import { __read, __spreadArray } from "tslib";
/**
 * Foreign key from the database stored in this class.
 */
var TableForeignKey = /** @class */ (function () {
    // -------------------------------------------------------------------------
    // Constructor
    // -------------------------------------------------------------------------
    function TableForeignKey(options) {
        /**
         * Column names which included by this foreign key.
         */
        this.columnNames = [];
        /**
         * Column names which included by this foreign key.
         */
        this.referencedColumnNames = [];
        this.name = options.name;
        this.columnNames = options.columnNames;
        this.referencedColumnNames = options.referencedColumnNames;
        this.referencedDatabase = options.referencedDatabase;
        this.referencedSchema = options.referencedSchema;
        this.referencedTableName = options.referencedTableName;
        this.onDelete = options.onDelete;
        this.onUpdate = options.onUpdate;
        this.deferrable = options.deferrable;
    }
    // -------------------------------------------------------------------------
    // Public Methods
    // -------------------------------------------------------------------------
    /**
     * Creates a new copy of this foreign key with exactly same properties.
     */
    TableForeignKey.prototype.clone = function () {
        return new TableForeignKey({
            name: this.name,
            columnNames: __spreadArray([], __read(this.columnNames), false),
            referencedColumnNames: __spreadArray([], __read(this.referencedColumnNames), false),
            referencedDatabase: this.referencedDatabase,
            referencedSchema: this.referencedSchema,
            referencedTableName: this.referencedTableName,
            onDelete: this.onDelete,
            onUpdate: this.onUpdate,
            deferrable: this.deferrable,
        });
    };
    // -------------------------------------------------------------------------
    // Static Methods
    // -------------------------------------------------------------------------
    /**
     * Creates a new table foreign key from the given foreign key metadata.
     */
    TableForeignKey.create = function (metadata, driver) {
        return new TableForeignKey({
            name: metadata.name,
            columnNames: metadata.columnNames,
            referencedColumnNames: metadata.referencedColumnNames,
            referencedDatabase: metadata.referencedEntityMetadata.database,
            referencedSchema: metadata.referencedEntityMetadata.schema,
            referencedTableName: metadata.referencedTablePath,
            onDelete: metadata.onDelete,
            onUpdate: metadata.onUpdate,
            deferrable: metadata.deferrable,
        });
    };
    return TableForeignKey;
}());
export { TableForeignKey };

//# sourceMappingURL=TableForeignKey.js.map
