//Written in the D programming language
/**
 * License: $(HTTP boost.org/LICENSE_1_0.txt, Boost License 1.0).
 *
 * Authors: Dmitry Olshansky
 *
 */
// !!! DO NOT EDIT !!!
// !!! Did you even read the comment? !!!
// This module is automatically generated from Unicode Character Database files
// https://github.com/dlang/phobos/blob/master/tools/unicode_table_generator.d
//dfmt off
module std.internal.unicode_tables;

@safe pure nothrow @nogc package(std):


struct SimpleCaseEntry
{
    uint ch;
    ubyte n, bucket;// n - number in bucket

pure nothrow @nogc:

    @property ubyte size() const
    {
        return bucket & 0x3F;
    }
    @property auto isLower() const
    {
        return bucket & 0x40;
    }
    @property auto isUpper() const
    {
        return bucket & 0x80;
    }
}

struct FullCaseEntry
{
    dchar[3] seq;
    ubyte n, size;// n number in batch, size - size of batch
    ubyte entry_len;

    @property auto value() const @trusted pure nothrow @nogc return
    {
        return seq[0 .. entry_len];
    }
}

struct CompEntry
{
    dchar rhs, composed;
}

struct UnicodeProperty
{
    string name;
    ubyte[] compressed;
}

struct TrieEntry(T...)
{
    size_t[] offsets;
    size_t[] sizes;
    size_t[] data;
}

@property immutable(SimpleCaseEntry[]) simpleCaseTable()
{
alias SCE = SimpleCaseEntry;
static immutable SCE[] t = [
SCE(0x1e90b, 0, 0x82),
SCE(0x1e92d, 1, 0x42),SCE(0x1e911, 0, 0x82),SCE(0x1e933, 1, 0x42),SCE(0x0496, 0, 0x82),
SCE(0x0497, 1, 0x42),SCE(0xa722, 0, 0x82),SCE(0xa723, 1, 0x42),SCE(0x1f79, 0, 0x42),
SCE(0x1ff9, 1, 0x82),SCE(0x1f44, 0, 0x42),SCE(0x1f4c, 1, 0x82),SCE(0x015a, 0, 0x82),
SCE(0x015b, 1, 0x42),SCE(0x10fd, 0, 0x42),SCE(0x1cbd, 1, 0x82),SCE(0x16e4c, 0, 0x82),
SCE(0x16e6c, 1, 0x42),SCE(0x1e38, 0, 0x82),SCE(0x1e39, 1, 0x42),SCE(0x1e921, 0, 0x82),
SCE(0x1e943, 1, 0x42),SCE(0x1f23, 0, 0x42),SCE(0x1f2b, 1, 0x82),SCE(0x01a0, 0, 0x82),
SCE(0x01a1, 1, 0x42),SCE(0x03a3, 0, 0x83),SCE(0x03c2, 1, 0x43),SCE(0x03c3, 2, 0x43),
SCE(0x04dc, 0, 0x82),SCE(0x04dd, 1, 0x42),SCE(0x2ca6, 0, 0x82),SCE(0x2ca7, 1, 0x42),
SCE(0x017b, 0, 0x82),SCE(0x017c, 1, 0x42),SCE(0x1e906, 0, 0x82),SCE(0x1e928, 1, 0x42),
SCE(0x10dc, 0, 0x42),SCE(0x1c9c, 1, 0x82),SCE(0x104cd, 0, 0x82),SCE(0x104f5, 1, 0x42),
SCE(0x1f65, 0, 0x42),SCE(0x1f6d, 1, 0x82),SCE(0x051e, 0, 0x82),SCE(0x051f, 1, 0x42),
SCE(0x10d8, 0, 0x42),SCE(0x1c98, 1, 0x82),SCE(0x2c1a, 0, 0x82),SCE(0x2c4a, 1, 0x42),
SCE(0x027d, 0, 0x42),SCE(0x2c64, 1, 0x82),SCE(0xa69a, 0, 0x82),SCE(0xa69b, 1, 0x42),
SCE(0x1f02, 0, 0x42),SCE(0x1f0a, 1, 0x82),SCE(0x0522, 0, 0x82),SCE(0x0523, 1, 0x42),
SCE(0x2c60, 0, 0x82),SCE(0x2c61, 1, 0x42),SCE(0x2c1e, 0, 0x82),SCE(0x2c4e, 1, 0x42),
SCE(0xa650, 0, 0x82),SCE(0xa651, 1, 0x42),SCE(0xa65c, 0, 0x82),SCE(0xa65d, 1, 0x42),
SCE(0x13c9, 0, 0x82),SCE(0xab99, 1, 0x42),SCE(0x10414, 0, 0x82),SCE(0x1043c, 1, 0x42),
SCE(0x13cd, 0, 0x82),SCE(0xab9d, 1, 0x42),SCE(0x00ce, 0, 0x82),SCE(0x00ee, 1, 0x42),
SCE(0x1e7e, 0, 0x82),SCE(0x1e7f, 1, 0x42),SCE(0x13f0, 0, 0x82),SCE(0x13f8, 1, 0x42),
SCE(0x1ec4, 0, 0x82),SCE(0x1ec5, 1, 0x42),SCE(0xa78b, 0, 0x82),SCE(0xa78c, 1, 0x42),
SCE(0x0114, 0, 0x82),SCE(0x0115, 1, 0x42),SCE(0x042f, 0, 0x82),SCE(0x044f, 1, 0x42),
SCE(0x1e902, 0, 0x82),SCE(0x1e924, 1, 0x42),SCE(0x04d8, 0, 0x82),SCE(0x04d9, 1, 0x42),
SCE(0x2caa, 0, 0x82),SCE(0x2cab, 1, 0x42),SCE(0x0110, 0, 0x82),SCE(0x0111, 1, 0x42),
SCE(0x0492, 0, 0x82),SCE(0x0493, 1, 0x42),SCE(0x1e34, 0, 0x82),SCE(0x1e35, 1, 0x42),
SCE(0x13f4, 0, 0x82),SCE(0x13fc, 1, 0x42),SCE(0x0224, 0, 0x82),SCE(0x0225, 1, 0x42),
SCE(0x2ca2, 0, 0x82),SCE(0x2ca3, 1, 0x42),SCE(0xa72e, 0, 0x82),SCE(0xa72f, 1, 0x42),
SCE(0x16e48, 0, 0x82),SCE(0x16e68, 1, 0x42),SCE(0x004a, 0, 0x82),SCE(0x006a, 1, 0x42),
SCE(0x13a6, 0, 0x82),SCE(0xab76, 1, 0x42),SCE(0x015e, 0, 0x82),SCE(0x015f, 1, 0x42),
SCE(0x01c4, 0, 0x83),SCE(0x01c5, 1, 0x3),SCE(0x01c6, 2, 0x43),SCE(0x1f40, 0, 0x42),
SCE(0x1f48, 1, 0x82),SCE(0xa658, 0, 0x82),SCE(0xa659, 1, 0x42),SCE(0x022c, 0, 0x82),
SCE(0x022d, 1, 0x42),SCE(0x10c9f, 0, 0x82),SCE(0x10cdf, 1, 0x42),SCE(0x1fa7, 0, 0x42),
SCE(0x1faf, 1, 0x2),SCE(0x13ae, 0, 0x82),SCE(0xab7e, 1, 0x42),SCE(0x0042, 0, 0x82),
SCE(0x0062, 1, 0x42),SCE(0x13d5, 0, 0x82),SCE(0xaba5, 1, 0x42),SCE(0x16e40, 0, 0x82),
SCE(0x16e60, 1, 0x42),SCE(0x00d2, 0, 0x82),SCE(0x00f2, 1, 0x42),SCE(0x1e82, 0, 0x82),
SCE(0x1e83, 1, 0x42),SCE(0x10c97, 0, 0x82),SCE(0x10cd7, 1, 0x42),SCE(0x10e0, 0, 0x42),
SCE(0x1ca0, 1, 0x82),SCE(0x013d, 0, 0x82),SCE(0x013e, 1, 0x42),SCE(0x0406, 0, 0x82),
SCE(0x0456, 1, 0x42),SCE(0x029d, 0, 0x42),SCE(0xa7b2, 1, 0x82),SCE(0x0139, 0, 0x82),
SCE(0x013a, 1, 0x42),SCE(0x0198, 0, 0x82),SCE(0x0199, 1, 0x42),SCE(0x1ebc, 0, 0x82),
SCE(0x1ebd, 1, 0x42),SCE(0x03ab, 0, 0x82),SCE(0x03cb, 1, 0x42),SCE(0x040e, 0, 0x82),
SCE(0x045e, 1, 0x42),SCE(0xa7b6, 0, 0x82),SCE(0xa7b7, 1, 0x42),SCE(0x040a, 0, 0x82),
SCE(0x045a, 1, 0x42),SCE(0x1ec0, 0, 0x82),SCE(0x1ec1, 1, 0x42),SCE(0x10572, 0, 0x82),
SCE(0x10599, 1, 0x42),SCE(0x24b9, 0, 0x82),SCE(0x24d3, 1, 0x42),SCE(0x2c16, 0, 0x82),
SCE(0x2c46, 1, 0x42),SCE(0x019c, 0, 0x82),SCE(0x026f, 1, 0x42),SCE(0x03a7, 0, 0x82),
SCE(0x03c7, 1, 0x42),SCE(0xa692, 0, 0x82),SCE(0xa693, 1, 0x42),SCE(0x00c5, 0, 0x83),
SCE(0x00e5, 1, 0x43),SCE(0x212b, 2, 0x83),SCE(0x0526, 0, 0x82),SCE(0x0527, 1, 0x42),
SCE(0x0266, 0, 0x42),SCE(0xa7aa, 1, 0x82),SCE(0x1057a, 0, 0x82),SCE(0x105a1, 1, 0x42),
SCE(0x1057e, 0, 0x82),SCE(0x105a5, 1, 0x42),SCE(0x1fd0, 0, 0x42),SCE(0x1fd8, 1, 0x82),
SCE(0x0046, 0, 0x82),SCE(0x0066, 1, 0x42),SCE(0x1e90a, 0, 0x82),SCE(0x1e92c, 1, 0x42),
SCE(0x0228, 0, 0x82),SCE(0x0229, 1, 0x42),SCE(0x13a2, 0, 0x82),SCE(0xab72, 1, 0x42),
SCE(0xa726, 0, 0x82),SCE(0xa727, 1, 0x42),SCE(0x10c93, 0, 0x82),SCE(0x10cd3, 1, 0x42),
SCE(0x049a, 0, 0x82),SCE(0x049b, 1, 0x42),SCE(0x00d6, 0, 0x82),SCE(0x00f6, 1, 0x42),
SCE(0x010c, 0, 0x82),SCE(0x010d, 1, 0x42),SCE(0x118a8, 0, 0x82),SCE(0x118c8, 1, 0x42),
SCE(0x0162, 0, 0x82),SCE(0x0163, 1, 0x42),SCE(0x019e, 0, 0x42),SCE(0x0220, 1, 0x82),
SCE(0x2c9e, 0, 0x82),SCE(0x2c9f, 1, 0x42),SCE(0x0392, 0, 0x83),SCE(0x03b2, 1, 0x43),
SCE(0x03d0, 2, 0x43),SCE(0x1e30, 0, 0x82),SCE(0x1e31, 1, 0x42),SCE(0x1fa3, 0, 0x42),
SCE(0x1fab, 1, 0x2),SCE(0x216d, 0, 0x82),SCE(0x217d, 1, 0x42),SCE(0x004e, 0, 0x82),
SCE(0x006e, 1, 0x42),SCE(0x00b5, 0, 0x43),SCE(0x039c, 1, 0x83),SCE(0x03bc, 2, 0x43),
SCE(0x048e, 0, 0x82),SCE(0x048f, 1, 0x42),SCE(0xa72a, 0, 0x82),SCE(0xa72b, 1, 0x42),
SCE(0x10410, 0, 0x82),SCE(0x10438, 1, 0x42),SCE(0x038a, 0, 0x82),SCE(0x03af, 1, 0x42),
SCE(0x1efe, 0, 0x82),SCE(0x1eff, 1, 0x42),SCE(0x118ac, 0, 0x82),SCE(0x118cc, 1, 0x42),
SCE(0x01ea, 0, 0x82),SCE(0x01eb, 1, 0x42),SCE(0x1f06, 0, 0x42),SCE(0x1f0e, 1, 0x82),
SCE(0x1fc3, 0, 0x42),SCE(0x1fcc, 1, 0x2),SCE(0x10b4, 0, 0x82),SCE(0x2d14, 1, 0x42),
SCE(0x026a, 0, 0x42),SCE(0xa7ae, 1, 0x82),SCE(0x0412, 0, 0x83),SCE(0x0432, 1, 0x43),
SCE(0x1c80, 2, 0x43),SCE(0xa760, 0, 0x82),SCE(0xa761, 1, 0x42),SCE(0x10c9b, 0, 0x82),
SCE(0x10cdb, 1, 0x42),SCE(0x24c8, 0, 0x82),SCE(0x24e2, 1, 0x42),SCE(0x01a4, 0, 0x82),
SCE(0x01a5, 1, 0x42),SCE(0x039f, 0, 0x82),SCE(0x03bf, 1, 0x42),SCE(0x10c4, 0, 0x82),
SCE(0x2d24, 1, 0x42),SCE(0x04a2, 0, 0x82),SCE(0x04a3, 1, 0x42),SCE(0x2c03, 0, 0x82),
SCE(0x2c33, 1, 0x42),SCE(0x2ce0, 0, 0x82),SCE(0x2ce1, 1, 0x42),SCE(0x10576, 0, 0x82),
SCE(0x1059d, 1, 0x42),SCE(0x04e0, 0, 0x82),SCE(0x04e1, 1, 0x42),SCE(0x2c2a, 0, 0x82),
SCE(0x2c5a, 1, 0x42),SCE(0x1ed0, 0, 0x82),SCE(0x1ed1, 1, 0x42),SCE(0x00c2, 0, 0x82),
SCE(0x00e2, 1, 0x42),SCE(0x04e8, 0, 0x82),SCE(0x04e9, 1, 0x42),SCE(0xa7a6, 0, 0x82),
SCE(0xa7a7, 1, 0x42),SCE(0x10f9, 0, 0x42),SCE(0x1cb9, 1, 0x82),SCE(0x0145, 0, 0x82),
SCE(0x0146, 1, 0x42),SCE(0x037c, 0, 0x42),SCE(0x03fe, 1, 0x82),SCE(0x1ec8, 0, 0x82),
SCE(0x1ec9, 1, 0x42),SCE(0x041a, 0, 0x82),SCE(0x043a, 1, 0x42),SCE(0x00ca, 0, 0x82),
SCE(0x00ea, 1, 0x42),SCE(0x1f86, 0, 0x42),SCE(0x1f8e, 1, 0x2),SCE(0x0421, 0, 0x83),
SCE(0x0441, 1, 0x43),SCE(0x1c83, 2, 0x43),SCE(0x10404, 0, 0x82),SCE(0x1042c, 1, 0x42),
SCE(0x10583, 0, 0x82),SCE(0x105aa, 1, 0x42),SCE(0x053f, 0, 0x82),SCE(0x056f, 1, 0x42),
SCE(0x0547, 0, 0x82),SCE(0x0577, 1, 0x42),SCE(0x13b6, 0, 0x82),SCE(0xab86, 1, 0x42),
SCE(0x13ec, 0, 0x82),SCE(0xabbc, 1, 0x42),SCE(0xff2c, 0, 0x82),SCE(0xff4c, 1, 0x42),
SCE(0xa7ba, 0, 0x82),SCE(0xa7bb, 1, 0x42),SCE(0xa648, 0, 0x82),SCE(0xa649, 1, 0x42),
SCE(0x13c5, 0, 0x82),SCE(0xab95, 1, 0x42),SCE(0xff24, 0, 0x82),SCE(0xff44, 1, 0x42),
SCE(0x1040f, 0, 0x82),SCE(0x10437, 1, 0x42),SCE(0x1041c, 0, 0x82),SCE(0x10444, 1, 0x42),
SCE(0x10c83, 0, 0x82),SCE(0x10cc3, 1, 0x42),SCE(0x0241, 0, 0x82),SCE(0x0242, 1, 0x42),
SCE(0x1e76, 0, 0x82),SCE(0x1e77, 1, 0x42),SCE(0x10bc, 0, 0x82),SCE(0x2d1c, 1, 0x42),
SCE(0x2c22, 0, 0x82),SCE(0x2c52, 1, 0x42),SCE(0x10d0, 0, 0x42),SCE(0x1c90, 1, 0x82),
SCE(0xa768, 0, 0x82),SCE(0xa769, 1, 0x42),SCE(0xa732, 0, 0x82),SCE(0xa733, 1, 0x42),
SCE(0x011c, 0, 0x82),SCE(0x011d, 1, 0x42),SCE(0x0427, 0, 0x82),SCE(0x0447, 1, 0x42),
SCE(0x1e40, 0, 0x82),SCE(0x1e41, 1, 0x42),SCE(0x118b1, 0, 0x82),SCE(0x118d1, 1, 0x42),
SCE(0x0152, 0, 0x82),SCE(0x0153, 1, 0x42),SCE(0x03a1, 0, 0x83),SCE(0x03c1, 1, 0x43),
SCE(0x03f1, 2, 0x43),SCE(0x0397, 0, 0x82),SCE(0x03b7, 1, 0x42),SCE(0x01ac, 0, 0x82),
SCE(0x01ad, 1, 0x42),SCE(0x01e2, 0, 0x82),SCE(0x01e3, 1, 0x42),SCE(0x0218, 0, 0x82),
SCE(0x0219, 1, 0x42),SCE(0x1e91a, 0, 0x82),SCE(0x1e93c, 1, 0x42),SCE(0x0516, 0, 0x82),
SCE(0x0517, 1, 0x42),SCE(0x1f27, 0, 0x42),SCE(0x1f2f, 1, 0x82),SCE(0xa7c9, 0, 0x82),
SCE(0xa7ca, 1, 0x42),SCE(0x1fe0, 0, 0x42),SCE(0x1fe8, 1, 0x82),SCE(0x2165, 0, 0x82),
SCE(0x2175, 1, 0x42),SCE(0xa66c, 0, 0x82),SCE(0xa66d, 1, 0x42),SCE(0x0393, 0, 0x82),
SCE(0x03b3, 1, 0x42),SCE(0x0532, 0, 0x82),SCE(0x0562, 1, 0x42),SCE(0x0056, 0, 0x82),
SCE(0x0076, 1, 0x42),SCE(0x1f33, 0, 0x42),SCE(0x1f3b, 1, 0x82),SCE(0x0554, 0, 0x82),
SCE(0x0584, 1, 0x42),SCE(0x1c88, 0, 0x43),SCE(0xa64a, 1, 0x83),SCE(0xa64b, 2, 0x43),
SCE(0xa68e, 0, 0x82),SCE(0xa68f, 1, 0x42),SCE(0x03d8, 0, 0x82),SCE(0x03d9, 1, 0x42),
SCE(0x24c5, 0, 0x82),SCE(0x24df, 1, 0x42),SCE(0x2cb2, 0, 0x82),SCE(0x2cb3, 1, 0x42),
SCE(0x10c82, 0, 0x82),SCE(0x10cc2, 1, 0x42),SCE(0x0057, 0, 0x82),SCE(0x0077, 1, 0x42),
SCE(0x16e53, 0, 0x82),SCE(0x16e73, 1, 0x42),SCE(0xff37, 0, 0x82),SCE(0xff57, 1, 0x42),
SCE(0x1ef6, 0, 0x82),SCE(0x1ef7, 1, 0x42),SCE(0x1e912, 0, 0x82),SCE(0x1e934, 1, 0x42),
SCE(0x1f12, 0, 0x42),SCE(0x1f1a, 1, 0x82),SCE(0x04a6, 0, 0x82),SCE(0x04a7, 1, 0x42),
SCE(0x016a, 0, 0x82),SCE(0x016b, 1, 0x42),SCE(0x1f34, 0, 0x42),SCE(0x1f3c, 1, 0x82),
SCE(0x2cdc, 0, 0x82),SCE(0x2cdd, 1, 0x42),SCE(0x01b1, 0, 0x82),SCE(0x028a, 1, 0x42),
SCE(0x118a4, 0, 0x82),SCE(0x118c4, 1, 0x42),SCE(0x1e28, 0, 0x82),SCE(0x1e29, 1, 0x42),
SCE(0x01bf, 0, 0x42),SCE(0x01f7, 1, 0x82),SCE(0x018b, 0, 0x82),SCE(0x018c, 1, 0x42),
SCE(0x10a7, 0, 0x82),SCE(0x2d07, 1, 0x42),SCE(0x0128, 0, 0x82),SCE(0x0129, 1, 0x42),
SCE(0x1e6a, 0, 0x82),SCE(0x1e6b, 1, 0x42),SCE(0x10ab, 0, 0x82),SCE(0x2d0b, 1, 0x42),
SCE(0x041f, 0, 0x82),SCE(0x043f, 1, 0x42),SCE(0x2c2e, 0, 0x82),SCE(0x2c5e, 1, 0x42),
SCE(0x10caf, 0, 0x82),SCE(0x10cef, 1, 0x42),SCE(0x104c5, 0, 0x82),SCE(0x104ed, 1, 0x42),
SCE(0x118a5, 0, 0x82),SCE(0x118c5, 1, 0x42),SCE(0x1fe1, 0, 0x42),SCE(0x1fe9, 1, 0x82),
SCE(0x03a6, 0, 0x83),SCE(0x03c6, 1, 0x43),SCE(0x03d5, 2, 0x43),SCE(0x2c0a, 0, 0x82),
SCE(0x2c3a, 1, 0x42),SCE(0x050e, 0, 0x82),SCE(0x050f, 1, 0x42),SCE(0x0104, 0, 0x82),
SCE(0x0105, 1, 0x42),SCE(0x0372, 0, 0x82),SCE(0x0373, 1, 0x42),SCE(0x1e8e, 0, 0x82),
SCE(0x1e8f, 1, 0x42),SCE(0x0396, 0, 0x82),SCE(0x03b6, 1, 0x42),SCE(0x1efa, 0, 0x82),
SCE(0x1efb, 1, 0x42),SCE(0x03f2, 0, 0x42),SCE(0x03f9, 1, 0x82),SCE(0xa640, 0, 0x82),
SCE(0xa641, 1, 0x42),SCE(0x10ec, 0, 0x42),SCE(0x1cac, 1, 0x82),SCE(0x118a1, 0, 0x82),
SCE(0x118c1, 1, 0x42),SCE(0x0166, 0, 0x82),SCE(0x0167, 1, 0x42),SCE(0x1f37, 0, 0x42),
SCE(0x1f3f, 1, 0x82),SCE(0x10c86, 0, 0x82),SCE(0x10cc6, 1, 0x42),SCE(0x13dd, 0, 0x82),
SCE(0xabad, 1, 0x42),SCE(0x1f51, 0, 0x42),SCE(0x1f59, 1, 0x82),SCE(0x2c9a, 0, 0x82),
SCE(0x2c9b, 1, 0x42),SCE(0x01fa, 0, 0x82),SCE(0x01fb, 1, 0x42),SCE(0x2169, 0, 0x82),
SCE(0x2179, 1, 0x42),SCE(0x16e57, 0, 0x82),SCE(0x16e77, 1, 0x42),SCE(0x10a4, 0, 0x82),
SCE(0x2d04, 1, 0x42),SCE(0x0053, 0, 0x83),SCE(0x0073, 1, 0x43),SCE(0x017f, 2, 0x43),
SCE(0x0376, 0, 0x82),SCE(0x0377, 1, 0x42),SCE(0x13b1, 0, 0x82),SCE(0xab81, 1, 0x42),
SCE(0x0468, 0, 0x82),SCE(0x0469, 1, 0x42),SCE(0x13e4, 0, 0x82),SCE(0xabb4, 1, 0x42),
SCE(0x1f96, 0, 0x42),SCE(0x1f9e, 1, 0x2),SCE(0x0108, 0, 0x82),SCE(0x0109, 1, 0x42),
SCE(0x10ca0, 0, 0x82),SCE(0x10ce0, 1, 0x42),SCE(0x1e66, 0, 0x82),SCE(0x1e67, 1, 0x42),
SCE(0x1e8a, 0, 0x82),SCE(0x1e8b, 1, 0x42),SCE(0x1e4c, 0, 0x82),SCE(0x1e4d, 1, 0x42),
SCE(0x1f75, 0, 0x42),SCE(0x1fcb, 1, 0x82),SCE(0x2c0e, 0, 0x82),SCE(0x2c3e, 1, 0x42),
SCE(0x1e50, 0, 0x82),SCE(0x1e51, 1, 0x42),SCE(0x24c0, 0, 0x82),SCE(0x24da, 1, 0x42),
SCE(0xa750, 0, 0x82),SCE(0xa751, 1, 0x42),SCE(0x00da, 0, 0x82),SCE(0x00fa, 1, 0x42),
SCE(0x10e9, 0, 0x42),SCE(0x1ca9, 1, 0x82),SCE(0x2cd8, 0, 0x82),SCE(0x2cd9, 1, 0x42),
SCE(0x1eb8, 0, 0x82),SCE(0x1eb9, 1, 0x42),SCE(0x012c, 0, 0x82),SCE(0x012d, 1, 0x42),
SCE(0x0252, 0, 0x42),SCE(0x2c70, 1, 0x82),SCE(0x04c3, 0, 0x82),SCE(0x04c4, 1, 0x42),
SCE(0x24c4, 0, 0x82),SCE(0x24de, 1, 0x42),SCE(0x104b5, 0, 0x82),SCE(0x104dd, 1, 0x42),
SCE(0x2c0f, 0, 0x82),SCE(0x2c3f, 1, 0x42),SCE(0x0533, 0, 0x82),SCE(0x0563, 1, 0x42),
SCE(0x0195, 0, 0x42),SCE(0x01f6, 1, 0x82),SCE(0x1f13, 0, 0x42),SCE(0x1f1b, 1, 0x82),
SCE(0x104b8, 0, 0x82),SCE(0x104e0, 1, 0x42),SCE(0x0553, 0, 0x82),SCE(0x0583, 1, 0x42),
SCE(0x10425, 0, 0x82),SCE(0x1044d, 1, 0x42),SCE(0x13d1, 0, 0x82),SCE(0xaba1, 1, 0x42),
SCE(0x04f4, 0, 0x82),SCE(0x04f5, 1, 0x42),SCE(0x04c7, 0, 0x82),SCE(0x04c8, 1, 0x42),
SCE(0x10cac, 0, 0x82),SCE(0x10cec, 1, 0x42),SCE(0x04d0, 0, 0x82),SCE(0x04d1, 1, 0x42),
SCE(0xa75c, 0, 0x82),SCE(0xa75d, 1, 0x42),SCE(0x1e2c, 0, 0x82),SCE(0x1e2d, 1, 0x42),
SCE(0x10a8, 0, 0x82),SCE(0x2d08, 1, 0x42),SCE(0x0464, 0, 0x82),SCE(0x0465, 1, 0x42),
SCE(0x0426, 0, 0x82),SCE(0x0446, 1, 0x42),SCE(0x04e4, 0, 0x82),SCE(0x04e5, 1, 0x42),
SCE(0x10ed, 0, 0x42),SCE(0x1cad, 1, 0x82),SCE(0xa792, 0, 0x82),SCE(0xa793, 1, 0x42),
SCE(0x1edc, 0, 0x82),SCE(0x1edd, 1, 0x42),SCE(0x104bc, 0, 0x82),SCE(0x104e4, 1, 0x42),
SCE(0x10577, 0, 0x82),SCE(0x1059e, 1, 0x42),SCE(0x1ea8, 0, 0x82),SCE(0x1ea9, 1, 0x42),
SCE(0x01b8, 0, 0x82),SCE(0x01b9, 1, 0x42),SCE(0x00c6, 0, 0x82),SCE(0x00e6, 1, 0x42),
SCE(0xff30, 0, 0x82),SCE(0xff50, 1, 0x42),SCE(0x16e44, 0, 0x82),SCE(0x16e64, 1, 0x42),
SCE(0x1041b, 0, 0x82),SCE(0x10443, 1, 0x42),SCE(0x1e0e, 0, 0x82),SCE(0x1e0f, 1, 0x42),
SCE(0x04d4, 0, 0x82),SCE(0x04d5, 1, 0x42),SCE(0x2cae, 0, 0x82),SCE(0x2caf, 1, 0x42),
SCE(0x2c6b, 0, 0x82),SCE(0x2c6c, 1, 0x42),SCE(0xff23, 0, 0x82),SCE(0xff43, 1, 0x42),
SCE(0x0184, 0, 0x82),SCE(0x0185, 1, 0x42),SCE(0x10573, 0, 0x82),SCE(0x1059a, 1, 0x42),
SCE(0x0398, 0, 0x84),SCE(0x03b8, 1, 0x44),SCE(0x03d1, 2, 0x44),SCE(0x03f4, 3, 0x84),
SCE(0x13d4, 0, 0x82),SCE(0xaba4, 1, 0x42),SCE(0x1e919, 0, 0x82),SCE(0x1e93b, 1, 0x42),
SCE(0x0187, 0, 0x82),SCE(0x0188, 1, 0x42),SCE(0x2c13, 0, 0x82),SCE(0x2c43, 1, 0x42),
SCE(0xa7a2, 0, 0x82),SCE(0xa7a3, 1, 0x42),SCE(0x0194, 0, 0x82),SCE(0x0263, 1, 0x42),
SCE(0x0416, 0, 0x82),SCE(0x0436, 1, 0x42),SCE(0x2cbe, 0, 0x82),SCE(0x2cbf, 1, 0x42),
SCE(0x1fa6, 0, 0x42),SCE(0x1fae, 1, 0x2),SCE(0x104c6, 0, 0x82),SCE(0x104ee, 1, 0x42),
SCE(0x1f82, 0, 0x42),SCE(0x1f8a, 1, 0x2),SCE(0x104c9, 0, 0x82),SCE(0x104f1, 1, 0x42),
SCE(0x13e0, 0, 0x82),SCE(0xabb0, 1, 0x42),SCE(0x0240, 0, 0x42),SCE(0x2c7f, 1, 0x82),
SCE(0xa7be, 0, 0x82),SCE(0xa7bf, 1, 0x42),SCE(0x1f92, 0, 0x42),SCE(0x1f9a, 1, 0x2),
SCE(0x0402, 0, 0x82),SCE(0x0452, 1, 0x42),SCE(0x0536, 0, 0x82),SCE(0x0566, 1, 0x42),
SCE(0x0550, 0, 0x82),SCE(0x0580, 1, 0x42),SCE(0xa682, 0, 0x82),SCE(0xa683, 1, 0x42),
SCE(0x0386, 0, 0x82),SCE(0x03ac, 1, 0x42),SCE(0x1fe5, 0, 0x42),SCE(0x1fec, 1, 0x82),
SCE(0x24c9, 0, 0x82),SCE(0x24e3, 1, 0x42),SCE(0x00d3, 0, 0x82),SCE(0x00f3, 1, 0x42),
SCE(0x10f0, 0, 0x42),SCE(0x1cb0, 1, 0x82),SCE(0x1e3c, 0, 0x82),SCE(0x1e3d, 1, 0x42),
SCE(0x2c80, 0, 0x82),SCE(0x2c81, 1, 0x42),SCE(0x1058a, 0, 0x82),SCE(0x105b1, 1, 0x42),
SCE(0x0156, 0, 0x82),SCE(0x0157, 1, 0x42),SCE(0x1e7a, 0, 0x82),SCE(0x1e7b, 1, 0x42),
SCE(0x13ed, 0, 0x82),SCE(0xabbd, 1, 0x42),SCE(0xa73e, 0, 0x82),SCE(0xa73f, 1, 0x42),
SCE(0x0118, 0, 0x82),SCE(0x0119, 1, 0x42),SCE(0x0214, 0, 0x82),SCE(0x0215, 1, 0x42),
SCE(0x1e60, 0, 0x83),SCE(0x1e61, 1, 0x43),SCE(0x1e9b, 2, 0x43),SCE(0x2c8a, 0, 0x82),
SCE(0x2c8b, 1, 0x42),SCE(0xa64c, 0, 0x82),SCE(0xa64d, 1, 0x42),SCE(0x0395, 0, 0x83),
SCE(0x03b5, 1, 0x43),SCE(0x03f5, 2, 0x43),SCE(0x01e6, 0, 0x82),SCE(0x01e7, 1, 0x42),
SCE(0x1f85, 0, 0x42),SCE(0x1f8d, 1, 0x2),SCE(0x0512, 0, 0x82),SCE(0x0513, 1, 0x42),
SCE(0x1f61, 0, 0x42),SCE(0x1f69, 1, 0x82),SCE(0xa668, 0, 0x82),SCE(0xa669, 1, 0x42),
SCE(0x10594, 0, 0x82),SCE(0x105bb, 1, 0x42),SCE(0x1e18, 0, 0x82),SCE(0x1e19, 1, 0x42),
SCE(0x13b2, 0, 0x82),SCE(0xab82, 1, 0x42),SCE(0x10415, 0, 0x82),SCE(0x1043d, 1, 0x42),
SCE(0x10418, 0, 0x82),SCE(0x10440, 1, 0x42),SCE(0x0245, 0, 0x82),SCE(0x028c, 1, 0x42),
SCE(0x1f72, 0, 0x42),SCE(0x1fc8, 1, 0x82),SCE(0x118b5, 0, 0x82),SCE(0x118d5, 1, 0x42),
SCE(0x10b8, 0, 0x82),SCE(0x2d18, 1, 0x42),SCE(0x04c0, 0, 0x82),SCE(0x04cf, 1, 0x42),
SCE(0x1040b, 0, 0x82),SCE(0x10433, 1, 0x42),SCE(0x0423, 0, 0x82),SCE(0x0443, 1, 0x42),
SCE(0x10c5, 0, 0x82),SCE(0x2d25, 1, 0x42),SCE(0x2c2d, 0, 0x82),SCE(0x2c5d, 1, 0x42),
SCE(0x1f30, 0, 0x42),SCE(0x1f38, 1, 0x82),SCE(0x13c1, 0, 0x82),SCE(0xab91, 1, 0x42),
SCE(0xa76c, 0, 0x82),SCE(0xa76d, 1, 0x42),SCE(0x104cc, 0, 0x82),SCE(0x104f4, 1, 0x42),
SCE(0x1f71, 0, 0x42),SCE(0x1fbb, 1, 0x82),SCE(0xff33, 0, 0x82),SCE(0xff53, 1, 0x42),
SCE(0x216a, 0, 0x82),SCE(0x217a, 1, 0x42),SCE(0x1ecc, 0, 0x82),SCE(0x1ecd, 1, 0x42),
SCE(0x03e8, 0, 0x82),SCE(0x03e9, 1, 0x42),SCE(0xa7d0, 0, 0x82),SCE(0xa7d1, 1, 0x42),
SCE(0x005a, 0, 0x82),SCE(0x007a, 1, 0x42),SCE(0x10cb0, 0, 0x82),SCE(0x10cf0, 1, 0x42),
SCE(0x01d9, 0, 0x82),SCE(0x01da, 1, 0x42),SCE(0x10587, 0, 0x82),SCE(0x105ae, 1, 0x42),
SCE(0x01b5, 0, 0x82),SCE(0x01b6, 1, 0x42),SCE(0x0543, 0, 0x82),SCE(0x0573, 1, 0x42),
SCE(0x1f22, 0, 0x42),SCE(0x1f2a, 1, 0x82),SCE(0x1ea0, 0, 0x82),SCE(0x1ea1, 1, 0x42),
SCE(0x10c8f, 0, 0x82),SCE(0x10ccf, 1, 0x42),SCE(0x16e54, 0, 0x82),SCE(0x16e74, 1, 0x42),
SCE(0x1d7d, 0, 0x42),SCE(0x2c63, 1, 0x82),SCE(0xa7d6, 0, 0x82),SCE(0xa7d7, 1, 0x42),
SCE(0xa74c, 0, 0x82),SCE(0xa74d, 1, 0x42),SCE(0x13ce, 0, 0x82),SCE(0xab9e, 1, 0x42),
SCE(0x00cf, 0, 0x82),SCE(0x00ef, 1, 0x42),SCE(0x10d9, 0, 0x42),SCE(0x1c99, 1, 0x82),
SCE(0x0045, 0, 0x82),SCE(0x0065, 1, 0x42),SCE(0x0136, 0, 0x82),SCE(0x0137, 1, 0x42),
SCE(0x040d, 0, 0x82),SCE(0x045d, 1, 0x42),SCE(0x16e43, 0, 0x82),SCE(0x16e63, 1, 0x42),
SCE(0x1f7c, 0, 0x42),SCE(0x1ffa, 1, 0x82),SCE(0x024a, 0, 0x82),SCE(0x024b, 1, 0x42),
SCE(0x04b8, 0, 0x82),SCE(0x04b9, 1, 0x42),SCE(0x2cca, 0, 0x82),SCE(0x2ccb, 1, 0x42),
SCE(0x2ced, 0, 0x82),SCE(0x2cee, 1, 0x42),SCE(0x019f, 0, 0x82),SCE(0x0275, 1, 0x42),
SCE(0x03a4, 0, 0x82),SCE(0x03c4, 1, 0x42),SCE(0xa74e, 0, 0x82),SCE(0xa74f, 1, 0x42),
SCE(0x104c0, 0, 0x82),SCE(0x104e8, 1, 0x42),SCE(0x1e16, 0, 0x82),SCE(0x1e17, 1, 0x42),
SCE(0x13af, 0, 0x82),SCE(0xab7f, 1, 0x42),SCE(0x0500, 0, 0x82),SCE(0x0501, 1, 0x42),
SCE(0x2c82, 0, 0x82),SCE(0x2c83, 1, 0x42),SCE(0x10bd, 0, 0x82),SCE(0x2d1d, 1, 0x42),
SCE(0x1e916, 0, 0x82),SCE(0x1e938, 1, 0x42),SCE(0x10ca3, 0, 0x82),SCE(0x10ce3, 1, 0x42),
SCE(0x10c94, 0, 0x82),SCE(0x10cd4, 1, 0x42),SCE(0x104c2, 0, 0x82),SCE(0x104ea, 1, 0x42),
SCE(0x03a6, 0, 0x83),SCE(0x03c6, 1, 0x43),SCE(0x03d5, 2, 0x43),SCE(0x16e4d, 0, 0x82),
SCE(0x16e6d, 1, 0x42),SCE(0x118b4, 0, 0x82),SCE(0x118d4, 1, 0x42),SCE(0x13e9, 0, 0x82),
SCE(0xabb9, 1, 0x42),SCE(0x1f41, 0, 0x42),SCE(0x1f49, 1, 0x82),SCE(0x0287, 0, 0x42),
SCE(0xa7b1, 1, 0x82),SCE(0x0542, 0, 0x82),SCE(0x0572, 1, 0x42),SCE(0x1e58, 0, 0x82),
SCE(0x1e59, 1, 0x42),SCE(0x1f43, 0, 0x42),SCE(0x1f4b, 1, 0x82),SCE(0x2ceb, 0, 0x82),
SCE(0x2cec, 1, 0x42),SCE(0x13eb, 0, 0x82),SCE(0xabbb, 1, 0x42),SCE(0x1fd1, 0, 0x42),
SCE(0x1fd9, 1, 0x82),SCE(0x1ee8, 0, 0x82),SCE(0x1ee9, 1, 0x42),SCE(0x13a3, 0, 0x82),
SCE(0xab73, 1, 0x42),SCE(0x03ee, 0, 0x82),SCE(0x03ef, 1, 0x42),SCE(0x118b8, 0, 0x82),
SCE(0x118d8, 1, 0x42),SCE(0x10c9e, 0, 0x82),SCE(0x10cde, 1, 0x42),SCE(0x1e920, 0, 0x82),
SCE(0x1e942, 1, 0x42),SCE(0x00ff, 0, 0x42),SCE(0x0178, 1, 0x82),SCE(0x10417, 0, 0x82),
SCE(0x1043f, 1, 0x42),SCE(0x118a9, 0, 0x82),SCE(0x118c9, 1, 0x42),SCE(0x1fb0, 0, 0x42),
SCE(0x1fb8, 1, 0x82),SCE(0x2c88, 0, 0x82),SCE(0x2c89, 1, 0x42),SCE(0x13a9, 0, 0x82),
SCE(0xab79, 1, 0x42),SCE(0x1e909, 0, 0x82),SCE(0x1e92b, 1, 0x42),SCE(0x13c2, 0, 0x82),
SCE(0xab92, 1, 0x42),SCE(0x24b6, 0, 0x82),SCE(0x24d0, 1, 0x42),SCE(0x1e5e, 0, 0x82),
SCE(0x1e5f, 1, 0x42),SCE(0x2c69, 0, 0x82),SCE(0x2c6a, 1, 0x42),SCE(0x1041f, 0, 0x82),
SCE(0x10447, 1, 0x42),SCE(0x037f, 0, 0x82),SCE(0x03f3, 1, 0x42),SCE(0x0540, 0, 0x82),
SCE(0x0570, 1, 0x42),SCE(0x004b, 0, 0x83),SCE(0x006b, 1, 0x43),SCE(0x212a, 2, 0x83),
SCE(0x04f8, 0, 0x82),SCE(0x04f9, 1, 0x42),SCE(0x13f3, 0, 0x82),SCE(0x13fb, 1, 0x42),
SCE(0x00c9, 0, 0x82),SCE(0x00e9, 1, 0x42),SCE(0x040f, 0, 0x82),SCE(0x045f, 1, 0x42),
SCE(0x10b5, 0, 0x82),SCE(0x2d15, 1, 0x42),SCE(0xa746, 0, 0x82),SCE(0xa747, 1, 0x42),
SCE(0x00cd, 0, 0x82),SCE(0x00ed, 1, 0x42),SCE(0x0476, 0, 0x82),SCE(0x0477, 1, 0x42),
SCE(0x039e, 0, 0x82),SCE(0x03be, 1, 0x42),SCE(0x1f20, 0, 0x42),SCE(0x1f28, 1, 0x82),
SCE(0x10fa, 0, 0x42),SCE(0x1cba, 1, 0x82),SCE(0x2c21, 0, 0x82),SCE(0x2c51, 1, 0x42),
SCE(0x1ea6, 0, 0x82),SCE(0x1ea7, 1, 0x42),SCE(0x1f83, 0, 0x42),SCE(0x1f8b, 1, 0x2),
SCE(0x053c, 0, 0x82),SCE(0x056c, 1, 0x42),SCE(0x1f01, 0, 0x42),SCE(0x1f09, 1, 0x82),
SCE(0x2cc2, 0, 0x82),SCE(0x2cc3, 1, 0x42),SCE(0x0208, 0, 0x82),SCE(0x0209, 1, 0x42),
SCE(0x13e3, 0, 0x82),SCE(0xabb3, 1, 0x42),SCE(0xa796, 0, 0x82),SCE(0xa797, 1, 0x42),
SCE(0x1f64, 0, 0x42),SCE(0x1f6c, 1, 0x82),SCE(0x10592, 0, 0x82),SCE(0x105b9, 1, 0x42),
SCE(0x04be, 0, 0x82),SCE(0x04bf, 1, 0x42),SCE(0x1f91, 0, 0x42),SCE(0x1f99, 1, 0x2),
SCE(0x03e6, 0, 0x82),SCE(0x03e7, 1, 0x42),SCE(0x1ee0, 0, 0x82),SCE(0x1ee1, 1, 0x42),
SCE(0x1ff3, 0, 0x42),SCE(0x1ffc, 1, 0x2),SCE(0x0413, 0, 0x82),SCE(0x0433, 1, 0x42),
SCE(0x042e, 0, 0x82),SCE(0x044e, 1, 0x42),SCE(0x104ca, 0, 0x82),SCE(0x104f2, 1, 0x42),
SCE(0x2c00, 0, 0x82),SCE(0x2c30, 1, 0x42),SCE(0x10db, 0, 0x42),SCE(0x1c9b, 1, 0x82),
SCE(0x10f6, 0, 0x42),SCE(0x1cb6, 1, 0x82),SCE(0x118be, 0, 0x82),SCE(0x118de, 1, 0x42),
SCE(0x01a7, 0, 0x82),SCE(0x01a8, 1, 0x42),SCE(0x10c3, 0, 0x82),SCE(0x2d23, 1, 0x42),
SCE(0x0415, 0, 0x82),SCE(0x0435, 1, 0x42),SCE(0x1e1e, 0, 0x82),SCE(0x1e1f, 1, 0x42),
SCE(0x0506, 0, 0x82),SCE(0x0507, 1, 0x42),SCE(0x1e64, 0, 0x82),SCE(0x1e65, 1, 0x42),
SCE(0x00c7, 0, 0x82),SCE(0x00e7, 1, 0x42),SCE(0x047c, 0, 0x82),SCE(0x047d, 1, 0x42),
SCE(0x1e52, 0, 0x82),SCE(0x1e53, 1, 0x42),SCE(0x10f4, 0, 0x42),SCE(0x1cb4, 1, 0x82),
SCE(0x10586, 0, 0x82),SCE(0x105ad, 1, 0x42),SCE(0x046a, 0, 0x82),SCE(0x046b, 1, 0x42),
SCE(0x2c27, 0, 0x82),SCE(0x2c57, 1, 0x42),SCE(0x10c89, 0, 0x82),SCE(0x10cc9, 1, 0x42),
SCE(0x10a2, 0, 0x82),SCE(0x2d02, 1, 0x42),SCE(0xff32, 0, 0x82),SCE(0xff52, 1, 0x42),
SCE(0x0398, 0, 0x84),SCE(0x03b8, 1, 0x44),SCE(0x03d1, 2, 0x44),SCE(0x03f4, 3, 0x84),
SCE(0x03a9, 0, 0x83),SCE(0x03c9, 1, 0x43),SCE(0x2126, 2, 0x83),SCE(0x1eda, 0, 0x82),
SCE(0x1edb, 1, 0x42),SCE(0x1e901, 0, 0x82),SCE(0x1e923, 1, 0x42),SCE(0xa79c, 0, 0x82),
SCE(0xa79d, 1, 0x42),SCE(0x10d3, 0, 0x42),SCE(0x1c93, 1, 0x82),SCE(0x24bc, 0, 0x82),
SCE(0x24d6, 1, 0x42),SCE(0xff2f, 0, 0x82),SCE(0xff4f, 1, 0x42),SCE(0x0250, 0, 0x42),
SCE(0x2c6f, 1, 0x82),SCE(0x2c29, 0, 0x82),SCE(0x2c59, 1, 0x42),SCE(0x04b2, 0, 0x82),
SCE(0x04b3, 1, 0x42),SCE(0x10419, 0, 0x82),SCE(0x10441, 1, 0x42),SCE(0x0210, 0, 0x82),
SCE(0x0211, 1, 0x42),SCE(0x2c15, 0, 0x82),SCE(0x2c45, 1, 0x42),SCE(0x16e47, 0, 0x82),
SCE(0x16e67, 1, 0x42),SCE(0xa754, 0, 0x82),SCE(0xa755, 1, 0x42),SCE(0x16e45, 0, 0x82),
SCE(0x16e65, 1, 0x42),SCE(0x01c7, 0, 0x83),SCE(0x01c8, 1, 0x3),SCE(0x01c9, 2, 0x43),
SCE(0x047e, 0, 0x82),SCE(0x047f, 1, 0x42),SCE(0x01fc, 0, 0x82),SCE(0x01fd, 1, 0x42),
SCE(0x020e, 0, 0x82),SCE(0x020f, 1, 0x42),SCE(0x0244, 0, 0x82),SCE(0x0289, 1, 0x42),
SCE(0x1f77, 0, 0x42),SCE(0x1fdb, 1, 0x82),SCE(0x2cd6, 0, 0x82),SCE(0x2cd7, 1, 0x42),
SCE(0x10589, 0, 0x82),SCE(0x105b0, 1, 0x42),SCE(0x0422, 0, 0x84),SCE(0x0442, 1, 0x44),
SCE(0x1c84, 2, 0x44),SCE(0x1c85, 3, 0x44),SCE(0x10e7, 0, 0x42),SCE(0x1ca7, 1, 0x82),
SCE(0x04fa, 0, 0x82),SCE(0x04fb, 1, 0x42),SCE(0x10d5, 0, 0x42),SCE(0x1c95, 1, 0x82),
SCE(0x1eac, 0, 0x82),SCE(0x1ead, 1, 0x42),SCE(0x10b7, 0, 0x82),SCE(0x2d17, 1, 0x42),
SCE(0x13a1, 0, 0x82),SCE(0xab71, 1, 0x42),SCE(0xa7c2, 0, 0x82),SCE(0xa7c3, 1, 0x42),
SCE(0x1e907, 0, 0x82),SCE(0x1e929, 1, 0x42),SCE(0x13f5, 0, 0x82),SCE(0x13fd, 1, 0x42),
SCE(0x1ee2, 0, 0x82),SCE(0x1ee3, 1, 0x42),SCE(0x1f62, 0, 0x42),SCE(0x1f6a, 1, 0x82),
SCE(0x1e92, 0, 0x82),SCE(0x1e93, 1, 0x42),SCE(0x01d5, 0, 0x82),SCE(0x01d6, 1, 0x42),
SCE(0x2c06, 0, 0x82),SCE(0x2c36, 1, 0x42),SCE(0x10c8b, 0, 0x82),SCE(0x10ccb, 1, 0x42),
SCE(0x1f70, 0, 0x42),SCE(0x1fba, 1, 0x82),SCE(0x03ec, 0, 0x82),SCE(0x03ed, 1, 0x42),
SCE(0x1e915, 0, 0x82),SCE(0x1e937, 1, 0x42),SCE(0x216e, 0, 0x82),SCE(0x217e, 1, 0x42),
SCE(0x13c0, 0, 0x82),SCE(0xab90, 1, 0x42),SCE(0x1ef4, 0, 0x82),SCE(0x1ef5, 1, 0x42),
SCE(0xff3a, 0, 0x82),SCE(0xff5a, 1, 0x42),SCE(0x118bc, 0, 0x82),SCE(0x118dc, 1, 0x42),
SCE(0x04aa, 0, 0x82),SCE(0x04ab, 1, 0x42),SCE(0x2163, 0, 0x82),SCE(0x2173, 1, 0x42),
SCE(0x1e1c, 0, 0x82),SCE(0x1e1d, 1, 0x42),SCE(0x13c8, 0, 0x82),SCE(0xab98, 1, 0x42),
SCE(0x118af, 0, 0x82),SCE(0x118cf, 1, 0x42),SCE(0x10c98, 0, 0x82),SCE(0x10cd8, 1, 0x42),
SCE(0x10571, 0, 0x82),SCE(0x10598, 1, 0x42),SCE(0x10ca7, 0, 0x82),SCE(0x10ce7, 1, 0x42),
SCE(0x0051, 0, 0x82),SCE(0x0071, 1, 0x42),SCE(0x04f2, 0, 0x82),SCE(0x04f3, 1, 0x42),
SCE(0x10caa, 0, 0x82),SCE(0x10cea, 1, 0x42),SCE(0x10af, 0, 0x82),SCE(0x2d0f, 1, 0x42),
SCE(0x2c8e, 0, 0x82),SCE(0x2c8f, 1, 0x42),SCE(0x2cc4, 0, 0x82),SCE(0x2cc5, 1, 0x42),
SCE(0x1e0a, 0, 0x82),SCE(0x1e0b, 1, 0x42),SCE(0x16e50, 0, 0x82),SCE(0x16e70, 1, 0x42),
SCE(0x1058e, 0, 0x82),SCE(0x105b5, 1, 0x42),SCE(0x10411, 0, 0x82),SCE(0x10439, 1, 0x42),
SCE(0x10423, 0, 0x82),SCE(0x1044b, 1, 0x42),SCE(0x053a, 0, 0x82),SCE(0x056a, 1, 0x42),
SCE(0x1e6c, 0, 0x82),SCE(0x1e6d, 1, 0x42),SCE(0x104be, 0, 0x82),SCE(0x104e6, 1, 0x42),
SCE(0x10424, 0, 0x82),SCE(0x1044c, 1, 0x42),SCE(0x10a9, 0, 0x82),SCE(0x2d09, 1, 0x42),
SCE(0x24c2, 0, 0x82),SCE(0x24dc, 1, 0x42),SCE(0x10c81, 0, 0x82),SCE(0x10cc1, 1, 0x42),
SCE(0x13bc, 0, 0x82),SCE(0xab8c, 1, 0x42),SCE(0x0462, 0, 0x83),SCE(0x0463, 1, 0x43),
SCE(0x1c87, 2, 0x43),SCE(0x118a6, 0, 0x82),SCE(0x118c6, 1, 0x42),SCE(0x1e4a, 0, 0x82),
SCE(0x1e4b, 1, 0x42),SCE(0x2162, 0, 0x82),SCE(0x2172, 1, 0x42),SCE(0x1ed4, 0, 0x82),
SCE(0x1ed5, 1, 0x42),SCE(0x10aa, 0, 0x82),SCE(0x2d0a, 1, 0x42),SCE(0x04ec, 0, 0x82),
SCE(0x04ed, 1, 0x42),SCE(0x2c0c, 0, 0x82),SCE(0x2c3c, 1, 0x42),SCE(0xa79a, 0, 0x82),
SCE(0xa79b, 1, 0x42),SCE(0x04cb, 0, 0x82),SCE(0x04cc, 1, 0x42),SCE(0x104bd, 0, 0x82),
SCE(0x104e5, 1, 0x42),SCE(0x0370, 0, 0x82),SCE(0x0371, 1, 0x42),SCE(0x1e914, 0, 0x82),
SCE(0x1e936, 1, 0x42),SCE(0x03da, 0, 0x82),SCE(0x03db, 1, 0x42),SCE(0x1f35, 0, 0x42),
SCE(0x1f3d, 1, 0x82),SCE(0x16e51, 0, 0x82),SCE(0x16e71, 1, 0x42),SCE(0x0392, 0, 0x83),
SCE(0x03b2, 1, 0x43),SCE(0x03d0, 2, 0x43),SCE(0x2c96, 0, 0x82),SCE(0x2c97, 1, 0x42),
SCE(0x0391, 0, 0x82),SCE(0x03b1, 1, 0x42),SCE(0x0534, 0, 0x82),SCE(0x0564, 1, 0x42),
SCE(0x041b, 0, 0x82),SCE(0x043b, 1, 0x42),SCE(0x13df, 0, 0x82),SCE(0xabaf, 1, 0x42),
SCE(0x2c2c, 0, 0x82),SCE(0x2c5c, 1, 0x42),SCE(0x0124, 0, 0x82),SCE(0x0125, 1, 0x42),
SCE(0x10ca2, 0, 0x82),SCE(0x10ce2, 1, 0x42),SCE(0x1e8c, 0, 0x82),SCE(0x1e8d, 1, 0x42),
SCE(0x1eb4, 0, 0x82),SCE(0x1eb5, 1, 0x42),SCE(0x016c, 0, 0x82),SCE(0x016d, 1, 0x42),
SCE(0x1e02, 0, 0x82),SCE(0x1e03, 1, 0x42),SCE(0x019a, 0, 0x42),SCE(0x023d, 1, 0x82),
SCE(0x0102, 0, 0x82),SCE(0x0103, 1, 0x42),SCE(0x1f14, 0, 0x42),SCE(0x1f1c, 1, 0x82),
SCE(0xff28, 0, 0x82),SCE(0xff48, 1, 0x42),SCE(0x10c80, 0, 0x82),SCE(0x10cc0, 1, 0x42),
SCE(0x10ee, 0, 0x42),SCE(0x1cae, 1, 0x82),SCE(0x1f55, 0, 0x42),SCE(0x1f5d, 1, 0x82),
SCE(0xa77b, 0, 0x82),SCE(0xa77c, 1, 0x42),SCE(0x0059, 0, 0x82),SCE(0x0079, 1, 0x42),
SCE(0x014a, 0, 0x82),SCE(0x014b, 1, 0x42),SCE(0x1e24, 0, 0x82),SCE(0x1e25, 1, 0x42),
SCE(0x13bd, 0, 0x82),SCE(0xab8d, 1, 0x42),SCE(0x2cbc, 0, 0x82),SCE(0x2cbd, 1, 0x42),
SCE(0x1040d, 0, 0x82),SCE(0x10435, 1, 0x42),SCE(0x1058f, 0, 0x82),SCE(0x105b6, 1, 0x42),
SCE(0x118a7, 0, 0x82),SCE(0x118c7, 1, 0x42),SCE(0xa660, 0, 0x82),SCE(0xa661, 1, 0x42),
SCE(0x0514, 0, 0x82),SCE(0x0515, 1, 0x42),SCE(0x052e, 0, 0x82),SCE(0x052f, 1, 0x42),
SCE(0x04a4, 0, 0x82),SCE(0x04a5, 1, 0x42),SCE(0x0400, 0, 0x82),SCE(0x0450, 1, 0x42),
SCE(0x16e58, 0, 0x82),SCE(0x16e78, 1, 0x42),SCE(0xa64e, 0, 0x82),SCE(0xa64f, 1, 0x42),
SCE(0xff2e, 0, 0x82),SCE(0xff4e, 1, 0x42),SCE(0x1040c, 0, 0x82),SCE(0x10434, 1, 0x42),
SCE(0x00db, 0, 0x82),SCE(0x00fb, 1, 0x42),SCE(0x01cd, 0, 0x82),SCE(0x01ce, 1, 0x42),
SCE(0x10e8, 0, 0x42),SCE(0x1ca8, 1, 0x82),SCE(0x054f, 0, 0x82),SCE(0x057f, 1, 0x42),
SCE(0xa738, 0, 0x82),SCE(0xa739, 1, 0x42),SCE(0x16e5f, 0, 0x82),SCE(0x16e7f, 1, 0x42),
SCE(0x1d79, 0, 0x42),SCE(0xa77d, 1, 0x82),SCE(0x1e90f, 0, 0x82),SCE(0x1e931, 1, 0x42),
SCE(0x2c07, 0, 0x82),SCE(0x2c37, 1, 0x42),SCE(0x10a3, 0, 0x82),SCE(0x2d03, 1, 0x42),
SCE(0xa7a0, 0, 0x82),SCE(0xa7a1, 1, 0x42),SCE(0x0421, 0, 0x83),SCE(0x0441, 1, 0x43),
SCE(0x1c83, 2, 0x43),SCE(0xa680, 0, 0x82),SCE(0xa681, 1, 0x42),SCE(0x0282, 0, 0x42),
SCE(0xa7c5, 1, 0x82),SCE(0x24cb, 0, 0x82),SCE(0x24e5, 1, 0x42),SCE(0x0401, 0, 0x82),
SCE(0x0451, 1, 0x42),SCE(0xa758, 0, 0x82),SCE(0xa759, 1, 0x42),SCE(0x0058, 0, 0x82),
SCE(0x0078, 1, 0x42),SCE(0x0193, 0, 0x82),SCE(0x0260, 1, 0x42),SCE(0x10ca1, 0, 0x82),
SCE(0x10ce1, 1, 0x42),SCE(0x054e, 0, 0x82),SCE(0x057e, 1, 0x42),SCE(0x0186, 0, 0x82),
SCE(0x0254, 1, 0x42),SCE(0x13dc, 0, 0x82),SCE(0xabac, 1, 0x42),SCE(0x24bd, 0, 0x82),
SCE(0x24d7, 1, 0x42),SCE(0x01b3, 0, 0x82),SCE(0x01b4, 1, 0x42),SCE(0xa696, 0, 0x82),
SCE(0xa697, 1, 0x42),SCE(0x0216, 0, 0x82),SCE(0x0217, 1, 0x42),SCE(0x1ece, 0, 0x82),
SCE(0x1ecf, 1, 0x42),SCE(0x2168, 0, 0x82),SCE(0x2178, 1, 0x42),SCE(0x1e90e, 0, 0x82),
SCE(0x1e930, 1, 0x42),SCE(0x2c12, 0, 0x82),SCE(0x2c42, 1, 0x42),SCE(0x2c2f, 0, 0x82),
SCE(0x2c5f, 1, 0x42),SCE(0x10cab, 0, 0x82),SCE(0x10ceb, 1, 0x42),SCE(0x1e86, 0, 0x82),
SCE(0x1e87, 1, 0x42),SCE(0x0412, 0, 0x83),SCE(0x0432, 1, 0x43),SCE(0x1c80, 2, 0x43),
SCE(0x13d6, 0, 0x82),SCE(0xaba6, 1, 0x42),SCE(0x1eba, 0, 0x82),SCE(0x1ebb, 1, 0x42),
SCE(0x1e91b, 0, 0x82),SCE(0x1e93d, 1, 0x42),SCE(0x1041a, 0, 0x82),SCE(0x10442, 1, 0x42),
SCE(0x1eee, 0, 0x82),SCE(0x1eef, 1, 0x42),SCE(0xff31, 0, 0x82),SCE(0xff51, 1, 0x42),
SCE(0xa7bc, 0, 0x82),SCE(0xa7bd, 1, 0x42),SCE(0x01db, 0, 0x82),SCE(0x01dc, 1, 0x42),
SCE(0x01a6, 0, 0x82),SCE(0x0280, 1, 0x42),SCE(0x1f07, 0, 0x42),SCE(0x1f0f, 1, 0x82),
SCE(0x118bd, 0, 0x82),SCE(0x118dd, 1, 0x42),SCE(0x00c8, 0, 0x82),SCE(0x00e8, 1, 0x42),
SCE(0x04d2, 0, 0x82),SCE(0x04d3, 1, 0x42),SCE(0x10e1, 0, 0x42),SCE(0x1ca1, 1, 0x82),
SCE(0x13b7, 0, 0x82),SCE(0xab87, 1, 0x42),SCE(0x10585, 0, 0x82),SCE(0x105ac, 1, 0x42),
SCE(0x16e4b, 0, 0x82),SCE(0x16e6b, 1, 0x42),SCE(0x0172, 0, 0x82),SCE(0x0173, 1, 0x42),
SCE(0x049e, 0, 0x82),SCE(0x049f, 1, 0x42),SCE(0x04e6, 0, 0x82),SCE(0x04e7, 1, 0x42),
SCE(0x10b0, 0, 0x82),SCE(0x2d10, 1, 0x42),SCE(0x2c9c, 0, 0x82),SCE(0x2c9d, 1, 0x42),
SCE(0x01ee, 0, 0x82),SCE(0x01ef, 1, 0x42),SCE(0x104b4, 0, 0x82),SCE(0x104dc, 1, 0x42),
SCE(0x10c87, 0, 0x82),SCE(0x10cc7, 1, 0x42),SCE(0x13ba, 0, 0x82),SCE(0xab8a, 1, 0x42),
SCE(0x1e10, 0, 0x82),SCE(0x1e11, 1, 0x42),SCE(0x0230, 0, 0x82),SCE(0x0231, 1, 0x42),
SCE(0x0428, 0, 0x82),SCE(0x0448, 1, 0x42),SCE(0x2cd0, 0, 0x82),SCE(0x2cd1, 1, 0x42),
SCE(0x118a0, 0, 0x82),SCE(0x118c0, 1, 0x42),SCE(0x03e0, 0, 0x82),SCE(0x03e1, 1, 0x42),
SCE(0x10588, 0, 0x82),SCE(0x105af, 1, 0x42),SCE(0xa780, 0, 0x82),SCE(0xa781, 1, 0x42),
SCE(0x10f5, 0, 0x42),SCE(0x1cb5, 1, 0x82),SCE(0x053b, 0, 0x82),SCE(0x056b, 1, 0x42),
SCE(0x00d5, 0, 0x82),SCE(0x00f5, 1, 0x42),SCE(0x0414, 0, 0x83),SCE(0x0434, 1, 0x43),
SCE(0x1c81, 2, 0x43),SCE(0x1fa4, 0, 0x42),SCE(0x1fac, 1, 0x2),SCE(0x012a, 0, 0x82),
SCE(0x012b, 1, 0x42),SCE(0x0052, 0, 0x82),SCE(0x0072, 1, 0x42),SCE(0x24b7, 0, 0x82),
SCE(0x24d1, 1, 0x42),SCE(0x1e908, 0, 0x82),SCE(0x1e92a, 1, 0x42),SCE(0x0398, 0, 0x84),
SCE(0x03b8, 1, 0x44),SCE(0x03d1, 2, 0x44),SCE(0x03f4, 3, 0x84),SCE(0x0202, 0, 0x82),
SCE(0x0203, 1, 0x42),SCE(0x0271, 0, 0x42),SCE(0x2c6e, 1, 0x82),SCE(0x0470, 0, 0x82),
SCE(0x0471, 1, 0x42),SCE(0x2c1b, 0, 0x82),SCE(0x2c4b, 1, 0x42),SCE(0x048a, 0, 0x82),
SCE(0x048b, 1, 0x42),SCE(0xa752, 0, 0x82),SCE(0xa753, 1, 0x42),SCE(0xff25, 0, 0x82),
SCE(0xff45, 1, 0x42),SCE(0x0407, 0, 0x82),SCE(0x0457, 1, 0x42),SCE(0x00c1, 0, 0x82),
SCE(0x00e1, 1, 0x42),SCE(0x1e44, 0, 0x82),SCE(0x1e45, 1, 0x42),SCE(0x1f97, 0, 0x42),
SCE(0x1f9f, 1, 0x2),SCE(0x0548, 0, 0x82),SCE(0x0578, 1, 0x42),SCE(0x021c, 0, 0x82),
SCE(0x021d, 1, 0x42),SCE(0x13e5, 0, 0x82),SCE(0xabb5, 1, 0x42),SCE(0x051a, 0, 0x82),
SCE(0x051b, 1, 0x42),SCE(0x2cb6, 0, 0x82),SCE(0x2cb7, 1, 0x42),SCE(0xa654, 0, 0x82),
SCE(0xa655, 1, 0x42),SCE(0x10403, 0, 0x82),SCE(0x1042b, 1, 0x42),SCE(0x1e72, 0, 0x82),
SCE(0x1e73, 1, 0x42),SCE(0x10d4, 0, 0x42),SCE(0x1c94, 1, 0x82),SCE(0x104c1, 0, 0x82),
SCE(0x104e9, 1, 0x42),SCE(0x10c8a, 0, 0x82),SCE(0x10cca, 1, 0x42),SCE(0x1e2a, 0, 0x82),
SCE(0x1e2b, 1, 0x42),SCE(0x0462, 0, 0x83),SCE(0x0463, 1, 0x43),SCE(0x1c87, 2, 0x43),
SCE(0x1f76, 0, 0x42),SCE(0x1fda, 1, 0x82),SCE(0x0053, 0, 0x83),SCE(0x0073, 1, 0x43),
SCE(0x017f, 2, 0x43),SCE(0x2c26, 0, 0x82),SCE(0x2c56, 1, 0x42),SCE(0x13a0, 0, 0x82),
SCE(0xab70, 1, 0x42),SCE(0x04c5, 0, 0x82),SCE(0x04c6, 1, 0x42),SCE(0x03fa, 0, 0x82),
SCE(0x03fb, 1, 0x42),SCE(0x0555, 0, 0x82),SCE(0x0585, 1, 0x42),SCE(0x13e8, 0, 0x82),
SCE(0xabb8, 1, 0x42),SCE(0x01c7, 0, 0x83),SCE(0x01c8, 1, 0x3),SCE(0x01c9, 2, 0x43),
SCE(0x1f42, 0, 0x42),SCE(0x1f4a, 1, 0x82),SCE(0x1f67, 0, 0x42),SCE(0x1f6f, 1, 0x82),
SCE(0x1057c, 0, 0x82),SCE(0x105a3, 1, 0x42),SCE(0xa7b4, 0, 0x82),SCE(0xa7b5, 1, 0x42),
SCE(0xa698, 0, 0x82),SCE(0xa699, 1, 0x42),SCE(0x1e904, 0, 0x82),SCE(0x1e926, 1, 0x42),
SCE(0x040c, 0, 0x82),SCE(0x045c, 1, 0x42),SCE(0x10da, 0, 0x42),SCE(0x1c9a, 1, 0x82),
SCE(0x00d0, 0, 0x82),SCE(0x00f0, 1, 0x42),SCE(0x16e46, 0, 0x82),SCE(0x16e66, 1, 0x42),
SCE(0x1ec2, 0, 0x82),SCE(0x1ec3, 1, 0x42),SCE(0x01e4, 0, 0x82),SCE(0x01e5, 1, 0x42),
SCE(0x0044, 0, 0x82),SCE(0x0064, 1, 0x42),SCE(0x017d, 0, 0x82),SCE(0x017e, 1, 0x42),
SCE(0x1f21, 0, 0x42),SCE(0x1f29, 1, 0x82),SCE(0xff39, 0, 0x82),SCE(0xff59, 1, 0x42),
SCE(0x13ac, 0, 0x82),SCE(0xab7c, 1, 0x42),SCE(0x1f00, 0, 0x42),SCE(0x1f08, 1, 0x82),
SCE(0x03a5, 0, 0x82),SCE(0x03c5, 1, 0x42),SCE(0x0158, 0, 0x82),SCE(0x0159, 1, 0x42),
SCE(0x104cf, 0, 0x82),SCE(0x104f7, 1, 0x42),SCE(0x1e3a, 0, 0x82),SCE(0x1e3b, 1, 0x42),
SCE(0xa72c, 0, 0x82),SCE(0xa72d, 1, 0x42),SCE(0x118b7, 0, 0x82),SCE(0x118d7, 1, 0x42),
SCE(0x0112, 0, 0x82),SCE(0x0113, 1, 0x42),SCE(0x1e36, 0, 0x82),SCE(0x1e37, 1, 0x42),
SCE(0x16e4e, 0, 0x82),SCE(0x16e6e, 1, 0x42),SCE(0x1f7d, 0, 0x42),SCE(0x1ffb, 1, 0x82),
SCE(0x0494, 0, 0x82),SCE(0x0495, 1, 0x42),SCE(0x1e80, 0, 0x82),SCE(0x1e81, 1, 0x42),
SCE(0x0116, 0, 0x82),SCE(0x0117, 1, 0x42),SCE(0x042d, 0, 0x82),SCE(0x044d, 1, 0x42),
SCE(0x13f2, 0, 0x82),SCE(0x13fa, 1, 0x42),SCE(0x0179, 0, 0x82),SCE(0x017a, 1, 0x42),
SCE(0x04da, 0, 0x82),SCE(0x04db, 1, 0x42),SCE(0x2ca8, 0, 0x82),SCE(0x2ca9, 1, 0x42),
SCE(0x00cc, 0, 0x82),SCE(0x00ec, 1, 0x42),SCE(0x01a2, 0, 0x82),SCE(0x01a3, 1, 0x42),
SCE(0x03a1, 0, 0x83),SCE(0x03c1, 1, 0x43),SCE(0x03f1, 2, 0x43),SCE(0x1e7c, 0, 0x82),
SCE(0x1e7d, 1, 0x42),SCE(0x13cf, 0, 0x82),SCE(0xab9f, 1, 0x42),SCE(0x10412, 0, 0x82),
SCE(0x1043a, 1, 0x42),SCE(0x0520, 0, 0x82),SCE(0x0521, 1, 0x42),SCE(0x2c1c, 0, 0x82),
SCE(0x2c4c, 1, 0x42),SCE(0x026b, 0, 0x42),SCE(0x2c62, 1, 0x82),SCE(0x10591, 0, 0x82),
SCE(0x105b8, 1, 0x42),SCE(0x015c, 0, 0x82),SCE(0x015d, 1, 0x42),SCE(0xa652, 0, 0x82),
SCE(0xa653, 1, 0x42),SCE(0xff26, 0, 0x82),SCE(0xff46, 1, 0x42),SCE(0x01e8, 0, 0x82),
SCE(0x01e9, 1, 0x42),SCE(0x10b6, 0, 0x82),SCE(0x2d16, 1, 0x42),SCE(0xa656, 0, 0x82),
SCE(0xa657, 1, 0x42),SCE(0x051c, 0, 0x82),SCE(0x051d, 1, 0x42),SCE(0x13c3, 0, 0x82),
SCE(0xab93, 1, 0x42),SCE(0x104cb, 0, 0x82),SCE(0x104f3, 1, 0x42),SCE(0x1ec6, 0, 0x82),
SCE(0x1ec7, 1, 0x42),SCE(0x01e0, 0, 0x82),SCE(0x01e1, 1, 0x42),SCE(0x1f63, 0, 0x42),
SCE(0x1f6b, 1, 0x82),SCE(0x2c01, 0, 0x82),SCE(0x2c31, 1, 0x42),SCE(0x1e900, 0, 0x82),
SCE(0x1e922, 1, 0x42),SCE(0x1e78, 0, 0x82),SCE(0x1e79, 1, 0x42),SCE(0x24ce, 0, 0x82),
SCE(0x24e8, 1, 0x42),SCE(0xa76a, 0, 0x82),SCE(0xa76b, 1, 0x42),SCE(0x011a, 0, 0x82),
SCE(0x011b, 1, 0x42),SCE(0x0429, 0, 0x82),SCE(0x0449, 1, 0x42),SCE(0x1f84, 0, 0x42),
SCE(0x1f8c, 1, 0x2),SCE(0x10d6, 0, 0x42),SCE(0x1c96, 1, 0x82),SCE(0x1fb1, 0, 0x42),
SCE(0x1fb9, 1, 0x82),SCE(0xa762, 0, 0x82),SCE(0xa763, 1, 0x42),SCE(0x10cb2, 0, 0x82),
SCE(0x10cf2, 1, 0x42),SCE(0x2c20, 0, 0x82),SCE(0x2c50, 1, 0x42),SCE(0x10be, 0, 0x82),
SCE(0x2d1e, 1, 0x42),SCE(0x1041e, 0, 0x82),SCE(0x10446, 1, 0x42),SCE(0x04e2, 0, 0x82),
SCE(0x04e3, 1, 0x42),SCE(0x04de, 0, 0x82),SCE(0x04df, 1, 0x42),SCE(0x13ea, 0, 0x82),
SCE(0xabba, 1, 0x42),SCE(0x0541, 0, 0x82),SCE(0x0571, 1, 0x42),SCE(0x0545, 0, 0x82),
SCE(0x0575, 1, 0x42),SCE(0x1f25, 0, 0x42),SCE(0x1f2d, 1, 0x82),SCE(0x0154, 0, 0x82),
SCE(0x0155, 1, 0x42),SCE(0x2c24, 0, 0x82),SCE(0x2c54, 1, 0x42),SCE(0x13ee, 0, 0x82),
SCE(0xabbe, 1, 0x42),SCE(0x0181, 0, 0x82),SCE(0x0253, 1, 0x42),SCE(0x03a3, 0, 0x83),
SCE(0x03c2, 1, 0x43),SCE(0x03c3, 2, 0x43),SCE(0x118b3, 0, 0x82),SCE(0x118d3, 1, 0x42),
SCE(0x10ba, 0, 0x82),SCE(0x2d1a, 1, 0x42),SCE(0x0180, 0, 0x42),SCE(0x0243, 1, 0x82),
SCE(0x1e3e, 0, 0x82),SCE(0x1e3f, 1, 0x42),SCE(0x10ff, 0, 0x42),SCE(0x1cbf, 1, 0x82),
SCE(0x10c88, 0, 0x82),SCE(0x10cc8, 1, 0x42),SCE(0x10d2, 0, 0x42),SCE(0x1c92, 1, 0x82),
SCE(0xa76e, 0, 0x82),SCE(0xa76f, 1, 0x42),SCE(0x1c88, 0, 0x43),SCE(0xa64a, 1, 0x83),
SCE(0xa64b, 2, 0x43),SCE(0x10b2, 0, 0x82),SCE(0x2d12, 1, 0x42),SCE(0x13c7, 0, 0x82),
SCE(0xab97, 1, 0x42),SCE(0x0518, 0, 0x82),SCE(0x0519, 1, 0x42),SCE(0xa766, 0, 0x82),
SCE(0xa767, 1, 0x42),SCE(0x01ec, 0, 0x82),SCE(0x01ed, 1, 0x42),SCE(0x104c3, 0, 0x82),
SCE(0x104eb, 1, 0x42),SCE(0x10574, 0, 0x82),SCE(0x1059b, 1, 0x42),SCE(0x1e91c, 0, 0x82),
SCE(0x1e93e, 1, 0x42),SCE(0x10e2, 0, 0x42),SCE(0x1ca2, 1, 0x82),SCE(0x2c05, 0, 0x82),
SCE(0x2c35, 1, 0x42),SCE(0x04a0, 0, 0x82),SCE(0x04a1, 1, 0x42),SCE(0x1e42, 0, 0x82),
SCE(0x1e43, 1, 0x42),SCE(0x13b4, 0, 0x82),SCE(0xab84, 1, 0x42),SCE(0x118bf, 0, 0x82),
SCE(0x118df, 1, 0x42),SCE(0x0150, 0, 0x82),SCE(0x0151, 1, 0x42),SCE(0x2cb0, 0, 0x82),
SCE(0x2cb1, 1, 0x42),SCE(0x13a4, 0, 0x82),SCE(0xab74, 1, 0x42),SCE(0x04c1, 0, 0x82),
SCE(0x04c2, 1, 0x42),SCE(0x01ca, 0, 0x83),SCE(0x01cb, 1, 0x3),SCE(0x01cc, 2, 0x43),
SCE(0x004c, 0, 0x82),SCE(0x006c, 1, 0x42),SCE(0x104c7, 0, 0x82),SCE(0x104ef, 1, 0x42),
SCE(0x16e5a, 0, 0x82),SCE(0x16e7a, 1, 0x42),SCE(0x0222, 0, 0x82),SCE(0x0223, 1, 0x42),
SCE(0x0490, 0, 0x82),SCE(0x0491, 1, 0x42),SCE(0x2cf2, 0, 0x82),SCE(0x2cf3, 1, 0x42),
SCE(0x10595, 0, 0x82),SCE(0x105bc, 1, 0x42),SCE(0x053d, 0, 0x82),SCE(0x056d, 1, 0x42),
SCE(0x0388, 0, 0x82),SCE(0x03ad, 1, 0x42),SCE(0x0549, 0, 0x82),SCE(0x0579, 1, 0x42),
SCE(0x13e2, 0, 0x82),SCE(0xabb2, 1, 0x42),SCE(0x16e4a, 0, 0x82),SCE(0x16e6a, 1, 0x42),
SCE(0x1efc, 0, 0x82),SCE(0x1efd, 1, 0x42),SCE(0x1f90, 0, 0x42),SCE(0x1f98, 1, 0x2),
SCE(0x04d6, 0, 0x82),SCE(0x04d7, 1, 0x42),SCE(0xa7b8, 0, 0x82),SCE(0xa7b9, 1, 0x42),
SCE(0x0414, 0, 0x83),SCE(0x0434, 1, 0x43),SCE(0x1c81, 2, 0x43),SCE(0x10cad, 0, 0x82),
SCE(0x10ced, 1, 0x42),SCE(0x10f7, 0, 0x42),SCE(0x1cb7, 1, 0x82),SCE(0x16e55, 0, 0x82),
SCE(0x16e75, 1, 0x42),SCE(0xa728, 0, 0x82),SCE(0xa729, 1, 0x42),SCE(0x1e00, 0, 0x82),
SCE(0x1e01, 1, 0x42),SCE(0x0232, 0, 0x82),SCE(0x0233, 1, 0x42),SCE(0x10a5, 0, 0x82),
SCE(0x2d05, 1, 0x42),SCE(0x1f15, 0, 0x42),SCE(0x1f1d, 1, 0x82),SCE(0x03a9, 0, 0x83),
SCE(0x03c9, 1, 0x43),SCE(0x2126, 2, 0x83),SCE(0x013b, 0, 0x82),SCE(0x013c, 1, 0x42),
SCE(0x0408, 0, 0x82),SCE(0x0458, 1, 0x42),SCE(0x00dc, 0, 0x82),SCE(0x00fc, 1, 0x42),
SCE(0x1ebe, 0, 0x82),SCE(0x1ebf, 1, 0x42),SCE(0x2c18, 0, 0x82),SCE(0x2c48, 1, 0x42),
SCE(0xa7a8, 0, 0x82),SCE(0xa7a9, 1, 0x42),SCE(0x216b, 0, 0x82),SCE(0x217b, 1, 0x42),
SCE(0x2c10, 0, 0x82),SCE(0x2c40, 1, 0x42),SCE(0x2cde, 0, 0x82),SCE(0x2cdf, 1, 0x42),
SCE(0x029e, 0, 0x42),SCE(0xa7b0, 1, 0x82),SCE(0x00d4, 0, 0x82),SCE(0x00f4, 1, 0x42),
SCE(0x10ef, 0, 0x42),SCE(0x1caf, 1, 0x82),SCE(0x0551, 0, 0x82),SCE(0x0581, 1, 0x42),
SCE(0x13da, 0, 0x82),SCE(0xabaa, 1, 0x42),SCE(0x0535, 0, 0x82),SCE(0x0565, 1, 0x42),
SCE(0x10c9d, 0, 0x82),SCE(0x10cdd, 1, 0x42),SCE(0x24c6, 0, 0x82),SCE(0x24e0, 1, 0x42),
SCE(0x0410, 0, 0x82),SCE(0x0430, 1, 0x42),SCE(0x1eb6, 0, 0x82),SCE(0x1eb7, 1, 0x42),
SCE(0x10416, 0, 0x82),SCE(0x1043e, 1, 0x42),SCE(0x16e42, 0, 0x82),SCE(0x16e62, 1, 0x42),
SCE(0x0164, 0, 0x82),SCE(0x0165, 1, 0x42),SCE(0x2ca0, 0, 0x82),SCE(0x2ca1, 1, 0x42),
SCE(0x1e2e, 0, 0x82),SCE(0x1e2f, 1, 0x42),SCE(0x10c95, 0, 0x82),SCE(0x10cd5, 1, 0x42),
SCE(0x0498, 0, 0x82),SCE(0x0499, 1, 0x42),SCE(0x010a, 0, 0x82),SCE(0x010b, 1, 0x42),
SCE(0x118aa, 0, 0x82),SCE(0x118ca, 1, 0x42),SCE(0x1e88, 0, 0x82),SCE(0x1e89, 1, 0x42),
SCE(0x0528, 0, 0x82),SCE(0x0529, 1, 0x42),SCE(0x13d7, 0, 0x82),SCE(0xaba7, 1, 0x42),
SCE(0xa65a, 0, 0x82),SCE(0xa65b, 1, 0x42),SCE(0x022a, 0, 0x82),SCE(0x022b, 1, 0x42),
SCE(0x1fa5, 0, 0x42),SCE(0x1fad, 1, 0x2),SCE(0x104b3, 0, 0x82),SCE(0x104db, 1, 0x42),
SCE(0x1e90c, 0, 0x82),SCE(0x1e92e, 1, 0x42),SCE(0x24bb, 0, 0x82),SCE(0x24d5, 1, 0x42),
SCE(0x01f4, 0, 0x82),SCE(0x01f5, 1, 0x42),SCE(0xa690, 0, 0x82),SCE(0xa691, 1, 0x42),
SCE(0xff29, 0, 0x82),SCE(0xff49, 1, 0x42),SCE(0x2c75, 0, 0x82),SCE(0x2c76, 1, 0x42),
SCE(0x2cb8, 0, 0x82),SCE(0x2cb9, 1, 0x42),SCE(0x10401, 0, 0x82),SCE(0x10429, 1, 0x42),
SCE(0x2c0d, 0, 0x82),SCE(0x2c3d, 1, 0x42),SCE(0x104d0, 0, 0x82),SCE(0x104f8, 1, 0x42),
SCE(0x1e913, 0, 0x82),SCE(0x1e935, 1, 0x42),SCE(0x01af, 0, 0x82),SCE(0x01b0, 1, 0x42),
SCE(0xa7c7, 0, 0x82),SCE(0xa7c8, 1, 0x42),SCE(0x13bf, 0, 0x82),SCE(0xab8f, 1, 0x42),
SCE(0x10402, 0, 0x82),SCE(0x1042a, 1, 0x42),SCE(0x10ea, 0, 0x42),SCE(0x1caa, 1, 0x82),
SCE(0x104bf, 0, 0x82),SCE(0x104e7, 1, 0x42),SCE(0x1058d, 0, 0x82),SCE(0x105b4, 1, 0x42),
SCE(0x2164, 0, 0x82),SCE(0x2174, 1, 0x42),SCE(0x018e, 0, 0x82),SCE(0x01dd, 1, 0x42),
SCE(0x01d3, 0, 0x82),SCE(0x01d4, 1, 0x42),SCE(0x1f10, 0, 0x42),SCE(0x1f18, 1, 0x82),
SCE(0x1f57, 0, 0x42),SCE(0x1f5f, 1, 0x82),SCE(0x1ed2, 0, 0x82),SCE(0x1ed3, 1, 0x42),
SCE(0xff2a, 0, 0x82),SCE(0xff4a, 1, 0x42),SCE(0x1e04, 0, 0x82),SCE(0x1e05, 1, 0x42),
SCE(0x04ee, 0, 0x82),SCE(0x04ef, 1, 0x42),SCE(0x2c94, 0, 0x82),SCE(0x2c95, 1, 0x42),
SCE(0x00c0, 0, 0x82),SCE(0x00e0, 1, 0x42),SCE(0x13db, 0, 0x82),SCE(0xabab, 1, 0x42),
SCE(0x01b2, 0, 0x82),SCE(0x028b, 1, 0x42),SCE(0x10426, 0, 0x82),SCE(0x1044e, 1, 0x42),
SCE(0xa662, 0, 0x82),SCE(0xa663, 1, 0x42),SCE(0x0054, 0, 0x82),SCE(0x0074, 1, 0x42),
SCE(0x0556, 0, 0x82),SCE(0x0586, 1, 0x42),SCE(0x042a, 0, 0x83),SCE(0x044a, 1, 0x43),
SCE(0x1c86, 2, 0x43),SCE(0x10422, 0, 0x82),SCE(0x1044a, 1, 0x42),SCE(0x1f36, 0, 0x42),
SCE(0x1f3e, 1, 0x82),SCE(0xa794, 0, 0x42),SCE(0xa7c4, 1, 0x82),SCE(0x04cd, 0, 0x82),
SCE(0x04ce, 1, 0x42),SCE(0x104bb, 0, 0x82),SCE(0x104e3, 1, 0x42),SCE(0x023b, 0, 0x82),
SCE(0x023c, 1, 0x42),SCE(0x01cf, 0, 0x82),SCE(0x01d0, 1, 0x42),SCE(0x050c, 0, 0x82),
SCE(0x050d, 1, 0x42),SCE(0xa646, 0, 0x82),SCE(0xa647, 1, 0x42),SCE(0x1e46, 0, 0x82),
SCE(0x1e47, 1, 0x42),SCE(0x10ca6, 0, 0x82),SCE(0x10ce6, 1, 0x42),SCE(0xa779, 0, 0x82),
SCE(0xa77a, 1, 0x42),SCE(0xff36, 0, 0x82),SCE(0xff56, 1, 0x42),SCE(0x118a2, 0, 0x82),
SCE(0x118c2, 1, 0x42),SCE(0x04ea, 0, 0x82),SCE(0x04eb, 1, 0x42),SCE(0x041d, 0, 0x82),
SCE(0x043d, 1, 0x42),SCE(0x16e52, 0, 0x82),SCE(0x16e72, 1, 0x42),SCE(0xa688, 0, 0x82),
SCE(0xa689, 1, 0x42),SCE(0x1eb2, 0, 0x82),SCE(0x1eb3, 1, 0x42),SCE(0x2160, 0, 0x82),
SCE(0x2170, 1, 0x42),SCE(0x1ed6, 0, 0x82),SCE(0x1ed7, 1, 0x42),SCE(0x24c3, 0, 0x82),
SCE(0x24dd, 1, 0x42),SCE(0x16e5e, 0, 0x82),SCE(0x16e7e, 1, 0x42),SCE(0x04ac, 0, 0x82),
SCE(0x04ad, 1, 0x42),SCE(0x1e910, 0, 0x82),SCE(0x1e932, 1, 0x42),SCE(0x023e, 0, 0x82),
SCE(0x2c66, 1, 0x42),SCE(0x2cb4, 0, 0x82),SCE(0x2cb5, 1, 0x42),SCE(0xff2d, 0, 0x82),
SCE(0xff4d, 1, 0x42),SCE(0x014c, 0, 0x82),SCE(0x014d, 1, 0x42),SCE(0x1e22, 0, 0x82),
SCE(0x1e23, 1, 0x42),SCE(0x13bb, 0, 0x82),SCE(0xab8b, 1, 0x42),SCE(0x0143, 0, 0x82),
SCE(0x0144, 1, 0x42),SCE(0x10581, 0, 0x82),SCE(0x105a8, 1, 0x42),SCE(0x0170, 0, 0x82),
SCE(0x0171, 1, 0x42),SCE(0x1e94, 0, 0x82),SCE(0x1e95, 1, 0x42),SCE(0x2c28, 0, 0x82),
SCE(0x2c58, 1, 0x42),SCE(0x1040e, 0, 0x82),SCE(0x10436, 1, 0x42),SCE(0x104b2, 0, 0x82),
SCE(0x104da, 1, 0x42),SCE(0xa798, 0, 0x82),SCE(0xa799, 1, 0x42),SCE(0x13b8, 0, 0x82),
SCE(0xab88, 1, 0x42),SCE(0x1e70, 0, 0x82),SCE(0x1e71, 1, 0x42),SCE(0x0422, 0, 0x84),
SCE(0x0442, 1, 0x44),SCE(0x1c84, 2, 0x44),SCE(0x1c85, 3, 0x44),SCE(0x10c85, 0, 0x82),
SCE(0x10cc5, 1, 0x42),SCE(0x1eae, 0, 0x82),SCE(0x1eaf, 1, 0x42),SCE(0x0122, 0, 0x82),
SCE(0x0123, 1, 0x42),SCE(0x10c8c, 0, 0x82),SCE(0x10ccc, 1, 0x42),SCE(0x10405, 0, 0x82),
SCE(0x1042d, 1, 0x42),SCE(0x0420, 0, 0x82),SCE(0x0440, 1, 0x42),SCE(0x01ae, 0, 0x82),
SCE(0x0288, 1, 0x42),SCE(0x021a, 0, 0x82),SCE(0x021b, 1, 0x42),SCE(0x038c, 0, 0x82),
SCE(0x03cc, 1, 0x42),SCE(0x1f95, 0, 0x42),SCE(0x1f9d, 1, 0x2),SCE(0x0345, 0, 0x44),
SCE(0x0399, 1, 0x84),SCE(0x03b9, 2, 0x44),SCE(0x1fbe, 3, 0x44),SCE(0x018a, 0, 0x82),
SCE(0x0257, 1, 0x42),SCE(0x2c90, 0, 0x82),SCE(0x2c91, 1, 0x42),SCE(0x10b1, 0, 0x82),
SCE(0x2d11, 1, 0x42),SCE(0x011e, 0, 0x82),SCE(0x011f, 1, 0x42),SCE(0x1e08, 0, 0x82),
SCE(0x1e09, 1, 0x42),SCE(0xa7c0, 0, 0x82),SCE(0xa7c1, 1, 0x42),SCE(0x13e7, 0, 0x82),
SCE(0xabb7, 1, 0x42),SCE(0x10580, 0, 0x82),SCE(0x105a7, 1, 0x42),SCE(0x041c, 0, 0x82),
SCE(0x043c, 1, 0x42),SCE(0xa7a4, 0, 0x82),SCE(0xa7a5, 1, 0x42),SCE(0x1e74, 0, 0x82),
SCE(0x1e75, 1, 0x42),SCE(0x2c14, 0, 0x82),SCE(0x2c44, 1, 0x42),SCE(0x1e90d, 0, 0x82),
SCE(0x1e92f, 1, 0x42),SCE(0x13a5, 0, 0x82),SCE(0xab75, 1, 0x42),SCE(0x10f3, 0, 0x42),
SCE(0x1cb3, 1, 0x82),SCE(0x24ba, 0, 0x82),SCE(0x24d4, 1, 0x42),SCE(0x013f, 0, 0x82),
SCE(0x0140, 1, 0x42),SCE(0x039d, 0, 0x82),SCE(0x03bd, 1, 0x42),SCE(0x2ce2, 0, 0x82),
SCE(0x2ce3, 1, 0x42),SCE(0x10a1, 0, 0x82),SCE(0x2d01, 1, 0x42),SCE(0x0508, 0, 0x82),
SCE(0x0509, 1, 0x42),SCE(0x004d, 0, 0x82),SCE(0x006d, 1, 0x42),SCE(0x0389, 0, 0x82),
SCE(0x03ae, 1, 0x42),SCE(0x048c, 0, 0x82),SCE(0x048d, 1, 0x42),SCE(0x2c04, 0, 0x82),
SCE(0x2c34, 1, 0x42),SCE(0x216f, 0, 0x82),SCE(0x217f, 1, 0x42),SCE(0x04b0, 0, 0x82),
SCE(0x04b1, 1, 0x42),SCE(0x2cd2, 0, 0x82),SCE(0x2cd3, 1, 0x42),SCE(0xa734, 0, 0x82),
SCE(0xa735, 1, 0x42),SCE(0x10584, 0, 0x82),SCE(0x105ab, 1, 0x42),SCE(0x0050, 0, 0x82),
SCE(0x0070, 1, 0x42),SCE(0x0160, 0, 0x82),SCE(0x0161, 1, 0x42),SCE(0x10ca9, 0, 0x82),
SCE(0x10ce9, 1, 0x42),SCE(0x1e32, 0, 0x82),SCE(0x1e33, 1, 0x42),SCE(0x0200, 0, 0x82),
SCE(0x0201, 1, 0x42),SCE(0x118ab, 0, 0x82),SCE(0x118cb, 1, 0x42),SCE(0xa786, 0, 0x82),
SCE(0xa787, 1, 0x42),SCE(0x118bb, 0, 0x82),SCE(0x118db, 1, 0x42),SCE(0x118ae, 0, 0x82),
SCE(0x118ce, 1, 0x42),SCE(0x021e, 0, 0x82),SCE(0x021f, 1, 0x42),SCE(0x03aa, 0, 0x82),
SCE(0x03ca, 1, 0x42),SCE(0x10c2, 0, 0x82),SCE(0x2d22, 1, 0x42),SCE(0x13c4, 0, 0x82),
SCE(0xab94, 1, 0x42),SCE(0x0539, 0, 0x82),SCE(0x0569, 1, 0x42),SCE(0xa74a, 0, 0x82),
SCE(0xa74b, 1, 0x42),SCE(0x00c3, 0, 0x82),SCE(0x00e3, 1, 0x42),SCE(0x046e, 0, 0x82),
SCE(0x046f, 1, 0x42),SCE(0x054d, 0, 0x82),SCE(0x057d, 1, 0x42),SCE(0x10e3, 0, 0x42),
SCE(0x1ca3, 1, 0x82),SCE(0x03de, 0, 0x82),SCE(0x03df, 1, 0x42),SCE(0x24ca, 0, 0x82),
SCE(0x24e4, 1, 0x42),SCE(0x0345, 0, 0x44),SCE(0x0399, 1, 0x84),SCE(0x03b9, 2, 0x44),
SCE(0x1fbe, 3, 0x44),SCE(0x10c99, 0, 0x82),SCE(0x10cd9, 1, 0x42),SCE(0xa75a, 0, 0x82),
SCE(0xa75b, 1, 0x42),SCE(0x0419, 0, 0x82),SCE(0x0439, 1, 0x42),SCE(0x2c09, 0, 0x82),
SCE(0x2c39, 1, 0x42),SCE(0x037d, 0, 0x42),SCE(0x03ff, 1, 0x82),SCE(0x1f26, 0, 0x42),
SCE(0x1f2e, 1, 0x82),SCE(0x118b2, 0, 0x82),SCE(0x118d2, 1, 0x42),SCE(0x2183, 0, 0x82),
SCE(0x2184, 1, 0x42),SCE(0x2c23, 0, 0x82),SCE(0x2c53, 1, 0x42),SCE(0x0132, 0, 0x82),
SCE(0x0133, 1, 0x42),SCE(0x1e56, 0, 0x82),SCE(0x1e57, 1, 0x42),SCE(0x10ae, 0, 0x82),
SCE(0x2d0e, 1, 0x42),SCE(0xa740, 0, 0x82),SCE(0xa741, 1, 0x42),SCE(0x00dd, 0, 0x82),
SCE(0x00fd, 1, 0x42),SCE(0x10e6, 0, 0x42),SCE(0x1ca6, 1, 0x82),SCE(0x1e60, 0, 0x83),
SCE(0x1e61, 1, 0x43),SCE(0x1e9b, 2, 0x43),SCE(0x0478, 0, 0x82),SCE(0x0479, 1, 0x42),
SCE(0x022e, 0, 0x82),SCE(0x022f, 1, 0x42),SCE(0xa694, 0, 0x82),SCE(0xa695, 1, 0x42),
SCE(0x052c, 0, 0x82),SCE(0x052d, 1, 0x42),SCE(0x10570, 0, 0x82),SCE(0x10597, 1, 0x42),
SCE(0xa666, 0, 0x82),SCE(0xa667, 1, 0x42),SCE(0x13a8, 0, 0x82),SCE(0xab78, 1, 0x42),
SCE(0x10c96, 0, 0x82),SCE(0x10cd6, 1, 0x42),SCE(0x020a, 0, 0x82),SCE(0x020b, 1, 0x42),
SCE(0x24bf, 0, 0x82),SCE(0x24d9, 1, 0x42),SCE(0x13cb, 0, 0x82),SCE(0xab9b, 1, 0x42),
SCE(0x10c9c, 0, 0x82),SCE(0x10cdc, 1, 0x42),SCE(0x041e, 0, 0x83),SCE(0x043e, 1, 0x43),
SCE(0x1c82, 2, 0x43),SCE(0x1e84, 0, 0x82),SCE(0x1e85, 1, 0x42),SCE(0x1ef0, 0, 0x82),
SCE(0x1ef1, 1, 0x42),SCE(0x16e59, 0, 0x82),SCE(0x16e79, 1, 0x42),SCE(0x2ca4, 0, 0x82),
SCE(0x2ca5, 1, 0x42),SCE(0xa724, 0, 0x82),SCE(0xa725, 1, 0x42),SCE(0x049c, 0, 0x82),
SCE(0x049d, 1, 0x42),SCE(0x010e, 0, 0x82),SCE(0x010f, 1, 0x42),SCE(0x104d3, 0, 0x82),
SCE(0x104fb, 1, 0x42),SCE(0x1e903, 0, 0x82),SCE(0x1e925, 1, 0x42),SCE(0x0191, 0, 0x82),
SCE(0x0192, 1, 0x42),SCE(0x13de, 0, 0x82),SCE(0xabae, 1, 0x42),SCE(0x03a0, 0, 0x83),
SCE(0x03c0, 1, 0x43),SCE(0x03d6, 2, 0x43),SCE(0x13ad, 0, 0x82),SCE(0xab7d, 1, 0x42),
SCE(0x0206, 0, 0x82),SCE(0x0207, 1, 0x42),SCE(0x1f45, 0, 0x42),SCE(0x1f4d, 1, 0x82),
SCE(0x03ea, 0, 0x82),SCE(0x03eb, 1, 0x42),SCE(0x10bb, 0, 0x82),SCE(0x2d1b, 1, 0x42),
SCE(0x0474, 0, 0x82),SCE(0x0475, 1, 0x42),SCE(0xff38, 0, 0x82),SCE(0xff58, 1, 0x42),
SCE(0x04fe, 0, 0x82),SCE(0x04ff, 1, 0x42),SCE(0x2c84, 0, 0x82),SCE(0x2c85, 1, 0x42),
SCE(0x10413, 0, 0x82),SCE(0x1043b, 1, 0x42),SCE(0x2c1f, 0, 0x82),SCE(0x2c4f, 1, 0x42),
SCE(0x1e5c, 0, 0x82),SCE(0x1e5d, 1, 0x42),SCE(0x1ee4, 0, 0x82),SCE(0x1ee5, 1, 0x42),
SCE(0x2cc8, 0, 0x82),SCE(0x2cc9, 1, 0x42),SCE(0x104ce, 0, 0x82),SCE(0x104f6, 1, 0x42),
SCE(0x04ba, 0, 0x82),SCE(0x04bb, 1, 0x42),SCE(0x1e905, 0, 0x82),SCE(0x1e927, 1, 0x42),
SCE(0x00d1, 0, 0x82),SCE(0x00f1, 1, 0x42),SCE(0x0472, 0, 0x82),SCE(0x0473, 1, 0x42),
SCE(0x118b6, 0, 0x82),SCE(0x118d6, 1, 0x42),SCE(0x1f78, 0, 0x42),SCE(0x1ff8, 1, 0x82),
SCE(0x0043, 0, 0x82),SCE(0x0063, 1, 0x42),SCE(0x1ea2, 0, 0x82),SCE(0x1ea3, 1, 0x42),
SCE(0x1f24, 0, 0x42),SCE(0x1f2c, 1, 0x82),SCE(0x019d, 0, 0x82),SCE(0x0272, 1, 0x42),
SCE(0x04b6, 0, 0x82),SCE(0x04b7, 1, 0x42),SCE(0x00df, 0, 0x42),SCE(0x1e9e, 1, 0x82),
SCE(0x1f87, 0, 0x42),SCE(0x1f8f, 1, 0x2),SCE(0x1e14, 0, 0x82),SCE(0x1e15, 1, 0x42),
SCE(0x1ee6, 0, 0x82),SCE(0x1ee7, 1, 0x42),SCE(0x040b, 0, 0x82),SCE(0x045b, 1, 0x42),
SCE(0x0409, 0, 0x82),SCE(0x0459, 1, 0x42),SCE(0x1057d, 0, 0x82),SCE(0x105a4, 1, 0x42),
SCE(0x03a8, 0, 0x82),SCE(0x03c8, 1, 0x42),SCE(0x1e5a, 0, 0x82),SCE(0x1e5b, 1, 0x42),
SCE(0x1057f, 0, 0x82),SCE(0x105a6, 1, 0x42),SCE(0x0544, 0, 0x82),SCE(0x0574, 1, 0x42),
SCE(0x10fe, 0, 0x42),SCE(0x1cbe, 1, 0x82),SCE(0x1e12, 0, 0x82),SCE(0x1e13, 1, 0x42),
SCE(0x10b9, 0, 0x82),SCE(0x2d19, 1, 0x42),SCE(0x0047, 0, 0x82),SCE(0x0067, 1, 0x42),
SCE(0x04fc, 0, 0x82),SCE(0x04fd, 1, 0x42),SCE(0x10c92, 0, 0x82),SCE(0x10cd2, 1, 0x42),
SCE(0x2c86, 0, 0x82),SCE(0x2c87, 1, 0x42),SCE(0x1e1a, 0, 0x82),SCE(0x1e1b, 1, 0x42),
SCE(0x10c90, 0, 0x82),SCE(0x10cd0, 1, 0x42),SCE(0x10bf, 0, 0x82),SCE(0x2d1f, 1, 0x42),
SCE(0x13ca, 0, 0x82),SCE(0xab9a, 1, 0x42),SCE(0x16e49, 0, 0x82),SCE(0x16e69, 1, 0x42),
SCE(0x0041, 0, 0x82),SCE(0x0061, 1, 0x42),SCE(0x01bc, 0, 0x82),SCE(0x01bd, 1, 0x42),
SCE(0x1eea, 0, 0x82),SCE(0x1eeb, 1, 0x42),SCE(0x0502, 0, 0x82),SCE(0x0503, 1, 0x42),
SCE(0x0248, 0, 0x82),SCE(0x0249, 1, 0x42),SCE(0x10df, 0, 0x42),SCE(0x1c9f, 1, 0x82),
SCE(0x01c4, 0, 0x83),SCE(0x01c5, 1, 0x3),SCE(0x01c6, 2, 0x43),SCE(0x0546, 0, 0x82),
SCE(0x0576, 1, 0x42),SCE(0x13ef, 0, 0x82),SCE(0xabbf, 1, 0x42),SCE(0x2ccc, 0, 0x82),
SCE(0x2ccd, 1, 0x42),SCE(0x10d7, 0, 0x42),SCE(0x1c97, 1, 0x82),SCE(0x13a7, 0, 0x82),
SCE(0xab77, 1, 0x42),SCE(0x047a, 0, 0x82),SCE(0x047b, 1, 0x42),SCE(0x0134, 0, 0x82),
SCE(0x0135, 1, 0x42),SCE(0x042a, 0, 0x83),SCE(0x044a, 1, 0x43),SCE(0x1c86, 2, 0x43),
SCE(0x2c19, 0, 0x82),SCE(0x2c49, 1, 0x42),SCE(0x0204, 0, 0x82),SCE(0x0205, 1, 0x42),
SCE(0x025c, 0, 0x42),SCE(0xa7ab, 1, 0x82),SCE(0x24cf, 0, 0x82),SCE(0x24e9, 1, 0x42),
SCE(0x1e54, 0, 0x82),SCE(0x1e55, 1, 0x42),SCE(0x10579, 0, 0x82),SCE(0x105a0, 1, 0x42),
SCE(0x054a, 0, 0x82),SCE(0x057a, 1, 0x42),SCE(0xa684, 0, 0x82),SCE(0xa685, 1, 0x42),
SCE(0xff27, 0, 0x82),SCE(0xff47, 1, 0x42),SCE(0x1f05, 0, 0x42),SCE(0x1f0d, 1, 0x82),
SCE(0x2132, 0, 0x82),SCE(0x214e, 1, 0x42),SCE(0x024c, 0, 0x82),SCE(0x024d, 1, 0x42),
SCE(0x13b5, 0, 0x82),SCE(0xab85, 1, 0x42),SCE(0x2cc6, 0, 0x82),SCE(0x2cc7, 1, 0x42),
SCE(0x10408, 0, 0x82),SCE(0x10430, 1, 0x42),SCE(0x2c1d, 0, 0x82),SCE(0x2c4d, 1, 0x42),
SCE(0x023f, 0, 0x42),SCE(0x2c7e, 1, 0x82),SCE(0xa742, 0, 0x82),SCE(0xa743, 1, 0x42),
SCE(0x1e62, 0, 0x82),SCE(0x1e63, 1, 0x42),SCE(0x10ca8, 0, 0x82),SCE(0x10ce8, 1, 0x42),
SCE(0x00b5, 0, 0x43),SCE(0x039c, 1, 0x83),SCE(0x03bc, 2, 0x43),SCE(0x1f81, 0, 0x42),
SCE(0x1f89, 1, 0x2),SCE(0x10c9a, 0, 0x82),SCE(0x10cda, 1, 0x42),SCE(0x012e, 0, 0x82),
SCE(0x012f, 1, 0x42),SCE(0x0403, 0, 0x82),SCE(0x0453, 1, 0x42),SCE(0x01fe, 0, 0x82),
SCE(0x01ff, 1, 0x42),SCE(0x0345, 0, 0x44),SCE(0x0399, 1, 0x84),SCE(0x03b9, 2, 0x44),
SCE(0x1fbe, 3, 0x44),SCE(0x0174, 0, 0x82),SCE(0x0175, 1, 0x42),SCE(0x03cf, 0, 0x82),
SCE(0x03d7, 1, 0x42),SCE(0x24cd, 0, 0x82),SCE(0x24e7, 1, 0x42),SCE(0x1fb3, 0, 0x42),
SCE(0x1fbc, 1, 0x2),SCE(0x118ad, 0, 0x82),SCE(0x118cd, 1, 0x42),SCE(0xa744, 0, 0x82),
SCE(0xa745, 1, 0x42),SCE(0x00d9, 0, 0x82),SCE(0x00f9, 1, 0x42),SCE(0x1e0c, 0, 0x82),
SCE(0x1e0d, 1, 0x42),SCE(0x2c17, 0, 0x82),SCE(0x2c47, 1, 0x42),SCE(0x03e2, 0, 0x82),
SCE(0x03e3, 1, 0x42),SCE(0x026c, 0, 0x42),SCE(0xa7ad, 1, 0x82),SCE(0xa756, 0, 0x82),
SCE(0xa757, 1, 0x42),SCE(0x0405, 0, 0x82),SCE(0x0455, 1, 0x42),SCE(0x0197, 0, 0x82),
SCE(0x0268, 1, 0x42),SCE(0x1f60, 0, 0x42),SCE(0x1f68, 1, 0x82),SCE(0x1eec, 0, 0x82),
SCE(0x1eed, 1, 0x42),SCE(0x2c8c, 0, 0x82),SCE(0x2c8d, 1, 0x42),SCE(0x10f2, 0, 0x42),
SCE(0x1cb2, 1, 0x82),SCE(0x104b6, 0, 0x82),SCE(0x104de, 1, 0x42),SCE(0x1e91d, 0, 0x82),
SCE(0x1e93f, 1, 0x42),SCE(0x1040a, 0, 0x82),SCE(0x10432, 1, 0x42),SCE(0x13c6, 0, 0x82),
SCE(0xab96, 1, 0x42),SCE(0x16e41, 0, 0x82),SCE(0x16e61, 1, 0x42),SCE(0x0424, 0, 0x82),
SCE(0x0444, 1, 0x42),SCE(0x01a9, 0, 0x82),SCE(0x0283, 1, 0x42),SCE(0x039a, 0, 0x83),
SCE(0x03ba, 1, 0x43),SCE(0x03f0, 2, 0x43),SCE(0x10e5, 0, 0x42),SCE(0x1ca5, 1, 0x82),
SCE(0x104c8, 0, 0x82),SCE(0x104f0, 1, 0x42),SCE(0x10407, 0, 0x82),SCE(0x1042f, 1, 0x42),
SCE(0x13d0, 0, 0x82),SCE(0xaba0, 1, 0x42),SCE(0x1fa2, 0, 0x42),SCE(0x1faa, 1, 0x2),
SCE(0x046c, 0, 0x82),SCE(0x046d, 1, 0x42),SCE(0x10a0, 0, 0x82),SCE(0x2d00, 1, 0x42),
SCE(0xa782, 0, 0x82),SCE(0xa783, 1, 0x42),SCE(0x00c5, 0, 0x83),SCE(0x00e5, 1, 0x43),
SCE(0x212b, 2, 0x83),SCE(0x04b4, 0, 0x82),SCE(0x04b5, 1, 0x42),SCE(0x2cce, 0, 0x82),
SCE(0x2ccf, 1, 0x42),SCE(0xa73a, 0, 0x82),SCE(0xa73b, 1, 0x42),SCE(0xff21, 0, 0x82),
SCE(0xff41, 1, 0x42),SCE(0x104b9, 0, 0x82),SCE(0x104e1, 1, 0x42),SCE(0x1ea4, 0, 0x82),
SCE(0x1ea5, 1, 0x42),SCE(0x038f, 0, 0x82),SCE(0x03ce, 1, 0x42),SCE(0x24be, 0, 0x82),
SCE(0x24d8, 1, 0x42),SCE(0xa79e, 0, 0x82),SCE(0xa79f, 1, 0x42),SCE(0x0049, 0, 0x82),
SCE(0x0069, 1, 0x42),SCE(0x1e91f, 0, 0x82),SCE(0x1e941, 1, 0x42),SCE(0x0246, 0, 0x82),
SCE(0x0247, 1, 0x42),SCE(0x1f73, 0, 0x42),SCE(0x1fc9, 1, 0x82),SCE(0x2c67, 0, 0x82),
SCE(0x2c68, 1, 0x42),SCE(0x2166, 0, 0x82),SCE(0x2176, 1, 0x42),SCE(0x0100, 0, 0x82),
SCE(0x0101, 1, 0x42),SCE(0x03e4, 0, 0x82),SCE(0x03e5, 1, 0x42),SCE(0x13d2, 0, 0x82),
SCE(0xaba2, 1, 0x42),SCE(0x1fa0, 0, 0x42),SCE(0x1fa8, 1, 0x2),SCE(0x10cb1, 0, 0x82),
SCE(0x10cf1, 1, 0x42),SCE(0x16e5d, 0, 0x82),SCE(0x16e7d, 1, 0x42),SCE(0x10c1, 0, 0x82),
SCE(0x2d21, 1, 0x42),SCE(0xa7f5, 0, 0x82),SCE(0xa7f6, 1, 0x42),SCE(0x13be, 0, 0x82),
SCE(0xab8e, 1, 0x42),SCE(0x042c, 0, 0x82),SCE(0x044c, 1, 0x42),SCE(0x10dd, 0, 0x42),
SCE(0x1c9d, 1, 0x82),SCE(0x1f93, 0, 0x42),SCE(0x1f9b, 1, 0x2),SCE(0x024e, 0, 0x82),
SCE(0x024f, 1, 0x42),SCE(0x04bc, 0, 0x82),SCE(0x04bd, 1, 0x42),SCE(0x0176, 0, 0x82),
SCE(0x0177, 1, 0x42),SCE(0x13ab, 0, 0x82),SCE(0xab7b, 1, 0x42),SCE(0x13e1, 0, 0x82),
SCE(0xabb1, 1, 0x42),SCE(0x0504, 0, 0x82),SCE(0x0505, 1, 0x42),SCE(0x1f03, 0, 0x42),
SCE(0x1f0b, 1, 0x82),SCE(0xa686, 0, 0x82),SCE(0xa687, 1, 0x42),SCE(0x054c, 0, 0x82),
SCE(0x057c, 1, 0x42),SCE(0x16e4f, 0, 0x82),SCE(0x16e6f, 1, 0x42),SCE(0x10eb, 0, 0x42),
SCE(0x1cab, 1, 0x82),SCE(0x13d9, 0, 0x82),SCE(0xaba9, 1, 0x42),SCE(0x023a, 0, 0x82),
SCE(0x2c65, 1, 0x42),SCE(0x04a8, 0, 0x82),SCE(0x04a9, 1, 0x42),SCE(0x2cda, 0, 0x82),
SCE(0x2cdb, 1, 0x42),SCE(0x041e, 0, 0x83),SCE(0x043e, 1, 0x43),SCE(0x1c82, 2, 0x43),
SCE(0x0394, 0, 0x82),SCE(0x03b4, 1, 0x42),SCE(0x2c72, 0, 0x82),SCE(0x2c73, 1, 0x42),
SCE(0x0510, 0, 0x82),SCE(0x0511, 1, 0x42),SCE(0x1e26, 0, 0x82),SCE(0x1e27, 1, 0x42),
SCE(0xa642, 0, 0x82),SCE(0xa643, 1, 0x42),SCE(0x04c9, 0, 0x82),SCE(0x04ca, 1, 0x42),
SCE(0x0147, 0, 0x82),SCE(0x0148, 1, 0x42),SCE(0x1eb0, 0, 0x82),SCE(0x1eb1, 1, 0x42),
SCE(0xa75e, 0, 0x82),SCE(0xa75f, 1, 0x42),SCE(0x1058c, 0, 0x82),SCE(0x105b3, 1, 0x42),
SCE(0xa73c, 0, 0x82),SCE(0xa73d, 1, 0x42),SCE(0x104d1, 0, 0x82),SCE(0x104f9, 1, 0x42),
SCE(0x104d2, 0, 0x82),SCE(0x104fa, 1, 0x42),SCE(0x10590, 0, 0x82),SCE(0x105b7, 1, 0x42),
SCE(0x0055, 0, 0x82),SCE(0x0075, 1, 0x42),SCE(0x1f11, 0, 0x42),SCE(0x1f19, 1, 0x82),
SCE(0x037b, 0, 0x42),SCE(0x03fd, 1, 0x82),SCE(0x1f31, 0, 0x42),SCE(0x1f39, 1, 0x82),
SCE(0x2cba, 0, 0x82),SCE(0x2cbb, 1, 0x42),SCE(0x0552, 0, 0x82),SCE(0x0582, 1, 0x42),
SCE(0xa68c, 0, 0x82),SCE(0xa68d, 1, 0x42),SCE(0x1e6e, 0, 0x82),SCE(0x1e6f, 1, 0x42),
SCE(0x2167, 0, 0x82),SCE(0x2177, 1, 0x42),SCE(0x00de, 0, 0x82),SCE(0x00fe, 1, 0x42),
SCE(0x0190, 0, 0x82),SCE(0x025b, 1, 0x42),SCE(0x1ef8, 0, 0x82),SCE(0x1ef9, 1, 0x42),
SCE(0x104b0, 0, 0x82),SCE(0x104d8, 1, 0x42),SCE(0x10c8e, 0, 0x82),SCE(0x10cce, 1, 0x42),
SCE(0x2c08, 0, 0x82),SCE(0x2c38, 1, 0x42),SCE(0x016e, 0, 0x82),SCE(0x016f, 1, 0x42),
SCE(0x16e5c, 0, 0x82),SCE(0x16e7c, 1, 0x42),SCE(0x10cd, 0, 0x82),SCE(0x2d2d, 1, 0x42),
SCE(0x1f7b, 0, 0x42),SCE(0x1feb, 1, 0x82),SCE(0x1e90, 0, 0x82),SCE(0x1e91, 1, 0x42),
SCE(0x13b3, 0, 0x82),SCE(0xab83, 1, 0x42),SCE(0x01d1, 0, 0x82),SCE(0x01d2, 1, 0x42),
SCE(0x1f53, 0, 0x42),SCE(0x1f5b, 1, 0x82),SCE(0x0126, 0, 0x82),SCE(0x0127, 1, 0x42),
SCE(0x1e48, 0, 0x82),SCE(0x1e49, 1, 0x42),SCE(0x2c98, 0, 0x82),SCE(0x2c99, 1, 0x42),
SCE(0x10400, 0, 0x82),SCE(0x10428, 1, 0x42),SCE(0x10ca4, 0, 0x82),SCE(0x10ce4, 1, 0x42),
SCE(0x118b9, 0, 0x82),SCE(0x118d9, 1, 0x42),SCE(0x13b0, 0, 0x82),SCE(0xab80, 1, 0x42),
SCE(0x1ed8, 0, 0x82),SCE(0x1ed9, 1, 0x42),SCE(0x1f74, 0, 0x42),SCE(0x1fca, 1, 0x82),
SCE(0x0422, 0, 0x84),SCE(0x0442, 1, 0x44),SCE(0x1c84, 2, 0x44),SCE(0x1c85, 3, 0x44),
SCE(0x1ef2, 0, 0x82),SCE(0x1ef3, 1, 0x42),SCE(0x2161, 0, 0x82),SCE(0x2171, 1, 0x42),
SCE(0x10420, 0, 0x82),SCE(0x10448, 1, 0x42),SCE(0x01f1, 0, 0x83),SCE(0x01f2, 1, 0x3),
SCE(0x01f3, 2, 0x43),SCE(0x01d7, 0, 0x82),SCE(0x01d8, 1, 0x42),SCE(0xa68a, 0, 0x82),
SCE(0xa68b, 1, 0x42),SCE(0x03f7, 0, 0x82),SCE(0x03f8, 1, 0x42),SCE(0xff35, 0, 0x82),
SCE(0xff55, 1, 0x42),SCE(0x03dc, 0, 0x82),SCE(0x03dd, 1, 0x42),SCE(0x10c8d, 0, 0x82),
SCE(0x10ccd, 1, 0x42),SCE(0x0418, 0, 0x82),SCE(0x0438, 1, 0x42),SCE(0x0212, 0, 0x82),
SCE(0x0213, 1, 0x42),SCE(0x04f0, 0, 0x82),SCE(0x04f1, 1, 0x42),SCE(0x24c1, 0, 0x82),
SCE(0x24db, 1, 0x42),SCE(0x050a, 0, 0x82),SCE(0x050b, 1, 0x42),SCE(0x1e917, 0, 0x82),
SCE(0x1e939, 1, 0x42),SCE(0xa644, 0, 0x82),SCE(0xa645, 1, 0x42),SCE(0x0537, 0, 0x82),
SCE(0x0567, 1, 0x42),SCE(0x10ac, 0, 0x82),SCE(0x2d0c, 1, 0x42),SCE(0x10ad, 0, 0x82),
SCE(0x2d0d, 1, 0x42),SCE(0x24c7, 0, 0x82),SCE(0x24e1, 1, 0x42),SCE(0x0460, 0, 0x82),
SCE(0x0461, 1, 0x42),SCE(0x2c2b, 0, 0x82),SCE(0x2c5b, 1, 0x42),SCE(0x16e56, 0, 0x82),
SCE(0x16e76, 1, 0x42),SCE(0x10c7, 0, 0x82),SCE(0x2d27, 1, 0x42),SCE(0x10406, 0, 0x82),
SCE(0x1042e, 1, 0x42),SCE(0x2cd4, 0, 0x82),SCE(0x2cd5, 1, 0x42),SCE(0x10f1, 0, 0x42),
SCE(0x1cb1, 1, 0x82),SCE(0x1f7a, 0, 0x42),SCE(0x1fea, 1, 0x82),SCE(0x2c0b, 0, 0x82),
SCE(0x2c3b, 1, 0x42),SCE(0xff34, 0, 0x82),SCE(0xff54, 1, 0x42),SCE(0x0417, 0, 0x82),
SCE(0x0437, 1, 0x42),SCE(0x118ba, 0, 0x82),SCE(0x118da, 1, 0x42),SCE(0x01f1, 0, 0x83),
SCE(0x01f2, 1, 0x3),SCE(0x01f3, 2, 0x43),SCE(0x0395, 0, 0x83),SCE(0x03b5, 1, 0x43),
SCE(0x03f5, 2, 0x43),SCE(0x01b7, 0, 0x82),SCE(0x0292, 1, 0x42),SCE(0x018f, 0, 0x82),
SCE(0x0259, 1, 0x42),SCE(0x0538, 0, 0x82),SCE(0x0568, 1, 0x42),SCE(0xa66a, 0, 0x82),
SCE(0xa66b, 1, 0x42),SCE(0x1f32, 0, 0x42),SCE(0x1f3a, 1, 0x82),SCE(0x10421, 0, 0x82),
SCE(0x10449, 1, 0x42),SCE(0x052a, 0, 0x82),SCE(0x052b, 1, 0x42),SCE(0x0425, 0, 0x82),
SCE(0x0445, 1, 0x42),SCE(0xa784, 0, 0x82),SCE(0xa785, 1, 0x42),SCE(0x004f, 0, 0x82),
SCE(0x006f, 1, 0x42),SCE(0xa664, 0, 0x82),SCE(0xa665, 1, 0x42),SCE(0x104b1, 0, 0x82),
SCE(0x104d9, 1, 0x42),SCE(0x00c4, 0, 0x82),SCE(0x00e4, 1, 0x42),SCE(0x10ca5, 0, 0x82),
SCE(0x10ce5, 1, 0x42),SCE(0x1eaa, 0, 0x82),SCE(0x1eab, 1, 0x42),SCE(0x13d8, 0, 0x82),
SCE(0xaba8, 1, 0x42),SCE(0x10e4, 0, 0x42),SCE(0x1ca4, 1, 0x82),SCE(0x00d8, 0, 0x82),
SCE(0x00f8, 1, 0x42),SCE(0x01ca, 0, 0x83),SCE(0x01cb, 1, 0x3),SCE(0x01cc, 2, 0x43),
SCE(0x10d1, 0, 0x42),SCE(0x1c91, 1, 0x82),SCE(0x10575, 0, 0x82),SCE(0x1059c, 1, 0x42),
SCE(0x216c, 0, 0x82),SCE(0x217c, 1, 0x42),SCE(0x2c02, 0, 0x82),SCE(0x2c32, 1, 0x42),
SCE(0x16e5b, 0, 0x82),SCE(0x16e7b, 1, 0x42),SCE(0xa7d8, 0, 0x82),SCE(0xa7d9, 1, 0x42),
SCE(0xff22, 0, 0x82),SCE(0xff42, 1, 0x42),SCE(0x0404, 0, 0x82),SCE(0x0454, 1, 0x42),
SCE(0x10b3, 0, 0x82),SCE(0x2d13, 1, 0x42),SCE(0x1eca, 0, 0x82),SCE(0x1ecb, 1, 0x42),
SCE(0x10409, 0, 0x82),SCE(0x10431, 1, 0x42),SCE(0x1e918, 0, 0x82),SCE(0x1e93a, 1, 0x42),
SCE(0x04f6, 0, 0x82),SCE(0x04f7, 1, 0x42),SCE(0x2cc0, 0, 0x82),SCE(0x2cc1, 1, 0x42),
SCE(0x1e20, 0, 0x82),SCE(0x1e21, 1, 0x42),SCE(0x104b7, 0, 0x82),SCE(0x104df, 1, 0x42),
SCE(0x039b, 0, 0x82),SCE(0x03bb, 1, 0x42),SCE(0x0196, 0, 0x82),SCE(0x0269, 1, 0x42),
SCE(0x2c25, 0, 0x82),SCE(0x2c55, 1, 0x42),SCE(0xa790, 0, 0x82),SCE(0xa791, 1, 0x42),
SCE(0xa764, 0, 0x82),SCE(0xa765, 1, 0x42),SCE(0x020c, 0, 0x82),SCE(0x020d, 1, 0x42),
SCE(0x1f94, 0, 0x42),SCE(0x1f9c, 1, 0x2),SCE(0x118b0, 0, 0x82),SCE(0x118d0, 1, 0x42),
SCE(0x0182, 0, 0x82),SCE(0x0183, 1, 0x42),SCE(0x2cac, 0, 0x82),SCE(0x2cad, 1, 0x42),
SCE(0x1f80, 0, 0x42),SCE(0x1f88, 1, 0x2),SCE(0x24cc, 0, 0x82),SCE(0x24e6, 1, 0x42),
SCE(0x0251, 0, 0x42),SCE(0x2c6d, 1, 0x82),SCE(0x0480, 0, 0x82),SCE(0x0481, 1, 0x42),
SCE(0x13e6, 0, 0x82),SCE(0xabb6, 1, 0x42),SCE(0x24b8, 0, 0x82),SCE(0x24d2, 1, 0x42),
SCE(0x054b, 0, 0x82),SCE(0x057b, 1, 0x42),SCE(0x13aa, 0, 0x82),SCE(0xab7a, 1, 0x42),
SCE(0x004b, 0, 0x83),SCE(0x006b, 1, 0x43),SCE(0x212a, 2, 0x83),SCE(0x0261, 0, 0x42),
SCE(0xa7ac, 1, 0x82),SCE(0x0141, 0, 0x82),SCE(0x0142, 1, 0x42),SCE(0x039a, 0, 0x83),
SCE(0x03ba, 1, 0x43),SCE(0x03f0, 2, 0x43),SCE(0x10f8, 0, 0x42),SCE(0x1cb8, 1, 0x82),
SCE(0x104c4, 0, 0x82),SCE(0x104ec, 1, 0x42),SCE(0x0189, 0, 0x82),SCE(0x0256, 1, 0x42),
SCE(0x10de, 0, 0x42),SCE(0x1c9e, 1, 0x82),SCE(0x1e68, 0, 0x82),SCE(0x1e69, 1, 0x42),
SCE(0x104ba, 0, 0x82),SCE(0x104e2, 1, 0x42),SCE(0x1f04, 0, 0x42),SCE(0x1f0c, 1, 0x82),
SCE(0x10578, 0, 0x82),SCE(0x1059f, 1, 0x42),SCE(0x0411, 0, 0x82),SCE(0x0431, 1, 0x42),
SCE(0x10582, 0, 0x82),SCE(0x105a9, 1, 0x42),SCE(0x0466, 0, 0x82),SCE(0x0467, 1, 0x42),
SCE(0xa736, 0, 0x82),SCE(0xa737, 1, 0x42),SCE(0x00cb, 0, 0x82),SCE(0x00eb, 1, 0x42),
SCE(0x10c0, 0, 0x82),SCE(0x2d20, 1, 0x42),SCE(0x10427, 0, 0x82),SCE(0x1044f, 1, 0x42),
SCE(0x01de, 0, 0x82),SCE(0x01df, 1, 0x42),SCE(0x2c92, 0, 0x82),SCE(0x2c93, 1, 0x42),
SCE(0x0106, 0, 0x82),SCE(0x0107, 1, 0x42),SCE(0x1e4e, 0, 0x82),SCE(0x1e4f, 1, 0x42),
SCE(0x042b, 0, 0x82),SCE(0x044b, 1, 0x42),SCE(0xa748, 0, 0x82),SCE(0xa749, 1, 0x42),
SCE(0x2c11, 0, 0x82),SCE(0x2c41, 1, 0x42),SCE(0xa7b3, 0, 0x82),SCE(0xab53, 1, 0x42),
SCE(0x053e, 0, 0x82),SCE(0x056e, 1, 0x42),SCE(0x014e, 0, 0x82),SCE(0x014f, 1, 0x42),
SCE(0x13d3, 0, 0x82),SCE(0xaba3, 1, 0x42),SCE(0x0524, 0, 0x82),SCE(0x0525, 1, 0x42),
SCE(0xa65e, 0, 0x82),SCE(0xa65f, 1, 0x42),SCE(0x01f8, 0, 0x82),SCE(0x01f9, 1, 0x42),
SCE(0x04ae, 0, 0x82),SCE(0x04af, 1, 0x42),SCE(0xa77e, 0, 0x82),SCE(0xa77f, 1, 0x42),
SCE(0x03a0, 0, 0x83),SCE(0x03c0, 1, 0x43),SCE(0x03d6, 2, 0x43),SCE(0x0265, 0, 0x42),
SCE(0xa78d, 1, 0x82),SCE(0xff2b, 0, 0x82),SCE(0xff4b, 1, 0x42),SCE(0x1fa1, 0, 0x42),
SCE(0x1fa9, 1, 0x2),SCE(0x1ede, 0, 0x82),SCE(0x1edf, 1, 0x42),SCE(0x13b9, 0, 0x82),
SCE(0xab89, 1, 0x42),SCE(0x0168, 0, 0x82),SCE(0x0169, 1, 0x42),SCE(0x0226, 0, 0x82),
SCE(0x0227, 1, 0x42),SCE(0x13f1, 0, 0x82),SCE(0x13f9, 1, 0x42),SCE(0x1e06, 0, 0x82),
SCE(0x1e07, 1, 0x42),SCE(0x0120, 0, 0x82),SCE(0x0121, 1, 0x42),SCE(0x1041d, 0, 0x82),
SCE(0x10445, 1, 0x42),SCE(0x1f66, 0, 0x42),SCE(0x1f6e, 1, 0x82),SCE(0x10a6, 0, 0x82),
SCE(0x2d06, 1, 0x42),SCE(0x10c91, 0, 0x82),SCE(0x10cd1, 1, 0x42),SCE(0x1d8e, 0, 0x42),
SCE(0xa7c6, 1, 0x82),SCE(0x10c84, 0, 0x82),SCE(0x10cc4, 1, 0x42),SCE(0x10cae, 0, 0x82),
SCE(0x10cee, 1, 0x42),SCE(0x118a3, 0, 0x82),SCE(0x118c3, 1, 0x42),SCE(0x0048, 0, 0x82),
SCE(0x0068, 1, 0x42),SCE(0x13cc, 0, 0x82),SCE(0xab9c, 1, 0x42),SCE(0x1e91e, 0, 0x82),
SCE(0x1e940, 1, 0x42),SCE(0x038e, 0, 0x82),SCE(0x03cd, 1, 0x42),SCE(0x0531, 0, 0x82),
SCE(0x0561, 1, 0x42),];
return t;
}
@property immutable(FullCaseEntry[]) fullCaseTable()  nothrow @nogc @safe pure
{
alias FCE = FullCaseEntry;
static immutable FCE[] t = [
FCE("𞤋", 0, 2, 1),
FCE("𞤭", 1, 2, 1),FCE("𐲮", 0, 2, 1),FCE("𐳮", 1, 2, 1),FCE("Җ", 0, 2, 1),
FCE("җ", 1, 2, 1),FCE("𞤑", 0, 2, 1),FCE("𞤳", 1, 2, 1),FCE("Ꜣ", 0, 2, 1),
FCE("ꜣ", 1, 2, 1),FCE("ό", 0, 2, 1),FCE("Ό", 1, 2, 1),FCE("ὄ", 0, 2, 1),
FCE("Ὄ", 1, 2, 1),FCE("Ś", 0, 2, 1),FCE("ś", 1, 2, 1),FCE("ჽ", 0, 2, 1),
FCE("Ჽ", 1, 2, 1),FCE("𖹌", 0, 2, 1),FCE("𖹬", 1, 2, 1),FCE("Ḹ", 0, 2, 1),
FCE("ḹ", 1, 2, 1),FCE("ﬖ", 0, 2, 1),FCE("վն", 1, 2, 2),FCE("𞤡", 0, 2, 1),
FCE("𞥃", 1, 2, 1),FCE("ἣ", 0, 2, 1),FCE("Ἣ", 1, 2, 1),FCE("Ơ", 0, 2, 1),
FCE("ơ", 1, 2, 1),FCE("Σ", 0, 3, 1),FCE("ς", 1, 3, 1),FCE("σ", 2, 3, 1),
FCE("Ӝ", 0, 2, 1),FCE("ӝ", 1, 2, 1),FCE("Ⲧ", 0, 2, 1),FCE("ⲧ", 1, 2, 1),
FCE("Ż", 0, 2, 1),FCE("ż", 1, 2, 1),FCE("𞤆", 0, 2, 1),FCE("𞤨", 1, 2, 1),
FCE("ნ", 0, 2, 1),FCE("Ნ", 1, 2, 1),FCE("𐓍", 0, 2, 1),FCE("𐓵", 1, 2, 1),
FCE("ὥ", 0, 2, 1),FCE("Ὥ", 1, 2, 1),FCE("Ԟ", 0, 2, 1),FCE("ԟ", 1, 2, 1),
FCE("ი", 0, 2, 1),FCE("Ი", 1, 2, 1),FCE("Ⱊ", 0, 2, 1),FCE("ⱊ", 1, 2, 1),
FCE("ɽ", 0, 2, 1),FCE("Ɽ", 1, 2, 1),FCE("Ꚛ", 0, 2, 1),FCE("ꚛ", 1, 2, 1),
FCE("ἂ", 0, 2, 1),FCE("Ἂ", 1, 2, 1),FCE("Ԣ", 0, 2, 1),FCE("ԣ", 1, 2, 1),
FCE("Ⱡ", 0, 2, 1),FCE("ⱡ", 1, 2, 1),FCE("ᾷ", 0, 2, 1),FCE("ᾶι", 1, 2, 3),
FCE("Ꙑ", 0, 2, 1),FCE("ꙑ", 1, 2, 1),FCE("Ꙝ", 0, 2, 1),FCE("ꙝ", 1, 2, 1),
FCE("Ⱎ", 0, 2, 1),FCE("ⱎ", 1, 2, 1),FCE("ᾳ", 0, 3, 1),FCE("ᾼ", 1, 3, 1),
FCE("αι", 2, 3, 2),FCE("Ꮙ", 0, 2, 1),FCE("ꮙ", 1, 2, 1),FCE("Ꮝ", 0, 2, 1),
FCE("ꮝ", 1, 2, 1),FCE("Î", 0, 2, 1),FCE("î", 1, 2, 1),FCE("Ṿ", 0, 2, 1),
FCE("ṿ", 1, 2, 1),FCE("𐐔", 0, 2, 1),FCE("𐐼", 1, 2, 1),FCE("Ᏸ", 0, 2, 1),
FCE("ᏸ", 1, 2, 1),FCE("Ễ", 0, 2, 1),FCE("ễ", 1, 2, 1),FCE("Ꞌ", 0, 2, 1),
FCE("ꞌ", 1, 2, 1),FCE("Ĕ", 0, 2, 1),FCE("ĕ", 1, 2, 1),FCE("Я", 0, 2, 1),
FCE("я", 1, 2, 1),FCE("𞤂", 0, 2, 1),FCE("𞤤", 1, 2, 1),FCE("Ә", 0, 2, 1),
FCE("ә", 1, 2, 1),FCE("Ⲫ", 0, 2, 1),FCE("ⲫ", 1, 2, 1),FCE("Đ", 0, 2, 1),
FCE("đ", 1, 2, 1),FCE("Ғ", 0, 2, 1),FCE("ғ", 1, 2, 1),FCE("Ḵ", 0, 2, 1),
FCE("ḵ", 1, 2, 1),FCE("Ᏼ", 0, 2, 1),FCE("ᏼ", 1, 2, 1),FCE("Ȥ", 0, 2, 1),
FCE("ȥ", 1, 2, 1),FCE("Ⲣ", 0, 2, 1),FCE("ⲣ", 1, 2, 1),FCE("Ꜯ", 0, 2, 1),
FCE("ꜯ", 1, 2, 1),FCE("𖹈", 0, 2, 1),FCE("𖹨", 1, 2, 1),FCE("J", 0, 2, 1),
FCE("j", 1, 2, 1),FCE("Ꭶ", 0, 2, 1),FCE("ꭶ", 1, 2, 1),FCE("Ş", 0, 2, 1),
FCE("ş", 1, 2, 1),FCE("Ǆ", 0, 3, 1),FCE("ǅ", 1, 3, 1),FCE("ǆ", 2, 3, 1),
FCE("ὀ", 0, 2, 1),FCE("Ὀ", 1, 2, 1),FCE("Ꙙ", 0, 2, 1),FCE("ꙙ", 1, 2, 1),
FCE("Ȭ", 0, 2, 1),FCE("ȭ", 1, 2, 1),FCE("𐲟", 0, 2, 1),FCE("𐳟", 1, 2, 1),
FCE("ὐ", 0, 2, 1),FCE("ὐ", 1, 2, 2),FCE("ᾧ", 0, 3, 1),FCE("ᾯ", 1, 3, 1),
FCE("ὧι", 2, 3, 2),FCE("B", 0, 2, 1),FCE("b", 1, 2, 1),FCE("Ꭾ", 0, 2, 1),
FCE("ꭾ", 1, 2, 1),FCE("𖹀", 0, 2, 1),FCE("𖹠", 1, 2, 1),FCE("Ò", 0, 2, 1),
FCE("ò", 1, 2, 1),FCE("Ẃ", 0, 2, 1),FCE("ẃ", 1, 2, 1),FCE("Ꮥ", 0, 2, 1),
FCE("ꮥ", 1, 2, 1),FCE("რ", 0, 2, 1),FCE("Რ", 1, 2, 1),FCE("Ľ", 0, 2, 1),
FCE("ľ", 1, 2, 1),FCE("І", 0, 2, 1),FCE("і", 1, 2, 1),FCE("ʝ", 0, 2, 1),
FCE("Ʝ", 1, 2, 1),FCE("Ĺ", 0, 2, 1),FCE("ĺ", 1, 2, 1),FCE("Ƙ", 0, 2, 1),
FCE("ƙ", 1, 2, 1),FCE("Ẽ", 0, 2, 1),FCE("ẽ", 1, 2, 1),FCE("Ϋ", 0, 2, 1),
FCE("ϋ", 1, 2, 1),FCE("Ў", 0, 2, 1),FCE("ў", 1, 2, 1),FCE("Ꞷ", 0, 2, 1),
FCE("ꞷ", 1, 2, 1),FCE("Њ", 0, 2, 1),FCE("њ", 1, 2, 1),FCE("Ề", 0, 2, 1),
FCE("ề", 1, 2, 1),FCE("𐕲", 0, 2, 1),FCE("𐖙", 1, 2, 1),FCE("Ⓓ", 0, 2, 1),
FCE("ⓓ", 1, 2, 1),FCE("Ⱆ", 0, 2, 1),FCE("ⱆ", 1, 2, 1),FCE("Ɯ", 0, 2, 1),
FCE("ɯ", 1, 2, 1),FCE("Χ", 0, 2, 1),FCE("χ", 1, 2, 1),FCE("Ꚓ", 0, 2, 1),
FCE("ꚓ", 1, 2, 1),FCE("Å", 0, 3, 1),FCE("å", 1, 3, 1),FCE("Å", 2, 3, 1),
FCE("Ԧ", 0, 2, 1),FCE("ԧ", 1, 2, 1),FCE("ɦ", 0, 2, 1),FCE("Ɦ", 1, 2, 1),
FCE("𐕺", 0, 2, 1),FCE("𐖡", 1, 2, 1),FCE("𐕾", 0, 2, 1),FCE("𐖥", 1, 2, 1),
FCE("ῐ", 0, 2, 1),FCE("Ῐ", 1, 2, 1),FCE("F", 0, 2, 1),FCE("f", 1, 2, 1),
FCE("𞤊", 0, 2, 1),FCE("𞤬", 1, 2, 1),FCE("Ȩ", 0, 2, 1),FCE("ȩ", 1, 2, 1),
FCE("Ꭲ", 0, 2, 1),FCE("ꭲ", 1, 2, 1),FCE("Ꜧ", 0, 2, 1),FCE("ꜧ", 1, 2, 1),
FCE("𐲓", 0, 2, 1),FCE("𐳓", 1, 2, 1),FCE("Қ", 0, 2, 1),FCE("қ", 1, 2, 1),
FCE("Ö", 0, 2, 1),FCE("ö", 1, 2, 1),FCE("Č", 0, 2, 1),FCE("č", 1, 2, 1),
FCE("𐲗", 0, 2, 1),FCE("𐳗", 1, 2, 1),FCE("Ţ", 0, 2, 1),FCE("ţ", 1, 2, 1),
FCE("ƞ", 0, 2, 1),FCE("Ƞ", 1, 2, 1),FCE("ẗ", 0, 2, 1),FCE("ẗ", 1, 2, 2),
FCE("Β", 0, 3, 1),FCE("β", 1, 3, 1),FCE("ϐ", 2, 3, 1),FCE("Ḱ", 0, 2, 1),
FCE("ḱ", 1, 2, 1),FCE("ᾣ", 0, 3, 1),FCE("ᾫ", 1, 3, 1),FCE("ὣι", 2, 3, 2),
FCE("𑢨", 0, 2, 1),FCE("𑣈", 1, 2, 1),FCE("Ⅽ", 0, 2, 1),FCE("ⅽ", 1, 2, 1),
FCE("Ⲟ", 0, 2, 1),FCE("ⲟ", 1, 2, 1),FCE("N", 0, 2, 1),FCE("n", 1, 2, 1),
FCE("µ", 0, 3, 1),FCE("Μ", 1, 3, 1),FCE("μ", 2, 3, 1),FCE("Ҏ", 0, 2, 1),
FCE("ҏ", 1, 2, 1),FCE("Ꜫ", 0, 2, 1),FCE("ꜫ", 1, 2, 1),FCE("𐐐", 0, 2, 1),
FCE("𐐸", 1, 2, 1),FCE("Ί", 0, 2, 1),FCE("ί", 1, 2, 1),FCE("Ỿ", 0, 2, 1),
FCE("ỿ", 1, 2, 1),FCE("𑢬", 0, 2, 1),FCE("𑣌", 1, 2, 1),FCE("Ǫ", 0, 2, 1),
FCE("ǫ", 1, 2, 1),FCE("ἆ", 0, 2, 1),FCE("Ἆ", 1, 2, 1),FCE("ῃ", 0, 3, 1),
FCE("ῌ", 1, 3, 1),FCE("ηι", 2, 3, 2),FCE("Ⴔ", 0, 2, 1),FCE("ⴔ", 1, 2, 1),
FCE("ɪ", 0, 2, 1),FCE("Ɪ", 1, 2, 1),FCE("В", 0, 3, 1),FCE("в", 1, 3, 1),
FCE("ᲀ", 2, 3, 1),FCE("ᾆ", 0, 3, 1),FCE("ᾎ", 1, 3, 1),FCE("ἆι", 2, 3, 2),
FCE("𐲛", 0, 2, 1),FCE("𐳛", 1, 2, 1),FCE("Ꝡ", 0, 2, 1),FCE("ꝡ", 1, 2, 1),
FCE("Ⓢ", 0, 2, 1),FCE("ⓢ", 1, 2, 1),FCE("Ƥ", 0, 2, 1),FCE("ƥ", 1, 2, 1),
FCE("Ο", 0, 2, 1),FCE("ο", 1, 2, 1),FCE("Ⴤ", 0, 2, 1),FCE("ⴤ", 1, 2, 1),
FCE("Ң", 0, 2, 1),FCE("ң", 1, 2, 1),FCE("Ⰳ", 0, 2, 1),FCE("ⰳ", 1, 2, 1),
FCE("Ⳡ", 0, 2, 1),FCE("ⳡ", 1, 2, 1),FCE("𐕶", 0, 2, 1),FCE("𐖝", 1, 2, 1),
FCE("ᾖ", 0, 3, 1),FCE("ᾞ", 1, 3, 1),FCE("ἦι", 2, 3, 2),FCE("Ӡ", 0, 2, 1),
FCE("ӡ", 1, 2, 1),FCE("Ⱚ", 0, 2, 1),FCE("ⱚ", 1, 2, 1),FCE("Ố", 0, 2, 1),
FCE("ố", 1, 2, 1),FCE("Â", 0, 2, 1),FCE("â", 1, 2, 1),FCE("Ө", 0, 2, 1),
FCE("ө", 1, 2, 1),FCE("Ꞧ", 0, 2, 1),FCE("ꞧ", 1, 2, 1),FCE("ჹ", 0, 2, 1),
FCE("Ჹ", 1, 2, 1),FCE("Ņ", 0, 2, 1),FCE("ņ", 1, 2, 1),FCE("ͼ", 0, 2, 1),
FCE("Ͼ", 1, 2, 1),FCE("Ỉ", 0, 2, 1),FCE("ỉ", 1, 2, 1),FCE("К", 0, 2, 1),
FCE("к", 1, 2, 1),FCE("Ê", 0, 2, 1),FCE("ê", 1, 2, 1),FCE("ᾆ", 0, 3, 1),
FCE("ᾎ", 1, 3, 1),FCE("ἆι", 2, 3, 2),FCE("С", 0, 3, 1),FCE("с", 1, 3, 1),
FCE("ᲃ", 2, 3, 1),FCE("𐐄", 0, 2, 1),FCE("𐐬", 1, 2, 1),FCE("ﬂ", 0, 2, 1),
FCE("fl", 1, 2, 2),FCE("Կ", 0, 2, 1),FCE("կ", 1, 2, 1),FCE("Շ", 0, 2, 1),
FCE("շ", 1, 2, 1),FCE("Ꮆ", 0, 2, 1),FCE("ꮆ", 1, 2, 1),FCE("Ꮼ", 0, 2, 1),
FCE("ꮼ", 1, 2, 1),FCE("Ｌ", 0, 2, 1),FCE("ｌ", 1, 2, 1),FCE("Ꞻ", 0, 2, 1),
FCE("ꞻ", 1, 2, 1),FCE("Ꙉ", 0, 2, 1),FCE("ꙉ", 1, 2, 1),FCE("Ꮕ", 0, 2, 1),
FCE("ꮕ", 1, 2, 1),FCE("Ｄ", 0, 2, 1),FCE("ｄ", 1, 2, 1),FCE("𐐏", 0, 2, 1),
FCE("𐐷", 1, 2, 1),FCE("𐐜", 0, 2, 1),FCE("𐑄", 1, 2, 1),FCE("𐖃", 0, 2, 1),
FCE("𐖪", 1, 2, 1),FCE("𐲃", 0, 2, 1),FCE("𐳃", 1, 2, 1),FCE("Ɂ", 0, 2, 1),
FCE("ɂ", 1, 2, 1),FCE("Ṷ", 0, 2, 1),FCE("ṷ", 1, 2, 1),FCE("Ⴜ", 0, 2, 1),
FCE("ⴜ", 1, 2, 1),FCE("Ⱒ", 0, 2, 1),FCE("ⱒ", 1, 2, 1),FCE("ა", 0, 2, 1),
FCE("Ა", 1, 2, 1),FCE("Ꝩ", 0, 2, 1),FCE("ꝩ", 1, 2, 1),FCE("Ꜳ", 0, 2, 1),
FCE("ꜳ", 1, 2, 1),FCE("Ĝ", 0, 2, 1),FCE("ĝ", 1, 2, 1),FCE("Ч", 0, 2, 1),
FCE("ч", 1, 2, 1),FCE("Ṁ", 0, 2, 1),FCE("ṁ", 1, 2, 1),FCE("𑢱", 0, 2, 1),
FCE("𑣑", 1, 2, 1),FCE("Œ", 0, 2, 1),FCE("œ", 1, 2, 1),FCE("Ρ", 0, 3, 1),
FCE("ρ", 1, 3, 1),FCE("ϱ", 2, 3, 1),FCE("Η", 0, 2, 1),FCE("η", 1, 2, 1),
FCE("Ƭ", 0, 2, 1),FCE("ƭ", 1, 2, 1),FCE("Ǣ", 0, 2, 1),FCE("ǣ", 1, 2, 1),
FCE("Ș", 0, 2, 1),FCE("ș", 1, 2, 1),FCE("𞤚", 0, 2, 1),FCE("𞤼", 1, 2, 1),
FCE("Ԗ", 0, 2, 1),FCE("ԗ", 1, 2, 1),FCE("ἧ", 0, 2, 1),FCE("Ἧ", 1, 2, 1),
FCE("Ꟊ", 0, 2, 1),FCE("ꟊ", 1, 2, 1),FCE("ῠ", 0, 2, 1),FCE("Ῠ", 1, 2, 1),
FCE("Ⅵ", 0, 2, 1),FCE("ⅵ", 1, 2, 1),FCE("Ꙭ", 0, 2, 1),FCE("ꙭ", 1, 2, 1),
FCE("Γ", 0, 2, 1),FCE("γ", 1, 2, 1),FCE("Բ", 0, 2, 1),FCE("բ", 1, 2, 1),
FCE("V", 0, 2, 1),FCE("v", 1, 2, 1),FCE("ἳ", 0, 2, 1),FCE("Ἳ", 1, 2, 1),
FCE("Ք", 0, 2, 1),FCE("ք", 1, 2, 1),FCE("ᲈ", 0, 3, 1),FCE("Ꙋ", 1, 3, 1),
FCE("ꙋ", 2, 3, 1),FCE("Ꚏ", 0, 2, 1),FCE("ꚏ", 1, 2, 1),FCE("Ϙ", 0, 2, 1),
FCE("ϙ", 1, 2, 1),FCE("Ⓟ", 0, 2, 1),FCE("ⓟ", 1, 2, 1),FCE("Ⲳ", 0, 2, 1),
FCE("ⲳ", 1, 2, 1),FCE("𐲂", 0, 2, 1),FCE("𐳂", 1, 2, 1),FCE("W", 0, 2, 1),
FCE("w", 1, 2, 1),FCE("𖹓", 0, 2, 1),FCE("𖹳", 1, 2, 1),FCE("Ｗ", 0, 2, 1),
FCE("ｗ", 1, 2, 1),FCE("Ỷ", 0, 2, 1),FCE("ỷ", 1, 2, 1),FCE("𞤒", 0, 2, 1),
FCE("𞤴", 1, 2, 1),FCE("ἒ", 0, 2, 1),FCE("Ἒ", 1, 2, 1),FCE("Ҧ", 0, 2, 1),
FCE("ҧ", 1, 2, 1),FCE("Ū", 0, 2, 1),FCE("ū", 1, 2, 1),FCE("ἴ", 0, 2, 1),
FCE("Ἴ", 1, 2, 1),FCE("Ⳝ", 0, 2, 1),FCE("ⳝ", 1, 2, 1),FCE("Ʊ", 0, 2, 1),
FCE("ʊ", 1, 2, 1),FCE("𑢤", 0, 2, 1),FCE("𑣄", 1, 2, 1),FCE("Ḩ", 0, 2, 1),
FCE("ḩ", 1, 2, 1),FCE("ƿ", 0, 2, 1),FCE("Ƿ", 1, 2, 1),FCE("Ƌ", 0, 2, 1),
FCE("ƌ", 1, 2, 1),FCE("Ⴇ", 0, 2, 1),FCE("ⴇ", 1, 2, 1),FCE("Ĩ", 0, 2, 1),
FCE("ĩ", 1, 2, 1),FCE("Ṫ", 0, 2, 1),FCE("ṫ", 1, 2, 1),FCE("Ⴋ", 0, 2, 1),
FCE("ⴋ", 1, 2, 1),FCE("П", 0, 2, 1),FCE("п", 1, 2, 1),FCE("Ⱞ", 0, 2, 1),
FCE("ⱞ", 1, 2, 1),FCE("𐲯", 0, 2, 1),FCE("𐳯", 1, 2, 1),FCE("𐓅", 0, 2, 1),
FCE("𐓭", 1, 2, 1),FCE("𑢥", 0, 2, 1),FCE("𑣅", 1, 2, 1),FCE("ῡ", 0, 2, 1),
FCE("Ῡ", 1, 2, 1),FCE("Φ", 0, 3, 1),FCE("φ", 1, 3, 1),FCE("ϕ", 2, 3, 1),
FCE("Ⰺ", 0, 2, 1),FCE("ⰺ", 1, 2, 1),FCE("Ԏ", 0, 2, 1),FCE("ԏ", 1, 2, 1),
FCE("Ą", 0, 2, 1),FCE("ą", 1, 2, 1),FCE("Ͳ", 0, 2, 1),FCE("ͳ", 1, 2, 1),
FCE("Ẏ", 0, 2, 1),FCE("ẏ", 1, 2, 1),FCE("Ζ", 0, 2, 1),FCE("ζ", 1, 2, 1),
FCE("Ỻ", 0, 2, 1),FCE("ỻ", 1, 2, 1),FCE("ϲ", 0, 2, 1),FCE("Ϲ", 1, 2, 1),
FCE("Ꙁ", 0, 2, 1),FCE("ꙁ", 1, 2, 1),FCE("წ", 0, 2, 1),FCE("Წ", 1, 2, 1),
FCE("𑢡", 0, 2, 1),FCE("𑣁", 1, 2, 1),FCE("ᾧ", 0, 3, 1),FCE("ᾯ", 1, 3, 1),
FCE("ὧι", 2, 3, 2),FCE("Ŧ", 0, 2, 1),FCE("ŧ", 1, 2, 1),FCE("ἷ", 0, 2, 1),
FCE("Ἷ", 1, 2, 1),FCE("𐲆", 0, 2, 1),FCE("𐳆", 1, 2, 1),FCE("Ꮭ", 0, 2, 1),
FCE("ꮭ", 1, 2, 1),FCE("ὑ", 0, 2, 1),FCE("Ὑ", 1, 2, 1),FCE("Ⲛ", 0, 2, 1),
FCE("ⲛ", 1, 2, 1),FCE("Ǻ", 0, 2, 1),FCE("ǻ", 1, 2, 1),FCE("Ⅹ", 0, 2, 1),
FCE("ⅹ", 1, 2, 1),FCE("𖹗", 0, 2, 1),FCE("𖹷", 1, 2, 1),FCE("Ⴄ", 0, 2, 1),
FCE("ⴄ", 1, 2, 1),FCE("S", 0, 3, 1),FCE("s", 1, 3, 1),FCE("ſ", 2, 3, 1),
FCE("Ͷ", 0, 2, 1),FCE("ͷ", 1, 2, 1),FCE("Ꮁ", 0, 2, 1),FCE("ꮁ", 1, 2, 1),
FCE("Ѩ", 0, 2, 1),FCE("ѩ", 1, 2, 1),FCE("Ꮴ", 0, 2, 1),FCE("ꮴ", 1, 2, 1),
FCE("ᾖ", 0, 3, 1),FCE("ᾞ", 1, 3, 1),FCE("ἦι", 2, 3, 2),FCE("Ĉ", 0, 2, 1),
FCE("ĉ", 1, 2, 1),FCE("𐲠", 0, 2, 1),FCE("𐳠", 1, 2, 1),FCE("Ṧ", 0, 2, 1),
FCE("ṧ", 1, 2, 1),FCE("Ẋ", 0, 2, 1),FCE("ẋ", 1, 2, 1),FCE("Ṍ", 0, 2, 1),
FCE("ṍ", 1, 2, 1),FCE("ή", 0, 2, 1),FCE("Ή", 1, 2, 1),FCE("Ⰾ", 0, 2, 1),
FCE("ⰾ", 1, 2, 1),FCE("Ṑ", 0, 2, 1),FCE("ṑ", 1, 2, 1),FCE("Ⓚ", 0, 2, 1),
FCE("ⓚ", 1, 2, 1),FCE("Ꝑ", 0, 2, 1),FCE("ꝑ", 1, 2, 1),FCE("Ú", 0, 2, 1),
FCE("ú", 1, 2, 1),FCE("ჩ", 0, 2, 1),FCE("Ჩ", 1, 2, 1),FCE("Ⳙ", 0, 2, 1),
FCE("ⳙ", 1, 2, 1),FCE("Ẹ", 0, 2, 1),FCE("ẹ", 1, 2, 1),FCE("Ĭ", 0, 2, 1),
FCE("ĭ", 1, 2, 1),FCE("ɒ", 0, 2, 1),FCE("Ɒ", 1, 2, 1),FCE("Ӄ", 0, 2, 1),
FCE("ӄ", 1, 2, 1),FCE("ΰ", 0, 3, 1),FCE("ΰ", 1, 3, 1),FCE("ΰ", 2, 3, 3),
FCE("Ⓞ", 0, 2, 1),FCE("ⓞ", 1, 2, 1),FCE("Ⰿ", 0, 2, 1),FCE("ⰿ", 1, 2, 1),
FCE("Գ", 0, 2, 1),FCE("գ", 1, 2, 1),FCE("ƕ", 0, 2, 1),FCE("Ƕ", 1, 2, 1),
FCE("ἓ", 0, 2, 1),FCE("Ἓ", 1, 2, 1),FCE("𐒸", 0, 2, 1),FCE("𐓠", 1, 2, 1),
FCE("Փ", 0, 2, 1),FCE("փ", 1, 2, 1),FCE("𐐥", 0, 2, 1),FCE("𐑍", 1, 2, 1),
FCE("Ꮡ", 0, 2, 1),FCE("ꮡ", 1, 2, 1),FCE("Ӵ", 0, 2, 1),FCE("ӵ", 1, 2, 1),
FCE("Ӈ", 0, 2, 1),FCE("ӈ", 1, 2, 1),FCE("𐒵", 0, 2, 1),FCE("𐓝", 1, 2, 1),
FCE("Ӑ", 0, 2, 1),FCE("ӑ", 1, 2, 1),FCE("Ꝝ", 0, 2, 1),FCE("ꝝ", 1, 2, 1),
FCE("𐲬", 0, 2, 1),FCE("𐳬", 1, 2, 1),FCE("Ḭ", 0, 2, 1),FCE("ḭ", 1, 2, 1),
FCE("Ⴈ", 0, 2, 1),FCE("ⴈ", 1, 2, 1),FCE("Ѥ", 0, 2, 1),FCE("ѥ", 1, 2, 1),
FCE("Ц", 0, 2, 1),FCE("ц", 1, 2, 1),FCE("Ӥ", 0, 2, 1),FCE("ӥ", 1, 2, 1),
FCE("ჭ", 0, 2, 1),FCE("Ჭ", 1, 2, 1),FCE("Ꞓ", 0, 2, 1),FCE("ꞓ", 1, 2, 1),
FCE("Ờ", 0, 2, 1),FCE("ờ", 1, 2, 1),FCE("𐒼", 0, 2, 1),FCE("𐓤", 1, 2, 1),
FCE("𐕷", 0, 2, 1),FCE("𐖞", 1, 2, 1),FCE("Ẩ", 0, 2, 1),FCE("ẩ", 1, 2, 1),
FCE("Ƹ", 0, 2, 1),FCE("ƹ", 1, 2, 1),FCE("Æ", 0, 2, 1),FCE("æ", 1, 2, 1),
FCE("Ｐ", 0, 2, 1),FCE("ｐ", 1, 2, 1),FCE("𖹄", 0, 2, 1),FCE("𖹤", 1, 2, 1),
FCE("𐐛", 0, 2, 1),FCE("𐑃", 1, 2, 1),FCE("Ḏ", 0, 2, 1),FCE("ḏ", 1, 2, 1),
FCE("Ӕ", 0, 2, 1),FCE("ӕ", 1, 2, 1),FCE("Ⲯ", 0, 2, 1),FCE("ⲯ", 1, 2, 1),
FCE("Ⱬ", 0, 2, 1),FCE("ⱬ", 1, 2, 1),FCE("Ｃ", 0, 2, 1),FCE("ｃ", 1, 2, 1),
FCE("Ƅ", 0, 2, 1),FCE("ƅ", 1, 2, 1),FCE("𐕳", 0, 2, 1),FCE("𐖚", 1, 2, 1),
FCE("Θ", 0, 4, 1),FCE("θ", 1, 4, 1),FCE("ϑ", 2, 4, 1),FCE("ϴ", 3, 4, 1),
FCE("Ꮤ", 0, 2, 1),FCE("ꮤ", 1, 2, 1),FCE("𞤙", 0, 2, 1),FCE("𞤻", 1, 2, 1),
FCE("Ƈ", 0, 2, 1),FCE("ƈ", 1, 2, 1),FCE("Ⱃ", 0, 2, 1),FCE("ⱃ", 1, 2, 1),
FCE("Ꞣ", 0, 2, 1),FCE("ꞣ", 1, 2, 1),FCE("Ɣ", 0, 2, 1),FCE("ɣ", 1, 2, 1),
FCE("Ж", 0, 2, 1),FCE("ж", 1, 2, 1),FCE("Ⲿ", 0, 2, 1),FCE("ⲿ", 1, 2, 1),
FCE("ᾦ", 0, 3, 1),FCE("ᾮ", 1, 3, 1),FCE("ὦι", 2, 3, 2),FCE("𐓆", 0, 2, 1),
FCE("𐓮", 1, 2, 1),FCE("ᾂ", 0, 3, 1),FCE("ᾊ", 1, 3, 1),FCE("ἂι", 2, 3, 2),
FCE("𐓉", 0, 2, 1),FCE("𐓱", 1, 2, 1),FCE("Ꮰ", 0, 2, 1),FCE("ꮰ", 1, 2, 1),
FCE("ɀ", 0, 2, 1),FCE("Ɀ", 1, 2, 1),FCE("Ꞿ", 0, 2, 1),FCE("ꞿ", 1, 2, 1),
FCE("ᾒ", 0, 3, 1),FCE("ᾚ", 1, 3, 1),FCE("ἢι", 2, 3, 2),FCE("Ђ", 0, 2, 1),
FCE("ђ", 1, 2, 1),FCE("Զ", 0, 2, 1),FCE("զ", 1, 2, 1),FCE("Ր", 0, 2, 1),
FCE("ր", 1, 2, 1),FCE("Ꚃ", 0, 2, 1),FCE("ꚃ", 1, 2, 1),FCE("Ά", 0, 2, 1),
FCE("ά", 1, 2, 1),FCE("ῥ", 0, 2, 1),FCE("Ῥ", 1, 2, 1),FCE("Ⓣ", 0, 2, 1),
FCE("ⓣ", 1, 2, 1),FCE("Ó", 0, 2, 1),FCE("ó", 1, 2, 1),FCE("ჰ", 0, 2, 1),
FCE("Ჰ", 1, 2, 1),FCE("Ḽ", 0, 2, 1),FCE("ḽ", 1, 2, 1),FCE("Ⲁ", 0, 2, 1),
FCE("ⲁ", 1, 2, 1),FCE("ᾗ", 0, 3, 1),FCE("ᾟ", 1, 3, 1),FCE("ἧι", 2, 3, 2),
FCE("𐖊", 0, 2, 1),FCE("𐖱", 1, 2, 1),FCE("Ŗ", 0, 2, 1),FCE("ŗ", 1, 2, 1),
FCE("Ṻ", 0, 2, 1),FCE("ṻ", 1, 2, 1),FCE("Ꮽ", 0, 2, 1),FCE("ꮽ", 1, 2, 1),
FCE("Ꜿ", 0, 2, 1),FCE("ꜿ", 1, 2, 1),FCE("Ę", 0, 2, 1),FCE("ę", 1, 2, 1),
FCE("Ȕ", 0, 2, 1),FCE("ȕ", 1, 2, 1),FCE("Ṡ", 0, 3, 1),FCE("ṡ", 1, 3, 1),
FCE("ẛ", 2, 3, 1),FCE("Ⲋ", 0, 2, 1),FCE("ⲋ", 1, 2, 1),FCE("Ꙍ", 0, 2, 1),
FCE("ꙍ", 1, 2, 1),FCE("Ε", 0, 3, 1),FCE("ε", 1, 3, 1),FCE("ϵ", 2, 3, 1),
FCE("Ǧ", 0, 2, 1),FCE("ǧ", 1, 2, 1),FCE("ᾅ", 0, 3, 1),FCE("ᾍ", 1, 3, 1),
FCE("ἅι", 2, 3, 2),FCE("Ԓ", 0, 2, 1),FCE("ԓ", 1, 2, 1),FCE("ὡ", 0, 2, 1),
FCE("Ὡ", 1, 2, 1),FCE("Ꙩ", 0, 2, 1),FCE("ꙩ", 1, 2, 1),FCE("𐖔", 0, 2, 1),
FCE("𐖻", 1, 2, 1),FCE("Ḙ", 0, 2, 1),FCE("ḙ", 1, 2, 1),FCE("Ꮂ", 0, 2, 1),
FCE("ꮂ", 1, 2, 1),FCE("𐐕", 0, 2, 1),FCE("𐐽", 1, 2, 1),FCE("𐐘", 0, 2, 1),
FCE("𐑀", 1, 2, 1),FCE("Ʌ", 0, 2, 1),FCE("ʌ", 1, 2, 1),FCE("ὲ", 0, 2, 1),
FCE("Ὲ", 1, 2, 1),FCE("𑢵", 0, 2, 1),FCE("𑣕", 1, 2, 1),FCE("Ⴘ", 0, 2, 1),
FCE("ⴘ", 1, 2, 1),FCE("Ӏ", 0, 2, 1),FCE("ӏ", 1, 2, 1),FCE("𐐋", 0, 2, 1),
FCE("𐐳", 1, 2, 1),FCE("У", 0, 2, 1),FCE("у", 1, 2, 1),FCE("Ⴥ", 0, 2, 1),
FCE("ⴥ", 1, 2, 1),FCE("Ⱝ", 0, 2, 1),FCE("ⱝ", 1, 2, 1),FCE("ἰ", 0, 2, 1),
FCE("Ἰ", 1, 2, 1),FCE("Ꮑ", 0, 2, 1),FCE("ꮑ", 1, 2, 1),FCE("Ꝭ", 0, 2, 1),
FCE("ꝭ", 1, 2, 1),FCE("𐓌", 0, 2, 1),FCE("𐓴", 1, 2, 1),FCE("ά", 0, 2, 1),
FCE("Ά", 1, 2, 1),FCE("Ｓ", 0, 2, 1),FCE("ｓ", 1, 2, 1),FCE("Ⅺ", 0, 2, 1),
FCE("ⅺ", 1, 2, 1),FCE("ŉ", 0, 2, 1),FCE("ʼn", 1, 2, 2),FCE("Ϩ", 0, 2, 1),
FCE("ϩ", 1, 2, 1),FCE("Ꟑ", 0, 2, 1),FCE("ꟑ", 1, 2, 1),FCE("Z", 0, 2, 1),
FCE("z", 1, 2, 1),FCE("𐲰", 0, 2, 1),FCE("𐳰", 1, 2, 1),FCE("Ǚ", 0, 2, 1),
FCE("ǚ", 1, 2, 1),FCE("Ọ", 0, 2, 1),FCE("ọ", 1, 2, 1),FCE("Ƶ", 0, 2, 1),
FCE("ƶ", 1, 2, 1),FCE("Ճ", 0, 2, 1),FCE("ճ", 1, 2, 1),FCE("ἢ", 0, 2, 1),
FCE("Ἢ", 1, 2, 1),FCE("𐖇", 0, 2, 1),FCE("𐖮", 1, 2, 1),FCE("Ạ", 0, 2, 1),
FCE("ạ", 1, 2, 1),FCE("𐲏", 0, 2, 1),FCE("𐳏", 1, 2, 1),FCE("𖹔", 0, 2, 1),
FCE("𖹴", 1, 2, 1),FCE("ᾴ", 0, 2, 1),FCE("άι", 1, 2, 2),FCE("ᵽ", 0, 2, 1),
FCE("Ᵽ", 1, 2, 1),FCE("Ꟗ", 0, 2, 1),FCE("ꟗ", 1, 2, 1),FCE("Ꝍ", 0, 2, 1),
FCE("ꝍ", 1, 2, 1),FCE("Ꮞ", 0, 2, 1),FCE("ꮞ", 1, 2, 1),FCE("Ï", 0, 2, 1),
FCE("ï", 1, 2, 1),FCE("კ", 0, 2, 1),FCE("Კ", 1, 2, 1),FCE("E", 0, 2, 1),
FCE("e", 1, 2, 1),FCE("Ķ", 0, 2, 1),FCE("ķ", 1, 2, 1),FCE("Ѝ", 0, 2, 1),
FCE("ѝ", 1, 2, 1),FCE("𖹃", 0, 2, 1),FCE("𖹣", 1, 2, 1),FCE("ὼ", 0, 2, 1),
FCE("Ὼ", 1, 2, 1),FCE("Ɋ", 0, 2, 1),FCE("ɋ", 1, 2, 1),FCE("Ҹ", 0, 2, 1),
FCE("ҹ", 1, 2, 1),FCE("Ⳋ", 0, 2, 1),FCE("ⳋ", 1, 2, 1),FCE("Ⳮ", 0, 2, 1),
FCE("ⳮ", 1, 2, 1),FCE("Ɵ", 0, 2, 1),FCE("ɵ", 1, 2, 1),FCE("Τ", 0, 2, 1),
FCE("τ", 1, 2, 1),FCE("ﬗ", 0, 2, 1),FCE("մխ", 1, 2, 2),FCE("Ꝏ", 0, 2, 1),
FCE("ꝏ", 1, 2, 1),FCE("𐓀", 0, 2, 1),FCE("𐓨", 1, 2, 1),FCE("Ḗ", 0, 2, 1),
FCE("ḗ", 1, 2, 1),FCE("Ꭿ", 0, 2, 1),FCE("ꭿ", 1, 2, 1),FCE("Ԁ", 0, 2, 1),
FCE("ԁ", 1, 2, 1),FCE("Ⲃ", 0, 2, 1),FCE("ⲃ", 1, 2, 1),FCE("Ⴝ", 0, 2, 1),
FCE("ⴝ", 1, 2, 1),FCE("𞤖", 0, 2, 1),FCE("𞤸", 1, 2, 1),FCE("𐲣", 0, 2, 1),
FCE("𐳣", 1, 2, 1),FCE("𐲔", 0, 2, 1),FCE("𐳔", 1, 2, 1),FCE("𐓂", 0, 2, 1),
FCE("𐓪", 1, 2, 1),FCE("Φ", 0, 3, 1),FCE("φ", 1, 3, 1),FCE("ϕ", 2, 3, 1),
FCE("ᾓ", 0, 3, 1),FCE("ᾛ", 1, 3, 1),FCE("ἣι", 2, 3, 2),FCE("𑢴", 0, 2, 1),
FCE("𑣔", 1, 2, 1),FCE("Ꮹ", 0, 2, 1),FCE("ꮹ", 1, 2, 1),FCE("𖹍", 0, 2, 1),
FCE("𖹭", 1, 2, 1),FCE("ὁ", 0, 2, 1),FCE("Ὁ", 1, 2, 1),FCE("ʇ", 0, 2, 1),
FCE("Ʇ", 1, 2, 1),FCE("Ղ", 0, 2, 1),FCE("ղ", 1, 2, 1),FCE("Ṙ", 0, 2, 1),
FCE("ṙ", 1, 2, 1),FCE("ὃ", 0, 2, 1),FCE("Ὃ", 1, 2, 1),FCE("ᾑ", 0, 3, 1),
FCE("ᾙ", 1, 3, 1),FCE("ἡι", 2, 3, 2),FCE("Ⳬ", 0, 2, 1),FCE("ⳬ", 1, 2, 1),
FCE("ῑ", 0, 2, 1),FCE("Ῑ", 1, 2, 1),FCE("Ứ", 0, 2, 1),FCE("ứ", 1, 2, 1),
FCE("Ꭳ", 0, 2, 1),FCE("ꭳ", 1, 2, 1),FCE("Ϯ", 0, 2, 1),FCE("ϯ", 1, 2, 1),
FCE("𑢸", 0, 2, 1),FCE("𑣘", 1, 2, 1),FCE("𐲞", 0, 2, 1),FCE("𐳞", 1, 2, 1),
FCE("Ꮻ", 0, 2, 1),FCE("ꮻ", 1, 2, 1),FCE("ÿ", 0, 2, 1),FCE("Ÿ", 1, 2, 1),
FCE("𐐗", 0, 2, 1),FCE("𐐿", 1, 2, 1),FCE("𑢩", 0, 2, 1),FCE("𑣉", 1, 2, 1),
FCE("ᾰ", 0, 2, 1),FCE("Ᾰ", 1, 2, 1),FCE("Ⲉ", 0, 2, 1),FCE("ⲉ", 1, 2, 1),
FCE("Ꭹ", 0, 2, 1),FCE("ꭹ", 1, 2, 1),FCE("𞤉", 0, 2, 1),FCE("𞤫", 1, 2, 1),
FCE("Ꮒ", 0, 2, 1),FCE("ꮒ", 1, 2, 1),FCE("Ⓐ", 0, 2, 1),FCE("ⓐ", 1, 2, 1),
FCE("Ṟ", 0, 2, 1),FCE("ṟ", 1, 2, 1),FCE("Ⱪ", 0, 2, 1),FCE("ⱪ", 1, 2, 1),
FCE("𐐟", 0, 2, 1),FCE("𐑇", 1, 2, 1),FCE("Ϳ", 0, 2, 1),FCE("ϳ", 1, 2, 1),
FCE("Հ", 0, 2, 1),FCE("հ", 1, 2, 1),FCE("ΐ", 0, 3, 1),FCE("ΐ", 1, 3, 1),
FCE("ΐ", 2, 3, 3),FCE("K", 0, 3, 1),FCE("k", 1, 3, 1),FCE("K", 2, 3, 1),
FCE("Ӹ", 0, 2, 1),FCE("ӹ", 1, 2, 1),FCE("Ᏻ", 0, 2, 1),FCE("ᏻ", 1, 2, 1),
FCE("É", 0, 2, 1),FCE("é", 1, 2, 1),FCE("Џ", 0, 2, 1),FCE("џ", 1, 2, 1),
FCE("Ⴕ", 0, 2, 1),FCE("ⴕ", 1, 2, 1),FCE("Ꝇ", 0, 2, 1),FCE("ꝇ", 1, 2, 1),
FCE("Í", 0, 2, 1),FCE("í", 1, 2, 1),FCE("Ѷ", 0, 2, 1),FCE("ѷ", 1, 2, 1),
FCE("Ξ", 0, 2, 1),FCE("ξ", 1, 2, 1),FCE("ἠ", 0, 2, 1),FCE("Ἠ", 1, 2, 1),
FCE("ჺ", 0, 2, 1),FCE("Ჺ", 1, 2, 1),FCE("Ⱑ", 0, 2, 1),FCE("ⱑ", 1, 2, 1),
FCE("Ầ", 0, 2, 1),FCE("ầ", 1, 2, 1),FCE("ᾃ", 0, 3, 1),FCE("ᾋ", 1, 3, 1),
FCE("ἃι", 2, 3, 2),FCE("Լ", 0, 2, 1),FCE("լ", 1, 2, 1),FCE("ἁ", 0, 2, 1),
FCE("Ἁ", 1, 2, 1),FCE("Ⳃ", 0, 2, 1),FCE("ⳃ", 1, 2, 1),FCE("Ȉ", 0, 2, 1),
FCE("ȉ", 1, 2, 1),FCE("Ꮳ", 0, 2, 1),FCE("ꮳ", 1, 2, 1),FCE("Ꞗ", 0, 2, 1),
FCE("ꞗ", 1, 2, 1),FCE("ὤ", 0, 2, 1),FCE("Ὤ", 1, 2, 1),FCE("𐖒", 0, 2, 1),
FCE("𐖹", 1, 2, 1),FCE("Ҿ", 0, 2, 1),FCE("ҿ", 1, 2, 1),FCE("ᾑ", 0, 3, 1),
FCE("ᾙ", 1, 3, 1),FCE("ἡι", 2, 3, 2),FCE("Ϧ", 0, 2, 1),FCE("ϧ", 1, 2, 1),
FCE("Ỡ", 0, 2, 1),FCE("ỡ", 1, 2, 1),FCE("ῳ", 0, 3, 1),FCE("ῼ", 1, 3, 1),
FCE("ωι", 2, 3, 2),FCE("İ", 0, 2, 1),FCE("i̇", 1, 2, 2),FCE("Г", 0, 2, 1),
FCE("г", 1, 2, 1),FCE("ẘ", 0, 2, 1),FCE("ẘ", 1, 2, 2),FCE("Ю", 0, 2, 1),
FCE("ю", 1, 2, 1),FCE("მ", 0, 2, 1),FCE("Მ", 1, 2, 1),FCE("ჶ", 0, 2, 1),
FCE("Ჶ", 1, 2, 1),FCE("Ⰰ", 0, 2, 1),FCE("ⰰ", 1, 2, 1),FCE("𑢾", 0, 2, 1),
FCE("𑣞", 1, 2, 1),FCE("Ƨ", 0, 2, 1),FCE("ƨ", 1, 2, 1),FCE("Ⴣ", 0, 2, 1),
FCE("ⴣ", 1, 2, 1),FCE("Е", 0, 2, 1),FCE("е", 1, 2, 1),FCE("Ḟ", 0, 2, 1),
FCE("ḟ", 1, 2, 1),FCE("Ԇ", 0, 2, 1),FCE("ԇ", 1, 2, 1),FCE("Ṥ", 0, 2, 1),
FCE("ṥ", 1, 2, 1),FCE("Ç", 0, 2, 1),FCE("ç", 1, 2, 1),FCE("Ѽ", 0, 2, 1),
FCE("ѽ", 1, 2, 1),FCE("Ṓ", 0, 2, 1),FCE("ṓ", 1, 2, 1),FCE("ჴ", 0, 2, 1),
FCE("Ჴ", 1, 2, 1),FCE("𐖆", 0, 2, 1),FCE("𐖭", 1, 2, 1),FCE("Ѫ", 0, 2, 1),
FCE("ѫ", 1, 2, 1),FCE("Ⱗ", 0, 2, 1),FCE("ⱗ", 1, 2, 1),FCE("𐓊", 0, 2, 1),
FCE("𐓲", 1, 2, 1),FCE("Ⴂ", 0, 2, 1),FCE("ⴂ", 1, 2, 1),FCE("𐲉", 0, 2, 1),
FCE("𐳉", 1, 2, 1),FCE("Ｒ", 0, 2, 1),FCE("ｒ", 1, 2, 1),FCE("Θ", 0, 4, 1),
FCE("θ", 1, 4, 1),FCE("ϑ", 2, 4, 1),FCE("ϴ", 3, 4, 1),FCE("Ω", 0, 3, 1),
FCE("ω", 1, 3, 1),FCE("Ω", 2, 3, 1),FCE("Ớ", 0, 2, 1),FCE("ớ", 1, 2, 1),
FCE("𞤁", 0, 2, 1),FCE("𞤣", 1, 2, 1),FCE("Ꞝ", 0, 2, 1),FCE("ꞝ", 1, 2, 1),
FCE("დ", 0, 2, 1),FCE("Დ", 1, 2, 1),FCE("Ⓖ", 0, 2, 1),FCE("ⓖ", 1, 2, 1),
FCE("Ｏ", 0, 2, 1),FCE("ｏ", 1, 2, 1),FCE("ɐ", 0, 2, 1),FCE("Ɐ", 1, 2, 1),
FCE("Ⱙ", 0, 2, 1),FCE("ⱙ", 1, 2, 1),FCE("𞤠", 0, 2, 1),FCE("𞥂", 1, 2, 1),
FCE("Ҳ", 0, 2, 1),FCE("ҳ", 1, 2, 1),FCE("𐐙", 0, 2, 1),FCE("𐑁", 1, 2, 1),
FCE("Ȑ", 0, 2, 1),FCE("ȑ", 1, 2, 1),FCE("Ⱅ", 0, 2, 1),FCE("ⱅ", 1, 2, 1),
FCE("𖹇", 0, 2, 1),FCE("𖹧", 1, 2, 1),FCE("Ꝕ", 0, 2, 1),FCE("ꝕ", 1, 2, 1),
FCE("𖹅", 0, 2, 1),FCE("𖹥", 1, 2, 1),FCE("Ǉ", 0, 3, 1),FCE("ǈ", 1, 3, 1),
FCE("ǉ", 2, 3, 1),FCE("Ѿ", 0, 2, 1),FCE("ѿ", 1, 2, 1),FCE("Ǽ", 0, 2, 1),
FCE("ǽ", 1, 2, 1),FCE("Ȏ", 0, 2, 1),FCE("ȏ", 1, 2, 1),FCE("Ʉ", 0, 2, 1),
FCE("ʉ", 1, 2, 1),FCE("ί", 0, 2, 1),FCE("Ί", 1, 2, 1),FCE("Ⳗ", 0, 2, 1),
FCE("ⳗ", 1, 2, 1),FCE("𐖉", 0, 2, 1),FCE("𐖰", 1, 2, 1),FCE("Т", 0, 4, 1),
FCE("т", 1, 4, 1),FCE("ᲄ", 2, 4, 1),FCE("ᲅ", 3, 4, 1),FCE("ყ", 0, 2, 1),
FCE("Ყ", 1, 2, 1),FCE("Ӻ", 0, 2, 1),FCE("ӻ", 1, 2, 1),FCE("ვ", 0, 2, 1),
FCE("Ვ", 1, 2, 1),FCE("Ậ", 0, 2, 1),FCE("ậ", 1, 2, 1),FCE("Ⴗ", 0, 2, 1),
FCE("ⴗ", 1, 2, 1),FCE("Ꭱ", 0, 2, 1),FCE("ꭱ", 1, 2, 1),FCE("Ꟃ", 0, 2, 1),
FCE("ꟃ", 1, 2, 1),FCE("𞤇", 0, 2, 1),FCE("𞤩", 1, 2, 1),FCE("Ᏽ", 0, 2, 1),
FCE("ᏽ", 1, 2, 1),FCE("Ợ", 0, 2, 1),FCE("ợ", 1, 2, 1),FCE("ὢ", 0, 2, 1),
FCE("Ὢ", 1, 2, 1),FCE("Ẓ", 0, 2, 1),FCE("ẓ", 1, 2, 1),FCE("Ǖ", 0, 2, 1),
FCE("ǖ", 1, 2, 1),FCE("Ⰶ", 0, 2, 1),FCE("ⰶ", 1, 2, 1),FCE("𐲋", 0, 2, 1),
FCE("𐳋", 1, 2, 1),FCE("ὰ", 0, 2, 1),FCE("Ὰ", 1, 2, 1),FCE("Ϭ", 0, 2, 1),
FCE("ϭ", 1, 2, 1),FCE("𞤕", 0, 2, 1),FCE("𞤷", 1, 2, 1),FCE("Ⅾ", 0, 2, 1),
FCE("ⅾ", 1, 2, 1),FCE("Ꮐ", 0, 2, 1),FCE("ꮐ", 1, 2, 1),FCE("Ỵ", 0, 2, 1),
FCE("ỵ", 1, 2, 1),FCE("ᾲ", 0, 2, 1),FCE("ὰι", 1, 2, 2),FCE("Ｚ", 0, 2, 1),
FCE("ｚ", 1, 2, 1),FCE("𑢼", 0, 2, 1),FCE("𑣜", 1, 2, 1),FCE("Ҫ", 0, 2, 1),
FCE("ҫ", 1, 2, 1),FCE("Ⅳ", 0, 2, 1),FCE("ⅳ", 1, 2, 1),FCE("Ḝ", 0, 2, 1),
FCE("ḝ", 1, 2, 1),FCE("Ꮘ", 0, 2, 1),FCE("ꮘ", 1, 2, 1),FCE("𑢯", 0, 2, 1),
FCE("𑣏", 1, 2, 1),FCE("ẚ", 0, 2, 1),FCE("aʾ", 1, 2, 2),FCE("𐕱", 0, 2, 1),
FCE("𐖘", 1, 2, 1),FCE("𐲧", 0, 2, 1),FCE("𐳧", 1, 2, 1),FCE("𐲘", 0, 2, 1),
FCE("𐳘", 1, 2, 1),FCE("Q", 0, 2, 1),FCE("q", 1, 2, 1),FCE("Ӳ", 0, 2, 1),
FCE("ӳ", 1, 2, 1),FCE("𐲪", 0, 2, 1),FCE("𐳪", 1, 2, 1),FCE("Ⴏ", 0, 2, 1),
FCE("ⴏ", 1, 2, 1),FCE("Ⲏ", 0, 2, 1),FCE("ⲏ", 1, 2, 1),FCE("Ⳅ", 0, 2, 1),
FCE("ⳅ", 1, 2, 1),FCE("Ḋ", 0, 2, 1),FCE("ḋ", 1, 2, 1),FCE("ﬕ", 0, 2, 1),
FCE("մի", 1, 2, 2),FCE("𖹐", 0, 2, 1),FCE("𖹰", 1, 2, 1),FCE("𐖎", 0, 2, 1),
FCE("𐖵", 1, 2, 1),FCE("𐐑", 0, 2, 1),FCE("𐐹", 1, 2, 1),FCE("𐐣", 0, 2, 1),
FCE("𐑋", 1, 2, 1),FCE("Ժ", 0, 2, 1),FCE("ժ", 1, 2, 1),FCE("Ṭ", 0, 2, 1),
FCE("ṭ", 1, 2, 1),FCE("𐒾", 0, 2, 1),FCE("𐓦", 1, 2, 1),FCE("𐐤", 0, 2, 1),
FCE("𐑌", 1, 2, 1),FCE("Ⴉ", 0, 2, 1),FCE("ⴉ", 1, 2, 1),FCE("Ⓜ", 0, 2, 1),
FCE("ⓜ", 1, 2, 1),FCE("𐲁", 0, 2, 1),FCE("𐳁", 1, 2, 1),FCE("Ꮌ", 0, 2, 1),
FCE("ꮌ", 1, 2, 1),FCE("Ѣ", 0, 3, 1),FCE("ѣ", 1, 3, 1),FCE("ᲇ", 2, 3, 1),
FCE("𑢦", 0, 2, 1),FCE("𑣆", 1, 2, 1),FCE("Ṋ", 0, 2, 1),FCE("ṋ", 1, 2, 1),
FCE("Ⅲ", 0, 2, 1),FCE("ⅲ", 1, 2, 1),FCE("Ổ", 0, 2, 1),FCE("ổ", 1, 2, 1),
FCE("Ⴊ", 0, 2, 1),FCE("ⴊ", 1, 2, 1),FCE("Ӭ", 0, 2, 1),FCE("ӭ", 1, 2, 1),
FCE("Ⰼ", 0, 2, 1),FCE("ⰼ", 1, 2, 1),FCE("Ꞛ", 0, 2, 1),FCE("ꞛ", 1, 2, 1),
FCE("Ӌ", 0, 2, 1),FCE("ӌ", 1, 2, 1),FCE("𐒽", 0, 2, 1),FCE("𐓥", 1, 2, 1),
FCE("Ͱ", 0, 2, 1),FCE("ͱ", 1, 2, 1),FCE("ῧ", 0, 2, 1),FCE("ῧ", 1, 2, 3),
FCE("𞤔", 0, 2, 1),FCE("𞤶", 1, 2, 1),FCE("Ϛ", 0, 2, 1),FCE("ϛ", 1, 2, 1),
FCE("ἵ", 0, 2, 1),FCE("Ἵ", 1, 2, 1),FCE("𖹑", 0, 2, 1),FCE("𖹱", 1, 2, 1),
FCE("Β", 0, 3, 1),FCE("β", 1, 3, 1),FCE("ϐ", 2, 3, 1),FCE("Ⲗ", 0, 2, 1),
FCE("ⲗ", 1, 2, 1),FCE("ᾥ", 0, 3, 1),FCE("ᾭ", 1, 3, 1),FCE("ὥι", 2, 3, 2),
FCE("Α", 0, 2, 1),FCE("α", 1, 2, 1),FCE("Դ", 0, 2, 1),FCE("դ", 1, 2, 1),
FCE("Л", 0, 2, 1),FCE("л", 1, 2, 1),FCE("Ꮯ", 0, 2, 1),FCE("ꮯ", 1, 2, 1),
FCE("Ⱜ", 0, 2, 1),FCE("ⱜ", 1, 2, 1),FCE("Ĥ", 0, 2, 1),FCE("ĥ", 1, 2, 1),
FCE("𐲢", 0, 2, 1),FCE("𐳢", 1, 2, 1),FCE("Ẍ", 0, 2, 1),FCE("ẍ", 1, 2, 1),
FCE("Ẵ", 0, 2, 1),FCE("ẵ", 1, 2, 1),FCE("Ŭ", 0, 2, 1),FCE("ŭ", 1, 2, 1),
FCE("Ḃ", 0, 2, 1),FCE("ḃ", 1, 2, 1),FCE("ƚ", 0, 2, 1),FCE("Ƚ", 1, 2, 1),
FCE("Ă", 0, 2, 1),FCE("ă", 1, 2, 1),FCE("ἔ", 0, 2, 1),FCE("Ἔ", 1, 2, 1),
FCE("Ｈ", 0, 2, 1),FCE("ｈ", 1, 2, 1),FCE("𐲀", 0, 2, 1),FCE("𐳀", 1, 2, 1),
FCE("ხ", 0, 2, 1),FCE("Ხ", 1, 2, 1),FCE("ὕ", 0, 2, 1),FCE("Ὕ", 1, 2, 1),
FCE("Ꝼ", 0, 2, 1),FCE("ꝼ", 1, 2, 1),FCE("ῇ", 0, 2, 1),FCE("ῆι", 1, 2, 3),
FCE("Y", 0, 2, 1),FCE("y", 1, 2, 1),FCE("Ŋ", 0, 2, 1),FCE("ŋ", 1, 2, 1),
FCE("Ḥ", 0, 2, 1),FCE("ḥ", 1, 2, 1),FCE("Ꮍ", 0, 2, 1),FCE("ꮍ", 1, 2, 1),
FCE("Ⲽ", 0, 2, 1),FCE("ⲽ", 1, 2, 1),FCE("𐐍", 0, 2, 1),FCE("𐐵", 1, 2, 1),
FCE("𐖏", 0, 2, 1),FCE("𐖶", 1, 2, 1),FCE("𑢧", 0, 2, 1),FCE("𑣇", 1, 2, 1),
FCE("Ꙡ", 0, 2, 1),FCE("ꙡ", 1, 2, 1),FCE("Ԕ", 0, 2, 1),FCE("ԕ", 1, 2, 1),
FCE("Ԯ", 0, 2, 1),FCE("ԯ", 1, 2, 1),FCE("Ҥ", 0, 2, 1),FCE("ҥ", 1, 2, 1),
FCE("Ѐ", 0, 2, 1),FCE("ѐ", 1, 2, 1),FCE("𖹘", 0, 2, 1),FCE("𖹸", 1, 2, 1),
FCE("Ꙏ", 0, 2, 1),FCE("ꙏ", 1, 2, 1),FCE("Ｎ", 0, 2, 1),FCE("ｎ", 1, 2, 1),
FCE("𐐌", 0, 2, 1),FCE("𐐴", 1, 2, 1),FCE("Û", 0, 2, 1),FCE("û", 1, 2, 1),
FCE("Ǎ", 0, 2, 1),FCE("ǎ", 1, 2, 1),FCE("შ", 0, 2, 1),FCE("Შ", 1, 2, 1),
FCE("Տ", 0, 2, 1),FCE("տ", 1, 2, 1),FCE("Ꜹ", 0, 2, 1),FCE("ꜹ", 1, 2, 1),
FCE("𖹟", 0, 2, 1),FCE("𖹿", 1, 2, 1),FCE("ᾦ", 0, 3, 1),FCE("ᾮ", 1, 3, 1),
FCE("ὦι", 2, 3, 2),FCE("𞤏", 0, 2, 1),FCE("𞤱", 1, 2, 1),FCE("Ⰷ", 0, 2, 1),
FCE("ⰷ", 1, 2, 1),FCE("Ⴃ", 0, 2, 1),FCE("ⴃ", 1, 2, 1),FCE("Ꞡ", 0, 2, 1),
FCE("ꞡ", 1, 2, 1),FCE("С", 0, 3, 1),FCE("с", 1, 3, 1),FCE("ᲃ", 2, 3, 1),
FCE("Ꚁ", 0, 2, 1),FCE("ꚁ", 1, 2, 1),FCE("ʂ", 0, 2, 1),FCE("Ʂ", 1, 2, 1),
FCE("ᵹ", 0, 2, 1),FCE("Ᵹ", 1, 2, 1),FCE("Ⓥ", 0, 2, 1),FCE("ⓥ", 1, 2, 1),
FCE("Ё", 0, 2, 1),FCE("ё", 1, 2, 1),FCE("Ꝙ", 0, 2, 1),FCE("ꝙ", 1, 2, 1),
FCE("X", 0, 2, 1),FCE("x", 1, 2, 1),FCE("Ɠ", 0, 2, 1),FCE("ɠ", 1, 2, 1),
FCE("𐲡", 0, 2, 1),FCE("𐳡", 1, 2, 1),FCE("Վ", 0, 2, 1),FCE("վ", 1, 2, 1),
FCE("Ɔ", 0, 2, 1),FCE("ɔ", 1, 2, 1),FCE("Ꮬ", 0, 2, 1),FCE("ꮬ", 1, 2, 1),
FCE("Ⓗ", 0, 2, 1),FCE("ⓗ", 1, 2, 1),FCE("Ƴ", 0, 2, 1),FCE("ƴ", 1, 2, 1),
FCE("Ꚗ", 0, 2, 1),FCE("ꚗ", 1, 2, 1),FCE("Ȗ", 0, 2, 1),FCE("ȗ", 1, 2, 1),
FCE("Ỏ", 0, 2, 1),FCE("ỏ", 1, 2, 1),FCE("Ⅸ", 0, 2, 1),FCE("ⅸ", 1, 2, 1),
FCE("ῆ", 0, 2, 1),FCE("ῆ", 1, 2, 2),FCE("Ⱂ", 0, 2, 1),FCE("ⱂ", 1, 2, 1),
FCE("Ⱟ", 0, 2, 1),FCE("ⱟ", 1, 2, 1),FCE("𞤎", 0, 2, 1),FCE("𞤰", 1, 2, 1),
FCE("𐲫", 0, 2, 1),FCE("𐳫", 1, 2, 1),FCE("Ẇ", 0, 2, 1),FCE("ẇ", 1, 2, 1),
FCE("В", 0, 3, 1),FCE("в", 1, 3, 1),FCE("ᲀ", 2, 3, 1),FCE("Ꮦ", 0, 2, 1),
FCE("ꮦ", 1, 2, 1),FCE("Ẻ", 0, 2, 1),FCE("ẻ", 1, 2, 1),FCE("𞤛", 0, 2, 1),
FCE("𞤽", 1, 2, 1),FCE("𐐚", 0, 2, 1),FCE("𐑂", 1, 2, 1),FCE("Ữ", 0, 2, 1),
FCE("ữ", 1, 2, 1),FCE("Ｑ", 0, 2, 1),FCE("ｑ", 1, 2, 1),FCE("Ꞽ", 0, 2, 1),
FCE("ꞽ", 1, 2, 1),FCE("Ǜ", 0, 2, 1),FCE("ǜ", 1, 2, 1),FCE("Ʀ", 0, 2, 1),
FCE("ʀ", 1, 2, 1),FCE("ἇ", 0, 2, 1),FCE("Ἇ", 1, 2, 1),FCE("𑢽", 0, 2, 1),
FCE("𑣝", 1, 2, 1),FCE("È", 0, 2, 1),FCE("è", 1, 2, 1),FCE("Ӓ", 0, 2, 1),
FCE("ӓ", 1, 2, 1),FCE("ს", 0, 2, 1),FCE("Ს", 1, 2, 1),FCE("Ꮇ", 0, 2, 1),
FCE("ꮇ", 1, 2, 1),FCE("𐖅", 0, 2, 1),FCE("𐖬", 1, 2, 1),FCE("𖹋", 0, 2, 1),
FCE("𖹫", 1, 2, 1),FCE("Ų", 0, 2, 1),FCE("ų", 1, 2, 1),FCE("Ҟ", 0, 2, 1),
FCE("ҟ", 1, 2, 1),FCE("Ӧ", 0, 2, 1),FCE("ӧ", 1, 2, 1),FCE("Ⴐ", 0, 2, 1),
FCE("ⴐ", 1, 2, 1),FCE("ẙ", 0, 2, 1),FCE("ẙ", 1, 2, 2),FCE("Ǯ", 0, 2, 1),
FCE("ǯ", 1, 2, 1),FCE("Ⲝ", 0, 2, 1),FCE("ⲝ", 1, 2, 1),FCE("𐒴", 0, 2, 1),
FCE("𐓜", 1, 2, 1),FCE("𐲇", 0, 2, 1),FCE("𐳇", 1, 2, 1),FCE("Ꮊ", 0, 2, 1),
FCE("ꮊ", 1, 2, 1),FCE("Ḑ", 0, 2, 1),FCE("ḑ", 1, 2, 1),FCE("Ȱ", 0, 2, 1),
FCE("ȱ", 1, 2, 1),FCE("Ш", 0, 2, 1),FCE("ш", 1, 2, 1),FCE("Ⳑ", 0, 2, 1),
FCE("ⳑ", 1, 2, 1),FCE("𑢠", 0, 2, 1),FCE("𑣀", 1, 2, 1),FCE("Ϡ", 0, 2, 1),
FCE("ϡ", 1, 2, 1),FCE("ῴ", 0, 2, 1),FCE("ώι", 1, 2, 2),FCE("Ꞁ", 0, 2, 1),
FCE("ꞁ", 1, 2, 1),FCE("ჵ", 0, 2, 1),FCE("Ჵ", 1, 2, 1),FCE("Ի", 0, 2, 1),
FCE("ի", 1, 2, 1),FCE("Õ", 0, 2, 1),FCE("õ", 1, 2, 1),FCE("𐖈", 0, 2, 1),
FCE("𐖯", 1, 2, 1),FCE("Д", 0, 3, 1),FCE("д", 1, 3, 1),FCE("ᲁ", 2, 3, 1),
FCE("ᾤ", 0, 3, 1),FCE("ᾬ", 1, 3, 1),FCE("ὤι", 2, 3, 2),FCE("Ī", 0, 2, 1),
FCE("ī", 1, 2, 1),FCE("R", 0, 2, 1),FCE("r", 1, 2, 1),FCE("Ⓑ", 0, 2, 1),
FCE("ⓑ", 1, 2, 1),FCE("𞤈", 0, 2, 1),FCE("𞤪", 1, 2, 1),FCE("Θ", 0, 4, 1),
FCE("θ", 1, 4, 1),FCE("ϑ", 2, 4, 1),FCE("ϴ", 3, 4, 1),FCE("Ȃ", 0, 2, 1),
FCE("ȃ", 1, 2, 1),FCE("ᾅ", 0, 3, 1),FCE("ᾍ", 1, 3, 1),FCE("ἅι", 2, 3, 2),
FCE("Ѱ", 0, 2, 1),FCE("ѱ", 1, 2, 1),FCE("ɱ", 0, 2, 1),FCE("Ɱ", 1, 2, 1),
FCE("Ⱋ", 0, 2, 1),FCE("ⱋ", 1, 2, 1),FCE("ﬃ", 0, 2, 1),FCE("ffi", 1, 2, 3),
FCE("Ҋ", 0, 2, 1),FCE("ҋ", 1, 2, 1),FCE("Ꝓ", 0, 2, 1),FCE("ꝓ", 1, 2, 1),
FCE("Ｅ", 0, 2, 1),FCE("ｅ", 1, 2, 1),FCE("Ї", 0, 2, 1),FCE("ї", 1, 2, 1),
FCE("Á", 0, 2, 1),FCE("á", 1, 2, 1),FCE("Ṅ", 0, 2, 1),FCE("ṅ", 1, 2, 1),
FCE("ᾗ", 0, 3, 1),FCE("ᾟ", 1, 3, 1),FCE("ἧι", 2, 3, 2),FCE("Ո", 0, 2, 1),
FCE("ո", 1, 2, 1),FCE("Ȝ", 0, 2, 1),FCE("ȝ", 1, 2, 1),FCE("Ꮵ", 0, 2, 1),
FCE("ꮵ", 1, 2, 1),FCE("Ԛ", 0, 2, 1),FCE("ԛ", 1, 2, 1),FCE("Ⲷ", 0, 2, 1),
FCE("ⲷ", 1, 2, 1),FCE("Ꙕ", 0, 2, 1),FCE("ꙕ", 1, 2, 1),FCE("𐐃", 0, 2, 1),
FCE("𐐫", 1, 2, 1),FCE("Ṳ", 0, 2, 1),FCE("ṳ", 1, 2, 1),FCE("ე", 0, 2, 1),
FCE("Ე", 1, 2, 1),FCE("𐓁", 0, 2, 1),FCE("𐓩", 1, 2, 1),FCE("𐲊", 0, 2, 1),
FCE("𐳊", 1, 2, 1),FCE("Ḫ", 0, 2, 1),FCE("ḫ", 1, 2, 1),FCE("Ѣ", 0, 3, 1),
FCE("ѣ", 1, 3, 1),FCE("ᲇ", 2, 3, 1),FCE("ὶ", 0, 2, 1),FCE("Ὶ", 1, 2, 1),
FCE("S", 0, 3, 1),FCE("s", 1, 3, 1),FCE("ſ", 2, 3, 1),FCE("Ⱖ", 0, 2, 1),
FCE("ⱖ", 1, 2, 1),FCE("Ꭰ", 0, 2, 1),FCE("ꭰ", 1, 2, 1),FCE("Ϻ", 0, 2, 1),
FCE("ϻ", 1, 2, 1),FCE("Ӆ", 0, 2, 1),FCE("ӆ", 1, 2, 1),FCE("ᾒ", 0, 3, 1),
FCE("ᾚ", 1, 3, 1),FCE("ἢι", 2, 3, 2),FCE("Օ", 0, 2, 1),FCE("օ", 1, 2, 1),
FCE("Ꮸ", 0, 2, 1),FCE("ꮸ", 1, 2, 1),FCE("Ǉ", 0, 3, 1),FCE("ǈ", 1, 3, 1),
FCE("ǉ", 2, 3, 1),FCE("ὂ", 0, 2, 1),FCE("Ὂ", 1, 2, 1),FCE("ὧ", 0, 2, 1),
FCE("Ὧ", 1, 2, 1),FCE("𐕼", 0, 2, 1),FCE("𐖣", 1, 2, 1),FCE("Ꞵ", 0, 2, 1),
FCE("ꞵ", 1, 2, 1),FCE("Ꚙ", 0, 2, 1),FCE("ꚙ", 1, 2, 1),FCE("𞤄", 0, 2, 1),
FCE("𞤦", 1, 2, 1),FCE("Ќ", 0, 2, 1),FCE("ќ", 1, 2, 1),FCE("ლ", 0, 2, 1),
FCE("Ლ", 1, 2, 1),FCE("ῖ", 0, 2, 1),FCE("ῖ", 1, 2, 2),FCE("Ð", 0, 2, 1),
FCE("ð", 1, 2, 1),FCE("𖹆", 0, 2, 1),FCE("𖹦", 1, 2, 1),FCE("Ể", 0, 2, 1),
FCE("ể", 1, 2, 1),FCE("Ǥ", 0, 2, 1),FCE("ǥ", 1, 2, 1),FCE("D", 0, 2, 1),
FCE("d", 1, 2, 1),FCE("Ž", 0, 2, 1),FCE("ž", 1, 2, 1),FCE("ἡ", 0, 2, 1),
FCE("Ἡ", 1, 2, 1),FCE("Ｙ", 0, 2, 1),FCE("ｙ", 1, 2, 1),FCE("Ꭼ", 0, 2, 1),
FCE("ꭼ", 1, 2, 1),FCE("և", 0, 2, 1),FCE("եւ", 1, 2, 2),FCE("ἀ", 0, 2, 1),
FCE("Ἀ", 1, 2, 1),FCE("Υ", 0, 2, 1),FCE("υ", 1, 2, 1),FCE("Ř", 0, 2, 1),
FCE("ř", 1, 2, 1),FCE("𐓏", 0, 2, 1),FCE("𐓷", 1, 2, 1),FCE("Ḻ", 0, 2, 1),
FCE("ḻ", 1, 2, 1),FCE("Ꜭ", 0, 2, 1),FCE("ꜭ", 1, 2, 1),FCE("𑢷", 0, 2, 1),
FCE("𑣗", 1, 2, 1),FCE("Ē", 0, 2, 1),FCE("ē", 1, 2, 1),FCE("Ḷ", 0, 2, 1),
FCE("ḷ", 1, 2, 1),FCE("𖹎", 0, 2, 1),FCE("𖹮", 1, 2, 1),FCE("ώ", 0, 2, 1),
FCE("Ώ", 1, 2, 1),FCE("Ҕ", 0, 2, 1),FCE("ҕ", 1, 2, 1),FCE("Ẁ", 0, 2, 1),
FCE("ẁ", 1, 2, 1),FCE("Ė", 0, 2, 1),FCE("ė", 1, 2, 1),FCE("Э", 0, 2, 1),
FCE("э", 1, 2, 1),FCE("Ᏺ", 0, 2, 1),FCE("ᏺ", 1, 2, 1),FCE("Ź", 0, 2, 1),
FCE("ź", 1, 2, 1),FCE("Ӛ", 0, 2, 1),FCE("ӛ", 1, 2, 1),FCE("Ⲩ", 0, 2, 1),
FCE("ⲩ", 1, 2, 1),FCE("Ì", 0, 2, 1),FCE("ì", 1, 2, 1),FCE("Ƣ", 0, 2, 1),
FCE("ƣ", 1, 2, 1),FCE("Ρ", 0, 3, 1),FCE("ρ", 1, 3, 1),FCE("ϱ", 2, 3, 1),
FCE("Ṽ", 0, 2, 1),FCE("ṽ", 1, 2, 1),FCE("Ꮟ", 0, 2, 1),FCE("ꮟ", 1, 2, 1),
FCE("𐐒", 0, 2, 1),FCE("𐐺", 1, 2, 1),FCE("Ԡ", 0, 2, 1),FCE("ԡ", 1, 2, 1),
FCE("Ⱌ", 0, 2, 1),FCE("ⱌ", 1, 2, 1),FCE("ɫ", 0, 2, 1),FCE("Ɫ", 1, 2, 1),
FCE("ﬔ", 0, 2, 1),FCE("մե", 1, 2, 2),FCE("Ŝ", 0, 2, 1),FCE("ŝ", 1, 2, 1),
FCE("Ꙓ", 0, 2, 1),FCE("ꙓ", 1, 2, 1),FCE("Ｆ", 0, 2, 1),FCE("ｆ", 1, 2, 1),
FCE("Ǩ", 0, 2, 1),FCE("ǩ", 1, 2, 1),FCE("Ⴖ", 0, 2, 1),FCE("ⴖ", 1, 2, 1),
FCE("Ꙗ", 0, 2, 1),FCE("ꙗ", 1, 2, 1),FCE("Ԝ", 0, 2, 1),FCE("ԝ", 1, 2, 1),
FCE("Ꮓ", 0, 2, 1),FCE("ꮓ", 1, 2, 1),FCE("𐖑", 0, 2, 1),FCE("𐖸", 1, 2, 1),
FCE("𐓋", 0, 2, 1),FCE("𐓳", 1, 2, 1),FCE("Ệ", 0, 2, 1),FCE("ệ", 1, 2, 1),
FCE("Ǡ", 0, 2, 1),FCE("ǡ", 1, 2, 1),FCE("ὣ", 0, 2, 1),FCE("Ὣ", 1, 2, 1),
FCE("Ⰱ", 0, 2, 1),FCE("ⰱ", 1, 2, 1),FCE("𞤀", 0, 2, 1),FCE("𞤢", 1, 2, 1),
FCE("Ṹ", 0, 2, 1),FCE("ṹ", 1, 2, 1),FCE("Ⓨ", 0, 2, 1),FCE("ⓨ", 1, 2, 1),
FCE("Ꝫ", 0, 2, 1),FCE("ꝫ", 1, 2, 1),FCE("Ě", 0, 2, 1),FCE("ě", 1, 2, 1),
FCE("Щ", 0, 2, 1),FCE("щ", 1, 2, 1),FCE("ᾄ", 0, 3, 1),FCE("ᾌ", 1, 3, 1),
FCE("ἄι", 2, 3, 2),FCE("ზ", 0, 2, 1),FCE("Ზ", 1, 2, 1),FCE("ᾱ", 0, 2, 1),
FCE("Ᾱ", 1, 2, 1),FCE("Ꝣ", 0, 2, 1),FCE("ꝣ", 1, 2, 1),FCE("𐲲", 0, 2, 1),
FCE("𐳲", 1, 2, 1),FCE("Ⱐ", 0, 2, 1),FCE("ⱐ", 1, 2, 1),FCE("Ⴞ", 0, 2, 1),
FCE("ⴞ", 1, 2, 1),FCE("𐐞", 0, 2, 1),FCE("𐑆", 1, 2, 1),FCE("ῷ", 0, 2, 1),
FCE("ῶι", 1, 2, 3),FCE("Ӣ", 0, 2, 1),FCE("ӣ", 1, 2, 1),FCE("ᾐ", 0, 3, 1),
FCE("ᾘ", 1, 3, 1),FCE("ἠι", 2, 3, 2),FCE("Ӟ", 0, 2, 1),FCE("ӟ", 1, 2, 1),
FCE("ᾔ", 0, 3, 1),FCE("ᾜ", 1, 3, 1),FCE("ἤι", 2, 3, 2),FCE("Ձ", 0, 2, 1),
FCE("ձ", 1, 2, 1),FCE("Յ", 0, 2, 1),FCE("յ", 1, 2, 1),FCE("ἥ", 0, 2, 1),
FCE("Ἥ", 1, 2, 1),FCE("Ŕ", 0, 2, 1),FCE("ŕ", 1, 2, 1),FCE("Ⱔ", 0, 2, 1),
FCE("ⱔ", 1, 2, 1),FCE("Ꮺ", 0, 2, 1),FCE("ꮺ", 1, 2, 1),FCE("Ɓ", 0, 2, 1),
FCE("ɓ", 1, 2, 1),FCE("Σ", 0, 3, 1),FCE("ς", 1, 3, 1),FCE("σ", 2, 3, 1),
FCE("𑢳", 0, 2, 1),FCE("𑣓", 1, 2, 1),FCE("Ⴚ", 0, 2, 1),FCE("ⴚ", 1, 2, 1),
FCE("ƀ", 0, 2, 1),FCE("Ƀ", 1, 2, 1),FCE("Ḿ", 0, 2, 1),FCE("ḿ", 1, 2, 1),
FCE("ჿ", 0, 2, 1),FCE("Ჿ", 1, 2, 1),FCE("ῳ", 0, 3, 1),FCE("ῼ", 1, 3, 1),
FCE("ωι", 2, 3, 2),FCE("გ", 0, 2, 1),FCE("Გ", 1, 2, 1),FCE("Ꝯ", 0, 2, 1),
FCE("ꝯ", 1, 2, 1),FCE("𐲈", 0, 2, 1),FCE("𐳈", 1, 2, 1),FCE("ᲈ", 0, 3, 1),
FCE("Ꙋ", 1, 3, 1),FCE("ꙋ", 2, 3, 1),FCE("Ⴒ", 0, 2, 1),FCE("ⴒ", 1, 2, 1),
FCE("Ꮗ", 0, 2, 1),FCE("ꮗ", 1, 2, 1),FCE("Ԙ", 0, 2, 1),FCE("ԙ", 1, 2, 1),
FCE("Ꝧ", 0, 2, 1),FCE("ꝧ", 1, 2, 1),FCE("Ǭ", 0, 2, 1),FCE("ǭ", 1, 2, 1),
FCE("𐓃", 0, 2, 1),FCE("𐓫", 1, 2, 1),FCE("𐕴", 0, 2, 1),FCE("𐖛", 1, 2, 1),
FCE("Ꮾ", 0, 2, 1),FCE("ꮾ", 1, 2, 1),FCE("𞤜", 0, 2, 1),FCE("𞤾", 1, 2, 1),
FCE("ტ", 0, 2, 1),FCE("Ტ", 1, 2, 1),FCE("Ⰵ", 0, 2, 1),FCE("ⰵ", 1, 2, 1),
FCE("Ҡ", 0, 2, 1),FCE("ҡ", 1, 2, 1),FCE("Ṃ", 0, 2, 1),FCE("ṃ", 1, 2, 1),
FCE("Ꮄ", 0, 2, 1),FCE("ꮄ", 1, 2, 1),FCE("𑢿", 0, 2, 1),FCE("𑣟", 1, 2, 1),
FCE("Ő", 0, 2, 1),FCE("ő", 1, 2, 1),FCE("ὖ", 0, 2, 1),FCE("ὖ", 1, 2, 3),
FCE("Ⲱ", 0, 2, 1),FCE("ⲱ", 1, 2, 1),FCE("Ꭴ", 0, 2, 1),FCE("ꭴ", 1, 2, 1),
FCE("Ӂ", 0, 2, 1),FCE("ӂ", 1, 2, 1),FCE("Ǌ", 0, 3, 1),FCE("ǋ", 1, 3, 1),
FCE("ǌ", 2, 3, 1),FCE("L", 0, 2, 1),FCE("l", 1, 2, 1),FCE("𐓇", 0, 2, 1),
FCE("𐓯", 1, 2, 1),FCE("𖹚", 0, 2, 1),FCE("𖹺", 1, 2, 1),FCE("Ȣ", 0, 2, 1),
FCE("ȣ", 1, 2, 1),FCE("Ґ", 0, 2, 1),FCE("ґ", 1, 2, 1),FCE("Ⳳ", 0, 2, 1),
FCE("ⳳ", 1, 2, 1),FCE("𐖕", 0, 2, 1),FCE("𐖼", 1, 2, 1),FCE("Խ", 0, 2, 1),
FCE("խ", 1, 2, 1),FCE("Έ", 0, 2, 1),FCE("έ", 1, 2, 1),FCE("Չ", 0, 2, 1),
FCE("չ", 1, 2, 1),FCE("Ꮲ", 0, 2, 1),FCE("ꮲ", 1, 2, 1),FCE("𖹊", 0, 2, 1),
FCE("𖹪", 1, 2, 1),FCE("Ỽ", 0, 2, 1),FCE("ỽ", 1, 2, 1),FCE("ᾐ", 0, 3, 1),
FCE("ᾘ", 1, 3, 1),FCE("ἠι", 2, 3, 2),FCE("Ӗ", 0, 2, 1),FCE("ӗ", 1, 2, 1),
FCE("Ꞹ", 0, 2, 1),FCE("ꞹ", 1, 2, 1),FCE("Д", 0, 3, 1),FCE("д", 1, 3, 1),
FCE("ᲁ", 2, 3, 1),FCE("𐲭", 0, 2, 1),FCE("𐳭", 1, 2, 1),FCE("ჷ", 0, 2, 1),
FCE("Ჷ", 1, 2, 1),FCE("𖹕", 0, 2, 1),FCE("𖹵", 1, 2, 1),FCE("Ꜩ", 0, 2, 1),
FCE("ꜩ", 1, 2, 1),FCE("Ḁ", 0, 2, 1),FCE("ḁ", 1, 2, 1),FCE("Ȳ", 0, 2, 1),
FCE("ȳ", 1, 2, 1),FCE("Ⴅ", 0, 2, 1),FCE("ⴅ", 1, 2, 1),FCE("ἕ", 0, 2, 1),
FCE("Ἕ", 1, 2, 1),FCE("Ω", 0, 3, 1),FCE("ω", 1, 3, 1),FCE("Ω", 2, 3, 1),
FCE("Ļ", 0, 2, 1),FCE("ļ", 1, 2, 1),FCE("Ј", 0, 2, 1),FCE("ј", 1, 2, 1),
FCE("Ü", 0, 2, 1),FCE("ü", 1, 2, 1),FCE("Ế", 0, 2, 1),FCE("ế", 1, 2, 1),
FCE("Ⱈ", 0, 2, 1),FCE("ⱈ", 1, 2, 1),FCE("Ꞩ", 0, 2, 1),FCE("ꞩ", 1, 2, 1),
FCE("Ⅻ", 0, 2, 1),FCE("ⅻ", 1, 2, 1),FCE("Ⱀ", 0, 2, 1),FCE("ⱀ", 1, 2, 1),
FCE("Ⳟ", 0, 2, 1),FCE("ⳟ", 1, 2, 1),FCE("ʞ", 0, 2, 1),FCE("Ʞ", 1, 2, 1),
FCE("Ô", 0, 2, 1),FCE("ô", 1, 2, 1),FCE("ჯ", 0, 2, 1),FCE("Ჯ", 1, 2, 1),
FCE("Ց", 0, 2, 1),FCE("ց", 1, 2, 1),FCE("Ꮪ", 0, 2, 1),FCE("ꮪ", 1, 2, 1),
FCE("Ե", 0, 2, 1),FCE("ե", 1, 2, 1),FCE("ᾠ", 0, 3, 1),FCE("ᾨ", 1, 3, 1),
FCE("ὠι", 2, 3, 2),FCE("Ⓠ", 0, 2, 1),FCE("ⓠ", 1, 2, 1),FCE("А", 0, 2, 1),
FCE("а", 1, 2, 1),FCE("Ặ", 0, 2, 1),FCE("ặ", 1, 2, 1),FCE("ᾄ", 0, 3, 1),
FCE("ᾌ", 1, 3, 1),FCE("ἄι", 2, 3, 2),FCE("𐐖", 0, 2, 1),FCE("𐐾", 1, 2, 1),
FCE("𖹂", 0, 2, 1),FCE("𖹢", 1, 2, 1),FCE("Ť", 0, 2, 1),FCE("ť", 1, 2, 1),
FCE("Ⲡ", 0, 2, 1),FCE("ⲡ", 1, 2, 1),FCE("Ḯ", 0, 2, 1),FCE("ḯ", 1, 2, 1),
FCE("𐲕", 0, 2, 1),FCE("𐳕", 1, 2, 1),FCE("Ҙ", 0, 2, 1),FCE("ҙ", 1, 2, 1),
FCE("Ċ", 0, 2, 1),FCE("ċ", 1, 2, 1),FCE("𐲝", 0, 2, 1),FCE("𐳝", 1, 2, 1),
FCE("𑢪", 0, 2, 1),FCE("𑣊", 1, 2, 1),FCE("Ẉ", 0, 2, 1),FCE("ẉ", 1, 2, 1),
FCE("Ԩ", 0, 2, 1),FCE("ԩ", 1, 2, 1),FCE("Ꮧ", 0, 2, 1),FCE("ꮧ", 1, 2, 1),
FCE("Ꙛ", 0, 2, 1),FCE("ꙛ", 1, 2, 1),FCE("Ȫ", 0, 2, 1),FCE("ȫ", 1, 2, 1),
FCE("ᾥ", 0, 3, 1),FCE("ᾭ", 1, 3, 1),FCE("ὥι", 2, 3, 2),FCE("𐒳", 0, 2, 1),
FCE("𐓛", 1, 2, 1),FCE("𞤌", 0, 2, 1),FCE("𞤮", 1, 2, 1),FCE("Ⓕ", 0, 2, 1),
FCE("ⓕ", 1, 2, 1),FCE("Ǵ", 0, 2, 1),FCE("ǵ", 1, 2, 1),FCE("Ꚑ", 0, 2, 1),
FCE("ꚑ", 1, 2, 1),FCE("Ｉ", 0, 2, 1),FCE("ｉ", 1, 2, 1),FCE("Ⱶ", 0, 2, 1),
FCE("ⱶ", 1, 2, 1),FCE("Ⲹ", 0, 2, 1),FCE("ⲹ", 1, 2, 1),FCE("𐐁", 0, 2, 1),
FCE("𐐩", 1, 2, 1),FCE("Ⰽ", 0, 2, 1),FCE("ⰽ", 1, 2, 1),FCE("𐓐", 0, 2, 1),
FCE("𐓸", 1, 2, 1),FCE("𞤓", 0, 2, 1),FCE("𞤵", 1, 2, 1),FCE("Ư", 0, 2, 1),
FCE("ư", 1, 2, 1),FCE("Ꟈ", 0, 2, 1),FCE("ꟈ", 1, 2, 1),FCE("Ꮏ", 0, 2, 1),
FCE("ꮏ", 1, 2, 1),FCE("𐐂", 0, 2, 1),FCE("𐐪", 1, 2, 1),FCE("ც", 0, 2, 1),
FCE("Ც", 1, 2, 1),FCE("𐒿", 0, 2, 1),FCE("𐓧", 1, 2, 1),FCE("𐖍", 0, 2, 1),
FCE("𐖴", 1, 2, 1),FCE("Ⅴ", 0, 2, 1),FCE("ⅴ", 1, 2, 1),FCE("Ǝ", 0, 2, 1),
FCE("ǝ", 1, 2, 1),FCE("Ǔ", 0, 2, 1),FCE("ǔ", 1, 2, 1),FCE("ἐ", 0, 2, 1),
FCE("Ἐ", 1, 2, 1),FCE("ὗ", 0, 2, 1),FCE("Ὗ", 1, 2, 1),FCE("Ồ", 0, 2, 1),
FCE("ồ", 1, 2, 1),FCE("Ｊ", 0, 2, 1),FCE("ｊ", 1, 2, 1),FCE("Ḅ", 0, 2, 1),
FCE("ḅ", 1, 2, 1),FCE("Ӯ", 0, 2, 1),FCE("ӯ", 1, 2, 1),FCE("Ⲕ", 0, 2, 1),
FCE("ⲕ", 1, 2, 1),FCE("À", 0, 2, 1),FCE("à", 1, 2, 1),FCE("ῦ", 0, 2, 1),
FCE("ῦ", 1, 2, 2),FCE("Ꮫ", 0, 2, 1),FCE("ꮫ", 1, 2, 1),FCE("Ʋ", 0, 2, 1),
FCE("ʋ", 1, 2, 1),FCE("𐐦", 0, 2, 1),FCE("𐑎", 1, 2, 1),FCE("Ꙣ", 0, 2, 1),
FCE("ꙣ", 1, 2, 1),FCE("T", 0, 2, 1),FCE("t", 1, 2, 1),FCE("Ֆ", 0, 2, 1),
FCE("ֆ", 1, 2, 1),FCE("Ъ", 0, 3, 1),FCE("ъ", 1, 3, 1),FCE("ᲆ", 2, 3, 1),
FCE("𐐢", 0, 2, 1),FCE("𐑊", 1, 2, 1),FCE("ἶ", 0, 2, 1),FCE("Ἶ", 1, 2, 1),
FCE("ᾡ", 0, 3, 1),FCE("ᾩ", 1, 3, 1),FCE("ὡι", 2, 3, 2),FCE("Ӎ", 0, 2, 1),
FCE("ӎ", 1, 2, 1),FCE("𐒻", 0, 2, 1),FCE("𐓣", 1, 2, 1),FCE("Ȼ", 0, 2, 1),
FCE("ȼ", 1, 2, 1),FCE("Ǐ", 0, 2, 1),FCE("ǐ", 1, 2, 1),FCE("Ԍ", 0, 2, 1),
FCE("ԍ", 1, 2, 1),FCE("Ꙇ", 0, 2, 1),FCE("ꙇ", 1, 2, 1),FCE("Ṇ", 0, 2, 1),
FCE("ṇ", 1, 2, 1),FCE("𐲦", 0, 2, 1),FCE("𐳦", 1, 2, 1),FCE("Ꝺ", 0, 2, 1),
FCE("ꝺ", 1, 2, 1),FCE("Ｖ", 0, 2, 1),FCE("ｖ", 1, 2, 1),FCE("𑢢", 0, 2, 1),
FCE("𑣂", 1, 2, 1),FCE("Ӫ", 0, 2, 1),FCE("ӫ", 1, 2, 1),FCE("Н", 0, 2, 1),
FCE("н", 1, 2, 1),FCE("ꞔ", 0, 2, 1),FCE("Ꞔ", 1, 2, 1),FCE("Ꚉ", 0, 2, 1),
FCE("ꚉ", 1, 2, 1),FCE("Ẳ", 0, 2, 1),FCE("ẳ", 1, 2, 1),FCE("Ⅰ", 0, 2, 1),
FCE("ⅰ", 1, 2, 1),FCE("Ỗ", 0, 2, 1),FCE("ỗ", 1, 2, 1),FCE("Ⓝ", 0, 2, 1),
FCE("ⓝ", 1, 2, 1),FCE("𖹞", 0, 2, 1),FCE("𖹾", 1, 2, 1),FCE("Ҭ", 0, 2, 1),
FCE("ҭ", 1, 2, 1),FCE("𖹒", 0, 2, 1),FCE("𖹲", 1, 2, 1),FCE("Ⱦ", 0, 2, 1),
FCE("ⱦ", 1, 2, 1),FCE("Ⲵ", 0, 2, 1),FCE("ⲵ", 1, 2, 1),FCE("Ｍ", 0, 2, 1),
FCE("ｍ", 1, 2, 1),FCE("Ō", 0, 2, 1),FCE("ō", 1, 2, 1),FCE("Ḣ", 0, 2, 1),
FCE("ḣ", 1, 2, 1),FCE("Ꮋ", 0, 2, 1),FCE("ꮋ", 1, 2, 1),FCE("Ń", 0, 2, 1),
FCE("ń", 1, 2, 1),FCE("ﬄ", 0, 2, 1),FCE("ffl", 1, 2, 3),FCE("𐖁", 0, 2, 1),
FCE("𐖨", 1, 2, 1),FCE("Ű", 0, 2, 1),FCE("ű", 1, 2, 1),FCE("Ẕ", 0, 2, 1),
FCE("ẕ", 1, 2, 1),FCE("ῂ", 0, 2, 1),FCE("ὴι", 1, 2, 2),FCE("Ⱘ", 0, 2, 1),
FCE("ⱘ", 1, 2, 1),FCE("𞤐", 0, 2, 1),FCE("𞤲", 1, 2, 1),FCE("𐐎", 0, 2, 1),
FCE("𐐶", 1, 2, 1),FCE("ᾃ", 0, 3, 1),FCE("ᾋ", 1, 3, 1),FCE("ἃι", 2, 3, 2),
FCE("Ꞙ", 0, 2, 1),FCE("ꞙ", 1, 2, 1),FCE("Ꮈ", 0, 2, 1),FCE("ꮈ", 1, 2, 1),
FCE("Ṱ", 0, 2, 1),FCE("ṱ", 1, 2, 1),FCE("Т", 0, 4, 1),FCE("т", 1, 4, 1),
FCE("ᲄ", 2, 4, 1),FCE("ᲅ", 3, 4, 1),FCE("𐲅", 0, 2, 1),FCE("𐳅", 1, 2, 1),
FCE("Ắ", 0, 2, 1),FCE("ắ", 1, 2, 1),FCE("Ģ", 0, 2, 1),FCE("ģ", 1, 2, 1),
FCE("𐒲", 0, 2, 1),FCE("𐓚", 1, 2, 1),FCE("𐲌", 0, 2, 1),FCE("𐳌", 1, 2, 1),
FCE("𐐅", 0, 2, 1),FCE("𐐭", 1, 2, 1),FCE("ᾇ", 0, 3, 1),FCE("ᾏ", 1, 3, 1),
FCE("ἇι", 2, 3, 2),FCE("Р", 0, 2, 1),FCE("р", 1, 2, 1),FCE("Ʈ", 0, 2, 1),
FCE("ʈ", 1, 2, 1),FCE("Ț", 0, 2, 1),FCE("ț", 1, 2, 1),FCE("Ό", 0, 2, 1),
FCE("ό", 1, 2, 1),FCE("ᾕ", 0, 3, 1),FCE("ᾝ", 1, 3, 1),FCE("ἥι", 2, 3, 2),
FCE("ͅ", 0, 4, 1),FCE("Ι", 1, 4, 1),FCE("ι", 2, 4, 1),FCE("ι", 3, 4, 1),
FCE("Ɗ", 0, 2, 1),FCE("ɗ", 1, 2, 1),FCE("ΐ", 0, 3, 1),FCE("ΐ", 1, 3, 1),
FCE("ΐ", 2, 3, 3),FCE("Ⴑ", 0, 2, 1),FCE("ⴑ", 1, 2, 1),FCE("Ğ", 0, 2, 1),
FCE("ğ", 1, 2, 1),FCE("Ḉ", 0, 2, 1),FCE("ḉ", 1, 2, 1),FCE("Ⲑ", 0, 2, 1),
FCE("ⲑ", 1, 2, 1),FCE("Ꟁ", 0, 2, 1),FCE("ꟁ", 1, 2, 1),FCE("Ꮷ", 0, 2, 1),
FCE("ꮷ", 1, 2, 1),FCE("𐖀", 0, 2, 1),FCE("𐖧", 1, 2, 1),FCE("М", 0, 2, 1),
FCE("м", 1, 2, 1),FCE("ﬅ", 0, 3, 1),FCE("ﬆ", 1, 3, 1),FCE("st", 2, 3, 2),
FCE("Ꞥ", 0, 2, 1),FCE("ꞥ", 1, 2, 1),FCE("Ṵ", 0, 2, 1),FCE("ṵ", 1, 2, 1),
FCE("Ⱄ", 0, 2, 1),FCE("ⱄ", 1, 2, 1),FCE("𞤍", 0, 2, 1),FCE("𞤯", 1, 2, 1),
FCE("Ꭵ", 0, 2, 1),FCE("ꭵ", 1, 2, 1),FCE("ჳ", 0, 2, 1),FCE("Ჳ", 1, 2, 1),
FCE("Ⓔ", 0, 2, 1),FCE("ⓔ", 1, 2, 1),FCE("Ŀ", 0, 2, 1),FCE("ŀ", 1, 2, 1),
FCE("Ν", 0, 2, 1),FCE("ν", 1, 2, 1),FCE("Ⳣ", 0, 2, 1),FCE("ⳣ", 1, 2, 1),
FCE("Ⴁ", 0, 2, 1),FCE("ⴁ", 1, 2, 1),FCE("Ԉ", 0, 2, 1),FCE("ԉ", 1, 2, 1),
FCE("M", 0, 2, 1),FCE("m", 1, 2, 1),FCE("Ή", 0, 2, 1),FCE("ή", 1, 2, 1),
FCE("Ҍ", 0, 2, 1),FCE("ҍ", 1, 2, 1),FCE("Ⰴ", 0, 2, 1),FCE("ⰴ", 1, 2, 1),
FCE("Ⅿ", 0, 2, 1),FCE("ⅿ", 1, 2, 1),FCE("Ұ", 0, 2, 1),FCE("ұ", 1, 2, 1),
FCE("Ⳓ", 0, 2, 1),FCE("ⳓ", 1, 2, 1),FCE("Ꜵ", 0, 2, 1),FCE("ꜵ", 1, 2, 1),
FCE("ﬁ", 0, 2, 1),FCE("fi", 1, 2, 2),FCE("P", 0, 2, 1),FCE("p", 1, 2, 1),
FCE("Š", 0, 2, 1),FCE("š", 1, 2, 1),FCE("𐖄", 0, 2, 1),FCE("𐖫", 1, 2, 1),
FCE("Ḳ", 0, 2, 1),FCE("ḳ", 1, 2, 1),FCE("𐲩", 0, 2, 1),FCE("𐳩", 1, 2, 1),
FCE("Ȁ", 0, 2, 1),FCE("ȁ", 1, 2, 1),FCE("𑢫", 0, 2, 1),FCE("𑣋", 1, 2, 1),
FCE("Ꞇ", 0, 2, 1),FCE("ꞇ", 1, 2, 1),FCE("𑢻", 0, 2, 1),FCE("𑣛", 1, 2, 1),
FCE("𑢮", 0, 2, 1),FCE("𑣎", 1, 2, 1),FCE("Ȟ", 0, 2, 1),FCE("ȟ", 1, 2, 1),
FCE("Ϊ", 0, 2, 1),FCE("ϊ", 1, 2, 1),FCE("Ⴢ", 0, 2, 1),FCE("ⴢ", 1, 2, 1),
FCE("Ꮔ", 0, 2, 1),FCE("ꮔ", 1, 2, 1),FCE("Թ", 0, 2, 1),FCE("թ", 1, 2, 1),
FCE("Ꝋ", 0, 2, 1),FCE("ꝋ", 1, 2, 1),FCE("Ã", 0, 2, 1),FCE("ã", 1, 2, 1),
FCE("Ѯ", 0, 2, 1),FCE("ѯ", 1, 2, 1),FCE("Ս", 0, 2, 1),FCE("ս", 1, 2, 1),
FCE("ῢ", 0, 2, 1),FCE("ῢ", 1, 2, 3),FCE("უ", 0, 2, 1),FCE("Უ", 1, 2, 1),
FCE("ὒ", 0, 2, 1),FCE("ὒ", 1, 2, 3),FCE("Ϟ", 0, 2, 1),FCE("ϟ", 1, 2, 1),
FCE("Ⓤ", 0, 2, 1),FCE("ⓤ", 1, 2, 1),FCE("ͅ", 0, 4, 1),FCE("Ι", 1, 4, 1),
FCE("ι", 2, 4, 1),FCE("ι", 3, 4, 1),FCE("𐲙", 0, 2, 1),FCE("𐳙", 1, 2, 1),
FCE("Ꝛ", 0, 2, 1),FCE("ꝛ", 1, 2, 1),FCE("Й", 0, 2, 1),FCE("й", 1, 2, 1),
FCE("Ⰹ", 0, 2, 1),FCE("ⰹ", 1, 2, 1),FCE("ͽ", 0, 2, 1),FCE("Ͽ", 1, 2, 1),
FCE("ἦ", 0, 2, 1),FCE("Ἦ", 1, 2, 1),FCE("𑢲", 0, 2, 1),FCE("𑣒", 1, 2, 1),
FCE("Ↄ", 0, 2, 1),FCE("ↄ", 1, 2, 1),FCE("Ⱓ", 0, 2, 1),FCE("ⱓ", 1, 2, 1),
FCE("Ĳ", 0, 2, 1),FCE("ĳ", 1, 2, 1),FCE("Ṗ", 0, 2, 1),FCE("ṗ", 1, 2, 1),
FCE("Ⴎ", 0, 2, 1),FCE("ⴎ", 1, 2, 1),FCE("Ꝁ", 0, 2, 1),FCE("ꝁ", 1, 2, 1),
FCE("Ý", 0, 2, 1),FCE("ý", 1, 2, 1),FCE("ღ", 0, 2, 1),FCE("Ღ", 1, 2, 1),
FCE("Ṡ", 0, 3, 1),FCE("ṡ", 1, 3, 1),FCE("ẛ", 2, 3, 1),FCE("Ѹ", 0, 2, 1),
FCE("ѹ", 1, 2, 1),FCE("Ȯ", 0, 2, 1),FCE("ȯ", 1, 2, 1),FCE("ῶ", 0, 2, 1),
FCE("ῶ", 1, 2, 2),FCE("ῒ", 0, 2, 1),FCE("ῒ", 1, 2, 3),FCE("Ꚕ", 0, 2, 1),
FCE("ꚕ", 1, 2, 1),FCE("Ԭ", 0, 2, 1),FCE("ԭ", 1, 2, 1),FCE("𐕰", 0, 2, 1),
FCE("𐖗", 1, 2, 1),FCE("Ꙧ", 0, 2, 1),FCE("ꙧ", 1, 2, 1),FCE("ǰ", 0, 2, 1),
FCE("ǰ", 1, 2, 2),FCE("𐲖", 0, 2, 1),FCE("𐳖", 1, 2, 1),FCE("Ȋ", 0, 2, 1),
FCE("ȋ", 1, 2, 1),FCE("Ⓙ", 0, 2, 1),FCE("ⓙ", 1, 2, 1),FCE("Ꮛ", 0, 2, 1),
FCE("ꮛ", 1, 2, 1),FCE("𐲜", 0, 2, 1),FCE("𐳜", 1, 2, 1),FCE("О", 0, 3, 1),
FCE("о", 1, 3, 1),FCE("ᲂ", 2, 3, 1),FCE("Ẅ", 0, 2, 1),FCE("ẅ", 1, 2, 1),
FCE("Ự", 0, 2, 1),FCE("ự", 1, 2, 1),FCE("Ꭸ", 0, 2, 1),FCE("ꭸ", 1, 2, 1),
FCE("𖹙", 0, 2, 1),FCE("𖹹", 1, 2, 1),FCE("Ⲥ", 0, 2, 1),FCE("ⲥ", 1, 2, 1),
FCE("Ꜥ", 0, 2, 1),FCE("ꜥ", 1, 2, 1),FCE("Ҝ", 0, 2, 1),FCE("ҝ", 1, 2, 1),
FCE("Ď", 0, 2, 1),FCE("ď", 1, 2, 1),FCE("ᾤ", 0, 3, 1),FCE("ᾬ", 1, 3, 1),
FCE("ὤι", 2, 3, 2),FCE("𐓓", 0, 2, 1),FCE("𐓻", 1, 2, 1),FCE("𞤃", 0, 2, 1),
FCE("𞤥", 1, 2, 1),FCE("Ƒ", 0, 2, 1),FCE("ƒ", 1, 2, 1),FCE("ᾀ", 0, 3, 1),
FCE("ᾈ", 1, 3, 1),FCE("ἀι", 2, 3, 2),FCE("Ꮮ", 0, 2, 1),FCE("ꮮ", 1, 2, 1),
FCE("Π", 0, 3, 1),FCE("π", 1, 3, 1),FCE("ϖ", 2, 3, 1),FCE("Ꭽ", 0, 2, 1),
FCE("ꭽ", 1, 2, 1),FCE("Ȇ", 0, 2, 1),FCE("ȇ", 1, 2, 1),FCE("ὅ", 0, 2, 1),
FCE("Ὅ", 1, 2, 1),FCE("Ϫ", 0, 2, 1),FCE("ϫ", 1, 2, 1),FCE("Ⴛ", 0, 2, 1),
FCE("ⴛ", 1, 2, 1),FCE("Ѵ", 0, 2, 1),FCE("ѵ", 1, 2, 1),FCE("Ｘ", 0, 2, 1),
FCE("ｘ", 1, 2, 1),FCE("Ӿ", 0, 2, 1),FCE("ӿ", 1, 2, 1),FCE("Ⲅ", 0, 2, 1),
FCE("ⲅ", 1, 2, 1),FCE("𐐓", 0, 2, 1),FCE("𐐻", 1, 2, 1),FCE("ῗ", 0, 2, 1),
FCE("ῗ", 1, 2, 3),FCE("Ṝ", 0, 2, 1),FCE("ṝ", 1, 2, 1),FCE("Ụ", 0, 2, 1),
FCE("ụ", 1, 2, 1),FCE("Ⳉ", 0, 2, 1),FCE("ⳉ", 1, 2, 1),FCE("Ⱏ", 0, 2, 1),
FCE("ⱏ", 1, 2, 1),FCE("Һ", 0, 2, 1),FCE("һ", 1, 2, 1),FCE("𐓎", 0, 2, 1),
FCE("𐓶", 1, 2, 1),FCE("𞤅", 0, 2, 1),FCE("𞤧", 1, 2, 1),FCE("Ñ", 0, 2, 1),
FCE("ñ", 1, 2, 1),FCE("Ѳ", 0, 2, 1),FCE("ѳ", 1, 2, 1),FCE("𑢶", 0, 2, 1),
FCE("𑣖", 1, 2, 1),FCE("ὸ", 0, 2, 1),FCE("Ὸ", 1, 2, 1),FCE("C", 0, 2, 1),
FCE("c", 1, 2, 1),FCE("Ả", 0, 2, 1),FCE("ả", 1, 2, 1),FCE("ἤ", 0, 2, 1),
FCE("Ἤ", 1, 2, 1),FCE("Ɲ", 0, 2, 1),FCE("ɲ", 1, 2, 1),FCE("Ҷ", 0, 2, 1),
FCE("ҷ", 1, 2, 1),FCE("ß", 0, 3, 1),FCE("ẞ", 1, 3, 1),FCE("ss", 2, 3, 2),
FCE("ᾇ", 0, 3, 1),FCE("ᾏ", 1, 3, 1),FCE("ἇι", 2, 3, 2),FCE("Ḕ", 0, 2, 1),
FCE("ḕ", 1, 2, 1),FCE("Ủ", 0, 2, 1),FCE("ủ", 1, 2, 1),FCE("Ћ", 0, 2, 1),
FCE("ћ", 1, 2, 1),FCE("Љ", 0, 2, 1),FCE("љ", 1, 2, 1),FCE("𐕽", 0, 2, 1),
FCE("𐖤", 1, 2, 1),FCE("Ψ", 0, 2, 1),FCE("ψ", 1, 2, 1),FCE("Ṛ", 0, 2, 1),
FCE("ṛ", 1, 2, 1),FCE("𐕿", 0, 2, 1),FCE("𐖦", 1, 2, 1),FCE("Մ", 0, 2, 1),
FCE("մ", 1, 2, 1),FCE("ჾ", 0, 2, 1),FCE("Ჾ", 1, 2, 1),FCE("Ḓ", 0, 2, 1),
FCE("ḓ", 1, 2, 1),FCE("Ⴙ", 0, 2, 1),FCE("ⴙ", 1, 2, 1),FCE("G", 0, 2, 1),
FCE("g", 1, 2, 1),FCE("Ӽ", 0, 2, 1),FCE("ӽ", 1, 2, 1),FCE("𐲒", 0, 2, 1),
FCE("𐳒", 1, 2, 1),FCE("Ⲇ", 0, 2, 1),FCE("ⲇ", 1, 2, 1),FCE("Ḛ", 0, 2, 1),
FCE("ḛ", 1, 2, 1),FCE("𐲐", 0, 2, 1),FCE("𐳐", 1, 2, 1),FCE("Ⴟ", 0, 2, 1),
FCE("ⴟ", 1, 2, 1),FCE("Ꮚ", 0, 2, 1),FCE("ꮚ", 1, 2, 1),FCE("𖹉", 0, 2, 1),
FCE("𖹩", 1, 2, 1),FCE("A", 0, 2, 1),FCE("a", 1, 2, 1),FCE("Ƽ", 0, 2, 1),
FCE("ƽ", 1, 2, 1),FCE("Ừ", 0, 2, 1),FCE("ừ", 1, 2, 1),FCE("Ԃ", 0, 2, 1),
FCE("ԃ", 1, 2, 1),FCE("Ɉ", 0, 2, 1),FCE("ɉ", 1, 2, 1),FCE("ᾕ", 0, 3, 1),
FCE("ᾝ", 1, 3, 1),FCE("ἥι", 2, 3, 2),FCE("ჟ", 0, 2, 1),FCE("Ჟ", 1, 2, 1),
FCE("Ǆ", 0, 3, 1),FCE("ǅ", 1, 3, 1),FCE("ǆ", 2, 3, 1),FCE("Ն", 0, 2, 1),
FCE("ն", 1, 2, 1),FCE("Ꮿ", 0, 2, 1),FCE("ꮿ", 1, 2, 1),FCE("Ⳍ", 0, 2, 1),
FCE("ⳍ", 1, 2, 1),FCE("თ", 0, 2, 1),FCE("Თ", 1, 2, 1),FCE("Ꭷ", 0, 2, 1),
FCE("ꭷ", 1, 2, 1),FCE("Ѻ", 0, 2, 1),FCE("ѻ", 1, 2, 1),FCE("Ĵ", 0, 2, 1),
FCE("ĵ", 1, 2, 1),FCE("Ъ", 0, 3, 1),FCE("ъ", 1, 3, 1),FCE("ᲆ", 2, 3, 1),
FCE("Ⱉ", 0, 2, 1),FCE("ⱉ", 1, 2, 1),FCE("Ȅ", 0, 2, 1),FCE("ȅ", 1, 2, 1),
FCE("ɜ", 0, 2, 1),FCE("Ɜ", 1, 2, 1),FCE("Ⓩ", 0, 2, 1),FCE("ⓩ", 1, 2, 1),
FCE("Ṕ", 0, 2, 1),FCE("ṕ", 1, 2, 1),FCE("𐕹", 0, 2, 1),FCE("𐖠", 1, 2, 1),
FCE("Պ", 0, 2, 1),FCE("պ", 1, 2, 1),FCE("Ꚅ", 0, 2, 1),FCE("ꚅ", 1, 2, 1),
FCE("Ｇ", 0, 2, 1),FCE("ｇ", 1, 2, 1),FCE("ἅ", 0, 2, 1),FCE("Ἅ", 1, 2, 1),
FCE("ﬓ", 0, 2, 1),FCE("մն", 1, 2, 2),FCE("Ⅎ", 0, 2, 1),FCE("ⅎ", 1, 2, 1),
FCE("Ɍ", 0, 2, 1),FCE("ɍ", 1, 2, 1),FCE("Ꮅ", 0, 2, 1),FCE("ꮅ", 1, 2, 1),
FCE("Ⳇ", 0, 2, 1),FCE("ⳇ", 1, 2, 1),FCE("𐐈", 0, 2, 1),FCE("𐐰", 1, 2, 1),
FCE("Ⱍ", 0, 2, 1),FCE("ⱍ", 1, 2, 1),FCE("ȿ", 0, 2, 1),FCE("Ȿ", 1, 2, 1),
FCE("Ꝃ", 0, 2, 1),FCE("ꝃ", 1, 2, 1),FCE("Ṣ", 0, 2, 1),FCE("ṣ", 1, 2, 1),
FCE("𐲨", 0, 2, 1),FCE("𐳨", 1, 2, 1),FCE("µ", 0, 3, 1),FCE("Μ", 1, 3, 1),
FCE("μ", 2, 3, 1),FCE("ᾁ", 0, 3, 1),FCE("ᾉ", 1, 3, 1),FCE("ἁι", 2, 3, 2),
FCE("𐲚", 0, 2, 1),FCE("𐳚", 1, 2, 1),FCE("Į", 0, 2, 1),FCE("į", 1, 2, 1),
FCE("Ѓ", 0, 2, 1),FCE("ѓ", 1, 2, 1),FCE("Ǿ", 0, 2, 1),FCE("ǿ", 1, 2, 1),
FCE("ͅ", 0, 4, 1),FCE("Ι", 1, 4, 1),FCE("ι", 2, 4, 1),FCE("ι", 3, 4, 1),
FCE("Ŵ", 0, 2, 1),FCE("ŵ", 1, 2, 1),FCE("Ϗ", 0, 2, 1),FCE("ϗ", 1, 2, 1),
FCE("Ⓧ", 0, 2, 1),FCE("ⓧ", 1, 2, 1),FCE("ᾳ", 0, 3, 1),FCE("ᾼ", 1, 3, 1),
FCE("αι", 2, 3, 2),FCE("𑢭", 0, 2, 1),FCE("𑣍", 1, 2, 1),FCE("Ꝅ", 0, 2, 1),
FCE("ꝅ", 1, 2, 1),FCE("Ù", 0, 2, 1),FCE("ù", 1, 2, 1),FCE("Ḍ", 0, 2, 1),
FCE("ḍ", 1, 2, 1),FCE("Ⱇ", 0, 2, 1),FCE("ⱇ", 1, 2, 1),FCE("Ϣ", 0, 2, 1),
FCE("ϣ", 1, 2, 1),FCE("ɬ", 0, 2, 1),FCE("Ɬ", 1, 2, 1),FCE("Ꝗ", 0, 2, 1),
FCE("ꝗ", 1, 2, 1),FCE("Ѕ", 0, 2, 1),FCE("ѕ", 1, 2, 1),FCE("Ɨ", 0, 2, 1),
FCE("ɨ", 1, 2, 1),FCE("ὠ", 0, 2, 1),FCE("Ὠ", 1, 2, 1),FCE("Ử", 0, 2, 1),
FCE("ử", 1, 2, 1),FCE("Ⲍ", 0, 2, 1),FCE("ⲍ", 1, 2, 1),FCE("ჲ", 0, 2, 1),
FCE("Ჲ", 1, 2, 1),FCE("𐒶", 0, 2, 1),FCE("𐓞", 1, 2, 1),FCE("𞤝", 0, 2, 1),
FCE("𞤿", 1, 2, 1),FCE("𐐊", 0, 2, 1),FCE("𐐲", 1, 2, 1),FCE("Ꮖ", 0, 2, 1),
FCE("ꮖ", 1, 2, 1),FCE("𖹁", 0, 2, 1),FCE("𖹡", 1, 2, 1),FCE("Ф", 0, 2, 1),
FCE("ф", 1, 2, 1),FCE("Ʃ", 0, 2, 1),FCE("ʃ", 1, 2, 1),FCE("Κ", 0, 3, 1),
FCE("κ", 1, 3, 1),FCE("ϰ", 2, 3, 1),FCE("ქ", 0, 2, 1),FCE("Ქ", 1, 2, 1),
FCE("𐓈", 0, 2, 1),FCE("𐓰", 1, 2, 1),FCE("𐐇", 0, 2, 1),FCE("𐐯", 1, 2, 1),
FCE("Ꮠ", 0, 2, 1),FCE("ꮠ", 1, 2, 1),FCE("ᾢ", 0, 3, 1),FCE("ᾪ", 1, 3, 1),
FCE("ὢι", 2, 3, 2),FCE("Ѭ", 0, 2, 1),FCE("ѭ", 1, 2, 1),FCE("Ⴀ", 0, 2, 1),
FCE("ⴀ", 1, 2, 1),FCE("Ꞃ", 0, 2, 1),FCE("ꞃ", 1, 2, 1),FCE("Å", 0, 3, 1),
FCE("å", 1, 3, 1),FCE("Å", 2, 3, 1),FCE("Ҵ", 0, 2, 1),FCE("ҵ", 1, 2, 1),
FCE("Ⳏ", 0, 2, 1),FCE("ⳏ", 1, 2, 1),FCE("ῲ", 0, 2, 1),FCE("ὼι", 1, 2, 2),
FCE("Ａ", 0, 2, 1),FCE("ａ", 1, 2, 1),FCE("Ꜻ", 0, 2, 1),FCE("ꜻ", 1, 2, 1),
FCE("𐒹", 0, 2, 1),FCE("𐓡", 1, 2, 1),FCE("Ấ", 0, 2, 1),FCE("ấ", 1, 2, 1),
FCE("Ώ", 0, 2, 1),FCE("ώ", 1, 2, 1),FCE("Ⓘ", 0, 2, 1),FCE("ⓘ", 1, 2, 1),
FCE("ΰ", 0, 3, 1),FCE("ΰ", 1, 3, 1),FCE("ΰ", 2, 3, 3),FCE("I", 0, 2, 1),
FCE("i", 1, 2, 1),FCE("𞤟", 0, 2, 1),FCE("𞥁", 1, 2, 1),FCE("Ɇ", 0, 2, 1),
FCE("ɇ", 1, 2, 1),FCE("έ", 0, 2, 1),FCE("Έ", 1, 2, 1),FCE("Ⱨ", 0, 2, 1),
FCE("ⱨ", 1, 2, 1),FCE("Ⅶ", 0, 2, 1),FCE("ⅶ", 1, 2, 1),FCE("Ā", 0, 2, 1),
FCE("ā", 1, 2, 1),FCE("Ϥ", 0, 2, 1),FCE("ϥ", 1, 2, 1),FCE("Ꮢ", 0, 2, 1),
FCE("ꮢ", 1, 2, 1),FCE("Ꞟ", 0, 2, 1),FCE("ꞟ", 1, 2, 1),FCE("ᾠ", 0, 3, 1),
FCE("ᾨ", 1, 3, 1),FCE("ὠι", 2, 3, 2),FCE("𐲱", 0, 2, 1),FCE("𐳱", 1, 2, 1),
FCE("𖹝", 0, 2, 1),FCE("𖹽", 1, 2, 1),FCE("Ⴡ", 0, 2, 1),FCE("ⴡ", 1, 2, 1),
FCE("Ꟶ", 0, 2, 1),FCE("ꟶ", 1, 2, 1),FCE("Ꮎ", 0, 2, 1),FCE("ꮎ", 1, 2, 1),
FCE("Ь", 0, 2, 1),FCE("ь", 1, 2, 1),FCE("ῄ", 0, 2, 1),FCE("ήι", 1, 2, 2),
FCE("ო", 0, 2, 1),FCE("Ო", 1, 2, 1),FCE("ᾓ", 0, 3, 1),FCE("ᾛ", 1, 3, 1),
FCE("ἣι", 2, 3, 2),FCE("Ɏ", 0, 2, 1),FCE("ɏ", 1, 2, 1),FCE("Ҽ", 0, 2, 1),
FCE("ҽ", 1, 2, 1),FCE("Ŷ", 0, 2, 1),FCE("ŷ", 1, 2, 1),FCE("Ꭻ", 0, 2, 1),
FCE("ꭻ", 1, 2, 1),FCE("Ꮱ", 0, 2, 1),FCE("ꮱ", 1, 2, 1),FCE("Ԅ", 0, 2, 1),
FCE("ԅ", 1, 2, 1),FCE("ἃ", 0, 2, 1),FCE("Ἃ", 1, 2, 1),FCE("Ꚇ", 0, 2, 1),
FCE("ꚇ", 1, 2, 1),FCE("Ռ", 0, 2, 1),FCE("ռ", 1, 2, 1),FCE("𖹏", 0, 2, 1),
FCE("𖹯", 1, 2, 1),FCE("ძ", 0, 2, 1),FCE("Ძ", 1, 2, 1),FCE("Ꮩ", 0, 2, 1),
FCE("ꮩ", 1, 2, 1),FCE("Ⱥ", 0, 2, 1),FCE("ⱥ", 1, 2, 1),FCE("Ҩ", 0, 2, 1),
FCE("ҩ", 1, 2, 1),FCE("Ⳛ", 0, 2, 1),FCE("ⳛ", 1, 2, 1),FCE("О", 0, 3, 1),
FCE("о", 1, 3, 1),FCE("ᲂ", 2, 3, 1),FCE("ᾁ", 0, 3, 1),FCE("ᾉ", 1, 3, 1),
FCE("ἁι", 2, 3, 2),FCE("Δ", 0, 2, 1),FCE("δ", 1, 2, 1),FCE("Ⱳ", 0, 2, 1),
FCE("ⱳ", 1, 2, 1),FCE("Ԑ", 0, 2, 1),FCE("ԑ", 1, 2, 1),FCE("Ḧ", 0, 2, 1),
FCE("ḧ", 1, 2, 1),FCE("Ꙃ", 0, 2, 1),FCE("ꙃ", 1, 2, 1),FCE("Ӊ", 0, 2, 1),
FCE("ӊ", 1, 2, 1),FCE("Ň", 0, 2, 1),FCE("ň", 1, 2, 1),FCE("Ằ", 0, 2, 1),
FCE("ằ", 1, 2, 1),FCE("Ꝟ", 0, 2, 1),FCE("ꝟ", 1, 2, 1),FCE("𐖌", 0, 2, 1),
FCE("𐖳", 1, 2, 1),FCE("Ꜽ", 0, 2, 1),FCE("ꜽ", 1, 2, 1),FCE("𐓑", 0, 2, 1),
FCE("𐓹", 1, 2, 1),FCE("𐓒", 0, 2, 1),FCE("𐓺", 1, 2, 1),FCE("𐖐", 0, 2, 1),
FCE("𐖷", 1, 2, 1),FCE("U", 0, 2, 1),FCE("u", 1, 2, 1),FCE("ἑ", 0, 2, 1),
FCE("Ἑ", 1, 2, 1),FCE("ͻ", 0, 2, 1),FCE("Ͻ", 1, 2, 1),FCE("ἱ", 0, 2, 1),
FCE("Ἱ", 1, 2, 1),FCE("Ⲻ", 0, 2, 1),FCE("ⲻ", 1, 2, 1),FCE("Ւ", 0, 2, 1),
FCE("ւ", 1, 2, 1),FCE("ῃ", 0, 3, 1),FCE("ῌ", 1, 3, 1),FCE("ηι", 2, 3, 2),
FCE("Ṯ", 0, 2, 1),FCE("ṯ", 1, 2, 1),FCE("Ⅷ", 0, 2, 1),FCE("ⅷ", 1, 2, 1),
FCE("Þ", 0, 2, 1),FCE("þ", 1, 2, 1),FCE("Ɛ", 0, 2, 1),FCE("ɛ", 1, 2, 1),
FCE("Ꚍ", 0, 2, 1),FCE("ꚍ", 1, 2, 1),FCE("Ỹ", 0, 2, 1),FCE("ỹ", 1, 2, 1),
FCE("𐒰", 0, 2, 1),FCE("𐓘", 1, 2, 1),FCE("𐲎", 0, 2, 1),FCE("𐳎", 1, 2, 1),
FCE("Ⰸ", 0, 2, 1),FCE("ⰸ", 1, 2, 1),FCE("Ů", 0, 2, 1),FCE("ů", 1, 2, 1),
FCE("𖹜", 0, 2, 1),FCE("𖹼", 1, 2, 1),FCE("Ⴭ", 0, 2, 1),FCE("ⴭ", 1, 2, 1),
FCE("ύ", 0, 2, 1),FCE("Ύ", 1, 2, 1),FCE("Ẑ", 0, 2, 1),FCE("ẑ", 1, 2, 1),
FCE("Ꮃ", 0, 2, 1),FCE("ꮃ", 1, 2, 1),FCE("Ǒ", 0, 2, 1),FCE("ǒ", 1, 2, 1),
FCE("ὓ", 0, 2, 1),FCE("Ὓ", 1, 2, 1),FCE("Ħ", 0, 2, 1),FCE("ħ", 1, 2, 1),
FCE("Ṉ", 0, 2, 1),FCE("ṉ", 1, 2, 1),FCE("Ⲙ", 0, 2, 1),FCE("ⲙ", 1, 2, 1),
FCE("𐐀", 0, 2, 1),FCE("𐐨", 1, 2, 1),FCE("ᾣ", 0, 3, 1),FCE("ᾫ", 1, 3, 1),
FCE("ὣι", 2, 3, 2),FCE("𑢹", 0, 2, 1),FCE("𑣙", 1, 2, 1),FCE("Ꮀ", 0, 2, 1),
FCE("ꮀ", 1, 2, 1),FCE("Ộ", 0, 2, 1),FCE("ộ", 1, 2, 1),FCE("𐲤", 0, 2, 1),
FCE("𐳤", 1, 2, 1),FCE("ὴ", 0, 2, 1),FCE("Ὴ", 1, 2, 1),FCE("Т", 0, 4, 1),
FCE("т", 1, 4, 1),FCE("ᲄ", 2, 4, 1),FCE("ᲅ", 3, 4, 1),FCE("Ỳ", 0, 2, 1),
FCE("ỳ", 1, 2, 1),FCE("Ⅱ", 0, 2, 1),FCE("ⅱ", 1, 2, 1),FCE("𐐠", 0, 2, 1),
FCE("𐑈", 1, 2, 1),FCE("Ǳ", 0, 3, 1),FCE("ǲ", 1, 3, 1),FCE("ǳ", 2, 3, 1),
FCE("Ǘ", 0, 2, 1),FCE("ǘ", 1, 2, 1),FCE("Ꚋ", 0, 2, 1),FCE("ꚋ", 1, 2, 1),
FCE("Ϸ", 0, 2, 1),FCE("ϸ", 1, 2, 1),FCE("Ｕ", 0, 2, 1),FCE("ｕ", 1, 2, 1),
FCE("Ϝ", 0, 2, 1),FCE("ϝ", 1, 2, 1),FCE("𐲍", 0, 2, 1),FCE("𐳍", 1, 2, 1),
FCE("И", 0, 2, 1),FCE("и", 1, 2, 1),FCE("Ȓ", 0, 2, 1),FCE("ȓ", 1, 2, 1),
FCE("Ӱ", 0, 2, 1),FCE("ӱ", 1, 2, 1),FCE("Ⓛ", 0, 2, 1),FCE("ⓛ", 1, 2, 1),
FCE("Ԋ", 0, 2, 1),FCE("ԋ", 1, 2, 1),FCE("𞤗", 0, 2, 1),FCE("𞤹", 1, 2, 1),
FCE("Ꙅ", 0, 2, 1),FCE("ꙅ", 1, 2, 1),FCE("Է", 0, 2, 1),FCE("է", 1, 2, 1),
FCE("Ⴌ", 0, 2, 1),FCE("ⴌ", 1, 2, 1),FCE("Ⴍ", 0, 2, 1),FCE("ⴍ", 1, 2, 1),
FCE("Ⓡ", 0, 2, 1),FCE("ⓡ", 1, 2, 1),FCE("Ѡ", 0, 2, 1),FCE("ѡ", 1, 2, 1),
FCE("Ⱛ", 0, 2, 1),FCE("ⱛ", 1, 2, 1),FCE("𖹖", 0, 2, 1),FCE("𖹶", 1, 2, 1),
FCE("Ⴧ", 0, 2, 1),FCE("ⴧ", 1, 2, 1),FCE("ﬅ", 0, 3, 1),FCE("ﬆ", 1, 3, 1),
FCE("st", 2, 3, 2),FCE("Ⳕ", 0, 2, 1),FCE("ⳕ", 1, 2, 1),FCE("ჱ", 0, 2, 1),
FCE("Ჱ", 1, 2, 1),FCE("ὺ", 0, 2, 1),FCE("Ὺ", 1, 2, 1),FCE("Ⰻ", 0, 2, 1),
FCE("ⰻ", 1, 2, 1),FCE("Ｔ", 0, 2, 1),FCE("ｔ", 1, 2, 1),FCE("𐐆", 0, 2, 1),
FCE("𐐮", 1, 2, 1),FCE("З", 0, 2, 1),FCE("з", 1, 2, 1),FCE("𑢺", 0, 2, 1),
FCE("𑣚", 1, 2, 1),FCE("ᾂ", 0, 3, 1),FCE("ᾊ", 1, 3, 1),FCE("ἂι", 2, 3, 2),
FCE("Ǳ", 0, 3, 1),FCE("ǲ", 1, 3, 1),FCE("ǳ", 2, 3, 1),FCE("Ε", 0, 3, 1),
FCE("ε", 1, 3, 1),FCE("ϵ", 2, 3, 1),FCE("Ʒ", 0, 2, 1),FCE("ʒ", 1, 2, 1),
FCE("Ə", 0, 2, 1),FCE("ə", 1, 2, 1),FCE("Ը", 0, 2, 1),FCE("ը", 1, 2, 1),
FCE("Ꙫ", 0, 2, 1),FCE("ꙫ", 1, 2, 1),FCE("ἲ", 0, 2, 1),FCE("Ἲ", 1, 2, 1),
FCE("𐐡", 0, 2, 1),FCE("𐑉", 1, 2, 1),FCE("Ԫ", 0, 2, 1),FCE("ԫ", 1, 2, 1),
FCE("Х", 0, 2, 1),FCE("х", 1, 2, 1),FCE("Ꞅ", 0, 2, 1),FCE("ꞅ", 1, 2, 1),
FCE("O", 0, 2, 1),FCE("o", 1, 2, 1),FCE("Ꙥ", 0, 2, 1),FCE("ꙥ", 1, 2, 1),
FCE("ᾢ", 0, 3, 1),FCE("ᾪ", 1, 3, 1),FCE("ὢι", 2, 3, 2),FCE("𐒱", 0, 2, 1),
FCE("𐓙", 1, 2, 1),FCE("Ä", 0, 2, 1),FCE("ä", 1, 2, 1),FCE("𐲥", 0, 2, 1),
FCE("𐳥", 1, 2, 1),FCE("Ẫ", 0, 2, 1),FCE("ẫ", 1, 2, 1),FCE("Ꮨ", 0, 2, 1),
FCE("ꮨ", 1, 2, 1),FCE("ß", 0, 3, 1),FCE("ẞ", 1, 3, 1),FCE("ss", 2, 3, 2),
FCE("ფ", 0, 2, 1),FCE("Ფ", 1, 2, 1),FCE("Ø", 0, 2, 1),FCE("ø", 1, 2, 1),
FCE("Ǌ", 0, 3, 1),FCE("ǋ", 1, 3, 1),FCE("ǌ", 2, 3, 1),FCE("ბ", 0, 2, 1),
FCE("Ბ", 1, 2, 1),FCE("𐕵", 0, 2, 1),FCE("𐖜", 1, 2, 1),FCE("Ⅼ", 0, 2, 1),
FCE("ⅼ", 1, 2, 1),FCE("Ⰲ", 0, 2, 1),FCE("ⰲ", 1, 2, 1),FCE("𖹛", 0, 2, 1),
FCE("𖹻", 1, 2, 1),FCE("Ꟙ", 0, 2, 1),FCE("ꟙ", 1, 2, 1),FCE("Ｂ", 0, 2, 1),
FCE("ｂ", 1, 2, 1),FCE("Є", 0, 2, 1),FCE("є", 1, 2, 1),FCE("Ⴓ", 0, 2, 1),
FCE("ⴓ", 1, 2, 1),FCE("Ị", 0, 2, 1),FCE("ị", 1, 2, 1),FCE("𐐉", 0, 2, 1),
FCE("𐐱", 1, 2, 1),FCE("𞤘", 0, 2, 1),FCE("𞤺", 1, 2, 1),FCE("Ӷ", 0, 2, 1),
FCE("ӷ", 1, 2, 1),FCE("Ⳁ", 0, 2, 1),FCE("ⳁ", 1, 2, 1),FCE("Ḡ", 0, 2, 1),
FCE("ḡ", 1, 2, 1),FCE("ﬀ", 0, 2, 1),FCE("ff", 1, 2, 2),FCE("𐒷", 0, 2, 1),
FCE("𐓟", 1, 2, 1),FCE("Λ", 0, 2, 1),FCE("λ", 1, 2, 1),FCE("Ɩ", 0, 2, 1),
FCE("ɩ", 1, 2, 1),FCE("Ⱕ", 0, 2, 1),FCE("ⱕ", 1, 2, 1),FCE("Ꞑ", 0, 2, 1),
FCE("ꞑ", 1, 2, 1),FCE("Ꝥ", 0, 2, 1),FCE("ꝥ", 1, 2, 1),FCE("Ȍ", 0, 2, 1),
FCE("ȍ", 1, 2, 1),FCE("ᾔ", 0, 3, 1),FCE("ᾜ", 1, 3, 1),FCE("ἤι", 2, 3, 2),
FCE("𑢰", 0, 2, 1),FCE("𑣐", 1, 2, 1),FCE("Ƃ", 0, 2, 1),FCE("ƃ", 1, 2, 1),
FCE("Ⲭ", 0, 2, 1),FCE("ⲭ", 1, 2, 1),FCE("ᾀ", 0, 3, 1),FCE("ᾈ", 1, 3, 1),
FCE("ἀι", 2, 3, 2),FCE("Ⓦ", 0, 2, 1),FCE("ⓦ", 1, 2, 1),FCE("ɑ", 0, 2, 1),
FCE("Ɑ", 1, 2, 1),FCE("Ҁ", 0, 2, 1),FCE("ҁ", 1, 2, 1),FCE("ὔ", 0, 2, 1),
FCE("ὔ", 1, 2, 3),FCE("Ⓒ", 0, 2, 1),FCE("ⓒ", 1, 2, 1),FCE("Ջ", 0, 2, 1),
FCE("ջ", 1, 2, 1),FCE("Ꭺ", 0, 2, 1),FCE("ꭺ", 1, 2, 1),FCE("K", 0, 3, 1),
FCE("k", 1, 3, 1),FCE("K", 2, 3, 1),FCE("ɡ", 0, 2, 1),FCE("Ɡ", 1, 2, 1),
FCE("Ł", 0, 2, 1),FCE("ł", 1, 2, 1),FCE("Κ", 0, 3, 1),FCE("κ", 1, 3, 1),
FCE("ϰ", 2, 3, 1),FCE("ჸ", 0, 2, 1),FCE("Ჸ", 1, 2, 1),FCE("𐓄", 0, 2, 1),
FCE("𐓬", 1, 2, 1),FCE("Ɖ", 0, 2, 1),FCE("ɖ", 1, 2, 1),FCE("პ", 0, 2, 1),
FCE("Პ", 1, 2, 1),FCE("Ṩ", 0, 2, 1),FCE("ṩ", 1, 2, 1),FCE("Ꮶ", 0, 2, 1),
FCE("ꮶ", 1, 2, 1),FCE("ἄ", 0, 2, 1),FCE("Ἄ", 1, 2, 1),FCE("𐕸", 0, 2, 1),
FCE("𐖟", 1, 2, 1),FCE("Б", 0, 2, 1),FCE("б", 1, 2, 1),FCE("𐒺", 0, 2, 1),
FCE("𐓢", 1, 2, 1),FCE("Ѧ", 0, 2, 1),FCE("ѧ", 1, 2, 1),FCE("Ꜷ", 0, 2, 1),
FCE("ꜷ", 1, 2, 1),FCE("ῤ", 0, 2, 1),FCE("ῤ", 1, 2, 2),FCE("Ë", 0, 2, 1),
FCE("ë", 1, 2, 1),FCE("Ⴠ", 0, 2, 1),FCE("ⴠ", 1, 2, 1),FCE("𐐧", 0, 2, 1),
FCE("𐑏", 1, 2, 1),FCE("Ǟ", 0, 2, 1),FCE("ǟ", 1, 2, 1),FCE("Ⲓ", 0, 2, 1),
FCE("ⲓ", 1, 2, 1),FCE("Ć", 0, 2, 1),FCE("ć", 1, 2, 1),FCE("Ṏ", 0, 2, 1),
FCE("ṏ", 1, 2, 1),FCE("Ы", 0, 2, 1),FCE("ы", 1, 2, 1),FCE("Ꝉ", 0, 2, 1),
FCE("ꝉ", 1, 2, 1),FCE("Ⱁ", 0, 2, 1),FCE("ⱁ", 1, 2, 1),FCE("Ꭓ", 0, 2, 1),
FCE("ꭓ", 1, 2, 1),FCE("Ծ", 0, 2, 1),FCE("ծ", 1, 2, 1),FCE("Ŏ", 0, 2, 1),
FCE("ŏ", 1, 2, 1),FCE("Ꮣ", 0, 2, 1),FCE("ꮣ", 1, 2, 1),FCE("Ԥ", 0, 2, 1),
FCE("ԥ", 1, 2, 1),FCE("Ꙟ", 0, 2, 1),FCE("ꙟ", 1, 2, 1),FCE("Ǹ", 0, 2, 1),
FCE("ǹ", 1, 2, 1),FCE("Ү", 0, 2, 1),FCE("ү", 1, 2, 1),FCE("Ꝿ", 0, 2, 1),
FCE("ꝿ", 1, 2, 1),FCE("Π", 0, 3, 1),FCE("π", 1, 3, 1),FCE("ϖ", 2, 3, 1),
FCE("ɥ", 0, 2, 1),FCE("Ɥ", 1, 2, 1),FCE("ᾶ", 0, 2, 1),FCE("ᾶ", 1, 2, 2),
FCE("ᾡ", 0, 3, 1),FCE("ᾩ", 1, 3, 1),FCE("ὡι", 2, 3, 2),FCE("Ở", 0, 2, 1),
FCE("ở", 1, 2, 1),FCE("Ꮉ", 0, 2, 1),FCE("ꮉ", 1, 2, 1),FCE("Ũ", 0, 2, 1),
FCE("ũ", 1, 2, 1),FCE("Ȧ", 0, 2, 1),FCE("ȧ", 1, 2, 1),FCE("Ᏹ", 0, 2, 1),
FCE("ᏹ", 1, 2, 1),FCE("Ḇ", 0, 2, 1),FCE("ḇ", 1, 2, 1),FCE("Ġ", 0, 2, 1),
FCE("ġ", 1, 2, 1),FCE("𐐝", 0, 2, 1),FCE("𐑅", 1, 2, 1),FCE("𐖂", 0, 2, 1),
FCE("𐖩", 1, 2, 1),FCE("ὦ", 0, 2, 1),FCE("Ὦ", 1, 2, 1),FCE("ẖ", 0, 2, 1),
FCE("ẖ", 1, 2, 2),FCE("Ⴆ", 0, 2, 1),FCE("ⴆ", 1, 2, 1),FCE("𐲑", 0, 2, 1),
FCE("𐳑", 1, 2, 1),FCE("ᶎ", 0, 2, 1),FCE("Ᶎ", 1, 2, 1),FCE("𐲄", 0, 2, 1),
FCE("𐳄", 1, 2, 1),FCE("Ｋ", 0, 2, 1),FCE("ｋ", 1, 2, 1),FCE("𑢣", 0, 2, 1),
FCE("𑣃", 1, 2, 1),FCE("H", 0, 2, 1),FCE("h", 1, 2, 1),FCE("Ꮜ", 0, 2, 1),
FCE("ꮜ", 1, 2, 1),FCE("𞤞", 0, 2, 1),FCE("𞥀", 1, 2, 1),FCE("Ύ", 0, 2, 1),
FCE("ύ", 1, 2, 1),FCE("Ա", 0, 2, 1),FCE("ա", 1, 2, 1),];
return t;
}

struct uniProps
{
private alias _U = immutable(UnicodeProperty);
@property static _U[] tab() pure { return _tab; }
static immutable:
private alias _T = ubyte[];
_T ID_Start = [0x41, 0x1a, 0x6, 0x1a, 0x2f, 0x1, 0xa, 0x1, 0x4, 0x1, 0x5, 0x17, 0x1, 0x1f, 0x1, 0x81, 0xca, 0x4, 0xc, 0xe, 0x5, 0x7, 0x1, 0x1, 0x1, 0x80, 0x81, 0x5, 0x1, 0x2, 0x2, 0x4, 0x1, 0x1, 0x6, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x14, 0x1, 0x53, 0x1, 0x80, 0x8b, 0x8, 0x80, 0xa6, 0x1, 0x26, 0x2, 0x1, 0x6, 0x29, 0x47, 0x1b, 0x4, 0x4, 0x2d, 0x2b, 0x23, 0x2, 0x1, 0x63, 0x1, 0x1, 0xf, 0x2, 0x7, 0x2, 0xa, 0x3, 0x2, 0x1, 0x10, 0x1, 0x1, 0x1e, 0x1d, 0x59, 0xb, 0x1, 0x18, 0x21, 0x9, 0x2, 0x4, 0x1, 0x5, 0x16, 0x4, 0x1, 0x9, 0x1, 0x3, 0x1, 0x17, 0x19, 0x7, 0xb, 0x5, 0x18, 0x1, 0x6, 0x11, 0x2a, 0x3a, 0x36, 0x3, 0x1, 0x12, 0x1, 0x7, 0xa, 0xf, 0x10, 0x4, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x1, 0x3, 0x4, 0x3, 0x1, 0x10, 0x1, 0xd, 0x2, 0x1, 0x3, 0xe, 0x2, 0xa, 0x1, 0x8, 0x6, 0x4, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1f, 0x4, 0x1, 0x1, 0x13, 0x3, 0x10, 0x9, 0x1, 0x3, 0x1, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x12, 0x1, 0xf, 0x2, 0x17, 0x1, 0xb, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x1e, 0x2, 0x1, 0x3, 0xf, 0x1, 0x11, 0x1, 0x1, 0x6, 0x3, 0x3, 0x1, 0x4, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0xc, 0x16, 0x1, 0x34, 0x8, 0x1, 0x3, 0x1, 0x17, 0x1, 0x10, 0x3, 0x1, 0x1a, 0x3, 0x2, 0x1, 0x2, 0x2, 0x1e, 0x1, 0x4, 0x8, 0x1, 0x3, 0x1, 0x17, 0x1, 0xa, 0x1, 0x5, 0x3, 0x1, 0x1f, 0x2, 0x1, 0x2, 0xf, 0x2, 0x11, 0x9, 0x1, 0x3, 0x1, 0x29, 0x2, 0x1, 0x10, 0x1, 0x5, 0x3, 0x8, 0x3, 0x18, 0x6, 0x5, 0x12, 0x3, 0x18, 0x1, 0x9, 0x1, 0x1, 0x2, 0x7, 0x3a, 0x30, 0x1, 0x2, 0xc, 0x7, 0x3a, 0x2, 0x1, 0x1, 0x1, 0x5, 0x1, 0x18, 0x1, 0x1, 0x1, 0xa, 0x1, 0x2, 0x9, 0x1, 0x2, 0x5, 0x1, 0x1, 0x15, 0x4, 0x20, 0x1, 0x3f, 0x8, 0x1, 0x24, 0x1b, 0x5, 0x73, 0x2b, 0x14, 0x1, 0x10, 0x6, 0x4, 0x4, 0x3, 0x1, 0x3, 0x2, 0x7, 0x3, 0x4, 0xd, 0xc, 0x1, 0x11, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x2b, 0x1, 0x81, 0x4d, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0x29, 0x1, 0x4, 0x2, 0x21, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0xf, 0x1, 0x39, 0x1, 0x4, 0x2, 0x43, 0x25, 0x10, 0x10, 0x56, 0x2, 0x6, 0x3, 0x82, 0x6c, 0x2, 0x11, 0x1, 0x1a, 0x5, 0x4b, 0x3, 0xb, 0x7, 0x12, 0xd, 0x13, 0xe, 0x12, 0xe, 0xd, 0x1, 0x3, 0xf, 0x34, 0x23, 0x1, 0x4, 0x1, 0x43, 0x59, 0x7, 0x29, 0x1, 0x1, 0x5, 0x46, 0xa, 0x1f, 0x31, 0x1e, 0x2, 0x5, 0xb, 0x2c, 0x4, 0x1a, 0x36, 0x17, 0x9, 0x35, 0x52, 0x1, 0x5d, 0x2f, 0x11, 0x8, 0x36, 0x1e, 0xd, 0x2, 0xa, 0x2c, 0x1a, 0x24, 0x29, 0x3, 0xa, 0x24, 0x2, 0x9, 0x7, 0x2b, 0x2, 0x3, 0x29, 0x4, 0x1, 0x6, 0x1, 0x2, 0x3, 0x1, 0x5, 0x80, 0xc0, 0x40, 0x81, 0x16, 0x2, 0x6, 0x2, 0x26, 0x2, 0x6, 0x2, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1f, 0x2, 0x35, 0x1, 0x7, 0x1, 0x1, 0x3, 0x3, 0x1, 0x7, 0x3, 0x4, 0x2, 0x6, 0x4, 0xd, 0x5, 0x3, 0x1, 0x7, 0x74, 0x1, 0xd, 0x1, 0x10, 0xd, 0x65, 0x1, 0x4, 0x1, 0x2, 0xa, 0x1, 0x1, 0x2, 0x6, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x10, 0x2, 0x4, 0x5, 0x5, 0x4, 0x1, 0x11, 0x29, 0x8a, 0x77, 0x80, 0xe5, 0x6, 0x4, 0x3, 0x2, 0xc, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x38, 0x7, 0x1, 0x10, 0x17, 0x9, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x82, 0x26, 0x3, 0x19, 0x9, 0x7, 0x5, 0x2, 0x5, 0x4, 0x56, 0x4, 0x5, 0x1, 0x5a, 0x1, 0x4, 0x5, 0x2b, 0x1, 0x5e, 0x11, 0x20, 0x30, 0x10, 0x82, 0x0, 0x99, 0xc0, 0x40, 0xa0, 0x56, 0x8d, 0x43, 0x2e, 0x2, 0x81, 0xd, 0x3, 0x10, 0xa, 0x2, 0x14, 0x2f, 0x10, 0x1f, 0x2, 0x50, 0x27, 0x9, 0x2, 0x67, 0x2, 0x40, 0x5, 0x2, 0x1, 0x1, 0x1, 0x5, 0x18, 0x10, 0x1, 0x3, 0x1, 0x4, 0x1, 0x17, 0x1d, 0x34, 0xe, 0x32, 0x3e, 0x6, 0x3, 0x1, 0x1, 0x2, 0xb, 0x1c, 0xa, 0x17, 0x19, 0x1d, 0x7, 0x2f, 0x1c, 0x1, 0x10, 0x5, 0x1, 0xa, 0xa, 0x5, 0x1, 0x29, 0x17, 0x3, 0x1, 0x8, 0x14, 0x17, 0x3, 0x1, 0x3, 0x32, 0x1, 0x1, 0x3, 0x2, 0x2, 0x5, 0x2, 0x1, 0x1, 0x1, 0x18, 0x3, 0x2, 0xb, 0x7, 0x3, 0xc, 0x6, 0x2, 0x6, 0x2, 0x6, 0x9, 0x7, 0x1, 0x7, 0x1, 0x2b, 0x1, 0xe, 0x6, 0x73, 0x1d, 0xa0, 0x2b, 0xa4, 0xc, 0x17, 0x4, 0x31, 0xa0, 0x21, 0x4, 0x81, 0x6e, 0x2, 0x6a, 0x26, 0x7, 0xc, 0x5, 0x5, 0x1, 0x1, 0xa, 0x1, 0xd, 0x1, 0x5, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x6c, 0x21, 0x81, 0x6b, 0x12, 0x40, 0x2, 0x36, 0x28, 0xc, 0x74, 0x5, 0x1, 0x80, 0x87, 0x24, 0x1a, 0x6, 0x1a, 0xb, 0x59, 0x3, 0x6, 0x2, 0x6, 0x2, 0x6, 0x2, 0x3, 0x23, 0xc, 0x1, 0x1a, 0x1, 0x13, 0x1, 0x2, 0x1, 0xf, 0x2, 0xe, 0x22, 0x7b, 0x45, 0x35, 0x81, 0xb, 0x1d, 0x3, 0x31, 0x2f, 0x20, 0xd, 0x1e, 0x5, 0x26, 0xa, 0x1e, 0x2, 0x24, 0x4, 0x8, 0x1, 0x5, 0x2a, 0x80, 0x9e, 0x12, 0x24, 0x4, 0x24, 0x4, 0x28, 0x8, 0x34, 0xc, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x1, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x43, 0x81, 0x37, 0x9, 0x16, 0xa, 0x8, 0x18, 0x6, 0x1, 0x2a, 0x1, 0x9, 0x45, 0x6, 0x2, 0x1, 0x1, 0x2c, 0x1, 0x2, 0x3, 0x1, 0x2, 0x17, 0xa, 0x17, 0x9, 0x1f, 0x41, 0x13, 0x1, 0x2, 0xa, 0x16, 0xa, 0x1a, 0x46, 0x38, 0x6, 0x2, 0x40, 0x1, 0xf, 0x4, 0x1, 0x3, 0x1, 0x1d, 0x2a, 0x1d, 0x3, 0x1d, 0x23, 0x8, 0x1, 0x1c, 0x1b, 0x36, 0xa, 0x16, 0xa, 0x13, 0xd, 0x12, 0x6e, 0x49, 0x37, 0x33, 0xd, 0x33, 0xd, 0x24, 0x81, 0x5c, 0x2a, 0x6, 0x2, 0x4e, 0x1d, 0xa, 0x1, 0x8, 0x16, 0x2a, 0x12, 0x2e, 0x15, 0x1b, 0x17, 0xc, 0x35, 0x39, 0x2, 0x2, 0x1, 0xd, 0x2d, 0x20, 0x19, 0x1a, 0x24, 0x1d, 0x1, 0x2, 0x1, 0x8, 0x23, 0x3, 0x1, 0xc, 0x30, 0xe, 0x4, 0x15, 0x1, 0x1, 0x1, 0x23, 0x12, 0x1, 0x19, 0x13, 0x2, 0x3f, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xf, 0x1, 0xa, 0x7, 0x2f, 0x26, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x12, 0x1, 0xc, 0x5, 0x80, 0x9e, 0x35, 0x12, 0x4, 0x14, 0x3, 0x1e, 0x30, 0x14, 0x2, 0x1, 0x1, 0x80, 0xb8, 0x2f, 0x29, 0x4, 0x24, 0x30, 0x14, 0x1, 0x3b, 0x2b, 0xd, 0x1, 0x47, 0x1b, 0x25, 0x7, 0x80, 0xb9, 0x2c, 0x74, 0x40, 0x1f, 0x8, 0x2, 0x1, 0x2, 0x8, 0x1, 0x2, 0x1, 0x18, 0xf, 0x1, 0x1, 0x1, 0x5e, 0x8, 0x2, 0x27, 0x10, 0x1, 0x1, 0x1, 0x1c, 0x1, 0xa, 0x28, 0x7, 0x1, 0x15, 0x1, 0xb, 0x2e, 0x13, 0x1, 0x12, 0x49, 0x81, 0x7, 0x9, 0x1, 0x25, 0x11, 0x1, 0x31, 0x1e, 0x70, 0x7, 0x1, 0x2, 0x1, 0x26, 0x15, 0x1, 0x19, 0x6, 0x1, 0x2, 0x1, 0x20, 0xe, 0x1, 0x81, 0x47, 0x13, 0xf, 0x1, 0x1, 0xd, 0x1, 0x22, 0x7c, 0x1, 0x4f, 0x83, 0x9a, 0x66, 0x6f, 0x11, 0x80, 0xc4, 0x8a, 0x4c, 0x61, 0xf, 0x84, 0x30, 0x11, 0x6, 0x8f, 0xb9, 0x82, 0x47, 0xa0, 0x21, 0xb9, 0x82, 0x39, 0x7, 0x1f, 0x11, 0x4f, 0x11, 0x1e, 0x12, 0x30, 0x10, 0x4, 0x1f, 0x15, 0x5, 0x13, 0x82, 0xb0, 0x40, 0x80, 0x80, 0x4b, 0x5, 0x1, 0x42, 0xd, 0x40, 0x2, 0x1, 0x1, 0x1c, 0x97, 0xf8, 0x8, 0x84, 0xd6, 0x2a, 0x9, 0xa0, 0x22, 0xe7, 0x4, 0x1, 0x7, 0x1, 0x2, 0x1, 0x81, 0x23, 0xf, 0x1, 0x1d, 0x3, 0x2, 0x1, 0xe, 0x4, 0x8, 0x81, 0x8c, 0x89, 0x4, 0x6b, 0x5, 0xd, 0x3, 0x9, 0x7, 0xa, 0x97, 0x66, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x19, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x8, 0x87, 0x34, 0x1f, 0x6, 0x6, 0x81, 0x5, 0x3e, 0x80, 0x92, 0x2d, 0xa, 0x7, 0x10, 0x1, 0x81, 0x41, 0x1e, 0x12, 0x2c, 0x81, 0xe4, 0x1c, 0x82, 0xf4, 0x7, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf, 0x1, 0x80, 0xc5, 0x3b, 0x44, 0x7, 0x1, 0x84, 0xb4, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11, 0x91, 0x44, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x8c, 0x1f, 0x82, 0x1e, 0x85, 0xe2, 0x93, 0x4b, 0x5, 0x90, 0x60];
_T Cs = [0xa0, 0xd8, 0x0, 0x88, 0x0];
_T Default_Ignorable_Code_Point = [0x80, 0xad, 0x1, 0x82, 0xa1, 0x1, 0x82, 0xcc, 0x1, 0x8b, 0x42, 0x2, 0x86, 0x53, 0x2, 0x55, 0x5, 0x87, 0xfb, 0x5, 0x1a, 0x5, 0x31, 0x10, 0x90, 0xf4, 0x1, 0xa0, 0xcc, 0x9b, 0x10, 0x80, 0xef, 0x1, 0x80, 0xa0, 0x1, 0x4f, 0x9, 0xa0, 0xbc, 0xa7, 0x4, 0x94, 0xcf, 0x8, 0xac, 0x2e, 0x85, 0x90, 0x0];
_T Pd = [0x2d, 0x1, 0x85, 0x5c, 0x1, 0x33, 0x1, 0x8e, 0x41, 0x1, 0x84, 0x5, 0x1, 0x88, 0x9, 0x6, 0x8e, 0x1, 0x1, 0x2, 0x1, 0x1f, 0x2, 0x4, 0x1, 0x1c, 0x1, 0x81, 0xbe, 0x1, 0x13, 0x1, 0x6f, 0x1, 0xa0, 0xcd, 0x90, 0x2, 0x25, 0x1, 0xa, 0x1, 0x80, 0xa9, 0x1, 0x8f, 0x9f, 0x1];
_T Unified_Ideograph = [0xa0, 0x34, 0x0, 0x99, 0xc0, 0x40, 0xa0, 0x52, 0x0, 0xa0, 0x5a, 0xe, 0x2, 0x1, 0x1, 0x1, 0x2, 0xa, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0xa1, 0x5, 0xd6, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x94, 0x1f, 0x93, 0x4b, 0x5, 0x90, 0x60];
_T IDS_Binary_Operator = [0xa0, 0x2f, 0xf0, 0x2, 0x2, 0x8];
_T Sm = [0x2b, 0x1, 0x10, 0x3, 0x3d, 0x1, 0x1, 0x1, 0x2d, 0x1, 0x4, 0x1, 0x25, 0x1, 0x1f, 0x1, 0x82, 0xfe, 0x1, 0x82, 0xf, 0x3, 0x9a, 0x3b, 0x1, 0xd, 0x1, 0x27, 0x3, 0xd, 0x3, 0x80, 0x8b, 0x1, 0x27, 0x5, 0x6, 0x1, 0x44, 0x5, 0x5, 0x2, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x7, 0x1, 0x1f, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1f, 0x81, 0xc, 0x20, 0x2, 0x5a, 0x1, 0x1e, 0x19, 0x28, 0x6, 0x81, 0xd5, 0x1, 0x9, 0x1, 0x36, 0x8, 0x6f, 0x1, 0x81, 0x50, 0x5, 0x2, 0x1f, 0xa, 0x10, 0x81, 0x0, 0x80, 0x83, 0x16, 0x3f, 0x4, 0x20, 0x2, 0x81, 0x2, 0x30, 0x15, 0x2, 0x6, 0xa0, 0xcf, 0xdc, 0x1, 0x83, 0x38, 0x1, 0x1, 0x3, 0x80, 0xa4, 0x1, 0x10, 0x3, 0x3d, 0x1, 0x1, 0x1, 0x80, 0x83, 0x1, 0x6, 0x4, 0xa0, 0xd6, 0xd4, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x97, 0x2c, 0x2];
_T Pi = [0x80, 0xab, 0x1, 0x9f, 0x6c, 0x1, 0x2, 0x2, 0x2, 0x1, 0x19, 0x1, 0x8d, 0xc8, 0x1, 0x1, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf, 0x1, 0x3, 0x1];
_T Other_Grapheme_Extend = [0x89, 0xbe, 0x1, 0x18, 0x1, 0x81, 0x66, 0x1, 0x18, 0x1, 0x66, 0x1, 0x18, 0x1, 0x80, 0xea, 0x1, 0x12, 0x2, 0x67, 0x1, 0x18, 0x1, 0x77, 0x1, 0xf, 0x1, 0x8d, 0x55, 0x1, 0x84, 0xd6, 0x1, 0x90, 0x21, 0x2, 0xa0, 0xcf, 0x6e, 0x2, 0x93, 0x9e, 0x1, 0x18, 0x1, 0x81, 0x58, 0x1, 0xc, 0x1, 0x80, 0xf1, 0x1, 0x83, 0x80, 0x1, 0xa0, 0xb8, 0x34, 0x1, 0x8, 0x5, 0xac, 0x2e, 0xad, 0x60];
_T Grapheme_Extend = [0x83, 0x0, 0x70, 0x81, 0x13, 0x7, 0x81, 0x7, 0x2d, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x48, 0xb, 0x30, 0x15, 0x10, 0x1, 0x65, 0x7, 0x2, 0x6, 0x2, 0x2, 0x1, 0x4, 0x23, 0x1, 0x1e, 0x1b, 0x5b, 0xb, 0x3a, 0x9, 0x9, 0x1, 0x18, 0x4, 0x1, 0x9, 0x1, 0x3, 0x1, 0x5, 0x2b, 0x3, 0x3c, 0x8, 0x2a, 0x18, 0x1, 0x20, 0x37, 0x1, 0x1, 0x1, 0x4, 0x8, 0x4, 0x1, 0x3, 0x7, 0xa, 0x2, 0x1d, 0x1, 0x3a, 0x1, 0x1, 0x1, 0x2, 0x4, 0x8, 0x1, 0x9, 0x1, 0xa, 0x2, 0x1a, 0x1, 0x2, 0x2, 0x39, 0x1, 0x4, 0x2, 0x4, 0x2, 0x2, 0x3, 0x3, 0x1, 0x1e, 0x2, 0x3, 0x1, 0xb, 0x2, 0x39, 0x1, 0x4, 0x5, 0x1, 0x2, 0x4, 0x1, 0x14, 0x2, 0x16, 0x6, 0x1, 0x1, 0x3a, 0x1, 0x1, 0x2, 0x1, 0x4, 0x8, 0x1, 0x7, 0x3, 0xa, 0x2, 0x1e, 0x1, 0x3b, 0x1, 0x1, 0x1, 0xc, 0x1, 0x9, 0x1, 0x28, 0x1, 0x3, 0x1, 0x37, 0x1, 0x1, 0x3, 0x5, 0x3, 0x1, 0x4, 0x7, 0x2, 0xb, 0x2, 0x1d, 0x1, 0x3a, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 0x5, 0x2, 0x7, 0x2, 0xb, 0x2, 0x1c, 0x2, 0x39, 0x2, 0x1, 0x1, 0x2, 0x4, 0x8, 0x1, 0x9, 0x1, 0xa, 0x2, 0x1d, 0x1, 0x48, 0x1, 0x4, 0x1, 0x2, 0x3, 0x1, 0x1, 0x8, 0x1, 0x51, 0x1, 0x2, 0x7, 0xc, 0x8, 0x62, 0x1, 0x2, 0x9, 0xb, 0x7, 0x49, 0x2, 0x1b, 0x1, 0x1, 0x1, 0x1, 0x1, 0x37, 0xe, 0x1, 0x5, 0x1, 0x2, 0x5, 0xb, 0x1, 0x24, 0x9, 0x1, 0x66, 0x4, 0x1, 0x6, 0x1, 0x2, 0x2, 0x2, 0x19, 0x2, 0x4, 0x3, 0x10, 0x4, 0xd, 0x1, 0x2, 0x2, 0x6, 0x1, 0xf, 0x1, 0x82, 0xbf, 0x3, 0x83, 0xb2, 0x3, 0x1d, 0x2, 0x1e, 0x2, 0x1e, 0x2, 0x40, 0x2, 0x1, 0x7, 0x8, 0x1, 0x2, 0xb, 0x9, 0x1, 0x2d, 0x3, 0x1, 0x1, 0x75, 0x2, 0x22, 0x1, 0x76, 0x3, 0x4, 0x2, 0x9, 0x1, 0x6, 0x3, 0x80, 0xdb, 0x2, 0x2, 0x1, 0x3a, 0x1, 0x1, 0x7, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0x6, 0xa, 0x2, 0x1, 0x30, 0x1f, 0x31, 0x4, 0x30, 0x7, 0x1, 0x1, 0x5, 0x1, 0x28, 0x9, 0xc, 0x2, 0x20, 0x4, 0x2, 0x2, 0x1, 0x3, 0x38, 0x1, 0x1, 0x2, 0x3, 0x1, 0x1, 0x3, 0x3a, 0x8, 0x2, 0x2, 0x80, 0x98, 0x3, 0x1, 0xd, 0x1, 0x7, 0x4, 0x1, 0x6, 0x1, 0x3, 0x2, 0x80, 0xc6, 0x40, 0x82, 0xc, 0x1, 0x80, 0xc3, 0x21, 0x8b, 0xfe, 0x3, 0x80, 0x8d, 0x1, 0x60, 0x20, 0x82, 0x2a, 0x6, 0x69, 0x2, 0xa0, 0x75, 0xd4, 0x4, 0x1, 0xa, 0x20, 0x2, 0x50, 0x2, 0x81, 0x10, 0x1, 0x3, 0x1, 0x4, 0x1, 0x19, 0x2, 0x5, 0x1, 0x80, 0x97, 0x2, 0x1a, 0x12, 0xd, 0x1, 0x26, 0x8, 0x19, 0xb, 0x2e, 0x3, 0x30, 0x1, 0x2, 0x4, 0x2, 0x2, 0x27, 0x1, 0x43, 0x6, 0x2, 0x2, 0x2, 0x2, 0xc, 0x1, 0x8, 0x1, 0x2f, 0x1, 0x33, 0x1, 0x1, 0x3, 0x2, 0x2, 0x5, 0x2, 0x1, 0x1, 0x2a, 0x2, 0x8, 0x1, 0x80, 0xee, 0x1, 0x2, 0x1, 0x4, 0x1, 0xa0, 0x4f, 0x30, 0x1, 0x82, 0xe1, 0x10, 0x10, 0x10, 0x81, 0x6e, 0x2, 0x82, 0x5d, 0x1, 0x80, 0xe2, 0x1, 0x80, 0x95, 0x5, 0x86, 0x86, 0x3, 0x1, 0x2, 0x5, 0x4, 0x28, 0x3, 0x4, 0x1, 0x80, 0xa5, 0x2, 0x82, 0x3d, 0x4, 0x81, 0x83, 0x2, 0x50, 0x3, 0x46, 0xb, 0x31, 0x4, 0x7b, 0x1, 0x36, 0xf, 0x29, 0x1, 0x2, 0x2, 0xa, 0x3, 0x31, 0x4, 0x2, 0x2, 0x7, 0x1, 0x3d, 0x3, 0x24, 0x5, 0x1, 0x8, 0x3e, 0x1, 0xc, 0x2, 0x34, 0x9, 0xa, 0x4, 0x2, 0x1, 0x5f, 0x3, 0x2, 0x1, 0x1, 0x2, 0x6, 0x1, 0x2, 0x1, 0x80, 0x9d, 0x1, 0x3, 0x8, 0x15, 0x2, 0x39, 0x2, 0x1, 0x1, 0x1, 0x1, 0x16, 0x1, 0xe, 0x7, 0x3, 0x5, 0x80, 0xc3, 0x8, 0x2, 0x3, 0x1, 0x1, 0x17, 0x1, 0x51, 0x1, 0x2, 0x6, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x80, 0xeb, 0x1, 0x2, 0x4, 0x6, 0x2, 0x1, 0x2, 0x1b, 0x2, 0x55, 0x8, 0x2, 0x1, 0x1, 0x2, 0x6a, 0x1, 0x1, 0x1, 0x2, 0x6, 0x1, 0x1, 0x65, 0x3, 0x2, 0x4, 0x1, 0x5, 0x81, 0x3, 0x9, 0x1, 0x2, 0x80, 0xf5, 0x1, 0xa, 0x2, 0x1, 0x1, 0x4, 0x1, 0x80, 0x90, 0x4, 0x2, 0x2, 0x4, 0x1, 0x20, 0xa, 0x28, 0x6, 0x2, 0x4, 0x8, 0x1, 0x9, 0x6, 0x2, 0x3, 0x2e, 0xd, 0x1, 0x2, 0x81, 0x96, 0x7, 0x1, 0x6, 0x1, 0x1, 0x52, 0x16, 0x2, 0x7, 0x1, 0x2, 0x1, 0x2, 0x7a, 0x6, 0x3, 0x1, 0x1, 0x2, 0x1, 0x7, 0x1, 0x1, 0x48, 0x2, 0x3, 0x1, 0x1, 0x1, 0x81, 0x5b, 0x2, 0xb, 0x2, 0x34, 0x5, 0x5, 0x1, 0x1, 0x1, 0x94, 0xfd, 0x1, 0x6, 0xf, 0xa0, 0x36, 0x9a, 0x5, 0x3b, 0x7, 0x84, 0x18, 0x1, 0x3f, 0x4, 0x51, 0x1, 0xa0, 0x4c, 0xb8, 0x2, 0x92, 0x61, 0x2e, 0x2, 0x17, 0x82, 0x1e, 0x1, 0x1, 0x3, 0x4, 0x5, 0x8, 0x8, 0x2, 0x7, 0x1e, 0x4, 0x80, 0x94, 0x3, 0x87, 0xbb, 0x37, 0x4, 0x32, 0x8, 0x1, 0xe, 0x1, 0x16, 0x5, 0x1, 0xf, 0x85, 0x50, 0x7, 0x1, 0x11, 0x2, 0x7, 0x1, 0x2, 0x1, 0x5, 0x64, 0x1, 0x80, 0xa0, 0x7, 0x81, 0x77, 0x1, 0x3d, 0x4, 0x81, 0xfc, 0x4, 0x83, 0xe0, 0x7, 0x6d, 0x7, 0xac, 0x16, 0xd5, 0x60, 0x80, 0x80, 0x80, 0xf0];
_T Other_ID_Start = [0x98, 0x85, 0x2, 0x88, 0x91, 0x1, 0x15, 0x1, 0x8f, 0x6c, 0x2];
_T Pattern_Syntax = [0x21, 0xf, 0xa, 0x7, 0x1a, 0x4, 0x1, 0x1, 0x1a, 0x4, 0x22, 0x7, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x2, 0x4, 0x1, 0x4, 0x1, 0x3, 0x1, 0x17, 0x1, 0x1f, 0x1, 0x9f, 0x18, 0x18, 0x8, 0xf, 0x2, 0x13, 0x1, 0xa, 0x81, 0x31, 0x82, 0xd0, 0x80, 0xa0, 0x82, 0x76, 0x1e, 0x84, 0x6c, 0x82, 0x0, 0x80, 0x80, 0x81, 0x81, 0x3, 0x4, 0x19, 0xf, 0x1, 0xa0, 0xcd, 0xd, 0x2, 0x81, 0x5, 0x2];
_T Lu = [0x41, 0x1a, 0x65, 0x17, 0x1, 0x7, 0x21, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x1, 0x3, 0x2, 0x4, 0x1, 0x2, 0x1, 0x3, 0x3, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x3, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x2, 0x1, 0x2, 0x2, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x81, 0x21, 0x1, 0x1, 0x1, 0x3, 0x1, 0x8, 0x1, 0x6, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x11, 0x1, 0x9, 0x23, 0x1, 0x2, 0x3, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x33, 0x30, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x26, 0x8b, 0x49, 0x26, 0x1, 0x1, 0x5, 0x1, 0x82, 0xd2, 0x56, 0x88, 0x9a, 0x2b, 0x2, 0x3, 0x81, 0x40, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x8, 0x8, 0x6, 0xa, 0x8, 0x8, 0x8, 0x8, 0x6, 0xb, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x8, 0x8, 0x48, 0x4, 0xc, 0x4, 0xc, 0x4, 0xc, 0x5, 0xb, 0x4, 0x81, 0x6, 0x1, 0x4, 0x1, 0x3, 0x3, 0x2, 0x3, 0x2, 0x1, 0x3, 0x5, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x2, 0x4, 0xa, 0x2, 0x5, 0x1, 0x3d, 0x1, 0x8a, 0x7c, 0x30, 0x30, 0x1, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x2, 0x1, 0x8, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x8, 0x1, 0x1, 0x1, 0x4, 0x1, 0xa0, 0x79, 0x4d, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x13, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x80, 0x87, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0xa, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x6, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1c, 0x1, 0xa0, 0x57, 0x2b, 0x1a, 0x84, 0xc5, 0x28, 0x80, 0x88, 0x24, 0x80, 0x9c, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x86, 0xea, 0x33, 0x8b, 0xed, 0x20, 0xa0, 0x55, 0x80, 0x20, 0xa0, 0x65, 0xa0, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0x8, 0x1a, 0x1a, 0x1a, 0x2, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1b, 0x2, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1b, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1e, 0x19, 0x21, 0x19, 0x21, 0x19, 0x21, 0x19, 0x21, 0x19, 0x21, 0x1, 0x91, 0x35, 0x22];
_T Case_Ignorable = [0x27, 0x1, 0x6, 0x1, 0xb, 0x1, 0x23, 0x1, 0x1, 0x1, 0x47, 0x1, 0x4, 0x1, 0x1, 0x1, 0x4, 0x1, 0x2, 0x2, 0x81, 0xf7, 0x80, 0xc0, 0x4, 0x2, 0x4, 0x1, 0x9, 0x2, 0x1, 0x1, 0x80, 0xfb, 0x7, 0x80, 0xcf, 0x1, 0x5, 0x1, 0x31, 0x2d, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2c, 0x1, 0xb, 0x6, 0xa, 0xb, 0x1, 0x1, 0x23, 0x1, 0xa, 0x15, 0x10, 0x1, 0x65, 0x8, 0x1, 0xa, 0x1, 0x4, 0x21, 0x1, 0x1, 0x1, 0x1e, 0x1b, 0x5b, 0xb, 0x3a, 0xb, 0x4, 0x1, 0x2, 0x1, 0x18, 0x18, 0x2b, 0x3, 0x2c, 0x1, 0x7, 0x2, 0x6, 0x8, 0x29, 0x3a, 0x37, 0x1, 0x1, 0x1, 0x4, 0x8, 0x4, 0x1, 0x3, 0x7, 0xa, 0x2, 0xd, 0x1, 0xf, 0x1, 0x3a, 0x1, 0x4, 0x4, 0x8, 0x1, 0x14, 0x2, 0x1a, 0x1, 0x2, 0x2, 0x39, 0x1, 0x4, 0x2, 0x4, 0x2, 0x2, 0x3, 0x3, 0x1, 0x1e, 0x2, 0x3, 0x1, 0xb, 0x2, 0x39, 0x1, 0x4, 0x5, 0x1, 0x2, 0x4, 0x1, 0x14, 0x2, 0x16, 0x6, 0x1, 0x1, 0x3a, 0x1, 0x2, 0x1, 0x1, 0x4, 0x8, 0x1, 0x7, 0x2, 0xb, 0x2, 0x1e, 0x1, 0x3d, 0x1, 0xc, 0x1, 0x32, 0x1, 0x3, 0x1, 0x37, 0x1, 0x1, 0x3, 0x5, 0x3, 0x1, 0x4, 0x7, 0x2, 0xb, 0x2, 0x1d, 0x1, 0x3a, 0x1, 0x2, 0x1, 0x6, 0x1, 0x5, 0x2, 0x14, 0x2, 0x1c, 0x2, 0x39, 0x2, 0x4, 0x4, 0x8, 0x1, 0x14, 0x2, 0x1d, 0x1, 0x48, 0x1, 0x7, 0x3, 0x1, 0x1, 0x5a, 0x1, 0x2, 0x7, 0xb, 0x9, 0x62, 0x1, 0x2, 0x9, 0x9, 0x1, 0x1, 0x7, 0x49, 0x2, 0x1b, 0x1, 0x1, 0x1, 0x1, 0x1, 0x37, 0xe, 0x1, 0x5, 0x1, 0x2, 0x5, 0xb, 0x1, 0x24, 0x9, 0x1, 0x66, 0x4, 0x1, 0x6, 0x1, 0x2, 0x2, 0x2, 0x19, 0x2, 0x4, 0x3, 0x10, 0x4, 0xd, 0x1, 0x2, 0x2, 0x6, 0x1, 0xf, 0x1, 0x5e, 0x1, 0x82, 0x60, 0x3, 0x83, 0xb2, 0x3, 0x1d, 0x2, 0x1e, 0x2, 0x1e, 0x2, 0x40, 0x2, 0x1, 0x7, 0x8, 0x1, 0x2, 0xb, 0x3, 0x1, 0x5, 0x1, 0x2d, 0x5, 0x33, 0x1, 0x41, 0x2, 0x22, 0x1, 0x76, 0x3, 0x4, 0x2, 0x9, 0x1, 0x6, 0x3, 0x80, 0xdb, 0x2, 0x2, 0x1, 0x3a, 0x1, 0x1, 0x7, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0x6, 0xa, 0x2, 0x1, 0x27, 0x1, 0x8, 0x1f, 0x31, 0x4, 0x30, 0x1, 0x1, 0x5, 0x1, 0x1, 0x5, 0x1, 0x28, 0x9, 0xc, 0x2, 0x20, 0x4, 0x2, 0x2, 0x1, 0x3, 0x38, 0x1, 0x1, 0x2, 0x3, 0x1, 0x1, 0x3, 0x3a, 0x8, 0x2, 0x2, 0x40, 0x6, 0x52, 0x3, 0x1, 0xd, 0x1, 0x7, 0x4, 0x1, 0x6, 0x1, 0x3, 0x2, 0x32, 0x3f, 0xd, 0x1, 0x22, 0x65, 0x81, 0xbd, 0x1, 0x1, 0x3, 0xb, 0x3, 0xd, 0x3, 0xd, 0x3, 0xd, 0x2, 0xc, 0x5, 0x8, 0x2, 0xa, 0x1, 0x2, 0x1, 0x2, 0x5, 0x31, 0x5, 0x1, 0xa, 0x1, 0x1, 0xd, 0x1, 0x10, 0xd, 0x33, 0x21, 0x8b, 0x8b, 0x2, 0x71, 0x3, 0x7d, 0x1, 0xf, 0x1, 0x60, 0x20, 0x2f, 0x1, 0x81, 0xd5, 0x1, 0x24, 0x4, 0x3, 0x5, 0x5, 0x1, 0x5d, 0x6, 0x5d, 0x3, 0xa0, 0x6f, 0x16, 0x1, 0x84, 0xe2, 0x6, 0x81, 0xe, 0x1, 0x62, 0x4, 0x1, 0xa, 0x1, 0x1, 0x1c, 0x4, 0x50, 0x2, 0xe, 0x22, 0x4e, 0x1, 0x17, 0x3, 0x67, 0x3, 0x3, 0x2, 0x8, 0x1, 0x3, 0x1, 0x4, 0x1, 0x19, 0x2, 0x5, 0x1, 0x80, 0x97, 0x2, 0x1a, 0x12, 0xd, 0x1, 0x26, 0x8, 0x19, 0xb, 0x2e, 0x3, 0x30, 0x1, 0x2, 0x4, 0x2, 0x2, 0x11, 0x1, 0x15, 0x2, 0x42, 0x6, 0x2, 0x2, 0x2, 0x2, 0xc, 0x1, 0x8, 0x1, 0x23, 0x1, 0xb, 0x1, 0x33, 0x1, 0x1, 0x3, 0x2, 0x2, 0x5, 0x2, 0x1, 0x1, 0x1b, 0x1, 0xe, 0x2, 0x5, 0x2, 0x1, 0x1, 0x64, 0x5, 0x9, 0x3, 0x79, 0x1, 0x2, 0x1, 0x4, 0x1, 0xa0, 0x4f, 0x30, 0x1, 0x80, 0x93, 0x11, 0x82, 0x3d, 0x10, 0x3, 0x1, 0xc, 0x10, 0x22, 0x1, 0x2, 0x1, 0x80, 0xa9, 0x1, 0x7, 0x1, 0x6, 0x1, 0xb, 0x1, 0x23, 0x1, 0x1, 0x1, 0x2f, 0x1, 0x2d, 0x2, 0x43, 0x1, 0x15, 0x3, 0x82, 0x1, 0x1, 0x80, 0xe2, 0x1, 0x80, 0x95, 0x5, 0x84, 0x5, 0x6, 0x1, 0x2a, 0x1, 0x9, 0x82, 0x46, 0x3, 0x1, 0x2, 0x5, 0x4, 0x28, 0x3, 0x4, 0x1, 0x80, 0xa5, 0x2, 0x82, 0x3d, 0x4, 0x81, 0x83, 0x2, 0x50, 0x3, 0x46, 0xb, 0x31, 0x4, 0x7b, 0x1, 0x36, 0xf, 0x29, 0x1, 0x2, 0x2, 0xa, 0x3, 0x31, 0x4, 0x2, 0x2, 0x2, 0x1, 0x4, 0x1, 0xa, 0x1, 0x32, 0x3, 0x24, 0x5, 0x1, 0x8, 0x3e, 0x1, 0xc, 0x2, 0x34, 0x9, 0xa, 0x4, 0x2, 0x1, 0x5f, 0x3, 0x2, 0x1, 0x1, 0x2, 0x6, 0x1, 0x2, 0x1, 0x80, 0x9d, 0x1, 0x3, 0x8, 0x15, 0x2, 0x39, 0x2, 0x3, 0x1, 0x25, 0x7, 0x3, 0x5, 0x80, 0xc3, 0x8, 0x2, 0x3, 0x1, 0x1, 0x17, 0x1, 0x54, 0x6, 0x1, 0x1, 0x4, 0x2, 0x1, 0x2, 0x80, 0xee, 0x4, 0x6, 0x2, 0x1, 0x2, 0x1b, 0x2, 0x55, 0x8, 0x2, 0x1, 0x1, 0x2, 0x6a, 0x1, 0x1, 0x1, 0x2, 0x6, 0x1, 0x1, 0x65, 0x3, 0x2, 0x4, 0x1, 0x5, 0x81, 0x3, 0x9, 0x1, 0x2, 0x81, 0x0, 0x2, 0x1, 0x1, 0x4, 0x1, 0x80, 0x90, 0x4, 0x2, 0x2, 0x4, 0x1, 0x20, 0xa, 0x28, 0x6, 0x2, 0x4, 0x8, 0x1, 0x9, 0x6, 0x2, 0x3, 0x2e, 0xd, 0x1, 0x2, 0x81, 0x96, 0x7, 0x1, 0x6, 0x1, 0x1, 0x52, 0x16, 0x2, 0x7, 0x1, 0x2, 0x1, 0x2, 0x7a, 0x6, 0x3, 0x1, 0x1, 0x2, 0x1, 0x7, 0x1, 0x1, 0x48, 0x2, 0x3, 0x1, 0x1, 0x1, 0x81, 0x5b, 0x2, 0xb, 0x2, 0x34, 0x5, 0x5, 0x1, 0x1, 0x1, 0x94, 0xed, 0x11, 0x6, 0xf, 0xa0, 0x36, 0x9a, 0x5, 0x3b, 0x7, 0x9, 0x4, 0x84, 0xb, 0x1, 0x3f, 0x11, 0x40, 0x2, 0x1, 0x2, 0xa0, 0x40, 0xb, 0x4, 0x1, 0x7, 0x1, 0x2, 0x8c, 0x9e, 0x2, 0x1, 0x4, 0x92, 0x5c, 0x2e, 0x2, 0x17, 0x82, 0x20, 0x3, 0x9, 0x10, 0x2, 0x7, 0x1e, 0x4, 0x80, 0x94, 0x3, 0x87, 0xbb, 0x37, 0x4, 0x32, 0x8, 0x1, 0xe, 0x1, 0x16, 0x5, 0x1, 0xf, 0x85, 0x50, 0x7, 0x1, 0x11, 0x2, 0x7, 0x1, 0x2, 0x1, 0x5, 0x5, 0x3e, 0x21, 0x1, 0x80, 0xa0, 0xe, 0x81, 0x70, 0x1, 0x3d, 0x4, 0x81, 0xfb, 0x5, 0x83, 0xe0, 0x7, 0x6d, 0x8, 0x8a, 0xaf, 0x5, 0xac, 0xc, 0x1, 0x1, 0x1e, 0x60, 0x80, 0x80, 0x80, 0xf0];
_T Lo = [0x80, 0xaa, 0x1, 0xf, 0x1, 0x81, 0x0, 0x1, 0x4, 0x4, 0x80, 0xd0, 0x1, 0x83, 0x3b, 0x1b, 0x4, 0x4, 0x2d, 0x20, 0x1, 0xa, 0x23, 0x2, 0x1, 0x63, 0x1, 0x1, 0x18, 0x2, 0xa, 0x3, 0x2, 0x1, 0x10, 0x1, 0x1, 0x1e, 0x1d, 0x59, 0xb, 0x1, 0x18, 0x21, 0x15, 0x16, 0x2a, 0x19, 0x7, 0xb, 0x5, 0x18, 0x1, 0x6, 0x11, 0x29, 0x3b, 0x36, 0x3, 0x1, 0x12, 0x1, 0x7, 0xa, 0x10, 0xf, 0x4, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x1, 0x3, 0x4, 0x3, 0x1, 0x10, 0x1, 0xd, 0x2, 0x1, 0x3, 0xe, 0x2, 0xa, 0x1, 0x8, 0x6, 0x4, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1f, 0x4, 0x1, 0x1, 0x13, 0x3, 0x10, 0x9, 0x1, 0x3, 0x1, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x12, 0x1, 0xf, 0x2, 0x17, 0x1, 0xb, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x1e, 0x2, 0x1, 0x3, 0xf, 0x1, 0x11, 0x1, 0x1, 0x6, 0x3, 0x3, 0x1, 0x4, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0xc, 0x16, 0x1, 0x34, 0x8, 0x1, 0x3, 0x1, 0x17, 0x1, 0x10, 0x3, 0x1, 0x1a, 0x3, 0x2, 0x1, 0x2, 0x2, 0x1e, 0x1, 0x4, 0x8, 0x1, 0x3, 0x1, 0x17, 0x1, 0xa, 0x1, 0x5, 0x3, 0x1, 0x1f, 0x2, 0x1, 0x2, 0xf, 0x2, 0x11, 0x9, 0x1, 0x3, 0x1, 0x29, 0x2, 0x1, 0x10, 0x1, 0x5, 0x3, 0x8, 0x3, 0x18, 0x6, 0x5, 0x12, 0x3, 0x18, 0x1, 0x9, 0x1, 0x1, 0x2, 0x7, 0x3a, 0x30, 0x1, 0x2, 0xc, 0x6, 0x3b, 0x2, 0x1, 0x1, 0x1, 0x5, 0x1, 0x18, 0x1, 0x1, 0x1, 0xa, 0x1, 0x2, 0x9, 0x1, 0x2, 0x5, 0x17, 0x4, 0x20, 0x1, 0x3f, 0x8, 0x1, 0x24, 0x1b, 0x5, 0x73, 0x2b, 0x14, 0x1, 0x10, 0x6, 0x4, 0x4, 0x3, 0x1, 0x3, 0x2, 0x7, 0x3, 0x4, 0xd, 0xc, 0x1, 0x71, 0x81, 0x49, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0x29, 0x1, 0x4, 0x2, 0x21, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0xf, 0x1, 0x39, 0x1, 0x4, 0x2, 0x43, 0x25, 0x10, 0x71, 0x82, 0x6c, 0x2, 0x11, 0x1, 0x1a, 0x5, 0x4b, 0x6, 0x8, 0x7, 0x12, 0xd, 0x13, 0xe, 0x12, 0xe, 0xd, 0x1, 0x3, 0xf, 0x34, 0x28, 0x1, 0x43, 0x23, 0x1, 0x35, 0x7, 0x5, 0x2, 0x22, 0x1, 0x1, 0x5, 0x46, 0xa, 0x1f, 0x31, 0x1e, 0x2, 0x5, 0xb, 0x2c, 0x4, 0x1a, 0x36, 0x17, 0x9, 0x35, 0x80, 0xb0, 0x2f, 0x11, 0x8, 0x36, 0x1e, 0xd, 0x2, 0xa, 0x2c, 0x1a, 0x24, 0x29, 0x3, 0xa, 0x1e, 0x71, 0x4, 0x1, 0x6, 0x1, 0x2, 0x3, 0x1, 0x84, 0x3a, 0x4, 0x8b, 0xf7, 0x38, 0x18, 0x17, 0x9, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x82, 0x27, 0x1, 0x35, 0x1, 0x4, 0x56, 0x8, 0x1, 0x1, 0x5a, 0x4, 0x1, 0x5, 0x2b, 0x1, 0x5e, 0x11, 0x20, 0x30, 0x10, 0x82, 0x0, 0x99, 0xc0, 0x40, 0xa0, 0x52, 0x15, 0x1, 0x84, 0x77, 0x43, 0x28, 0x8, 0x81, 0xc, 0x4, 0x10, 0xa, 0x2, 0x42, 0x1, 0x31, 0x46, 0x80, 0xa9, 0x1, 0x67, 0x1, 0x3, 0x7, 0x1, 0x3, 0x1, 0x4, 0x1, 0x17, 0x1d, 0x34, 0xe, 0x32, 0x3e, 0x6, 0x3, 0x1, 0x1, 0x2, 0xb, 0x1c, 0xa, 0x17, 0x19, 0x1d, 0x7, 0x2f, 0x2d, 0x5, 0x2, 0x9, 0xa, 0x5, 0x1, 0x29, 0x17, 0x3, 0x1, 0x8, 0x14, 0x10, 0x1, 0x6, 0x3, 0x1, 0x3, 0x32, 0x1, 0x1, 0x3, 0x2, 0x2, 0x5, 0x2, 0x1, 0x1, 0x1, 0x18, 0x2, 0x3, 0xb, 0x7, 0x1, 0xe, 0x6, 0x2, 0x6, 0x2, 0x6, 0x9, 0x7, 0x1, 0x7, 0x80, 0x91, 0x23, 0x1d, 0xa0, 0x2b, 0xa4, 0xc, 0x17, 0x4, 0x31, 0xa0, 0x21, 0x4, 0x81, 0x6e, 0x2, 0x6a, 0x43, 0x1, 0x1, 0xa, 0x1, 0xd, 0x1, 0x5, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x6c, 0x21, 0x81, 0x6b, 0x12, 0x40, 0x2, 0x36, 0x28, 0xc, 0x74, 0x5, 0x1, 0x80, 0x87, 0x69, 0xa, 0x1, 0x2d, 0x2, 0x1f, 0x3, 0x6, 0x2, 0x6, 0x2, 0x6, 0x2, 0x3, 0x23, 0xc, 0x1, 0x1a, 0x1, 0x13, 0x1, 0x2, 0x1, 0xf, 0x2, 0xe, 0x22, 0x7b, 0x81, 0x85, 0x1d, 0x3, 0x31, 0x2f, 0x20, 0xd, 0x14, 0x1, 0x8, 0x6, 0x26, 0xa, 0x1e, 0x2, 0x24, 0x4, 0x8, 0x80, 0x80, 0x4e, 0x62, 0x28, 0x8, 0x34, 0x80, 0x9c, 0x81, 0x37, 0x9, 0x16, 0xa, 0x8, 0x80, 0x98, 0x6, 0x2, 0x1, 0x1, 0x2c, 0x1, 0x2, 0x3, 0x1, 0x2, 0x17, 0xa, 0x17, 0x9, 0x1f, 0x41, 0x13, 0x1, 0x2, 0xa, 0x16, 0xa, 0x1a, 0x46, 0x38, 0x6, 0x2, 0x40, 0x1, 0xf, 0x4, 0x1, 0x3, 0x1, 0x1d, 0x2a, 0x1d, 0x3, 0x1d, 0x23, 0x8, 0x1, 0x1c, 0x1b, 0x36, 0xa, 0x16, 0xa, 0x13, 0xd, 0x12, 0x6e, 0x49, 0x80, 0xb7, 0x24, 0x81, 0x5c, 0x2a, 0x6, 0x2, 0x4e, 0x1d, 0xa, 0x1, 0x8, 0x16, 0x2a, 0x12, 0x2e, 0x15, 0x1b, 0x17, 0xc, 0x35, 0x39, 0x2, 0x2, 0x1, 0xd, 0x2d, 0x20, 0x19, 0x1a, 0x24, 0x1d, 0x1, 0x2, 0x1, 0x8, 0x23, 0x3, 0x1, 0xc, 0x30, 0xe, 0x4, 0x15, 0x1, 0x1, 0x1, 0x23, 0x12, 0x1, 0x19, 0x13, 0x2, 0x3f, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xf, 0x1, 0xa, 0x7, 0x2f, 0x26, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x12, 0x1, 0xc, 0x5, 0x80, 0x9e, 0x35, 0x12, 0x4, 0x14, 0x3, 0x1e, 0x30, 0x14, 0x2, 0x1, 0x1, 0x80, 0xb8, 0x2f, 0x29, 0x4, 0x24, 0x30, 0x14, 0x1, 0x3b, 0x2b, 0xd, 0x1, 0x47, 0x1b, 0x25, 0x7, 0x80, 0xb9, 0x2c, 0x80, 0xd3, 0x8, 0x2, 0x1, 0x2, 0x8, 0x1, 0x2, 0x1, 0x18, 0xf, 0x1, 0x1, 0x1, 0x5e, 0x8, 0x2, 0x27, 0x10, 0x1, 0x1, 0x1, 0x1c, 0x1, 0xa, 0x28, 0x7, 0x1, 0x15, 0x1, 0xb, 0x2e, 0x13, 0x1, 0x12, 0x49, 0x81, 0x7, 0x9, 0x1, 0x25, 0x11, 0x1, 0x31, 0x1e, 0x70, 0x7, 0x1, 0x2, 0x1, 0x26, 0x15, 0x1, 0x19, 0x6, 0x1, 0x2, 0x1, 0x20, 0xe, 0x1, 0x81, 0x47, 0x13, 0xf, 0x1, 0x1, 0xd, 0x1, 0x22, 0x7c, 0x1, 0x4f, 0x83, 0x9a, 0x80, 0xe6, 0x80, 0xc4, 0x8a, 0x4c, 0x61, 0xf, 0x84, 0x30, 0x11, 0x6, 0x8f, 0xb9, 0x82, 0x47, 0xa0, 0x21, 0xb9, 0x82, 0x39, 0x7, 0x1f, 0x11, 0x4f, 0x11, 0x1e, 0x12, 0x30, 0x33, 0x15, 0x5, 0x13, 0x83, 0x70, 0x4b, 0x5, 0x1, 0x80, 0xaf, 0x97, 0xf8, 0x8, 0x84, 0xd6, 0x2a, 0x9, 0xa0, 0x22, 0xf7, 0x81, 0x23, 0xf, 0x1, 0x1d, 0x3, 0x2, 0x1, 0xe, 0x4, 0x8, 0x81, 0x8c, 0x89, 0x4, 0x6b, 0x5, 0xd, 0x3, 0x9, 0x7, 0xa, 0xa0, 0x22, 0x70, 0x1, 0x81, 0xf5, 0x2d, 0x21, 0x1, 0x81, 0x41, 0x1e, 0x12, 0x2c, 0x81, 0xe4, 0x1b, 0x82, 0xf5, 0x7, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf, 0x1, 0x80, 0xc5, 0x85, 0x3b, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11, 0x91, 0x44, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x8c, 0x1f, 0x82, 0x1e, 0x85, 0xe2, 0x93, 0x4b, 0x5, 0x90, 0x60];
_T Pc = [0x5f, 0x1, 0x9f, 0xdf, 0x2, 0x13, 0x1, 0xa0, 0xdd, 0xde, 0x2, 0x18, 0x3, 0x80, 0xef, 0x1];
_T Bidi_Control = [0x86, 0x1c, 0x1, 0x99, 0xf1, 0x2, 0x1a, 0x5, 0x37, 0x4];
_T Co = [0xa0, 0xe0, 0x0, 0x99, 0x0, 0xae, 0x7, 0x0, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe];
_T Variation_Selector = [0x98, 0xb, 0x3, 0x1, 0x1, 0xa0, 0xe5, 0xf0, 0x10, 0xad, 0x2, 0xf0, 0x80, 0xf0];
_T Soft_Dotted = [0x69, 0x2, 0x80, 0xc4, 0x1, 0x81, 0x19, 0x1, 0x1e, 0x1, 0x34, 0x1, 0x14, 0x1, 0x81, 0x40, 0x1, 0x62, 0x1, 0x1, 0x1, 0x99, 0x9, 0x1, 0x33, 0x1, 0xd, 0x1, 0x3, 0x1, 0x80, 0x84, 0x1, 0x80, 0x9d, 0x1, 0x81, 0xa5, 0x1, 0x80, 0xd6, 0x2, 0x8b, 0x32, 0x1, 0xa1, 0xa7, 0xa5, 0x2, 0x32, 0x2, 0x32, 0x2, 0x32, 0x2, 0x32, 0x2, 0x32, 0x2, 0x32, 0x2, 0x32, 0x2, 0x32, 0x2, 0x32, 0x2, 0x32, 0x2, 0x32, 0x2, 0x32, 0x2, 0x88, 0x86, 0x1, 0x81, 0x31, 0x2, 0x1a, 0x1];
_T Noncharacter_Code_Point = [0xa0, 0xfd, 0xd0, 0x20, 0x82, 0xe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe];
_T Logical_Order_Exception = [0x8e, 0x40, 0x5, 0x7b, 0x5, 0x8a, 0xf0, 0x3, 0x2, 0x1, 0xa0, 0x90, 0xfa, 0x2, 0x2, 0x1, 0x1, 0x2];
_T Cased = [0x41, 0x1a, 0x6, 0x1a, 0x2f, 0x1, 0xa, 0x1, 0x4, 0x1, 0x5, 0x17, 0x1, 0x1f, 0x1, 0x80, 0xc3, 0x1, 0x4, 0x4, 0x80, 0xd0, 0x1, 0x24, 0x7, 0x2, 0x1e, 0x5, 0x60, 0x1, 0x2a, 0x4, 0x2, 0x2, 0x2, 0x4, 0x1, 0x1, 0x6, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x14, 0x1, 0x53, 0x1, 0x80, 0x8b, 0x8, 0x80, 0xa6, 0x1, 0x26, 0x9, 0x29, 0x8b, 0x17, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x2b, 0x1, 0x4, 0x82, 0xa0, 0x56, 0x2, 0x6, 0x88, 0x82, 0x9, 0x7, 0x2b, 0x2, 0x3, 0x40, 0x80, 0xc0, 0x40, 0x81, 0x16, 0x2, 0x6, 0x2, 0x26, 0x2, 0x6, 0x2, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1f, 0x2, 0x35, 0x1, 0x7, 0x1, 0x1, 0x3, 0x3, 0x1, 0x7, 0x3, 0x4, 0x2, 0x6, 0x4, 0xd, 0x5, 0x3, 0x1, 0x7, 0x74, 0x1, 0xd, 0x1, 0x10, 0xd, 0x65, 0x1, 0x4, 0x1, 0x2, 0xa, 0x1, 0x1, 0x3, 0x5, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x6, 0x4, 0x1, 0x2, 0x4, 0x5, 0x5, 0x4, 0x1, 0x11, 0x20, 0x3, 0x2, 0x83, 0x31, 0x34, 0x87, 0x16, 0x80, 0xe5, 0x6, 0x4, 0x3, 0x2, 0xc, 0x26, 0x1, 0x1, 0x5, 0x1, 0xa0, 0x79, 0x12, 0x2e, 0x12, 0x1e, 0x80, 0x84, 0x66, 0x3, 0x4, 0x1, 0x3b, 0x5, 0x2, 0x1, 0x1, 0x1, 0x5, 0x18, 0x5, 0x1, 0x3, 0x83, 0x35, 0x2b, 0x1, 0xe, 0x6, 0x50, 0xa0, 0x4f, 0x40, 0x7, 0xc, 0x5, 0x84, 0x9, 0x1a, 0x6, 0x1a, 0x84, 0xa5, 0x50, 0x60, 0x24, 0x4, 0x24, 0x74, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x1, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x81, 0xc3, 0x1, 0x2, 0x3, 0x1, 0x2a, 0x1, 0x9, 0x84, 0xc5, 0x33, 0xd, 0x33, 0x8b, 0xad, 0x40, 0xa0, 0x55, 0x60, 0x40, 0xa0, 0x65, 0x80, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x19, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x8, 0x87, 0x34, 0xa, 0x1, 0x14, 0x6, 0x6, 0x81, 0x5, 0x3e, 0x88, 0x92, 0x44, 0x87, 0xec, 0x1a, 0x6, 0x1a, 0x6, 0x1a];
_T Math = [0x2b, 0x1, 0x10, 0x3, 0x1f, 0x1, 0x1d, 0x1, 0x1, 0x1, 0x2d, 0x1, 0x4, 0x1, 0x25, 0x1, 0x1f, 0x1, 0x82, 0xd8, 0x3, 0x2, 0x1, 0x1a, 0x2, 0x2, 0x3, 0x82, 0xf, 0x3, 0x9a, 0xd, 0x1, 0x1b, 0x3, 0xb, 0x1, 0x3, 0x1, 0xd, 0x1, 0xe, 0x4, 0x15, 0x5, 0xb, 0x5, 0x41, 0xd, 0x4, 0x1, 0x3, 0x2, 0x4, 0x5, 0x12, 0x1, 0x4, 0x1, 0x2, 0xa, 0x1, 0x1, 0x2, 0x6, 0x6, 0x1, 0x3, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x6, 0x3, 0xe, 0x1, 0x1, 0x44, 0x18, 0x1, 0x6, 0x1, 0x2, 0x4, 0x2, 0x4, 0x20, 0x1, 0x1, 0x6, 0x2, 0xe, 0x81, 0xc, 0x8, 0x4, 0x14, 0x2, 0x5a, 0x1, 0x1e, 0x1b, 0x1, 0x1, 0x18, 0x1, 0xb, 0x7, 0x81, 0xbd, 0x2, 0xc, 0xa, 0x4, 0x6, 0x4, 0x2, 0x2, 0x2, 0x3, 0x5, 0xe, 0x1, 0x1, 0x1, 0x2, 0x6, 0xb, 0x8, 0x5, 0x2, 0x39, 0x1, 0x1, 0x1, 0x1d, 0x4, 0x9, 0x3, 0x81, 0x50, 0x40, 0x81, 0x0, 0x82, 0x0, 0x30, 0x15, 0x2, 0x6, 0xa0, 0xcf, 0xdc, 0x1, 0x83, 0x37, 0x6, 0x1, 0x1, 0x80, 0xa2, 0x1, 0x10, 0x3, 0x1d, 0x1, 0x1, 0x1, 0x1d, 0x1, 0x1, 0x1, 0x80, 0x83, 0x1, 0x6, 0x4, 0xa0, 0xd4, 0x13, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x81, 0x24, 0x2, 0x32, 0x96, 0x0, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11, 0x34, 0x2];
_T Me = [0x84, 0x88, 0x2, 0x96, 0x34, 0x1, 0x86, 0x1e, 0x4, 0x1, 0x3, 0xa0, 0x85, 0x8b, 0x3];
_T No = [0x80, 0xb2, 0x2, 0x5, 0x1, 0x2, 0x3, 0x89, 0x35, 0x6, 0x81, 0x78, 0x6, 0x78, 0x3, 0x80, 0x85, 0x7, 0x80, 0xd9, 0x7, 0x11, 0x9, 0x81, 0xb1, 0xa, 0x84, 0x35, 0x14, 0x84, 0x73, 0xa, 0x81, 0xe0, 0x1, 0x86, 0x95, 0x1, 0x3, 0x6, 0x6, 0xa, 0x80, 0xc6, 0x10, 0x29, 0x1, 0x82, 0xd6, 0x3c, 0x4e, 0x16, 0x82, 0x76, 0x1e, 0x85, 0x69, 0x1, 0x84, 0x94, 0x4, 0x80, 0x8a, 0xa, 0x1e, 0x8, 0x1, 0xf, 0x20, 0xa, 0x27, 0xf, 0xa0, 0x75, 0x70, 0x6, 0xa0, 0x58, 0xd1, 0x2d, 0x41, 0x4, 0x11, 0x2, 0x81, 0x55, 0x1b, 0x24, 0x4, 0x85, 0x34, 0x8, 0x19, 0x7, 0x27, 0x9, 0x4b, 0x5, 0x16, 0x6, 0x80, 0xa0, 0x2, 0x2, 0x10, 0x2, 0x2e, 0x40, 0x9, 0x34, 0x2, 0x1e, 0x3, 0x4b, 0x5, 0x68, 0x8, 0x18, 0x8, 0x29, 0x7, 0x81, 0x4a, 0x6, 0x81, 0x60, 0x1f, 0x80, 0x9e, 0xa, 0x2a, 0x4, 0x70, 0x7, 0x80, 0x86, 0x14, 0x81, 0x7b, 0x14, 0x85, 0x45, 0x2, 0x81, 0xae, 0x9, 0x83, 0x67, 0x13, 0x83, 0x53, 0x15, 0xa0, 0x4b, 0x86, 0x7, 0x83, 0x1e, 0x17, 0xa0, 0x64, 0x29, 0x14, 0xc, 0x14, 0x6c, 0x19, 0x95, 0x4e, 0x9, 0x83, 0xa1, 0x3b, 0x1, 0x3, 0x1, 0x4, 0x4c, 0x2d, 0x1, 0xf, 0x83, 0xc2, 0xd];
_T ID_Continue = [0x30, 0xa, 0x7, 0x1a, 0x4, 0x1, 0x1, 0x1a, 0x2f, 0x1, 0xa, 0x1, 0x1, 0x1, 0x2, 0x1, 0x5, 0x17, 0x1, 0x1f, 0x1, 0x81, 0xca, 0x4, 0xc, 0xe, 0x5, 0x7, 0x1, 0x1, 0x1, 0x11, 0x75, 0x1, 0x2, 0x2, 0x4, 0x1, 0x1, 0x6, 0x5, 0x1, 0x1, 0x1, 0x14, 0x1, 0x53, 0x1, 0x80, 0x8b, 0x1, 0x5, 0x2, 0x80, 0xa6, 0x1, 0x26, 0x2, 0x1, 0x6, 0x29, 0x8, 0x2d, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x8, 0x1b, 0x4, 0x4, 0x1d, 0xb, 0x5, 0x4a, 0x4, 0x66, 0x1, 0x8, 0x2, 0xa, 0x1, 0x13, 0x2, 0x1, 0x10, 0x3b, 0x2, 0x65, 0xe, 0x36, 0x4, 0x1, 0x2, 0x1, 0x2, 0x2e, 0x12, 0x1c, 0x4, 0xb, 0x5, 0x18, 0x1, 0x6, 0x9, 0x4a, 0x1, 0x80, 0x81, 0x2, 0xa, 0x1, 0x13, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x1, 0x3, 0x4, 0x2, 0x9, 0x2, 0x2, 0x2, 0x4, 0x8, 0x1, 0x4, 0x2, 0x1, 0x5, 0x2, 0xc, 0xa, 0x1, 0x1, 0x1, 0x2, 0x3, 0x1, 0x6, 0x4, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x2, 0x1, 0x1, 0x5, 0x4, 0x2, 0x2, 0x3, 0x3, 0x1, 0x7, 0x4, 0x1, 0x1, 0x7, 0x10, 0xb, 0x3, 0x1, 0x9, 0x1, 0x3, 0x1, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x2, 0xa, 0x1, 0x3, 0x1, 0x3, 0x2, 0x1, 0xf, 0x4, 0x2, 0xa, 0x9, 0x7, 0x1, 0x3, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x2, 0x9, 0x2, 0x2, 0x2, 0x3, 0x7, 0x3, 0x4, 0x2, 0x1, 0x5, 0x2, 0xa, 0x1, 0x1, 0x10, 0x2, 0x1, 0x6, 0x3, 0x3, 0x1, 0x4, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0xc, 0x4, 0x5, 0x3, 0x3, 0x1, 0x4, 0x2, 0x1, 0x6, 0x1, 0xe, 0xa, 0x10, 0xd, 0x1, 0x3, 0x1, 0x17, 0x1, 0x10, 0x2, 0x9, 0x1, 0x3, 0x1, 0x4, 0x7, 0x2, 0x1, 0x3, 0x2, 0x1, 0x2, 0x4, 0x2, 0xa, 0x10, 0x4, 0x1, 0x8, 0x1, 0x3, 0x1, 0x17, 0x1, 0xa, 0x1, 0x5, 0x2, 0x9, 0x1, 0x3, 0x1, 0x4, 0x7, 0x2, 0x6, 0x2, 0x1, 0x4, 0x2, 0xa, 0x1, 0x3, 0xc, 0xd, 0x1, 0x3, 0x1, 0x33, 0x1, 0x3, 0x1, 0x5, 0x5, 0x4, 0x7, 0x5, 0x2, 0xa, 0xa, 0x6, 0x1, 0x3, 0x1, 0x12, 0x3, 0x18, 0x1, 0x9, 0x1, 0x1, 0x2, 0x7, 0x3, 0x1, 0x4, 0x6, 0x1, 0x1, 0x1, 0x8, 0x6, 0xa, 0x2, 0x2, 0xd, 0x3a, 0x5, 0xf, 0x1, 0xa, 0x27, 0x2, 0x1, 0x1, 0x1, 0x5, 0x1, 0x18, 0x1, 0x1, 0x1, 0x17, 0x2, 0x5, 0x1, 0x1, 0x1, 0x7, 0x1, 0xa, 0x2, 0x4, 0x20, 0x1, 0x17, 0x2, 0x6, 0xa, 0xb, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0xa, 0x1, 0x24, 0x4, 0x14, 0x1, 0x12, 0x1, 0x24, 0x9, 0x1, 0x39, 0x4a, 0x6, 0x4e, 0x2, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x2b, 0x1, 0x81, 0x4d, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0x29, 0x1, 0x4, 0x2, 0x21, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0xf, 0x1, 0x39, 0x1, 0x4, 0x2, 0x43, 0x2, 0x3, 0x9, 0x9, 0xe, 0x10, 0x10, 0x56, 0x2, 0x6, 0x3, 0x82, 0x6c, 0x2, 0x11, 0x1, 0x1a, 0x5, 0x4b, 0x3, 0xb, 0x7, 0x16, 0x9, 0x16, 0xb, 0x14, 0xc, 0xd, 0x1, 0x3, 0x1, 0x2, 0xc, 0x54, 0x3, 0x1, 0x4, 0x2, 0x2, 0xa, 0x21, 0x3, 0x1, 0xb, 0x6, 0x59, 0x7, 0x2b, 0x5, 0x46, 0xa, 0x1f, 0x1, 0xc, 0x4, 0xc, 0xa, 0x28, 0x2, 0x5, 0xb, 0x2c, 0x4, 0x1a, 0x6, 0xb, 0x25, 0x1c, 0x4, 0x3f, 0x1, 0x1d, 0x2, 0xb, 0x6, 0xa, 0xd, 0x1, 0x8, 0xe, 0x1, 0x10, 0x31, 0x4d, 0x3, 0xa, 0x11, 0x9, 0xc, 0x74, 0xc, 0x38, 0x8, 0xa, 0x3, 0x31, 0x2, 0x9, 0x7, 0x2b, 0x2, 0x3, 0x10, 0x3, 0x1, 0x27, 0x5, 0x82, 0x16, 0x2, 0x6, 0x2, 0x26, 0x2, 0x6, 0x2, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1f, 0x2, 0x35, 0x1, 0x7, 0x1, 0x1, 0x3, 0x3, 0x1, 0x7, 0x3, 0x4, 0x2, 0x6, 0x4, 0xd, 0x5, 0x3, 0x1, 0x7, 0x42, 0x2, 0x13, 0x1, 0x1c, 0x1, 0xd, 0x1, 0x10, 0xd, 0x33, 0xd, 0x4, 0x1, 0x3, 0xc, 0x11, 0x1, 0x4, 0x1, 0x2, 0xa, 0x1, 0x1, 0x2, 0x6, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x10, 0x2, 0x4, 0x5, 0x5, 0x4, 0x1, 0x11, 0x29, 0x8a, 0x77, 0x80, 0xe5, 0x6, 0x9, 0xc, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x38, 0x7, 0x1, 0xf, 0x18, 0x9, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x20, 0x82, 0x5, 0x3, 0x19, 0xf, 0x1, 0x5, 0x2, 0x5, 0x4, 0x56, 0x2, 0x7, 0x1, 0x5a, 0x1, 0x4, 0x5, 0x2b, 0x1, 0x5e, 0x11, 0x20, 0x30, 0x10, 0x82, 0x0, 0x99, 0xc0, 0x40, 0xa0, 0x56, 0x8d, 0x43, 0x2e, 0x2, 0x81, 0xd, 0x3, 0x1c, 0x14, 0x30, 0x4, 0xa, 0x1, 0x73, 0x25, 0x9, 0x2, 0x67, 0x2, 0x40, 0x5, 0x2, 0x1, 0x1, 0x1, 0x5, 0x18, 0x36, 0x4, 0x1, 0x13, 0x34, 0xc, 0x46, 0xa, 0xa, 0x6, 0x18, 0x3, 0x1, 0x1, 0x31, 0x2, 0x24, 0xc, 0x1d, 0x3, 0x41, 0xe, 0xb, 0x6, 0x1f, 0x1, 0x37, 0x9, 0xe, 0x2, 0xa, 0x6, 0x17, 0x3, 0x49, 0x18, 0x3, 0x2, 0x10, 0x2, 0x5, 0xa, 0x6, 0x2, 0x6, 0x2, 0x6, 0x9, 0x7, 0x1, 0x7, 0x1, 0x2b, 0x1, 0xe, 0x6, 0x7b, 0x1, 0x2, 0x2, 0xa, 0x6, 0xa0, 0x2b, 0xa4, 0xc, 0x17, 0x4, 0x31, 0xa0, 0x21, 0x4, 0x81, 0x6e, 0x2, 0x6a, 0x26, 0x7, 0xc, 0x5, 0x5, 0xc, 0x1, 0xd, 0x1, 0x5, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x6c, 0x21, 0x81, 0x6b, 0x12, 0x40, 0x2, 0x36, 0x28, 0xc, 0x4, 0x10, 0x10, 0x10, 0x3, 0x2, 0x18, 0x3, 0x20, 0x5, 0x1, 0x80, 0x87, 0x13, 0xa, 0x7, 0x1a, 0x4, 0x1, 0x1, 0x1a, 0xb, 0x59, 0x3, 0x6, 0x2, 0x6, 0x2, 0x6, 0x2, 0x3, 0x23, 0xc, 0x1, 0x1a, 0x1, 0x13, 0x1, 0x2, 0x1, 0xf, 0x2, 0xe, 0x22, 0x7b, 0x45, 0x35, 0x80, 0x88, 0x1, 0x80, 0x82, 0x1d, 0x3, 0x31, 0xf, 0x1, 0x1f, 0x20, 0xd, 0x1e, 0x5, 0x2b, 0x5, 0x1e, 0x2, 0x24, 0x4, 0x8, 0x1, 0x5, 0x2a, 0x80, 0x9e, 0x2, 0xa, 0x6, 0x24, 0x4, 0x24, 0x4, 0x28, 0x8, 0x34, 0xc, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x1, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x43, 0x81, 0x37, 0x9, 0x16, 0xa, 0x8, 0x18, 0x6, 0x1, 0x2a, 0x1, 0x9, 0x45, 0x6, 0x2, 0x1, 0x1, 0x2c, 0x1, 0x2, 0x3, 0x1, 0x2, 0x17, 0xa, 0x17, 0x9, 0x1f, 0x41, 0x13, 0x1, 0x2, 0xa, 0x16, 0xa, 0x1a, 0x46, 0x38, 0x6, 0x2, 0x40, 0x4, 0x1, 0x2, 0x5, 0x8, 0x1, 0x3, 0x1, 0x1d, 0x2, 0x3, 0x4, 0x1, 0x20, 0x1d, 0x3, 0x1d, 0x23, 0x8, 0x1, 0x1e, 0x19, 0x36, 0xa, 0x16, 0xa, 0x13, 0xd, 0x12, 0x6e, 0x49, 0x37, 0x33, 0xd, 0x33, 0xd, 0x28, 0x8, 0xa, 0x81, 0x46, 0x2a, 0x1, 0x2, 0x3, 0x2, 0x4b, 0x20, 0xa, 0x1, 0x8, 0x21, 0x1f, 0x16, 0x2a, 0x15, 0x1b, 0x17, 0x9, 0x47, 0x1f, 0x10, 0x9, 0x3c, 0x7, 0x1, 0xd, 0x19, 0x7, 0xa, 0x6, 0x35, 0x1, 0xa, 0x4, 0x4, 0x8, 0x24, 0x2, 0x1, 0x9, 0x45, 0x4, 0x4, 0x1, 0xd, 0x1, 0x1, 0x23, 0x12, 0x1, 0x25, 0x6, 0x4, 0x3e, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xf, 0x1, 0xa, 0x7, 0x3b, 0x5, 0xa, 0x6, 0x4, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x1, 0xa, 0x2, 0x2, 0x2, 0x3, 0x2, 0x1, 0x6, 0x1, 0x5, 0x7, 0x2, 0x7, 0x3, 0x5, 0x80, 0x8b, 0x4b, 0x5, 0xa, 0x4, 0x4, 0x1e, 0x46, 0x1, 0x1, 0x8, 0xa, 0x80, 0xa6, 0x36, 0x2, 0x9, 0x17, 0x6, 0x22, 0x41, 0x3, 0x1, 0xb, 0xa, 0x26, 0x39, 0x7, 0xa, 0x36, 0x1b, 0x2, 0xf, 0x4, 0xa, 0x6, 0x7, 0x80, 0xb9, 0x3b, 0x65, 0x4a, 0x15, 0x8, 0x2, 0x1, 0x2, 0x8, 0x1, 0x2, 0x1, 0x1e, 0x1, 0x2, 0x2, 0x9, 0xc, 0xa, 0x46, 0x8, 0x2, 0x2e, 0x2, 0x8, 0x1, 0x2, 0x1b, 0x3f, 0x8, 0x1, 0x8, 0x4a, 0x3, 0x1, 0x12, 0x49, 0x81, 0x7, 0x9, 0x1, 0x2d, 0x1, 0x9, 0xf, 0xa, 0x18, 0x1e, 0x2, 0x16, 0x1, 0xe, 0x49, 0x7, 0x1, 0x2, 0x1, 0x2c, 0x3, 0x1, 0x1, 0x2, 0x1, 0x9, 0x8, 0xa, 0x6, 0x6, 0x1, 0x2, 0x1, 0x25, 0x1, 0x2, 0x1, 0x6, 0x7, 0xa, 0x81, 0x36, 0x17, 0x9, 0x11, 0x1, 0x29, 0x3, 0x5, 0xd, 0xa, 0x56, 0x1, 0x4f, 0x83, 0x9a, 0x66, 0x6f, 0x11, 0x80, 0xc4, 0x8a, 0x4c, 0x61, 0xf, 0x84, 0x30, 0x10, 0x16, 0x8f, 0xaa, 0x82, 0x47, 0xa0, 0x21, 0xb9, 0x82, 0x39, 0x7, 0x1f, 0x1, 0xa, 0x6, 0x4f, 0x1, 0xa, 0x6, 0x1e, 0x2, 0x5, 0xb, 0x37, 0x9, 0x4, 0xc, 0xa, 0x9, 0x15, 0x5, 0x13, 0x82, 0xb0, 0x40, 0x80, 0x80, 0x4b, 0x4, 0x39, 0x7, 0x11, 0x40, 0x2, 0x1, 0x2, 0xb, 0x2, 0xe, 0x97, 0xf8, 0x8, 0x84, 0xd6, 0x2a, 0x9, 0xa0, 0x22, 0xe7, 0x4, 0x1, 0x7, 0x1, 0x2, 0x1, 0x81, 0x23, 0xf, 0x1, 0x1d, 0x3, 0x2, 0x1, 0xe, 0x4, 0x8, 0x81, 0x8c, 0x89, 0x4, 0x6b, 0x5, 0xd, 0x3, 0x9, 0x7, 0xa, 0x3, 0x2, 0x92, 0x61, 0x2e, 0x2, 0x17, 0x82, 0x1e, 0x5, 0x3, 0x6, 0x8, 0x8, 0x2, 0x7, 0x1e, 0x4, 0x80, 0x94, 0x3, 0x81, 0xbb, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x19, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x8, 0x2, 0x32, 0x82, 0x0, 0x37, 0x4, 0x32, 0x8, 0x1, 0xe, 0x1, 0x16, 0x5, 0x1, 0xf, 0x84, 0x50, 0x1f, 0x6, 0x6, 0x80, 0xd5, 0x7, 0x1, 0x11, 0x2, 0x7, 0x1, 0x2, 0x1, 0x5, 0x5, 0x3e, 0x21, 0x1, 0x70, 0x2d, 0x3, 0xe, 0x2, 0xa, 0x4, 0x1, 0x81, 0x41, 0x1f, 0x11, 0x3a, 0x81, 0xd6, 0x2a, 0x82, 0xe6, 0x7, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf, 0x1, 0x80, 0xc5, 0xb, 0x7, 0x29, 0x4c, 0x4, 0xa, 0x84, 0xa6, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11, 0x8d, 0x34, 0xa, 0x84, 0x6, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x8c, 0x1f, 0x82, 0x1e, 0x85, 0xe2, 0x93, 0x4b, 0x5, 0x90, 0x60, 0xaa, 0xdd, 0x50, 0x80, 0xf0];
_T Ideographic = [0xa0, 0x30, 0x6, 0x2, 0x19, 0x9, 0xe, 0x3, 0x83, 0xc5, 0x99, 0xc0, 0x40, 0xa0, 0x52, 0x0, 0xa0, 0x59, 0x0, 0x81, 0x6e, 0x2, 0x6a, 0xa0, 0x75, 0xa, 0x1, 0x1b, 0x97, 0xf8, 0x8, 0x84, 0xd6, 0x2a, 0x9, 0xa0, 0x24, 0x67, 0x81, 0x8c, 0xa0, 0x4d, 0x4, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x8c, 0x1f, 0x82, 0x1e, 0x85, 0xe2, 0x93, 0x4b, 0x5, 0x90, 0x60];
_T Cf = [0x80, 0xad, 0x1, 0x85, 0x52, 0x6, 0x16, 0x1, 0x80, 0xc0, 0x1, 0x31, 0x1, 0x81, 0x80, 0x2, 0x50, 0x1, 0x8f, 0x2b, 0x1, 0x87, 0xfc, 0x5, 0x1a, 0x5, 0x31, 0x5, 0x1, 0xa, 0xa0, 0xde, 0x8f, 0x1, 0x80, 0xf9, 0x3, 0x90, 0xc1, 0x1, 0xf, 0x1, 0xa0, 0x23, 0x62, 0x10, 0xa0, 0x88, 0x60, 0x4, 0x94, 0xcf, 0x8, 0xac, 0x2e, 0x86, 0x1, 0x1e, 0x60];
_T So = [0x80, 0xa6, 0x1, 0x2, 0x1, 0x4, 0x1, 0x1, 0x1, 0x83, 0xd1, 0x1, 0x81, 0xa, 0x2, 0x7f, 0x2, 0x80, 0xce, 0x1, 0xa, 0x1, 0x13, 0x2, 0x80, 0xf7, 0x1, 0x82, 0x3, 0x1, 0x81, 0x75, 0x1, 0x80, 0x82, 0x6, 0x1, 0x1, 0x80, 0x84, 0x1, 0x80, 0xcf, 0x1, 0x29, 0x1, 0x81, 0x87, 0x3, 0xf, 0x1, 0x1, 0x3, 0x2, 0x6, 0x14, 0x1, 0x1, 0x1, 0x1, 0x1, 0x80, 0x85, 0x8, 0x1, 0x6, 0x1, 0x2, 0x5, 0x4, 0x80, 0xc5, 0x2, 0x82, 0xf0, 0xa, 0x82, 0xd3, 0x1, 0x82, 0xd2, 0x1, 0x80, 0x9d, 0x22, 0x81, 0x61, 0xa, 0x9, 0x9, 0x85, 0x83, 0x2, 0x1, 0x4, 0x1, 0x2, 0xa, 0x1, 0x1, 0x2, 0x6, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0xb, 0x2, 0xe, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3a, 0x2, 0x9, 0x5, 0x2, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x7, 0x1, 0x1f, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1f, 0x81, 0xc, 0x8, 0x4, 0x14, 0x2, 0x7, 0x2, 0x51, 0x1, 0x1e, 0x19, 0x28, 0x6, 0x45, 0x19, 0xb, 0x51, 0x4e, 0x16, 0x80, 0xb7, 0x1, 0x9, 0x1, 0x36, 0x8, 0x6f, 0x1, 0x80, 0xf8, 0x2c, 0x2c, 0x40, 0x81, 0x0, 0x82, 0x0, 0x30, 0x15, 0x2, 0x6, 0x27, 0x2, 0x20, 0x1, 0x69, 0x80, 0xe5, 0x6, 0x81, 0x65, 0x2, 0x2e, 0x1a, 0x1, 0x59, 0xc, 0x80, 0xd6, 0x1a, 0xc, 0x8, 0x1, 0xd, 0x2, 0xc, 0x1, 0x15, 0x2, 0x6, 0x2, 0x81, 0x50, 0x2, 0x4, 0xa, 0x20, 0x24, 0x1c, 0x1f, 0xb, 0x1e, 0x8, 0x1, 0xf, 0x20, 0xa, 0x27, 0xf, 0x81, 0x40, 0x99, 0xc0, 0x40, 0xa0, 0x56, 0x90, 0x37, 0x83, 0x61, 0x4, 0xa, 0x2, 0x1, 0x1, 0x82, 0x3d, 0x3, 0xa0, 0x52, 0xc6, 0x10, 0x7f, 0x1, 0x2d, 0x3, 0x81, 0xe4, 0x1, 0x3, 0x1, 0x4, 0x2, 0xd, 0x2, 0x81, 0x39, 0x9, 0x39, 0x11, 0x2, 0x3, 0x1, 0xd, 0x3, 0x1, 0x2f, 0x2d, 0x86, 0x7a, 0x2, 0x82, 0x4f, 0x1, 0x8c, 0x76, 0x1, 0x88, 0x95, 0x8, 0x4, 0x11, 0xa0, 0x4b, 0x4a, 0x4, 0x5, 0x1, 0xa0, 0x51, 0x56, 0x1, 0x92, 0xb3, 0x74, 0x3c, 0x80, 0xf6, 0xa, 0x27, 0x2, 0x3c, 0x5, 0x3, 0x16, 0x2, 0x7, 0x1e, 0x4, 0x3d, 0x15, 0x42, 0x3, 0x1, 0x80, 0xba, 0x57, 0x84, 0xa9, 0x82, 0x0, 0x37, 0x4, 0x32, 0x8, 0x1, 0xe, 0x1, 0x2, 0x86, 0xc8, 0x1, 0x8b, 0x5c, 0x1, 0x80, 0x81, 0x1, 0x82, 0xd1, 0x2c, 0x4, 0x64, 0xc, 0xf, 0x2, 0xf, 0x1, 0xf, 0x1, 0x25, 0x17, 0x80, 0xa1, 0x38, 0x1d, 0xd, 0x2c, 0x4, 0x9, 0x7, 0x2, 0xe, 0x6, 0x80, 0x9a, 0x80, 0xfb, 0x5, 0x82, 0xd8, 0x4, 0x11, 0x3, 0xd, 0x3, 0x77, 0x4, 0x5f, 0x6, 0xc, 0x4, 0x1, 0xf, 0xc, 0x4, 0x38, 0x8, 0xa, 0x6, 0x28, 0x8, 0x1e, 0x2, 0x2, 0x4e, 0x81, 0x54, 0xc, 0xe, 0x2, 0xd, 0x3, 0x9, 0x7, 0x2e, 0x1, 0x7, 0x8, 0xe, 0x4, 0x9, 0x7, 0x9, 0x7, 0x80, 0x93, 0x1, 0x37];
_T White_Space = [0x9, 0x5, 0x12, 0x1, 0x64, 0x1, 0x1a, 0x1, 0x95, 0xdf, 0x1, 0x89, 0x7f, 0xb, 0x1d, 0x2, 0x5, 0x1, 0x2f, 0x1, 0x8f, 0xa0, 0x1];
_T Sentence_Terminal = [0x21, 0x1, 0xc, 0x1, 0x10, 0x1, 0x85, 0x49, 0x1, 0x80, 0x93, 0x3, 0x80, 0xb4, 0x1, 0x2b, 0x3, 0x80, 0xf6, 0x1, 0x3d, 0x1, 0x1, 0x1, 0x3, 0x2, 0x81, 0x25, 0x2, 0x86, 0xe4, 0x2, 0x83, 0x16, 0x1, 0x4, 0x2, 0x83, 0x5, 0x1, 0x80, 0xc6, 0x2, 0x80, 0xcc, 0x1, 0x5, 0x1, 0x81, 0x3a, 0x2, 0x81, 0x62, 0x4, 0x80, 0xae, 0x2, 0x2, 0x2, 0x1d, 0x2, 0x80, 0xbc, 0x2, 0x41, 0x2, 0x83, 0xbc, 0x2, 0x9, 0x3, 0x8d, 0xe4, 0x1, 0xd, 0x1, 0x16, 0x2, 0x81, 0xad, 0x1, 0xa0, 0x74, 0xfc, 0x1, 0x81, 0xe, 0x2, 0x80, 0xe3, 0x1, 0x3, 0x1, 0x81, 0x7e, 0x2, 0x56, 0x2, 0x5f, 0x1, 0x80, 0x98, 0x2, 0x80, 0x93, 0x3, 0x80, 0x90, 0x2, 0x80, 0xf9, 0x1, 0xa0, 0x52, 0x66, 0x1, 0x3, 0x2, 0x80, 0xa9, 0x1, 0xc, 0x1, 0x10, 0x1, 0x41, 0x1, 0x8a, 0xf4, 0x2, 0x84, 0xfd, 0x5, 0x2c, 0x4, 0x80, 0xbd, 0x2, 0x75, 0x4, 0x7f, 0x3, 0x80, 0x81, 0x2, 0x6, 0x1, 0x10, 0x2, 0x58, 0x2, 0x1, 0x2, 0x6c, 0x1, 0x81, 0xa1, 0x2, 0x81, 0x75, 0x2, 0x5, 0xf, 0x69, 0x2, 0x80, 0xf9, 0x3, 0x82, 0x5, 0x1, 0x1, 0x1, 0x80, 0xfb, 0x2, 0x57, 0x2, 0x81, 0xa4, 0x2, 0x82, 0xb4, 0x2, 0x4a, 0x2, 0xa0, 0x4b, 0x29, 0x2, 0x80, 0x85, 0x1, 0x41, 0x2, 0xb, 0x1, 0x83, 0x53, 0x1, 0xa0, 0x4e, 0x6, 0x1, 0x9d, 0xe8, 0x1];
_T Lt = [0x81, 0xc5, 0x1, 0x2, 0x1, 0x2, 0x1, 0x26, 0x1, 0x9d, 0x95, 0x8, 0x8, 0x8, 0x8, 0x8, 0xc, 0x1, 0xf, 0x1, 0x2f, 0x1];
_T Other_Lowercase = [0x80, 0xaa, 0x1, 0xf, 0x1, 0x81, 0xf5, 0x9, 0x7, 0x2, 0x1e, 0x5, 0x60, 0x1, 0x34, 0x1, 0x8d, 0x81, 0x1, 0x8c, 0x2f, 0x3f, 0xd, 0x1, 0x22, 0x25, 0x82, 0xb1, 0x1, 0xd, 0x1, 0x10, 0xd, 0x80, 0xd3, 0x10, 0x83, 0x50, 0x1a, 0x87, 0x92, 0x2, 0xa0, 0x7a, 0x1e, 0x2, 0x80, 0xd2, 0x1, 0x80, 0x81, 0x3, 0x3, 0x2, 0x83, 0x62, 0x4, 0x9, 0x1, 0xa0, 0x5c, 0x16, 0x1, 0x2, 0x3, 0x1, 0x2a, 0x1, 0x9, 0xa0, 0xd8, 0x75, 0x3e];
_T Other_Alphabetic = [0x83, 0x45, 0x1, 0x82, 0x6a, 0xe, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x48, 0xb, 0x30, 0xd, 0x1, 0x7, 0x10, 0x1, 0x65, 0x7, 0x4, 0x4, 0x2, 0x2, 0x4, 0x1, 0x23, 0x1, 0x1e, 0x10, 0x66, 0xb, 0x65, 0x2, 0x3, 0x9, 0x1, 0x3, 0x1, 0x4, 0x80, 0xa7, 0xc, 0x3, 0x7, 0x6, 0x14, 0x36, 0x2, 0x2, 0xf, 0x1, 0x2, 0x5, 0x3, 0xa, 0x2, 0x1d, 0x3, 0x3a, 0x7, 0x2, 0x2, 0x2, 0x2, 0xa, 0x1, 0xa, 0x2, 0x1d, 0x3, 0x3a, 0x5, 0x4, 0x2, 0x2, 0x2, 0x4, 0x1, 0x1e, 0x2, 0x3, 0x1, 0xb, 0x3, 0x3a, 0x8, 0x1, 0x3, 0x1, 0x2, 0x15, 0x2, 0x16, 0x3, 0x4, 0x3, 0x3a, 0x7, 0x2, 0x2, 0x2, 0x2, 0x9, 0x2, 0xa, 0x2, 0x1e, 0x1, 0x3b, 0x5, 0x3, 0x3, 0x1, 0x3, 0xa, 0x1, 0x28, 0x5, 0x39, 0x7, 0x1, 0x3, 0x1, 0x3, 0x8, 0x2, 0xb, 0x2, 0x1d, 0x3, 0x3a, 0x7, 0x1, 0x3, 0x1, 0x3, 0x8, 0x2, 0xb, 0x2, 0xf, 0x1, 0xc, 0x4, 0x3a, 0x7, 0x1, 0x3, 0x1, 0x3, 0xa, 0x1, 0xa, 0x2, 0x1d, 0x3, 0x4b, 0x6, 0x1, 0x1, 0x1, 0x8, 0x12, 0x2, 0x3d, 0x1, 0x2, 0x7, 0x12, 0x1, 0x63, 0x1, 0x2, 0x6, 0x1, 0x2, 0x10, 0x1, 0x80, 0xa3, 0x13, 0x9, 0xb, 0x1, 0x24, 0x6e, 0xc, 0x1, 0x1, 0x2, 0x4, 0x17, 0x4, 0x4, 0x3, 0x1, 0x3, 0x2, 0x7, 0x3, 0x4, 0xd, 0xc, 0x1, 0x1, 0xa, 0x4, 0x86, 0x74, 0x2, 0x1e, 0x2, 0x1e, 0x2, 0x1e, 0x2, 0x42, 0x13, 0x80, 0xbc, 0x2, 0x22, 0x1, 0x76, 0xc, 0x4, 0x9, 0x80, 0xde, 0x5, 0x39, 0xa, 0x2, 0x14, 0x4a, 0x2, 0xb, 0x3, 0x31, 0x5, 0x30, 0xf, 0x3c, 0x3, 0x1e, 0x9, 0x2, 0x2, 0x39, 0xb, 0x32, 0x13, 0x81, 0xb0, 0xe, 0x86, 0xc1, 0x34, 0x88, 0xf6, 0x20, 0xa0, 0x78, 0x74, 0x8, 0x22, 0x2, 0x81, 0x62, 0x1, 0x8, 0x1, 0x17, 0x5, 0x58, 0x2, 0x32, 0x10, 0x1, 0x1, 0x39, 0x1, 0x26, 0x5, 0x1c, 0xc, 0x2d, 0x4, 0x30, 0xc, 0x25, 0x1, 0x43, 0xe, 0xc, 0x1, 0x8, 0x2, 0x2d, 0x3, 0x32, 0x1, 0x1, 0x3, 0x2, 0x2, 0x5, 0x1, 0x2c, 0x5, 0x5, 0x1, 0x80, 0xed, 0x8, 0xa0, 0x4f, 0x33, 0x1, 0x88, 0x57, 0x5, 0x86, 0x86, 0x3, 0x1, 0x2, 0x5, 0x4, 0x83, 0x14, 0x4, 0x81, 0x83, 0x2, 0x81, 0x53, 0x3, 0x35, 0xe, 0x2d, 0x2, 0xb, 0x3, 0x2d, 0x9, 0x9, 0x1, 0x3d, 0x3, 0x24, 0xc, 0x12, 0x2, 0x39, 0x3, 0x30, 0xd, 0xe, 0x2, 0x5c, 0x9, 0x2, 0x1, 0x6, 0x1, 0x2, 0x1, 0x80, 0x9d, 0xa, 0x17, 0x4, 0x3a, 0x7, 0x2, 0x2, 0x2, 0x2, 0xa, 0x1, 0xa, 0x2, 0x80, 0xd1, 0xd, 0x1, 0x3, 0x6a, 0x12, 0x80, 0xed, 0x7, 0x2, 0x7, 0x1d, 0x2, 0x52, 0xf, 0x1, 0x1, 0x6a, 0xb, 0x67, 0xe, 0x81, 0x1, 0xd, 0x80, 0xf7, 0x6, 0x1, 0x2, 0x2, 0x2, 0x3, 0x1, 0x1, 0x1, 0x80, 0x8e, 0x7, 0x2, 0x6, 0x4, 0x1, 0x1c, 0xa, 0x2a, 0x5, 0x1, 0x4, 0x12, 0xb, 0x2e, 0xe, 0x81, 0x97, 0x8, 0x1, 0x7, 0x53, 0x16, 0x1, 0xe, 0x7a, 0x6, 0x3, 0x1, 0x1, 0x2, 0x1, 0x3, 0x1, 0x1, 0x3, 0x1, 0x42, 0x5, 0x1, 0x2, 0x1, 0x4, 0x81, 0x5c, 0x4, 0x9, 0x2, 0x1, 0x1, 0x30, 0x7, 0x3, 0x3, 0xa0, 0x50, 0xe, 0x1, 0x1, 0x37, 0x7, 0x4, 0x5d, 0x2, 0xa0, 0x4c, 0xac, 0x1, 0xa0, 0x23, 0x61, 0x7, 0x1, 0x11, 0x2, 0x7, 0x1, 0x2, 0x1, 0x5, 0x64, 0x1, 0x88, 0xb7, 0x1, 0x87, 0xe8, 0x1a, 0x6, 0x1a, 0x6, 0x1a];
_T XID_Continue = [0x30, 0xa, 0x7, 0x1a, 0x4, 0x1, 0x1, 0x1a, 0x2f, 0x1, 0xa, 0x1, 0x1, 0x1, 0x2, 0x1, 0x5, 0x17, 0x1, 0x1f, 0x1, 0x81, 0xca, 0x4, 0xc, 0xe, 0x5, 0x7, 0x1, 0x1, 0x1, 0x11, 0x75, 0x1, 0x2, 0x3, 0x3, 0x1, 0x1, 0x6, 0x5, 0x1, 0x1, 0x1, 0x14, 0x1, 0x53, 0x1, 0x80, 0x8b, 0x1, 0x5, 0x2, 0x80, 0xa6, 0x1, 0x26, 0x2, 0x1, 0x6, 0x29, 0x8, 0x2d, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x8, 0x1b, 0x4, 0x4, 0x1d, 0xb, 0x5, 0x4a, 0x4, 0x66, 0x1, 0x8, 0x2, 0xa, 0x1, 0x13, 0x2, 0x1, 0x10, 0x3b, 0x2, 0x65, 0xe, 0x36, 0x4, 0x1, 0x2, 0x1, 0x2, 0x2e, 0x12, 0x1c, 0x4, 0xb, 0x5, 0x18, 0x1, 0x6, 0x9, 0x4a, 0x1, 0x80, 0x81, 0x2, 0xa, 0x1, 0x13, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x1, 0x3, 0x4, 0x2, 0x9, 0x2, 0x2, 0x2, 0x4, 0x8, 0x1, 0x4, 0x2, 0x1, 0x5, 0x2, 0xc, 0xa, 0x1, 0x1, 0x1, 0x2, 0x3, 0x1, 0x6, 0x4, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x2, 0x1, 0x1, 0x5, 0x4, 0x2, 0x2, 0x3, 0x3, 0x1, 0x7, 0x4, 0x1, 0x1, 0x7, 0x10, 0xb, 0x3, 0x1, 0x9, 0x1, 0x3, 0x1, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x2, 0xa, 0x1, 0x3, 0x1, 0x3, 0x2, 0x1, 0xf, 0x4, 0x2, 0xa, 0x9, 0x7, 0x1, 0x3, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x2, 0x9, 0x2, 0x2, 0x2, 0x3, 0x7, 0x3, 0x4, 0x2, 0x1, 0x5, 0x2, 0xa, 0x1, 0x1, 0x10, 0x2, 0x1, 0x6, 0x3, 0x3, 0x1, 0x4, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0xc, 0x4, 0x5, 0x3, 0x3, 0x1, 0x4, 0x2, 0x1, 0x6, 0x1, 0xe, 0xa, 0x10, 0xd, 0x1, 0x3, 0x1, 0x17, 0x1, 0x10, 0x2, 0x9, 0x1, 0x3, 0x1, 0x4, 0x7, 0x2, 0x1, 0x3, 0x2, 0x1, 0x2, 0x4, 0x2, 0xa, 0x10, 0x4, 0x1, 0x8, 0x1, 0x3, 0x1, 0x17, 0x1, 0xa, 0x1, 0x5, 0x2, 0x9, 0x1, 0x3, 0x1, 0x4, 0x7, 0x2, 0x6, 0x2, 0x1, 0x4, 0x2, 0xa, 0x1, 0x3, 0xc, 0xd, 0x1, 0x3, 0x1, 0x33, 0x1, 0x3, 0x1, 0x5, 0x5, 0x4, 0x7, 0x5, 0x2, 0xa, 0xa, 0x6, 0x1, 0x3, 0x1, 0x12, 0x3, 0x18, 0x1, 0x9, 0x1, 0x1, 0x2, 0x7, 0x3, 0x1, 0x4, 0x6, 0x1, 0x1, 0x1, 0x8, 0x6, 0xa, 0x2, 0x2, 0xd, 0x3a, 0x5, 0xf, 0x1, 0xa, 0x27, 0x2, 0x1, 0x1, 0x1, 0x5, 0x1, 0x18, 0x1, 0x1, 0x1, 0x17, 0x2, 0x5, 0x1, 0x1, 0x1, 0x7, 0x1, 0xa, 0x2, 0x4, 0x20, 0x1, 0x17, 0x2, 0x6, 0xa, 0xb, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0xa, 0x1, 0x24, 0x4, 0x14, 0x1, 0x12, 0x1, 0x24, 0x9, 0x1, 0x39, 0x4a, 0x6, 0x4e, 0x2, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x2b, 0x1, 0x81, 0x4d, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0x29, 0x1, 0x4, 0x2, 0x21, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0xf, 0x1, 0x39, 0x1, 0x4, 0x2, 0x43, 0x2, 0x3, 0x9, 0x9, 0xe, 0x10, 0x10, 0x56, 0x2, 0x6, 0x3, 0x82, 0x6c, 0x2, 0x11, 0x1, 0x1a, 0x5, 0x4b, 0x3, 0xb, 0x7, 0x16, 0x9, 0x16, 0xb, 0x14, 0xc, 0xd, 0x1, 0x3, 0x1, 0x2, 0xc, 0x54, 0x3, 0x1, 0x4, 0x2, 0x2, 0xa, 0x21, 0x3, 0x1, 0xb, 0x6, 0x59, 0x7, 0x2b, 0x5, 0x46, 0xa, 0x1f, 0x1, 0xc, 0x4, 0xc, 0xa, 0x28, 0x2, 0x5, 0xb, 0x2c, 0x4, 0x1a, 0x6, 0xb, 0x25, 0x1c, 0x4, 0x3f, 0x1, 0x1d, 0x2, 0xb, 0x6, 0xa, 0xd, 0x1, 0x8, 0xe, 0x1, 0x10, 0x31, 0x4d, 0x3, 0xa, 0x11, 0x9, 0xc, 0x74, 0xc, 0x38, 0x8, 0xa, 0x3, 0x31, 0x2, 0x9, 0x7, 0x2b, 0x2, 0x3, 0x10, 0x3, 0x1, 0x27, 0x5, 0x82, 0x16, 0x2, 0x6, 0x2, 0x26, 0x2, 0x6, 0x2, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1f, 0x2, 0x35, 0x1, 0x7, 0x1, 0x1, 0x3, 0x3, 0x1, 0x7, 0x3, 0x4, 0x2, 0x6, 0x4, 0xd, 0x5, 0x3, 0x1, 0x7, 0x42, 0x2, 0x13, 0x1, 0x1c, 0x1, 0xd, 0x1, 0x10, 0xd, 0x33, 0xd, 0x4, 0x1, 0x3, 0xc, 0x11, 0x1, 0x4, 0x1, 0x2, 0xa, 0x1, 0x1, 0x2, 0x6, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x10, 0x2, 0x4, 0x5, 0x5, 0x4, 0x1, 0x11, 0x29, 0x8a, 0x77, 0x80, 0xe5, 0x6, 0x9, 0xc, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x38, 0x7, 0x1, 0xf, 0x18, 0x9, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x20, 0x82, 0x5, 0x3, 0x19, 0xf, 0x1, 0x5, 0x2, 0x5, 0x4, 0x56, 0x2, 0x2, 0x2, 0x3, 0x1, 0x5a, 0x1, 0x4, 0x5, 0x2b, 0x1, 0x5e, 0x11, 0x20, 0x30, 0x10, 0x82, 0x0, 0x99, 0xc0, 0x40, 0xa0, 0x56, 0x8d, 0x43, 0x2e, 0x2, 0x81, 0xd, 0x3, 0x1c, 0x14, 0x30, 0x4, 0xa, 0x1, 0x73, 0x25, 0x9, 0x2, 0x67, 0x2, 0x40, 0x5, 0x2, 0x1, 0x1, 0x1, 0x5, 0x18, 0x36, 0x4, 0x1, 0x13, 0x34, 0xc, 0x46, 0xa, 0xa, 0x6, 0x18, 0x3, 0x1, 0x1, 0x31, 0x2, 0x24, 0xc, 0x1d, 0x3, 0x41, 0xe, 0xb, 0x6, 0x1f, 0x1, 0x37, 0x9, 0xe, 0x2, 0xa, 0x6, 0x17, 0x3, 0x49, 0x18, 0x3, 0x2, 0x10, 0x2, 0x5, 0xa, 0x6, 0x2, 0x6, 0x2, 0x6, 0x9, 0x7, 0x1, 0x7, 0x1, 0x2b, 0x1, 0xe, 0x6, 0x7b, 0x1, 0x2, 0x2, 0xa, 0x6, 0xa0, 0x2b, 0xa4, 0xc, 0x17, 0x4, 0x31, 0xa0, 0x21, 0x4, 0x81, 0x6e, 0x2, 0x6a, 0x26, 0x7, 0xc, 0x5, 0x5, 0xc, 0x1, 0xd, 0x1, 0x5, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x6c, 0x21, 0x80, 0x8b, 0x6, 0x80, 0xda, 0x12, 0x40, 0x2, 0x36, 0x28, 0xa, 0x6, 0x10, 0x10, 0x10, 0x3, 0x2, 0x18, 0x3, 0x21, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7e, 0x13, 0xa, 0x7, 0x1a, 0x4, 0x1, 0x1, 0x1a, 0xb, 0x59, 0x3, 0x6, 0x2, 0x6, 0x2, 0x6, 0x2, 0x3, 0x23, 0xc, 0x1, 0x1a, 0x1, 0x13, 0x1, 0x2, 0x1, 0xf, 0x2, 0xe, 0x22, 0x7b, 0x45, 0x35, 0x80, 0x88, 0x1, 0x80, 0x82, 0x1d, 0x3, 0x31, 0xf, 0x1, 0x1f, 0x20, 0xd, 0x1e, 0x5, 0x2b, 0x5, 0x1e, 0x2, 0x24, 0x4, 0x8, 0x1, 0x5, 0x2a, 0x80, 0x9e, 0x2, 0xa, 0x6, 0x24, 0x4, 0x24, 0x4, 0x28, 0x8, 0x34, 0xc, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x1, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x43, 0x81, 0x37, 0x9, 0x16, 0xa, 0x8, 0x18, 0x6, 0x1, 0x2a, 0x1, 0x9, 0x45, 0x6, 0x2, 0x1, 0x1, 0x2c, 0x1, 0x2, 0x3, 0x1, 0x2, 0x17, 0xa, 0x17, 0x9, 0x1f, 0x41, 0x13, 0x1, 0x2, 0xa, 0x16, 0xa, 0x1a, 0x46, 0x38, 0x6, 0x2, 0x40, 0x4, 0x1, 0x2, 0x5, 0x8, 0x1, 0x3, 0x1, 0x1d, 0x2, 0x3, 0x4, 0x1, 0x20, 0x1d, 0x3, 0x1d, 0x23, 0x8, 0x1, 0x1e, 0x19, 0x36, 0xa, 0x16, 0xa, 0x13, 0xd, 0x12, 0x6e, 0x49, 0x37, 0x33, 0xd, 0x33, 0xd, 0x28, 0x8, 0xa, 0x81, 0x46, 0x2a, 0x1, 0x2, 0x3, 0x2, 0x4b, 0x20, 0xa, 0x1, 0x8, 0x21, 0x1f, 0x16, 0x2a, 0x15, 0x1b, 0x17, 0x9, 0x47, 0x1f, 0x10, 0x9, 0x3c, 0x7, 0x1, 0xd, 0x19, 0x7, 0xa, 0x6, 0x35, 0x1, 0xa, 0x4, 0x4, 0x8, 0x24, 0x2, 0x1, 0x9, 0x45, 0x4, 0x4, 0x1, 0xd, 0x1, 0x1, 0x23, 0x12, 0x1, 0x25, 0x6, 0x4, 0x3e, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xf, 0x1, 0xa, 0x7, 0x3b, 0x5, 0xa, 0x6, 0x4, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x1, 0xa, 0x2, 0x2, 0x2, 0x3, 0x2, 0x1, 0x6, 0x1, 0x5, 0x7, 0x2, 0x7, 0x3, 0x5, 0x80, 0x8b, 0x4b, 0x5, 0xa, 0x4, 0x4, 0x1e, 0x46, 0x1, 0x1, 0x8, 0xa, 0x80, 0xa6, 0x36, 0x2, 0x9, 0x17, 0x6, 0x22, 0x41, 0x3, 0x1, 0xb, 0xa, 0x26, 0x39, 0x7, 0xa, 0x36, 0x1b, 0x2, 0xf, 0x4, 0xa, 0x6, 0x7, 0x80, 0xb9, 0x3b, 0x65, 0x4a, 0x15, 0x8, 0x2, 0x1, 0x2, 0x8, 0x1, 0x2, 0x1, 0x1e, 0x1, 0x2, 0x2, 0x9, 0xc, 0xa, 0x46, 0x8, 0x2, 0x2e, 0x2, 0x8, 0x1, 0x2, 0x1b, 0x3f, 0x8, 0x1, 0x8, 0x4a, 0x3, 0x1, 0x12, 0x49, 0x81, 0x7, 0x9, 0x1, 0x2d, 0x1, 0x9, 0xf, 0xa, 0x18, 0x1e, 0x2, 0x16, 0x1, 0xe, 0x49, 0x7, 0x1, 0x2, 0x1, 0x2c, 0x3, 0x1, 0x1, 0x2, 0x1, 0x9, 0x8, 0xa, 0x6, 0x6, 0x1, 0x2, 0x1, 0x25, 0x1, 0x2, 0x1, 0x6, 0x7, 0xa, 0x81, 0x36, 0x17, 0x9, 0x11, 0x1, 0x29, 0x3, 0x5, 0xd, 0xa, 0x56, 0x1, 0x4f, 0x83, 0x9a, 0x66, 0x6f, 0x11, 0x80, 0xc4, 0x8a, 0x4c, 0x61, 0xf, 0x84, 0x30, 0x10, 0x16, 0x8f, 0xaa, 0x82, 0x47, 0xa0, 0x21, 0xb9, 0x82, 0x39, 0x7, 0x1f, 0x1, 0xa, 0x6, 0x4f, 0x1, 0xa, 0x6, 0x1e, 0x2, 0x5, 0xb, 0x37, 0x9, 0x4, 0xc, 0xa, 0x9, 0x15, 0x5, 0x13, 0x82, 0xb0, 0x40, 0x80, 0x80, 0x4b, 0x4, 0x39, 0x7, 0x11, 0x40, 0x2, 0x1, 0x2, 0xb, 0x2, 0xe, 0x97, 0xf8, 0x8, 0x84, 0xd6, 0x2a, 0x9, 0xa0, 0x22, 0xe7, 0x4, 0x1, 0x7, 0x1, 0x2, 0x1, 0x81, 0x23, 0xf, 0x1, 0x1d, 0x3, 0x2, 0x1, 0xe, 0x4, 0x8, 0x81, 0x8c, 0x89, 0x4, 0x6b, 0x5, 0xd, 0x3, 0x9, 0x7, 0xa, 0x3, 0x2, 0x92, 0x61, 0x2e, 0x2, 0x17, 0x82, 0x1e, 0x5, 0x3, 0x6, 0x8, 0x8, 0x2, 0x7, 0x1e, 0x4, 0x80, 0x94, 0x3, 0x81, 0xbb, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x19, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x8, 0x2, 0x32, 0x82, 0x0, 0x37, 0x4, 0x32, 0x8, 0x1, 0xe, 0x1, 0x16, 0x5, 0x1, 0xf, 0x84, 0x50, 0x1f, 0x6, 0x6, 0x80, 0xd5, 0x7, 0x1, 0x11, 0x2, 0x7, 0x1, 0x2, 0x1, 0x5, 0x5, 0x3e, 0x21, 0x1, 0x70, 0x2d, 0x3, 0xe, 0x2, 0xa, 0x4, 0x1, 0x81, 0x41, 0x1f, 0x11, 0x3a, 0x81, 0xd6, 0x2a, 0x82, 0xe6, 0x7, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf, 0x1, 0x80, 0xc5, 0xb, 0x7, 0x29, 0x4c, 0x4, 0xa, 0x84, 0xa6, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11, 0x8d, 0x34, 0xa, 0x84, 0x6, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x8c, 0x1f, 0x82, 0x1e, 0x85, 0xe2, 0x93, 0x4b, 0x5, 0x90, 0x60, 0xaa, 0xdd, 0x50, 0x80, 0xf0];
_T Cc = [0x0, 0x20, 0x5f, 0x21];
_T Regional_Indicator = [0xa1, 0xf1, 0xe6, 0x1a];
_T Sc = [0x24, 0x1, 0x7d, 0x4, 0x84, 0xe9, 0x1, 0x7b, 0x1, 0x81, 0xf2, 0x2, 0x81, 0xf2, 0x2, 0x7, 0x1, 0x80, 0xf5, 0x1, 0x81, 0x7, 0x1, 0x82, 0x45, 0x1, 0x89, 0x9b, 0x1, 0x88, 0xc4, 0x21, 0xa0, 0x87, 0x77, 0x1, 0xa0, 0x55, 0xc3, 0x1, 0x6c, 0x1, 0x80, 0x9a, 0x1, 0x80, 0xdb, 0x2, 0x3, 0x2, 0x9f, 0xf6, 0x4, 0xa0, 0xc3, 0x1e, 0x1, 0x89, 0xb0, 0x1];
_T Pe = [0x29, 0x1, 0x33, 0x1, 0x1f, 0x1, 0x8e, 0xbd, 0x1, 0x1, 0x1, 0x87, 0x5e, 0x1, 0x89, 0xa9, 0x1, 0x37, 0x1, 0xf, 0x1, 0x82, 0x7a, 0x1, 0x1, 0x1, 0x1e, 0x1, 0x84, 0x3e, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x50, 0x1, 0x20, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x81, 0x94, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x40, 0x1, 0x1, 0x1, 0x21, 0x1, 0x84, 0x25, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2c, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x81, 0xac, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0xa0, 0xcd, 0x1e, 0x1, 0x80, 0xd9, 0x1, 0x1d, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x11, 0x1, 0x1, 0x1, 0x1, 0x1, 0x80, 0xaa, 0x1, 0x33, 0x1, 0x1f, 0x1, 0x2, 0x1, 0x2, 0x1];
_T Pf = [0x80, 0xbb, 0x1, 0x9f, 0x5d, 0x1, 0x3, 0x1, 0x1c, 0x1, 0x8d, 0xc8, 0x1, 0x1, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf, 0x1, 0x3, 0x1];
_T Other_Uppercase = [0xa0, 0x21, 0x60, 0x10, 0x83, 0x46, 0x1a, 0xa1, 0xcc, 0x60, 0x1a, 0x6, 0x1a, 0x6, 0x1a];
_T Cn = [0x83, 0x78, 0x2, 0x6, 0x4, 0x7, 0x1, 0x1, 0x1, 0x14, 0x1, 0x81, 0x8d, 0x1, 0x26, 0x2, 0x32, 0x2, 0x3, 0x1, 0x37, 0x8, 0x1b, 0x4, 0x6, 0xb, 0x81, 0xe, 0x1, 0x3c, 0x2, 0x65, 0xe, 0x3b, 0x2, 0x31, 0x2, 0xf, 0x1, 0x1c, 0x2, 0x1, 0x1, 0xb, 0x5, 0x1f, 0x1, 0x2, 0x6, 0x80, 0xec, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x1, 0x3, 0x4, 0x2, 0x9, 0x2, 0x2, 0x2, 0x4, 0x8, 0x1, 0x4, 0x2, 0x1, 0x5, 0x2, 0x19, 0x2, 0x3, 0x1, 0x6, 0x4, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x2, 0x1, 0x1, 0x5, 0x4, 0x2, 0x2, 0x3, 0x3, 0x1, 0x7, 0x4, 0x1, 0x1, 0x7, 0x11, 0xa, 0x3, 0x1, 0x9, 0x1, 0x3, 0x1, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x2, 0xa, 0x1, 0x3, 0x1, 0x3, 0x2, 0x1, 0xf, 0x4, 0x2, 0xc, 0x7, 0x7, 0x1, 0x3, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x2, 0x9, 0x2, 0x2, 0x2, 0x3, 0x7, 0x3, 0x4, 0x2, 0x1, 0x5, 0x2, 0x12, 0xa, 0x2, 0x1, 0x6, 0x3, 0x3, 0x1, 0x4, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0xc, 0x4, 0x5, 0x3, 0x3, 0x1, 0x4, 0x2, 0x1, 0x6, 0x1, 0xe, 0x15, 0x5, 0xd, 0x1, 0x3, 0x1, 0x17, 0x1, 0x10, 0x2, 0x9, 0x1, 0x3, 0x1, 0x4, 0x7, 0x2, 0x1, 0x3, 0x2, 0x1, 0x2, 0x4, 0x2, 0xa, 0x7, 0x16, 0x1, 0x3, 0x1, 0x17, 0x1, 0xa, 0x1, 0x5, 0x2, 0x9, 0x1, 0x3, 0x1, 0x4, 0x7, 0x2, 0x6, 0x2, 0x1, 0x4, 0x2, 0xa, 0x1, 0x3, 0xc, 0xd, 0x1, 0x3, 0x1, 0x33, 0x1, 0x3, 0x1, 0x6, 0x4, 0x10, 0x2, 0x1a, 0x1, 0x3, 0x1, 0x12, 0x3, 0x18, 0x1, 0x9, 0x1, 0x1, 0x2, 0x7, 0x3, 0x1, 0x4, 0x6, 0x1, 0x1, 0x1, 0x8, 0x6, 0xa, 0x2, 0x3, 0xc, 0x3a, 0x4, 0x1d, 0x25, 0x2, 0x1, 0x1, 0x1, 0x5, 0x1, 0x18, 0x1, 0x1, 0x1, 0x17, 0x2, 0x5, 0x1, 0x1, 0x1, 0x7, 0x1, 0xa, 0x2, 0x4, 0x20, 0x48, 0x1, 0x24, 0x4, 0x27, 0x1, 0x24, 0x1, 0xf, 0x1, 0xd, 0x25, 0x80, 0xc6, 0x1, 0x1, 0x5, 0x1, 0x2, 0x81, 0x79, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0x29, 0x1, 0x4, 0x2, 0x21, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0xf, 0x1, 0x39, 0x1, 0x4, 0x2, 0x43, 0x2, 0x20, 0x3, 0x1a, 0x6, 0x56, 0x2, 0x6, 0x2, 0x82, 0x9d, 0x3, 0x59, 0x7, 0x16, 0x9, 0x18, 0x9, 0x14, 0xc, 0xd, 0x1, 0x3, 0x1, 0x2, 0xc, 0x5e, 0x2, 0xa, 0x6, 0xa, 0x6, 0x1a, 0x6, 0x59, 0x7, 0x2b, 0x5, 0x46, 0xa, 0x1f, 0x1, 0xc, 0x4, 0xc, 0x4, 0x1, 0x3, 0x2a, 0x2, 0x5, 0xb, 0x2c, 0x4, 0x1a, 0x6, 0xb, 0x3, 0x3e, 0x2, 0x41, 0x1, 0x1d, 0x2, 0xb, 0x6, 0xa, 0x6, 0xe, 0x2, 0x1f, 0x31, 0x4d, 0x3, 0x2f, 0x1, 0x74, 0x8, 0x3c, 0x3, 0xf, 0x3, 0x3c, 0x7, 0x2b, 0x2, 0xb, 0x8, 0x2b, 0x5, 0x82, 0x16, 0x2, 0x6, 0x2, 0x26, 0x2, 0x6, 0x2, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1f, 0x2, 0x35, 0x1, 0xf, 0x1, 0xe, 0x2, 0x6, 0x1, 0x13, 0x2, 0x3, 0x1, 0x9, 0x1, 0x65, 0x1, 0xc, 0x2, 0x1b, 0x1, 0xd, 0x3, 0x21, 0xf, 0x21, 0xf, 0x80, 0x8c, 0x4, 0x82, 0x97, 0x19, 0xb, 0x15, 0x87, 0x14, 0x2, 0x20, 0x1, 0x81, 0x5d, 0x5, 0x2d, 0x1, 0x1, 0x5, 0x1, 0x2, 0x38, 0x7, 0x2, 0xe, 0x18, 0x9, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7e, 0x22, 0x1a, 0x1, 0x59, 0xc, 0x80, 0xd6, 0x1a, 0xc, 0x4, 0x40, 0x1, 0x56, 0x2, 0x67, 0x5, 0x2b, 0x1, 0x5e, 0x1, 0x54, 0xc, 0x2f, 0x1, 0xa0, 0x72, 0x6d, 0x3, 0x37, 0x9, 0x81, 0x5c, 0x14, 0x80, 0xb8, 0x8, 0x80, 0xcb, 0x5, 0x2, 0x1, 0x1, 0x1, 0x5, 0x18, 0x3b, 0x3, 0xa, 0x6, 0x38, 0x8, 0x46, 0x8, 0xc, 0x6, 0x74, 0xb, 0x1e, 0x3, 0x4e, 0x1, 0xb, 0x4, 0x21, 0x1, 0x37, 0x9, 0xe, 0x2, 0xa, 0x2, 0x67, 0x18, 0x1c, 0xa, 0x6, 0x2, 0x6, 0x2, 0x6, 0x9, 0x7, 0x1, 0x7, 0x1, 0x3c, 0x4, 0x7e, 0x2, 0xa, 0x6, 0xa0, 0x2b, 0xa4, 0xc, 0x17, 0x4, 0x31, 0x4, 0xa0, 0x22, 0x6e, 0x2, 0x6a, 0x26, 0x7, 0xc, 0x5, 0x5, 0x1a, 0x1, 0x5, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x7d, 0x10, 0x81, 0xbd, 0x2, 0x36, 0x7, 0x1, 0x20, 0x2a, 0x6, 0x33, 0x1, 0x13, 0x1, 0x4, 0x4, 0x5, 0x1, 0x80, 0x87, 0x2, 0x1, 0x1, 0x80, 0xbe, 0x3, 0x6, 0x2, 0x6, 0x2, 0x6, 0x2, 0x3, 0x3, 0x7, 0x1, 0x7, 0xa, 0x5, 0x2, 0xc, 0x1, 0x1a, 0x1, 0x13, 0x1, 0x2, 0x1, 0xf, 0x2, 0xe, 0x22, 0x7b, 0x5, 0x3, 0x4, 0x2d, 0x3, 0x58, 0x1, 0xd, 0x3, 0x1, 0x2f, 0x2e, 0x80, 0x82, 0x1d, 0x3, 0x31, 0xf, 0x1c, 0x4, 0x24, 0x9, 0x1e, 0x5, 0x2b, 0x5, 0x1e, 0x1, 0x25, 0x4, 0xe, 0x2a, 0x80, 0x9e, 0x2, 0xa, 0x6, 0x24, 0x4, 0x24, 0x4, 0x28, 0x8, 0x34, 0xb, 0xc, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x1, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x43, 0x81, 0x37, 0x9, 0x16, 0xa, 0x8, 0x18, 0x6, 0x1, 0x2a, 0x1, 0x9, 0x45, 0x6, 0x2, 0x1, 0x1, 0x2c, 0x1, 0x2, 0x3, 0x1, 0x2, 0x17, 0x1, 0x48, 0x8, 0x9, 0x30, 0x13, 0x1, 0x2, 0x5, 0x21, 0x3, 0x1b, 0x5, 0x1, 0x40, 0x38, 0x4, 0x14, 0x2, 0x32, 0x1, 0x2, 0x5, 0x8, 0x1, 0x3, 0x1, 0x1d, 0x2, 0x3, 0x4, 0xa, 0x7, 0x9, 0x7, 0x40, 0x20, 0x27, 0x4, 0xc, 0x9, 0x36, 0x3, 0x1d, 0x2, 0x1b, 0x5, 0x1a, 0x7, 0x4, 0xc, 0x7, 0x50, 0x49, 0x37, 0x33, 0xd, 0x33, 0x7, 0x2e, 0x8, 0xa, 0x81, 0x26, 0x1f, 0x1, 0x2a, 0x1, 0x3, 0x2, 0x2, 0x4b, 0x2b, 0x8, 0x2a, 0x16, 0x1a, 0x26, 0x1c, 0x14, 0x17, 0x9, 0x4e, 0x4, 0x24, 0x9, 0x44, 0xa, 0x1, 0x2, 0x19, 0x7, 0xa, 0x6, 0x35, 0x1, 0x12, 0x8, 0x27, 0x9, 0x60, 0x1, 0x14, 0xb, 0x12, 0x1, 0x2f, 0x3e, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xf, 0x1, 0xb, 0x6, 0x3b, 0x5, 0xa, 0x6, 0x4, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x1, 0xa, 0x2, 0x2, 0x2, 0x3, 0x2, 0x1, 0x6, 0x1, 0x5, 0x7, 0x2, 0x7, 0x3, 0x5, 0x80, 0x8b, 0x5c, 0x1, 0x5, 0x1e, 0x48, 0x8, 0xa, 0x80, 0xa6, 0x36, 0x2, 0x26, 0x22, 0x45, 0xb, 0xa, 0x6, 0xd, 0x13, 0x3a, 0x6, 0xa, 0x36, 0x1b, 0x2, 0xf, 0x4, 0x17, 0x80, 0xb9, 0x3c, 0x64, 0x53, 0xc, 0x8, 0x2, 0x1, 0x2, 0x8, 0x1, 0x2, 0x1, 0x1e, 0x1, 0x2, 0x2, 0xc, 0x9, 0xa, 0x46, 0x8, 0x2, 0x2e, 0x2, 0xb, 0x1b, 0x48, 0x8, 0x53, 0xd, 0x49, 0x7, 0xa, 0x80, 0xf6, 0x9, 0x1, 0x2d, 0x1, 0xe, 0xa, 0x1d, 0x3, 0x20, 0x2, 0x16, 0x1, 0xe, 0x49, 0x7, 0x1, 0x2, 0x1, 0x2c, 0x3, 0x1, 0x1, 0x2, 0x1, 0x9, 0x8, 0xa, 0x6, 0x6, 0x1, 0x2, 0x1, 0x25, 0x1, 0x2, 0x1, 0x6, 0x7, 0xa, 0x81, 0x36, 0x19, 0x7, 0x11, 0x1, 0x29, 0x3, 0x1c, 0x56, 0x1, 0xf, 0x32, 0xd, 0x83, 0x9b, 0x66, 0x6f, 0x1, 0x5, 0xb, 0x80, 0xc4, 0x8a, 0x4c, 0x63, 0xd, 0x84, 0x56, 0x8f, 0xaa, 0x82, 0x47, 0xa0, 0x21, 0xb9, 0x82, 0x39, 0x7, 0x1f, 0x1, 0xa, 0x4, 0x51, 0x1, 0xa, 0x6, 0x1e, 0x2, 0x6, 0xa, 0x46, 0xa, 0xa, 0x1, 0x7, 0x1, 0x15, 0x5, 0x13, 0x82, 0xb0, 0x5b, 0x65, 0x4b, 0x4, 0x39, 0x7, 0x11, 0x40, 0x5, 0xb, 0x2, 0xe, 0x97, 0xf8, 0x8, 0x84, 0xd6, 0x2a, 0x9, 0xa0, 0x22, 0xe7, 0x4, 0x1, 0x7, 0x1, 0x2, 0x1, 0x81, 0x23, 0xf, 0x1, 0x1d, 0x3, 0x2, 0x1, 0xe, 0x4, 0x8, 0x81, 0x8c, 0x89, 0x4, 0x6b, 0x5, 0xd, 0x3, 0x9, 0x7, 0xa, 0x2, 0x8, 0x92, 0x5c, 0x2e, 0x2, 0x17, 0x9, 0x74, 0x3c, 0x80, 0xf6, 0xa, 0x27, 0x2, 0x80, 0xc2, 0x15, 0x46, 0x7a, 0x14, 0xc, 0x14, 0xc, 0x57, 0x9, 0x19, 0x80, 0x87, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x81, 0x24, 0x2, 0x82, 0xbe, 0xf, 0x5, 0x1, 0xf, 0x84, 0x50, 0x1f, 0x6, 0x6, 0x80, 0xd5, 0x7, 0x1, 0x11, 0x2, 0x7, 0x1, 0x2, 0x1, 0x5, 0x5, 0x3e, 0x21, 0x1, 0x70, 0x2d, 0x3, 0xe, 0x2, 0xa, 0x4, 0x2, 0x81, 0x40, 0x1f, 0x11, 0x3a, 0x5, 0x1, 0x81, 0xd0, 0x2a, 0x82, 0xe6, 0x7, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf, 0x1, 0x80, 0xc5, 0x2, 0x10, 0x29, 0x4c, 0x4, 0xa, 0x4, 0x2, 0x83, 0x11, 0x44, 0x4c, 0x3d, 0x80, 0xc2, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11, 0x34, 0x2, 0x81, 0xe, 0x2c, 0x4, 0x64, 0xc, 0xf, 0x2, 0xf, 0x1, 0xf, 0x1, 0x25, 0xa, 0x80, 0xae, 0x38, 0x1d, 0xd, 0x2c, 0x4, 0x9, 0x7, 0x2, 0xe, 0x6, 0x80, 0x9a, 0x83, 0xd8, 0x4, 0x11, 0x3, 0xd, 0x3, 0x77, 0x4, 0x5f, 0x6, 0xc, 0x4, 0x1, 0xf, 0xc, 0x4, 0x38, 0x8, 0xa, 0x6, 0x28, 0x8, 0x1e, 0x2, 0x2, 0x4e, 0x81, 0x54, 0xc, 0xe, 0x2, 0xd, 0x3, 0x9, 0x7, 0x2e, 0x1, 0x7, 0x8, 0xe, 0x4, 0x9, 0x7, 0x9, 0x7, 0x80, 0x93, 0x1, 0x37, 0x25, 0xa, 0x84, 0x6, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x8c, 0x1f, 0x82, 0x1e, 0x85, 0xe2, 0x93, 0x4b, 0x5, 0x90, 0x60, 0xaa, 0xdc, 0x51, 0x1, 0x1e, 0x60, 0x80, 0x80, 0x80, 0xf0, 0xa0, 0xfe, 0x10, 0xa0, 0xff, 0xfe, 0x2, 0xa0, 0xff, 0xfe];
_T Hyphen = [0x2d, 0x1, 0x7f, 0x1, 0x84, 0xdc, 0x1, 0x92, 0x7b, 0x1, 0x88, 0x9, 0x2, 0x8e, 0x5, 0x1, 0x82, 0xe3, 0x1, 0xa0, 0xcd, 0x67, 0x1, 0x80, 0xa9, 0x1, 0x57, 0x1];
_T Other_Math = [0x5e, 0x1, 0x83, 0x71, 0x3, 0x2, 0x1, 0x1a, 0x2, 0x2, 0x2, 0x9c, 0x20, 0x1, 0x1b, 0x3, 0xb, 0x1, 0x20, 0x4, 0x18, 0x2, 0xe, 0x2, 0x41, 0xd, 0x4, 0x1, 0x3, 0x2, 0x4, 0x5, 0x12, 0x1, 0x4, 0x1, 0x2, 0xa, 0x1, 0x1, 0x3, 0x5, 0x6, 0x1, 0x3, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x6, 0x3, 0x4, 0x5, 0x5, 0x4b, 0x5, 0x2, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 0x5, 0x2, 0x2, 0x4, 0x2, 0x4, 0x12, 0x2, 0x2, 0x1, 0x1, 0x1, 0x7, 0x1, 0x1, 0x6, 0x2, 0x81, 0x22, 0x4, 0x80, 0xa8, 0x2, 0x1, 0x1, 0x18, 0x1, 0x11, 0x1, 0x81, 0xbd, 0x2, 0xc, 0x9, 0x5, 0x5, 0x5, 0x2, 0x2, 0x2, 0x3, 0x5, 0xe, 0x1, 0x1, 0x1, 0x2, 0x6, 0x18, 0x2, 0x39, 0x1, 0x1, 0x1, 0x1d, 0x4, 0x9, 0x2, 0x81, 0x56, 0x2, 0x1f, 0xa, 0x81, 0x93, 0x16, 0x3f, 0x4, 0x20, 0x2, 0xa0, 0xd4, 0x63, 0x1, 0x1, 0x1, 0x4, 0x1, 0x80, 0xd3, 0x1, 0x1, 0x1, 0xa0, 0xd4, 0xc1, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x19, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x8, 0x2, 0x32, 0x96, 0x0, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11];
_T Ps = [0x28, 0x1, 0x32, 0x1, 0x1f, 0x1, 0x8e, 0xbe, 0x1, 0x1, 0x1, 0x87, 0x5e, 0x1, 0x89, 0x7e, 0x1, 0x3, 0x1, 0x26, 0x1, 0x37, 0x1, 0xf, 0x1, 0x82, 0x7a, 0x1, 0x1, 0x1, 0x1e, 0x1, 0x84, 0x3e, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x50, 0x1, 0x20, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x81, 0x94, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x40, 0x1, 0x1, 0x1, 0x21, 0x1, 0x84, 0x25, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x19, 0x1, 0x12, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x81, 0xac, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0xa0, 0xcd, 0x21, 0x1, 0x80, 0xd7, 0x1, 0x1d, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x11, 0x1, 0x1, 0x1, 0x1, 0x1, 0x80, 0xaa, 0x1, 0x32, 0x1, 0x1f, 0x1, 0x3, 0x1, 0x2, 0x1];
_T Zs = [0x20, 0x1, 0x7f, 0x1, 0x95, 0xdf, 0x1, 0x89, 0x7f, 0xb, 0x24, 0x1, 0x2f, 0x1, 0x8f, 0xa0, 0x1];
_T Alphabetic = [0x41, 0x1a, 0x6, 0x1a, 0x2f, 0x1, 0xa, 0x1, 0x4, 0x1, 0x5, 0x17, 0x1, 0x1f, 0x1, 0x81, 0xca, 0x4, 0xc, 0xe, 0x5, 0x7, 0x1, 0x1, 0x1, 0x56, 0x1, 0x2a, 0x5, 0x1, 0x2, 0x2, 0x4, 0x1, 0x1, 0x6, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x14, 0x1, 0x53, 0x1, 0x80, 0x8b, 0x8, 0x80, 0xa6, 0x1, 0x26, 0x2, 0x1, 0x6, 0x29, 0x27, 0xe, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x8, 0x1b, 0x4, 0x4, 0x1d, 0xb, 0x5, 0x38, 0x1, 0x7, 0xe, 0x66, 0x1, 0x8, 0x4, 0x8, 0x4, 0x3, 0xa, 0x3, 0x2, 0x1, 0x10, 0x30, 0xd, 0x65, 0x18, 0x21, 0x9, 0x2, 0x4, 0x1, 0x5, 0x18, 0x2, 0x13, 0x13, 0x19, 0x7, 0xb, 0x5, 0x18, 0x1, 0x6, 0x11, 0x2a, 0xa, 0xc, 0x3, 0x7, 0x6, 0x4c, 0x1, 0x10, 0x1, 0x3, 0x4, 0xf, 0xd, 0x13, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x1, 0x3, 0x4, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x8, 0x1, 0x4, 0x2, 0x1, 0x5, 0xc, 0x2, 0xa, 0x1, 0x4, 0x3, 0x1, 0x6, 0x4, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x5, 0x4, 0x2, 0x2, 0x2, 0x4, 0x1, 0x7, 0x4, 0x1, 0x1, 0x11, 0x6, 0xb, 0x3, 0x1, 0x9, 0x1, 0x3, 0x1, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x9, 0x1, 0x3, 0x1, 0x2, 0x3, 0x1, 0xf, 0x4, 0x15, 0x4, 0x4, 0x3, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x9, 0x2, 0x4, 0x2, 0x1, 0x5, 0xd, 0x1, 0x10, 0x2, 0x1, 0x6, 0x3, 0x3, 0x1, 0x4, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0xc, 0x4, 0x5, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 0x6, 0x1, 0x28, 0xd, 0x1, 0x3, 0x1, 0x17, 0x1, 0x10, 0x3, 0x8, 0x1, 0x3, 0x1, 0x3, 0x8, 0x2, 0x1, 0x3, 0x2, 0x1, 0x2, 0x4, 0x1c, 0x4, 0x1, 0x8, 0x1, 0x3, 0x1, 0x17, 0x1, 0xa, 0x1, 0x5, 0x3, 0x8, 0x1, 0x3, 0x1, 0x3, 0x8, 0x2, 0x6, 0x2, 0x1, 0x4, 0xd, 0x3, 0xc, 0xd, 0x1, 0x3, 0x1, 0x29, 0x2, 0x8, 0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x5, 0x4, 0x7, 0x5, 0x16, 0x6, 0x1, 0x3, 0x1, 0x12, 0x3, 0x18, 0x1, 0x9, 0x1, 0x1, 0x2, 0x7, 0x8, 0x6, 0x1, 0x1, 0x1, 0x8, 0x12, 0x2, 0xd, 0x3a, 0x5, 0x7, 0x6, 0x1, 0x33, 0x2, 0x1, 0x1, 0x1, 0x5, 0x1, 0x18, 0x1, 0x1, 0x1, 0x13, 0x1, 0x3, 0x2, 0x5, 0x1, 0x1, 0x6, 0x1, 0xe, 0x4, 0x20, 0x1, 0x3f, 0x8, 0x1, 0x24, 0x4, 0x13, 0x4, 0x10, 0x1, 0x24, 0x43, 0x37, 0x1, 0x1, 0x2, 0x5, 0x10, 0x40, 0xa, 0x4, 0x2, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x2b, 0x1, 0x81, 0x4d, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0x29, 0x1, 0x4, 0x2, 0x21, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0xf, 0x1, 0x39, 0x1, 0x4, 0x2, 0x43, 0x25, 0x10, 0x10, 0x56, 0x2, 0x6, 0x3, 0x82, 0x6c, 0x2, 0x11, 0x1, 0x1a, 0x5, 0x4b, 0x3, 0xb, 0x7, 0x14, 0xb, 0x15, 0xc, 0x14, 0xc, 0xd, 0x1, 0x3, 0x1, 0x2, 0xc, 0x34, 0x2, 0x13, 0xe, 0x1, 0x4, 0x1, 0x43, 0x59, 0x7, 0x2b, 0x5, 0x46, 0xa, 0x1f, 0x1, 0xc, 0x4, 0x9, 0x17, 0x1e, 0x2, 0x5, 0xb, 0x2c, 0x4, 0x1a, 0x36, 0x1c, 0x4, 0x3f, 0x2, 0x14, 0x32, 0x1, 0x17, 0x2, 0xb, 0x3, 0x31, 0x34, 0x1, 0xf, 0x1, 0x8, 0x33, 0x2a, 0x2, 0x4, 0xa, 0x2c, 0x1, 0xb, 0xe, 0x37, 0x16, 0x3, 0xa, 0x24, 0x2, 0x9, 0x7, 0x2b, 0x2, 0x3, 0x29, 0x4, 0x1, 0x6, 0x1, 0x2, 0x3, 0x1, 0x5, 0x80, 0xc0, 0x27, 0xe, 0xb, 0x81, 0x16, 0x2, 0x6, 0x2, 0x26, 0x2, 0x6, 0x2, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1f, 0x2, 0x35, 0x1, 0x7, 0x1, 0x1, 0x3, 0x3, 0x1, 0x7, 0x3, 0x4, 0x2, 0x6, 0x4, 0xd, 0x5, 0x3, 0x1, 0x7, 0x74, 0x1, 0xd, 0x1, 0x10, 0xd, 0x65, 0x1, 0x4, 0x1, 0x2, 0xa, 0x1, 0x1, 0x3, 0x5, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0xb, 0x2, 0x4, 0x5, 0x5, 0x4, 0x1, 0x11, 0x29, 0x83, 0x2d, 0x34, 0x87, 0x16, 0x80, 0xe5, 0x6, 0x4, 0x3, 0x2, 0xc, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x38, 0x7, 0x1, 0x10, 0x17, 0x9, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x20, 0x2f, 0x1, 0x81, 0xd5, 0x3, 0x19, 0x9, 0x7, 0x5, 0x2, 0x5, 0x4, 0x56, 0x6, 0x3, 0x1, 0x5a, 0x1, 0x4, 0x5, 0x2b, 0x1, 0x5e, 0x11, 0x20, 0x30, 0x10, 0x82, 0x0, 0x99, 0xc0, 0x40, 0xa0, 0x56, 0x8d, 0x43, 0x2e, 0x2, 0x81, 0xd, 0x3, 0x10, 0xa, 0x2, 0x14, 0x2f, 0x5, 0x8, 0x3, 0x71, 0x27, 0x9, 0x2, 0x67, 0x2, 0x40, 0x5, 0x2, 0x1, 0x1, 0x1, 0x5, 0x18, 0x14, 0x1, 0x21, 0x18, 0x34, 0xc, 0x44, 0x1, 0x1, 0x2c, 0x6, 0x3, 0x1, 0x1, 0x3, 0xa, 0x21, 0x5, 0x23, 0xd, 0x1d, 0x3, 0x33, 0x1, 0xc, 0xf, 0x1, 0x10, 0x10, 0xa, 0x5, 0x1, 0x37, 0x9, 0xe, 0x12, 0x17, 0x3, 0x45, 0x1, 0x1, 0x1, 0x1, 0x18, 0x3, 0x2, 0x10, 0x2, 0x4, 0xb, 0x6, 0x2, 0x6, 0x2, 0x6, 0x9, 0x7, 0x1, 0x7, 0x1, 0x2b, 0x1, 0xe, 0x6, 0x7b, 0x15, 0xa0, 0x2b, 0xa4, 0xc, 0x17, 0x4, 0x31, 0xa0, 0x21, 0x4, 0x81, 0x6e, 0x2, 0x6a, 0x26, 0x7, 0xc, 0x5, 0x5, 0xc, 0x1, 0xd, 0x1, 0x5, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x6c, 0x21, 0x81, 0x6b, 0x12, 0x40, 0x2, 0x36, 0x28, 0xc, 0x74, 0x5, 0x1, 0x80, 0x87, 0x24, 0x1a, 0x6, 0x1a, 0xb, 0x59, 0x3, 0x6, 0x2, 0x6, 0x2, 0x6, 0x2, 0x3, 0x23, 0xc, 0x1, 0x1a, 0x1, 0x13, 0x1, 0x2, 0x1, 0xf, 0x2, 0xe, 0x22, 0x7b, 0x45, 0x35, 0x81, 0xb, 0x1d, 0x3, 0x31, 0x2f, 0x20, 0xd, 0x1e, 0x5, 0x2b, 0x5, 0x1e, 0x2, 0x24, 0x4, 0x8, 0x1, 0x5, 0x2a, 0x80, 0x9e, 0x12, 0x24, 0x4, 0x24, 0x4, 0x28, 0x8, 0x34, 0xc, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x1, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x43, 0x81, 0x37, 0x9, 0x16, 0xa, 0x8, 0x18, 0x6, 0x1, 0x2a, 0x1, 0x9, 0x45, 0x6, 0x2, 0x1, 0x1, 0x2c, 0x1, 0x2, 0x3, 0x1, 0x2, 0x17, 0xa, 0x17, 0x9, 0x1f, 0x41, 0x13, 0x1, 0x2, 0xa, 0x16, 0xa, 0x1a, 0x46, 0x38, 0x6, 0x2, 0x40, 0x4, 0x1, 0x2, 0x5, 0x8, 0x1, 0x3, 0x1, 0x1d, 0x2a, 0x1d, 0x3, 0x1d, 0x23, 0x8, 0x1, 0x1c, 0x1b, 0x36, 0xa, 0x16, 0xa, 0x13, 0xd, 0x12, 0x6e, 0x49, 0x37, 0x33, 0xd, 0x33, 0xd, 0x28, 0x81, 0x58, 0x2a, 0x1, 0x2, 0x3, 0x2, 0x4e, 0x1d, 0xa, 0x1, 0x8, 0x16, 0x2a, 0x12, 0x2e, 0x15, 0x1b, 0x17, 0x9, 0x46, 0x2b, 0x5, 0xa, 0x39, 0x9, 0x1, 0xd, 0x19, 0x17, 0x33, 0x11, 0x4, 0x8, 0x23, 0x3, 0x1, 0x9, 0x40, 0x1, 0x4, 0x9, 0x2, 0xa, 0x1, 0x1, 0x1, 0x23, 0x12, 0x1, 0x22, 0x2, 0x1, 0x6, 0x4, 0x3e, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xf, 0x1, 0xa, 0x7, 0x39, 0x17, 0x4, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x3, 0x1, 0x6, 0x1, 0x5, 0x7, 0x80, 0x9c, 0x42, 0x1, 0x3, 0x1, 0x4, 0x14, 0x3, 0x1e, 0x42, 0x2, 0x2, 0x1, 0x1, 0x80, 0xb8, 0x36, 0x2, 0x7, 0x19, 0x6, 0x22, 0x3f, 0x1, 0x1, 0x3, 0x1, 0x3b, 0x36, 0x2, 0x1, 0x47, 0x1b, 0x2, 0xe, 0x15, 0x7, 0x80, 0xb9, 0x39, 0x67, 0x40, 0x1f, 0x8, 0x2, 0x1, 0x2, 0x8, 0x1, 0x2, 0x1, 0x1e, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x5d, 0x8, 0x2, 0x2e, 0x2, 0x6, 0x1, 0x1, 0x1, 0x2, 0x1b, 0x33, 0x2, 0xa, 0x11, 0x48, 0x5, 0x1, 0x12, 0x49, 0x81, 0x7, 0x9, 0x1, 0x2d, 0x1, 0x7, 0x1, 0x1, 0x31, 0x1e, 0x2, 0x16, 0x1, 0xe, 0x49, 0x7, 0x1, 0x2, 0x1, 0x2c, 0x3, 0x1, 0x1, 0x2, 0x1, 0x3, 0x1, 0x1, 0x2, 0x2, 0x18, 0x6, 0x1, 0x2, 0x1, 0x25, 0x1, 0x2, 0x1, 0x4, 0x1, 0x1, 0x81, 0x47, 0x17, 0x9, 0x11, 0x1, 0x29, 0x3, 0x3, 0x6f, 0x1, 0x4f, 0x83, 0x9a, 0x66, 0x6f, 0x11, 0x80, 0xc4, 0x8a, 0x4c, 0x61, 0xf, 0x84, 0x30, 0x11, 0x6, 0x8f, 0xb9, 0x82, 0x47, 0xa0, 0x21, 0xb9, 0x82, 0x39, 0x7, 0x1f, 0x11, 0x4f, 0x11, 0x1e, 0x12, 0x30, 0x10, 0x4, 0x1f, 0x15, 0x5, 0x13, 0x82, 0xb0, 0x40, 0x80, 0x80, 0x4b, 0x4, 0x39, 0x7, 0x11, 0x40, 0x2, 0x1, 0x1, 0xc, 0x2, 0xe, 0x97, 0xf8, 0x8, 0x84, 0xd6, 0x2a, 0x9, 0xa0, 0x22, 0xe7, 0x4, 0x1, 0x7, 0x1, 0x2, 0x1, 0x81, 0x23, 0xf, 0x1, 0x1d, 0x3, 0x2, 0x1, 0xe, 0x4, 0x8, 0x81, 0x8c, 0x89, 0x4, 0x6b, 0x5, 0xd, 0x3, 0x9, 0x7, 0xa, 0x4, 0x1, 0x97, 0x61, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x19, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x8, 0x87, 0x34, 0x1f, 0x6, 0x6, 0x80, 0xd5, 0x7, 0x1, 0x11, 0x2, 0x7, 0x1, 0x2, 0x1, 0x5, 0x5, 0x3e, 0x21, 0x1, 0x70, 0x2d, 0xa, 0x7, 0x10, 0x1, 0x81, 0x41, 0x1e, 0x12, 0x2c, 0x81, 0xe4, 0x1c, 0x82, 0xf4, 0x7, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf, 0x1, 0x80, 0xc5, 0x3b, 0x44, 0x3, 0x1, 0x3, 0x1, 0x84, 0xb4, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11, 0x82, 0x74, 0x1a, 0x6, 0x1a, 0x6, 0x1a, 0x8e, 0x76, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x8c, 0x1f, 0x82, 0x1e, 0x85, 0xe2, 0x93, 0x4b, 0x5, 0x90, 0x60];
_T XID_Start = [0x41, 0x1a, 0x6, 0x1a, 0x2f, 0x1, 0xa, 0x1, 0x4, 0x1, 0x5, 0x17, 0x1, 0x1f, 0x1, 0x81, 0xca, 0x4, 0xc, 0xe, 0x5, 0x7, 0x1, 0x1, 0x1, 0x80, 0x81, 0x5, 0x1, 0x2, 0x3, 0x3, 0x1, 0x1, 0x6, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x14, 0x1, 0x53, 0x1, 0x80, 0x8b, 0x8, 0x80, 0xa6, 0x1, 0x26, 0x2, 0x1, 0x6, 0x29, 0x47, 0x1b, 0x4, 0x4, 0x2d, 0x2b, 0x23, 0x2, 0x1, 0x63, 0x1, 0x1, 0xf, 0x2, 0x7, 0x2, 0xa, 0x3, 0x2, 0x1, 0x10, 0x1, 0x1, 0x1e, 0x1d, 0x59, 0xb, 0x1, 0x18, 0x21, 0x9, 0x2, 0x4, 0x1, 0x5, 0x16, 0x4, 0x1, 0x9, 0x1, 0x3, 0x1, 0x17, 0x19, 0x7, 0xb, 0x5, 0x18, 0x1, 0x6, 0x11, 0x2a, 0x3a, 0x36, 0x3, 0x1, 0x12, 0x1, 0x7, 0xa, 0xf, 0x10, 0x4, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x1, 0x3, 0x4, 0x3, 0x1, 0x10, 0x1, 0xd, 0x2, 0x1, 0x3, 0xe, 0x2, 0xa, 0x1, 0x8, 0x6, 0x4, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1f, 0x4, 0x1, 0x1, 0x13, 0x3, 0x10, 0x9, 0x1, 0x3, 0x1, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x12, 0x1, 0xf, 0x2, 0x17, 0x1, 0xb, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x1e, 0x2, 0x1, 0x3, 0xf, 0x1, 0x11, 0x1, 0x1, 0x6, 0x3, 0x3, 0x1, 0x4, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0xc, 0x16, 0x1, 0x34, 0x8, 0x1, 0x3, 0x1, 0x17, 0x1, 0x10, 0x3, 0x1, 0x1a, 0x3, 0x2, 0x1, 0x2, 0x2, 0x1e, 0x1, 0x4, 0x8, 0x1, 0x3, 0x1, 0x17, 0x1, 0xa, 0x1, 0x5, 0x3, 0x1, 0x1f, 0x2, 0x1, 0x2, 0xf, 0x2, 0x11, 0x9, 0x1, 0x3, 0x1, 0x29, 0x2, 0x1, 0x10, 0x1, 0x5, 0x3, 0x8, 0x3, 0x18, 0x6, 0x5, 0x12, 0x3, 0x18, 0x1, 0x9, 0x1, 0x1, 0x2, 0x7, 0x3a, 0x30, 0x1, 0x1, 0xd, 0x7, 0x3a, 0x2, 0x1, 0x1, 0x1, 0x5, 0x1, 0x18, 0x1, 0x1, 0x1, 0xa, 0x1, 0x1, 0xa, 0x1, 0x2, 0x5, 0x1, 0x1, 0x15, 0x4, 0x20, 0x1, 0x3f, 0x8, 0x1, 0x24, 0x1b, 0x5, 0x73, 0x2b, 0x14, 0x1, 0x10, 0x6, 0x4, 0x4, 0x3, 0x1, 0x3, 0x2, 0x7, 0x3, 0x4, 0xd, 0xc, 0x1, 0x11, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x2b, 0x1, 0x81, 0x4d, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0x29, 0x1, 0x4, 0x2, 0x21, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0xf, 0x1, 0x39, 0x1, 0x4, 0x2, 0x43, 0x25, 0x10, 0x10, 0x56, 0x2, 0x6, 0x3, 0x82, 0x6c, 0x2, 0x11, 0x1, 0x1a, 0x5, 0x4b, 0x3, 0xb, 0x7, 0x12, 0xd, 0x13, 0xe, 0x12, 0xe, 0xd, 0x1, 0x3, 0xf, 0x34, 0x23, 0x1, 0x4, 0x1, 0x43, 0x59, 0x7, 0x29, 0x1, 0x1, 0x5, 0x46, 0xa, 0x1f, 0x31, 0x1e, 0x2, 0x5, 0xb, 0x2c, 0x4, 0x1a, 0x36, 0x17, 0x9, 0x35, 0x52, 0x1, 0x5d, 0x2f, 0x11, 0x8, 0x36, 0x1e, 0xd, 0x2, 0xa, 0x2c, 0x1a, 0x24, 0x29, 0x3, 0xa, 0x24, 0x2, 0x9, 0x7, 0x2b, 0x2, 0x3, 0x29, 0x4, 0x1, 0x6, 0x1, 0x2, 0x3, 0x1, 0x5, 0x80, 0xc0, 0x40, 0x81, 0x16, 0x2, 0x6, 0x2, 0x26, 0x2, 0x6, 0x2, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1f, 0x2, 0x35, 0x1, 0x7, 0x1, 0x1, 0x3, 0x3, 0x1, 0x7, 0x3, 0x4, 0x2, 0x6, 0x4, 0xd, 0x5, 0x3, 0x1, 0x7, 0x74, 0x1, 0xd, 0x1, 0x10, 0xd, 0x65, 0x1, 0x4, 0x1, 0x2, 0xa, 0x1, 0x1, 0x2, 0x6, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x10, 0x2, 0x4, 0x5, 0x5, 0x4, 0x1, 0x11, 0x29, 0x8a, 0x77, 0x80, 0xe5, 0x6, 0x4, 0x3, 0x2, 0xc, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x38, 0x7, 0x1, 0x10, 0x17, 0x9, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x82, 0x26, 0x3, 0x19, 0x9, 0x7, 0x5, 0x2, 0x5, 0x4, 0x56, 0x6, 0x3, 0x1, 0x5a, 0x1, 0x4, 0x5, 0x2b, 0x1, 0x5e, 0x11, 0x20, 0x30, 0x10, 0x82, 0x0, 0x99, 0xc0, 0x40, 0xa0, 0x56, 0x8d, 0x43, 0x2e, 0x2, 0x81, 0xd, 0x3, 0x10, 0xa, 0x2, 0x14, 0x2f, 0x10, 0x1f, 0x2, 0x50, 0x27, 0x9, 0x2, 0x67, 0x2, 0x40, 0x5, 0x2, 0x1, 0x1, 0x1, 0x5, 0x18, 0x10, 0x1, 0x3, 0x1, 0x4, 0x1, 0x17, 0x1d, 0x34, 0xe, 0x32, 0x3e, 0x6, 0x3, 0x1, 0x1, 0x2, 0xb, 0x1c, 0xa, 0x17, 0x19, 0x1d, 0x7, 0x2f, 0x1c, 0x1, 0x10, 0x5, 0x1, 0xa, 0xa, 0x5, 0x1, 0x29, 0x17, 0x3, 0x1, 0x8, 0x14, 0x17, 0x3, 0x1, 0x3, 0x32, 0x1, 0x1, 0x3, 0x2, 0x2, 0x5, 0x2, 0x1, 0x1, 0x1, 0x18, 0x3, 0x2, 0xb, 0x7, 0x3, 0xc, 0x6, 0x2, 0x6, 0x2, 0x6, 0x9, 0x7, 0x1, 0x7, 0x1, 0x2b, 0x1, 0xe, 0x6, 0x73, 0x1d, 0xa0, 0x2b, 0xa4, 0xc, 0x17, 0x4, 0x31, 0xa0, 0x21, 0x4, 0x81, 0x6e, 0x2, 0x6a, 0x26, 0x7, 0xc, 0x5, 0x5, 0x1, 0x1, 0xa, 0x1, 0xd, 0x1, 0x5, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x6c, 0x21, 0x80, 0x8b, 0x6, 0x80, 0xda, 0x12, 0x40, 0x2, 0x36, 0x28, 0xa, 0x77, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7e, 0x24, 0x1a, 0x6, 0x1a, 0xb, 0x38, 0x2, 0x1f, 0x3, 0x6, 0x2, 0x6, 0x2, 0x6, 0x2, 0x3, 0x23, 0xc, 0x1, 0x1a, 0x1, 0x13, 0x1, 0x2, 0x1, 0xf, 0x2, 0xe, 0x22, 0x7b, 0x45, 0x35, 0x81, 0xb, 0x1d, 0x3, 0x31, 0x2f, 0x20, 0xd, 0x1e, 0x5, 0x26, 0xa, 0x1e, 0x2, 0x24, 0x4, 0x8, 0x1, 0x5, 0x2a, 0x80, 0x9e, 0x12, 0x24, 0x4, 0x24, 0x4, 0x28, 0x8, 0x34, 0xc, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x1, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x43, 0x81, 0x37, 0x9, 0x16, 0xa, 0x8, 0x18, 0x6, 0x1, 0x2a, 0x1, 0x9, 0x45, 0x6, 0x2, 0x1, 0x1, 0x2c, 0x1, 0x2, 0x3, 0x1, 0x2, 0x17, 0xa, 0x17, 0x9, 0x1f, 0x41, 0x13, 0x1, 0x2, 0xa, 0x16, 0xa, 0x1a, 0x46, 0x38, 0x6, 0x2, 0x40, 0x1, 0xf, 0x4, 0x1, 0x3, 0x1, 0x1d, 0x2a, 0x1d, 0x3, 0x1d, 0x23, 0x8, 0x1, 0x1c, 0x1b, 0x36, 0xa, 0x16, 0xa, 0x13, 0xd, 0x12, 0x6e, 0x49, 0x37, 0x33, 0xd, 0x33, 0xd, 0x24, 0x81, 0x5c, 0x2a, 0x6, 0x2, 0x4e, 0x1d, 0xa, 0x1, 0x8, 0x16, 0x2a, 0x12, 0x2e, 0x15, 0x1b, 0x17, 0xc, 0x35, 0x39, 0x2, 0x2, 0x1, 0xd, 0x2d, 0x20, 0x19, 0x1a, 0x24, 0x1d, 0x1, 0x2, 0x1, 0x8, 0x23, 0x3, 0x1, 0xc, 0x30, 0xe, 0x4, 0x15, 0x1, 0x1, 0x1, 0x23, 0x12, 0x1, 0x19, 0x13, 0x2, 0x3f, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xf, 0x1, 0xa, 0x7, 0x2f, 0x26, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x12, 0x1, 0xc, 0x5, 0x80, 0x9e, 0x35, 0x12, 0x4, 0x14, 0x3, 0x1e, 0x30, 0x14, 0x2, 0x1, 0x1, 0x80, 0xb8, 0x2f, 0x29, 0x4, 0x24, 0x30, 0x14, 0x1, 0x3b, 0x2b, 0xd, 0x1, 0x47, 0x1b, 0x25, 0x7, 0x80, 0xb9, 0x2c, 0x74, 0x40, 0x1f, 0x8, 0x2, 0x1, 0x2, 0x8, 0x1, 0x2, 0x1, 0x18, 0xf, 0x1, 0x1, 0x1, 0x5e, 0x8, 0x2, 0x27, 0x10, 0x1, 0x1, 0x1, 0x1c, 0x1, 0xa, 0x28, 0x7, 0x1, 0x15, 0x1, 0xb, 0x2e, 0x13, 0x1, 0x12, 0x49, 0x81, 0x7, 0x9, 0x1, 0x25, 0x11, 0x1, 0x31, 0x1e, 0x70, 0x7, 0x1, 0x2, 0x1, 0x26, 0x15, 0x1, 0x19, 0x6, 0x1, 0x2, 0x1, 0x20, 0xe, 0x1, 0x81, 0x47, 0x13, 0xf, 0x1, 0x1, 0xd, 0x1, 0x22, 0x7c, 0x1, 0x4f, 0x83, 0x9a, 0x66, 0x6f, 0x11, 0x80, 0xc4, 0x8a, 0x4c, 0x61, 0xf, 0x84, 0x30, 0x11, 0x6, 0x8f, 0xb9, 0x82, 0x47, 0xa0, 0x21, 0xb9, 0x82, 0x39, 0x7, 0x1f, 0x11, 0x4f, 0x11, 0x1e, 0x12, 0x30, 0x10, 0x4, 0x1f, 0x15, 0x5, 0x13, 0x82, 0xb0, 0x40, 0x80, 0x80, 0x4b, 0x5, 0x1, 0x42, 0xd, 0x40, 0x2, 0x1, 0x1, 0x1c, 0x97, 0xf8, 0x8, 0x84, 0xd6, 0x2a, 0x9, 0xa0, 0x22, 0xe7, 0x4, 0x1, 0x7, 0x1, 0x2, 0x1, 0x81, 0x23, 0xf, 0x1, 0x1d, 0x3, 0x2, 0x1, 0xe, 0x4, 0x8, 0x81, 0x8c, 0x89, 0x4, 0x6b, 0x5, 0xd, 0x3, 0x9, 0x7, 0xa, 0x97, 0x66, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x19, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x1f, 0x1, 0x19, 0x1, 0x8, 0x87, 0x34, 0x1f, 0x6, 0x6, 0x81, 0x5, 0x3e, 0x80, 0x92, 0x2d, 0xa, 0x7, 0x10, 0x1, 0x81, 0x41, 0x1e, 0x12, 0x2c, 0x81, 0xe4, 0x1c, 0x82, 0xf4, 0x7, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf, 0x1, 0x80, 0xc5, 0x3b, 0x44, 0x7, 0x1, 0x84, 0xb4, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11, 0x91, 0x44, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x8c, 0x1f, 0x82, 0x1e, 0x85, 0xe2, 0x93, 0x4b, 0x5, 0x90, 0x60];
_T Grapheme_Link = [0x89, 0x4d, 0x1, 0x7f, 0x1, 0x7f, 0x1, 0x7f, 0x1, 0x7f, 0x1, 0x7f, 0x1, 0x7f, 0x1, 0x7f, 0x1, 0x6d, 0x2, 0x10, 0x1, 0x7c, 0x1, 0x6f, 0x1, 0x7f, 0x1, 0x80, 0xc9, 0x1, 0x80, 0xb4, 0x2, 0x86, 0xd9, 0x2, 0x1e, 0x1, 0x80, 0x9d, 0x1, 0x82, 0x8d, 0x1, 0x80, 0xe3, 0x1, 0x65, 0x2, 0x46, 0x2, 0x91, 0x8b, 0x1, 0xa0, 0x7a, 0x86, 0x1, 0x25, 0x1, 0x80, 0x97, 0x1, 0x80, 0x8e, 0x1, 0x6c, 0x1, 0x81, 0x35, 0x1, 0x80, 0xf6, 0x1, 0xa0, 0x5e, 0x51, 0x1, 0x86, 0x6, 0x1, 0x29, 0x1, 0xe, 0x1, 0x39, 0x1, 0x79, 0x2, 0x80, 0x8b, 0x1, 0x74, 0x1, 0x80, 0xb4, 0x1, 0x62, 0x1, 0x80, 0xf4, 0x1, 0x7f, 0x1, 0x80, 0xfc, 0x1, 0x7f, 0x1, 0x76, 0x1, 0x74, 0x1, 0x81, 0xd, 0x1, 0x81, 0x3, 0x2, 0x80, 0xa1, 0x1, 0x53, 0x1, 0x12, 0x1, 0x51, 0x1, 0x81, 0xa5, 0x1, 0x81, 0x4, 0x2, 0x51, 0x1, 0x81, 0xa9, 0x2];
_T Dash = [0x2d, 0x1, 0x85, 0x5c, 0x1, 0x33, 0x1, 0x8e, 0x41, 0x1, 0x84, 0x5, 0x1, 0x88, 0x9, 0x6, 0x3d, 0x1, 0x27, 0x1, 0xf, 0x1, 0x81, 0x86, 0x1, 0x8c, 0x4, 0x1, 0x2, 0x1, 0x1f, 0x2, 0x4, 0x1, 0x1c, 0x1, 0x81, 0xbe, 0x1, 0x13, 0x1, 0x6f, 0x1, 0xa0, 0xcd, 0x90, 0x2, 0x25, 0x1, 0xa, 0x1, 0x80, 0xa9, 0x1, 0x8f, 0x9f, 0x1];
_T Nl = [0x96, 0xee, 0x3, 0x8a, 0x6f, 0x23, 0x2, 0x4, 0x8e, 0x7e, 0x1, 0x19, 0x9, 0xe, 0x3, 0xa0, 0x76, 0xab, 0xa, 0xa0, 0x5a, 0x50, 0x35, 0x81, 0xcc, 0x1, 0x8, 0x1, 0x80, 0x86, 0x5, 0xa0, 0x20, 0x2a, 0x6f];
_T IDS_Trinary_Operator = [0xa0, 0x2f, 0xf2, 0x2];
_T Terminal_Punctuation = [0x21, 0x1, 0xa, 0x1, 0x1, 0x1, 0xb, 0x2, 0x3, 0x1, 0x83, 0x3e, 0x1, 0x8, 0x1, 0x82, 0x1, 0x1, 0x39, 0x1, 0x48, 0x1, 0xe, 0x1, 0x1, 0x3, 0x80, 0xb4, 0x1, 0x2b, 0xb, 0x1, 0x1, 0x80, 0xeb, 0x2, 0x36, 0xf, 0x1f, 0x1, 0x81, 0x5, 0x2, 0x84, 0xf4, 0x2, 0x80, 0xac, 0x1, 0x4, 0x6, 0x81, 0x37, 0x2, 0x83, 0x15, 0x8, 0x83, 0x5, 0x1, 0x7c, 0x3, 0x47, 0x2, 0x80, 0x9d, 0x3, 0x3, 0x1, 0x27, 0x4, 0x2, 0x2, 0x81, 0x3a, 0x2, 0x81, 0x62, 0x4, 0x80, 0xae, 0x2, 0x1, 0x3, 0x1d, 0x2, 0x80, 0xbc, 0x5, 0x3e, 0x2, 0x83, 0xbc, 0x2, 0x9, 0x3, 0x8d, 0xe4, 0x1, 0xd, 0x1, 0x4, 0x1, 0xa, 0x1, 0x1, 0x2, 0x3, 0x2, 0x81, 0xac, 0x2, 0xa0, 0x74, 0xfb, 0x2, 0x81, 0xd, 0x3, 0x80, 0xe3, 0x5, 0x81, 0x7e, 0x2, 0x56, 0x2, 0x5f, 0x1, 0x80, 0x97, 0x3, 0x80, 0x93, 0x3, 0x7f, 0x1, 0x10, 0x2, 0x80, 0xf9, 0x1, 0xa0, 0x52, 0x64, 0x3, 0x1, 0x4, 0x80, 0xa9, 0x1, 0xa, 0x1, 0x1, 0x1, 0xb, 0x2, 0x3, 0x1, 0x41, 0x1, 0x2, 0x1, 0x84, 0x3a, 0x1, 0x30, 0x1, 0x84, 0x86, 0x1, 0x80, 0xc7, 0x1, 0x81, 0x36, 0x2, 0x80, 0x98, 0x6, 0x44, 0x6, 0x59, 0x4, 0x83, 0xb8, 0x5, 0x2c, 0x4, 0x80, 0xbd, 0x7, 0x70, 0x4, 0x7f, 0x3, 0x80, 0x81, 0x2, 0x6, 0x1, 0x10, 0x2, 0x58, 0x5, 0x6c, 0x1, 0x81, 0xa1, 0x3, 0xc, 0x2, 0x81, 0x66, 0x4, 0x3, 0xf, 0x69, 0x2, 0x80, 0xf9, 0x3, 0x82, 0x5, 0x1, 0x1, 0x1, 0x80, 0xfb, 0x2, 0x57, 0x2, 0x4, 0x2, 0x81, 0x9e, 0x3, 0x2d, 0x1, 0x82, 0x85, 0x2, 0x4a, 0x2, 0x85, 0x2b, 0x5, 0xa0, 0x45, 0xf9, 0x2, 0x80, 0x85, 0x1, 0x41, 0x3, 0xa, 0x1, 0x83, 0x52, 0x2, 0xa0, 0x4e, 0x6, 0x1, 0x9d, 0xe7, 0x4];
_T Nd = [0x30, 0xa, 0x86, 0x26, 0xa, 0x80, 0x86, 0xa, 0x80, 0xc6, 0xa, 0x81, 0x9c, 0xa, 0x76, 0xa, 0x76, 0xa, 0x76, 0xa, 0x76, 0xa, 0x76, 0xa, 0x76, 0xa, 0x76, 0xa, 0x76, 0xa, 0x76, 0xa, 0x60, 0xa, 0x76, 0xa, 0x46, 0xa, 0x81, 0x16, 0xa, 0x46, 0xa, 0x87, 0x46, 0xa, 0x26, 0xa, 0x81, 0x2c, 0xa, 0x80, 0x80, 0xa, 0x80, 0xa6, 0xa, 0x6, 0xa, 0x80, 0xb6, 0xa, 0x56, 0xa, 0x80, 0x86, 0xa, 0x6, 0xa, 0xa0, 0x89, 0xc6, 0xa, 0x82, 0xa6, 0xa, 0x26, 0xa, 0x80, 0xc6, 0xa, 0x16, 0xa, 0x56, 0xa, 0x81, 0x96, 0xa, 0xa0, 0x53, 0x16, 0xa, 0x85, 0x86, 0xa, 0x88, 0x86, 0xa, 0x83, 0x2c, 0xa, 0x80, 0x80, 0xa, 0x3c, 0xa, 0x80, 0x90, 0xa, 0x81, 0x16, 0xa, 0x81, 0x56, 0xa, 0x76, 0xa, 0x81, 0x76, 0xa, 0x66, 0xa, 0x66, 0xa, 0x81, 0xa6, 0xa, 0x66, 0xa, 0x82, 0xf6, 0xa, 0x80, 0xf6, 0xa, 0x46, 0xa, 0x81, 0xa6, 0xa, 0xa0, 0x4b, 0x6, 0xa, 0x56, 0xa, 0x80, 0x86, 0xa, 0xa0, 0x6c, 0x74, 0x32, 0x89, 0x40, 0xa, 0x81, 0xa6, 0xa, 0x81, 0xf6, 0xa, 0x84, 0x56, 0xa, 0x92, 0x96, 0xa];
_T Prepended_Concatenation_Mark = [0x86, 0x0, 0x6, 0x80, 0xd7, 0x1, 0x31, 0x1, 0x81, 0x80, 0x2, 0x50, 0x1, 0xa1, 0x7, 0xda, 0x1, 0xf, 0x1];
_T Mc = [0x89, 0x3, 0x1, 0x37, 0x1, 0x2, 0x3, 0x8, 0x4, 0x1, 0x2, 0x32, 0x2, 0x3a, 0x3, 0x6, 0x2, 0x2, 0x2, 0xa, 0x1, 0x2b, 0x1, 0x3a, 0x3, 0x42, 0x1, 0x3a, 0x3, 0x8, 0x1, 0x1, 0x2, 0x35, 0x2, 0x3a, 0x1, 0x1, 0x1, 0x6, 0x2, 0x2, 0x2, 0xa, 0x1, 0x66, 0x2, 0x1, 0x2, 0x3, 0x3, 0x1, 0x3, 0xa, 0x1, 0x29, 0x3, 0x3d, 0x4, 0x3d, 0x2, 0x3a, 0x1, 0x1, 0x5, 0x2, 0x2, 0x1, 0x2, 0x9, 0x2, 0x1c, 0x1, 0xe, 0x2, 0x3a, 0x3, 0x5, 0x3, 0x1, 0x3, 0xa, 0x1, 0x2a, 0x2, 0x4b, 0x3, 0x6, 0x8, 0x12, 0x2, 0x81, 0x4a, 0x2, 0x3f, 0x1, 0x80, 0xab, 0x2, 0x4, 0x1, 0x6, 0x1, 0x2, 0x2, 0x19, 0x2, 0xa, 0x3, 0x2, 0x7, 0x15, 0x2, 0x2, 0x6, 0x2, 0x1, 0xa, 0x3, 0x86, 0x78, 0x1, 0x1e, 0x1, 0x80, 0x81, 0x1, 0x7, 0x8, 0x1, 0x2, 0x81, 0x5a, 0x4, 0x2, 0x3, 0x4, 0x2, 0x1, 0x6, 0x80, 0xe0, 0x2, 0x3a, 0x1, 0x1, 0x1, 0x9, 0x1, 0x1, 0x2, 0x8, 0x6, 0x80, 0x91, 0x1, 0x30, 0x1, 0x5, 0x1, 0x1, 0x5, 0x1, 0x2, 0x3d, 0x1, 0x1e, 0x1, 0x4, 0x2, 0x2, 0x1, 0x3c, 0x1, 0x2, 0x3, 0x1, 0x1, 0x3, 0x2, 0x30, 0x8, 0x8, 0x2, 0x80, 0xab, 0x1, 0x15, 0x1, 0x93, 0x36, 0x2, 0xa0, 0x77, 0xf3, 0x2, 0x2, 0x1, 0x58, 0x2, 0x32, 0x10, 0x80, 0x8e, 0x2, 0x2f, 0x1, 0x30, 0x2, 0x4, 0x2, 0x2, 0x3, 0x6e, 0x2, 0x2, 0x2, 0x18, 0x1, 0x2d, 0x1, 0x1, 0x1, 0x6d, 0x1, 0x2, 0x2, 0x5, 0x1, 0x80, 0xed, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0xa0, 0x64, 0x13, 0x1, 0x1, 0x1, 0x7f, 0x1, 0x2d, 0x3, 0x4, 0x2, 0x73, 0x1, 0x18, 0x2, 0x3b, 0x1, 0x30, 0x3, 0x9, 0x2, 0xd, 0x1, 0x5d, 0x3, 0x3, 0x2, 0x1, 0x1, 0x80, 0xaa, 0x3, 0x1f, 0x2, 0x3a, 0x2, 0x1, 0x4, 0x2, 0x2, 0x2, 0x3, 0x9, 0x1, 0xa, 0x2, 0x80, 0xd1, 0x3, 0x8, 0x2, 0x3, 0x1, 0x6a, 0x3, 0x6, 0x1, 0x1, 0x4, 0x2, 0x1, 0x80, 0xed, 0x3, 0x6, 0x4, 0x2, 0x1, 0x71, 0x3, 0x8, 0x2, 0x1, 0x1, 0x6d, 0x1, 0x1, 0x2, 0x6, 0x1, 0x69, 0x2, 0x4, 0x1, 0x81, 0x5, 0x3, 0x9, 0x1, 0x80, 0xf7, 0x6, 0x1, 0x2, 0x4, 0x1, 0x2, 0x1, 0x1, 0x1, 0x80, 0x8e, 0x3, 0x8, 0x4, 0x4, 0x1, 0x54, 0x1, 0x1d, 0x2, 0x3e, 0x1, 0x81, 0x97, 0x1, 0xe, 0x1, 0x6a, 0x1, 0x7, 0x1, 0x2, 0x1, 0x80, 0xd5, 0x5, 0x4, 0x2, 0x1, 0x1, 0x81, 0x5e, 0x2, 0xc, 0x1, 0x30, 0x2, 0x8, 0x2, 0x1, 0x1, 0xa0, 0x50, 0xf, 0x37, 0x68, 0x2, 0xa0, 0x61, 0x73, 0x2, 0x6, 0x6];
_T ASCII_Hex_Digit = [0x30, 0xa, 0x7, 0x6, 0x1a, 0x6];
_T Quotation_Mark = [0x22, 0x1, 0x4, 0x1, 0x80, 0x83, 0x1, 0xf, 0x1, 0x9f, 0x5c, 0x8, 0x19, 0x2, 0x8e, 0x7, 0x1, 0x81, 0xc9, 0x4, 0xd, 0x3, 0xa0, 0xce, 0x21, 0x4, 0x80, 0xbd, 0x1, 0x4, 0x1, 0x5a, 0x2];
_T Radical = [0xa0, 0x2e, 0x80, 0x1a, 0x1, 0x59, 0xc, 0x80, 0xd6];
_T Other_Default_Ignorable_Code_Point = [0x83, 0x4f, 0x1, 0x8e, 0xf, 0x2, 0x86, 0x53, 0x2, 0x88, 0xaf, 0x1, 0x90, 0xfe, 0x1, 0xa0, 0xce, 0x3b, 0x1, 0x4f, 0x9, 0xad, 0x0, 0x7, 0x1, 0x1, 0x1e, 0x60, 0x80, 0x80, 0x80, 0xf0, 0x8e, 0x10];
_T Join_Control = [0xa0, 0x20, 0xc, 0x2];
_T Grapheme_Base = [0x20, 0x5f, 0x21, 0xd, 0x1, 0x82, 0x52, 0x70, 0x8, 0x2, 0x6, 0x4, 0x7, 0x1, 0x1, 0x1, 0x14, 0x1, 0x80, 0xe0, 0x7, 0x80, 0xa6, 0x1, 0x26, 0x2, 0x32, 0x2, 0x3, 0x2e, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x9, 0x1b, 0x4, 0x6, 0x11, 0xa, 0xb, 0x1, 0x1, 0x2e, 0x15, 0x10, 0x1, 0x65, 0x8, 0x1, 0x6, 0x2, 0x2, 0x1, 0x4, 0x20, 0x2, 0x1, 0x1, 0x1e, 0x1d, 0x59, 0xb, 0x1, 0xe, 0x2b, 0x9, 0x7, 0x3, 0x18, 0x4, 0x1, 0x9, 0x1, 0x3, 0x1, 0x7, 0xf, 0x1, 0x19, 0x5, 0x1, 0x1, 0xb, 0x5, 0x1f, 0x11, 0x2a, 0x39, 0x37, 0x1, 0x1, 0x1, 0x4, 0x8, 0x4, 0x1, 0x3, 0x7, 0xa, 0x2, 0x1d, 0x1, 0x2, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x1, 0x3, 0x4, 0x3, 0x1, 0x1, 0x2, 0x6, 0x2, 0x2, 0x2, 0x1, 0x1, 0xd, 0x2, 0x1, 0x3, 0x4, 0x18, 0x5, 0x1, 0x1, 0x6, 0x4, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x3, 0x18, 0x4, 0x1, 0x1, 0x7, 0xa, 0x2, 0x3, 0x1, 0x1, 0xc, 0x1, 0x1, 0x9, 0x1, 0x3, 0x1, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x4, 0x8, 0x1, 0x1, 0x2, 0x3, 0x1, 0xf, 0x2, 0x4, 0xc, 0x7, 0x1, 0x8, 0x2, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x2, 0x1, 0x6, 0x2, 0x2, 0x2, 0xf, 0x2, 0x1, 0x3, 0x4, 0x12, 0xb, 0x1, 0x1, 0x6, 0x3, 0x3, 0x1, 0x4, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0xc, 0x5, 0x1, 0x1, 0x2, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 0x15, 0x15, 0x6, 0x3, 0x1, 0x8, 0x1, 0x3, 0x1, 0x17, 0x1, 0x10, 0x3, 0x1, 0x3, 0x4, 0x13, 0x3, 0x2, 0x1, 0x2, 0x2, 0x4, 0xa, 0x7, 0xa, 0x1, 0xb, 0x1, 0x3, 0x1, 0x17, 0x1, 0xa, 0x1, 0x5, 0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 0x2, 0x2, 0x1, 0x2, 0x11, 0x2, 0x1, 0x2, 0x4, 0xa, 0x1, 0x3, 0xe, 0xb, 0x1, 0x3, 0x1, 0x29, 0x2, 0x1, 0x1, 0x2, 0x5, 0x3, 0x1, 0x3, 0x1, 0x2, 0x4, 0x3, 0x1, 0xa, 0x4, 0x1a, 0x2, 0x2, 0x1, 0x12, 0x3, 0x18, 0x1, 0x9, 0x1, 0x1, 0x2, 0x7, 0x9, 0x2, 0x6, 0x7, 0x7, 0xa, 0x2, 0x3, 0xc, 0x30, 0x1, 0x2, 0xb, 0x8, 0x8, 0xd, 0x25, 0x2, 0x1, 0x1, 0x1, 0x5, 0x1, 0x18, 0x1, 0x1, 0x1, 0xa, 0x1, 0x2, 0x9, 0x1, 0x2, 0x5, 0x1, 0x1, 0x9, 0xa, 0x2, 0x4, 0x20, 0x18, 0x2, 0x1b, 0x1, 0x1, 0x1, 0x1, 0x1, 0xe, 0x1, 0x24, 0x12, 0x1, 0x5, 0x1, 0x2, 0x5, 0x31, 0x8, 0x1, 0x6, 0x1, 0xd, 0x25, 0x2d, 0x4, 0x1, 0x6, 0x1, 0x2, 0x2, 0x2, 0x19, 0x2, 0x4, 0x3, 0x10, 0x4, 0xd, 0x1, 0x2, 0x2, 0x6, 0x1, 0xf, 0x1, 0x28, 0x1, 0x1, 0x5, 0x1, 0x2, 0x81, 0x79, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0x29, 0x1, 0x4, 0x2, 0x21, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0xf, 0x1, 0x39, 0x1, 0x4, 0x2, 0x43, 0x5, 0x1d, 0x3, 0x1a, 0x6, 0x56, 0x2, 0x6, 0x2, 0x82, 0x9d, 0x3, 0x59, 0x7, 0x12, 0x3, 0x1, 0x9, 0x13, 0x2, 0x3, 0x9, 0x12, 0xe, 0xd, 0x1, 0x3, 0xf, 0x34, 0x2, 0x1, 0x7, 0x8, 0x1, 0x2, 0xb, 0x9, 0x3, 0xa, 0x6, 0xa, 0x6, 0xb, 0x5, 0xa, 0x6, 0x59, 0x7, 0x5, 0x2, 0x22, 0x1, 0x1, 0x5, 0x46, 0xa, 0x1f, 0x4, 0x4, 0x2, 0x3, 0x4, 0x2, 0x1, 0x6, 0x7, 0x1, 0x3, 0x2a, 0x2, 0x5, 0xb, 0x2c, 0x4, 0x1a, 0x6, 0xb, 0x3, 0x39, 0x2, 0x2, 0x3, 0x38, 0x1, 0x1, 0x9, 0x1, 0x1, 0x2, 0x8, 0x6, 0xd, 0xa, 0x6, 0xa, 0x6, 0xe, 0x56, 0x30, 0x7, 0x1, 0x1, 0x5, 0x1, 0xa, 0x3, 0x1b, 0x9, 0xb, 0x3, 0x20, 0x4, 0x2, 0x2, 0x1, 0x3, 0x38, 0x1, 0x1, 0x2, 0x3, 0x1, 0x1, 0x3, 0x2, 0x8, 0x30, 0x8, 0x2, 0x5, 0xf, 0x3, 0x3c, 0x7, 0x2b, 0x2, 0xb, 0xb, 0x1, 0xd, 0x1, 0x7, 0x4, 0x1, 0x6, 0x1, 0x3, 0x2, 0x1, 0x5, 0x80, 0xc0, 0x40, 0x81, 0x16, 0x2, 0x6, 0x2, 0x26, 0x2, 0x6, 0x2, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1f, 0x2, 0x35, 0x1, 0xf, 0x1, 0xe, 0x2, 0x6, 0x1, 0x13, 0x2, 0x3, 0x1, 0x9, 0x1, 0xb, 0x5, 0x18, 0x7, 0x31, 0x10, 0x2, 0x2, 0x1b, 0x1, 0xd, 0x3, 0x21, 0x3f, 0x80, 0x8c, 0x4, 0x82, 0x97, 0x19, 0xb, 0x15, 0x87, 0x14, 0x2, 0x20, 0x1, 0x81, 0x58, 0x3, 0x2, 0x5, 0x2d, 0x1, 0x1, 0x5, 0x1, 0x2, 0x38, 0x7, 0x2, 0xf, 0x17, 0x9, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x21, 0x5e, 0x22, 0x1a, 0x1, 0x59, 0xc, 0x80, 0xd6, 0x1a, 0xc, 0x4, 0x2a, 0x6, 0x10, 0x1, 0x56, 0x4, 0x65, 0x5, 0x2b, 0x1, 0x5e, 0x1, 0x54, 0xc, 0x2f, 0x1, 0xa0, 0x72, 0x6d, 0x3, 0x37, 0x9, 0x81, 0x5c, 0x14, 0x2f, 0x4, 0x1, 0xa, 0x20, 0x2, 0x50, 0x2, 0x6, 0x8, 0x80, 0xcb, 0x5, 0x2, 0x1, 0x1, 0x1, 0x5, 0x18, 0x10, 0x1, 0x3, 0x1, 0x4, 0x1, 0x19, 0x2, 0x5, 0x4, 0xa, 0x6, 0x38, 0x8, 0x44, 0xa, 0xc, 0x18, 0xd, 0x1, 0x26, 0x8, 0x19, 0xb, 0x2, 0xb, 0x1e, 0x6, 0x30, 0x1, 0x2, 0x4, 0x2, 0x2, 0x10, 0x1, 0xb, 0x4, 0x7, 0x1, 0x19, 0x1, 0x29, 0x6, 0x2, 0x2, 0x2, 0xb, 0x3, 0x1, 0x8, 0x1, 0x1, 0x2, 0xa, 0x2, 0x20, 0x1, 0x33, 0x1, 0x1, 0x3, 0x2, 0x2, 0x5, 0x2, 0x1, 0x1, 0x1, 0x18, 0x11, 0x2, 0x8, 0xb, 0x6, 0x2, 0x6, 0x2, 0x6, 0x9, 0x7, 0x1, 0x7, 0x1, 0x3c, 0x4, 0x75, 0x1, 0x2, 0x1, 0x4, 0x3, 0xa, 0x6, 0xa0, 0x2b, 0xa4, 0xc, 0x17, 0x4, 0x31, 0xa0, 0x21, 0x4, 0x81, 0x6e, 0x2, 0x6a, 0x26, 0x7, 0xc, 0x5, 0x5, 0x1, 0x1, 0x18, 0x1, 0x5, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x7d, 0x10, 0x81, 0xbd, 0x2, 0x36, 0x7, 0x1, 0x20, 0x10, 0x10, 0xa, 0x16, 0x23, 0x1, 0x13, 0x1, 0x4, 0x4, 0x5, 0x1, 0x80, 0x87, 0x4, 0x80, 0x9d, 0x2, 0x1f, 0x3, 0x6, 0x2, 0x6, 0x2, 0x6, 0x2, 0x3, 0x3, 0x7, 0x1, 0x7, 0xd, 0x2, 0x2, 0xc, 0x1, 0x1a, 0x1, 0x13, 0x1, 0x2, 0x1, 0xf, 0x2, 0xe, 0x22, 0x7b, 0x5, 0x3, 0x4, 0x2d, 0x3, 0x58, 0x1, 0xd, 0x3, 0x1, 0x2f, 0x2d, 0x80, 0x83, 0x1d, 0x3, 0x31, 0x10, 0x1b, 0x4, 0x24, 0x9, 0x1e, 0x5, 0x26, 0xa, 0x1e, 0x1, 0x25, 0x4, 0xe, 0x2a, 0x80, 0x9e, 0x2, 0xa, 0x6, 0x24, 0x4, 0x24, 0x4, 0x28, 0x8, 0x34, 0xb, 0xc, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x1, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x43, 0x81, 0x37, 0x9, 0x16, 0xa, 0x8, 0x18, 0x6, 0x1, 0x2a, 0x1, 0x9, 0x45, 0x6, 0x2, 0x1, 0x1, 0x2c, 0x1, 0x2, 0x3, 0x1, 0x2, 0x17, 0x1, 0x48, 0x8, 0x9, 0x30, 0x13, 0x1, 0x2, 0x5, 0x21, 0x3, 0x1b, 0x5, 0x1, 0x40, 0x38, 0x4, 0x14, 0x2, 0x2f, 0xf, 0x4, 0x1, 0x3, 0x1, 0x1d, 0xa, 0x9, 0x7, 0x9, 0x7, 0x40, 0x20, 0x25, 0x6, 0xc, 0x9, 0x36, 0x3, 0x1d, 0x2, 0x1b, 0x5, 0x1a, 0x7, 0x4, 0xc, 0x7, 0x50, 0x49, 0x37, 0x33, 0xd, 0x33, 0x7, 0x2a, 0xc, 0xa, 0x81, 0x26, 0x1f, 0x1, 0x2a, 0x3, 0x1, 0x2, 0x2, 0x4e, 0x28, 0x8, 0x16, 0xb, 0x9, 0x16, 0x12, 0x4, 0x4, 0x26, 0x1c, 0x14, 0x17, 0x9, 0x1, 0x1, 0x36, 0xf, 0x7, 0x4, 0x1e, 0x1, 0x2, 0x2, 0x1, 0xc, 0x31, 0x4, 0x2, 0x2, 0x2, 0x1, 0x4, 0xe, 0x19, 0x7, 0xa, 0x9, 0x24, 0x5, 0x1, 0x9, 0x12, 0x8, 0x23, 0x1, 0x3, 0xb, 0x34, 0x9, 0xa, 0x4, 0x2, 0x1, 0x10, 0x1, 0x14, 0xb, 0x12, 0x1, 0x1c, 0x3, 0x2, 0x1, 0x1, 0x2, 0x6, 0x1, 0x2, 0x3f, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xf, 0x1, 0xb, 0x6, 0x2f, 0x1, 0x3, 0xd, 0xa, 0x8, 0x2, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x3, 0x1, 0x1, 0x1, 0x1, 0x4, 0x2, 0x2, 0x2, 0x3, 0x2, 0x1, 0xc, 0x7, 0x80, 0x9c, 0x38, 0x8, 0x2, 0x3, 0x1, 0x1, 0x15, 0x1, 0x1, 0x1, 0x3, 0x1e, 0x30, 0x1, 0x2, 0x6, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x4, 0x8, 0xa, 0x80, 0xa6, 0x2f, 0x1, 0x2, 0x6, 0x4, 0x2, 0x1, 0x2, 0x1b, 0x24, 0x33, 0x8, 0x2, 0x1, 0x1, 0x2, 0x4, 0xb, 0xa, 0x6, 0xd, 0x13, 0x2b, 0x1, 0x1, 0x1, 0x2, 0x6, 0x1, 0x1, 0x2, 0x6, 0xa, 0x36, 0x1b, 0x5, 0x2, 0x4, 0x1, 0x9, 0x17, 0x80, 0xb9, 0x2f, 0x9, 0x1, 0x2, 0x1, 0x64, 0x53, 0xc, 0x8, 0x2, 0x1, 0x2, 0x8, 0x1, 0x2, 0x1, 0x18, 0x1, 0x5, 0x1, 0x2, 0x4, 0x1, 0x1, 0x4, 0x1, 0x3, 0x9, 0xa, 0x46, 0x8, 0x2, 0x2a, 0x8, 0x4, 0x1, 0x4, 0x1b, 0x1, 0xa, 0x28, 0x6, 0x2, 0x4, 0x8, 0x9, 0x1, 0x6, 0x2, 0x3, 0x2e, 0xd, 0x1, 0x2, 0x9, 0xd, 0x49, 0x7, 0xa, 0x80, 0xf6, 0x9, 0x1, 0x26, 0xe, 0x1, 0x1, 0x6, 0xa, 0x1d, 0x3, 0x20, 0x19, 0x1, 0x7, 0x1, 0x2, 0x1, 0x4b, 0x7, 0x1, 0x2, 0x1, 0x26, 0x15, 0x1, 0x9, 0xa, 0x6, 0x6, 0x1, 0x2, 0x1, 0x25, 0x4, 0x2, 0x1, 0x1, 0x1, 0x1, 0x7, 0xa, 0x81, 0x36, 0x13, 0x2, 0x4, 0x9, 0xf, 0x1, 0x24, 0x8, 0x2, 0x1, 0x1, 0x1, 0x17, 0x56, 0x1, 0xf, 0x32, 0xd, 0x83, 0x9b, 0x66, 0x6f, 0x1, 0x5, 0xb, 0x80, 0xc4, 0x8a, 0x4c, 0x63, 0xd, 0x84, 0x30, 0x11, 0x6, 0x8f, 0xb9, 0x82, 0x47, 0xa0, 0x21, 0xb9, 0x82, 0x39, 0x7, 0x1f, 0x1, 0xa, 0x4, 0x51, 0x1, 0xa, 0x6, 0x1e, 0x7, 0x1, 0xa, 0x30, 0x7, 0xf, 0xa, 0xa, 0x1, 0x7, 0x1, 0x15, 0x5, 0x13, 0x82, 0xb0, 0x5b, 0x65, 0x4b, 0x5, 0x38, 0xb, 0xd, 0x40, 0x4, 0xc, 0x2, 0xe, 0x97, 0xf8, 0x8, 0x84, 0xd6, 0x2a, 0x9, 0xa0, 0x22, 0xe7, 0x4, 0x1, 0x7, 0x1, 0x2, 0x1, 0x81, 0x23, 0xf, 0x1, 0x1d, 0x3, 0x2, 0x1, 0xe, 0x4, 0x8, 0x81, 0x8c, 0x89, 0x4, 0x6b, 0x5, 0xd, 0x3, 0x9, 0x7, 0xa, 0x2, 0x1, 0x2, 0x1, 0x92, 0xb0, 0x74, 0x3c, 0x80, 0xf6, 0xa, 0x27, 0x2, 0x3c, 0x1, 0x1, 0x3, 0x4, 0x15, 0x2, 0x7, 0x1e, 0x4, 0x3d, 0x15, 0x42, 0x3, 0x1, 0x7a, 0x14, 0xc, 0x14, 0xc, 0x57, 0x9, 0x19, 0x80, 0x87, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x81, 0x24, 0x2, 0x82, 0x32, 0x37, 0x4, 0x32, 0x8, 0x1, 0xe, 0x1, 0x7, 0x84, 0x74, 0x1f, 0x6, 0x6, 0x81, 0x5, 0x3e, 0x80, 0x92, 0x2d, 0xa, 0x7, 0x2, 0xa, 0x4, 0x2, 0x81, 0x40, 0x1e, 0x12, 0x2c, 0x4, 0xa, 0x5, 0x1, 0x81, 0xd0, 0x1c, 0x4, 0xa, 0x82, 0xe6, 0x7, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf, 0x1, 0x80, 0xc5, 0x2, 0x9, 0x30, 0x44, 0x7, 0x1, 0x4, 0xa, 0x4, 0x2, 0x83, 0x11, 0x44, 0x4c, 0x3d, 0x80, 0xc2, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11, 0x34, 0x2, 0x81, 0xe, 0x2c, 0x4, 0x64, 0xc, 0xf, 0x2, 0xf, 0x1, 0xf, 0x1, 0x25, 0xa, 0x80, 0xae, 0x38, 0x1d, 0xd, 0x2c, 0x4, 0x9, 0x7, 0x2, 0xe, 0x6, 0x80, 0x9a, 0x83, 0xd8, 0x4, 0x11, 0x3, 0xd, 0x3, 0x77, 0x4, 0x5f, 0x6, 0xc, 0x4, 0x1, 0xf, 0xc, 0x4, 0x38, 0x8, 0xa, 0x6, 0x28, 0x8, 0x1e, 0x2, 0x2, 0x4e, 0x81, 0x54, 0xc, 0xe, 0x2, 0xd, 0x3, 0x9, 0x7, 0x2e, 0x1, 0x7, 0x8, 0xe, 0x4, 0x9, 0x7, 0x9, 0x7, 0x80, 0x93, 0x1, 0x37, 0x25, 0xa, 0x84, 0x6, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x8c, 0x1f, 0x82, 0x1e, 0x85, 0xe2, 0x93, 0x4b, 0x5, 0x90, 0x60];
_T Uppercase = [0x41, 0x1a, 0x65, 0x17, 0x1, 0x7, 0x21, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x1, 0x3, 0x2, 0x4, 0x1, 0x2, 0x1, 0x3, 0x3, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x3, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x2, 0x1, 0x2, 0x2, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x81, 0x21, 0x1, 0x1, 0x1, 0x3, 0x1, 0x8, 0x1, 0x6, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x11, 0x1, 0x9, 0x23, 0x1, 0x2, 0x3, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x33, 0x30, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x26, 0x8b, 0x49, 0x26, 0x1, 0x1, 0x5, 0x1, 0x82, 0xd2, 0x56, 0x88, 0x9a, 0x2b, 0x2, 0x3, 0x81, 0x40, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x8, 0x8, 0x6, 0xa, 0x8, 0x8, 0x8, 0x8, 0x6, 0xb, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x8, 0x8, 0x48, 0x4, 0xc, 0x4, 0xc, 0x4, 0xc, 0x5, 0xb, 0x4, 0x81, 0x6, 0x1, 0x4, 0x1, 0x3, 0x3, 0x2, 0x3, 0x2, 0x1, 0x3, 0x5, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x2, 0x4, 0xa, 0x2, 0x5, 0x1, 0x1a, 0x10, 0x13, 0x1, 0x83, 0x32, 0x1a, 0x87, 0x30, 0x30, 0x30, 0x1, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x2, 0x1, 0x8, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x8, 0x1, 0x1, 0x1, 0x4, 0x1, 0xa0, 0x79, 0x4d, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x13, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x80, 0x87, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0xa, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x6, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1c, 0x1, 0xa0, 0x57, 0x2b, 0x1a, 0x84, 0xc5, 0x28, 0x80, 0x88, 0x24, 0x80, 0x9c, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x86, 0xea, 0x33, 0x8b, 0xed, 0x20, 0xa0, 0x55, 0x80, 0x20, 0xa0, 0x65, 0xa0, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0x8, 0x1a, 0x1a, 0x1a, 0x2, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1b, 0x2, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1b, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1e, 0x19, 0x21, 0x19, 0x21, 0x19, 0x21, 0x19, 0x21, 0x19, 0x21, 0x1, 0x91, 0x35, 0x22, 0x88, 0xe, 0x1a, 0x6, 0x1a, 0x6, 0x1a];
_T Zl = [0xa0, 0x20, 0x28, 0x1];
_T Hex_Digit = [0x30, 0xa, 0x7, 0x6, 0x1a, 0x6, 0xa0, 0xfe, 0xa9, 0xa, 0x7, 0x6, 0x1a, 0x6];
_T Zp = [0xa0, 0x20, 0x29, 0x1];
_T Pattern_White_Space = [0x9, 0x5, 0x12, 0x1, 0x64, 0x1, 0x9f, 0x88, 0x2, 0x18, 0x2];
_T Diacritic = [0x5e, 0x1, 0x1, 0x1, 0x47, 0x1, 0x6, 0x1, 0x4, 0x1, 0x2, 0x2, 0x81, 0xf7, 0x80, 0x9f, 0x1, 0x8, 0x5, 0x6, 0x11, 0x2, 0x4, 0x1, 0x9, 0x2, 0x80, 0xfd, 0x5, 0x80, 0xd1, 0x1, 0x37, 0x11, 0x1, 0x1b, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x80, 0x86, 0x8, 0x4, 0x2, 0x80, 0x86, 0x2, 0x4, 0x2, 0x3, 0x3, 0x43, 0x1b, 0x5b, 0xb, 0x3a, 0xb, 0x22, 0x2, 0x7e, 0x8, 0x29, 0xa, 0x10, 0x1c, 0x3d, 0x1, 0x10, 0x1, 0x3, 0x4, 0x1c, 0x1, 0x4a, 0x1, 0x10, 0x1, 0x6e, 0x1, 0x10, 0x1, 0x6e, 0x1, 0x10, 0x1, 0x2f, 0x3, 0x3c, 0x1, 0x10, 0x1, 0x7, 0x1, 0x77, 0x1, 0x6e, 0x1, 0x10, 0x1, 0x6e, 0x1, 0x10, 0x1, 0x6d, 0x2, 0x10, 0x1, 0x7c, 0x1, 0x7c, 0x6, 0x1, 0x1, 0x6b, 0x1, 0xd, 0x5, 0x4b, 0x2, 0x1b, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x2, 0x42, 0x3, 0x1, 0x2, 0x3e, 0x1, 0x70, 0x1, 0x1, 0x2, 0x28, 0x2, 0x4, 0x5, 0x19, 0x7, 0x1, 0x1, 0xa, 0x2, 0x82, 0xc1, 0x3, 0x83, 0xb4, 0x2, 0x80, 0xb3, 0xb, 0x9, 0x1, 0x81, 0x5b, 0x3, 0x81, 0x39, 0x8, 0x2, 0x1, 0x30, 0xf, 0x2, 0xb, 0x68, 0x1, 0xf, 0x1, 0x26, 0x9, 0x36, 0x2, 0x80, 0x8a, 0x2, 0x40, 0x6, 0x52, 0x19, 0x4, 0x1, 0x6, 0x1, 0x2, 0x3, 0x32, 0x3f, 0x59, 0xc, 0x25, 0xb, 0x81, 0xbd, 0x1, 0x1, 0x3, 0xb, 0x3, 0xd, 0x3, 0xd, 0x3, 0xd, 0x2, 0x8c, 0xf0, 0x3, 0x81, 0x3d, 0x1, 0x81, 0xfa, 0x6, 0x69, 0x4, 0x5f, 0x1, 0xa0, 0x75, 0x72, 0x1, 0xc, 0x2, 0x1, 0x1, 0x1c, 0x2, 0x52, 0x2, 0xe, 0x22, 0x66, 0x3, 0x6d, 0x2, 0x80, 0xca, 0x1, 0x1b, 0x12, 0x39, 0x4, 0x24, 0x1, 0x5f, 0x1, 0xc, 0x1, 0x24, 0x1, 0x80, 0x95, 0x3, 0x41, 0x4, 0x33, 0x1, 0x64, 0x5, 0x9, 0x3, 0x80, 0x80, 0x2, 0xa0, 0x4f, 0x30, 0x1, 0x83, 0x1, 0x10, 0x81, 0xe, 0x1, 0x1, 0x1, 0x2f, 0x1, 0x2d, 0x2, 0x43, 0x1, 0x82, 0xfc, 0x1, 0x84, 0x9f, 0x6, 0x1, 0x2a, 0x1, 0x9, 0x83, 0x2a, 0x2, 0x82, 0x3b, 0x6, 0x81, 0xd5, 0x3, 0x46, 0xb, 0x31, 0x4, 0x80, 0xc0, 0x1, 0x29, 0x1, 0x48, 0x2, 0x78, 0x2, 0x3e, 0x1, 0x4c, 0x1, 0x9, 0x3, 0x68, 0x2, 0x80, 0xb2, 0x2, 0x51, 0x1, 0x10, 0x1, 0x18, 0x7, 0x3, 0x5, 0x80, 0xcd, 0x1, 0x3, 0x1, 0x7b, 0x2, 0x80, 0xfb, 0x2, 0x7e, 0x1, 0x76, 0x2, 0x73, 0x1, 0x81, 0xd, 0x2, 0x81, 0x2, 0x2, 0x4, 0x1, 0x80, 0x9c, 0x1, 0x53, 0x1, 0x12, 0x1, 0x51, 0x1, 0x81, 0xa5, 0x1, 0x81, 0x2, 0x1, 0x1, 0x2, 0x51, 0x1, 0x96, 0xaf, 0xf, 0xa0, 0x36, 0x9a, 0x5, 0x3b, 0x7, 0x84, 0x58, 0x11, 0x50, 0x2, 0xa0, 0x3f, 0xfe, 0x4, 0x1, 0x7, 0x1, 0x2, 0x9f, 0x1, 0x2e, 0x2, 0x17, 0x82, 0x20, 0x3, 0x3, 0x6, 0x8, 0x8, 0x2, 0x7, 0x1e, 0x4, 0x8e, 0x82, 0x3e, 0x80, 0xc2, 0x7, 0x81, 0x77, 0x1, 0x3d, 0x4, 0x85, 0xe0, 0x7, 0x6d, 0x3, 0x1, 0x3];
_T Lowercase = [0x61, 0x1a, 0x2f, 0x1, 0xa, 0x1, 0x4, 0x1, 0x24, 0x18, 0x1, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x1, 0x3, 0x2, 0x4, 0x1, 0x2, 0x1, 0x3, 0x3, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x6, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x2, 0x1, 0x2, 0x2, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x45, 0x1, 0x24, 0x7, 0x2, 0x1e, 0x5, 0x60, 0x1, 0x2b, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x4, 0x12, 0x1, 0x1b, 0x23, 0x1, 0x2, 0x3, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x1, 0x1, 0x2, 0x1, 0x2, 0x2, 0x33, 0x30, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x30, 0x29, 0x8b, 0x47, 0x2b, 0x1, 0x4, 0x82, 0xf8, 0x6, 0x88, 0x82, 0x9, 0x77, 0x80, 0xc0, 0x41, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x8, 0x6, 0xa, 0x8, 0x8, 0x8, 0x8, 0x6, 0xa, 0x8, 0x8, 0x8, 0x8, 0xe, 0x2, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x5, 0x1, 0x2, 0x6, 0x1, 0x3, 0x3, 0x1, 0x2, 0x8, 0x4, 0x2, 0x2, 0x8, 0x8, 0xa, 0x3, 0x1, 0x2, 0x79, 0x1, 0xd, 0x1, 0x10, 0xd, 0x6d, 0x1, 0x3, 0x2, 0x3, 0x1, 0x1b, 0x1, 0x4, 0x1, 0x4, 0x1, 0x2, 0x2, 0x8, 0x4, 0x4, 0x1, 0x21, 0x10, 0x4, 0x1, 0x83, 0x4b, 0x1a, 0x87, 0x46, 0x30, 0x1, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x2, 0x1, 0x8, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xc, 0x26, 0x1, 0x1, 0x5, 0x1, 0xa0, 0x79, 0x13, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x13, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x80, 0x85, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0xa, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x18, 0x3, 0x1, 0x1, 0x1, 0x3, 0x83, 0x35, 0x2b, 0x1, 0xe, 0x6, 0x50, 0xa0, 0x4f, 0x40, 0x7, 0xc, 0x5, 0x84, 0x29, 0x1a, 0x84, 0xcd, 0x28, 0x80, 0x88, 0x24, 0x80, 0x9b, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x81, 0xc3, 0x1, 0x2, 0x3, 0x1, 0x2a, 0x1, 0x9, 0x85, 0x5, 0x33, 0x8b, 0xcd, 0x20, 0xa0, 0x55, 0x80, 0x20, 0xa0, 0x65, 0x9a, 0x1a, 0x1a, 0x7, 0x1, 0x12, 0x1a, 0x1a, 0x1a, 0x4, 0x1, 0x1, 0x1, 0x7, 0x1, 0xb, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1c, 0x1c, 0x19, 0x1, 0x6, 0x1a, 0x19, 0x1, 0x6, 0x1a, 0x19, 0x1, 0x6, 0x1a, 0x19, 0x1, 0x6, 0x1a, 0x19, 0x1, 0x6, 0x1, 0x1, 0x87, 0x34, 0xa, 0x1, 0x14, 0x6, 0x6, 0x81, 0x5, 0x3e, 0x88, 0xb4, 0x22];
_T Ll = [0x61, 0x1a, 0x3a, 0x1, 0x29, 0x18, 0x1, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x1, 0x3, 0x2, 0x4, 0x1, 0x2, 0x1, 0x3, 0x3, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x6, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x2, 0x1, 0x2, 0x2, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x45, 0x1, 0x1b, 0x80, 0xc1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x3, 0x3, 0x12, 0x1, 0x1b, 0x23, 0x1, 0x2, 0x3, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x1, 0x1, 0x2, 0x1, 0x2, 0x2, 0x33, 0x30, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x30, 0x29, 0x8b, 0x47, 0x2b, 0x2, 0x3, 0x82, 0xf8, 0x6, 0x88, 0x82, 0x9, 0x77, 0x2c, 0x3f, 0xd, 0x1, 0x22, 0x66, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x9, 0x8, 0x6, 0xa, 0x8, 0x8, 0x8, 0x8, 0x6, 0xa, 0x8, 0x8, 0x8, 0x8, 0xe, 0x2, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x5, 0x1, 0x2, 0x6, 0x1, 0x3, 0x3, 0x1, 0x2, 0x8, 0x4, 0x2, 0x2, 0x8, 0x8, 0xa, 0x3, 0x1, 0x2, 0x81, 0x12, 0x1, 0x3, 0x2, 0x3, 0x1, 0x1b, 0x1, 0x4, 0x1, 0x4, 0x1, 0x2, 0x2, 0x8, 0x4, 0x4, 0x1, 0x35, 0x1, 0x8a, 0xab, 0x30, 0x1, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x2, 0x1, 0x6, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xc, 0x26, 0x1, 0x1, 0x5, 0x1, 0xa0, 0x79, 0x13, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x13, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x80, 0x87, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x8, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1c, 0x1, 0x3, 0x1, 0x83, 0x35, 0x2b, 0x5, 0x9, 0x7, 0x50, 0xa0, 0x4f, 0x40, 0x7, 0xc, 0x5, 0x84, 0x29, 0x1a, 0x84, 0xcd, 0x28, 0x80, 0x88, 0x24, 0x80, 0x9b, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x87, 0x3, 0x33, 0x8b, 0xcd, 0x20, 0xa0, 0x55, 0x80, 0x20, 0xa0, 0x65, 0x9a, 0x1a, 0x1a, 0x7, 0x1, 0x12, 0x1a, 0x1a, 0x1a, 0x4, 0x1, 0x1, 0x1, 0x7, 0x1, 0xb, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1c, 0x1c, 0x19, 0x1, 0x6, 0x1a, 0x19, 0x1, 0x6, 0x1a, 0x19, 0x1, 0x6, 0x1a, 0x19, 0x1, 0x6, 0x1a, 0x19, 0x1, 0x6, 0x1, 0x1, 0x87, 0x34, 0xa, 0x1, 0x14, 0x6, 0x6, 0x89, 0xf7, 0x22];
_T Extender = [0x80, 0xb7, 0x1, 0x82, 0x18, 0x2, 0x83, 0x6e, 0x1, 0x81, 0xb9, 0x1, 0x83, 0x5a, 0x1, 0x82, 0xf0, 0x1, 0x7f, 0x1, 0x89, 0x43, 0x1, 0x38, 0x1, 0x82, 0x63, 0x1, 0x81, 0x8e, 0x1, 0x44, 0x1, 0x93, 0x89, 0x1, 0x2b, 0x5, 0x67, 0x2, 0x5d, 0x3, 0xa0, 0x6f, 0x16, 0x1, 0x85, 0xf6, 0x1, 0x83, 0xc2, 0x1, 0x16, 0x1, 0x80, 0x89, 0x1, 0x6c, 0x1, 0x15, 0x2, 0xa0, 0x54, 0x7b, 0x1, 0x88, 0x10, 0x2, 0x8b, 0xda, 0x1, 0x82, 0x68, 0x3, 0x84, 0xcf, 0x1, 0xa0, 0x50, 0xa9, 0x2, 0x84, 0x9c, 0x2, 0x1, 0x1, 0xa0, 0x71, 0x58, 0x2, 0x88, 0x6, 0x3];
_T Lm = [0x82, 0xb0, 0x12, 0x4, 0xc, 0xe, 0x5, 0x7, 0x1, 0x1, 0x1, 0x80, 0x85, 0x1, 0x5, 0x1, 0x81, 0xde, 0x1, 0x80, 0xe6, 0x1, 0x80, 0xa4, 0x2, 0x81, 0xd, 0x2, 0x4, 0x1, 0x1f, 0x1, 0x9, 0x1, 0x3, 0x1, 0x80, 0xa0, 0x1, 0x80, 0xa7, 0x1, 0x84, 0xd4, 0x1, 0x7f, 0x1, 0x82, 0x35, 0x1, 0x86, 0xda, 0x1, 0x6b, 0x1, 0x82, 0x63, 0x1, 0x81, 0xd0, 0x6, 0x80, 0xae, 0x3f, 0xd, 0x1, 0x22, 0x25, 0x82, 0xb1, 0x1, 0xd, 0x1, 0x10, 0xd, 0x8b, 0xdf, 0x2, 0x80, 0xf1, 0x1, 0x80, 0xbf, 0x1, 0x81, 0xd5, 0x1, 0x2b, 0x5, 0x5, 0x1, 0x61, 0x2, 0x5d, 0x3, 0xa0, 0x6f, 0x16, 0x1, 0x84, 0xe2, 0x6, 0x81, 0xe, 0x1, 0x72, 0x1, 0x1c, 0x2, 0x79, 0x9, 0x50, 0x1, 0x17, 0x1, 0x69, 0x3, 0x3, 0x2, 0x81, 0xd5, 0x1, 0x16, 0x1, 0x80, 0x89, 0x1, 0x6c, 0x1, 0x15, 0x2, 0x67, 0x4, 0x9, 0x1, 0xa0, 0x54, 0x6, 0x1, 0x2d, 0x2, 0x87, 0xe0, 0x6, 0x1, 0x2a, 0x1, 0x9, 0xa0, 0x63, 0x85, 0x4, 0x84, 0x4f, 0xd, 0x40, 0x2, 0x1, 0x1, 0xa0, 0x40, 0xc, 0x4, 0x1, 0x7, 0x1, 0x2, 0xa0, 0x30, 0x31, 0x3e, 0x80, 0xc9, 0x7, 0x83, 0xad, 0x1, 0x84, 0x5f, 0x1];
_T Mn = [0x83, 0x0, 0x70, 0x81, 0x13, 0x5, 0x81, 0x9, 0x2d, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x48, 0xb, 0x30, 0x15, 0x10, 0x1, 0x65, 0x7, 0x2, 0x6, 0x2, 0x2, 0x1, 0x4, 0x23, 0x1, 0x1e, 0x1b, 0x5b, 0xb, 0x3a, 0x9, 0x9, 0x1, 0x18, 0x4, 0x1, 0x9, 0x1, 0x3, 0x1, 0x5, 0x2b, 0x3, 0x3c, 0x8, 0x2a, 0x18, 0x1, 0x20, 0x37, 0x1, 0x1, 0x1, 0x4, 0x8, 0x4, 0x1, 0x3, 0x7, 0xa, 0x2, 0x1d, 0x1, 0x3a, 0x1, 0x4, 0x4, 0x8, 0x1, 0x14, 0x2, 0x1a, 0x1, 0x2, 0x2, 0x39, 0x1, 0x4, 0x2, 0x4, 0x2, 0x2, 0x3, 0x3, 0x1, 0x1e, 0x2, 0x3, 0x1, 0xb, 0x2, 0x39, 0x1, 0x4, 0x5, 0x1, 0x2, 0x4, 0x1, 0x14, 0x2, 0x16, 0x6, 0x1, 0x1, 0x3a, 0x1, 0x2, 0x1, 0x1, 0x4, 0x8, 0x1, 0x7, 0x2, 0xb, 0x2, 0x1e, 0x1, 0x3d, 0x1, 0xc, 0x1, 0x32, 0x1, 0x3, 0x1, 0x37, 0x1, 0x1, 0x3, 0x5, 0x3, 0x1, 0x4, 0x7, 0x2, 0xb, 0x2, 0x1d, 0x1, 0x3a, 0x1, 0x2, 0x1, 0x6, 0x1, 0x5, 0x2, 0x14, 0x2, 0x1c, 0x2, 0x39, 0x2, 0x4, 0x4, 0x8, 0x1, 0x14, 0x2, 0x1d, 0x1, 0x48, 0x1, 0x7, 0x3, 0x1, 0x1, 0x5a, 0x1, 0x2, 0x7, 0xc, 0x8, 0x62, 0x1, 0x2, 0x9, 0xb, 0x7, 0x49, 0x2, 0x1b, 0x1, 0x1, 0x1, 0x1, 0x1, 0x37, 0xe, 0x1, 0x5, 0x1, 0x2, 0x5, 0xb, 0x1, 0x24, 0x9, 0x1, 0x66, 0x4, 0x1, 0x6, 0x1, 0x2, 0x2, 0x2, 0x19, 0x2, 0x4, 0x3, 0x10, 0x4, 0xd, 0x1, 0x2, 0x2, 0x6, 0x1, 0xf, 0x1, 0x82, 0xbf, 0x3, 0x83, 0xb2, 0x3, 0x1d, 0x2, 0x1e, 0x2, 0x1e, 0x2, 0x40, 0x2, 0x1, 0x7, 0x8, 0x1, 0x2, 0xb, 0x9, 0x1, 0x2d, 0x3, 0x1, 0x1, 0x75, 0x2, 0x22, 0x1, 0x76, 0x3, 0x4, 0x2, 0x9, 0x1, 0x6, 0x3, 0x80, 0xdb, 0x2, 0x2, 0x1, 0x3a, 0x1, 0x1, 0x7, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0x6, 0xa, 0x2, 0x1, 0x30, 0xe, 0x1, 0x10, 0x31, 0x4, 0x30, 0x1, 0x1, 0x5, 0x1, 0x1, 0x5, 0x1, 0x28, 0x9, 0xc, 0x2, 0x20, 0x4, 0x2, 0x2, 0x1, 0x3, 0x38, 0x1, 0x1, 0x2, 0x3, 0x1, 0x1, 0x3, 0x3a, 0x8, 0x2, 0x2, 0x80, 0x98, 0x3, 0x1, 0xd, 0x1, 0x7, 0x4, 0x1, 0x6, 0x1, 0x3, 0x2, 0x80, 0xc6, 0x40, 0x82, 0xd0, 0xd, 0x4, 0x1, 0x3, 0xc, 0x8b, 0xfe, 0x3, 0x80, 0x8d, 0x1, 0x60, 0x20, 0x82, 0x2a, 0x4, 0x6b, 0x2, 0xa0, 0x75, 0xd4, 0x1, 0x4, 0xa, 0x20, 0x2, 0x50, 0x2, 0x81, 0x10, 0x1, 0x3, 0x1, 0x4, 0x1, 0x19, 0x2, 0x5, 0x1, 0x80, 0x97, 0x2, 0x1a, 0x12, 0xd, 0x1, 0x26, 0x8, 0x19, 0xb, 0x2e, 0x3, 0x30, 0x1, 0x2, 0x4, 0x2, 0x2, 0x27, 0x1, 0x43, 0x6, 0x2, 0x2, 0x2, 0x2, 0xc, 0x1, 0x8, 0x1, 0x2f, 0x1, 0x33, 0x1, 0x1, 0x3, 0x2, 0x2, 0x5, 0x2, 0x1, 0x1, 0x2a, 0x2, 0x8, 0x1, 0x80, 0xee, 0x1, 0x2, 0x1, 0x4, 0x1, 0xa0, 0x4f, 0x30, 0x1, 0x82, 0xe1, 0x10, 0x10, 0x10, 0x83, 0xcd, 0x1, 0x80, 0xe2, 0x1, 0x80, 0x95, 0x5, 0x86, 0x86, 0x3, 0x1, 0x2, 0x5, 0x4, 0x28, 0x3, 0x4, 0x1, 0x80, 0xa5, 0x2, 0x82, 0x3d, 0x4, 0x81, 0x83, 0x2, 0x50, 0x3, 0x46, 0xb, 0x31, 0x4, 0x7b, 0x1, 0x36, 0xf, 0x29, 0x1, 0x2, 0x2, 0xa, 0x3, 0x31, 0x4, 0x2, 0x2, 0x7, 0x1, 0x3d, 0x3, 0x24, 0x5, 0x1, 0x8, 0x3e, 0x1, 0xc, 0x2, 0x34, 0x9, 0xa, 0x4, 0x2, 0x1, 0x5f, 0x3, 0x2, 0x1, 0x1, 0x2, 0x6, 0x1, 0x2, 0x1, 0x80, 0x9d, 0x1, 0x3, 0x8, 0x15, 0x2, 0x39, 0x2, 0x3, 0x1, 0x25, 0x7, 0x3, 0x5, 0x80, 0xc3, 0x8, 0x2, 0x3, 0x1, 0x1, 0x17, 0x1, 0x54, 0x6, 0x1, 0x1, 0x4, 0x2, 0x1, 0x2, 0x80, 0xee, 0x4, 0x6, 0x2, 0x1, 0x2, 0x1b, 0x2, 0x55, 0x8, 0x2, 0x1, 0x1, 0x2, 0x6a, 0x1, 0x1, 0x1, 0x2, 0x6, 0x1, 0x1, 0x65, 0x3, 0x2, 0x4, 0x1, 0x5, 0x81, 0x3, 0x9, 0x1, 0x2, 0x81, 0x0, 0x2, 0x1, 0x1, 0x4, 0x1, 0x80, 0x90, 0x4, 0x2, 0x2, 0x4, 0x1, 0x20, 0xa, 0x28, 0x6, 0x2, 0x4, 0x8, 0x1, 0x9, 0x6, 0x2, 0x3, 0x2e, 0xd, 0x1, 0x2, 0x81, 0x96, 0x7, 0x1, 0x6, 0x1, 0x1, 0x52, 0x16, 0x2, 0x7, 0x1, 0x2, 0x1, 0x2, 0x7a, 0x6, 0x3, 0x1, 0x1, 0x2, 0x1, 0x7, 0x1, 0x1, 0x48, 0x2, 0x3, 0x1, 0x1, 0x1, 0x81, 0x5b, 0x2, 0xb, 0x2, 0x34, 0x5, 0x5, 0x1, 0x1, 0x1, 0x94, 0xfd, 0x1, 0x6, 0xf, 0xa0, 0x36, 0x9a, 0x5, 0x3b, 0x7, 0x84, 0x18, 0x1, 0x3f, 0x4, 0x51, 0x1, 0xa0, 0x4c, 0xb8, 0x2, 0x92, 0x61, 0x2e, 0x2, 0x17, 0x82, 0x20, 0x3, 0x11, 0x8, 0x2, 0x7, 0x1e, 0x4, 0x80, 0x94, 0x3, 0x87, 0xbb, 0x37, 0x4, 0x32, 0x8, 0x1, 0xe, 0x1, 0x16, 0x5, 0x1, 0xf, 0x85, 0x50, 0x7, 0x1, 0x11, 0x2, 0x7, 0x1, 0x2, 0x1, 0x5, 0x64, 0x1, 0x80, 0xa0, 0x7, 0x81, 0x77, 0x1, 0x3d, 0x4, 0x81, 0xfc, 0x4, 0x83, 0xe0, 0x7, 0x6d, 0x7, 0xac, 0x17, 0xb5, 0x80, 0xf0];
_T Sk = [0x5e, 0x1, 0x1, 0x1, 0x47, 0x1, 0x6, 0x1, 0x4, 0x1, 0x3, 0x1, 0x82, 0x9, 0x4, 0xc, 0xe, 0x5, 0x7, 0x1, 0x1, 0x1, 0x11, 0x75, 0x1, 0xe, 0x2, 0x85, 0x2, 0x1, 0x97, 0x34, 0x1, 0x1, 0x3, 0xb, 0x3, 0xd, 0x3, 0xd, 0x3, 0xd, 0x2, 0x90, 0x9c, 0x2, 0xa0, 0x76, 0x63, 0x17, 0x9, 0x2, 0x67, 0x2, 0x83, 0xd0, 0x1, 0xe, 0x2, 0xa0, 0x50, 0x46, 0x11, 0x83, 0x7b, 0x1, 0x1, 0x1, 0x80, 0xa2, 0x1, 0xa0, 0xf4, 0x17, 0x5];
_T Po = [0x21, 0x3, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x1, 0x2, 0xa, 0x2, 0x3, 0x2, 0x1b, 0x1, 0x44, 0x1, 0x5, 0x1, 0xe, 0x2, 0x7, 0x1, 0x82, 0xbe, 0x1, 0x8, 0x1, 0x81, 0xd2, 0x6, 0x29, 0x1, 0x36, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2c, 0x2, 0x14, 0x2, 0x1, 0x2, 0xd, 0x1, 0x1, 0x3, 0x4a, 0x4, 0x66, 0x1, 0x2b, 0xe, 0x80, 0xe9, 0x3, 0x36, 0xf, 0x1f, 0x1, 0x81, 0x5, 0x2, 0xa, 0x1, 0x80, 0x8c, 0x1, 0x78, 0x1, 0x79, 0x1, 0x81, 0x86, 0x1, 0xc, 0x1, 0x81, 0x6f, 0x1, 0x5a, 0x1, 0xa, 0x2, 0x80, 0xa8, 0xf, 0x1, 0x1, 0x70, 0x1, 0x4a, 0x5, 0x4, 0x2, 0x6f, 0x6, 0x80, 0xab, 0x1, 0x82, 0x64, 0x9, 0x83, 0x5, 0x1, 0x7c, 0x3, 0x47, 0x2, 0x80, 0x9d, 0x3, 0x1, 0x3, 0x25, 0x6, 0x1, 0x4, 0x81, 0x39, 0x2, 0x80, 0xd8, 0x2, 0x80, 0x80, 0x7, 0x1, 0x6, 0x80, 0xac, 0x7, 0x1c, 0x2, 0x7d, 0x4, 0x3b, 0x5, 0x3e, 0x2, 0x40, 0x8, 0xb, 0x1, 0x83, 0x42, 0x2, 0x8, 0x8, 0x8, 0x9, 0x2, 0x4, 0x2, 0x3, 0x3, 0xb, 0x1, 0x1, 0x1, 0xa, 0x8c, 0x9a, 0x4, 0x1, 0x2, 0x70, 0x1, 0x80, 0x8f, 0x2, 0x4, 0x3, 0x2, 0x1, 0x2, 0x9, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0xa, 0x5, 0x1, 0xa, 0x2, 0x4, 0x1, 0x1, 0x1, 0xd, 0x2, 0x3, 0x81, 0xac, 0x3, 0x39, 0x1, 0x80, 0xbd, 0x1, 0xa0, 0x74, 0x2, 0x2, 0x81, 0xd, 0x3, 0x63, 0x1, 0xa, 0x1, 0x73, 0x6, 0x81, 0x7c, 0x4, 0x56, 0x2, 0x28, 0x3, 0x1, 0x1, 0x31, 0x2, 0x2f, 0x1, 0x61, 0xd, 0x10, 0x2, 0x7c, 0x4, 0x7e, 0x2, 0x10, 0x2, 0x80, 0xf9, 0x1, 0xa0, 0x52, 0x24, 0x7, 0x2, 0x1, 0x16, 0x1, 0x14, 0x2, 0x2, 0x4, 0x3, 0x3, 0x1, 0x4, 0x7, 0x3, 0x6, 0x1, 0x1, 0x2, 0x80, 0x95, 0x3, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x1, 0x2, 0xa, 0x2, 0x3, 0x2, 0x1b, 0x1, 0x24, 0x1, 0x2, 0x2, 0x81, 0x9a, 0x3, 0x82, 0x9c, 0x1, 0x30, 0x1, 0x81, 0x9e, 0x1, 0x82, 0xe7, 0x1, 0x80, 0xc7, 0x1, 0x1f, 0x1, 0x81, 0x10, 0x9, 0x26, 0x1, 0x70, 0x7, 0x42, 0x7, 0x59, 0x4, 0x83, 0xb8, 0x5, 0x2c, 0x4, 0x80, 0xbd, 0x7, 0x6d, 0x2, 0x1, 0x4, 0x7e, 0x4, 0x30, 0x2, 0x4f, 0x4, 0x4, 0x1, 0xd, 0x1, 0x1, 0x3, 0x58, 0x6, 0x6b, 0x1, 0x81, 0xa1, 0x5, 0xa, 0x2, 0x1, 0x1, 0x68, 0x1, 0x80, 0xfa, 0x17, 0x69, 0x3, 0x1c, 0xd, 0x4c, 0x1, 0x80, 0x82, 0x3, 0x80, 0xfc, 0x1, 0x81, 0x8, 0x3, 0x80, 0x9b, 0x1, 0x5c, 0x8, 0x53, 0x3, 0x1, 0x5, 0x5d, 0xa, 0x81, 0x37, 0x5, 0x2a, 0x2, 0x82, 0x85, 0x2, 0x4a, 0xd, 0x80, 0xaf, 0x1, 0x84, 0x70, 0x5, 0x8b, 0x7c, 0x2, 0xa0, 0x3a, 0x7b, 0x2, 0x80, 0x85, 0x1, 0x41, 0x5, 0x8, 0x1, 0x83, 0x52, 0x4, 0x81, 0x47, 0x1, 0xa0, 0x4c, 0xbc, 0x1, 0x9d, 0xe7, 0x5, 0x8e, 0xd2, 0x2];
_T Deprecated = [0x81, 0x49, 0x1, 0x85, 0x29, 0x1, 0x89, 0x3, 0x1, 0x1, 0x1, 0x88, 0x29, 0x2, 0x88, 0xc5, 0x6, 0x82, 0xb9, 0x2, 0xad, 0xdc, 0xd6, 0x1];
_T Other_ID_Continue = [0x80, 0xb7, 0x1, 0x82, 0xcf, 0x1, 0x8f, 0xe1, 0x9, 0x86, 0x68, 0x1];
_U[] _tab = [
_U("Alphabetic", Alphabetic),
_U("ASCII_Hex_Digit", ASCII_Hex_Digit),
_U("Bidi_Control", Bidi_Control),
_U("Cased", Cased),
_U("Case_Ignorable", Case_Ignorable),
_U("Cc", Cc),
_U("Cf", Cf),
_U("Close_Punctuation", Pe),
_U("Cn", Cn),
_U("Co", Co),
_U("Connector_Punctuation", Pc),
_U("Control", Cc),
_U("Cs", Cs),
_U("Currency_Symbol", Sc),
_U("Dash", Dash),
_U("Dash_Punctuation", Pd),
_U("Decimal_Number", Nd),
_U("Default_Ignorable_Code_Point", Default_Ignorable_Code_Point),
_U("Deprecated", Deprecated),
_U("Diacritic", Diacritic),
_U("Enclosing_Mark", Me),
_U("Extender", Extender),
_U("Final_Punctuation", Pf),
_U("Format", Cf),
_U("Grapheme_Base", Grapheme_Base),
_U("Grapheme_Extend", Grapheme_Extend),
_U("Grapheme_Link", Grapheme_Link),
_U("Hex_Digit", Hex_Digit),
_U("Hyphen", Hyphen),
_U("ID_Continue", ID_Continue),
_U("Ideographic", Ideographic),
_U("IDS_Binary_Operator", IDS_Binary_Operator),
_U("ID_Start", ID_Start),
_U("IDS_Trinary_Operator", IDS_Trinary_Operator),
_U("Initial_Punctuation", Pi),
_U("Join_Control", Join_Control),
_U("Letter_Number", Nl),
_U("Line_Separator", Zl),
_U("Ll", Ll),
_U("Lm", Lm),
_U("Lo", Lo),
_U("Logical_Order_Exception", Logical_Order_Exception),
_U("Lowercase", Lowercase),
_U("Lowercase_Letter", Ll),
_U("Lt", Lt),
_U("Lu", Lu),
_U("Math", Math),
_U("Math_Symbol", Sm),
_U("Mc", Mc),
_U("Me", Me),
_U("Mn", Mn),
_U("Modifier_Letter", Lm),
_U("Modifier_Symbol", Sk),
_U("Nd", Nd),
_U("Nl", Nl),
_U("No", No),
_U("Noncharacter_Code_Point", Noncharacter_Code_Point),
_U("Nonspacing_Mark", Mn),
_U("Open_Punctuation", Ps),
_U("Other_Alphabetic", Other_Alphabetic),
_U("Other_Default_Ignorable_Code_Point", Other_Default_Ignorable_Code_Point),
_U("Other_Grapheme_Extend", Other_Grapheme_Extend),
_U("Other_ID_Continue", Other_ID_Continue),
_U("Other_ID_Start", Other_ID_Start),
_U("Other_Letter", Lo),
_U("Other_Lowercase", Other_Lowercase),
_U("Other_Math", Other_Math),
_U("Other_Number", No),
_U("Other_Punctuation", Po),
_U("Other_Symbol", So),
_U("Other_Uppercase", Other_Uppercase),
_U("Paragraph_Separator", Zp),
_U("Pattern_Syntax", Pattern_Syntax),
_U("Pattern_White_Space", Pattern_White_Space),
_U("Pc", Pc),
_U("Pd", Pd),
_U("Pe", Pe),
_U("Pf", Pf),
_U("Pi", Pi),
_U("Po", Po),
_U("Prepended_Concatenation_Mark", Prepended_Concatenation_Mark),
_U("Private_Use", Co),
_U("Ps", Ps),
_U("Quotation_Mark", Quotation_Mark),
_U("Radical", Radical),
_U("Regional_Indicator", Regional_Indicator),
_U("Sc", Sc),
_U("Sentence_Terminal", Sentence_Terminal),
_U("Sk", Sk),
_U("Sm", Sm),
_U("So", So),
_U("Soft_Dotted", Soft_Dotted),
_U("Space_Separator", Zs),
_U("Spacing_Mark", Mc),
_U("Surrogate", Cs),
_U("Terminal_Punctuation", Terminal_Punctuation),
_U("Titlecase_Letter", Lt),
_U("Unassigned", Cn),
_U("Unified_Ideograph", Unified_Ideograph),
_U("Uppercase", Uppercase),
_U("Uppercase_Letter", Lu),
_U("Variation_Selector", Variation_Selector),
_U("White_Space", White_Space),
_U("XID_Continue", XID_Continue),
_U("XID_Start", XID_Start),
_U("Zl", Zl),
_U("Zp", Zp),
_U("Zs", Zs),
];
}

struct blocks
{
private alias _U = immutable(UnicodeProperty);
@property static _U[] tab() pure { return _tab; }
static immutable:
private alias _T = ubyte[];
_T CJK_Unified_Ideographs_Extension_G = [0xa3, 0x0, 0x0, 0x93, 0x50];
_T Tai_Le = [0x99, 0x50, 0x30];
_T Coptic = [0xa0, 0x2c, 0x80, 0x80, 0x80];
_T Halfwidth_and_Fullwidth_Forms = [0xa0, 0xff, 0x0, 0x80, 0xf0];
_T Cyrillic = [0x84, 0x0, 0x81, 0x0];
_T CJK_Radicals_Supplement = [0xa0, 0x2e, 0x80, 0x80, 0x80];
_T Thaana = [0x87, 0x80, 0x40];
_T Specials = [0xa0, 0xff, 0xf0, 0x10];
_T Hangul_Jamo_Extended_B = [0xa0, 0xd7, 0xb0, 0x50];
_T Linear_B_Syllabary = [0xa1, 0x0, 0x0, 0x80, 0x80];
_T Ogham = [0x96, 0x80, 0x20];
_T Arabic_Extended_C = [0xa1, 0xe, 0xc0, 0x40];
_T Nabataean = [0xa1, 0x8, 0x80, 0x30];
_T Makasar = [0xa1, 0x1e, 0xe0, 0x20];
_T CJK_Unified_Ideographs_Extension_B = [0xa2, 0x0, 0x0, 0xa0, 0xa6, 0xe0];
_T Siddham = [0xa1, 0x15, 0x80, 0x80, 0x80];
_T Kana_Extended_A = [0xa1, 0xb1, 0x0, 0x30];
_T Supplemental_Arrows_C = [0xa1, 0xf8, 0x0, 0x81, 0x0];
_T Kaktovik_Numerals = [0xa1, 0xd2, 0xc0, 0x20];
_T Combining_Diacritical_Marks = [0x83, 0x0, 0x70];
_T Vertical_Forms = [0xa0, 0xfe, 0x10, 0x10];
_T Old_Sogdian = [0xa1, 0xf, 0x0, 0x30];
_T Old_South_Arabian = [0xa1, 0xa, 0x60, 0x20];
_T Cyrillic_Extended_C = [0x9c, 0x80, 0x10];
_T Myanmar = [0x90, 0x0, 0x80, 0xa0];
_T Bassa_Vah = [0xa1, 0x6a, 0xd0, 0x30];
_T Deseret = [0xa1, 0x4, 0x0, 0x50];
_T Phaistos_Disc = [0xa1, 0x1, 0xd0, 0x30];
_T Common_Indic_Number_Forms = [0xa0, 0xa8, 0x30, 0x10];
_T Unified_Canadian_Aboriginal_Syllabics_Extended = [0x98, 0xb0, 0x50];
_T Kaithi = [0xa1, 0x10, 0x80, 0x50];
_T Medefaidrin = [0xa1, 0x6e, 0x40, 0x60];
_T Arabic_Supplement = [0x87, 0x50, 0x30];
_T Yi_Radicals = [0xa0, 0xa4, 0x90, 0x40];
_T Tai_Tham = [0x9a, 0x20, 0x80, 0x90];
_T Hiragana = [0xa0, 0x30, 0x40, 0x60];
_T Hangul_Compatibility_Jamo = [0xa0, 0x31, 0x30, 0x60];
_T Linear_B_Ideograms = [0xa1, 0x0, 0x80, 0x80, 0x80];
_T Syriac_Supplement = [0x88, 0x60, 0x10];
_T Ahom = [0xa1, 0x17, 0x0, 0x50];
_T Shorthand_Format_Controls = [0xa1, 0xbc, 0xa0, 0x10];
_T Phonetic_Extensions = [0x9d, 0x0, 0x80, 0x80];
_T Nag_Mundari = [0xa1, 0xe4, 0xd0, 0x30];
_T Devanagari = [0x89, 0x0, 0x80, 0x80];
_T Tibetan = [0x8f, 0x0, 0x81, 0x0];
_T Hanifi_Rohingya = [0xa1, 0xd, 0x0, 0x40];
_T Old_Uyghur = [0xa1, 0xf, 0x70, 0x40];
_T Enclosed_Ideographic_Supplement = [0xa1, 0xf2, 0x0, 0x81, 0x0];
_T Brahmi = [0xa1, 0x10, 0x0, 0x80, 0x80];
_T Number_Forms = [0xa0, 0x21, 0x50, 0x40];
_T Mayan_Numerals = [0xa1, 0xd2, 0xe0, 0x20];
_T Ornamental_Dingbats = [0xa1, 0xf6, 0x50, 0x30];
_T Symbols_for_Legacy_Computing = [0xa1, 0xfb, 0x0, 0x81, 0x0];
_T Unified_Canadian_Aboriginal_Syllabics_Extended_A = [0xa1, 0x1a, 0xb0, 0x10];
_T Greek_and_Coptic = [0x83, 0x70, 0x80, 0x90];
_T Counting_Rod_Numerals = [0xa1, 0xd3, 0x60, 0x20];
_T Ethiopic_Extended_B = [0xa1, 0xe7, 0xe0, 0x20];
_T Supplemental_Mathematical_Operators = [0xa0, 0x2a, 0x0, 0x81, 0x0];
_T Osage = [0xa1, 0x4, 0xb0, 0x50];
_T Nushu = [0xa1, 0xb1, 0x70, 0x81, 0x90];
_T Chess_Symbols = [0xa1, 0xfa, 0x0, 0x70];
_T Cuneiform = [0xa1, 0x20, 0x0, 0x84, 0x0];
_T Takri = [0xa1, 0x16, 0x80, 0x50];
_T Enclosed_Alphanumeric_Supplement = [0xa1, 0xf1, 0x0, 0x81, 0x0];
_T Sutton_SignWriting = [0xa1, 0xd8, 0x0, 0x82, 0xb0];
_T Miscellaneous_Technical = [0xa0, 0x23, 0x0, 0x81, 0x0];
_T Old_Italic = [0xa1, 0x3, 0x0, 0x30];
_T Toto = [0xa1, 0xe2, 0x90, 0x30];
_T Hanunoo = [0x97, 0x20, 0x20];
_T Lisu = [0xa0, 0xa4, 0xd0, 0x30];
_T Limbu = [0x99, 0x0, 0x50];
_T Saurashtra = [0xa0, 0xa8, 0x80, 0x60];
_T Elbasan = [0xa1, 0x5, 0x0, 0x30];
_T Variation_Selectors_Supplement = [0xae, 0x1, 0x0, 0x80, 0xf0];
_T Psalter_Pahlavi = [0xa1, 0xb, 0x80, 0x30];
_T Palmyrene = [0xa1, 0x8, 0x60, 0x20];
_T Tagbanwa = [0x97, 0x60, 0x20];
_T CJK_Unified_Ideographs_Extension_F = [0xa2, 0xce, 0xb0, 0x9d, 0x40];
_T Combining_Diacritical_Marks_for_Symbols = [0xa0, 0x20, 0xd0, 0x30];
_T Dingbats = [0xa0, 0x27, 0x0, 0x80, 0xc0];
_T Nyiakeng_Puachue_Hmong = [0xa1, 0xe1, 0x0, 0x50];
_T Combining_Half_Marks = [0xa0, 0xfe, 0x20, 0x10];
_T Supplementary_Private_Use_Area_A = [0xaf, 0x0, 0x0, 0xa1, 0x0, 0x0];
_T Playing_Cards = [0xa1, 0xf0, 0xa0, 0x60];
_T Malayalam = [0x8d, 0x0, 0x80, 0x80];
_T Indic_Siyaq_Numbers = [0xa1, 0xec, 0x70, 0x50];
_T Variation_Selectors = [0xa0, 0xfe, 0x0, 0x10];
_T Thai = [0x8e, 0x0, 0x80, 0x80];
_T Supplemental_Arrows_B = [0xa0, 0x29, 0x0, 0x80, 0x80];
_T Zanabazar_Square = [0xa1, 0x1a, 0x0, 0x50];
_T Ideographic_Symbols_and_Punctuation = [0xa1, 0x6f, 0xe0, 0x20];
_T Symbols_and_Pictographs_Extended_A = [0xa1, 0xfa, 0x70, 0x80, 0x90];
_T High_Private_Use_Surrogates = [0xa0, 0xdb, 0x80, 0x80, 0x80];
_T Modifier_Tone_Letters = [0xa0, 0xa7, 0x0, 0x20];
_T Samaritan = [0x88, 0x0, 0x40];
_T Egyptian_Hieroglyph_Format_Controls = [0xa1, 0x34, 0x30, 0x30];
_T Latin_Extended_Additional = [0x9e, 0x0, 0x81, 0x0];
_T Coptic_Epact_Numbers = [0xa1, 0x2, 0xe0, 0x20];
_T Small_Form_Variants = [0xa0, 0xfe, 0x50, 0x20];
_T Balinese = [0x9b, 0x0, 0x80, 0x80];
_T Mandaic = [0x88, 0x40, 0x20];
_T Block_Elements = [0xa0, 0x25, 0x80, 0x20];
_T Supplemental_Symbols_and_Pictographs = [0xa1, 0xf9, 0x0, 0x81, 0x0];
_T Miscellaneous_Mathematical_Symbols_A = [0xa0, 0x27, 0xc0, 0x30];
_T Tifinagh = [0xa0, 0x2d, 0x30, 0x50];
_T Arabic_Extended_A = [0x88, 0xa0, 0x60];
_T Cyrillic_Extended_A = [0xa0, 0x2d, 0xe0, 0x20];
_T Syriac = [0x87, 0x0, 0x50];
_T Latin_Extended_E = [0xa0, 0xab, 0x30, 0x40];
_T Caucasian_Albanian = [0xa1, 0x5, 0x30, 0x40];
_T Soyombo = [0xa1, 0x1a, 0x50, 0x60];
_T Syloti_Nagri = [0xa0, 0xa8, 0x0, 0x30];
_T NKo = [0x87, 0xc0, 0x40];
_T Tai_Viet = [0xa0, 0xaa, 0x80, 0x60];
_T Low_Surrogates = [0xa0, 0xdc, 0x0, 0x84, 0x0];
_T Elymaic = [0xa1, 0xf, 0xe0, 0x20];
_T Hatran = [0xa1, 0x8, 0xe0, 0x20];
_T Sundanese_Supplement = [0x9c, 0xc0, 0x10];
_T CJK_Unified_Ideographs_Extension_H = [0xa3, 0x13, 0x50, 0x90, 0x60];
_T Chorasmian = [0xa1, 0xf, 0xb0, 0x30];
_T Kana_Extended_B = [0xa1, 0xaf, 0xf0, 0x10];
_T Glagolitic = [0xa0, 0x2c, 0x0, 0x60];
_T Devanagari_Extended_A = [0xa1, 0x1b, 0x0, 0x60];
_T Hangul_Syllables = [0xa0, 0xac, 0x0, 0xa0, 0x2b, 0xb0];
_T Osmanya = [0xa1, 0x4, 0x80, 0x30];
_T Enclosed_CJK_Letters_and_Months = [0xa0, 0x32, 0x0, 0x81, 0x0];
_T Meetei_Mayek_Extensions = [0xa0, 0xaa, 0xe0, 0x20];
_T Hangul_Jamo = [0x91, 0x0, 0x81, 0x0];
_T Mro = [0xa1, 0x6a, 0x40, 0x30];
_T Currency_Symbols = [0xa0, 0x20, 0xa0, 0x30];
_T Bopomofo_Extended = [0xa0, 0x31, 0xa0, 0x20];
_T Chakma = [0xa1, 0x11, 0x0, 0x50];
_T Pau_Cin_Hau = [0xa1, 0x1a, 0xc0, 0x40];
_T Latin_Extended_G = [0xa1, 0xdf, 0x0, 0x81, 0x0];
_T CJK_Unified_Ideographs = [0xa0, 0x4e, 0x0, 0xa0, 0x52, 0x0];
_T Znamenny_Musical_Notation = [0xa1, 0xcf, 0x0, 0x80, 0xd0];
_T New_Tai_Lue = [0x99, 0x80, 0x60];
_T Modi = [0xa1, 0x16, 0x0, 0x60];
_T Bamum_Supplement = [0xa1, 0x68, 0x0, 0x82, 0x40];
_T Cypro_Minoan = [0xa1, 0x2f, 0x90, 0x70];
_T Basic_Latin = [0x0, 0x80, 0x80];
_T Multani = [0xa1, 0x12, 0x80, 0x30];
_T Alchemical_Symbols = [0xa1, 0xf7, 0x0, 0x80, 0x80];
_T Bopomofo = [0xa0, 0x31, 0x0, 0x30];
_T Adlam = [0xa1, 0xe9, 0x0, 0x60];
_T Khitan_Small_Script = [0xa1, 0x8b, 0x0, 0x82, 0x0];
_T Old_Turkic = [0xa1, 0xc, 0x0, 0x50];
_T Lao = [0x8e, 0x80, 0x80, 0x80];
_T Cherokee_Supplement = [0xa0, 0xab, 0x70, 0x50];
_T CJK_Compatibility_Ideographs = [0xa0, 0xf9, 0x0, 0x82, 0x0];
_T Latin_Extended_F = [0xa1, 0x7, 0x80, 0x40];
_T Lisu_Supplement = [0xa1, 0x1f, 0xb0, 0x10];
_T Latin_Extended_A = [0x81, 0x0, 0x80, 0x80];
_T Spacing_Modifier_Letters = [0x82, 0xb0, 0x50];
_T Gothic = [0xa1, 0x3, 0x30, 0x20];
_T Sinhala_Archaic_Numbers = [0xa1, 0x11, 0xe0, 0x20];
_T Egyptian_Hieroglyphs = [0xa1, 0x30, 0x0, 0x84, 0x30];
_T Sinhala = [0x8d, 0x80, 0x80, 0x80];
_T Rejang = [0xa0, 0xa9, 0x30, 0x30];
_T Glagolitic_Supplement = [0xa1, 0xe0, 0x0, 0x30];
_T Lepcha = [0x9c, 0x0, 0x50];
_T Optical_Character_Recognition = [0xa0, 0x24, 0x40, 0x20];
_T Greek_Extended = [0x9f, 0x0, 0x81, 0x0];
_T Miscellaneous_Symbols_and_Pictographs = [0xa1, 0xf3, 0x0, 0x83, 0x0];
_T Emoticons = [0xa1, 0xf6, 0x0, 0x50];
_T Tirhuta = [0xa1, 0x14, 0x80, 0x60];
_T Marchen = [0xa1, 0x1c, 0x70, 0x50];
_T Geometric_Shapes_Extended = [0xa1, 0xf7, 0x80, 0x80, 0x80];
_T Arabic_Presentation_Forms_A = [0xa0, 0xfb, 0x50, 0x82, 0xb0];
_T Cyrillic_Extended_D = [0xa1, 0xe0, 0x30, 0x60];
_T Phoenician = [0xa1, 0x9, 0x0, 0x20];
_T Wancho = [0xa1, 0xe2, 0xc0, 0x40];
_T Meroitic_Hieroglyphs = [0xa1, 0x9, 0x80, 0x20];
_T Alphabetic_Presentation_Forms = [0xa0, 0xfb, 0x0, 0x50];
_T Linear_A = [0xa1, 0x6, 0x0, 0x81, 0x80];
_T Mahjong_Tiles = [0xa1, 0xf0, 0x0, 0x30];
_T Gurmukhi = [0x8a, 0x0, 0x80, 0x80];
_T Byzantine_Musical_Symbols = [0xa1, 0xd0, 0x0, 0x81, 0x0];
_T Transport_and_Map_Symbols = [0xa1, 0xf6, 0x80, 0x80, 0x80];
_T Unified_Canadian_Aboriginal_Syllabics = [0x94, 0x0, 0x82, 0x80];
_T Khojki = [0xa1, 0x12, 0x0, 0x50];
_T Khudawadi = [0xa1, 0x12, 0xb0, 0x50];
_T Newa = [0xa1, 0x14, 0x0, 0x80, 0x80];
_T Dogra = [0xa1, 0x18, 0x0, 0x50];
_T Ancient_Greek_Musical_Notation = [0xa1, 0xd2, 0x0, 0x50];
_T Cypriot_Syllabary = [0xa1, 0x8, 0x0, 0x40];
_T Latin_1_Supplement = [0x80, 0x80, 0x80, 0x80];
_T Hangul_Jamo_Extended_A = [0xa0, 0xa9, 0x60, 0x20];
_T Imperial_Aramaic = [0xa1, 0x8, 0x40, 0x20];
_T Tamil_Supplement = [0xa1, 0x1f, 0xc0, 0x40];
_T Oriya = [0x8b, 0x0, 0x80, 0x80];
_T Tai_Xuan_Jing_Symbols = [0xa1, 0xd3, 0x0, 0x60];
_T Enclosed_Alphanumerics = [0xa0, 0x24, 0x60, 0x80, 0xa0];
_T Meetei_Mayek = [0xa0, 0xab, 0xc0, 0x40];
_T Tagalog = [0x97, 0x0, 0x20];
_T Sundanese = [0x9b, 0x80, 0x40];
_T CJK_Compatibility_Ideographs_Supplement = [0xa2, 0xf8, 0x0, 0x82, 0x20];
_T Cuneiform_Numbers_and_Punctuation = [0xa1, 0x24, 0x0, 0x80, 0x80];
_T Ethiopic_Extended = [0xa0, 0x2d, 0x80, 0x60];
_T Domino_Tiles = [0xa1, 0xf0, 0x30, 0x70];
_T Old_Permic = [0xa1, 0x3, 0x50, 0x30];
_T Supplementary_Private_Use_Area_B = [0xb0, 0x0, 0x0];
_T Shavian = [0xa1, 0x4, 0x50, 0x30];
_T Anatolian_Hieroglyphs = [0xa1, 0x44, 0x0, 0x82, 0x80];
_T Lycian = [0xa1, 0x2, 0x80, 0x20];
_T Inscriptional_Pahlavi = [0xa1, 0xb, 0x60, 0x20];
_T Ancient_Greek_Numbers = [0xa1, 0x1, 0x40, 0x50];
_T Miao = [0xa1, 0x6f, 0x0, 0x80, 0xa0];
_T CJK_Unified_Ideographs_Extension_E = [0xa2, 0xb8, 0x20, 0x96, 0x90];
_T Pahawh_Hmong = [0xa1, 0x6b, 0x0, 0x80, 0x90];
_T Tangut = [0xa1, 0x70, 0x0, 0x98, 0x0];
_T Bengali = [0x89, 0x80, 0x80, 0x80];
_T CJK_Compatibility_Forms = [0xa0, 0xfe, 0x30, 0x20];
_T Vithkuqi = [0xa1, 0x5, 0x70, 0x50];
_T Supplemental_Punctuation = [0xa0, 0x2e, 0x0, 0x80, 0x80];
_T Armenian = [0x85, 0x30, 0x60];
_T Arabic_Presentation_Forms_B = [0xa0, 0xfe, 0x70, 0x80, 0x90];
_T Tangut_Components = [0xa1, 0x88, 0x0, 0x83, 0x0];
_T Sogdian = [0xa1, 0xf, 0x30, 0x40];
_T Ottoman_Siyaq_Numbers = [0xa1, 0xed, 0x0, 0x50];
_T Buhid = [0x97, 0x40, 0x20];
_T Myanmar_Extended_A = [0xa0, 0xaa, 0x60, 0x20];
_T Manichaean = [0xa1, 0xa, 0xc0, 0x40];
_T Miscellaneous_Mathematical_Symbols_B = [0xa0, 0x29, 0x80, 0x80, 0x80];
_T Latin_Extended_D = [0xa0, 0xa7, 0x20, 0x80, 0xe0];
_T Avestan = [0xa1, 0xb, 0x0, 0x40];
_T Small_Kana_Extension = [0xa1, 0xb1, 0x30, 0x40];
_T Ethiopic_Supplement = [0x93, 0x80, 0x20];
_T Arabic = [0x86, 0x0, 0x81, 0x0];
_T Kayah_Li = [0xa0, 0xa9, 0x0, 0x30];
_T Javanese = [0xa0, 0xa9, 0x80, 0x60];
_T Lydian = [0xa1, 0x9, 0x20, 0x20];
_T Aegean_Numbers = [0xa1, 0x1, 0x0, 0x40];
_T Braille_Patterns = [0xa0, 0x28, 0x0, 0x81, 0x0];
_T Buginese = [0x9a, 0x0, 0x20];
_T CJK_Symbols_and_Punctuation = [0xa0, 0x30, 0x0, 0x40];
_T Batak = [0x9b, 0xc0, 0x40];
_T Combining_Diacritical_Marks_Supplement = [0x9d, 0xc0, 0x40];
_T High_Surrogates = [0xa0, 0xd8, 0x0, 0x83, 0x80];
_T Vedic_Extensions = [0x9c, 0xd0, 0x30];
_T Nandinagari = [0xa1, 0x19, 0xa0, 0x60];
_T Kanbun = [0xa0, 0x31, 0x90, 0x10];
_T Arrows = [0xa0, 0x21, 0x90, 0x70];
_T Devanagari_Extended = [0xa0, 0xa8, 0xe0, 0x20];
_T Inscriptional_Parthian = [0xa1, 0xb, 0x40, 0x20];
_T Cham = [0xa0, 0xaa, 0x0, 0x60];
_T Box_Drawing = [0xa0, 0x25, 0x0, 0x80, 0x80];
_T Ugaritic = [0xa1, 0x3, 0x80, 0x20];
_T Georgian = [0x90, 0xa0, 0x60];
_T Tangut_Supplement = [0xa1, 0x8d, 0x0, 0x80, 0x80];
_T Kana_Supplement = [0xa1, 0xb0, 0x0, 0x81, 0x0];
_T Sharada = [0xa1, 0x11, 0x80, 0x60];
_T Tamil = [0x8b, 0x80, 0x80, 0x80];
_T Old_Persian = [0xa1, 0x3, 0xa0, 0x40];
_T Geometric_Shapes = [0xa0, 0x25, 0xa0, 0x60];
_T Cherokee = [0x93, 0xa0, 0x60];
_T Superscripts_and_Subscripts = [0xa0, 0x20, 0x70, 0x30];
_T CJK_Strokes = [0xa0, 0x31, 0xc0, 0x30];
_T Letterlike_Symbols = [0xa0, 0x21, 0x0, 0x50];
_T CJK_Unified_Ideographs_Extension_D = [0xa2, 0xb7, 0x40, 0x80, 0xe0];
_T Yijing_Hexagram_Symbols = [0xa0, 0x4d, 0xc0, 0x40];
_T Georgian_Extended = [0x9c, 0x90, 0x30];
_T Khmer_Symbols = [0x99, 0xe0, 0x20];
_T Sora_Sompeng = [0xa1, 0x10, 0xd0, 0x30];
_T Private_Use_Area = [0xa0, 0xe0, 0x0, 0x99, 0x0];
_T Kharoshthi = [0xa1, 0xa, 0x0, 0x60];
_T Dives_Akuru = [0xa1, 0x19, 0x0, 0x60];
_T Ancient_Symbols = [0xa1, 0x1, 0x90, 0x40];
_T Katakana = [0xa0, 0x30, 0xa0, 0x60];
_T Ideographic_Description_Characters = [0xa0, 0x2f, 0xf0, 0x10];
_T Cyrillic_Extended_B = [0xa0, 0xa6, 0x40, 0x60];
_T Meroitic_Cursive = [0xa1, 0x9, 0xa0, 0x60];
_T Mende_Kikakui = [0xa1, 0xe8, 0x0, 0x80, 0xe0];
_T Rumi_Numeral_Symbols = [0xa1, 0xe, 0x60, 0x20];
_T Combining_Diacritical_Marks_Extended = [0x9a, 0xb0, 0x50];
_T Telugu = [0x8c, 0x0, 0x80, 0x80];
_T Cyrillic_Supplement = [0x85, 0x0, 0x30];
_T Ethiopic = [0x92, 0x0, 0x81, 0x80];
_T Old_North_Arabian = [0xa1, 0xa, 0x80, 0x20];
_T IPA_Extensions = [0x82, 0x50, 0x60];
_T Vai = [0xa0, 0xa5, 0x0, 0x81, 0x40];
_T Latin_Extended_C = [0xa0, 0x2c, 0x60, 0x20];
_T Bamum = [0xa0, 0xa6, 0xa0, 0x60];
_T Control_Pictures = [0xa0, 0x24, 0x0, 0x40];
_T Mongolian = [0x98, 0x0, 0x80, 0xb0];
_T Warang_Citi = [0xa1, 0x18, 0xa0, 0x60];
_T Katakana_Phonetic_Extensions = [0xa0, 0x31, 0xf0, 0x10];
_T Mathematical_Operators = [0xa0, 0x22, 0x0, 0x81, 0x0];
_T Early_Dynastic_Cuneiform = [0xa1, 0x24, 0x80, 0x80, 0xd0];
_T Ol_Chiki = [0x9c, 0x50, 0x30];
_T Mahajani = [0xa1, 0x11, 0x50, 0x30];
_T Myanmar_Extended_B = [0xa0, 0xa9, 0xe0, 0x20];
_T Khmer = [0x97, 0x80, 0x80, 0x80];
_T Grantha = [0xa1, 0x13, 0x0, 0x80, 0x80];
_T Kannada = [0x8c, 0x80, 0x80, 0x80];
_T Phags_pa = [0xa0, 0xa8, 0x40, 0x40];
_T Mathematical_Alphanumeric_Symbols = [0xa1, 0xd4, 0x0, 0x84, 0x0];
_T Kawi = [0xa1, 0x1f, 0x0, 0x60];
_T Musical_Symbols = [0xa1, 0xd1, 0x0, 0x81, 0x0];
_T Yezidi = [0xa1, 0xe, 0x80, 0x40];
_T Kangxi_Radicals = [0xa0, 0x2f, 0x0, 0x80, 0xe0];
_T Phonetic_Extensions_Supplement = [0x9d, 0x80, 0x40];
_T CJK_Unified_Ideographs_Extension_A = [0xa0, 0x34, 0x0, 0x99, 0xc0];
_T Mongolian_Supplement = [0xa1, 0x16, 0x60, 0x20];
_T Bhaiksuki = [0xa1, 0x1c, 0x0, 0x70];
_T Hebrew = [0x85, 0x90, 0x70];
_T Gujarati = [0x8a, 0x80, 0x80, 0x80];
_T Tangsa = [0xa1, 0x6a, 0x70, 0x60];
_T General_Punctuation = [0xa0, 0x20, 0x0, 0x70];
_T CJK_Compatibility = [0xa0, 0x33, 0x0, 0x81, 0x0];
_T Yi_Syllables = [0xa0, 0xa0, 0x0, 0x84, 0x90];
_T Carian = [0xa1, 0x2, 0xa0, 0x40];
_T Miscellaneous_Symbols = [0xa0, 0x26, 0x0, 0x81, 0x0];
_T CJK_Unified_Ideographs_Extension_C = [0xa2, 0xa7, 0x0, 0x90, 0x40];
_T Miscellaneous_Symbols_and_Arrows = [0xa0, 0x2b, 0x0, 0x81, 0x0];
_T Old_Hungarian = [0xa1, 0xc, 0x80, 0x80, 0x80];
_T Latin_Extended_B = [0x81, 0x80, 0x80, 0xd0];
_T Runic = [0x96, 0xa0, 0x60];
_T Tags = [0xae, 0x0, 0x0, 0x80, 0x80];
_T Supplemental_Arrows_A = [0xa0, 0x27, 0xf0, 0x10];
_T Masaram_Gondi = [0xa1, 0x1d, 0x0, 0x60];
_T Arabic_Extended_B = [0x88, 0x70, 0x30];
_T Ethiopic_Extended_A = [0xa0, 0xab, 0x0, 0x30];
_T Duployan = [0xa1, 0xbc, 0x0, 0x80, 0xa0];
_T Georgian_Supplement = [0xa0, 0x2d, 0x0, 0x30];
_T Gunjala_Gondi = [0xa1, 0x1d, 0x60, 0x50];
_T Arabic_Mathematical_Alphabetic_Symbols = [0xa1, 0xee, 0x0, 0x81, 0x0];
_U[] _tab = [
_U("Adlam", Adlam),
_U("Aegean Numbers", Aegean_Numbers),
_U("Ahom", Ahom),
_U("Alchemical Symbols", Alchemical_Symbols),
_U("Alphabetic Presentation Forms", Alphabetic_Presentation_Forms),
_U("Anatolian Hieroglyphs", Anatolian_Hieroglyphs),
_U("Ancient Greek Musical Notation", Ancient_Greek_Musical_Notation),
_U("Ancient Greek Numbers", Ancient_Greek_Numbers),
_U("Ancient Symbols", Ancient_Symbols),
_U("Arabic", Arabic),
_U("Arabic Extended-A", Arabic_Extended_A),
_U("Arabic Extended-B", Arabic_Extended_B),
_U("Arabic Extended-C", Arabic_Extended_C),
_U("Arabic Mathematical Alphabetic Symbols", Arabic_Mathematical_Alphabetic_Symbols),
_U("Arabic Presentation Forms-A", Arabic_Presentation_Forms_A),
_U("Arabic Presentation Forms-B", Arabic_Presentation_Forms_B),
_U("Arabic Supplement", Arabic_Supplement),
_U("Armenian", Armenian),
_U("Arrows", Arrows),
_U("Avestan", Avestan),
_U("Balinese", Balinese),
_U("Bamum", Bamum),
_U("Bamum Supplement", Bamum_Supplement),
_U("Basic Latin", Basic_Latin),
_U("Bassa Vah", Bassa_Vah),
_U("Batak", Batak),
_U("Bengali", Bengali),
_U("Bhaiksuki", Bhaiksuki),
_U("Block Elements", Block_Elements),
_U("Bopomofo", Bopomofo),
_U("Bopomofo Extended", Bopomofo_Extended),
_U("Box Drawing", Box_Drawing),
_U("Brahmi", Brahmi),
_U("Braille Patterns", Braille_Patterns),
_U("Buginese", Buginese),
_U("Buhid", Buhid),
_U("Byzantine Musical Symbols", Byzantine_Musical_Symbols),
_U("Carian", Carian),
_U("Caucasian Albanian", Caucasian_Albanian),
_U("Chakma", Chakma),
_U("Cham", Cham),
_U("Cherokee", Cherokee),
_U("Cherokee Supplement", Cherokee_Supplement),
_U("Chess Symbols", Chess_Symbols),
_U("Chorasmian", Chorasmian),
_U("CJK Compatibility", CJK_Compatibility),
_U("CJK Compatibility Forms", CJK_Compatibility_Forms),
_U("CJK Compatibility Ideographs", CJK_Compatibility_Ideographs),
_U("CJK Compatibility Ideographs Supplement", CJK_Compatibility_Ideographs_Supplement),
_U("CJK Radicals Supplement", CJK_Radicals_Supplement),
_U("CJK Strokes", CJK_Strokes),
_U("CJK Symbols and Punctuation", CJK_Symbols_and_Punctuation),
_U("CJK Unified Ideographs", CJK_Unified_Ideographs),
_U("CJK Unified Ideographs Extension A", CJK_Unified_Ideographs_Extension_A),
_U("CJK Unified Ideographs Extension B", CJK_Unified_Ideographs_Extension_B),
_U("CJK Unified Ideographs Extension C", CJK_Unified_Ideographs_Extension_C),
_U("CJK Unified Ideographs Extension D", CJK_Unified_Ideographs_Extension_D),
_U("CJK Unified Ideographs Extension E", CJK_Unified_Ideographs_Extension_E),
_U("CJK Unified Ideographs Extension F", CJK_Unified_Ideographs_Extension_F),
_U("CJK Unified Ideographs Extension G", CJK_Unified_Ideographs_Extension_G),
_U("CJK Unified Ideographs Extension H", CJK_Unified_Ideographs_Extension_H),
_U("Combining Diacritical Marks", Combining_Diacritical_Marks),
_U("Combining Diacritical Marks Extended", Combining_Diacritical_Marks_Extended),
_U("Combining Diacritical Marks for Symbols", Combining_Diacritical_Marks_for_Symbols),
_U("Combining Diacritical Marks Supplement", Combining_Diacritical_Marks_Supplement),
_U("Combining Half Marks", Combining_Half_Marks),
_U("Common Indic Number Forms", Common_Indic_Number_Forms),
_U("Control Pictures", Control_Pictures),
_U("Coptic", Coptic),
_U("Coptic Epact Numbers", Coptic_Epact_Numbers),
_U("Counting Rod Numerals", Counting_Rod_Numerals),
_U("Cuneiform", Cuneiform),
_U("Cuneiform Numbers and Punctuation", Cuneiform_Numbers_and_Punctuation),
_U("Currency Symbols", Currency_Symbols),
_U("Cypriot Syllabary", Cypriot_Syllabary),
_U("Cypro-Minoan", Cypro_Minoan),
_U("Cyrillic", Cyrillic),
_U("Cyrillic Extended-A", Cyrillic_Extended_A),
_U("Cyrillic Extended-B", Cyrillic_Extended_B),
_U("Cyrillic Extended-C", Cyrillic_Extended_C),
_U("Cyrillic Extended-D", Cyrillic_Extended_D),
_U("Cyrillic Supplement", Cyrillic_Supplement),
_U("Deseret", Deseret),
_U("Devanagari", Devanagari),
_U("Devanagari Extended", Devanagari_Extended),
_U("Devanagari Extended-A", Devanagari_Extended_A),
_U("Dingbats", Dingbats),
_U("Dives Akuru", Dives_Akuru),
_U("Dogra", Dogra),
_U("Domino Tiles", Domino_Tiles),
_U("Duployan", Duployan),
_U("Early Dynastic Cuneiform", Early_Dynastic_Cuneiform),
_U("Egyptian Hieroglyph Format Controls", Egyptian_Hieroglyph_Format_Controls),
_U("Egyptian Hieroglyphs", Egyptian_Hieroglyphs),
_U("Elbasan", Elbasan),
_U("Elymaic", Elymaic),
_U("Emoticons", Emoticons),
_U("Enclosed Alphanumerics", Enclosed_Alphanumerics),
_U("Enclosed Alphanumeric Supplement", Enclosed_Alphanumeric_Supplement),
_U("Enclosed CJK Letters and Months", Enclosed_CJK_Letters_and_Months),
_U("Enclosed Ideographic Supplement", Enclosed_Ideographic_Supplement),
_U("Ethiopic", Ethiopic),
_U("Ethiopic Extended", Ethiopic_Extended),
_U("Ethiopic Extended-A", Ethiopic_Extended_A),
_U("Ethiopic Extended-B", Ethiopic_Extended_B),
_U("Ethiopic Supplement", Ethiopic_Supplement),
_U("General Punctuation", General_Punctuation),
_U("Geometric Shapes", Geometric_Shapes),
_U("Geometric Shapes Extended", Geometric_Shapes_Extended),
_U("Georgian", Georgian),
_U("Georgian Extended", Georgian_Extended),
_U("Georgian Supplement", Georgian_Supplement),
_U("Glagolitic", Glagolitic),
_U("Glagolitic Supplement", Glagolitic_Supplement),
_U("Gothic", Gothic),
_U("Grantha", Grantha),
_U("Greek and Coptic", Greek_and_Coptic),
_U("Greek Extended", Greek_Extended),
_U("Gujarati", Gujarati),
_U("Gunjala Gondi", Gunjala_Gondi),
_U("Gurmukhi", Gurmukhi),
_U("Halfwidth and Fullwidth Forms", Halfwidth_and_Fullwidth_Forms),
_U("Hangul Compatibility Jamo", Hangul_Compatibility_Jamo),
_U("Hangul Jamo", Hangul_Jamo),
_U("Hangul Jamo Extended-A", Hangul_Jamo_Extended_A),
_U("Hangul Jamo Extended-B", Hangul_Jamo_Extended_B),
_U("Hangul Syllables", Hangul_Syllables),
_U("Hanifi Rohingya", Hanifi_Rohingya),
_U("Hanunoo", Hanunoo),
_U("Hatran", Hatran),
_U("Hebrew", Hebrew),
_U("High Private Use Surrogates", High_Private_Use_Surrogates),
_U("High Surrogates", High_Surrogates),
_U("Hiragana", Hiragana),
_U("Ideographic Description Characters", Ideographic_Description_Characters),
_U("Ideographic Symbols and Punctuation", Ideographic_Symbols_and_Punctuation),
_U("Imperial Aramaic", Imperial_Aramaic),
_U("Indic Siyaq Numbers", Indic_Siyaq_Numbers),
_U("Inscriptional Pahlavi", Inscriptional_Pahlavi),
_U("Inscriptional Parthian", Inscriptional_Parthian),
_U("IPA Extensions", IPA_Extensions),
_U("Javanese", Javanese),
_U("Kaithi", Kaithi),
_U("Kaktovik Numerals", Kaktovik_Numerals),
_U("Kana Extended-A", Kana_Extended_A),
_U("Kana Extended-B", Kana_Extended_B),
_U("Kana Supplement", Kana_Supplement),
_U("Kanbun", Kanbun),
_U("Kangxi Radicals", Kangxi_Radicals),
_U("Kannada", Kannada),
_U("Katakana", Katakana),
_U("Katakana Phonetic Extensions", Katakana_Phonetic_Extensions),
_U("Kawi", Kawi),
_U("Kayah Li", Kayah_Li),
_U("Kharoshthi", Kharoshthi),
_U("Khitan Small Script", Khitan_Small_Script),
_U("Khmer", Khmer),
_U("Khmer Symbols", Khmer_Symbols),
_U("Khojki", Khojki),
_U("Khudawadi", Khudawadi),
_U("Lao", Lao),
_U("Latin-1 Supplement", Latin_1_Supplement),
_U("Latin Extended-A", Latin_Extended_A),
_U("Latin Extended Additional", Latin_Extended_Additional),
_U("Latin Extended-B", Latin_Extended_B),
_U("Latin Extended-C", Latin_Extended_C),
_U("Latin Extended-D", Latin_Extended_D),
_U("Latin Extended-E", Latin_Extended_E),
_U("Latin Extended-F", Latin_Extended_F),
_U("Latin Extended-G", Latin_Extended_G),
_U("Lepcha", Lepcha),
_U("Letterlike Symbols", Letterlike_Symbols),
_U("Limbu", Limbu),
_U("Linear A", Linear_A),
_U("Linear B Ideograms", Linear_B_Ideograms),
_U("Linear B Syllabary", Linear_B_Syllabary),
_U("Lisu", Lisu),
_U("Lisu Supplement", Lisu_Supplement),
_U("Low Surrogates", Low_Surrogates),
_U("Lycian", Lycian),
_U("Lydian", Lydian),
_U("Mahajani", Mahajani),
_U("Mahjong Tiles", Mahjong_Tiles),
_U("Makasar", Makasar),
_U("Malayalam", Malayalam),
_U("Mandaic", Mandaic),
_U("Manichaean", Manichaean),
_U("Marchen", Marchen),
_U("Masaram Gondi", Masaram_Gondi),
_U("Mathematical Alphanumeric Symbols", Mathematical_Alphanumeric_Symbols),
_U("Mathematical Operators", Mathematical_Operators),
_U("Mayan Numerals", Mayan_Numerals),
_U("Medefaidrin", Medefaidrin),
_U("Meetei Mayek", Meetei_Mayek),
_U("Meetei Mayek Extensions", Meetei_Mayek_Extensions),
_U("Mende Kikakui", Mende_Kikakui),
_U("Meroitic Cursive", Meroitic_Cursive),
_U("Meroitic Hieroglyphs", Meroitic_Hieroglyphs),
_U("Miao", Miao),
_U("Miscellaneous Mathematical Symbols-A", Miscellaneous_Mathematical_Symbols_A),
_U("Miscellaneous Mathematical Symbols-B", Miscellaneous_Mathematical_Symbols_B),
_U("Miscellaneous Symbols", Miscellaneous_Symbols),
_U("Miscellaneous Symbols and Arrows", Miscellaneous_Symbols_and_Arrows),
_U("Miscellaneous Symbols and Pictographs", Miscellaneous_Symbols_and_Pictographs),
_U("Miscellaneous Technical", Miscellaneous_Technical),
_U("Modi", Modi),
_U("Modifier Tone Letters", Modifier_Tone_Letters),
_U("Mongolian", Mongolian),
_U("Mongolian Supplement", Mongolian_Supplement),
_U("Mro", Mro),
_U("Multani", Multani),
_U("Musical Symbols", Musical_Symbols),
_U("Myanmar", Myanmar),
_U("Myanmar Extended-A", Myanmar_Extended_A),
_U("Myanmar Extended-B", Myanmar_Extended_B),
_U("Nabataean", Nabataean),
_U("Nag Mundari", Nag_Mundari),
_U("Nandinagari", Nandinagari),
_U("Newa", Newa),
_U("New Tai Lue", New_Tai_Lue),
_U("NKo", NKo),
_U("Number Forms", Number_Forms),
_U("Nushu", Nushu),
_U("Nyiakeng Puachue Hmong", Nyiakeng_Puachue_Hmong),
_U("Ogham", Ogham),
_U("Ol Chiki", Ol_Chiki),
_U("Old Hungarian", Old_Hungarian),
_U("Old Italic", Old_Italic),
_U("Old North Arabian", Old_North_Arabian),
_U("Old Permic", Old_Permic),
_U("Old Persian", Old_Persian),
_U("Old Sogdian", Old_Sogdian),
_U("Old South Arabian", Old_South_Arabian),
_U("Old Turkic", Old_Turkic),
_U("Old Uyghur", Old_Uyghur),
_U("Optical Character Recognition", Optical_Character_Recognition),
_U("Oriya", Oriya),
_U("Ornamental Dingbats", Ornamental_Dingbats),
_U("Osage", Osage),
_U("Osmanya", Osmanya),
_U("Ottoman Siyaq Numbers", Ottoman_Siyaq_Numbers),
_U("Pahawh Hmong", Pahawh_Hmong),
_U("Palmyrene", Palmyrene),
_U("Pau Cin Hau", Pau_Cin_Hau),
_U("Phags-pa", Phags_pa),
_U("Phaistos Disc", Phaistos_Disc),
_U("Phoenician", Phoenician),
_U("Phonetic Extensions", Phonetic_Extensions),
_U("Phonetic Extensions Supplement", Phonetic_Extensions_Supplement),
_U("Playing Cards", Playing_Cards),
_U("Private Use Area", Private_Use_Area),
_U("Psalter Pahlavi", Psalter_Pahlavi),
_U("Rejang", Rejang),
_U("Rumi Numeral Symbols", Rumi_Numeral_Symbols),
_U("Runic", Runic),
_U("Samaritan", Samaritan),
_U("Saurashtra", Saurashtra),
_U("Sharada", Sharada),
_U("Shavian", Shavian),
_U("Shorthand Format Controls", Shorthand_Format_Controls),
_U("Siddham", Siddham),
_U("Sinhala", Sinhala),
_U("Sinhala Archaic Numbers", Sinhala_Archaic_Numbers),
_U("Small Form Variants", Small_Form_Variants),
_U("Small Kana Extension", Small_Kana_Extension),
_U("Sogdian", Sogdian),
_U("Sora Sompeng", Sora_Sompeng),
_U("Soyombo", Soyombo),
_U("Spacing Modifier Letters", Spacing_Modifier_Letters),
_U("Specials", Specials),
_U("Sundanese", Sundanese),
_U("Sundanese Supplement", Sundanese_Supplement),
_U("Superscripts and Subscripts", Superscripts_and_Subscripts),
_U("Supplemental Arrows-A", Supplemental_Arrows_A),
_U("Supplemental Arrows-B", Supplemental_Arrows_B),
_U("Supplemental Arrows-C", Supplemental_Arrows_C),
_U("Supplemental Mathematical Operators", Supplemental_Mathematical_Operators),
_U("Supplemental Punctuation", Supplemental_Punctuation),
_U("Supplemental Symbols and Pictographs", Supplemental_Symbols_and_Pictographs),
_U("Supplementary Private Use Area-A", Supplementary_Private_Use_Area_A),
_U("Supplementary Private Use Area-B", Supplementary_Private_Use_Area_B),
_U("Sutton SignWriting", Sutton_SignWriting),
_U("Syloti Nagri", Syloti_Nagri),
_U("Symbols and Pictographs Extended-A", Symbols_and_Pictographs_Extended_A),
_U("Symbols for Legacy Computing", Symbols_for_Legacy_Computing),
_U("Syriac", Syriac),
_U("Syriac Supplement", Syriac_Supplement),
_U("Tagalog", Tagalog),
_U("Tagbanwa", Tagbanwa),
_U("Tags", Tags),
_U("Tai Le", Tai_Le),
_U("Tai Tham", Tai_Tham),
_U("Tai Viet", Tai_Viet),
_U("Tai Xuan Jing Symbols", Tai_Xuan_Jing_Symbols),
_U("Takri", Takri),
_U("Tamil", Tamil),
_U("Tamil Supplement", Tamil_Supplement),
_U("Tangsa", Tangsa),
_U("Tangut", Tangut),
_U("Tangut Components", Tangut_Components),
_U("Tangut Supplement", Tangut_Supplement),
_U("Telugu", Telugu),
_U("Thaana", Thaana),
_U("Thai", Thai),
_U("Tibetan", Tibetan),
_U("Tifinagh", Tifinagh),
_U("Tirhuta", Tirhuta),
_U("Toto", Toto),
_U("Transport and Map Symbols", Transport_and_Map_Symbols),
_U("Ugaritic", Ugaritic),
_U("Unified Canadian Aboriginal Syllabics", Unified_Canadian_Aboriginal_Syllabics),
_U("Unified Canadian Aboriginal Syllabics Extended", Unified_Canadian_Aboriginal_Syllabics_Extended),
_U("Unified Canadian Aboriginal Syllabics Extended-A", Unified_Canadian_Aboriginal_Syllabics_Extended_A),
_U("Vai", Vai),
_U("Variation Selectors", Variation_Selectors),
_U("Variation Selectors Supplement", Variation_Selectors_Supplement),
_U("Vedic Extensions", Vedic_Extensions),
_U("Vertical Forms", Vertical_Forms),
_U("Vithkuqi", Vithkuqi),
_U("Wancho", Wancho),
_U("Warang Citi", Warang_Citi),
_U("Yezidi", Yezidi),
_U("Yijing Hexagram Symbols", Yijing_Hexagram_Symbols),
_U("Yi Radicals", Yi_Radicals),
_U("Yi Syllables", Yi_Syllables),
_U("Zanabazar Square", Zanabazar_Square),
_U("Znamenny Musical Notation", Znamenny_Musical_Notation),
];
}

struct scripts
{
private alias _U = immutable(UnicodeProperty);
@property static _U[] tab() pure { return _tab; }
static immutable:
private alias _T = ubyte[];
_T Old_Hungarian = [0xa1, 0xc, 0x80, 0x33, 0xd, 0x33, 0x7, 0x6];
_T Coptic = [0x83, 0xe2, 0xe, 0xa0, 0x28, 0x90, 0x74, 0x5, 0x7];
_T Ol_Chiki = [0x9c, 0x50, 0x30];
_T Cyrillic = [0x84, 0x0, 0x80, 0x85, 0x2, 0x80, 0xa9, 0x97, 0x50, 0x9, 0x80, 0xa2, 0x1, 0x4c, 0x1, 0x90, 0x67, 0x20, 0xa0, 0x78, 0x40, 0x60, 0xa0, 0x57, 0x8e, 0x2, 0xa0, 0xe2, 0x0, 0x3e, 0x21, 0x1];
_T Thaana = [0x87, 0x80, 0x32];
_T Inscriptional_Parthian = [0xa1, 0xb, 0x40, 0x16, 0x2, 0x8];
_T Nabataean = [0xa1, 0x8, 0x80, 0x1f, 0x8, 0x9];
_T Ogham = [0x96, 0x80, 0x1d];
_T Meroitic_Hieroglyphs = [0xa1, 0x9, 0x80, 0x20];
_T Makasar = [0xa1, 0x1e, 0xe0, 0x19];
_T Siddham = [0xa1, 0x15, 0x80, 0x36, 0x2, 0x26];
_T Old_Persian = [0xa1, 0x3, 0xa0, 0x24, 0x4, 0xe];
_T Imperial_Aramaic = [0xa1, 0x8, 0x40, 0x16, 0x1, 0x9];
_T Myanmar = [0x90, 0x0, 0x80, 0xa0, 0xa0, 0x99, 0x40, 0x1f, 0x61, 0x20];
_T Deseret = [0xa1, 0x4, 0x0, 0x50];
_T Kaithi = [0xa1, 0x10, 0x80, 0x43, 0xa, 0x1];
_T Medefaidrin = [0xa1, 0x6e, 0x40, 0x5b];
_T Kayah_Li = [0xa0, 0xa9, 0x0, 0x2e, 0x1, 0x1];
_T Hiragana = [0xa0, 0x30, 0x41, 0x56, 0x6, 0x3, 0xa1, 0x7f, 0x61, 0x81, 0x1f, 0x12, 0x1, 0x1d, 0x3, 0xa0, 0x40, 0xad, 0x1];
_T Ahom = [0xa1, 0x17, 0x0, 0x1b, 0x2, 0xf, 0x4, 0x17];
_T Devanagari = [0x89, 0x0, 0x51, 0x4, 0xf, 0x2, 0x1a, 0xa0, 0x9f, 0x60, 0x20, 0xa0, 0x72, 0x0, 0xa];
_T Tibetan = [0x8f, 0x0, 0x48, 0x1, 0x24, 0x4, 0x27, 0x1, 0x24, 0x1, 0xf, 0x1, 0x7, 0x4, 0x2];
_T Nko = [0x87, 0xc0, 0x3b, 0x2, 0x3];
_T Brahmi = [0xa1, 0x10, 0x0, 0x4e, 0x4, 0x24, 0x9, 0x1];
_T Osage = [0xa1, 0x4, 0xb0, 0x24, 0x4, 0x24];
_T Nushu = [0xa1, 0x6f, 0xe1, 0x1, 0xa0, 0x41, 0x8e, 0x81, 0x8c];
_T Cuneiform = [0xa1, 0x20, 0x0, 0x83, 0x9a, 0x66, 0x6f, 0x1, 0x5, 0xb, 0x80, 0xc4];
_T Takri = [0xa1, 0x16, 0x80, 0x3a, 0x6, 0xa];
_T Toto = [0xa1, 0xe2, 0x90, 0x1f];
_T Latin = [0x41, 0x1a, 0x6, 0x1a, 0x2f, 0x1, 0xf, 0x1, 0x5, 0x17, 0x1, 0x1f, 0x1, 0x81, 0xc1, 0x27, 0x5, 0x9a, 0x1b, 0x26, 0x6, 0x31, 0x5, 0x4, 0x5, 0xd, 0x1, 0x46, 0x41, 0x81, 0x0, 0x81, 0x71, 0x1, 0xd, 0x1, 0x10, 0xd, 0x80, 0x8d, 0x2, 0x6, 0x1, 0x1b, 0x1, 0x11, 0x29, 0x8a, 0xd7, 0x20, 0xa0, 0x7a, 0xa2, 0x66, 0x3, 0x40, 0x5, 0x2, 0x1, 0x1, 0x1, 0x5, 0x18, 0xe, 0x83, 0x30, 0x2b, 0x1, 0x9, 0x1, 0x4, 0xa0, 0x4f, 0x96, 0x7, 0x84, 0x1a, 0x1a, 0x6, 0x1a, 0x88, 0x25, 0x6, 0x1, 0x2a, 0x1, 0x9, 0xa0, 0xd7, 0x45, 0x1f, 0x6, 0x6];
_T Hanunoo = [0x97, 0x20, 0x15];
_T Limbu = [0x99, 0x0, 0x1f, 0x1, 0xc, 0x4, 0xc, 0x4, 0x1, 0x3, 0xc];
_T Saurashtra = [0xa0, 0xa8, 0x80, 0x46, 0x8, 0xc];
_T Lisu = [0xa0, 0xa4, 0xd0, 0x30, 0xa0, 0x7a, 0xb0, 0x1];
_T Egyptian_Hieroglyphs = [0xa1, 0x30, 0x0, 0x84, 0x56];
_T Elbasan = [0xa1, 0x5, 0x0, 0x28];
_T Palmyrene = [0xa1, 0x8, 0x60, 0x20];
_T Tagbanwa = [0x97, 0x60, 0xd, 0x1, 0x3, 0x1, 0x2];
_T Old_Italic = [0xa1, 0x3, 0x0, 0x24, 0x9, 0x3];
_T Caucasian_Albanian = [0xa1, 0x5, 0x30, 0x34, 0xb, 0x1];
_T Malayalam = [0x8d, 0x0, 0xd, 0x1, 0x3, 0x1, 0x33, 0x1, 0x3, 0x1, 0x6, 0x4, 0x10, 0x2, 0x1a];
_T Inherited = [0x83, 0x0, 0x70, 0x81, 0x15, 0x2, 0x81, 0xc4, 0xb, 0x1a, 0x1, 0x82, 0xe0, 0x4, 0x91, 0x5b, 0x1f, 0x82, 0x1, 0x3, 0x1, 0xd, 0x1, 0x7, 0x4, 0x1, 0x6, 0x1, 0x3, 0x2, 0x80, 0xc6, 0x40, 0x82, 0xc, 0x2, 0x80, 0xc2, 0x21, 0x8f, 0x39, 0x4, 0x6b, 0x2, 0xa0, 0xcd, 0x65, 0x10, 0x10, 0xe, 0x83, 0xcf, 0x1, 0x80, 0xe2, 0x1, 0x90, 0x5a, 0x1, 0xa0, 0xbb, 0xc4, 0x2e, 0x2, 0x17, 0x82, 0x20, 0x3, 0x11, 0x8, 0x2, 0x7, 0x1e, 0x4, 0xac, 0x2f, 0x52, 0x80, 0xf0];
_T Sora_Sompeng = [0xa1, 0x10, 0xd0, 0x19, 0x7, 0xa];
_T Linear_B = [0xa1, 0x0, 0x0, 0xc, 0x1, 0x1a, 0x1, 0x13, 0x1, 0x2, 0x1, 0xf, 0x2, 0xe, 0x22, 0x7b];
_T Nyiakeng_Puachue_Hmong = [0xa1, 0xe1, 0x0, 0x2d, 0x3, 0xe, 0x2, 0xa, 0x4, 0x2];
_T Meroitic_Cursive = [0xa1, 0x9, 0xa0, 0x18, 0x4, 0x14, 0x2, 0x2e];
_T Thai = [0x8e, 0x1, 0x3a, 0x5, 0x1c];
_T Mende_Kikakui = [0xa1, 0xe8, 0x0, 0x80, 0xc5, 0x2, 0x10];
_T Old_Sogdian = [0xa1, 0xf, 0x0, 0x28];
_T Old_Turkic = [0xa1, 0xc, 0x0, 0x49];
_T Samaritan = [0x88, 0x0, 0x2e, 0x2, 0xf];
_T Old_South_Arabian = [0xa1, 0xa, 0x60, 0x20];
_T Hanifi_Rohingya = [0xa1, 0xd, 0x0, 0x28, 0x8, 0xa];
_T Balinese = [0x9b, 0x0, 0x4d, 0x3, 0x2f];
_T Mandaic = [0x88, 0x40, 0x1c, 0x2, 0x1];
_T SignWriting = [0xa1, 0xd8, 0x0, 0x82, 0x8c, 0xf, 0x5, 0x1, 0xf];
_T Tifinagh = [0xa0, 0x2d, 0x30, 0x38, 0x7, 0x2, 0xe, 0x1];
_T Tai_Viet = [0xa0, 0xaa, 0x80, 0x43, 0x18, 0x5];
_T Syriac = [0x87, 0x0, 0xe, 0x1, 0x3c, 0x2, 0x3, 0x81, 0x10, 0xb];
_T Soyombo = [0xa1, 0x1a, 0x50, 0x53];
_T Elymaic = [0xa1, 0xf, 0xe0, 0x17];
_T Hatran = [0xa1, 0x8, 0xe0, 0x13, 0x1, 0x2, 0x5, 0x5];
_T Chorasmian = [0xa1, 0xf, 0xb0, 0x1c];
_T Glagolitic = [0xa0, 0x2c, 0x0, 0x60, 0xa1, 0xb3, 0xa0, 0x7, 0x1, 0x11, 0x2, 0x7, 0x1, 0x2, 0x1, 0x5];
_T Osmanya = [0xa1, 0x4, 0x80, 0x1e, 0x2, 0xa];
_T Linear_A = [0xa1, 0x6, 0x0, 0x81, 0x37, 0x9, 0x16, 0xa, 0x8];
_T Mro = [0xa1, 0x6a, 0x40, 0x1f, 0x1, 0xa, 0x4, 0x2];
_T Chakma = [0xa1, 0x11, 0x0, 0x35, 0x1, 0x12];
_T Modi = [0xa1, 0x16, 0x0, 0x45, 0xb, 0xa];
_T Bassa_Vah = [0xa1, 0x6a, 0xd0, 0x1e, 0x2, 0x6];
_T Han = [0xa0, 0x2e, 0x80, 0x1a, 0x1, 0x59, 0xc, 0x80, 0xd6, 0x2f, 0x1, 0x1, 0x1, 0x19, 0x9, 0xe, 0x4, 0x83, 0xc4, 0x99, 0xc0, 0x40, 0xa0, 0x52, 0x0, 0xa0, 0x59, 0x0, 0x81, 0x6e, 0x2, 0x6a, 0xa0, 0x75, 0x8, 0x2, 0xc, 0x2, 0xa0, 0x90, 0xe, 0xa0, 0xa6, 0xe0, 0x20, 0x90, 0x3a, 0x6, 0x80, 0xde, 0x2, 0x96, 0x82, 0xe, 0x9d, 0x31, 0x8c, 0x1f, 0x82, 0x1e, 0x85, 0xe2, 0x93, 0x4b, 0x5, 0x90, 0x60];
_T Multani = [0xa1, 0x12, 0x80, 0x7, 0x1, 0x1, 0x1, 0x4, 0x1, 0xf, 0x1, 0xb];
_T Bopomofo = [0x82, 0xea, 0x2, 0xa0, 0x2e, 0x19, 0x2b, 0x70, 0x20];
_T Adlam = [0xa1, 0xe9, 0x0, 0x4c, 0x4, 0xa, 0x4, 0x2];
_T Khitan_Small_Script = [0xa1, 0x6f, 0xe4, 0x1, 0x9b, 0x1b, 0x81, 0xd6];
_T Lao = [0x8e, 0x81, 0x2, 0x1, 0x1, 0x1, 0x5, 0x1, 0x18, 0x1, 0x1, 0x1, 0x17, 0x2, 0x5, 0x1, 0x1, 0x1, 0x7, 0x1, 0xa, 0x2, 0x4];
_T Psalter_Pahlavi = [0xa1, 0xb, 0x80, 0x12, 0x7, 0x4, 0xc, 0x7];
_T Anatolian_Hieroglyphs = [0xa1, 0x44, 0x0, 0x82, 0x47];
_T Canadian_Aboriginal = [0x94, 0x0, 0x82, 0x80, 0x82, 0x30, 0x46, 0xa1, 0x1, 0xba, 0x10];
_T Common = [0x0, 0x41, 0x1a, 0x6, 0x1a, 0x2f, 0x1, 0xf, 0x1, 0x5, 0x17, 0x1, 0x1f, 0x1, 0x81, 0xc1, 0x27, 0x5, 0x5, 0x2, 0x14, 0x74, 0x1, 0x9, 0x1, 0x6, 0x1, 0x1, 0x1, 0x82, 0x7d, 0x1, 0x6, 0x1, 0xe, 0x1, 0x3, 0x1, 0x20, 0x1, 0x80, 0x9c, 0x1, 0x82, 0x4, 0x1, 0x80, 0x81, 0x2, 0x84, 0xd9, 0x1, 0x81, 0x95, 0x4, 0x81, 0x22, 0x1, 0x85, 0xef, 0x3, 0x47, 0x2, 0x80, 0xcb, 0x2, 0x1, 0x1, 0x84, 0xcd, 0x1, 0xd, 0x1, 0x7, 0x4, 0x1, 0x6, 0x1, 0x3, 0x2, 0x1, 0x83, 0x5, 0xc, 0x2, 0x57, 0x1, 0xb, 0x3, 0xb, 0x1, 0xf, 0x11, 0x21, 0x3f, 0x26, 0x1, 0x3, 0x2, 0x6, 0x1, 0x1b, 0x1, 0x11, 0x29, 0x3, 0x4, 0x82, 0x97, 0x19, 0xb, 0x15, 0x83, 0xa0, 0x81, 0x0, 0x82, 0x74, 0x2, 0x20, 0x1, 0x69, 0x82, 0x0, 0x5e, 0x81, 0x92, 0xc, 0x4, 0x5, 0x1, 0x1, 0x1, 0x19, 0xf, 0x8, 0x4, 0x4, 0x5b, 0x2, 0x3, 0x1, 0x5a, 0x2, 0x80, 0x93, 0x10, 0x20, 0x24, 0x3c, 0x40, 0x1f, 0x51, 0x2f, 0x1, 0x58, 0x80, 0xa8, 0x99, 0xc0, 0x40, 0xa0, 0x59, 0x0, 0x22, 0x66, 0x3, 0x80, 0xa5, 0xa, 0x80, 0xf4, 0x1, 0x80, 0xa0, 0x1, 0x81, 0x8b, 0x1, 0xe, 0x2, 0xa0, 0x51, 0xd2, 0x2, 0x80, 0xd0, 0xa, 0x16, 0x23, 0x1, 0x13, 0x1, 0x4, 0x80, 0x93, 0x1, 0x1, 0x20, 0x1a, 0x6, 0x1a, 0xb, 0xa, 0x1, 0x2d, 0x2, 0x40, 0x7, 0x1, 0x7, 0xa, 0x5, 0x81, 0x2, 0x3, 0x4, 0x2d, 0x3, 0x9, 0x50, 0xd, 0x33, 0x2d, 0x80, 0xe4, 0x1b, 0xa0, 0xb9, 0xa4, 0x4, 0x92, 0xac, 0x74, 0x3c, 0x80, 0xf6, 0xa, 0x27, 0x2, 0x3e, 0x3, 0x11, 0x8, 0x2, 0x7, 0x1e, 0x4, 0x3d, 0x80, 0xd5, 0x14, 0xc, 0x14, 0xc, 0x57, 0x9, 0x19, 0x80, 0x87, 0x55, 0x1, 0x47, 0x1, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x4, 0x1, 0xc, 0x1, 0x1, 0x1, 0x7, 0x1, 0x41, 0x1, 0x4, 0x2, 0x8, 0x1, 0x7, 0x1, 0x1c, 0x1, 0x4, 0x1, 0x5, 0x1, 0x1, 0x3, 0x7, 0x1, 0x81, 0x54, 0x2, 0x81, 0x24, 0x2, 0x32, 0x94, 0x71, 0x44, 0x4c, 0x3d, 0x82, 0xc2, 0x2c, 0x4, 0x64, 0xc, 0xf, 0x2, 0xf, 0x1, 0xf, 0x1, 0x25, 0xa, 0x80, 0xae, 0x38, 0x1a, 0x1, 0x2, 0xd, 0x2c, 0x4, 0x9, 0x7, 0x2, 0xe, 0x6, 0x80, 0x9a, 0x83, 0xd8, 0x4, 0x11, 0x3, 0xd, 0x3, 0x77, 0x4, 0x5f, 0x6, 0xc, 0x4, 0x1, 0xf, 0xc, 0x4, 0x38, 0x8, 0xa, 0x6, 0x28, 0x8, 0x1e, 0x2, 0x2, 0x4e, 0x81, 0x54, 0xc, 0xe, 0x2, 0xd, 0x3, 0x9, 0x7, 0x2e, 0x1, 0x7, 0x8, 0xe, 0x4, 0x9, 0x7, 0x9, 0x7, 0x80, 0x93, 0x1, 0x37, 0x25, 0xa, 0xac, 0x4, 0x7, 0x1, 0x1e, 0x60];
_T Gothic = [0xa1, 0x3, 0x30, 0x1b];
_T Yi = [0xa0, 0xa0, 0x0, 0x84, 0x8d, 0x3, 0x37];
_T Sinhala = [0x8d, 0x81, 0x3, 0x1, 0x12, 0x3, 0x18, 0x1, 0x9, 0x1, 0x1, 0x2, 0x7, 0x3, 0x1, 0x4, 0x6, 0x1, 0x1, 0x1, 0x8, 0x6, 0xa, 0x2, 0x3, 0xa1, 0x3, 0xec, 0x14];
_T Rejang = [0xa0, 0xa9, 0x30, 0x24, 0xb, 0x1];
_T Lepcha = [0x9c, 0x0, 0x38, 0x3, 0xf, 0x3, 0x3];
_T Tai_Tham = [0x9a, 0x20, 0x3f, 0x1, 0x1d, 0x2, 0xb, 0x6, 0xa, 0x6, 0xe];
_T Dives_Akuru = [0xa1, 0x19, 0x0, 0x7, 0x2, 0x1, 0x2, 0x8, 0x1, 0x2, 0x1, 0x1e, 0x1, 0x2, 0x2, 0xc, 0x9, 0xa];
_T Meetei_Mayek = [0xa0, 0xaa, 0xe0, 0x17, 0x80, 0xc9, 0x2e, 0x2, 0xa];
_T Tirhuta = [0xa1, 0x14, 0x80, 0x48, 0x8, 0xa];
_T Marchen = [0xa1, 0x1c, 0x70, 0x20, 0x2, 0x16, 0x1, 0xe];
_T Wancho = [0xa1, 0xe2, 0xc0, 0x3a, 0x5, 0x1];
_T Phoenician = [0xa1, 0x9, 0x0, 0x1c, 0x3, 0x1];
_T Gurmukhi = [0x8a, 0x1, 0x3, 0x1, 0x6, 0x4, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x2, 0x1, 0x1, 0x5, 0x4, 0x2, 0x2, 0x3, 0x3, 0x1, 0x7, 0x4, 0x1, 0x1, 0x7, 0x11];
_T Khudawadi = [0xa1, 0x12, 0xb0, 0x3b, 0x5, 0xa];
_T Khojki = [0xa1, 0x12, 0x0, 0x12, 0x1, 0x2f];
_T Newa = [0xa1, 0x14, 0x0, 0x5c, 0x1, 0x5];
_T Dogra = [0xa1, 0x18, 0x0, 0x3c];
_T Oriya = [0x8b, 0x1, 0x3, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x2, 0x9, 0x2, 0x2, 0x2, 0x3, 0x7, 0x3, 0x4, 0x2, 0x1, 0x5, 0x2, 0x12];
_T Tagalog = [0x97, 0x0, 0x16, 0x9, 0x1];
_T Sundanese = [0x9b, 0x80, 0x40, 0x81, 0x0, 0x8];
_T Old_Permic = [0xa1, 0x3, 0x50, 0x2b];
_T Shavian = [0xa1, 0x4, 0x50, 0x30];
_T Lycian = [0xa1, 0x2, 0x80, 0x1d];
_T Miao = [0xa1, 0x6f, 0x0, 0x4b, 0x4, 0x39, 0x7, 0x11];
_T Tangut = [0xa1, 0x6f, 0xe0, 0x1, 0x1f, 0x97, 0xf8, 0x8, 0x83, 0x0, 0x82, 0x0, 0x9];
_T Bengali = [0x89, 0x80, 0x4, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x1, 0x3, 0x4, 0x2, 0x9, 0x2, 0x2, 0x2, 0x4, 0x8, 0x1, 0x4, 0x2, 0x1, 0x5, 0x2, 0x19];
_T Inscriptional_Pahlavi = [0xa1, 0xb, 0x60, 0x13, 0x5, 0x8];
_T Vithkuqi = [0xa1, 0x5, 0x70, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2, 0x1, 0xb, 0x1, 0xf, 0x1, 0x7, 0x1, 0x2];
_T Armenian = [0x85, 0x31, 0x26, 0x2, 0x32, 0x2, 0x3, 0xa0, 0xf5, 0x83, 0x5];
_T New_Tai_Lue = [0x99, 0x80, 0x2c, 0x4, 0x1a, 0x6, 0xb, 0x3, 0x2];
_T Sogdian = [0xa1, 0xf, 0x30, 0x2a];
_T Buhid = [0x97, 0x40, 0x14];
_T Manichaean = [0xa1, 0xa, 0xc0, 0x27, 0x4, 0xc];
_T Greek = [0x83, 0x70, 0x4, 0x1, 0x3, 0x2, 0x4, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x14, 0x1, 0x3f, 0xe, 0x10, 0x99, 0x26, 0x5, 0x32, 0x5, 0x4, 0x5, 0x54, 0x1, 0x81, 0x40, 0x16, 0x2, 0x6, 0x2, 0x26, 0x2, 0x6, 0x2, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1f, 0x2, 0x35, 0x1, 0xf, 0x1, 0xe, 0x2, 0x6, 0x1, 0x13, 0x2, 0x3, 0x1, 0x9, 0x81, 0x27, 0x1, 0xa0, 0x8a, 0x3e, 0x1, 0xa0, 0x55, 0xda, 0x4f, 0x11, 0x1, 0xa0, 0xd0, 0x5f, 0x46];
_T Braille = [0xa0, 0x28, 0x0, 0x81, 0x0];
_T Avestan = [0xa1, 0xb, 0x0, 0x36, 0x3, 0x7];
_T Arabic = [0x86, 0x0, 0x5, 0x1, 0x6, 0x1, 0xe, 0x1, 0x3, 0x1, 0x20, 0x1, 0xa, 0xb, 0x1a, 0x1, 0x6c, 0x1, 0x22, 0x50, 0x30, 0x80, 0xf0, 0x1f, 0x1, 0x2, 0x6, 0x4a, 0x1, 0x1d, 0xa0, 0xf2, 0x50, 0x73, 0x10, 0x81, 0x6b, 0x2, 0x50, 0x2, 0x36, 0x7, 0x1, 0x20, 0x10, 0x70, 0x5, 0x1, 0x80, 0x87, 0x8f, 0x63, 0x1f, 0x7e, 0x3, 0xa0, 0xdf, 0x0, 0x4, 0x1, 0x1b, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0xa, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x6, 0x1, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x1, 0x7, 0x1, 0x4, 0x1, 0x4, 0x1, 0x1, 0x1, 0xa, 0x1, 0x11, 0x5, 0x3, 0x1, 0x5, 0x1, 0x11, 0x34, 0x2];
_T Javanese = [0xa0, 0xa9, 0x80, 0x4e, 0x2, 0xa, 0x4, 0x2];
_T Lydian = [0xa1, 0x9, 0x20, 0x1a, 0x5, 0x1];
_T Pau_Cin_Hau = [0xa1, 0x1a, 0xc0, 0x39];
_T Cypro_Minoan = [0xa1, 0x2f, 0x90, 0x63];
_T Buginese = [0x9a, 0x0, 0x1c, 0x2, 0x2];
_T Batak = [0x9b, 0xc0, 0x34, 0x8, 0x4];
_T Nandinagari = [0xa1, 0x19, 0xa0, 0x8, 0x2, 0x2e, 0x2, 0xb];
_T Cham = [0xa0, 0xaa, 0x0, 0x37, 0x9, 0xe, 0x2, 0xa, 0x2, 0x4];
_T Gunjala_Gondi = [0xa1, 0x1d, 0x60, 0x6, 0x1, 0x2, 0x1, 0x25, 0x1, 0x2, 0x1, 0x6, 0x7, 0xa];
_T Cypriot = [0xa1, 0x8, 0x0, 0x6, 0x2, 0x1, 0x1, 0x2c, 0x1, 0x2, 0x3, 0x1, 0x2, 0x1];
_T Ugaritic = [0xa1, 0x3, 0x80, 0x1e, 0x1, 0x1];
_T Georgian = [0x90, 0xa0, 0x26, 0x1, 0x1, 0x5, 0x1, 0x2, 0x2b, 0x1, 0x4, 0x8b, 0x90, 0x2b, 0x2, 0x3, 0x90, 0x40, 0x26, 0x1, 0x1, 0x5, 0x1];
_T Sharada = [0xa1, 0x11, 0x80, 0x60];
_T Tamil = [0x8b, 0x82, 0x2, 0x1, 0x6, 0x3, 0x3, 0x1, 0x4, 0x3, 0x2, 0x1, 0x1, 0x1, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 0xc, 0x4, 0x5, 0x3, 0x3, 0x1, 0x4, 0x2, 0x1, 0x6, 0x1, 0xe, 0x15, 0xa1, 0x13, 0xc5, 0x32, 0xd, 0x1];
_T Cherokee = [0x93, 0xa0, 0x56, 0x2, 0x6, 0xa0, 0x97, 0x72, 0x50];
_T Pahawh_Hmong = [0xa1, 0x6b, 0x0, 0x46, 0xa, 0xa, 0x1, 0x7, 0x1, 0x15, 0x5, 0x13];
_T Syloti_Nagri = [0xa0, 0xa8, 0x0, 0x2d];
_T Kharoshthi = [0xa1, 0xa, 0x0, 0x4, 0x1, 0x2, 0x5, 0x8, 0x1, 0x3, 0x1, 0x1d, 0x2, 0x3, 0x4, 0xa, 0x7, 0x9];
_T Zanabazar_Square = [0xa1, 0x1a, 0x0, 0x48];
_T Katakana = [0xa0, 0x30, 0xa1, 0x5a, 0x2, 0x3, 0x80, 0xf0, 0x10, 0x80, 0xd0, 0x2f, 0x1, 0x58, 0xa0, 0xcc, 0xe, 0xa, 0x1, 0x2d, 0xa0, 0xb0, 0x52, 0x4, 0x1, 0x7, 0x1, 0x2, 0x1, 0x1, 0x81, 0x1f, 0x3, 0x32, 0x1, 0xe, 0x4];
_T Telugu = [0x8c, 0x0, 0xd, 0x1, 0x3, 0x1, 0x17, 0x1, 0x10, 0x2, 0x9, 0x1, 0x3, 0x1, 0x4, 0x7, 0x2, 0x1, 0x3, 0x2, 0x1, 0x2, 0x4, 0x2, 0xa, 0x7, 0x9];
_T Ethiopic = [0x92, 0x0, 0x49, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0x29, 0x1, 0x4, 0x2, 0x21, 0x1, 0x4, 0x2, 0x7, 0x1, 0x1, 0x1, 0x4, 0x2, 0xf, 0x1, 0x39, 0x1, 0x4, 0x2, 0x43, 0x2, 0x20, 0x3, 0x1a, 0x99, 0xe6, 0x17, 0x9, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0x1, 0x7, 0xa0, 0x7d, 0x22, 0x6, 0x2, 0x6, 0x2, 0x6, 0x9, 0x7, 0x1, 0x7, 0xa1, 0x3c, 0xb1, 0x7, 0x1, 0x4, 0x1, 0x2, 0x1, 0xf];
_T Vai = [0xa0, 0xa5, 0x0, 0x81, 0x2c];
_T Bamum = [0xa0, 0xa6, 0xa0, 0x58, 0xa0, 0xc1, 0x8, 0x82, 0x39];
_T Hangul = [0x91, 0x0, 0x81, 0x0, 0x9e, 0x2e, 0x2, 0x81, 0x1, 0x5e, 0x71, 0x1f, 0x41, 0x1f, 0xa0, 0x76, 0xe1, 0x1d, 0x82, 0x83, 0xa0, 0x2b, 0xa4, 0xc, 0x17, 0x4, 0x31, 0xa0, 0x27, 0xa4, 0x1f, 0x3, 0x6, 0x2, 0x6, 0x2, 0x6, 0x2, 0x3];
_T Mongolian = [0x98, 0x0, 0x2, 0x2, 0x1, 0x1, 0x14, 0x6, 0x59, 0x7, 0x2b, 0xa0, 0xfd, 0xb5, 0xd];
_T Nag_Mundari = [0xa1, 0xe4, 0xd0, 0x2a];
_T Old_Uyghur = [0xa1, 0xf, 0x70, 0x1a];
_T Mahajani = [0xa1, 0x11, 0x50, 0x27];
_T Khmer = [0x97, 0x80, 0x5e, 0x2, 0xa, 0x6, 0xa, 0x81, 0xe6, 0x20];
_T Grantha = [0xa1, 0x13, 0x0, 0x4, 0x1, 0x8, 0x2, 0x2, 0x2, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x2, 0x9, 0x2, 0x2, 0x2, 0x3, 0x2, 0x1, 0x6, 0x1, 0x5, 0x7, 0x2, 0x7, 0x3, 0x5];
_T Kannada = [0x8c, 0x80, 0xd, 0x1, 0x3, 0x1, 0x17, 0x1, 0xa, 0x1, 0x5, 0x2, 0x9, 0x1, 0x3, 0x1, 0x4, 0x7, 0x2, 0x6, 0x2, 0x1, 0x4, 0x2, 0xa, 0x1, 0x3];
_T Kawi = [0xa1, 0x1f, 0x0, 0x11, 0x1, 0x29, 0x3, 0x1c];
_T Yezidi = [0xa1, 0xe, 0x80, 0x2a, 0x1, 0x3, 0x2, 0x2];
_T Old_North_Arabian = [0xa1, 0xa, 0x80, 0x20];
_T Tai_Le = [0x99, 0x50, 0x1e, 0x2, 0x5];
_T Hebrew = [0x85, 0x91, 0x37, 0x8, 0x1b, 0x4, 0x6, 0xa0, 0xf5, 0x28, 0x1a, 0x1, 0x5, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0xa];
_T Gujarati = [0x8a, 0x81, 0x3, 0x1, 0x9, 0x1, 0x3, 0x1, 0x16, 0x1, 0x7, 0x1, 0x2, 0x1, 0x5, 0x2, 0xa, 0x1, 0x3, 0x1, 0x3, 0x2, 0x1, 0xf, 0x4, 0x2, 0xc, 0x7, 0x7];
_T Tangsa = [0xa1, 0x6a, 0x70, 0x4f, 0x1, 0xa];
_T Carian = [0xa1, 0x2, 0xa0, 0x31];
_T Bhaiksuki = [0xa1, 0x1c, 0x0, 0x9, 0x1, 0x2d, 0x1, 0xe, 0xa, 0x1d];
_T Masaram_Gondi = [0xa1, 0x1d, 0x0, 0x7, 0x1, 0x2, 0x1, 0x2c, 0x3, 0x1, 0x1, 0x2, 0x1, 0x9, 0x8, 0xa];
_T Runic = [0x96, 0xa0, 0x4b, 0x3, 0xb];
_T Duployan = [0xa1, 0xbc, 0x0, 0x6b, 0x5, 0xd, 0x3, 0x9, 0x7, 0xa, 0x2, 0x4];
_T Warang_Citi = [0xa1, 0x18, 0xa0, 0x53, 0xc, 0x1];
_T Phags_Pa = [0xa0, 0xa8, 0x40, 0x38];
_U[] _tab = [
_U("Adlam", Adlam),
_U("Ahom", Ahom),
_U("Anatolian_Hieroglyphs", Anatolian_Hieroglyphs),
_U("Arabic", Arabic),
_U("Armenian", Armenian),
_U("Avestan", Avestan),
_U("Balinese", Balinese),
_U("Bamum", Bamum),
_U("Bassa_Vah", Bassa_Vah),
_U("Batak", Batak),
_U("Bengali", Bengali),
_U("Bhaiksuki", Bhaiksuki),
_U("Bopomofo", Bopomofo),
_U("Brahmi", Brahmi),
_U("Braille", Braille),
_U("Buginese", Buginese),
_U("Buhid", Buhid),
_U("Canadian_Aboriginal", Canadian_Aboriginal),
_U("Carian", Carian),
_U("Caucasian_Albanian", Caucasian_Albanian),
_U("Chakma", Chakma),
_U("Cham", Cham),
_U("Cherokee", Cherokee),
_U("Chorasmian", Chorasmian),
_U("Common", Common),
_U("Coptic", Coptic),
_U("Cuneiform", Cuneiform),
_U("Cypriot", Cypriot),
_U("Cypro_Minoan", Cypro_Minoan),
_U("Cyrillic", Cyrillic),
_U("Deseret", Deseret),
_U("Devanagari", Devanagari),
_U("Dives_Akuru", Dives_Akuru),
_U("Dogra", Dogra),
_U("Duployan", Duployan),
_U("Egyptian_Hieroglyphs", Egyptian_Hieroglyphs),
_U("Elbasan", Elbasan),
_U("Elymaic", Elymaic),
_U("Ethiopic", Ethiopic),
_U("Georgian", Georgian),
_U("Glagolitic", Glagolitic),
_U("Gothic", Gothic),
_U("Grantha", Grantha),
_U("Greek", Greek),
_U("Gujarati", Gujarati),
_U("Gunjala_Gondi", Gunjala_Gondi),
_U("Gurmukhi", Gurmukhi),
_U("Han", Han),
_U("Hangul", Hangul),
_U("Hanifi_Rohingya", Hanifi_Rohingya),
_U("Hanunoo", Hanunoo),
_U("Hatran", Hatran),
_U("Hebrew", Hebrew),
_U("Hiragana", Hiragana),
_U("Imperial_Aramaic", Imperial_Aramaic),
_U("Inherited", Inherited),
_U("Inscriptional_Pahlavi", Inscriptional_Pahlavi),
_U("Inscriptional_Parthian", Inscriptional_Parthian),
_U("Javanese", Javanese),
_U("Kaithi", Kaithi),
_U("Kannada", Kannada),
_U("Katakana", Katakana),
_U("Kawi", Kawi),
_U("Kayah_Li", Kayah_Li),
_U("Kharoshthi", Kharoshthi),
_U("Khitan_Small_Script", Khitan_Small_Script),
_U("Khmer", Khmer),
_U("Khojki", Khojki),
_U("Khudawadi", Khudawadi),
_U("Lao", Lao),
_U("Latin", Latin),
_U("Lepcha", Lepcha),
_U("Limbu", Limbu),
_U("Linear_A", Linear_A),
_U("Linear_B", Linear_B),
_U("Lisu", Lisu),
_U("Lycian", Lycian),
_U("Lydian", Lydian),
_U("Mahajani", Mahajani),
_U("Makasar", Makasar),
_U("Malayalam", Malayalam),
_U("Mandaic", Mandaic),
_U("Manichaean", Manichaean),
_U("Marchen", Marchen),
_U("Masaram_Gondi", Masaram_Gondi),
_U("Medefaidrin", Medefaidrin),
_U("Meetei_Mayek", Meetei_Mayek),
_U("Mende_Kikakui", Mende_Kikakui),
_U("Meroitic_Cursive", Meroitic_Cursive),
_U("Meroitic_Hieroglyphs", Meroitic_Hieroglyphs),
_U("Miao", Miao),
_U("Modi", Modi),
_U("Mongolian", Mongolian),
_U("Mro", Mro),
_U("Multani", Multani),
_U("Myanmar", Myanmar),
_U("Nabataean", Nabataean),
_U("Nag_Mundari", Nag_Mundari),
_U("Nandinagari", Nandinagari),
_U("Newa", Newa),
_U("New_Tai_Lue", New_Tai_Lue),
_U("Nko", Nko),
_U("Nushu", Nushu),
_U("Nyiakeng_Puachue_Hmong", Nyiakeng_Puachue_Hmong),
_U("Ogham", Ogham),
_U("Ol_Chiki", Ol_Chiki),
_U("Old_Hungarian", Old_Hungarian),
_U("Old_Italic", Old_Italic),
_U("Old_North_Arabian", Old_North_Arabian),
_U("Old_Permic", Old_Permic),
_U("Old_Persian", Old_Persian),
_U("Old_Sogdian", Old_Sogdian),
_U("Old_South_Arabian", Old_South_Arabian),
_U("Old_Turkic", Old_Turkic),
_U("Old_Uyghur", Old_Uyghur),
_U("Oriya", Oriya),
_U("Osage", Osage),
_U("Osmanya", Osmanya),
_U("Pahawh_Hmong", Pahawh_Hmong),
_U("Palmyrene", Palmyrene),
_U("Pau_Cin_Hau", Pau_Cin_Hau),
_U("Phags_Pa", Phags_Pa),
_U("Phoenician", Phoenician),
_U("Psalter_Pahlavi", Psalter_Pahlavi),
_U("Rejang", Rejang),
_U("Runic", Runic),
_U("Samaritan", Samaritan),
_U("Saurashtra", Saurashtra),
_U("Sharada", Sharada),
_U("Shavian", Shavian),
_U("Siddham", Siddham),
_U("SignWriting", SignWriting),
_U("Sinhala", Sinhala),
_U("Sogdian", Sogdian),
_U("Sora_Sompeng", Sora_Sompeng),
_U("Soyombo", Soyombo),
_U("Sundanese", Sundanese),
_U("Syloti_Nagri", Syloti_Nagri),
_U("Syriac", Syriac),
_U("Tagalog", Tagalog),
_U("Tagbanwa", Tagbanwa),
_U("Tai_Le", Tai_Le),
_U("Tai_Tham", Tai_Tham),
_U("Tai_Viet", Tai_Viet),
_U("Takri", Takri),
_U("Tamil", Tamil),
_U("Tangsa", Tangsa),
_U("Tangut", Tangut),
_U("Telugu", Telugu),
_U("Thaana", Thaana),
_U("Thai", Thai),
_U("Tibetan", Tibetan),
_U("Tifinagh", Tifinagh),
_U("Tirhuta", Tirhuta),
_U("Toto", Toto),
_U("Ugaritic", Ugaritic),
_U("Vai", Vai),
_U("Vithkuqi", Vithkuqi),
_U("Wancho", Wancho),
_U("Warang_Citi", Warang_Citi),
_U("Yezidi", Yezidi),
_U("Yi", Yi),
_U("Zanabazar_Square", Zanabazar_Square),
];
}

struct hangul
{
private alias _U = immutable(UnicodeProperty);
@property static _U[] tab() pure { return _tab; }
static immutable:
private alias _T = ubyte[];
_T V = [0x91, 0x60, 0x48, 0xa0, 0xc6, 0x8, 0x17];
_T T = [0x91, 0xa8, 0x58, 0xa0, 0xc5, 0xcb, 0x31];
_T LVT = [0xa0, 0xac, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b];
_T L = [0x91, 0x0, 0x60, 0xa0, 0x98, 0x0, 0x1d];
_T LV = [0xa0, 0xac, 0x0, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1, 0x1b, 0x1];
_U[] _tab = [
_U("L", L),
_U("Leading_Jamo", L),
_U("LV", LV),
_U("LV_Syllable", LV),
_U("LVT", LVT),
_U("LVT_Syllable", LVT),
_U("T", T),
_U("Trailing_Jamo", T),
_U("V", V),
_U("Vowel_Jamo", V),
];
}
bool isFormatGen(dchar ch) @safe pure nothrow @nogc
{
    if (ch < 8288)
    {
        if (ch < 2192)
        {
            if (ch < 1564)
            {
                if (ch == 173) return true;
                if (ch < 1536) return false;
                if (ch < 1542) return true;
                return false;
            }
            else if (ch < 1565) return true;
            else
            {
                if (ch == 1757) return true;
                if (ch == 1807) return true;
                return false;
            }
        }
        else if (ch < 2194) return true;
        else
        {
            if (ch < 8203)
            {
                if (ch == 2274) return true;
                if (ch == 6158) return true;
                return false;
            }
            else if (ch < 8208) return true;
            else
            {
                if (ch < 8234) return false;
                if (ch < 8239) return true;
                return false;
            }
        }
    }
    else if (ch < 8293) return true;
    else
    {
        if (ch < 78896)
        {
            if (ch < 65529)
            {
                if (ch < 8294) return false;
                if (ch < 8304) return true;
                if (ch == 65279) return true;
                return false;
            }
            else if (ch < 65532) return true;
            else
            {
                if (ch == 69821) return true;
                if (ch == 69837) return true;
                return false;
            }
        }
        else if (ch < 78912) return true;
        else
        {
            if (ch < 917505)
            {
                if (ch < 113824) return false;
                if (ch < 113828) return true;
                if (ch < 119155) return false;
                if (ch < 119163) return true;
                return false;
            }
            else if (ch < 917506) return true;
            else
            {
                if (ch < 917536) return false;
                if (ch < 917632) return true;
                return false;
            }
        }
    }
}

bool isControlGen(dchar ch) @safe pure nothrow @nogc
{
    if (ch < 32) return true;
    if (ch < 127) return false;
    if (ch < 160) return true;
    return false;
}

bool isSpaceGen(dchar ch) @safe pure nothrow @nogc
{
    if (ch < 160)
    {
        if (ch == 32) return true;
        return false;
    }
    else if (ch < 161) return true;
    else
    {
        if (ch < 8239)
        {
            if (ch == 5760) return true;
            if (ch < 8192) return false;
            if (ch < 8203) return true;
            return false;
        }
        else if (ch < 8240) return true;
        else
        {
            if (ch == 8287) return true;
            if (ch == 12288) return true;
            return false;
        }
    }
}

bool isWhiteGen(dchar ch) @safe pure nothrow @nogc
{
    if (ch < 133)
    {
        if (ch < 9) return false;
        if (ch < 14) return true;
        if (ch == 32) return true;
        return false;
    }
    else if (ch < 134) return true;
    else
    {
        if (ch < 8232)
        {
            if (ch < 5760)
            {
                if (ch == 160) return true;
                return false;
            }
            else if (ch < 5761) return true;
            else
            {
                if (ch < 8192) return false;
                if (ch < 8203) return true;
                return false;
            }
        }
        else if (ch < 8234) return true;
        else
        {
            if (ch < 8287)
            {
                if (ch == 8239) return true;
                return false;
            }
            else if (ch < 8288) return true;
            else
            {
                if (ch == 12288) return true;
                return false;
            }
        }
    }
}

bool isHangL(dchar ch) @safe pure nothrow @nogc
{
    if (ch < 4352) return false;
    if (ch < 4448) return true;
    if (ch < 43360) return false;
    if (ch < 43389) return true;
    return false;
}

bool isHangV(dchar ch) @safe pure nothrow @nogc
{
    if (ch < 4448) return false;
    if (ch < 4520) return true;
    if (ch < 55216) return false;
    if (ch < 55239) return true;
    return false;
}

bool isHangT(dchar ch) @safe pure nothrow @nogc
{
    if (ch < 4520) return false;
    if (ch < 4608) return true;
    if (ch < 55243) return false;
    if (ch < 55292) return true;
    return false;
}


static if (size_t.sizeof == 4)
{
//2080 bytes
enum lowerCaseTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x40,  0xe0], [ 0x100,  0x140,  0x2500], [ 0x2020100,  0x4020302,  0x6020205,  0x8070202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000,  0x30002,  0x50004,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60007,  0x80006,  0x60006,  0x60006,  0x60006,  0x60006,  0xa0009,  0xc000b,  0xe000d,  0x60006,  0x6000f,  0x60006,  0x60006,  0x60006,  0x110010,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x130012,  0x60006,  0x140006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x150006,  0x60006,  0x160006,  0x60006,  0x60006,  0x180017,  0x190006,  0x60006,  0x60006,  0x6001a,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x6001b,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x6001c,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x1e001d,  0x20001f,  0x60006,  0x60006,  0x60006,  0x210006,  0x60022,  0x60006,  0x60006,  0x60006,  0x230006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x0,  0x0,  0x0,  0x7fffffe,  0x0,  0x4200400,  0x80000000,  0xff7fffff,  0xaaaaaaaa,  0x55aaaaaa,  0xaaaaab55,  0xd4aaaaaa,  0x4e243129,  0xe6512d2a,  0xb5555240,  0xaa29aaaa,  0xaaaaaaaa,  0x93faaaaa,  0xffffaa85,  0xffffffff,  0xffefffff,  0x1ffffff,  0x3,  0x1f,  0x0,  0x0,  0x20,  0x3c8a0000,  0x10000,  0xfffff000,  0xaae37fff,  0x192faaaa,  0x0,  0xffff0000,  0xffffffff,  0xaaaaaaaa,  0xaaaaa802,  0xaaaaaaaa,  0xaaaad554,  0xaaaaaaaa,  0xaaaaaaaa,  0xaaaa,  0x0,  0xffffffff,  0x1ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0xf7ffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3f000000,  0x0,  0x0,  0x0,  0x0,  0x1ff,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x0,  0x0,  0xaaaaaaaa,  0xaaaaaaaa,  0xaaaaaaaa,  0xaaaaaaaa,  0xbfeaaaaa,  0xaaaaaaaa,  0xaaaaaaaa,  0xaaaaaaaa,  0x3f00ff,  0xff00ff,  0xff003f,  0x3fff00ff,  0xff00ff,  0x40df00ff,  0xcf00dc,  0xdc00ff,  0x0,  0x0,  0x0,  0x80020000,  0x1fff0000,  0x0,  0x0,  0x0,  0x8c400,  0x32108000,  0x43c0,  0xffff0000,  0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0x3ff,  0x0,  0xffff0000,  0xffffffff,  0x3fda1562,  0xaaaaaaaa,  0xaaaaaaaa,  0xaaaaaaaa,  0x8501a,  0xffffffff,  0x20bf,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xaaaaaaaa,  0x2aaa,  0x3aaaaaaa,  0x0,  0x0,  0x0,  0x0,  0xaaabaaa8,  0xaaaaaaaa,  0x95ffaaaa,  0xaaba50aa,  0xaaa082aa,  0x2aa050a,  0x75c0000,  0x0,  0xffff0000,  0xf7ffffff,  0xffff03ff,  0xffffffff,  0xffffffff,  0x0,  0x0,  0xf8007f,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7fffffe,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffff00,  0xffff,  0x0,  0x0,  0x0,  0xff000000,  0xfffffff,  0x0,  0x0,  0x0,  0x0,  0xff800000,  0x1bfbfffb,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffb9,  0x7fdffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x7ffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x0,  0x0,  0x0,  0x0,  0xfc000000,  0xfffff,  0xffdfc000,  0xff,  0xffffffc,  0xebc00000,  0xffef,  0xfffffc00,  0xc000000f,  0xffffff,  0xfffc0000,  0xfff,  0xffffffc0,  0xfc000000,  0xfffff,  0xffffc000,  0xff,  0xffffffc,  0xffc00000,  0xffff,  0xfffffc00,  0x3f,  0xf7fffffc,  0xf0000003,  0xfdfffff,  0xffc00000,  0x3f7fff,  0xffff0000,  0xfdff,  0xfffffc00,  0xbf7,  0x0,  0x7ffffbff,  0x7e0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0xffffffff,  0x3fff,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfffffffc,  0xf,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0]);
//1856 bytes
enum upperCaseTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x40,  0xe0], [ 0x100,  0x140,  0x1e00], [ 0x2020100,  0x4020302,  0x6020205,  0x8070202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000,  0x30002,  0x50004,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60007,  0x80006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60009,  0xb000a,  0xc0006,  0x60006,  0x6000d,  0x60006,  0x60006,  0x60006,  0x6000e,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x10000f,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x110006,  0x60006,  0x60006,  0x130012,  0x60006,  0x60006,  0x60006,  0x60014,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60015,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60016,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x180017,  0x1a0019,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x1b0006,  0x60006,  0x60006,  0x60006,  0x1c0006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x60006,  0x0,  0x0,  0x7fffffe,  0x0,  0x0,  0x0,  0x7f7fffff,  0x0,  0x55555555,  0xaa555555,  0x555554aa,  0x2b555555,  0xb1dbced6,  0x11aed2d5,  0x4aaaa490,  0x55d25555,  0x55555555,  0x6c055555,  0x557a,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x80450000,  0xfffed740,  0xffb,  0x551c8000,  0xe6905555,  0xffffffff,  0xffff,  0x0,  0x55555555,  0x55555401,  0x55555555,  0x55552aab,  0x55555555,  0x55555555,  0xfffe5555,  0x7fffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x20bf,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x3fffff,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0xe7ffffff,  0x0,  0x0,  0x55555555,  0x55555555,  0x55555555,  0x55555555,  0x40155555,  0x55555555,  0x55555555,  0x55555555,  0x3f00ff00,  0xff00ff00,  0xaa003f00,  0xff00,  0x0,  0xf000000,  0xf000f00,  0xf001f00,  0x3e273884,  0xc00f3d50,  0x20,  0xffff,  0x8,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffc00000,  0xffff,  0x0,  0xffffffff,  0xffff,  0x0,  0xc025ea9d,  0x55555555,  0x55555555,  0x55555555,  0x42805,  0x0,  0x0,  0x55555555,  0x1555,  0x5555555,  0x0,  0x0,  0x0,  0x0,  0x55545554,  0x55555555,  0x6a005555,  0x55452855,  0x555f7d55,  0x14102f5,  0x200000,  0x0,  0x7fffffe,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xff,  0x0,  0x0,  0x0,  0xffff0000,  0xfffff,  0x0,  0x0,  0x0,  0x0,  0xf7ff0000,  0x37f7ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x7ffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3ffffff,  0xfff00000,  0x3fff,  0xffffff00,  0xd0000003,  0x3fde64,  0xffff0000,  0x3ff,  0x1fdfe7b0,  0x7b000000,  0x1fc5f,  0xfffff000,  0x3f,  0x3ffffff,  0xfff00000,  0x3fff,  0xffffff00,  0xf0000003,  0x3fffff,  0xffff0000,  0x3ff,  0xffffff00,  0x1,  0x7fffffc,  0xf0000000,  0x1fffff,  0xffc00000,  0x7fff,  0xffff0000,  0x1ff,  0x400,  0x0,  0xffffffff,  0x3,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0xffff03ff,  0xffff03ff,  0x3ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0]);
//11520 bytes
enum simpleCaseTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x40,  0x280], [ 0x100,  0x480,  0x1180], [ 0x2020100,  0x4020302,  0x6020205,  0x7020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x10000,  0x30002,  0x50004,  0x70006,  0x90008,  0xa,  0xb0000,  0xd000c,  0xf000e,  0x110010,  0x130012,  0x14,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x160015,  0x0,  0x0,  0x0,  0x0,  0x0,  0x180017,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x19,  0x1a0000,  0x1b,  0x1d001c,  0x1f001e,  0x210020,  0x230022,  0x0,  0x0,  0x250024,  0x26,  0x0,  0x0,  0x0,  0x0,  0x0,  0x280027,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2a0029,  0x2c002b,  0x2d,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2e0000,  0x2f,  0x310030,  0x330032,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x340000,  0x35,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x370036,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x390038,  0x3b003a,  0x3c0000,  0x3d,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3f003e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x410040,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x420000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x440043,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x919ffff,  0x8e10080,  0x31905f9,  0x90700bd,  0x9cc0b94,  0xb25006b,  0x82206c5,  0xacc00e0,  0x4650834,  0x5cf0592,  0xa2d0783,  0x1930180,  0x4d7051c,  0xffff02f9,  0xffffffff,  0xffffffff,  0x91affff,  0x8e20081,  0x31a05fa,  0x90800be,  0x9cd0b95,  0xb26006c,  0x82306c6,  0xacd00e1,  0x4660835,  0x5d00593,  0xa2e0784,  0x1940181,  0x4d8051d,  0xffff02fa,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x961ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5ac0779,  0x8520118,  0x9b70ad2,  0x3d90257,  0x38d0557,  0xb470128,  0x3950629,  0x3150047,  0x8d905f1,  0x29f0086,  0x589070f,  0xffff00cb,  0x97e0adc,  0x4f90213,  0x87c06ff,  0x8eb0a3f,  0x5ad077a,  0x8530119,  0x9b80ad3,  0x3da0258,  0x38e0558,  0xb480129,  0x396062a,  0x3160048,  0x8da05f2,  0x2a00087,  0x58a0710,  0xffff00cc,  0x97f0add,  0x4fa0214,  0x87d0700,  0x36a0a40,  0x9d909d8,  0x4ca04c9,  0x1cd01cc,  0xb520b51,  0x20001ff,  0x730072f,  0xce00cd,  0x8ab08aa,  0x5c005b,  0x6120611,  0x520051,  0x61e061d,  0x2b202b1,  0x6610660,  0x15a0159,  0x7ff07fe,  0xb830b82,  0x7e507e4,  0x4bc04bb,  0xa5c0a5b,  0x1b401b3,  0x5910590,  0x21c021b,  0x9690968,  0xffffffff,  0x8750874,  0x9350934,  0x31c031b,  0x94ffff,  0x6fb0095,  0x8e06fc,  0x818008f,  0xb2a0819,  0x7c80b2b,  0x12007c9,  0xa1d0121,  0xffff0a1e,  0x4da04d9,  0x7c307c2,  0xb600b5f,  0x6bb06ba,  0x1620161,  0x6810680,  0x2aa02a9,  0x6080607,  0xd000c,  0x63f063e,  0x70006f,  0x8370836,  0xd200d1,  0x7260725,  0x1df01de,  0xb7b0b7a,  0x1a201a1,  0x4c404c3,  0xa4c0a4b,  0x7cd07cc,  0x5640563,  0x9730972,  0x9f509f4,  0x623036b,  0x210624,  0x5fb0022,  0x5d105fc,  0x686068f,  0xb120b11,  0x26a0269,  0x2750524,  0xb330276,  0x1af07f8,  0xffff01b0,  0xabc0767,  0x8b00a41,  0x51e08b1,  0x229027b,  0x98c0b03,  0x970096,  0xffff04c7,  0x8e700aa,  0x32b00d3,  0x190018,  0x62c062b,  0x1050104,  0x3cd0551,  0x9a203ce,  0xffffffff,  0x1690168,  0x75707ec,  0x1a70758,  0x52a077d,  0x301052b,  0xaba0302,  0x2560255,  0xffffffff,  0x91c091b,  0x1adffff,  0xffffffff,  0xffffffff,  0x9260925,  0x5de0927,  0x5e005df,  0xadf0ade,  0x4fb0ae0,  0x79604fc,  0xa570797,  0x7690a58,  0x43f076a,  0xa7a0440,  0x2fd0a7b,  0x54f02fe,  0x7680550,  0xb4e0b4d,  0x6530652,  0x16b016a,  0x5f805f7,  0x2c002bf,  0x6450644,  0xf200f1,  0x6a706a6,  0x56e056d,  0xab4ffff,  0xab60ab5,  0x7460745,  0x1ae022a,  0xb680b67,  0x1eb01ea,  0x4180417,  0x96d096c,  0x83d083c,  0x59d059c,  0x93c093b,  0x8ba08b9,  0x3ac03ab,  0x8940893,  0xb0c0b0b,  0x41a0419,  0x4090408,  0xa890a88,  0x2b402b3,  0x52f052e,  0x16d016c,  0x7ef07ee,  0x5b505b4,  0x8470846,  0xffff00d4,  0x6cc06cb,  0x640063,  0xb7d0b7c,  0xc200c1,  0x73c073b,  0x790078,  0x8860885,  0x5780577,  0x6f306f2,  0xffffffff,  0xffffffff,  0xffffffff,  0x7940a08,  0x4c80795,  0x95907bc,  0x14b028b,  0x690014c,  0x2d3041b,  0x9d109d0,  0x9220921,  0x3240323,  0x950094f,  0x9f109f0,  0xb190400,  0x687021d,  0xffff0525,  0x7f90b34,  0xabdffff,  0xa42ffff,  0xffff093d,  0xffffffff,  0xb28051f,  0x27cffff,  0xb70ffff,  0xffff00b5,  0xb04098d,  0x63a00f9,  0xffff0986,  0xabffff,  0x59effff,  0xffff08e8,  0x32cffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x31ffff,  0xffffffff,  0xffff0552,  0x9a30514,  0xffffffff,  0x350ffff,  0x41c07ed,  0x77e01a8,  0xffff02d4,  0xffffffff,  0xffffffff,  0xffff0abb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x92ffff,  0xffff070d,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x96effff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4a304a2,  0x1cf01ce,  0xffffffff,  0x1f601f5,  0xffffffff,  0xa31ffff,  0x86a0122,  0x382ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0299,  0x82406d5,  0xffff00eb,  0xffff07f0,  0x9c60b9a,  0x4b1ffff,  0x17c04ac,  0xab70a11,  0x16601d2,  0x96f0598,  0xb010b2c,  0x81a0962,  0x1060399,  0x62d0b6d,  0x688ffff,  0x605032d,  0xac0345,  0x6f808f9,  0x9a0848,  0x6d6029a,  0xec0825,  0x4b2ffff,  0x17d04ad,  0xab80a12,  0x16701d3,  0x9700599,  0xb020b2d,  0x81b0963,  0x107039a,  0x62e0b6e,  0x68a0689,  0x606032e,  0xad0346,  0x6f908fa,  0x9b0849,  0xb9b07f1,  0x97409c7,  0x59a04ae,  0xffffffff,  0x347ffff,  0x9750b6f,  0x18c018b,  0x4a704a6,  0xa830a82,  0x85b085a,  0x580057f,  0x9850984,  0x9db09da,  0x3ba03b9,  0x2f602f5,  0x8be08bd,  0x4480447,  0x3630362,  0x62f0b2e,  0x38301d6,  0xab9059b,  0xa7effff,  0x1d70a7f,  0x5d905d8,  0xa32ffff,  0x86b0123,  0x51804ef,  0x96a0291,  0x98a0aef,  0x5aa0090,  0x8f506fd,  0x8f300a0,  0x31d05ed,  0x38f009c,  0xb3f071d,  0x3bf053e,  0x3d106e5,  0xab0027d,  0x8660a86,  0x4b50126,  0x7a80808,  0x1b90a0e,  0x50f07ea,  0x2df0a6d,  0xac809a0,  0x15b0245,  0x6620579,  0xb550936,  0x61f09ea,  0x5303c1,  0xb40071e,  0x3c0053f,  0x3d206e6,  0xab1027e,  0x8670a87,  0x4b60127,  0x7a90809,  0x1ba0a0f,  0x51007eb,  0x2e00a6e,  0xac909a1,  0x15c0246,  0x663057a,  0xb560937,  0x62009eb,  0x5403c2,  0x51904f0,  0x96b0292,  0x98b0af0,  0x5ab0091,  0x8f606fe,  0x8f400a1,  0x31e05ee,  0x390009d,  0xa9d0a9c,  0x5cb05ca,  0x2440243,  0xb440b43,  0x1fa01f9,  0x3e403e3,  0x9b209b1,  0x8550854,  0x5a105a0,  0x8dc08db,  0x8c208c1,  0x3980397,  0x8840883,  0x9330932,  0x3dc03db,  0x4160415,  0xb1c0b1b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5a505a4,  0x8270826,  0xe600e5,  0x6ce06cd,  0x5e005d,  0x61a0619,  0x50004,  0x72e072d,  0xca00c9,  0x8a908a8,  0x5660565,  0x6b306b2,  0x10b010a,  0x4ee04ed,  0x1a0019f,  0xa0b0a0a,  0x4560455,  0x7b907b8,  0xb6a0b69,  0x82d082c,  0x4050404,  0x9bb09ba,  0x8ea08e9,  0x3260325,  0x8d608d5,  0x9f309f2,  0x3b603b5,  0x6c002db,  0x21f06c1,  0x5d60220,  0x23705d7,  0xa1b0238,  0x49e0a1c,  0x790049f,  0x2dc0791,  0x23c023b,  0x55a0559,  0x2620261,  0x6e206e1,  0x580057,  0x6260625,  0x1e001d,  0x6770676,  0x1130112,  0x6750674,  0x2480247,  0x5680567,  0x11b011a,  0x7a707a6,  0x4990498,  0x7760775,  0xa8b0a8a,  0x4680467,  0x2360235,  0xafa0af9,  0x38a0389,  0x42a0429,  0x90a0909,  0x8c608c5,  0x3380337,  0x920091f,  0x9fb09fa,  0x3d603d5,  0x8210820,  0xa8f0a8e,  0x7990798,  0x1cb01ca,  0xa160a15,  0x2c402c3,  0x4ea04e9,  0x1710170,  0x6a306a2,  0x5b905b8,  0x64b064a,  0x2c002b,  0x6370636,  0x380037,  0xb640b63,  0xb400b3,  0x7360735,  0xac70ac6,  0x88a0889,  0x4ec04eb,  0xb9cffff,  0x227017e,  0x71704b3,  0xa940293,  0x84e0abe,  0x587047b,  0x6d303a5,  0x1330b5d,  0x67a0384,  0x3030352,  0x67c08ff,  0x1350928,  0x6d705b2,  0xb210945,  0x8560a00,  0x4ff0522,  0x7130295,  0x22f0a37,  0x5da0184,  0xffff0785,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xb9dffff,  0x228017f,  0x71804b4,  0xa950294,  0x84f0abf,  0x588047c,  0x6d403a6,  0x1340b5e,  0x67b0385,  0x3040353,  0x67d0900,  0x1360929,  0x6d805b3,  0xb220946,  0x8570a01,  0x5000523,  0x7140296,  0x2300a38,  0x5db0185,  0xffff0786,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x81e09b3,  0x50b03e9,  0x6f401f0,  0x1b10b88,  0x4830241,  0x1b70496,  0xa980a96,  0x46b0878,  0x7fc0569,  0xaf1069e,  0x39100f7,  0x42f0646,  0x90502d9,  0x8bf068d,  0x33b014f,  0x9130670,  0x9e40b49,  0x3cf084a,  0x2e10108,  0xaa2ffff,  0xffffffff,  0xffffffff,  0xa4fffff,  0xffffffff,  0xae10153,  0x3fa0697,  0x42b05c2,  0x92e0666,  0x317002d,  0x3c705ef,  0x9ec0025,  0x9230b35,  0x55b008c,  0x85806ae,  0x9a70ada,  0x427087e,  0x21504fd,  0xa04075f,  0x24901da,  0x71104d1,  0xaa802a1,  0x8140994,  0x58503df,  0x6ea03c9,  0x11e0b2f,  0xffff039d,  0xeffff,  0x6930901,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x43105d4,  0x36000c3,  0x81206be,  0x930006d,  0x374088f,  0x9f60b23,  0x8b70601,  0x335007e,  0x1f70a67,  0xa5502cd,  0x95106b6,  0x55d0137,  0xb7807d8,  0x7c60573,  0x4dd0489,  0x75b09e8,  0x2e7044d,  0x64c0378,  0x141084c,  0x6a0099c,  0x41045b,  0x8970915,  0x450b96,  0x6320313,  0x23309ad,  0xb6109dc,  0x820271,  0x7370541,  0xa060ad8,  0x77b0715,  0x1e40526,  0x4b708b2,  0x9f80289,  0x3ad06d9,  0x5b601fb,  0x8040b1d,  0x34c05dc,  0x35a0678,  0x2ad0139,  0x92a0684,  0xb7e004b,  0x38b0621,  0x4370061,  0xffffffff,  0xb7f004c,  0x38c0622,  0x4380062,  0xffffffff,  0x6e70540,  0x5110a10,  0xa700a6f,  0x5cc0938,  0xffff069b,  0xffffffff,  0xffffffff,  0xffffffff,  0xae20154,  0x3fb0698,  0x42c05c3,  0x92f0667,  0x318002e,  0x3c805f0,  0x9ed0026,  0x9240b36,  0x55c008d,  0x85906af,  0x9a80adb,  0x428087f,  0x21604fe,  0xa050760,  0x24a01db,  0x71204d2,  0xaa902a2,  0x8150995,  0x58603e0,  0x6eb03ca,  0x11f0b30,  0xffff039e,  0xfffff,  0x6940902,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x505ffff,  0xffffffff,  0x30dffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0b8c,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x6f106f0,  0x4c604c5,  0x7740773,  0xb810b80,  0x8010800,  0x4720471,  0x9810980,  0x260025f,  0x5760575,  0x9040903,  0x8f008ef,  0x3340333,  0x2cc02cb,  0x910090f,  0x45a0459,  0x3d403d3,  0xafe0afd,  0x7c507c4,  0x4dc04db,  0xa180a17,  0x1ac01ab,  0x5c905c8,  0x240023f,  0x72a0729,  0xdb00da,  0x83b083a,  0x60005f,  0x6140613,  0x130012,  0x60c060b,  0x2a402a3,  0x6920691,  0x15e015d,  0x6b506b4,  0x5af05ae,  0x79d079c,  0xa5e0a5d,  0x4910490,  0x2080207,  0xb540b53,  0x20e020d,  0x3de03dd,  0x9420941,  0x8770876,  0x3550354,  0x8fc08fb,  0x8ce08cd,  0x37d037c,  0x8810880,  0x95e095d,  0x3d803d7,  0x2040203,  0xb380b37,  0x1b601b5,  0x47e047d,  0xa3c0a3b,  0x7db07da,  0x5c105c0,  0x80d080c,  0x14e014d,  0x65b065a,  0x2ac02ab,  0x6310630,  0x4a0049,  0x61c061b,  0x890088,  0x89f089e,  0x53d053c,  0x7340733,  0x2060205,  0x4c004bf,  0x1d101d0,  0xa540a53,  0x43e043d,  0x7cf07ce,  0xffffffff,  0xffffffff,  0x882ffff,  0xffffffff,  0xffff08ec,  0x3080307,  0x8e408e3,  0x9c509c4,  0x3a203a1,  0x2540253,  0xad70ad6,  0x42e042d,  0x7e307e2,  0xa200a1f,  0x7af07ae,  0x4c204c1,  0x720071f,  0x21a0219,  0x5440543,  0x990098,  0x7020701,  0xa300a2,  0x5f605f5,  0x4e004d,  0x6510650,  0x1250124,  0xaf40af3,  0x2f402f3,  0x5310530,  0x1170116,  0x770076f,  0x4950494,  0x7b307b2,  0xa6a0a69,  0x3f503f4,  0x24e024d,  0xb770b76,  0x3bc03bb,  0x43a0439,  0x8d008cf,  0x8f208f1,  0x35f035e,  0x91e091d,  0x9910990,  0x54a0549,  0x8a108a0,  0xa720a71,  0x450044f,  0x19a0199,  0xa440a43,  0x1d501d4,  0x6de06dd,  0xee00ed,  0x3a70603,  0x9fc0035,  0x94b0b3b,  0x55300f3,  0x3a80604,  0x9fd0036,  0x94c0b3c,  0x55400f4,  0xa2f076b,  0x22b019d,  0x6f604cb,  0xffffffff,  0xa30076c,  0x22c019e,  0x6f704cc,  0xffffffff,  0x5fd039b,  0x160305,  0x67e08e5,  0x172086c,  0x5fe039c,  0x170306,  0x67f08e6,  0x173086d,  0xa3302e5,  0x1820ac2,  0x4a801a3,  0x1e0078c,  0xa3402e6,  0x1830ac3,  0x4a901a4,  0x1e1078d,  0x34e0074,  0x35605e1,  0x8bb000a,  0xffffffff,  0x34f0075,  0x35705e2,  0x8bc000b,  0xffffffff,  0x1e6ffff,  0xa59ffff,  0x4d3ffff,  0x76dffff,  0x1e7ffff,  0xa5affff,  0x4d4ffff,  0x76effff,  0x2c5098e,  0x654043b,  0x2903b1,  0x5e30b86,  0x2c6098f,  0x655043c,  0x2a03b2,  0x5e40b87,  0x2ed0445,  0x9d202d5,  0x2090a6b,  0x41d05cd,  0x808df,  0xa510aaa,  0x6170321,  0xffffffff,  0x9640b15,  0x3a30285,  0x2c10664,  0x8ed012a,  0x9650b16,  0x3a40286,  0x2c20665,  0x8ee012b,  0x3b706df,  0x9ee028f,  0x7f20b0d,  0x5b001fd,  0x3b806e0,  0x9ef0290,  0x7f30b0e,  0x5b101fe,  0xb7409de,  0xdc09af,  0x73d058e,  0x7c0281,  0xb7509df,  0xdd09b0,  0x73e058f,  0x7d0282,  0x6680370,  0x978ffff,  0xffffffff,  0xffffffff,  0x6690371,  0x2ee0446,  0xffff0979,  0xffff0971,  0xffffffff,  0xf5ffff,  0xffffffff,  0xffffffff,  0x9d302d6,  0x20a0a6c,  0xffff00f6,  0xffffffff,  0x35c00bb,  0xffffffff,  0xffffffff,  0xffffffff,  0x35d00bc,  0x41e05ce,  0xffffffff,  0xffffffff,  0x1c30176,  0xffffffff,  0x29bffff,  0xffffffff,  0x1c40177,  0xa520aab,  0xffff029c,  0xffffffff,  0xffffffff,  0x3bdffff,  0xffffffff,  0xffffffff,  0x908e0,  0x6180322,  0xffff03be,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff06fa,  0xffffffff,  0x9b90b27,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff094d,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff094e,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xa7307b0,  0x4570492,  0x1780765,  0xa3d09d6,  0x1ec0532,  0x70702f1,  0xde0ae5,  0x82a044b,  0xa7407b1,  0x4580493,  0x1790766,  0xa3e09d7,  0x1ed0533,  0x70802f2,  0xdf0ae6,  0x82b044c,  0xffffffff,  0x870ffff,  0xffff0871,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x594037a,  0xa60b1f,  0x7430816,  0x52803fc,  0x89509c8,  0xa8c020f,  0x7b40485,  0x18d0221,  0xa9a071b,  0x29d0102,  0x516085c,  0x9760b17,  0x93f065c,  0x595037b,  0xa70b20,  0x7440817,  0x52903fd,  0x89609c9,  0xa8d0210,  0x7b50486,  0x18e0222,  0xa9b071c,  0x29e0103,  0x517085d,  0x9770b18,  0x940065d,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x65603c5,  0x10c0ae7,  0x6b00828,  0x5090441,  0x8680a49,  0xaac01c8,  0x751049a,  0x225020b,  0xb590709,  0x2770536,  0x40a080e,  0x98200a8,  0x9390703,  0x5a2002f,  0x9570638,  0x8cb003b,  0x39f066e,  0x8720151,  0xb050682,  0x3e505d2,  0x40207d0,  0xa9e0114,  0x2e304b9,  0x53801bb,  0x65703c6,  0x10d0ae8,  0x6b10829,  0x50a0442,  0x8690a4a,  0xaad01c9,  0x752049b,  0x226020c,  0xb5a070a,  0x2780537,  0x40b080f,  0x98300a9,  0x93a0704,  0x5a30030,  0x9580639,  0x8cc003c,  0x3a0066f,  0x8730152,  0xb060683,  0x3e605d3,  0x40307d1,  0xa9f0115,  0x2e404ba,  0x53901bc,  0x3a0039,  0x30e063b,  0xa090032,  0x9d407bd,  0x37e09d5,  0x265037f,  0xb1a0266,  0x401059f,  0xffff021e,  0xa140a13,  0x74bffff,  0xffff074c,  0xffffffff,  0xffffffff,  0xffffffff,  0x28c095a,  0x2a602a5,  0x33a0339,  0x8c808c7,  0x90e090d,  0x3730372,  0x2b902b8,  0x9930992,  0x46e046d,  0x7fb07fa,  0xb500b4f,  0x7780777,  0x4b004af,  0xa600a5f,  0x1e901e8,  0x56c056b,  0xd600d5,  0x7280727,  0x660065,  0x8a508a4,  0x20001f,  0x6280627,  0x5a0059,  0xb140b13,  0x2640263,  0x6bd06bc,  0x190018f,  0x7bf07be,  0x5bb05ba,  0x74e074d,  0xa360a35,  0x4e004df,  0x280027f,  0xafc0afb,  0x3aa03a9,  0x470046f,  0x9540953,  0x8d208d1,  0x3280327,  0x92d092c,  0x9bd09bc,  0x57c057b,  0x82f082e,  0xaa70aa6,  0x420041f,  0x2180217,  0xa0d0a0c,  0x1a601a5,  0x70c070b,  0x10f010e,  0x81d081c,  0xffffffff,  0xffffffff,  0xffffffff,  0x358ffff,  0x3290359,  0xffff032a,  0xffffffff,  0x6d006cf,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x81f09b4,  0x50c03ea,  0x6f501f1,  0x1b20b89,  0x4840242,  0x1b80497,  0xa990a97,  0x46c0879,  0x7fd056a,  0xaf2069f,  0x39200f8,  0x4300647,  0x90602da,  0x8c0068e,  0x33c0150,  0x9140671,  0x9e50b4a,  0x3d0084b,  0x2e20109,  0xaa3ffff,  0xffffffff,  0xffffffff,  0xa50ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1d901d8,  0xa1a0a19,  0xa930a92,  0x79b079a,  0x140013f,  0x69d069c,  0x2bb02ba,  0x4f404f3,  0x3e003d,  0x6410640,  0x5bd05bc,  0x6490648,  0x770076,  0x73a0739,  0x40003f,  0xb660b65,  0x4e804e7,  0x7820781,  0xacf0ace,  0x88e088d,  0x2c802c7,  0xac10ac0,  0x17b017a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5130512,  0x2980297,  0x9480947,  0x9ff09fe,  0x7ad07ac,  0xa7d0a7c,  0xa3a0a39,  0x18a0189,  0x7480747,  0xaf00ae,  0x8880887,  0x52d052c,  0x5ea05e9,  0x340033,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x70006,  0x8a708a6,  0xc600c5,  0x6ef06ee,  0xe800e7,  0x60e060d,  0x680067,  0xffffffff,  0x1580157,  0x8310830,  0xb460b45,  0x5020501,  0x9bf09be,  0xa260a25,  0x2b002af,  0x87b087a,  0x95c095b,  0x97d097c,  0x3940393,  0xb580b57,  0x8510850,  0x3120311,  0x330032f,  0x2120211,  0x5a705a6,  0x40f040e,  0x9890988,  0x51b051a,  0x8650864,  0x23e023d,  0xa220a21,  0xff00fe,  0x66b066a,  0xb0a0b09,  0x6a506a4,  0x1560155,  0x65f065e,  0x2ea02e9,  0x69a0699,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x7a0ffff,  0x4d507a1,  0x50604d6,  0xb6c0b6b,  0x5840583,  0x9b609b5,  0xacb0aca,  0x8410840,  0xffffffff,  0x4fffff,  0xb710050,  0xffffffff,  0xb080b07,  0x24c024b,  0xffff078e,  0x3b003af,  0x7d707d6,  0x49d049c,  0x3f903f8,  0x9cb09ca,  0x50e050d,  0x27a0279,  0x80b080a,  0x11d011c,  0x7060705,  0x93e00b6,  0x9870b29,  0xffff00fa,  0x351070e,  0xb5b0093,  0x5e805e7,  0x9f009e,  0x6e406e3,  0x13e013d,  0x54e054d,  0x28e028d,  0x8030802,  0x4340433,  0x515078f,  0x7590b8d,  0x174075a,  0xffff0175,  0xffffffff,  0xffffffff,  0x2f802f7,  0xffffffff,  0xffffffff,  0x310030f,  0xaec0aeb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x9e6ffff,  0xffff09e7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xb5cffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x43205d5,  0x36100c4,  0x81306bf,  0x931006e,  0x3750890,  0x9f70b24,  0x8b80602,  0x336007f,  0x1f80a68,  0xa5602ce,  0x95206b7,  0x55e0138,  0xb7907d9,  0x7c70574,  0x4de048a,  0x75c09e9,  0x2e8044e,  0x64d0379,  0x142084d,  0x6a1099d,  0x42045c,  0x8980916,  0x460b97,  0x6330314,  0x23409ae,  0xb6209dd,  0x830272,  0x7380542,  0xa070ad9,  0x77c0716,  0x1e50527,  0x4b808b3,  0x9f9028a,  0x3ae06da,  0x5b701fc,  0x8050b1e,  0x34d05dd,  0x35b0679,  0x2ae013a,  0x92b0685,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x9c0ffff,  0x2670aed,  0x5a80143,  0x9490642,  0x74904cd,  0xb720771,  0x7c0013b,  0x3fe04f5,  0x54b0259,  0x2ef03eb,  0xa800aae,  0x19707a2,  0x5ff08c3,  0xffff0451,  0xffffffff,  0xffffffff,  0x9c1ffff,  0x2680aee,  0x5a90144,  0x94a0643,  0x74a04ce,  0xb730772,  0x7c1013c,  0x3ff04f6,  0x54c025a,  0x2f003ec,  0xa810aaf,  0x19807a3,  0x60008c4,  0xffff0452,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x74f0a61,  0x5be075d,  0x7e8012f,  0x9ab0aa4,  0xaf50955,  0x2dd099a,  0x4e104f7,  0x14507d2,  0x47700e9,  0x8c90634,  0x2cf0043,  0x36c0721,  0x40602d1,  0x25d0547,  0xb840147,  0x3800672,  0xac40a75,  0x479078a,  0x2310481,  0xb4b077f,  0x7500a62,  0x5bf075e,  0x7e90130,  0x9ac0aa5,  0xaf60956,  0x2de099b,  0x4e204f8,  0x14607d3,  0x47800ea,  0x8ca0635,  0x2d00044,  0x36d0722,  0x40702d2,  0x25e0548,  0xb850148,  0x3810673,  0xac50a76,  0x47a078b,  0x2320482,  0xb4c0780,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xad00a45,  0x73f07d4,  0x223056f,  0xaff0996,  0x9c2022d,  0x7920b39,  0x4a0024f,  0x761047f,  0x5c40331,  0x6a80343,  0x1bf0b31,  0x6c70283,  0x28709a9,  0x64e03c3,  0x2702eb,  0x60908d3,  0xa270753,  0x8ac0a29,  0xffffffff,  0xffffffff,  0xad10a46,  0x74007d5,  0x2240570,  0xb000997,  0x9c3022e,  0x7930b3a,  0x4a10250,  0x7620480,  0x5c50332,  0x6a90344,  0x1c00b32,  0x6c80284,  0x28809aa,  0x64f03c4,  0x2802ec,  0x60a08d4,  0xa280754,  0x8ad0a2a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x461088b,  0x26b00a4,  0xae306aa,  0x2510110,  0x9430b3d,  0xffff00b7,  0x8f705e5,  0x8fd00b9,  0x7ca0806,  0x1310b41,  0x55f0832,  0x2ff03e1,  0x4210581,  0xffff02a7,  0x7630a23,  0x4e30475,  0x63c0a2b,  0xffff03b3,  0x6d102c9,  0x88cffff,  0xa50462,  0x6ab026c,  0x1110ae4,  0xb3e0252,  0xb80944,  0x5e6ffff,  0xba08f8,  0x80708fe,  0xb4207cb,  0x8330132,  0x3e20560,  0x5820300,  0x2a80422,  0xa24ffff,  0x4760764,  0xa2c04e4,  0x3b4063d,  0x2caffff,  0xffff06d2,  0xffffffff,  0x48704cf,  0x1490191,  0x7e00b8e,  0x57101e2,  0x3e70695,  0x44305c6,  0xa8407e6,  0x3090a47,  0xb8a0911,  0xc7090b,  0x72b0341,  0x8a0891,  0x862045f,  0x1000966,  0x7190899,  0x7a0366,  0x5200201,  0x33f04bd,  0xad40a63,  0x463079e,  0x838095f,  0x53a0469,  0x6e80239,  0x1bd0b90,  0x9e002fb,  0xffff066c,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x48804d0,  0x14a0192,  0x7e10b8f,  0x57201e3,  0x3e80696,  0x44405c7,  0xa8507e7,  0x30a0a48,  0xb8b0912,  0xc8090c,  0x72c0342,  0x8b0892,  0x8630460,  0x1010967,  0x71a089a,  0x7b0367,  0x5210202,  0x34004be,  0xad50a64,  0x464079f,  0x8390960,  0x53b046a,  0x6e9023a,  0x1be0b91,  0x9e102fc,  0xffff066d,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1dc057d,  0xb9207a4,  0x1c101a9,  0x4e5048e,  0x36e00cf,  0x83e0731,  0x97a00ef,  0x45d0844,  0x15f0b0f,  0x68b086e,  0x2d7034a,  0x60f08dd,  0xa650364,  0x8420ab2,  0x5550453,  0x6b803cb,  0x1dd057e,  0xb9307a5,  0x1c201aa,  0x4e6048f,  0x36f00d0,  0x83f0732,  0x97b00f0,  0x45e0845,  0x1600b10,  0x68c086f,  0x2d8034b,  0x61008de,  0xa660365,  0x8430ab3,  0x5560454,  0x6b903cc,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x99e0084,  0x31f0723,  0x410025b,  0x40c05f3,  0x9170069,  0x56106db,  0x3480010,  0xa020615,  0x4aa0473,  0x19507aa,  0x6ec030b,  0x1ee0aa0,  0x8a204f1,  0xae906c9,  0x9e20a4d,  0x50307b6,  0x99f0085,  0x3200724,  0x411025c,  0x40d05f4,  0x918006a,  0x56206dc,  0x3490011,  0xa030616,  0x4ab0474,  0x19607ab,  0x6ed030c,  0x1ef0aa1,  0x8a304f2,  0xaea06ca,  0x9e30a4e,  0x50407b7,  0x3f60658,  0x8ae0055,  0x8d705eb,  0x4350023,  0x3760596,  0xbf,  0x8100741,  0x5070534,  0x207ba,  0x755019b,  0x44904a4,  0xa90033d,  0x2730af7,  0x545016e,  0x99806ac,  0x9ce0b98,  0x140368,  0x3f70659,  0x8af0056,  0x8d805ec,  0x4360024,  0x3770597,  0x100c0,  0x8110742,  0x5080535,  0x307bb,  0x756019c,  0x44a04a5,  0xa91033e,  0x2740af8,  0x546016f,  0x99906ad,  0x9cf0b99,  0x150369,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff]);
//11648 bytes
enum fullCaseTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x40,  0x280], [ 0x100,  0x480,  0x11c0], [ 0x2020100,  0x4020302,  0x6020205,  0x7020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x10000,  0x30002,  0x50004,  0x70006,  0x90008,  0xa,  0xb0000,  0xd000c,  0xf000e,  0x110010,  0x130012,  0x14,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x160015,  0x0,  0x0,  0x0,  0x0,  0x0,  0x180017,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x19,  0x1a0000,  0x1b,  0x1d001c,  0x1f001e,  0x210020,  0x230022,  0x0,  0x0,  0x250024,  0x26,  0x0,  0x0,  0x0,  0x0,  0x0,  0x280027,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2a0029,  0x2c002b,  0x2d,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2e0000,  0x2f,  0x310030,  0x330032,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x340000,  0x35,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x36,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x380037,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3a0039,  0x3c003b,  0x3d0000,  0x3e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x40003f,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x420041,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x430000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x450044,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x9beffff,  0x984008a,  0x3440658,  0x9ac00c7,  0xa7c0c6a,  0xbf40074,  0x8b10736,  0xb9100ef,  0x4a608c3,  0x62905e6,  0xae607fe,  0x1ac0199,  0x5210569,  0xffff0320,  0xffffffff,  0xffffffff,  0x9bfffff,  0x985008b,  0x3450659,  0x9ad00c8,  0xa7d0c6b,  0xbf50075,  0x8b20737,  0xb9200f0,  0x4a708c4,  0x62a05e7,  0xae707ff,  0x1ad019a,  0x522056a,  0xffff0321,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xa0bffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x60507f2,  0x8e3012e,  0xa640b9a,  0x4120277,  0x3c105a6,  0xc18013e,  0x3c9068a,  0x340004e,  0x97c0650,  0x2c20090,  0x5da0781,  0xffff00d5,  0xa2a0ba7,  0x5430230,  0x9110771,  0xba20af9,  0x60607f3,  0x8e4012f,  0xa650b9b,  0x4130278,  0x3c205a7,  0xc19013f,  0x3ca068b,  0x341004f,  0x97d0651,  0x2c30091,  0x5db0782,  0xffff00d6,  0xa2b0ba8,  0x5440231,  0x9120772,  0x39b0afa,  0xa890a88,  0x5120511,  0x1e601e5,  0xc230c22,  0x21d021c,  0x7a607a5,  0xd800d7,  0x9460945,  0x650064,  0x6730672,  0x5b005a,  0x67f067e,  0x2d802d7,  0x6c406c3,  0x1730172,  0x8890888,  0xc550c54,  0x8680867,  0x5040503,  0xb180b17,  0x1cd01cc,  0x5e505e4,  0x2390238,  0xa140a13,  0xffff03f6,  0x90a0909,  0x9dd09dc,  0x3470346,  0x9effff,  0x76d009f,  0x98076e,  0x8a70099,  0xbf908a8,  0x8440bfa,  0x1360845,  0xad60137,  0x31a0ad7,  0x5240523,  0x83f083e,  0xc310c30,  0x72a0729,  0x17b017a,  0x6eb06ea,  0x2d002cf,  0x6690668,  0xf000e,  0x6a0069f,  0x790078,  0x8c608c5,  0xdc00db,  0x79c079b,  0x1fb01fa,  0xc4d0c4c,  0x1bb01ba,  0x50c050b,  0xb080b07,  0x84b084a,  0x5b305b2,  0xa1e0a1d,  0xaab0aaa,  0x684039c,  0x250685,  0x65a0026,  0x62b065b,  0x6f006f9,  0xbe00bdf,  0x28a0289,  0x2950571,  0xc020296,  0x1c80881,  0xffff01c9,  0xb8107e0,  0x94e0afb,  0x56b094f,  0x247029b,  0xa380bd0,  0xa100a0,  0xffff050f,  0x98a00b4,  0x35600dd,  0x1d001c,  0x68d068c,  0x1180117,  0x40605a0,  0xa4e0407,  0xffffffff,  0x1820181,  0x7d00874,  0x1c007d1,  0x57707f8,  0x3280578,  0xb7f0329,  0x2760275,  0xffffffff,  0x9c109c0,  0x1c6ffff,  0xffffffff,  0xffffffff,  0x9ce09cd,  0x63b09cf,  0x63d063c,  0xbaa0ba9,  0x5450bab,  0x8120546,  0xb130813,  0x7e20b14,  0x47c07e3,  0xb39047d,  0x3240b3a,  0x59e0325,  0x7e1059f,  0xc1f0c1e,  0x6b606b5,  0x1840183,  0x6570656,  0x2e602e5,  0x6a606a5,  0x1010100,  0x7140713,  0x5bd05bc,  0xb790928,  0xb7b0b7a,  0x7bf07be,  0x1c70248,  0xc390c38,  0x2070206,  0x4550454,  0xa180a17,  0x8ce08cd,  0x5f105f0,  0x9e409e3,  0x95b095a,  0x3e103e0,  0x92d092c,  0xbd90bd8,  0x4570456,  0x4460445,  0xb480b47,  0x2da02d9,  0x57c057b,  0x1860185,  0x8770876,  0x60f060e,  0x8d808d7,  0xffff00de,  0x73d073c,  0x6d006c,  0xc4f0c4e,  0xcc00cb,  0x7b407b3,  0x820081,  0x91b091a,  0x5c905c8,  0x7650764,  0xffffffff,  0xffffffff,  0xffffffff,  0x8100abe,  0x5100811,  0xa030838,  0x16402ad,  0x6fa0165,  0x2fa0458,  0xa810a80,  0x9c709c6,  0x34f034e,  0x9fa09f9,  0xaa70aa6,  0xbe8043b,  0x6f1023a,  0xffff0572,  0x8820c03,  0xb82ffff,  0xafcffff,  0xffff09e5,  0xffffffff,  0xbf7056c,  0x29cffff,  0xc41ffff,  0xffff00bf,  0xbd10a39,  0x69b0109,  0xffff0a32,  0xb5ffff,  0x5f7ffff,  0xffff098b,  0x357ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x35ffff,  0xffffffff,  0xffff05a1,  0xa4f055f,  0xffffffff,  0x380ffff,  0x4590875,  0x7f901c1,  0xffff02fb,  0xffffffff,  0xffffffff,  0xffff0b80,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x9cffff,  0xffff077f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xa19ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4e604e5,  0x1e801e7,  0xffffffff,  0x2120211,  0xffffffff,  0xaeaffff,  0x8ff0138,  0x3b3ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff02bc,  0x8b30746,  0xffff00fa,  0xffff0878,  0xa750c70,  0x4f90883,  0x19504f1,  0xb7c0aca,  0x17f01eb,  0xa1a05ec,  0xbce0bfb,  0x8a90a0c,  0x11903cd,  0x68e0c3e,  0x6f2ffff,  0x6660358,  0xb60372,  0x76a099e,  0xa408d9,  0x74702bd,  0xfb08b4,  0x4fa0a79,  0x19604f2,  0xb7d0acb,  0x18001ec,  0xa1b05ed,  0xbcf0bfc,  0x8aa0a0d,  0x11a03ce,  0x68f0c3f,  0x6f406f3,  0x6670359,  0xb70373,  0x76b099f,  0xa508da,  0xc710879,  0xa1f0a76,  0x5ee04f3,  0xffffffff,  0x374ffff,  0xa200c40,  0x1a501a4,  0x4ec04eb,  0xb420b41,  0x8f008ef,  0x5d105d0,  0xa310a30,  0xa8b0a8a,  0x3f003ef,  0x31d031c,  0x95f095e,  0x4850484,  0x3940393,  0x6900bfd,  0x3b401ef,  0xb7e05ef,  0xb3dffff,  0x1f00b3e,  0x6310630,  0xaebffff,  0x9000139,  0x5650539,  0xa1502b4,  0xa360bba,  0x603009a,  0x99a076f,  0x99800aa,  0x348064a,  0x3c300a6,  0xc0e0790,  0x3f8058d,  0x40a0757,  0xb72029d,  0x8fb0b45,  0x4fd013c,  0x8240894,  0x1d20ac4,  0x55a0872,  0x3060b2c,  0xb8d0a4c,  0x1740265,  0x6c505ca,  0xc2609de,  0x6800a9d,  0x5c03fc,  0xc0f0791,  0x3f9058e,  0x40b0758,  0xb73029e,  0x8fc0b46,  0x4fe013d,  0x8250895,  0x1d30ac5,  0x55b0873,  0x3070b2d,  0xb8e0a4d,  0x1750266,  0x6c605cb,  0xc2709df,  0x6810a9e,  0x5d03fd,  0x566053a,  0xa1602b5,  0xa370bbb,  0x604009b,  0x99b0770,  0x99900ab,  0x349064b,  0x3c400a7,  0xb5c0b5b,  0x6250624,  0x2640263,  0xc130c12,  0x2160215,  0x41d041c,  0xa5f0a5e,  0x8e608e5,  0x5f605f5,  0x97f097e,  0x9630962,  0x3cc03cb,  0x9190918,  0x9db09da,  0x4150414,  0x4530452,  0xbeb0bea,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5fe05fd,  0x8b608b5,  0xf500f4,  0x73f073e,  0x670066,  0x67b067a,  0x50004,  0x7a407a3,  0xd400d3,  0x9440943,  0x5b505b4,  0x7220721,  0x11e011d,  0x5380537,  0x1b901b8,  0xac10ac0,  0x4950494,  0x8350834,  0xc3b0c3a,  0x8bc08bb,  0x4420441,  0xa680a67,  0x98d098c,  0x3510350,  0x9770976,  0xaa90aa8,  0x3eb03ea,  0x7310302,  0x23c0732,  0x632023d,  0x2550633,  0xad40256,  0x4e10ad5,  0x80c04e2,  0x303080d,  0x25a0259,  0x5a905a8,  0x2820281,  0x7540753,  0x610060,  0x6870686,  0x220021,  0x6e006df,  0x1290128,  0x6db06da,  0x2680267,  0x5b705b6,  0x1310130,  0x8230822,  0x4dc04db,  0x7ef07ee,  0xb4a0b49,  0x4a904a8,  0x2540253,  0xbc50bc4,  0x3be03bd,  0x4670466,  0x9af09ae,  0x9670966,  0x3650364,  0x9c509c4,  0xab10ab0,  0x40f040e,  0x8b008af,  0xb4e0b4d,  0x8150814,  0x1e401e3,  0xacf0ace,  0x2eb02ea,  0x5340533,  0x18a0189,  0x710070f,  0x6130612,  0x6ac06ab,  0x30002f,  0x6980697,  0x3c003b,  0xc350c34,  0xbe00bd,  0x7ae07ad,  0xb8c0b8b,  0x9230922,  0x5360535,  0xc72ffff,  0x2450197,  0x78904fb,  0xb5302b6,  0x8df0b83,  0x5d804be,  0x74403da,  0x14a0c2e,  0x6e403b5,  0x32a0382,  0x6e609a4,  0x14c09d0,  0x748060c,  0xbf009ed,  0x8e70ab6,  0x549056f,  0x78502b8,  0x24d0af0,  0x637019d,  0xffff0800,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xc73ffff,  0x2460198,  0x78a04fc,  0xb5402b7,  0x8e00b84,  0x5d904bf,  0x74503db,  0x14b0c2f,  0x6e503b6,  0x32b0383,  0x6e709a5,  0x14d09d1,  0x749060d,  0xbf109ee,  0x8e80ab7,  0x54a0570,  0x78602b9,  0x24e0af1,  0x638019e,  0x6620801,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x8ad0a60,  0x5560422,  0x766020c,  0x1ca0c5e,  0x4c60261,  0x1d004d9,  0xb570b55,  0x4ac090d,  0x88605b8,  0xbbc070b,  0x3c50107,  0x46c06a7,  0x9aa0300,  0x96006f7,  0x3680168,  0x9b806d4,  0xa970c1a,  0x40808db,  0x308011b,  0xb61ffff,  0xffffffff,  0xffffffff,  0xb0bffff,  0xffffffff,  0xbac016c,  0x4350702,  0x468061c,  0x9d606ca,  0x3420031,  0x3fe064c,  0xaa10029,  0x9cb0c04,  0x5aa0096,  0x8eb071d,  0xa530ba5,  0x4640913,  0x2320547,  0xaba07d8,  0x26901f3,  0x7830519,  0xb6802c4,  0x8a30a40,  0x5d60418,  0x75c0400,  0x1340bfe,  0xffff03d1,  0x10ffff,  0x6fd09a6,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x46e062e,  0x39100cd,  0x8a1072f,  0x9d80076,  0x3a5093b,  0xaac0bf2,  0x9580660,  0x362008c,  0x2130b24,  0xb1102f4,  0x9fb0725,  0x5ac014e,  0xc4a085b,  0x84205c4,  0x52704cc,  0x7d40a9b,  0x30e048a,  0x6ad03a9,  0x15808dd,  0x70d0a48,  0x4a049a,  0x93009ba,  0x4c0c6c,  0x693033e,  0x2510a59,  0xc320a8c,  0x940291,  0x7af0590,  0xabc0ba0,  0x7f60787,  0x2000573,  0x4ff0953,  0xaae02ab,  0x3e2074a,  0x6100217,  0x8900c08,  0x37a0639,  0x39906ee,  0x2d30150,  0x9d20719,  0xc500054,  0x3bf0682,  0x474006a,  0xffffffff,  0xc510055,  0x3c00683,  0x475006b,  0xffffffff,  0x759058f,  0x55c0ac6,  0xb2f0b2e,  0x62609e0,  0xffff0708,  0xffffffff,  0xffffffff,  0xffffffff,  0xbad016d,  0x4360703,  0x469061d,  0x9d706cb,  0x3430032,  0x3ff064d,  0xaa2002a,  0x9cc0c05,  0x5ab0097,  0x8ec071e,  0xa540ba6,  0x4650914,  0x2330548,  0xabb07d9,  0x26a01f4,  0x784051a,  0xb6902c5,  0x8a40a41,  0x5d70419,  0x75d0401,  0x1350bff,  0xffff03d2,  0x11ffff,  0x6fe09a7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x561ffff,  0xffffffff,  0x338ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0c62,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x7630762,  0x50e050d,  0x7ed07ec,  0xc530c52,  0x88b088a,  0x4b304b2,  0xa2d0a2c,  0x280027f,  0x5c705c6,  0x9a909a8,  0x9950994,  0x3610360,  0x2f302f2,  0x9b509b4,  0x4990498,  0x40d040c,  0xbc90bc8,  0x8410840,  0x5260525,  0xad10ad0,  0x1c501c4,  0x6230622,  0x260025f,  0x7a0079f,  0xe500e4,  0x8ca08c9,  0x690068,  0x6750674,  0x150014,  0x66d066c,  0x2c702c6,  0x6fc06fb,  0x1770176,  0x7240723,  0x6080607,  0x8190818,  0xb1a0b19,  0x4d404d3,  0x2250224,  0xc250c24,  0x22b022a,  0x4170416,  0x9ea09e9,  0x90c090b,  0x3850384,  0x9a109a0,  0x96f096e,  0x3ae03ad,  0x9160915,  0xa080a07,  0x4110410,  0x2210220,  0xc070c06,  0x1cf01ce,  0x4c104c0,  0xaf60af5,  0x85e085d,  0x61b061a,  0x89c089b,  0x1670166,  0x6be06bd,  0x2d202d1,  0x6920691,  0x510050,  0x67d067c,  0x930092,  0x9380937,  0x58c058b,  0x7ac07ab,  0x2230222,  0x5080507,  0x1ea01e9,  0xb100b0f,  0x47b047a,  0x84d084c,  0xdf0c5c,  0x5ba03fa,  0x917049e,  0xffffffff,  0xffff0ba3,  0x3310330,  0x9870986,  0xa740a73,  0x3d603d5,  0x2740273,  0xb9f0b9e,  0x46b046a,  0x8660865,  0xad90ad8,  0x82b082a,  0x50a0509,  0x7930792,  0x2370236,  0x5930592,  0xa300a2,  0x7740773,  0xad00ac,  0x6550654,  0x570056,  0x6b406b3,  0x13b013a,  0xbbf0bbe,  0x3270326,  0x57e057d,  0x12d012c,  0x7e907e8,  0x4d804d7,  0x82f082e,  0xb270b26,  0x430042f,  0x26e026d,  0xc490c48,  0x3f203f1,  0x4770476,  0x9710970,  0x9970996,  0x390038f,  0x9c309c2,  0xa3d0a3c,  0x5990598,  0x93a0939,  0xb310b30,  0x48d048c,  0x1b301b2,  0xb000aff,  0x1ee01ed,  0x74f074e,  0xfd00fc,  0x3dc0664,  0xab20039,  0x9f30c0a,  0x5a20102,  0x3dd0665,  0xab3003a,  0x9f40c0b,  0x5a30103,  0xae807e4,  0x24901b6,  0x7680513,  0xffffffff,  0xae907e5,  0x24a01b7,  0x7690514,  0xffffffff,  0x65c03cf,  0x1a032c,  0x6e80988,  0x18b0901,  0x65d03d0,  0x1b032d,  0x6e90989,  0x18c0902,  0xaec030c,  0x19b0b87,  0x4ed01bc,  0x1fc0807,  0xaed030d,  0x19c0b88,  0x4ee01bd,  0x1fd0808,  0x37e007d,  0x386063e,  0x95c000c,  0xffffffff,  0x37f007e,  0x387063f,  0x95d000d,  0xffffffff,  0x2020085,  0xb1508ed,  0x51b0bec,  0x7e6072b,  0x203ffff,  0xb16ffff,  0x51cffff,  0x7e7ffff,  0x2ec0a3a,  0x6b70478,  0x2d03e6,  0x6400c5a,  0x2ed0a3b,  0x6b80479,  0x2e03e7,  0x6410c5b,  0x3140482,  0xa8202fc,  0x2260b2a,  0x45a0627,  0xa0982,  0xb0d0b6a,  0x678034c,  0xffffffff,  0xac70be3,  0x8560b76,  0x5f20794,  0x9910140,  0xac80be4,  0x8570b77,  0x5f30795,  0x9920141,  0x3ec0750,  0xaa30634,  0x9c80bda,  0x6090219,  0x3ed0751,  0xaa40635,  0x9c90bdb,  0x60a021a,  0xc450a90,  0xb1f0b95,  0x7b50947,  0x1f7054f,  0xc460a91,  0xb200b96,  0x7b60948,  0x1f80550,  0x6cc03a1,  0xa23048e,  0xffff0336,  0x3f0c43,  0x6cd03a2,  0x3150483,  0xffff0a24,  0xffff0a1c,  0xffffffff,  0xaf2084e,  0xffff0a9f,  0x51f0581,  0xa8302fd,  0x2270b2b,  0xffff0af3,  0xffffffff,  0x38d00c5,  0x884091e,  0xffffffff,  0x96c064e,  0x38e00c6,  0x45b0628,  0xffffffff,  0xffffffff,  0x1dc018f,  0xa7a08e9,  0x2be0c16,  0x4e707f4,  0x1dd0190,  0xb0e0b6b,  0xffff02bf,  0xffffffff,  0xffffffff,  0x6ff0a6b,  0xffff05d2,  0x6d8091c,  0xb0983,  0x679034d,  0xffff0700,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff076c,  0xffffffff,  0xa660bf6,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff09f7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff09f8,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xb32082c,  0x49604d5,  0x19107de,  0xaf70a86,  0x208057f,  0x7790318,  0xeb0bb0,  0x8b90488,  0xb33082d,  0x49704d6,  0x19207df,  0xaf80a87,  0x2090580,  0x77a0319,  0xec0bb1,  0x8ba0489,  0xffffffff,  0x905ffff,  0xffff0906,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5e803ab,  0xb00bee,  0x7bc08a5,  0x5750437,  0x92e0a77,  0xb4b022c,  0x83004c8,  0x1a60241,  0xb59078e,  0x2c00115,  0x56308f1,  0xa210be6,  0x9e706bf,  0x5e903ac,  0xb10bef,  0x7bd08a6,  0x5760438,  0x92f0a78,  0xb4c022d,  0x83104c9,  0x1a70242,  0xb5a078f,  0x2c10116,  0x56408f2,  0xa220be7,  0x9e806c0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x6b90402,  0x11f0bb2,  0x71f08b7,  0x554047e,  0x8fd0b05,  0xb6c01e1,  0x7ca04dd,  0x2430228,  0xc2a077b,  0x2970583,  0x447089d,  0xa2e00b2,  0x9e10775,  0x5f90033,  0xa010699,  0x9740045,  0x3d306d2,  0x907016a,  0xbd206ec,  0x41e062c,  0x43d0850,  0xb5d012a,  0x30a0501,  0x58501d4,  0x6ba0403,  0x1200bb3,  0x72008b8,  0x555047f,  0x8fe0b06,  0xb6d01e2,  0x7cb04de,  0x2440229,  0xc2b077c,  0x2980584,  0x448089e,  0xa2f00b3,  0x9e20776,  0x5fa0034,  0xa02069a,  0x9750046,  0x3d406d3,  0x908016b,  0xbd306ed,  0x41f062d,  0x43e0851,  0xb5e012b,  0x30b0502,  0x58601d5,  0x3e003d,  0x339069c,  0xabf0036,  0xa840839,  0x3af0a85,  0x28503b0,  0xbe90286,  0x43c05f8,  0xffff023b,  0xacd0acc,  0x7c4ffff,  0xffff07c5,  0xffffffff,  0xffffffff,  0xffffffff,  0x2ae0a04,  0x2c902c8,  0x3670366,  0x9690968,  0x9b309b2,  0x3a403a3,  0x2df02de,  0xa3f0a3e,  0x4af04ae,  0x88d088c,  0xc210c20,  0x7f107f0,  0x4f504f4,  0xb1c0b1b,  0x2050204,  0x5bf05be,  0xee00ed,  0x79e079d,  0x6f006e,  0x940093f,  0x240023,  0x6890688,  0x630062,  0xbe20be1,  0x2840283,  0x72e072d,  0x1a901a8,  0x83b083a,  0x6150614,  0x7c707c6,  0xaef0aee,  0x52a0529,  0x2a0029f,  0xbc70bc6,  0x3df03de,  0x4b104b0,  0x9fe09fd,  0x9730972,  0x3530352,  0x9d509d4,  0xa6a0a69,  0x5cd05cc,  0x8be08bd,  0xb670b66,  0x45d045c,  0x2350234,  0xac30ac2,  0x1bf01be,  0x77e077d,  0x1220121,  0x8ac08ab,  0xffffffff,  0xffffffff,  0xffffffff,  0x38bffff,  0x354038c,  0xffff0355,  0xffffffff,  0x7410740,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x8ae0a61,  0x5570423,  0x767020d,  0x1cb0c5f,  0x4c70262,  0x1d104da,  0xb580b56,  0x4ad090e,  0x88705b9,  0xbbd070c,  0x3c60108,  0x46d06a8,  0x9ab0301,  0x96106f8,  0x3690169,  0x9b906d5,  0xa980c1b,  0x40908dc,  0x309011c,  0xb62ffff,  0xffffffff,  0xffffffff,  0xb0cffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1f201f1,  0xad30ad2,  0xb520b51,  0x8170816,  0x1570156,  0x70a0709,  0x2e102e0,  0x53e053d,  0x420041,  0x6a206a1,  0x6170616,  0x6aa06a9,  0x80007f,  0x7b207b1,  0x440043,  0xc370c36,  0x5320531,  0x7fd07fc,  0xb940b93,  0x9270926,  0x2ef02ee,  0xb860b85,  0x1940193,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x55e055d,  0x2bb02ba,  0x9f009ef,  0xab50ab4,  0x8290828,  0xb3c0b3b,  0xafe0afd,  0x1a301a2,  0x7c107c0,  0xb900b8,  0x9210920,  0x57a0579,  0x6470646,  0x380037,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x90008,  0x9420941,  0xd000cf,  0x7610760,  0xf700f6,  0x66f066e,  0x710070,  0xffffffff,  0x1710170,  0x8c008bf,  0xc150c14,  0x54c054b,  0xa700a6f,  0xadf0ade,  0x2d602d5,  0x910090f,  0xa060a05,  0xa290a28,  0x3c803c7,  0xc290c28,  0x8e208e1,  0x33d033c,  0x35d035c,  0x22f022e,  0x60005ff,  0x44c044b,  0xa350a34,  0x5680567,  0x8fa08f9,  0x25c025b,  0xadb0ada,  0x1140113,  0x6cf06ce,  0xbd70bd6,  0x7120711,  0x16f016e,  0x6c206c1,  0x3110310,  0x7050704,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x81cffff,  0x51d081d,  0x562051e,  0xc3d0c3c,  0x5d505d4,  0xa630a62,  0xb900b8f,  0x8d208d1,  0xffffffff,  0x58ffff,  0xc420059,  0xffffffff,  0xbd50bd4,  0x26c026b,  0xffff0826,  0x3e503e4,  0x85a0859,  0x4e004df,  0x4340433,  0xa8f0a8e,  0x5590558,  0x29a0299,  0x89a0899,  0x1330132,  0x7780777,  0x9e600c0,  0xa330bf8,  0xffff010a,  0x3810780,  0xc2c009d,  0x6450644,  0xa900a8,  0x7560755,  0x1550154,  0x59d059c,  0x2b002af,  0x88f088e,  0x4710470,  0x5600827,  0x7d20c63,  0x18d07d3,  0xffff018e,  0xffffffff,  0xffffffff,  0x31f031e,  0xffffffff,  0xffffffff,  0x33b033a,  0xbb70bb6,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xa99ffff,  0xffff0a9a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xc2dffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x46f062f,  0x39200ce,  0x8a20730,  0x9d90077,  0x3a6093c,  0xaad0bf3,  0x9590661,  0x363008d,  0x2140b25,  0xb1202f5,  0x9fc0726,  0x5ad014f,  0xc4b085c,  0x84305c5,  0x52804cd,  0x7d50a9c,  0x30f048b,  0x6ae03aa,  0x15908de,  0x70e0a49,  0x4b049b,  0x93109bb,  0x4d0c6d,  0x694033f,  0x2520a5a,  0xc330a8d,  0x950292,  0x7b00591,  0xabd0ba1,  0x7f70788,  0x2010574,  0x5000954,  0xaaf02ac,  0x3e3074b,  0x6110218,  0x8910c09,  0x37b063a,  0x39a06ef,  0x2d40151,  0x9d3071a,  0x8c10bca,  0x5fb0148,  0xb630846,  0xffff0b64,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x9f5ffff,  0x4b4069d,  0x35a0016,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xa6dffff,  0x2870bb8,  0x601015a,  0x9f106a3,  0x7c20515,  0xc6607ea,  0x83c0152,  0x439053f,  0x59a0279,  0x3160426,  0xb3f0b6e,  0x1b0081e,  0x65e0964,  0xffff0490,  0xffffffff,  0xffffffff,  0xa6effff,  0x2880bb9,  0x602015b,  0x9f206a4,  0x7c30516,  0xc6707eb,  0x83d0153,  0x43a0540,  0x59b027a,  0x3170427,  0xb400b6f,  0x1b1081f,  0x65f0965,  0xffff0491,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x7c80b1d,  0x61807d6,  0x86d0146,  0xa570b70,  0xbc009ff,  0x3040a46,  0x52b0541,  0x15c0854,  0x4ba00f8,  0x96a0695,  0x2f60052,  0x39d0797,  0x44302f8,  0x27d0596,  0xc56015e,  0x3b106d6,  0xb890b34,  0x4bc0805,  0x24f04c4,  0xc1c07fa,  0x7c90b1e,  0x61907d7,  0x86e0147,  0xa580b71,  0xbc10a00,  0x3050a47,  0x52c0542,  0x15d0855,  0x4bb00f9,  0x96b0696,  0x2f70053,  0x39e0798,  0x44402f9,  0x27e0597,  0xc57015f,  0x3b206d7,  0xb8a0b35,  0x4bd0806,  0x25004c5,  0xc1d07fb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xb980b01,  0x7b80869,  0x25705c0,  0xbcc0a42,  0xa71024b,  0x80e0c10,  0x4e3026f,  0x7da04c2,  0x61e035e,  0x7150370,  0x1d80c00,  0x73802a4,  0x2a90a55,  0x6b10420,  0x2b0312,  0x66a0978,  0xae007cc,  0x94a0ae2,  0xffffffff,  0xffffffff,  0xb990b02,  0x7b9086a,  0x25805c1,  0xbcd0a43,  0xa72024c,  0x80f0c11,  0x4e40270,  0x7db04c3,  0x61f035f,  0x7160371,  0x1d90c01,  0x73902a5,  0x2aa0a56,  0x6b20421,  0x2c0313,  0x66b0979,  0xae107cd,  0x94b0ae3,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4a00924,  0x28b00ae,  0xbae0717,  0x2710123,  0x9eb0c0c,  0xffff00c1,  0x99c0642,  0x9a200c3,  0x8480892,  0x1600c58,  0x5ae08c7,  0x32e041a,  0x45e05dc,  0xffff02cd,  0x7dc0adc,  0x52d04b8,  0x6af0ae4,  0xffff03e8,  0x74202f0,  0x925ffff,  0xaf04a1,  0x718028c,  0x1240baf,  0xc0d0272,  0xc209ec,  0x643ffff,  0xc4099d,  0x89309a3,  0xc590849,  0x8c80161,  0x41b05af,  0x5dd032f,  0x2ce045f,  0xaddffff,  0x4b907dd,  0xae5052e,  0x3e906b0,  0x2f1ffff,  0xffff0743,  0xffffffff,  0x4ca0517,  0x16201aa,  0x8630c64,  0x5c201fe,  0x4240706,  0x4800620,  0xb43086b,  0x3320b03,  0xc6009b6,  0xd109b0,  0x7a1036e,  0xd9092a,  0x8f704a4,  0x1110a11,  0x7a70932,  0x830397,  0x56d021e,  0x36c0505,  0xb9c0b28,  0x4a2081a,  0x8cb0a09,  0x58904aa,  0x75a025d,  0x1d60002,  0xa930322,  0xffff06d0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4cb0518,  0x16301ab,  0x8640c65,  0x5c301ff,  0x4250707,  0x4810621,  0xb44086c,  0x3330b04,  0xc6109b7,  0xd209b1,  0x7a2036f,  0xda092b,  0x8f804a5,  0x1120a12,  0x7a80933,  0x840398,  0x56e021f,  0x36d0506,  0xb9d0b29,  0x4a3081b,  0x8cc0a0a,  0x58a04ab,  0x75b025e,  0x1d70003,  0xa940323,  0xffff06d1,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1f505ce,  0xc680820,  0x1da01c2,  0x52f04d1,  0x39f00e9,  0x8cf07a9,  0xa2600fe,  0x49c08d5,  0x1780bdd,  0x6f50903,  0x2fe0378,  0x6700980,  0xb220395,  0x8d30b74,  0x5a40492,  0x7270404,  0x1f605cf,  0xc690821,  0x1db01c3,  0x53004d2,  0x3a000ea,  0x8d007aa,  0xa2700ff,  0x49d08d6,  0x1790bde,  0x6f60904,  0x2ff0379,  0x6710981,  0xb230396,  0x8d40b75,  0x5a50493,  0x7280405,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xa4a008e,  0x34a0799,  0x44d027b,  0x4490652,  0x9bc0072,  0x5b0074c,  0x37c0012,  0xab80676,  0x4ef04b6,  0x1ae0836,  0x75e0334,  0x20a0b5f,  0x93d053b,  0xbb4073a,  0xa950b09,  0x54d0832,  0xa4b008f,  0x34b079a,  0x44e027c,  0x44a0653,  0x9bd0073,  0x5b1074d,  0x37d0013,  0xab90677,  0x4f004b7,  0x1af0837,  0x75f0335,  0x20b0b60,  0x93e053c,  0xbb5073b,  0xa960b0a,  0x54e0833,  0x43106bb,  0x94c005e,  0x97a0648,  0x4720027,  0x3a705ea,  0xc9,  0x89f07ba,  0x5520587,  0x60852,  0x7ce01b4,  0x48604e9,  0xb4f036a,  0x2930bc2,  0x5940187,  0xa44071b,  0xa7e0c6e,  0x18043f,  0x43206bc,  0x94d005f,  0x97b0649,  0x4730028,  0x3a805eb,  0x100ca,  0x8a007bb,  0x5530588,  0x70853,  0x7cf01b5,  0x48704ea,  0xb50036b,  0x2940bc3,  0x5950188,  0xa45071c,  0xa7f0c6f,  0x190440,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff]);
//5568 bytes
enum alphaTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x40,  0x1a0], [ 0x100,  0x2c0,  0x7a00], [ 0x3020100,  0x6050403,  0xa090807,  0xe0d0c0b,  0x3030303,  0x11100f03,  0x14141312,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x14141414,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000,  0x30002,  0x50004,  0x70006,  0x90008,  0xb000a,  0xd000c,  0xf000e,  0x10010,  0x120011,  0x10013,  0x150014,  0x170016,  0x190018,  0x1b001a,  0x1c0001,  0x1e001d,  0x1f001f,  0x1f0020,  0x1f001f,  0x1f001f,  0x1f001f,  0x220021,  0x1f0023,  0x250024,  0x1f001f,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x260001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10027,  0x290028,  0x2b002a,  0x2d002c,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x2e0001,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1001f,  0x30002f,  0x310001,  0x330032,  0x350034,  0x370036,  0x390038,  0x3a0001,  0x3c003b,  0x3e003d,  0x40003f,  0x420041,  0x440043,  0x460045,  0x480047,  0x4a0049,  0x4c004b,  0x1f004d,  0x4f004e,  0x510050,  0x10001,  0x520001,  0x540053,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x55001f,  0x10001,  0x10001,  0x1f0056,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x10001,  0x1f0057,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x10001,  0x590058,  0x1f001f,  0x5b005a,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x5c0001,  0x10001,  0x10001,  0x5e005d,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x5f001f,  0x600001,  0x1f0061,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f0062,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x640063,  0x660065,  0x1f001f,  0x1f001f,  0x1f001f,  0x67001f,  0x690068,  0x1f006a,  0x1f006b,  0x6c001f,  0x6e006d,  0x1f001f,  0x1f001f,  0x1f006f,  0x70001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x10001,  0x10001,  0x10001,  0x10071,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x720001,  0x10073,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10074,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x750001,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x10001,  0x1f0076,  0x1f001f,  0x1f001f,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x770001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x780001,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x1f001f,  0x0,  0x0,  0x7fffffe,  0x7fffffe,  0x0,  0x4200400,  0xff7fffff,  0xff7fffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3ffc3,  0x501f,  0x0,  0x0,  0x20,  0xbcdf0000,  0xffffd740,  0xfffffffb,  0xffffffff,  0xffbfffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfffffc03,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfffeffff,  0x27fffff,  0xffffffff,  0x1ff,  0xbfff0000,  0xffff00b6,  0x787ff,  0x7ff0000,  0xffffffff,  0xfeffffff,  0xffffc000,  0xffffffff,  0xffffffff,  0x1fefffff,  0x9c00e1fe,  0xffff0000,  0xffffffff,  0xffffe000,  0xffffffff,  0xffffffff,  0x3ffff,  0xfffffc00,  0x43007ff,  0xfcffffff,  0x1fff,  0x1ffffff,  0xffff07ff,  0x7eff,  0xffffffff,  0xfff003ff,  0xffff03f8,  0xffffffff,  0xefffffff,  0xffe1dfff,  0xfffe000f,  0xfff99fef,  0xe3c5fdff,  0xb080599f,  0x1003000f,  0xfff987ee,  0xc36dfdff,  0x5e021987,  0x3f0000,  0xfffbbfee,  0xe3edfdff,  0x11bbf,  0x1e00000f,  0xfff99fee,  0xe3edfdff,  0xb0c0199f,  0x2000f,  0xd63dc7ec,  0xc3ffc718,  0x811dc7,  0x0,  0xfffddfff,  0xe3fffdff,  0x27601ddf,  0xf,  0xfffddfef,  0xe3effdff,  0x60601ddf,  0xe000f,  0xfffddfff,  0xe7ffffff,  0x80f05ddf,  0xfc00000f,  0xfc7fffee,  0x2ffbffff,  0xff5f807f,  0xc0000,  0xfffffffe,  0x7ffffff,  0x207f,  0x0,  0xfffff7d6,  0x3bffffaf,  0xf000205f,  0x0,  0x1,  0x0,  0xfffffeff,  0xfffe1fff,  0xfeffff0f,  0x1fffffff,  0x0,  0x0,  0xffffffff,  0xf97fffff,  0xffff0000,  0xffffffff,  0x3c00ffff,  0xffffffff,  0xffff20bf,  0xf7ffffff,  0xffffffff,  0xffffffff,  0x3d7f3dff,  0xffffffff,  0xffff3dff,  0x7f3dffff,  0xff7fff3d,  0xffffffff,  0xff3dffff,  0xffffffff,  0x7ffffff,  0x0,  0xffff,  0xffffffff,  0xffffffff,  0x3f3fffff,  0xfffffffe,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff9fff,  0x7fffffe,  0xffffffff,  0xffffffff,  0x1ffc7ff,  0x800fffff,  0xfffff,  0xfffff,  0xddfff,  0xffffffff,  0xffcfffff,  0x108001ff,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x1ffffff,  0xffffffff,  0xffff07ff,  0xffffffff,  0x3fffff,  0x7fffffff,  0x1ff0fff,  0xffff0000,  0x1f3fff,  0xffffffff,  0xffff0fff,  0x3ff,  0x0,  0xfffffff,  0xffffffff,  0x7fffffff,  0x1ffffe,  0x0,  0x80000080,  0x7001,  0x0,  0xffffffff,  0xffefffff,  0x1fef,  0x0,  0xffffffff,  0xfc00f3ff,  0xffffffff,  0x3ffbf,  0xffffffff,  0x7fffff,  0xfc00e000,  0x3fffffff,  0xffff01ff,  0xe7ffffff,  0x0,  0x46fde00,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x0,  0x1fff80,  0x3f3fffff,  0xffffffff,  0xaaff3f3f,  0x3fffffff,  0xffffffff,  0x5fdfffff,  0xfcf1fdc,  0x1fdc1fff,  0x0,  0x0,  0x0,  0x80020000,  0x1fff0000,  0x0,  0x0,  0x0,  0x3e2ffc84,  0xf3ffbd50,  0x43e0,  0xffffffff,  0x1ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffc00000,  0xffffffff,  0x3ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xc781f,  0xffffffff,  0xffff20bf,  0xffffffff,  0x80ff,  0x7fffff,  0x7f7f7f7f,  0x7f7f7f7f,  0xffffffff,  0x0,  0x8000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xe0,  0x1f3e03fe,  0xfffffffe,  0xffffffff,  0xe07fffff,  0xfffffffe,  0xffffffff,  0xf7ffffff,  0xffffffe0,  0xfffeffff,  0xffffffff,  0xffffffff,  0x7fff,  0xffffffff,  0x0,  0xffff0000,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1fff,  0x0,  0xffff0000,  0x3fffffff,  0xffff1fff,  0xc00,  0xffffffff,  0x8ff07fff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0xff800000,  0xfffffffc,  0xffffffff,  0xffffffff,  0xfffff9ff,  0xffffffff,  0x3eb07ff,  0xfffc0000,  0xffffffbf,  0xff,  0xffffffff,  0xfffff,  0xffffffff,  0xffffffff,  0x2f,  0xe8fc0000,  0xfffffc00,  0xffff07ff,  0x7ffff,  0x1fffffff,  0xffffffff,  0xfff7ffff,  0x8000,  0x7c00ffff,  0xffffffff,  0x7fffff,  0x3fff,  0xfc7fffff,  0xffffffff,  0x7fffffff,  0x38000005,  0x3cffff,  0x7e7e7e,  0xffff7f7f,  0xf7ffffff,  0xffff03ff,  0xffffffff,  0xffffffff,  0xffffffff,  0x7ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff000f,  0xfffff87f,  0xfffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff3fff,  0xffffffff,  0xffffffff,  0x3ffffff,  0x0,  0xe0f8007f,  0x5f7ffdff,  0xffffffdb,  0xffffffff,  0xffffffff,  0x3ffff,  0xfff80000,  0xffffffff,  0xffffffff,  0x3fffffff,  0xffff0000,  0xffffffff,  0xfffcffff,  0xffffffff,  0xff,  0xfff0000,  0x0,  0x0,  0x0,  0xffdf0000,  0xffffffff,  0xffffffff,  0xffffffff,  0x1fffffff,  0x0,  0x7fffffe,  0x7fffffe,  0xffffffc0,  0xffffffff,  0x7fffffff,  0x1cfcfcfc,  0x0,  0xffffefff,  0xb7ffff7f,  0x3fff3fff,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0x7ffffff,  0x0,  0x0,  0xffffffff,  0x1fffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1fffffff,  0xffffffff,  0x1ffff,  0x0,  0xffffffff,  0xffffe000,  0xffff07ff,  0x7ffffff,  0x3fffffff,  0xffffffff,  0x3eff0f,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffffff,  0xffff0000,  0xff0fffff,  0xfffffff,  0xffffffff,  0xffff00ff,  0xffffffff,  0xf7ff000f,  0xffb7f7ff,  0x1bfbfffb,  0x0,  0x0,  0xffffffff,  0x7fffff,  0x3fffff,  0xff,  0xffffffbf,  0x7fdffff,  0x0,  0x0,  0xfffffd3f,  0x91bfffff,  0x3fffff,  0x7fffff,  0x7fffffff,  0x0,  0x0,  0x37ffff,  0x3fffff,  0x3ffffff,  0x0,  0x0,  0xffffffff,  0xc0ffffff,  0x0,  0x0,  0xfeeff06f,  0x3fffff,  0x0,  0x1fffffff,  0x1fffffff,  0x0,  0xfffffeff,  0x1f,  0xffffffff,  0x3fffff,  0x3fffff,  0x7ffff,  0x3ffff,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x1ff,  0x0,  0xffffffff,  0x7ffff,  0xffffffff,  0x7ffff,  0xffffffff,  0xff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x31bff,  0x0,  0x0,  0x1fffffff,  0xffff0080,  0x3f,  0xffff0000,  0x3,  0xffff0000,  0x1f,  0x7fffff,  0xffffffff,  0xffffffff,  0x3f,  0x3e0000,  0xffffffff,  0x1ffffff,  0xffff0004,  0x1ff,  0xffffffff,  0x7ffff,  0xffff00f0,  0x47ffff,  0xffffffff,  0xffffffff,  0x1400c01e,  0x0,  0xfffbffff,  0xc09fffff,  0x3,  0x0,  0xbfffbd7f,  0xffff01ff,  0xffffffff,  0x1ff,  0xfff99fef,  0xe3edfdff,  0xe081199f,  0xf,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x800007bb,  0x3,  0xffffffff,  0xffffffff,  0xb3,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x7f3fffff,  0x3f000000,  0x0,  0xffffffff,  0x7fffffff,  0x11,  0x0,  0xffffffff,  0x13fffff,  0x0,  0x0,  0xe7ffffff,  0x7ff,  0x7f,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x1ffffff,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x80000000,  0xff6ff27f,  0x99bfffff,  0x7,  0x0,  0x0,  0xfffffcff,  0xfcffffff,  0x1a,  0xffffffff,  0x7fe7ffff,  0xffff0000,  0xffffffff,  0x20ffffff,  0xffff0000,  0xffffffff,  0x1ffffff,  0xfffffdff,  0x7f7fffff,  0x1,  0xfffc0000,  0xfffcffff,  0x7ffeff,  0x0,  0x0,  0xfffffb7f,  0xb47fffff,  0xcb,  0xfffffdbf,  0x17b7fff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7fffff,  0xfffdffff,  0xc7ffffff,  0x1,  0x0,  0x0,  0x10000,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3ffffff,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0x7fff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0xffffffff,  0xffffffff,  0x1ffff,  0xffffffff,  0xffff,  0x7e,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x7f,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x1ffffff,  0x7fffffff,  0xffff0000,  0xffffffff,  0x7fffffff,  0xffff0000,  0x3fff,  0xffffffff,  0xffff,  0xf,  0xe0fffff8,  0xffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffff87ff,  0xffffffff,  0xffff80ff,  0x0,  0x0,  0x3000b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffff,  0x0,  0x1ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x6fef0000,  0xffffffff,  0x40007,  0x270000,  0xffff00f0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1fff07ff,  0x43ff01ff,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffdfffff,  0xffffffff,  0xdfffffff,  0xebffde64,  0xffffffef,  0xffffffff,  0xdfdfe7bf,  0x7bffffff,  0xfffdfc5f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffff3f,  0xf7fffffd,  0xf7ffffff,  0xffdfffff,  0xffdfffff,  0xffff7fff,  0xffff7fff,  0xfffffdff,  0xfffffdff,  0xff7,  0x0,  0x7fffffff,  0x7e0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xf9ffff7f,  0xffff07db,  0xffffffff,  0x3fff,  0x8000,  0x0,  0x0,  0x0,  0xffffffff,  0x3f801fff,  0x4000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0x3fff,  0xffffffff,  0xfff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0xfff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7fff6f7f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1f,  0x0,  0xffffffff,  0xffffffff,  0x88f,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffef,  0xaf7fe96,  0xaa96ea84,  0x5ef7f796,  0xffffbff,  0xffffbee,  0x0,  0x0,  0x0,  0xffff0000,  0xffff03ff,  0xffff03ff,  0x3ff,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x0,  0xffffffff,  0x3ffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0003,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1,  0x3fffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffff07ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0]);
//3392 bytes
enum markTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x40,  0x110], [ 0x100,  0x1a0,  0x4800], [ 0x2020100,  0x4020302,  0x7020605,  0xa090802,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x202020b,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000,  0x30002,  0x50004,  0x70006,  0x90008,  0xb000a,  0xd000c,  0xe,  0xf0000,  0x0,  0x100000,  0x120011,  0x140013,  0x160015,  0x0,  0x17,  0x0,  0x0,  0x0,  0x0,  0x0,  0x190018,  0x0,  0x1a,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1b,  0x1d001c,  0x1f001e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x200000,  0x0,  0x21,  0x220000,  0x240023,  0x0,  0x0,  0x0,  0x25,  0x260000,  0x280027,  0x2a0029,  0x2c002b,  0x2e002d,  0x30002f,  0x320031,  0x33,  0x350034,  0x370036,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x38,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3a0039,  0x0,  0x3b0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3c,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3d0000,  0x3e0000,  0x3f,  0x0,  0x0,  0x0,  0x40,  0x0,  0x0,  0x3a0041,  0x42,  0x43,  0x0,  0x450044,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x460000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3f8,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfffe0000,  0xbfffffff,  0xb6,  0x0,  0x7ff0000,  0x0,  0xfffff800,  0x10000,  0x0,  0x0,  0x9fc00000,  0x3d9f,  0x20000,  0xffff0000,  0x7ff,  0x0,  0x0,  0x1ffc0,  0x0,  0x200ff800,  0xfbc00000,  0x3eef,  0xe000000,  0x0,  0xff000000,  0x0,  0xfffffc00,  0xfffffffb,  0xf,  0xdc000000,  0xfeffff,  0xc,  0xe,  0xd0000000,  0x80399f,  0x4000000c,  0xe,  0xd0000000,  0x23987,  0x230000,  0xe,  0xd0000000,  0x3bbf,  0xfc00000c,  0xe,  0xd0000000,  0xe0399f,  0xc,  0x4,  0xc0000000,  0x803dc7,  0x0,  0x1f,  0xd0000000,  0x603ddf,  0xc,  0xe,  0xd0000000,  0x603ddf,  0x8000c,  0xf,  0xd8000000,  0x803ddf,  0xc,  0xe,  0x0,  0xff5f8400,  0xc0000,  0x0,  0x7f20000,  0x7f80,  0x0,  0x0,  0x1ff20000,  0x7f00,  0x0,  0x3000000,  0xc2a00000,  0x0,  0xfffe0000,  0xfeffe0df,  0x1fffffff,  0x40,  0x0,  0x0,  0x7ffff800,  0xc3c00000,  0x1e3f9d,  0x3c00bffc,  0x0,  0x0,  0x0,  0x0,  0x0,  0xe0000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3c0000,  0x1c0000,  0xc0000,  0xc0000,  0x0,  0xfff00000,  0x200fffff,  0x0,  0xb800,  0x0,  0x0,  0x0,  0x60,  0x200,  0x0,  0x0,  0x0,  0xfff0fff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xf800000,  0x0,  0x7fe00000,  0x9fffffff,  0x0,  0xffff0000,  0x7fff,  0x0,  0x1f,  0xfff00000,  0x1f,  0xff800,  0x7,  0x3ffe,  0x0,  0xfffc0,  0x0,  0xfffff0,  0x0,  0x0,  0x0,  0x0,  0xfff70000,  0x39021ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0x1ffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x38000,  0x0,  0x0,  0x0,  0x80000000,  0x0,  0x0,  0x0,  0xffffffff,  0x0,  0xfc00,  0x0,  0x0,  0x6000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3ff78000,  0xc0000000,  0x0,  0x0,  0x30000,  0x844,  0x10f8,  0x0,  0x0,  0x3,  0xfff00000,  0x3f,  0x8003ffff,  0x0,  0x3fc0,  0xfff80,  0x0,  0xf,  0xfff80000,  0x1,  0x20,  0x0,  0x7ffe00,  0x3008,  0x38000000,  0x0,  0xc19d0000,  0x2,  0x60f800,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x37f8,  0x40000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff,  0xffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x20000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1,  0x0,  0x0,  0x0,  0x7c00000,  0x0,  0x0,  0x0,  0x0,  0xf06e,  0x87000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x60,  0x0,  0xf0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1800,  0x0,  0xe0000000,  0x0,  0x0,  0x1ffc0,  0x0,  0x3c,  0x0,  0x0,  0x0,  0x7,  0xff000000,  0x7f,  0x80190000,  0x7,  0x7ff0000,  0x4,  0x0,  0x7,  0x1fff80,  0x60,  0x80000,  0x7,  0xfff80000,  0xde01,  0x0,  0x0,  0x40fff000,  0x2,  0x0,  0x0,  0x0,  0x80000000,  0x7ff,  0xf,  0xd8000000,  0x80399f,  0x1f1fcc,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffe00000,  0x4000007f,  0x0,  0x0,  0xffff0000,  0xf,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xff3f8000,  0x30000001,  0x0,  0x0,  0xffff0000,  0x1,  0x0,  0x0,  0xfff800,  0x0,  0x0,  0xe0000000,  0xfff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7fff000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x79bf0000,  0xd,  0x0,  0x0,  0x0,  0xfcfe0000,  0x11,  0x7fe,  0x7bf80000,  0xffe0080,  0x0,  0x3fffc00,  0x0,  0x0,  0x0,  0x0,  0xff7f8000,  0x0,  0x0,  0xfffc0000,  0x7ffeff,  0x0,  0x0,  0x0,  0xb47e0000,  0xbf,  0x0,  0xfb7c00,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x780000,  0xb,  0xc7f00000,  0x7,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3fff81,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1f0000,  0x0,  0x7f0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfffe8000,  0xffffffff,  0x780ff,  0x0,  0x0,  0x30010,  0x0,  0x0,  0x0,  0x0,  0x60000000,  0x0,  0x0,  0x0,  0xffffffff,  0xffff3fff,  0x7f,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xf807e3e0,  0xfe7,  0x3c00,  0x0,  0x0,  0x0,  0x0,  0x1c,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xf87fffff,  0xffffffff,  0x201fff,  0xf8000010,  0xfffe,  0x0,  0x0,  0xf9ffff7f,  0x7db,  0x0,  0x0,  0x8000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x4000,  0x0,  0xf000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xf000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7f0000,  0x0,  0x0,  0x0,  0x7f0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0]);
//2848 bytes
enum numberTrieEntries = TrieEntry!(bool, 8, 6, 7)([ 0x0,  0x40,  0x1a0], [ 0x100,  0x2c0,  0x2500], [ 0x2020100,  0x4020302,  0x7020605,  0x9080202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x40003,  0x50002,  0x20002,  0x70006,  0x60006,  0x90008,  0x6000a,  0x6000b,  0xc000c,  0x2000d,  0xe0005,  0x20002,  0x20002,  0x2000f,  0x20002,  0x20002,  0x100002,  0x110002,  0x2000e,  0x130012,  0x140002,  0xc,  0x20015,  0x20002,  0x20002,  0x20002,  0x170016,  0x190018,  0x20002,  0x20002,  0x1b001a,  0x20002,  0x20002,  0x1d001c,  0x20002,  0x20002,  0x20002,  0x20002,  0x1e0002,  0x20002,  0x20002,  0x20002,  0x2001f,  0x200002,  0x220021,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x60023,  0x20002,  0xc0024,  0x250017,  0x2000c,  0x40002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x2000e,  0x20002,  0x270026,  0x280002,  0x2a0029,  0x230002,  0x20002,  0x20002,  0x20002,  0x2c002b,  0x2e002d,  0x30002f,  0x320031,  0x330002,  0x20000,  0x20034,  0x360035,  0x40037,  0x390038,  0x40002,  0x20002,  0xc000c,  0x20002,  0x5000c,  0x2003a,  0x3b0002,  0x2000c,  0x20002,  0x20002,  0x2003c,  0x23000c,  0x20002,  0x3d000c,  0x20002,  0x20002,  0x20002,  0x20002,  0x2003e,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x50003,  0x2003f,  0x20002,  0x20002,  0x400002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x410002,  0x20042,  0x20002,  0x20002,  0x20002,  0x430002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20005,  0x40002,  0x20002,  0x40002,  0x20002,  0x20002,  0x20002,  0x440002,  0x2000c,  0x20002,  0x20002,  0x460045,  0x20047,  0x20002,  0x20002,  0x20002,  0x20048,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x40002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x20002,  0x0,  0x3ff0000,  0x0,  0x0,  0x0,  0x720c0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3ff,  0x0,  0x0,  0x0,  0x3ff0000,  0x0,  0x0,  0x3ff,  0x0,  0x0,  0x0,  0x0,  0xffc0,  0x0,  0x0,  0x0,  0x3f0ffc0,  0x0,  0x0,  0x0,  0xfcffc0,  0x0,  0x0,  0x0,  0x7ffc0,  0x0,  0x0,  0x0,  0x7f00ffc0,  0x0,  0x0,  0x7f000000,  0x1ffffc0,  0x0,  0x0,  0x3ff0000,  0x0,  0x0,  0xfffff,  0x0,  0x0,  0x3ff0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1ffffe00,  0x0,  0x0,  0x0,  0x1c000,  0x0,  0x0,  0x0,  0x3ff03ff,  0x0,  0x0,  0xffc0,  0x0,  0x0,  0x0,  0x7ff0000,  0x0,  0x3ff03ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3ff03ff,  0x0,  0x0,  0x0,  0x0,  0x3f10000,  0x3ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0xffffffff,  0x3e7,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xfffffff,  0x0,  0x0,  0xfffffc00,  0x0,  0x0,  0x0,  0xffc00000,  0xfffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x20000000,  0x80,  0x70003fe,  0x0,  0x0,  0x3c0000,  0x0,  0x0,  0x0,  0x0,  0x3ff,  0xfffeff00,  0x0,  0x3ff,  0xfffe0000,  0x0,  0x0,  0x0,  0x3ff,  0x0,  0x0,  0x0,  0x3f0000,  0x0,  0x0,  0x0,  0x0,  0x3ff0000,  0x3ff0000,  0xffffff80,  0xfffff,  0xffffffff,  0x1ffffff,  0xc00,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffe,  0x0,  0xf,  0x402,  0x0,  0x0,  0x0,  0x3e0000,  0x0,  0x0,  0x0,  0xff000000,  0xfe000000,  0x0,  0xff80,  0x0,  0xf8000000,  0xfc00000,  0x0,  0x0,  0x0,  0x0,  0x30000000,  0xfffcffff,  0xffffffff,  0x0,  0x0,  0x1ff,  0x60000000,  0xe0000000,  0x0,  0x0,  0xf800,  0x0,  0x0,  0xff000000,  0xff000000,  0x0,  0xfe00,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfc000000,  0x0,  0x0,  0x0,  0x7fffffff,  0xe0000000,  0x7f,  0x1e0000,  0x0,  0x0,  0x0,  0xfe0,  0x0,  0x0,  0x0,  0xfffc0000,  0xffff,  0x0,  0xffc00000,  0x0,  0x0,  0x0,  0x0,  0x3ff0000,  0x1ffffe,  0x0,  0xfff0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7ffff,  0x0,  0x0,  0xffff0000,  0x1fff,  0x0,  0x0,  0x1fffff,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0x7fff,  0x0,  0x0,  0xfbff0000,  0x3,  0x7fffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfffff,  0xfffff,  0x0,  0x0,  0x0,  0x1ffffff,  0x0,  0x0,  0xffffc000,  0xffffffff,  0x0,  0x0,  0xff80,  0x0,  0x0,  0x0,  0x0,  0xfffe0000,  0xffffffff,  0x1eefff,  0x0,  0x0,  0xfffffffe,  0x3fffbfff,  0x0,  0x0,  0x1fff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3ff0000]);
//3360 bytes
enum punctuationTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x40,  0x100], [ 0x100,  0x180,  0x4900], [ 0x2020100,  0x4020302,  0x7020605,  0xa090802,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000,  0x20001,  0x30001,  0x50004,  0x70006,  0x10008,  0xa0009,  0xc000b,  0x1000d,  0xe0001,  0x1000f,  0x110010,  0x130012,  0x150014,  0x10016,  0x10001,  0x10017,  0x180001,  0x10001,  0x190001,  0x1a0001,  0x10001,  0x1c001b,  0x1001d,  0x1001e,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x1001f,  0x10020,  0x220021,  0x240023,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x250001,  0x270026,  0x280001,  0x290001,  0x2a0001,  0x10001,  0x2c002b,  0x2e002d,  0x10001,  0x30002f,  0x320031,  0x10033,  0x350034,  0x370036,  0x390038,  0x3b003a,  0x1003c,  0x3e003d,  0x10001,  0x10001,  0x1003f,  0x10001,  0x10001,  0x10001,  0x10001,  0x400001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x420041,  0x10001,  0x440043,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10045,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10046,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x470001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x0,  0x8c00f7ee,  0xb8000001,  0x28000000,  0x0,  0x88c00882,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x40000000,  0x80,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfc000000,  0x0,  0x600,  0x40000000,  0x49,  0x180000,  0xe8003600,  0x0,  0x0,  0x3c00,  0x0,  0x0,  0x100000,  0x0,  0x3fff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3800000,  0x0,  0x7fff0000,  0x40000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10030,  0x0,  0x0,  0x0,  0x20000000,  0x0,  0x0,  0x0,  0x400000,  0x0,  0x0,  0x0,  0x10000,  0x0,  0x0,  0x0,  0x800000,  0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x100000,  0x0,  0x0,  0xc008000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x17fff0,  0x3c000000,  0x0,  0x0,  0x20,  0x0,  0x61f0000,  0x0,  0x0,  0x0,  0xfc00,  0x0,  0x0,  0x0,  0x0,  0x8000000,  0x0,  0x0,  0x0,  0x1ff,  0x0,  0x0,  0x0,  0x0,  0x1,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x4000,  0x18000000,  0x0,  0x0,  0x3800,  0x0,  0x600000,  0x0,  0x0,  0x0,  0x0,  0x7700000,  0x0,  0x7ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x30,  0x0,  0x0,  0x0,  0x0,  0x0,  0xc0000000,  0x0,  0x0,  0x0,  0x0,  0x3f7f,  0x0,  0x0,  0x0,  0x0,  0xfc000000,  0x60000001,  0x0,  0x0,  0x0,  0xf0000000,  0x0,  0xf8000000,  0x0,  0xc0000000,  0x0,  0x0,  0x800ff,  0x0,  0xffff0000,  0xffff00ff,  0x7ffbffef,  0x60000000,  0x6000,  0x0,  0x0,  0x0,  0xf00,  0x600,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3fff00,  0x0,  0x0,  0x60,  0xffc0,  0x0,  0x0,  0x0,  0x0,  0x1fffff8,  0x0,  0xf000000,  0x30000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xde000000,  0x0,  0x0,  0x0,  0x10000,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffff7fff,  0x3ffcffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfff3ff0e,  0x20010000,  0x0,  0x0,  0x0,  0x1,  0x0,  0x8000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xc0000000,  0xe000,  0x0,  0x0,  0x40080000,  0x0,  0x0,  0x0,  0xfc0000,  0x0,  0x0,  0x0,  0xf00000,  0x0,  0x0,  0xc000,  0x17000000,  0x0,  0xc000,  0x80000000,  0x0,  0x0,  0x0,  0xc0003ffe,  0x0,  0x0,  0x0,  0xf0000000,  0x0,  0x0,  0x0,  0xc0000000,  0x30000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x800,  0x0,  0xc0000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3ff0000,  0xffff0000,  0xfff7ffff,  0xd0b,  0x0,  0x0,  0x0,  0x0,  0x8c00f7ee,  0xb8000001,  0xa8000000,  0x3f,  0x0,  0x0,  0x0,  0x0,  0x7,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x80000000,  0x0,  0x10000,  0x0,  0x0,  0x0,  0x0,  0x8000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x800000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x80000000,  0x80000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1ff0000,  0x80000000,  0x0,  0x0,  0x0,  0x7f0000,  0x0,  0xfe000000,  0x0,  0x0,  0x1e000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2000,  0x0,  0x0,  0x0,  0x0,  0x3e00000,  0x0,  0x3c0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3f80,  0x0,  0x0,  0xd8000000,  0x3,  0x0,  0x0,  0x0,  0xf,  0x300000,  0x0,  0x0,  0xe80021e0,  0x0,  0x0,  0x3f000000,  0x0,  0x0,  0x0,  0x200,  0x0,  0x0,  0x0,  0x0,  0x2c00f800,  0x0,  0x0,  0x0,  0x40,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfffffe,  0x0,  0x0,  0x0,  0xe,  0x1fff,  0x0,  0x2000000,  0x0,  0x0,  0x0,  0x70000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x70,  0x0,  0x0,  0x0,  0x0,  0x4,  0x0,  0x80000000,  0x7f,  0x0,  0xdc000000,  0x7,  0x0,  0x0,  0x3ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3e,  0x30000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1800000,  0x0,  0x0,  0xfff8,  0x0,  0x0,  0x0,  0x0,  0x80000000,  0x0,  0x0,  0x0,  0x1f0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x60000,  0x0,  0x0,  0x0,  0xc000,  0x0,  0x0,  0x0,  0x200000,  0x0,  0xf800000,  0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7800000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x4,  0x0,  0x0,  0x0,  0x0,  0x80000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xf80,  0x0,  0x0,  0x0,  0x0,  0x0,  0xc0000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0]);
//3424 bytes
enum symbolTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x40,  0x100], [ 0x100,  0x180,  0x4b00], [ 0x3020100,  0x5030403,  0x7030306,  0xa090803,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x3030303,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000,  0x30002,  0x50004,  0x70006,  0x90008,  0xb000a,  0xd000c,  0xf000e,  0x10010,  0x110001,  0x10001,  0x130012,  0x140001,  0x150001,  0x10001,  0x160001,  0x180017,  0x1a0019,  0x19001b,  0x1c0019,  0x1d0019,  0x1e0019,  0x1001f,  0x210020,  0x230022,  0x190024,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x250001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10026,  0x270001,  0x10028,  0x2a0029,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x2b0001,  0x2c0001,  0x2e002d,  0x2f0001,  0x10001,  0x10001,  0x10001,  0x10030,  0x10031,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0xe0001,  0x10001,  0x10001,  0x10001,  0x320001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x330001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10034,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x350001,  0x370036,  0x390038,  0x10001,  0x3b003a,  0x190019,  0x1003c,  0x10001,  0x10001,  0x3d0001,  0x1003e,  0x10001,  0x10001,  0x10001,  0x10001,  0x40003f,  0x10041,  0x430042,  0x190044,  0x190019,  0x460045,  0x190047,  0x490048,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x0,  0x70000810,  0x40000000,  0x50000001,  0x0,  0x113d37c,  0x800000,  0x800000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfffc003c,  0xffffafe0,  0x0,  0x0,  0x0,  0x200000,  0x30,  0x0,  0x0,  0x400000,  0x0,  0x0,  0x0,  0x0,  0x4,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xe000,  0x0,  0x0,  0x0,  0xc9c0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x40000000,  0x60000200,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xc0400000,  0x0,  0x0,  0x0,  0x0,  0x100,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xc0c0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x20000,  0x0,  0x0,  0x0,  0x10000,  0x0,  0x0,  0x0,  0x7f80000,  0x0,  0x0,  0x0,  0x80000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8000,  0x2000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x80000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfce8000e,  0x1500000,  0x0,  0x0,  0x0,  0xc0000000,  0x1e0dfbf,  0x0,  0x0,  0x0,  0x0,  0x0,  0xc0000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3ff0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8000000,  0x0,  0x0,  0x0,  0x1,  0x0,  0x0,  0x0,  0xc0000000,  0xffffffff,  0x0,  0x0,  0x0,  0x1ff007fe,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xa0000000,  0xe000e003,  0x6000e000,  0x0,  0x0,  0x40010,  0x1c000000,  0x1c00,  0xffffffff,  0x1,  0x0,  0xc1d0037b,  0xc0042af,  0xbc1f,  0x0,  0xffff0c00,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfffff0ff,  0xfffff9ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x7f,  0x7ff,  0x0,  0xf0000000,  0xffffffff,  0xffffffff,  0x3ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xff,  0xfff00000,  0xffffffff,  0xffffff9f,  0xffff003f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfe000007,  0xffffffff,  0xf0ffffff,  0xcfffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffcfffff,  0xffbfffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7e0,  0x0,  0x0,  0x30000,  0x0,  0xfbffffff,  0xffffffff,  0xffffffff,  0xfffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffff,  0xfff0000,  0xc0010,  0xc0c00001,  0x0,  0x0,  0x18000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffc30000,  0x0,  0xffffffff,  0xf,  0x7fffffff,  0xfffffc00,  0x100ff,  0xffffffff,  0xfffffc00,  0x1ffff,  0xffffffff,  0xffffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0xffffffff,  0x7f,  0x0,  0x7fffff,  0x3,  0x0,  0x0,  0x600,  0x0,  0x0,  0x0,  0x0,  0x3c00f00,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3800000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8000000,  0xc00,  0x0,  0x0,  0x0,  0x0,  0x0,  0x200,  0x0,  0x0,  0x0,  0xfffc0000,  0x7,  0x0,  0x0,  0x0,  0xffff,  0x0,  0x0,  0x0,  0x8000,  0xf0000000,  0x0,  0x0,  0x0,  0x274,  0x0,  0x0,  0x0,  0x0,  0x70000810,  0x40000000,  0x50000001,  0x0,  0x0,  0x0,  0x0,  0x30007f7f,  0x0,  0xff800000,  0x0,  0xfe000000,  0x1fff73ff,  0x1,  0xffff0000,  0x1fffffff,  0x0,  0x0,  0x0,  0x1800000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x100,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffe00000,  0x3ffff,  0x0,  0xf0000000,  0x20,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0xffffffff,  0xffffffff,  0xffffffff,  0xf,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffff,  0xffffffff,  0xfffffe7f,  0xffffffff,  0x1c1f,  0xfffff018,  0xffffc3ff,  0xffffffff,  0x7ff,  0xffffffff,  0xffffffff,  0x23,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x7fffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8000002,  0x8000000,  0x200000,  0x200000,  0x8000,  0x8000,  0x200,  0x200,  0x8,  0x0,  0x0,  0x7800000,  0x0,  0xffdfe000,  0x6f,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x80000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x11000,  0x0,  0x0,  0x0,  0x4000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x30000,  0xffffffff,  0xffff0fff,  0xffffffff,  0xffffffff,  0xfffff,  0xfffe7fff,  0xfffefffe,  0x3fffff,  0xffffe000,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fff,  0x0,  0xffffffc0,  0xffff0007,  0xfffffff,  0x301ff,  0x3f,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf0ffffff,  0x1fff1fff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf87fffff,  0xffffffff,  0xffffffff,  0x3ffffff,  0x10fff,  0xffff0fff,  0xffffffff,  0x3ff00ff,  0xffffffff,  0xffff00ff,  0x33fff,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xfffff,  0x1fff3fff,  0xffff01ff,  0xbfffffff,  0xfffc03f,  0x1ff01ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfff7ffff,  0xffffffff,  0x7ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0]);
//6048 bytes
enum graphicalTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x40,  0x1a0], [ 0x100,  0x2c0,  0x8900], [ 0x2020100,  0x5040302,  0x9080706,  0xd0c0b0a,  0x2020202,  0x100f0e02,  0x13131211,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131314,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x13131313,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000,  0x20001,  0x30001,  0x50004,  0x70006,  0x90008,  0xb000a,  0xd000c,  0x1000e,  0x10000f,  0x10001,  0x120011,  0x140013,  0x160015,  0x10017,  0x180001,  0x1a0019,  0x10001,  0x1001b,  0x10001,  0x10001,  0x1c0001,  0x1e001d,  0x20001f,  0x220021,  0x10023,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10024,  0x260025,  0x280027,  0x2a0029,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x2b0001,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x1002c,  0x2e002d,  0x2f0001,  0x310030,  0x330032,  0x350034,  0x370036,  0x380001,  0x3a0039,  0x3c003b,  0x3e003d,  0x40003f,  0x420041,  0x440043,  0x460045,  0x480047,  0x4a0049,  0x4c004b,  0x4e004d,  0x50004f,  0x10001,  0x510001,  0x530052,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x54002c,  0x10001,  0x10001,  0x2c0055,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x10001,  0x2c0056,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x10001,  0x580057,  0x2c002c,  0x5a0059,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x5b0001,  0x10001,  0x10001,  0x5d005c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x5e002c,  0x5f0001,  0x2c0060,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c0061,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x62002c,  0x640063,  0x660065,  0x680067,  0x6a0069,  0x10001,  0x2c006b,  0x2c002c,  0x6c002c,  0x6e006d,  0x2c006f,  0x2c0070,  0x71002c,  0x730072,  0x2c002c,  0x750074,  0x2c0076,  0x780077,  0x10079,  0x10001,  0x7b007a,  0x1007c,  0x7e007d,  0x2c002c,  0x2c002c,  0x10001,  0x10001,  0x10001,  0x1007f,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x800001,  0x10081,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10082,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x830001,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x10001,  0x2c0084,  0x2c002c,  0x2c002c,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x850001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x10001,  0x860001,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x87002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x2c002c,  0x0,  0xffffffff,  0xffffffff,  0x7fffffff,  0x0,  0xffffdfff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfcffffff,  0xffffd7f0,  0xfffffffb,  0xffffffff,  0xffffffff,  0xffffffff,  0xfffeffff,  0xfe7fffff,  0xffffffff,  0xfffee7ff,  0xffffffff,  0xffff00ff,  0x1f87ff,  0xefffffc0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xdfffffff,  0xffffffff,  0xffff3fff,  0xffffffff,  0xffffe7ff,  0xffffffff,  0xffffffff,  0x3ffff,  0xffffffff,  0xe7ffffff,  0xffffffff,  0x7fff3fff,  0x4fffffff,  0xffff07ff,  0xff007fff,  0xffffffff,  0xffffffff,  0xfffffffb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfff99fef,  0xf3c5fdff,  0xb080799f,  0x7fffffcf,  0xfff987ee,  0xd36dfdff,  0x5e023987,  0x7fffc0,  0xfffbbfee,  0xf3edfdff,  0x13bbf,  0xfe03ffcf,  0xfff99fee,  0xf3edfdff,  0xb0e0399f,  0xffffcf,  0xd63dc7ec,  0xc3ffc718,  0x813dc7,  0x7ffffc0,  0xfffddfff,  0xf3fffdff,  0x27603ddf,  0xff80ffcf,  0xfffddfff,  0xf3effdff,  0x60603ddf,  0xeffcf,  0xfffddfff,  0xffffffff,  0xfff0fddf,  0xffffffcf,  0xfc7fffee,  0x2ffbffff,  0xff5f847f,  0x1cffc0,  0xfffffffe,  0x87ffffff,  0xfffffff,  0x0,  0xfffff7d6,  0x3fffffaf,  0xf3ff7f5f,  0x0,  0xffffffff,  0xffffffff,  0xfffffeff,  0xfffe1fff,  0xfeffffff,  0xdfffffff,  0x7ffdfff,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff20bf,  0xffffffff,  0xffffffff,  0xffffffff,  0x3d7f3dff,  0xffffffff,  0xffff3dff,  0x7f3dffff,  0xff7fff3d,  0xffffffff,  0xff3dffff,  0xffffffff,  0xe7ffffff,  0x1fffffff,  0x3ffffff,  0xffffffff,  0xffffffff,  0x3f3fffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1fffffff,  0xffffffff,  0xffffffff,  0x1ffffff,  0x803fffff,  0x7fffff,  0xfffff,  0xddfff,  0xffffffff,  0xffffffff,  0x3fffffff,  0x3ff03ff,  0x3ffbfff,  0xffffffff,  0xffffffff,  0x1ffffff,  0xffffffff,  0xffff07ff,  0xffffffff,  0x3fffff,  0x7fffffff,  0xfff0fff,  0xfffffff1,  0x1f3fff,  0xffffffff,  0xffff0fff,  0xc7ff03ff,  0xffffffff,  0xcfffffff,  0xffffffff,  0x7fffffff,  0x9fffffff,  0x3ff03ff,  0xffff3fff,  0x7fff,  0x0,  0xffffffff,  0xffffffff,  0xffff1fff,  0x7fffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf00fffff,  0xffffffff,  0xf8ffffff,  0xffffe3ff,  0xffffffff,  0xffff01ff,  0xe7ffffff,  0xffff00ff,  0x7ffffff,  0x3f3fffff,  0xffffffff,  0xaaff3f3f,  0x3fffffff,  0xffffffff,  0xffdfffff,  0xefcfffdf,  0x7fdcffff,  0xffff07ff,  0xffff80ff,  0xffffffff,  0xfff30000,  0x1fff7fff,  0xffffffff,  0xffff0001,  0x1ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0fff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x7f,  0x7ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffcfffff,  0xffbfffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfe0fffff,  0xffffffff,  0xffff20bf,  0xffffffff,  0x800180ff,  0x7fffff,  0x7f7f7f7f,  0x7f7f7f7f,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffffff,  0x0,  0xfbffffff,  0xffffffff,  0xffffffff,  0xfffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffff,  0xfff0000,  0xffffffff,  0xffffffff,  0xfffffffe,  0xffffffff,  0xfe7fffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffe0,  0xfffeffff,  0xffffffff,  0xffffffff,  0xffff7fff,  0xffffffff,  0xffffffff,  0xffff000f,  0x7fffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff1fff,  0xffffffff,  0xffff007f,  0xffffffff,  0xffffffff,  0xfff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3eb07ff,  0xfffc0000,  0xffffffff,  0x3ff1fff,  0xffffffff,  0xffffff,  0xffffffff,  0xffffffff,  0x3ffc03f,  0xffffffff,  0xffffffff,  0xffffffff,  0x800fffff,  0x1fffffff,  0xffffffff,  0xffffffff,  0xc3ffbfff,  0x7fffffff,  0xffffffff,  0x7fffff,  0xf3ff3fff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf8000007,  0x7fffff,  0x7e7e7e,  0xffff7f7f,  0xffffffff,  0xffff0fff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3ff3fff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff000f,  0xfffff87f,  0xfffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff3fff,  0xffffffff,  0xffffffff,  0x3ffffff,  0x0,  0xe0f8007f,  0x5f7fffff,  0xffffffdb,  0xffffffff,  0xffffffff,  0xffffffff,  0xfff80007,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfffcffff,  0xffffffff,  0x80ff,  0xffff0000,  0x3ffffff,  0xffffffff,  0xfff7ffff,  0xffdf0f7f,  0xffffffff,  0xffffffff,  0xffffffff,  0x1fffffff,  0xfffffffe,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x7fffffff,  0x1cfcfcfc,  0x30007f7f,  0xffffefff,  0xb7ffff7f,  0x3fff3fff,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0x7ffffff,  0xffffff87,  0xff8fffff,  0xffffffff,  0xffffffff,  0x1fff7fff,  0x1,  0xffff0000,  0x3fffffff,  0x0,  0x0,  0x0,  0x0,  0x1fffffff,  0xffffffff,  0x1ffff,  0xfffffff,  0xffffffff,  0xffffe00f,  0xffff07ff,  0x7ffffff,  0xbfffffff,  0xffffffff,  0x3fff0f,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffffff,  0xffff03ff,  0xff0fffff,  0xfffffff,  0xffffffff,  0xffff00ff,  0xffffffff,  0xf7ff800f,  0xffb7f7ff,  0x1bfbfffb,  0x0,  0x0,  0xffffffff,  0x7fffff,  0x3fffff,  0xff,  0xffffffbf,  0x7fdffff,  0x0,  0x0,  0xfffffd3f,  0x91bfffff,  0xffbfffff,  0xffffffff,  0x7fffffff,  0xff80,  0x0,  0xf837ffff,  0x8fffffff,  0x83ffffff,  0x0,  0x0,  0xffffffff,  0xf0ffffff,  0xfffcffff,  0xffffffff,  0xfeeff06f,  0x873fffff,  0x1ff01ff,  0xffffffff,  0xffffffff,  0x0,  0xffffffff,  0x7ff87f,  0xffffffff,  0xfe3fffff,  0xff3fffff,  0xff07ffff,  0x1e03ffff,  0xfe00,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x1ff,  0x0,  0xffffffff,  0x7ffff,  0xffffffff,  0xfc07ffff,  0xffffffff,  0x3ff00ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7fffffff,  0xffffffff,  0x33bff,  0x0,  0xe0000000,  0xffffffff,  0xffff00ff,  0x3ffffff,  0xffff0000,  0x3ff,  0xffff0000,  0xfff,  0x7fffff,  0xffffffff,  0xffffffff,  0xfffc3fff,  0x803fffff,  0xffffffff,  0xdfffffff,  0xffff0007,  0x3ff01ff,  0xffffffff,  0xffdfffff,  0xffff00ff,  0x7fffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1ffffe,  0xfffbffff,  0xffffffff,  0x3,  0x0,  0xbfffbd7f,  0xffff03ff,  0xffffffff,  0x3ff07ff,  0xfff99fef,  0xfbedfdff,  0xe081399f,  0x1f1fcf,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xefffffff,  0x3,  0xffffffff,  0xffffffff,  0x3ff00ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xff3fffff,  0x3fffffff,  0x0,  0xffffffff,  0xffffffff,  0x3ff001f,  0x1fff,  0xffffffff,  0x3ffffff,  0x3ff,  0x0,  0xe7ffffff,  0xffff0fff,  0x7f,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xfffffff,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x8007ffff,  0xff6ff27f,  0xf9bfffff,  0x3ff007f,  0x0,  0x0,  0xfffffcff,  0xfcffffff,  0x1f,  0xffffffff,  0xffffffff,  0xffff00ff,  0xffffffff,  0xffffffff,  0xffff0007,  0xffffffff,  0x1ffffff,  0x3ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfffffdff,  0xff7fffff,  0xffff003f,  0xffff1fff,  0xfffcffff,  0x7ffeff,  0x0,  0x0,  0xfffffb7f,  0xb47fffff,  0x3ff00ff,  0xfffffdbf,  0x1fb7fff,  0x3ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1ffffff,  0xfffdffff,  0xc7ffffff,  0x3ffffff,  0x0,  0x0,  0x10000,  0xffffffff,  0x8003ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3ffffff,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0x1f7fff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0xffffffff,  0xffffffff,  0x7ffff,  0xffffffff,  0xffff,  0x3fffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x7f,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0x1ffffff,  0x7fffffff,  0xffffc3ff,  0xffffffff,  0x7fffffff,  0xffff03ff,  0x3f3fff,  0xffffffff,  0xffffffff,  0xfbff003f,  0xe0fffffb,  0xffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0x7ffffff,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffff87ff,  0xffffffff,  0xffff80ff,  0x0,  0x0,  0x3001f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffff,  0x0,  0x1ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x6fef0000,  0xffffffff,  0x40007,  0x270000,  0xffff00f0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1fff07ff,  0xf3ff01ff,  0x0,  0x0,  0x0,  0xffffffff,  0xffff3fff,  0xffff007f,  0xffffffff,  0xffffffff,  0xffffffff,  0xf,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffff,  0xffffffff,  0xfffffe7f,  0xffffffff,  0xf807ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x7ff,  0xffffffff,  0xffffffff,  0x3f,  0x0,  0x0,  0x0,  0xfffff,  0xfffff,  0xffffffff,  0xffffffff,  0x7fffff,  0x1ffffff,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffdfffff,  0xffffffff,  0xdfffffff,  0xebffde64,  0xffffffef,  0xffffffff,  0xdfdfe7bf,  0x7bffffff,  0xfffdfc5f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffff3f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffcfff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf8000fff,  0xfffe,  0x0,  0x0,  0x7fffffff,  0x7e0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xf9ffff7f,  0xffff07db,  0xffffffff,  0x3fff,  0x8000,  0x0,  0x0,  0x0,  0xffffffff,  0x3fff1fff,  0xc3ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0x7fff,  0xffffffff,  0x83ffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffff0000,  0x3ffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7fff6f7f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x7fff9f,  0x0,  0xffffffff,  0xffffffff,  0xc3ff0fff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfffe0000,  0xffffffff,  0x1fffff,  0x0,  0x0,  0xfffffffe,  0x3fffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffef,  0xaf7fe96,  0xaa96ea84,  0x5ef7f796,  0xffffbff,  0xffffbee,  0x0,  0x30000,  0xffffffff,  0xffff0fff,  0xffffffff,  0xffffffff,  0xfffff,  0xfffe7fff,  0xfffefffe,  0x3fffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fff,  0x0,  0xffffffc0,  0xffff0007,  0xfffffff,  0x301ff,  0x3f,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf0ffffff,  0x1fff1fff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf87fffff,  0xffffffff,  0xffffffff,  0x3ffffff,  0x10fff,  0xffff0fff,  0xffffffff,  0x3ff00ff,  0xffffffff,  0xffff00ff,  0x33fff,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xfffff,  0x1fff3fff,  0xffff01ff,  0xbfffffff,  0xfffc03f,  0x1ff01ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfff7ffff,  0xffffffff,  0x7ff,  0x3ff0000,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x0,  0xffffffff,  0x3ffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0003,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1,  0x3fffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffff07ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0]);
//4784 bytes
enum nonCharacterTrieEntries = TrieEntry!(bool, 7, 4, 4, 6)([ 0x0,  0x20,  0x98,  0x290], [ 0x80,  0xf0,  0x3f0,  0x4380], [ 0x3020100,  0x7060504,  0x9080101,  0xb0b0b0a,  0xb0b0b0b,  0xb0b0b0b,  0xb0b0b0b,  0xb0b0b0b,  0xb0b0b0b,  0xb0b0b0b,  0xb0b0b0b,  0xb0b0b0b,  0xb0b0b0b,  0xb0b0b0b,  0xb0b0b0c,  0xd010101,  0xd010101,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000,  0x30002,  0x50004,  0x70006,  0x90008,  0xb000a,  0xd000c,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xe000d,  0xd000f,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0x10000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0x120011,  0x140013,  0x160015,  0x180017,  0x1a0019,  0x1c001b,  0x1e001d,  0x1f000d,  0x1d001d,  0x20001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x220021,  0xd000d,  0xd000d,  0x23000d,  0x24000d,  0x1d001d,  0x1d001d,  0x1d001d,  0x25001d,  0x1d0026,  0x27001d,  0x1d001d,  0x28001d,  0x2a0029,  0x2c002b,  0x2e002d,  0x30002f,  0x320031,  0x1d0033,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0x34000d,  0xd000d,  0x35000d,  0xd0036,  0xd000d,  0x37000d,  0xd000d,  0xd000d,  0xd000d,  0x1d0038,  0x1d001d,  0x1d0039,  0xd000d,  0xd000d,  0xd003a,  0xd000d,  0x1d003b,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d003c,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0x1d001d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0x3d000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0xd000d,  0x3d000d,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10000,  0x2,  0x0,  0x0,  0x40003,  0x60005,  0x0,  0x0,  0x80007,  0xa0009,  0xc000b,  0xd,  0x0,  0xf000e,  0x110010,  0x130012,  0x150014,  0x170016,  0x190018,  0x1b001a,  0x1d001c,  0x1f001e,  0x210020,  0x230022,  0x240000,  0x260025,  0x0,  0x270000,  0x0,  0x0,  0x280000,  0x2a0029,  0x2c002b,  0x2e002d,  0x0,  0x0,  0x0,  0x0,  0x0,  0x30002f,  0x320031,  0x330000,  0x30002d,  0x350034,  0x370036,  0x390038,  0x3b003a,  0x3d003c,  0x3e0000,  0x3f0000,  0x410040,  0x430042,  0x0,  0x0,  0x0,  0x0,  0x450044,  0x470046,  0x480000,  0x4a0049,  0x0,  0x4b,  0x0,  0x0,  0x0,  0x0,  0x4d004c,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x4e0000,  0x4f,  0x0,  0x500000,  0x520051,  0x540053,  0x550000,  0x570056,  0x0,  0x580000,  0x590000,  0x4,  0x5a,  0x5c005b,  0x5d,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x5f005e,  0x0,  0x0,  0x60,  0x610000,  0x0,  0x620000,  0x610063,  0x640000,  0x650000,  0x660000,  0x680067,  0x690000,  0x38006a,  0x6b0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x6c005c,  0x0,  0x0,  0x0,  0x0,  0x6d0000,  0x6e0000,  0x70006f,  0x710000,  0x0,  0x0,  0x0,  0x730072,  0x74002d,  0x750000,  0x59,  0x770076,  0x790078,  0x7a0000,  0x7b,  0x7d007c,  0x7e007e,  0x7f002f,  0x810080,  0x830082,  0x0,  0x850084,  0x870086,  0x7e0088,  0x0,  0x0,  0x890067,  0x7e008a,  0x4f008b,  0x8d008c,  0x7e008e,  0x72008f,  0x910090,  0x930092,  0x950094,  0x7e0096,  0x970000,  0x990098,  0x7e009a,  0x7e007e,  0x9b007e,  0x9d009c,  0x9e0086,  0xa0009f,  0xa10000,  0xa20000,  0xa30046,  0xa40000,  0xa600a5,  0xa800a7,  0xaa00a9,  0x7e007e,  0xab0000,  0xac0000,  0x7e007e,  0x5500ad,  0xae0000,  0xb000af,  0xb200b1,  0x7e007e,  0x7e00b3,  0xb500b4,  0xb700b6,  0xb900b8,  0xba0000,  0x3000bb,  0x7e00b0,  0x7e007e,  0xbd00bc,  0x7e00be,  0xc000bf,  0x7e00c1,  0x7e007e,  0xc2007e,  0x6e00c3,  0xc500c4,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7e006e,  0xc60000,  0x0,  0xc70000,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x9800c8,  0xc90000,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x0,  0x0,  0x0,  0x0,  0xb20000,  0x7e007e,  0x7e007e,  0x7e007e,  0x0,  0x0,  0x0,  0x0,  0xca0030,  0xcb0076,  0xcc0000,  0x7e00cd,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e,  0x7e00ce,  0xcf0000,  0xd100d0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x610000,  0x0,  0xc90000,  0x7e0097,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0xd2007e,  0x0,  0x0,  0xd400d3,  0x0,  0x0,  0xb30000,  0x7e007e,  0x7e007e,  0xd50000,  0x7e00d6,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x5f006d,  0xc70000,  0x0,  0x350000,  0xd7,  0xd80000,  0xd90000,  0xda007e,  0xdb0000,  0x7e007e,  0xdc0000,  0xde00dd,  0xe000df,  0x0,  0x0,  0xe1,  0x0,  0xe20000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7e00e3,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e00e4,  0x7e007e,  0xe600e5,  0x7e00e7,  0xe900e8,  0x7e007e,  0x7e007e,  0xeb00ea,  0x7e007e,  0x7e007e,  0x7e007e,  0xec007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0xed007e,  0x0,  0xee0000,  0xef0000,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0xf0007e,  0x7e00f1,  0x7e00f2,  0x7e007e,  0xf400f3,  0xf600f5,  0x7e007e,  0x7e007e,  0x38,  0xf800f7,  0x0,  0xf900e6,  0xfb00fa,  0x7e007e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xfc0000,  0xfd0000,  0xfe0000,  0xff004b,  0x7e0100,  0x0,  0x0,  0x1010000,  0x1030102,  0x0,  0x1050104,  0x0,  0x0,  0x0,  0x0,  0x0,  0x920000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xaf,  0x0,  0x106,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x107,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1080000,  0x0,  0x0,  0x0,  0x0,  0x7e0055,  0x7e007e,  0x7e007e,  0x7e007e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1090000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x7e010a,  0x10b,  0x7e007e,  0x0,  0x10a0000,  0x7e007e,  0x7e007e,  0x7e007e,  0x7e007e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10c0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10c0000,  0x0,  0x0,  0x0,  0x3000000,  0x280f,  0x4,  0x0,  0x10000,  0x1800000,  0x0,  0x11800,  0x0,  0xff00,  0xffe07800,  0x4000,  0x0,  0x1800,  0x0,  0x0,  0xfffc0000,  0x0,  0x18000000,  0x0,  0x8000c000,  0xb0000000,  0xf800,  0xfc8000,  0x0,  0x66010,  0xc3a0200,  0x4f7f8660,  0x80000030,  0x67811,  0x2c920200,  0xa1fdc678,  0xff80003f,  0x44011,  0xc120200,  0xfffec440,  0x1fc0030,  0x66011,  0xc120200,  0x4f1fc660,  0xff000030,  0x29c23813,  0x3c0038e7,  0xff7ec238,  0xf800003f,  0x22000,  0xc000200,  0xd89fc220,  0x7f0030,  0x22000,  0xc100200,  0x9f9fc220,  0xfff10030,  0x22000,  0x0,  0xf0220,  0x30,  0x3800011,  0xd0040000,  0xa07b80,  0xffe3003f,  0x1,  0x78000000,  0xf0000000,  0xffffffff,  0x829,  0xc0000050,  0xc0080a0,  0xffffffff,  0x100,  0x1e000,  0x1000000,  0x20000000,  0xf8002000,  0xffffffff,  0xdf40,  0x0,  0xc280c200,  0x0,  0xc200,  0x80c20000,  0x8000c2,  0x0,  0xc20000,  0x0,  0x18000000,  0xe0000000,  0xfc000000,  0x0,  0x0,  0xc0c00000,  0xe0000000,  0x0,  0x0,  0xfe000000,  0x7fc00000,  0xff800000,  0xfff00000,  0xfff22000,  0xc0000000,  0xfc00fc00,  0x0,  0xf800,  0x0,  0xffc00000,  0x80000000,  0xf000f000,  0xe,  0xffe0c000,  0x0,  0xf000,  0x3800fc00,  0x0,  0x30000000,  0x0,  0x80000000,  0x60000000,  0xfc00fc00,  0xc000,  0xffff8000,  0xffffffff,  0xe000,  0x80000000,  0x0,  0xff00000,  0x0,  0x7000000,  0x1c00,  0x0,  0xfe00,  0x18000000,  0xff00,  0xf8000000,  0xc0c00000,  0x0,  0x5500c0c0,  0xc0000000,  0x0,  0x200000,  0x10300020,  0x80230000,  0x0,  0xc0020,  0xe0008000,  0x0,  0xfffe,  0xfffe0000,  0xf000,  0x0,  0x0,  0xffffff80,  0xfffff800,  0x0,  0x0,  0x300000,  0x400000,  0x0,  0x0,  0x1f00000,  0x0,  0xdf40,  0x0,  0x7ffe7f00,  0xff800000,  0x80808080,  0x80808080,  0x0,  0xc0000000,  0xffffffff,  0x4000000,  0x0,  0x0,  0xfff00000,  0xffc00000,  0xf000ffff,  0x1,  0x0,  0x1f,  0x10000,  0x8000,  0x0,  0x0,  0xfff0,  0x80000000,  0x0,  0xe000,  0x0,  0xff80,  0x0,  0x0,  0xfffff000,  0x0,  0xff000000,  0xfc14f800,  0x3ffff,  0x0,  0xfc00e000,  0xfc003fc0,  0x0,  0x7ff00000,  0xe0000000,  0x3c004000,  0x80000000,  0x0,  0xff800000,  0xc00c000,  0x0,  0x7fffff8,  0xff800000,  0xff818181,  0x8080,  0x0,  0xfc00c000,  0x780,  0xf0000000,  0x0,  0xc000,  0xfc000000,  0xffffffff,  0x1f07ff80,  0xa0800000,  0x24,  0x0,  0x7fff8,  0x0,  0x30000,  0x0,  0xffff7f00,  0xffff,  0x80000,  0x20f080,  0x0,  0x60000000,  0x0,  0x80000000,  0xe3030303,  0xc1ff8080,  0x1000,  0x48000080,  0xc000c000,  0xffffffff,  0x0,  0xf8000000,  0x78,  0x700000,  0xe0008000,  0xfffffffe,  0xffff,  0xc0000000,  0xffffffff,  0xffffffff,  0xfffe0000,  0xf0000000,  0x0,  0x1ff0,  0xf800,  0xf8000000,  0x40000000,  0x0,  0xffc000f0,  0xffffffff,  0xc0000000,  0xfc00,  0xf00000,  0xf0000000,  0x0,  0xff00,  0x0,  0x8007ff0,  0x480800,  0xe4040004,  0xffc00000,  0xffffff00,  0x40,  0xf8020000,  0x2c0,  0x6e400000,  0x80000000,  0xffff007f,  0xffffffff,  0x7c80000,  0x70000000,  0x7c000000,  0x0,  0xf000000,  0x1100f90,  0x78c00000,  0xfe00fe00,  0x0,  0x0,  0xffffffff,  0x0,  0xff800780,  0x0,  0x1c00000,  0xc00000,  0xf80000,  0xe1fc0000,  0xffff01ff,  0xfffffe00,  0xffffffff,  0x0,  0xfff80000,  0x0,  0x3f80000,  0x0,  0xfc00ff00,  0xffffffff,  0x80000000,  0x0,  0xfffcc400,  0xffffffff,  0x1fffffff,  0xfc000000,  0xffff,  0xfffffc00,  0xffff,  0xfffff000,  0xff800000,  0x3c000,  0x7fc00000,  0xdff8,  0xfc00fe00,  0xff00,  0xff800000,  0x0,  0xffe00001,  0x40000,  0x0,  0xfffffffc,  0xffffffff,  0x40004280,  0xfc00,  0x0,  0xfc00f800,  0x66010,  0x4120200,  0x1f7ec660,  0xffe0e030,  0x10000000,  0xfffffffc,  0xfc00ff00,  0xffffffff,  0x0,  0xc00000,  0xfc00ffe0,  0xffffe000,  0x0,  0xfc000000,  0xfffffc00,  0xffffffff,  0x18000000,  0xf000,  0xffffff80,  0xffffffff,  0x0,  0xf0000000,  0xffffffff,  0x0,  0x0,  0x7ff80000,  0x900d80,  0x6400000,  0xfc00ff80,  0xffffffff,  0xffffffff,  0x300,  0x3000000,  0xffffffe0,  0xff00,  0x0,  0x0,  0xfff8,  0x200,  0x800000,  0xffc0,  0xe000,  0x30000,  0xff800100,  0x480,  0x4b800000,  0xfc00ff00,  0x240,  0xfe048000,  0xfffffc00,  0xffffffff,  0xfe000000,  0x20000,  0x38000000,  0xffffffff,  0xfffeffff,  0x0,  0x7ffc0000,  0x0,  0xffe08000,  0xfffffff0,  0xffffffff,  0xffff,  0x0,  0xffc00000,  0xffffffff,  0x80000000,  0x3c00,  0xfc00,  0xffc0c000,  0x400ffc0,  0x1f000004,  0xffff0000,  0xffffffff,  0xf8000000,  0xffffffff,  0x7800,  0x0,  0x7f00,  0xffffffff,  0xffffffff,  0xfffcffe0,  0xffffffff,  0x9010ffff,  0x0,  0xfffbfff8,  0xffd8ffff,  0xff0f,  0x0,  0xe000f800,  0xc00fe00,  0xfffffff0,  0x0,  0x180,  0x0,  0xfffff800,  0xffffffc0,  0xffffffff,  0xfff00000,  0xfff00000,  0xff800000,  0xfe000000,  0x200000,  0x0,  0x20000000,  0x1400219b,  0x10,  0x0,  0x20201840,  0x84000000,  0x203a0,  0x0,  0x0,  0xc0,  0x3000,  0x0,  0x7fff000,  0xffff0001,  0x80000000,  0xfffff81f,  0x6000080,  0xf824,  0x0,  0xffffc000,  0xffff7fff,  0xffffffff,  0x0,  0xc000e000,  0xffff3c00,  0xffffffff,  0xffff,  0xffff8000,  0x0,  0x7c000000,  0xffff,  0xfc000000,  0xffffffff,  0x80009080,  0xff800060,  0xffffffff,  0x3c00f000,  0xffffffff,  0xffffffff,  0x1ffff,  0x0,  0xffe00000,  0x1,  0xc0000000,  0x10,  0xf5080169,  0x5569157b,  0xa1080869,  0xf0000400,  0xf0000411,  0xffffffff,  0xfffcffff,  0xfff00000,  0x18000,  0x10001,  0xffc00000,  0xffffffff,  0x3f,  0xfff8,  0xf0000000,  0xfffcfe00,  0xffffffc0,  0xf000000,  0xe000e000,  0x0,  0x7800000,  0xfc000000,  0xfffef000,  0xfc00ff00,  0x0,  0xff00,  0xfffcc000,  0xfff00000,  0xe000c000,  0xfe00,  0x40000000,  0xf0003fc0,  0xfe00fe00,  0x80000,  0x0,  0xfffff800,  0xfc00ffff,  0xc0000000,  0x0,  0x0,  0xfffc,  0x0,  0xfffffffe,  0xf800,  0x0,  0x0,  0xffff0000,  0xfffffffd,  0x0,  0x0,  0xc0000000,  0x0,  0xc0000000]);
enum MAX_SIMPLE_LOWER = 1433;
enum MAX_SIMPLE_UPPER = 1450;
enum MAX_SIMPLE_TITLE = 1454;
//10496 bytes
enum toUpperIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x40,  0x280], [ 0x100,  0x480,  0xf80], [ 0x2020100,  0x4020302,  0x6020205,  0x7020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x10000,  0x30002,  0x50004,  0x70006,  0x90008,  0xa,  0xb0000,  0xd000c,  0xf000e,  0x110010,  0x130012,  0x14,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x150000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x160000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x17,  0x180000,  0x19,  0x1b001a,  0x1d001c,  0x1f001e,  0x210020,  0x0,  0x0,  0x220000,  0x23,  0x0,  0x0,  0x0,  0x0,  0x0,  0x240000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x260025,  0x280027,  0x29,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2a0000,  0x2b,  0x2d002c,  0x2f002e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x300000,  0x31,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x32,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x330000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x350034,  0x360000,  0x0,  0x37,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x380000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x390000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3a0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3c003b,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x20001,  0x40003,  0x60005,  0x80007,  0xa0009,  0xc000b,  0xe000d,  0x10000f,  0x120011,  0x140013,  0x160015,  0x180017,  0xffff0019,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1affff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5aaffff,  0x1c001b,  0x1e001d,  0x20001f,  0x220021,  0x240023,  0x260025,  0x280027,  0x2a0029,  0x2c002b,  0x2e002d,  0x30002f,  0xffff0031,  0x330032,  0x350034,  0x370036,  0x390038,  0x3affff,  0x3bffff,  0x3cffff,  0x3dffff,  0x3effff,  0x3fffff,  0x40ffff,  0x41ffff,  0x42ffff,  0x43ffff,  0x44ffff,  0x45ffff,  0x46ffff,  0x47ffff,  0x48ffff,  0x49ffff,  0x4affff,  0x4bffff,  0x4cffff,  0x4dffff,  0x4effff,  0x4fffff,  0x50ffff,  0x51ffff,  0x5205ac,  0x53ffff,  0x54ffff,  0x55ffff,  0xffffffff,  0xffff0056,  0xffff0057,  0xffff0058,  0xffff0059,  0xffff005a,  0xffff005b,  0xffff005c,  0x5c9005d,  0x5effff,  0x5fffff,  0x60ffff,  0x61ffff,  0x62ffff,  0x63ffff,  0x64ffff,  0x65ffff,  0x66ffff,  0x67ffff,  0x68ffff,  0x69ffff,  0x6affff,  0x6bffff,  0x6cffff,  0x6dffff,  0x6effff,  0x6fffff,  0x70ffff,  0x71ffff,  0x72ffff,  0x73ffff,  0x74ffff,  0xffffffff,  0xffff0075,  0xffff0076,  0x780077,  0xffff0079,  0x7affff,  0x7bffff,  0xffffffff,  0xffff007c,  0xffffffff,  0xffff007d,  0xffffffff,  0xffffffff,  0xffff007e,  0x7fffff,  0xffffffff,  0x80ffff,  0xffff0081,  0xffffffff,  0xffff0082,  0x83ffff,  0x84ffff,  0x85ffff,  0xffffffff,  0xffff0086,  0xffffffff,  0x87ffff,  0xffffffff,  0xffff0088,  0xffffffff,  0xffff0089,  0xffff008a,  0x8bffff,  0xffffffff,  0x8cffff,  0x8dffff,  0xffffffff,  0xffffffff,  0x8effff,  0xffff008f,  0x910090,  0x92ffff,  0xffff0093,  0xffff0094,  0xffff0095,  0xffff0096,  0xffff0097,  0xffff0098,  0xffff0099,  0xffff009a,  0x9c009b,  0x9dffff,  0x9effff,  0x9fffff,  0xa0ffff,  0xa1ffff,  0xa2ffff,  0xa3ffff,  0xa4ffff,  0xa5ffff,  0xffff05d1,  0xa700a6,  0xa8ffff,  0xffffffff,  0xa9ffff,  0xaaffff,  0xabffff,  0xacffff,  0xadffff,  0xaeffff,  0xafffff,  0xb0ffff,  0xb1ffff,  0xb2ffff,  0xb3ffff,  0xb4ffff,  0xb5ffff,  0xb6ffff,  0xb7ffff,  0xb8ffff,  0xb9ffff,  0xbaffff,  0xbbffff,  0xbcffff,  0xffffffff,  0xbdffff,  0xbeffff,  0xbfffff,  0xc0ffff,  0xc1ffff,  0xc2ffff,  0xc3ffff,  0xc4ffff,  0xc5ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff00c6,  0xc7ffff,  0xffff00c8,  0xffff00c9,  0xffffffff,  0xcaffff,  0xcbffff,  0xccffff,  0xcdffff,  0xceffff,  0xd000cf,  0xd200d1,  0xffff00d3,  0xd500d4,  0xd6ffff,  0xd7ffff,  0xffff00d8,  0xffffffff,  0xda00d9,  0xdbffff,  0xdcffff,  0xffff00dd,  0xdf00de,  0xe100e0,  0xffff00e2,  0xe3ffff,  0xe4ffff,  0xffff00e5,  0xe6ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xe7ffff,  0xffffffff,  0xffff00e8,  0xea00e9,  0xffffffff,  0xebffff,  0xed00ec,  0xef00ee,  0xffff00f0,  0xffffffff,  0xffffffff,  0xffff00f1,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf2ffff,  0xffff00f3,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf4ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf5ffff,  0xf6ffff,  0xffffffff,  0xf7ffff,  0xffffffff,  0xf8ffff,  0xfa00f9,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff05cb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfc00fb,  0xfe00fd,  0xff05ce,  0x1010100,  0x1030102,  0x1050104,  0x1070106,  0x1090108,  0x10b010a,  0x10d010c,  0x10f010e,  0x1110110,  0x1130112,  0x1150114,  0x1170116,  0x1190118,  0x11b011a,  0xffff011c,  0x11e011d,  0xffffffff,  0x11fffff,  0x1210120,  0x122ffff,  0x123ffff,  0x124ffff,  0x125ffff,  0x126ffff,  0x127ffff,  0x128ffff,  0x129ffff,  0x12affff,  0x12bffff,  0x12cffff,  0x12dffff,  0x12f012e,  0x1310130,  0x132ffff,  0xffffffff,  0xffff0133,  0x134ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1360135,  0x1380137,  0x13a0139,  0x13c013b,  0x13e013d,  0x140013f,  0x1420141,  0x1440143,  0x1460145,  0x1480147,  0x14a0149,  0x14c014b,  0x14e014d,  0x150014f,  0x1520151,  0x1540153,  0x1560155,  0x1580157,  0x15a0159,  0x15c015b,  0x15e015d,  0x160015f,  0x1620161,  0x1640163,  0x165ffff,  0x166ffff,  0x167ffff,  0x168ffff,  0x169ffff,  0x16affff,  0x16bffff,  0x16cffff,  0x16dffff,  0x16effff,  0x16fffff,  0x170ffff,  0x171ffff,  0x172ffff,  0x173ffff,  0x174ffff,  0x175ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x176ffff,  0x177ffff,  0x178ffff,  0x179ffff,  0x17affff,  0x17bffff,  0x17cffff,  0x17dffff,  0x17effff,  0x17fffff,  0x180ffff,  0x181ffff,  0x182ffff,  0x183ffff,  0x184ffff,  0x185ffff,  0x186ffff,  0x187ffff,  0x188ffff,  0x189ffff,  0x18affff,  0x18bffff,  0x18cffff,  0x18dffff,  0x18effff,  0x18fffff,  0x190ffff,  0xffffffff,  0xffff0191,  0xffff0192,  0xffff0193,  0xffff0194,  0xffff0195,  0xffff0196,  0x1980197,  0x199ffff,  0x19affff,  0x19bffff,  0x19cffff,  0x19dffff,  0x19effff,  0x19fffff,  0x1a0ffff,  0x1a1ffff,  0x1a2ffff,  0x1a3ffff,  0x1a4ffff,  0x1a5ffff,  0x1a6ffff,  0x1a7ffff,  0x1a8ffff,  0x1a9ffff,  0x1aaffff,  0x1abffff,  0x1acffff,  0x1adffff,  0x1aeffff,  0x1afffff,  0x1b0ffff,  0x1b1ffff,  0x1b2ffff,  0x1b3ffff,  0x1b4ffff,  0x1b5ffff,  0x1b6ffff,  0x1b7ffff,  0x1b8ffff,  0x1b9ffff,  0x1baffff,  0x1bbffff,  0x1bcffff,  0x1bdffff,  0x1beffff,  0x1bfffff,  0x1c0ffff,  0x1c1ffff,  0x1c2ffff,  0x1c3ffff,  0x1c4ffff,  0x1c5ffff,  0x1c6ffff,  0x1c7ffff,  0x1c8ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1c9ffff,  0x1cb01ca,  0x1cd01cc,  0x1cf01ce,  0x1d101d0,  0x1d301d2,  0x1d501d4,  0x1d701d6,  0x1d901d8,  0x1db01da,  0x1dd01dc,  0x1df01de,  0x1e101e0,  0x1e301e2,  0x1e501e4,  0x1e701e6,  0x1e901e8,  0x1eb01ea,  0x1ed01ec,  0x5bd01ee,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1f001ef,  0x1f201f1,  0x1f401f3,  0x1f601f5,  0x1f801f7,  0x1fa01f9,  0x1fc01fb,  0x1fe01fd,  0x20001ff,  0x2020201,  0x2040203,  0x2060205,  0x2080207,  0x20a0209,  0x20c020b,  0x20e020d,  0x210020f,  0x2120211,  0x2140213,  0x2160215,  0x2180217,  0xffff0219,  0x21affff,  0x21c021b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x21e021d,  0x220021f,  0x2220221,  0xffffffff,  0x2240223,  0x2260225,  0x2280227,  0x22a0229,  0xffff022b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x22cffff,  0xffffffff,  0x22dffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff022e,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x22fffff,  0x230ffff,  0x231ffff,  0x232ffff,  0x233ffff,  0x234ffff,  0x235ffff,  0x236ffff,  0x237ffff,  0x238ffff,  0x239ffff,  0x23affff,  0x23bffff,  0x23cffff,  0x23dffff,  0x23effff,  0x23fffff,  0x240ffff,  0x241ffff,  0x242ffff,  0x243ffff,  0x244ffff,  0x245ffff,  0x246ffff,  0x247ffff,  0x248ffff,  0x249ffff,  0x24affff,  0x24bffff,  0x24cffff,  0x24dffff,  0x24effff,  0x24fffff,  0x250ffff,  0x251ffff,  0x252ffff,  0x253ffff,  0x254ffff,  0x255ffff,  0x256ffff,  0x257ffff,  0x258ffff,  0x259ffff,  0x25affff,  0x25bffff,  0x25cffff,  0x25dffff,  0x25effff,  0x25fffff,  0x260ffff,  0x261ffff,  0x262ffff,  0x263ffff,  0x264ffff,  0x265ffff,  0x266ffff,  0x267ffff,  0x268ffff,  0x269ffff,  0x26affff,  0x26bffff,  0x26cffff,  0x26dffff,  0x26effff,  0x26fffff,  0x270ffff,  0x271ffff,  0x272ffff,  0x273ffff,  0x274ffff,  0x275ffff,  0x276ffff,  0x277ffff,  0x278ffff,  0x279ffff,  0x5d505d3,  0x5d905d7,  0x27a05db,  0xffffffff,  0xffffffff,  0x27bffff,  0x27cffff,  0x27dffff,  0x27effff,  0x27fffff,  0x280ffff,  0x281ffff,  0x282ffff,  0x283ffff,  0x284ffff,  0x285ffff,  0x286ffff,  0x287ffff,  0x288ffff,  0x289ffff,  0x28affff,  0x28bffff,  0x28cffff,  0x28dffff,  0x28effff,  0x28fffff,  0x290ffff,  0x291ffff,  0x292ffff,  0x293ffff,  0x294ffff,  0x295ffff,  0x296ffff,  0x297ffff,  0x298ffff,  0x299ffff,  0x29affff,  0x29bffff,  0x29cffff,  0x29dffff,  0x29effff,  0x29fffff,  0x2a0ffff,  0x2a1ffff,  0x2a2ffff,  0x2a3ffff,  0x2a4ffff,  0x2a5ffff,  0x2a6ffff,  0x2a7ffff,  0x2a8ffff,  0x2a9ffff,  0x2aaffff,  0x2ac02ab,  0x2ae02ad,  0x2b002af,  0x2b202b1,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2b402b3,  0x2b602b5,  0x2b802b7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2ba02b9,  0x2bc02bb,  0x2be02bd,  0x2c002bf,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2c202c1,  0x2c402c3,  0x2c602c5,  0x2c802c7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2ca02c9,  0x2cc02cb,  0x2ce02cd,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2cf05dd,  0x2d005df,  0x2d105e2,  0x2d205e5,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2d402d3,  0x2d602d5,  0x2d802d7,  0x2da02d9,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2dc02db,  0x2de02dd,  0x2e002df,  0x2e202e1,  0x2e402e3,  0x2e602e5,  0x2e802e7,  0xffffffff,  0x6080606,  0x60c060a,  0x610060e,  0x6140612,  0x6180616,  0x61c061a,  0x620061e,  0x6240622,  0x6280626,  0x62c062a,  0x630062e,  0x6340632,  0x6380636,  0x63c063a,  0x640063e,  0x6440642,  0x6480646,  0x64c064a,  0x650064e,  0x6540652,  0x6580656,  0x65c065a,  0x660065e,  0x6640662,  0x3020301,  0x6660672,  0xffff0674,  0x67e05e8,  0xffffffff,  0xffffffff,  0xffff0668,  0xffff0304,  0xffffffff,  0x66a0676,  0xffff0678,  0x68105ea,  0xffffffff,  0xffffffff,  0xffff066c,  0xffffffff,  0x3070306,  0x5ef05ec,  0xffffffff,  0x5f405f2,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3090308,  0x5fa05f7,  0x30a05fd,  0x60105ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x66e067a,  0xffff067c,  0x6840604,  0xffffffff,  0xffffffff,  0xffff0670,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff030c,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x30e030d,  0x310030f,  0x3120311,  0x3140313,  0x3160315,  0x3180317,  0x31a0319,  0x31c031b,  0xffffffff,  0xffffffff,  0xffff031d,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x31f031e,  0x3210320,  0x3230322,  0x3250324,  0x3270326,  0x3290328,  0x32b032a,  0x32d032c,  0x32f032e,  0x3310330,  0x3330332,  0x3350334,  0x3370336,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3390338,  0x33b033a,  0x33d033c,  0x33f033e,  0x3410340,  0x3430342,  0x3450344,  0x3470346,  0x3490348,  0x34b034a,  0x34d034c,  0x34f034e,  0x3510350,  0x3530352,  0x3550354,  0x3570356,  0x3590358,  0x35b035a,  0x35d035c,  0x35f035e,  0x3610360,  0x3630362,  0x3650364,  0x3670366,  0x368ffff,  0xffffffff,  0x369ffff,  0xffff036a,  0xffff036b,  0xffff036c,  0xffff036d,  0xffffffff,  0xffffffff,  0x36effff,  0xffffffff,  0xffff036f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x370ffff,  0x371ffff,  0x372ffff,  0x373ffff,  0x374ffff,  0x375ffff,  0x376ffff,  0x377ffff,  0x378ffff,  0x379ffff,  0x37affff,  0x37bffff,  0x37cffff,  0x37dffff,  0x37effff,  0x37fffff,  0x380ffff,  0x381ffff,  0x382ffff,  0x383ffff,  0x384ffff,  0x385ffff,  0x386ffff,  0x387ffff,  0x388ffff,  0x389ffff,  0x38affff,  0x38bffff,  0x38cffff,  0x38dffff,  0x38effff,  0x38fffff,  0x390ffff,  0x391ffff,  0x392ffff,  0x393ffff,  0x394ffff,  0x395ffff,  0x396ffff,  0x397ffff,  0x398ffff,  0x399ffff,  0x39affff,  0x39bffff,  0x39cffff,  0x39dffff,  0x39effff,  0x39fffff,  0x3a0ffff,  0x3a1ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff03a2,  0xffff03a3,  0xffffffff,  0x3a4ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3a603a5,  0x3a803a7,  0x3aa03a9,  0x3ac03ab,  0x3ae03ad,  0x3b003af,  0x3b203b1,  0x3b403b3,  0x3b603b5,  0x3b803b7,  0x3ba03b9,  0x3bc03bb,  0x3be03bd,  0x3c003bf,  0x3c203c1,  0x3c403c3,  0x3c603c5,  0x3c803c7,  0x3ca03c9,  0x3cbffff,  0xffffffff,  0xffffffff,  0x3ccffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3cdffff,  0x3ceffff,  0x3cfffff,  0x3d0ffff,  0x3d1ffff,  0x3d2ffff,  0x3d3ffff,  0x3d4ffff,  0x3d5ffff,  0x3d6ffff,  0x3d7ffff,  0x3d8ffff,  0x3d9ffff,  0x3daffff,  0x3dbffff,  0x3dcffff,  0x3ddffff,  0x3deffff,  0x3dfffff,  0x3e0ffff,  0x3e1ffff,  0x3e2ffff,  0x3e3ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3e4ffff,  0x3e5ffff,  0x3e6ffff,  0x3e7ffff,  0x3e8ffff,  0x3e9ffff,  0x3eaffff,  0x3ebffff,  0x3ecffff,  0x3edffff,  0x3eeffff,  0x3efffff,  0x3f0ffff,  0x3f1ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3f2ffff,  0x3f3ffff,  0x3f4ffff,  0x3f5ffff,  0x3f6ffff,  0x3f7ffff,  0x3f8ffff,  0xffffffff,  0x3f9ffff,  0x3faffff,  0x3fbffff,  0x3fcffff,  0x3fdffff,  0x3feffff,  0x3ffffff,  0x400ffff,  0x401ffff,  0x402ffff,  0x403ffff,  0x404ffff,  0x405ffff,  0x406ffff,  0x407ffff,  0x408ffff,  0x409ffff,  0x40affff,  0x40bffff,  0x40cffff,  0x40dffff,  0x40effff,  0x40fffff,  0x410ffff,  0x411ffff,  0x412ffff,  0x413ffff,  0x414ffff,  0x415ffff,  0x416ffff,  0x417ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0418,  0xffff0419,  0x41affff,  0x41bffff,  0x41cffff,  0x41dffff,  0x41effff,  0xffffffff,  0xffffffff,  0xffff041f,  0xffffffff,  0x420ffff,  0x421ffff,  0xffff0422,  0x423ffff,  0x424ffff,  0x425ffff,  0x426ffff,  0x427ffff,  0x428ffff,  0x429ffff,  0x42affff,  0x42bffff,  0x42cffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x42dffff,  0x42effff,  0x42fffff,  0x430ffff,  0x431ffff,  0x432ffff,  0x433ffff,  0x434ffff,  0xffffffff,  0xffffffff,  0xffff0435,  0xffff0436,  0xffffffff,  0xffffffff,  0x437ffff,  0xffffffff,  0xffffffff,  0x438ffff,  0x439ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff043a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x43bffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x43d043c,  0x43f043e,  0x4410440,  0x4430442,  0x4450444,  0x4470446,  0x4490448,  0x44b044a,  0x44d044c,  0x44f044e,  0x4510450,  0x4530452,  0x4550454,  0x4570456,  0x4590458,  0x45b045a,  0x45d045c,  0x45f045e,  0x4610460,  0x4630462,  0x4650464,  0x4670466,  0x4690468,  0x46b046a,  0x46d046c,  0x46f046e,  0x4710470,  0x4730472,  0x4750474,  0x4770476,  0x4790478,  0x47b047a,  0x47d047c,  0x47f047e,  0x4810480,  0x4830482,  0x4850484,  0x4870486,  0x4890488,  0x48b048a,  0x5af05ad,  0x5b305b1,  0x5b905b6,  0xffff05bb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5bfffff,  0x5c305c1,  0x5c705c5,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x48cffff,  0x48e048d,  0x490048f,  0x4920491,  0x4940493,  0x4960495,  0x4980497,  0x49a0499,  0x49c049b,  0x49e049d,  0x4a0049f,  0x4a204a1,  0x4a404a3,  0xffff04a5,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4a704a6,  0x4a904a8,  0x4ab04aa,  0x4ad04ac,  0x4af04ae,  0x4b104b0,  0x4b304b2,  0x4b504b4,  0x4b704b6,  0x4b904b8,  0x4bb04ba,  0x4bd04bc,  0x4bf04be,  0x4c104c0,  0x4c304c2,  0x4c504c4,  0x4c704c6,  0x4c904c8,  0x4cb04ca,  0x4cd04cc,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4cf04ce,  0x4d104d0,  0x4d304d2,  0x4d504d4,  0x4d704d6,  0x4d904d8,  0x4db04da,  0x4dd04dc,  0x4df04de,  0x4e104e0,  0x4e304e2,  0x4e504e4,  0x4e704e6,  0x4e904e8,  0x4eb04ea,  0x4ed04ec,  0x4ef04ee,  0x4f104f0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4f2ffff,  0x4f404f3,  0x4f604f5,  0x4f804f7,  0x4fa04f9,  0x4fc04fb,  0x4fdffff,  0x4ff04fe,  0x5010500,  0x5030502,  0x5050504,  0x5070506,  0x5090508,  0x50b050a,  0x50cffff,  0x50e050d,  0x510050f,  0x5120511,  0x513ffff,  0xffff0514,  0xffffffff,  0x5160515,  0x5180517,  0x51a0519,  0x51c051b,  0x51e051d,  0x520051f,  0x5220521,  0x5240523,  0x5260525,  0x5280527,  0x52a0529,  0x52c052b,  0x52e052d,  0x530052f,  0x5320531,  0x5340533,  0x5360535,  0x5380537,  0x53a0539,  0x53c053b,  0x53e053d,  0x540053f,  0x5420541,  0x5440543,  0x5460545,  0xffff0547,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5490548,  0x54b054a,  0x54d054c,  0x54f054e,  0x5510550,  0x5530552,  0x5550554,  0x5570556,  0x5590558,  0x55b055a,  0x55d055c,  0x55f055e,  0x5610560,  0x5630562,  0x5650564,  0x5670566,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5690568,  0x56b056a,  0x56d056c,  0x56f056e,  0x5710570,  0x5730572,  0x5750574,  0x5770576,  0x5790578,  0x57b057a,  0x57d057c,  0x57f057e,  0x5810580,  0x5830582,  0x5850584,  0x5870586,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5890588,  0x58b058a,  0x58d058c,  0x58f058e,  0x5910590,  0x5930592,  0x5950594,  0x5970596,  0x5990598,  0x59b059a,  0x59d059c,  0x59f059e,  0x5a105a0,  0x5a305a2,  0x5a505a4,  0x5a705a6,  0x5a905a8,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff]);
//10112 bytes
enum toLowerIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x40,  0x280], [ 0x100,  0x480,  0xec0], [ 0x2020100,  0x4020302,  0x6020205,  0x7020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x10000,  0x20000,  0x40003,  0x60005,  0x80007,  0x0,  0x90000,  0xb000a,  0xd000c,  0xf000e,  0x110010,  0x12,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x140013,  0x0,  0x0,  0x0,  0x0,  0x0,  0x160015,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x17,  0x0,  0x0,  0x190018,  0x1b001a,  0x1d001c,  0x1f001e,  0x0,  0x0,  0x210020,  0x22,  0x0,  0x0,  0x0,  0x0,  0x0,  0x240023,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x260025,  0x280027,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x290000,  0x2a,  0x2c002b,  0x2e002d,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2f,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x30,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x31,  0x330032,  0x340000,  0x35,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x36,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x37,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x380000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x39,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x20001,  0x40003,  0x60005,  0x80007,  0xa0009,  0xc000b,  0xe000d,  0x10000f,  0x120011,  0x140013,  0x160015,  0x180017,  0xffff0019,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1b001a,  0x1d001c,  0x1f001e,  0x210020,  0x230022,  0x250024,  0x270026,  0x290028,  0x2b002a,  0x2d002c,  0x2f002e,  0xffff0030,  0x320031,  0x340033,  0x360035,  0x5990037,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0038,  0xffff0039,  0xffff003a,  0xffff003b,  0xffff003c,  0xffff003d,  0xffff003e,  0xffff003f,  0xffff0040,  0xffff0041,  0xffff0042,  0xffff0043,  0xffff0044,  0xffff0045,  0xffff0046,  0xffff0047,  0xffff0048,  0xffff0049,  0xffff004a,  0xffff004b,  0xffff004c,  0xffff004d,  0xffff004e,  0xffff004f,  0xffff059a,  0xffff0051,  0xffff0052,  0xffff0053,  0x54ffff,  0x55ffff,  0x56ffff,  0x57ffff,  0x58ffff,  0x59ffff,  0x5affff,  0x5bffff,  0x5a9ffff,  0xffff005c,  0xffff005d,  0xffff005e,  0xffff005f,  0xffff0060,  0xffff0061,  0xffff0062,  0xffff0063,  0xffff0064,  0xffff0065,  0xffff0066,  0xffff0067,  0xffff0068,  0xffff0069,  0xffff006a,  0xffff006b,  0xffff006c,  0xffff006d,  0xffff006e,  0xffff006f,  0xffff0070,  0xffff0071,  0xffff0072,  0x740073,  0x75ffff,  0x76ffff,  0xffffffff,  0x77ffff,  0xffff0078,  0xffff0079,  0x7b007a,  0x7cffff,  0x7e007d,  0xffffffff,  0x80007f,  0x820081,  0x83ffff,  0xffff0084,  0x860085,  0xffff0087,  0xffffffff,  0x890088,  0x8affff,  0xffff008b,  0xffff008c,  0xffff008d,  0x8f008e,  0x90ffff,  0xffffffff,  0xffff0091,  0x930092,  0x94ffff,  0x960095,  0x97ffff,  0x98ffff,  0xffff0099,  0xffffffff,  0xffff009a,  0xffffffff,  0xffffffff,  0xffffffff,  0x9c009b,  0x9dffff,  0xffff009e,  0xa0009f,  0xa1ffff,  0xa2ffff,  0xa3ffff,  0xa4ffff,  0xa5ffff,  0xa6ffff,  0xa7ffff,  0xa8ffff,  0xffffffff,  0xffff00a9,  0xffff00aa,  0xffff00ab,  0xffff00ac,  0xffff00ad,  0xffff00ae,  0xffff00af,  0xffff00b0,  0xffff00b1,  0xb205ac,  0xffff00b3,  0xffff00b4,  0xb600b5,  0xffff00b7,  0xffff00b8,  0xffff00b9,  0xffff00ba,  0xffff00bb,  0xffff00bc,  0xffff00bd,  0xffff00be,  0xffff00bf,  0xffff00c0,  0xffff00c1,  0xffff00c2,  0xffff00c3,  0xffff00c4,  0xffff00c5,  0xffff00c6,  0xffff00c7,  0xffff00c8,  0xffff00c9,  0xffff00ca,  0xffff00cb,  0xffff00cc,  0xffff00cd,  0xffff00ce,  0xffff00cf,  0xffff00d0,  0xffff00d1,  0xffff00d2,  0xffff00d3,  0xffff00d4,  0xffffffff,  0xffffffff,  0xffffffff,  0xd600d5,  0xd7ffff,  0xffff00d8,  0xd9ffff,  0xdaffff,  0xdc00db,  0xffff00dd,  0xffff00de,  0xffff00df,  0xffff00e0,  0xffff00e1,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff00e2,  0xffff00e3,  0xffffffff,  0xffff00e4,  0xffffffff,  0xffffffff,  0xffffffff,  0xe5ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff00e6,  0xe800e7,  0xffff00e9,  0xffff00ea,  0xec00eb,  0xed05aa,  0xef00ee,  0xf100f0,  0xf300f2,  0xf500f4,  0xf700f6,  0xf900f8,  0xfb00fa,  0xfd00fc,  0xfeffff,  0x10000ff,  0x1020101,  0x1040103,  0x1060105,  0xffffffff,  0xffffffff,  0xffff05ab,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x107ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0108,  0xffff0109,  0xffff010a,  0xffff010b,  0xffff010c,  0xffff010d,  0xffff010e,  0xffff010f,  0xffff0110,  0xffff0111,  0xffff0112,  0xffff0113,  0xffffffff,  0xffffffff,  0xffff0114,  0x115ffff,  0x116ffff,  0xffff0117,  0x118ffff,  0x11a0119,  0x11c011b,  0x11e011d,  0x120011f,  0x1220121,  0x1240123,  0x1260125,  0x1280127,  0x12a0129,  0x12c012b,  0x12e012d,  0x130012f,  0x1320131,  0x1340133,  0x1360135,  0x1380137,  0x13a0139,  0x13c013b,  0x13e013d,  0x140013f,  0x1420141,  0x1440143,  0x1460145,  0x1480147,  0x14a0149,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff014b,  0xffff014c,  0xffff014d,  0xffff014e,  0xffff014f,  0xffff0150,  0xffff0151,  0xffff0152,  0xffff0153,  0xffff0154,  0xffff0155,  0xffff0156,  0xffff0157,  0xffff0158,  0xffff0159,  0xffff015a,  0xffff015b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff015c,  0xffff015d,  0xffff015e,  0xffff015f,  0xffff0160,  0xffff0161,  0xffff0162,  0xffff0163,  0xffff0164,  0xffff0165,  0xffff0166,  0xffff0167,  0xffff0168,  0xffff0169,  0xffff016a,  0xffff016b,  0xffff016c,  0xffff016d,  0xffff016e,  0xffff016f,  0xffff0170,  0xffff0171,  0xffff0172,  0xffff0173,  0xffff0174,  0xffff0175,  0xffff0176,  0x1780177,  0x179ffff,  0x17affff,  0x17bffff,  0x17cffff,  0x17dffff,  0x17effff,  0xffffffff,  0xffff017f,  0xffff0180,  0xffff0181,  0xffff0182,  0xffff0183,  0xffff0184,  0xffff0185,  0xffff0186,  0xffff0187,  0xffff0188,  0xffff0189,  0xffff018a,  0xffff018b,  0xffff018c,  0xffff018d,  0xffff018e,  0xffff018f,  0xffff0190,  0xffff0191,  0xffff0192,  0xffff0193,  0xffff0194,  0xffff0195,  0xffff0196,  0xffff0197,  0xffff0198,  0xffff0199,  0xffff019a,  0xffff019b,  0xffff019c,  0xffff019d,  0xffff019e,  0xffff019f,  0xffff01a0,  0xffff01a1,  0xffff01a2,  0xffff01a3,  0xffff01a4,  0xffff01a5,  0xffff01a6,  0xffff01a7,  0xffff01a8,  0xffff01a9,  0xffff01aa,  0xffff01ab,  0xffff01ac,  0xffff01ad,  0xffff01ae,  0x1afffff,  0x1b101b0,  0x1b301b2,  0x1b501b4,  0x1b701b6,  0x1b901b8,  0x1bb01ba,  0x1bd01bc,  0x1bf01be,  0x1c101c0,  0x1c301c2,  0x1c501c4,  0x1c701c6,  0x1c901c8,  0x1cb01ca,  0x1cd01cc,  0x1cf01ce,  0x1d101d0,  0x1d301d2,  0xffff01d4,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5a3ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1d601d5,  0x1d801d7,  0x1da01d9,  0x1dc01db,  0x1de01dd,  0x1e001df,  0x1e201e1,  0x1e401e3,  0x1e601e5,  0x1e801e7,  0x1ea01e9,  0x1ec01eb,  0x1ee01ed,  0x1f001ef,  0x1f201f1,  0x1f401f3,  0x1f601f5,  0x1f801f7,  0x1fa01f9,  0x1fbffff,  0xffffffff,  0xffffffff,  0x1fcffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1fe01fd,  0x20001ff,  0x2020201,  0x2040203,  0x2060205,  0x2080207,  0x20a0209,  0x20c020b,  0x20e020d,  0x210020f,  0x2120211,  0x2140213,  0x2160215,  0x2180217,  0x21a0219,  0x21c021b,  0x21e021d,  0x220021f,  0x2220221,  0x2240223,  0x2260225,  0x2280227,  0x22a0229,  0x22c022b,  0x22e022d,  0x230022f,  0x2320231,  0x2340233,  0x2360235,  0x2380237,  0x23a0239,  0x23c023b,  0x23e023d,  0x240023f,  0x2420241,  0x2440243,  0x2460245,  0x2480247,  0x24a0249,  0x24c024b,  0x24e024d,  0x250024f,  0x2520251,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2540253,  0x2560255,  0x2580257,  0x25a0259,  0x25c025b,  0x25e025d,  0x260025f,  0x2620261,  0x2640263,  0x2660265,  0x2680267,  0x26a0269,  0x26c026b,  0x26e026d,  0x270026f,  0x2720271,  0x2740273,  0x2760275,  0x2780277,  0x27a0279,  0x27c027b,  0xffff027d,  0x27effff,  0x280027f,  0xffff0281,  0xffff0282,  0xffff0283,  0xffff0284,  0xffff0285,  0xffff0286,  0xffff0287,  0xffff0288,  0xffff0289,  0xffff028a,  0xffff028b,  0xffff028c,  0xffff028d,  0xffff028e,  0xffff028f,  0xffff0290,  0xffff0291,  0xffff0292,  0xffff0293,  0xffff0294,  0xffff0295,  0xffff0296,  0xffff0297,  0xffff0298,  0xffff0299,  0xffff029a,  0xffff029b,  0xffff029c,  0xffff029d,  0xffff029e,  0xffff029f,  0xffff02a0,  0xffff02a1,  0xffff02a2,  0xffff02a3,  0xffff02a4,  0xffff02a5,  0xffff02a6,  0xffff02a7,  0xffff02a8,  0xffff02a9,  0xffff02aa,  0xffff02ab,  0xffff02ac,  0xffff02ad,  0xffff02ae,  0xffff02af,  0xffff02b0,  0xffff02b1,  0xffff02b2,  0xffff02b3,  0xffff02b4,  0xffff02b5,  0xffff02b6,  0xffff02b7,  0xffff02b8,  0xffff02b9,  0xffff02ba,  0xffff02bb,  0xffff02bc,  0xffff02bd,  0xffff02be,  0xffff02bf,  0xffff02c0,  0xffff02c1,  0xffff02c2,  0xffff02c3,  0xffff02c4,  0xffff02c5,  0xffff02c6,  0xffff02c7,  0xffff02c8,  0xffff02c9,  0xffff02ca,  0xffff02cb,  0x5ae05ad,  0x5b005af,  0xffff05b1,  0xffffffff,  0xffff02cc,  0xffff02cd,  0xffff02ce,  0xffff02cf,  0xffff02d0,  0xffff02d1,  0xffff02d2,  0xffff02d3,  0xffff02d4,  0xffff02d5,  0xffff02d6,  0xffff02d7,  0xffff02d8,  0xffff02d9,  0xffff02da,  0xffff02db,  0xffff02dc,  0xffff02dd,  0xffff02de,  0xffff02df,  0xffff02e0,  0xffff02e1,  0xffff02e2,  0xffff02e3,  0xffff02e4,  0xffff02e5,  0xffff02e6,  0xffff02e7,  0xffff02e8,  0xffff02e9,  0xffff02ea,  0xffff02eb,  0xffff02ec,  0xffff02ed,  0xffff02ee,  0xffff02ef,  0xffff02f0,  0xffff02f1,  0xffff02f2,  0xffff02f3,  0xffff02f4,  0xffff02f5,  0xffff02f6,  0xffff02f7,  0xffff02f8,  0xffff02f9,  0xffff02fa,  0xffff02fb,  0xffff02fc,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2fe02fd,  0x30002ff,  0x3020301,  0x3040303,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3060305,  0x3080307,  0x30a0309,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x30c030b,  0x30e030d,  0x310030f,  0x3120311,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3140313,  0x3160315,  0x3180317,  0x31a0319,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x31c031b,  0x31e031d,  0x320031f,  0xffffffff,  0xffff05b2,  0xffff05b3,  0xffff05b4,  0xffff05b5,  0x321ffff,  0x322ffff,  0x323ffff,  0x324ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3260325,  0x3280327,  0x32a0329,  0x32c032b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5c305c2,  0x5c505c4,  0x5c705c6,  0x5c905c8,  0x5cb05ca,  0x5cd05cc,  0x5cf05ce,  0x5d105d0,  0x5d305d2,  0x5d505d4,  0x5d705d6,  0x5d905d8,  0x5db05da,  0x5dd05dc,  0x5df05de,  0x5e105e0,  0x5e305e2,  0x5e505e4,  0x5e705e6,  0x5e905e8,  0x5eb05ea,  0x5ed05ec,  0x5ef05ee,  0x5f105f0,  0xffffffff,  0x5f205f8,  0xffff05f9,  0x5fe05b6,  0x3460345,  0x3480347,  0xffff05f3,  0xffffffff,  0xffffffff,  0x5f405fa,  0xffff05fb,  0x5ff05b7,  0x34b034a,  0x34d034c,  0xffff05f5,  0xffffffff,  0xffffffff,  0x5b905b8,  0xffffffff,  0x5bb05ba,  0x350034f,  0x3520351,  0xffffffff,  0xffffffff,  0xffffffff,  0x5bd05bc,  0xffff05be,  0x5c005bf,  0x3540353,  0x3560355,  0xffff0357,  0xffffffff,  0xffffffff,  0x5f605fc,  0xffff05fd,  0x60005c1,  0x3590358,  0x35b035a,  0xffff05f7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff035d,  0xffffffff,  0x35f035e,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0360,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3620361,  0x3640363,  0x3660365,  0x3680367,  0x36a0369,  0x36c036b,  0x36e036d,  0x370036f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x371ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3730372,  0x3750374,  0x3770376,  0x3790378,  0x37b037a,  0x37d037c,  0x37f037e,  0x3810380,  0x3830382,  0x3850384,  0x3870386,  0x3890388,  0x38b038a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x38d038c,  0x38f038e,  0x3910390,  0x3930392,  0x3950394,  0x3970396,  0x3990398,  0x39b039a,  0x39d039c,  0x39f039e,  0x3a103a0,  0x3a303a2,  0x3a503a4,  0x3a703a6,  0x3a903a8,  0x3ab03aa,  0x3ad03ac,  0x3af03ae,  0x3b103b0,  0x3b303b2,  0x3b503b4,  0x3b703b6,  0x3b903b8,  0x3bb03ba,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff03bc,  0x3be03bd,  0xffff03bf,  0x3c0ffff,  0x3c1ffff,  0x3c2ffff,  0x3c3ffff,  0x3c503c4,  0xffff03c6,  0xffff03c7,  0x3c8ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3ca03c9,  0xffff03cb,  0xffff03cc,  0xffff03cd,  0xffff03ce,  0xffff03cf,  0xffff03d0,  0xffff03d1,  0xffff03d2,  0xffff03d3,  0xffff03d4,  0xffff03d5,  0xffff03d6,  0xffff03d7,  0xffff03d8,  0xffff03d9,  0xffff03da,  0xffff03db,  0xffff03dc,  0xffff03dd,  0xffff03de,  0xffff03df,  0xffff03e0,  0xffff03e1,  0xffff03e2,  0xffff03e3,  0xffff03e4,  0xffff03e5,  0xffff03e6,  0xffff03e7,  0xffff03e8,  0xffff03e9,  0xffff03ea,  0xffff03eb,  0xffff03ec,  0xffff03ed,  0xffff03ee,  0xffff03ef,  0xffff03f0,  0xffff03f1,  0xffff03f2,  0xffff03f3,  0xffff03f4,  0xffff03f5,  0xffff03f6,  0xffff03f7,  0xffff03f8,  0xffff03f9,  0xffff03fa,  0xffff03fb,  0xffff03fc,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fdffff,  0x3feffff,  0xffffffff,  0xffffffff,  0xffff03ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0400,  0xffff0401,  0xffff0402,  0xffff0403,  0xffff0404,  0xffff0405,  0xffff0406,  0xffff0407,  0xffff0408,  0xffff0409,  0xffff040a,  0xffff040b,  0xffff040c,  0xffff040d,  0xffff040e,  0xffff040f,  0xffff0410,  0xffff0411,  0xffff0412,  0xffff0413,  0xffff0414,  0xffff0415,  0xffff0416,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0417,  0xffff0418,  0xffff0419,  0xffff041a,  0xffff041b,  0xffff041c,  0xffff041d,  0xffff041e,  0xffff041f,  0xffff0420,  0xffff0421,  0xffff0422,  0xffff0423,  0xffff0424,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0425,  0xffff0426,  0xffff0427,  0xffff0428,  0xffff0429,  0xffff042a,  0xffff042b,  0xffffffff,  0xffff042c,  0xffff042d,  0xffff042e,  0xffff042f,  0xffff0430,  0xffff0431,  0xffff0432,  0xffff0433,  0xffff0434,  0xffff0435,  0xffff0436,  0xffff0437,  0xffff0438,  0xffff0439,  0xffff043a,  0xffff043b,  0xffff043c,  0xffff043d,  0xffff043e,  0xffff043f,  0xffff0440,  0xffff0441,  0xffff0442,  0xffff0443,  0xffff0444,  0xffff0445,  0xffff0446,  0xffff0447,  0xffff0448,  0xffff0449,  0xffff044a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x44bffff,  0x44cffff,  0x44dffff,  0xffff044e,  0xffff044f,  0xffff0450,  0xffff0451,  0xffff0452,  0xffffffff,  0x453ffff,  0x454ffff,  0xffffffff,  0xffff0455,  0xffff0456,  0xffffffff,  0xffff0457,  0xffff0458,  0xffff0459,  0xffff045a,  0xffff045b,  0xffff045c,  0xffff045d,  0xffff045e,  0xffff045f,  0xffff0460,  0x4620461,  0x4640463,  0xffff0465,  0x4670466,  0x4690468,  0xffff046a,  0xffff046b,  0xffff046c,  0xffff046d,  0xffff046e,  0xffff046f,  0xffff0470,  0xffff0471,  0x4730472,  0x4750474,  0x476ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0477,  0xffffffff,  0xffffffff,  0xffff0478,  0xffff0479,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x47affff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x59d059c,  0x59f059e,  0x5a105a0,  0xffff05a2,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5a4ffff,  0x5a605a5,  0x5a805a7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x47bffff,  0x47d047c,  0x47f047e,  0x4810480,  0x4830482,  0x4850484,  0x4870486,  0x4890488,  0x48b048a,  0x48d048c,  0x48f048e,  0x4910490,  0x4930492,  0xffff0494,  0xffffffff,  0xffffffff,  0x4960495,  0x4980497,  0x49a0499,  0x49c049b,  0x49e049d,  0x4a0049f,  0x4a204a1,  0x4a404a3,  0x4a604a5,  0x4a804a7,  0x4aa04a9,  0x4ac04ab,  0x4ae04ad,  0x4b004af,  0x4b204b1,  0x4b404b3,  0x4b604b5,  0x4b804b7,  0x4ba04b9,  0x4bc04bb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4be04bd,  0x4c004bf,  0x4c204c1,  0x4c404c3,  0x4c604c5,  0x4c804c7,  0x4ca04c9,  0x4cc04cb,  0x4ce04cd,  0x4d004cf,  0x4d204d1,  0x4d404d3,  0x4d604d5,  0x4d804d7,  0x4da04d9,  0x4dc04db,  0x4de04dd,  0x4e004df,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4e204e1,  0x4e404e3,  0x4e604e5,  0x4e804e7,  0x4ea04e9,  0xffff04eb,  0x4ed04ec,  0x4ef04ee,  0x4f104f0,  0x4f304f2,  0x4f504f4,  0x4f704f6,  0x4f904f8,  0xffff04fa,  0x4fc04fb,  0x4fe04fd,  0x50004ff,  0xffff0501,  0x5030502,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5050504,  0x5070506,  0x5090508,  0x50b050a,  0x50d050c,  0x50f050e,  0x5110510,  0x5130512,  0x5150514,  0x5170516,  0x5190518,  0x51b051a,  0x51d051c,  0x51f051e,  0x5210520,  0x5230522,  0x5250524,  0x5270526,  0x5290528,  0x52b052a,  0x52d052c,  0x52f052e,  0x5310530,  0x5330532,  0x5350534,  0xffff0536,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5380537,  0x53a0539,  0x53c053b,  0x53e053d,  0x540053f,  0x5420541,  0x5440543,  0x5460545,  0x5480547,  0x54a0549,  0x54c054b,  0x54e054d,  0x550054f,  0x5520551,  0x5540553,  0x5560555,  0x5580557,  0x55a0559,  0x55c055b,  0x55e055d,  0x560055f,  0x5620561,  0x5640563,  0x5660565,  0x5680567,  0x56a0569,  0x56c056b,  0x56e056d,  0x570056f,  0x5720571,  0x5740573,  0x5760575,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5780577,  0x57a0579,  0x57c057b,  0x57e057d,  0x580057f,  0x5820581,  0x5840583,  0x5860585,  0x5880587,  0x58a0589,  0x58c058b,  0x58e058d,  0x590058f,  0x5920591,  0x5940593,  0x5960595,  0x5980597,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff]);
//10496 bytes
enum toTitleIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x40,  0x280], [ 0x100,  0x480,  0xf80], [ 0x2020100,  0x4020302,  0x6020205,  0x7020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x10000,  0x30002,  0x50004,  0x70006,  0x90008,  0xa,  0xb0000,  0xd000c,  0xf000e,  0x110010,  0x130012,  0x14,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x150000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x160000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x17,  0x180000,  0x19,  0x1b001a,  0x1d001c,  0x1f001e,  0x210020,  0x0,  0x0,  0x220000,  0x23,  0x0,  0x0,  0x0,  0x0,  0x0,  0x240000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x260025,  0x280027,  0x29,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2a0000,  0x2b,  0x2d002c,  0x2f002e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x300000,  0x31,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x32,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x330000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x350034,  0x360000,  0x0,  0x37,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x380000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x390000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3a0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3c003b,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x20001,  0x40003,  0x60005,  0x80007,  0xa0009,  0xc000b,  0xe000d,  0x10000f,  0x120011,  0x140013,  0x160015,  0x180017,  0xffff0019,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1affff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5aeffff,  0x1c001b,  0x1e001d,  0x20001f,  0x220021,  0x240023,  0x260025,  0x280027,  0x2a0029,  0x2c002b,  0x2e002d,  0x30002f,  0xffff0031,  0x330032,  0x350034,  0x370036,  0x390038,  0x3affff,  0x3bffff,  0x3cffff,  0x3dffff,  0x3effff,  0x3fffff,  0x40ffff,  0x41ffff,  0x42ffff,  0x43ffff,  0x44ffff,  0x45ffff,  0x46ffff,  0x47ffff,  0x48ffff,  0x49ffff,  0x4affff,  0x4bffff,  0x4cffff,  0x4dffff,  0x4effff,  0x4fffff,  0x50ffff,  0x51ffff,  0x5205b0,  0x53ffff,  0x54ffff,  0x55ffff,  0xffffffff,  0xffff0056,  0xffff0057,  0xffff0058,  0xffff0059,  0xffff005a,  0xffff005b,  0xffff005c,  0x5cd005d,  0x5effff,  0x5fffff,  0x60ffff,  0x61ffff,  0x62ffff,  0x63ffff,  0x64ffff,  0x65ffff,  0x66ffff,  0x67ffff,  0x68ffff,  0x69ffff,  0x6affff,  0x6bffff,  0x6cffff,  0x6dffff,  0x6effff,  0x6fffff,  0x70ffff,  0x71ffff,  0x72ffff,  0x73ffff,  0x74ffff,  0xffffffff,  0xffff0075,  0xffff0076,  0x780077,  0xffff0079,  0x7affff,  0x7bffff,  0xffffffff,  0xffff007c,  0xffffffff,  0xffff007d,  0xffffffff,  0xffffffff,  0xffff007e,  0x7fffff,  0xffffffff,  0x80ffff,  0xffff0081,  0xffffffff,  0xffff0082,  0x83ffff,  0x84ffff,  0x85ffff,  0xffffffff,  0xffff0086,  0xffffffff,  0x87ffff,  0xffffffff,  0xffff0088,  0xffffffff,  0xffff0089,  0xffff008a,  0x8bffff,  0xffffffff,  0x8cffff,  0x8dffff,  0xffffffff,  0xffffffff,  0x8f008e,  0x910090,  0x930092,  0x950094,  0xffff0096,  0xffff0097,  0xffff0098,  0xffff0099,  0xffff009a,  0xffff009b,  0xffff009c,  0xffff009d,  0x9f009e,  0xa0ffff,  0xa1ffff,  0xa2ffff,  0xa3ffff,  0xa4ffff,  0xa5ffff,  0xa6ffff,  0xa7ffff,  0xa8ffff,  0xa905d5,  0xab00aa,  0xacffff,  0xffffffff,  0xadffff,  0xaeffff,  0xafffff,  0xb0ffff,  0xb1ffff,  0xb2ffff,  0xb3ffff,  0xb4ffff,  0xb5ffff,  0xb6ffff,  0xb7ffff,  0xb8ffff,  0xb9ffff,  0xbaffff,  0xbbffff,  0xbcffff,  0xbdffff,  0xbeffff,  0xbfffff,  0xc0ffff,  0xffffffff,  0xc1ffff,  0xc2ffff,  0xc3ffff,  0xc4ffff,  0xc5ffff,  0xc6ffff,  0xc7ffff,  0xc8ffff,  0xc9ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff00ca,  0xcbffff,  0xffff00cc,  0xffff00cd,  0xffffffff,  0xceffff,  0xcfffff,  0xd0ffff,  0xd1ffff,  0xd2ffff,  0xd400d3,  0xd600d5,  0xffff00d7,  0xd900d8,  0xdaffff,  0xdbffff,  0xffff00dc,  0xffffffff,  0xde00dd,  0xdfffff,  0xe0ffff,  0xffff00e1,  0xe300e2,  0xe500e4,  0xffff00e6,  0xe7ffff,  0xe8ffff,  0xffff00e9,  0xeaffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xebffff,  0xffffffff,  0xffff00ec,  0xee00ed,  0xffffffff,  0xefffff,  0xf100f0,  0xf300f2,  0xffff00f4,  0xffffffff,  0xffffffff,  0xffff00f5,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf6ffff,  0xffff00f7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf8ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf9ffff,  0xfaffff,  0xffffffff,  0xfbffff,  0xffffffff,  0xfcffff,  0xfe00fd,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff05cf,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x10000ff,  0x1020101,  0x10305d2,  0x1050104,  0x1070106,  0x1090108,  0x10b010a,  0x10d010c,  0x10f010e,  0x1110110,  0x1130112,  0x1150114,  0x1170116,  0x1190118,  0x11b011a,  0x11d011c,  0x11f011e,  0xffff0120,  0x1220121,  0xffffffff,  0x123ffff,  0x1250124,  0x126ffff,  0x127ffff,  0x128ffff,  0x129ffff,  0x12affff,  0x12bffff,  0x12cffff,  0x12dffff,  0x12effff,  0x12fffff,  0x130ffff,  0x131ffff,  0x1330132,  0x1350134,  0x136ffff,  0xffffffff,  0xffff0137,  0x138ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x13a0139,  0x13c013b,  0x13e013d,  0x140013f,  0x1420141,  0x1440143,  0x1460145,  0x1480147,  0x14a0149,  0x14c014b,  0x14e014d,  0x150014f,  0x1520151,  0x1540153,  0x1560155,  0x1580157,  0x15a0159,  0x15c015b,  0x15e015d,  0x160015f,  0x1620161,  0x1640163,  0x1660165,  0x1680167,  0x169ffff,  0x16affff,  0x16bffff,  0x16cffff,  0x16dffff,  0x16effff,  0x16fffff,  0x170ffff,  0x171ffff,  0x172ffff,  0x173ffff,  0x174ffff,  0x175ffff,  0x176ffff,  0x177ffff,  0x178ffff,  0x179ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x17affff,  0x17bffff,  0x17cffff,  0x17dffff,  0x17effff,  0x17fffff,  0x180ffff,  0x181ffff,  0x182ffff,  0x183ffff,  0x184ffff,  0x185ffff,  0x186ffff,  0x187ffff,  0x188ffff,  0x189ffff,  0x18affff,  0x18bffff,  0x18cffff,  0x18dffff,  0x18effff,  0x18fffff,  0x190ffff,  0x191ffff,  0x192ffff,  0x193ffff,  0x194ffff,  0xffffffff,  0xffff0195,  0xffff0196,  0xffff0197,  0xffff0198,  0xffff0199,  0xffff019a,  0x19c019b,  0x19dffff,  0x19effff,  0x19fffff,  0x1a0ffff,  0x1a1ffff,  0x1a2ffff,  0x1a3ffff,  0x1a4ffff,  0x1a5ffff,  0x1a6ffff,  0x1a7ffff,  0x1a8ffff,  0x1a9ffff,  0x1aaffff,  0x1abffff,  0x1acffff,  0x1adffff,  0x1aeffff,  0x1afffff,  0x1b0ffff,  0x1b1ffff,  0x1b2ffff,  0x1b3ffff,  0x1b4ffff,  0x1b5ffff,  0x1b6ffff,  0x1b7ffff,  0x1b8ffff,  0x1b9ffff,  0x1baffff,  0x1bbffff,  0x1bcffff,  0x1bdffff,  0x1beffff,  0x1bfffff,  0x1c0ffff,  0x1c1ffff,  0x1c2ffff,  0x1c3ffff,  0x1c4ffff,  0x1c5ffff,  0x1c6ffff,  0x1c7ffff,  0x1c8ffff,  0x1c9ffff,  0x1caffff,  0x1cbffff,  0x1ccffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1cdffff,  0x1cf01ce,  0x1d101d0,  0x1d301d2,  0x1d501d4,  0x1d701d6,  0x1d901d8,  0x1db01da,  0x1dd01dc,  0x1df01de,  0x1e101e0,  0x1e301e2,  0x1e501e4,  0x1e701e6,  0x1e901e8,  0x1eb01ea,  0x1ed01ec,  0x1ef01ee,  0x1f101f0,  0x5c101f2,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1f401f3,  0x1f601f5,  0x1f801f7,  0x1fa01f9,  0x1fc01fb,  0x1fe01fd,  0x20001ff,  0x2020201,  0x2040203,  0x2060205,  0x2080207,  0x20a0209,  0x20c020b,  0x20e020d,  0x210020f,  0x2120211,  0x2140213,  0x2160215,  0x2180217,  0x21a0219,  0x21c021b,  0xffff021d,  0x21effff,  0x220021f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2220221,  0x2240223,  0x2260225,  0xffffffff,  0x2280227,  0x22a0229,  0x22c022b,  0x22e022d,  0xffff022f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x230ffff,  0xffffffff,  0x231ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0232,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x233ffff,  0x234ffff,  0x235ffff,  0x236ffff,  0x237ffff,  0x238ffff,  0x239ffff,  0x23affff,  0x23bffff,  0x23cffff,  0x23dffff,  0x23effff,  0x23fffff,  0x240ffff,  0x241ffff,  0x242ffff,  0x243ffff,  0x244ffff,  0x245ffff,  0x246ffff,  0x247ffff,  0x248ffff,  0x249ffff,  0x24affff,  0x24bffff,  0x24cffff,  0x24dffff,  0x24effff,  0x24fffff,  0x250ffff,  0x251ffff,  0x252ffff,  0x253ffff,  0x254ffff,  0x255ffff,  0x256ffff,  0x257ffff,  0x258ffff,  0x259ffff,  0x25affff,  0x25bffff,  0x25cffff,  0x25dffff,  0x25effff,  0x25fffff,  0x260ffff,  0x261ffff,  0x262ffff,  0x263ffff,  0x264ffff,  0x265ffff,  0x266ffff,  0x267ffff,  0x268ffff,  0x269ffff,  0x26affff,  0x26bffff,  0x26cffff,  0x26dffff,  0x26effff,  0x26fffff,  0x270ffff,  0x271ffff,  0x272ffff,  0x273ffff,  0x274ffff,  0x275ffff,  0x276ffff,  0x277ffff,  0x278ffff,  0x279ffff,  0x27affff,  0x27bffff,  0x27cffff,  0x27dffff,  0x5d905d7,  0x5dd05db,  0x27e05df,  0xffffffff,  0xffffffff,  0x27fffff,  0x280ffff,  0x281ffff,  0x282ffff,  0x283ffff,  0x284ffff,  0x285ffff,  0x286ffff,  0x287ffff,  0x288ffff,  0x289ffff,  0x28affff,  0x28bffff,  0x28cffff,  0x28dffff,  0x28effff,  0x28fffff,  0x290ffff,  0x291ffff,  0x292ffff,  0x293ffff,  0x294ffff,  0x295ffff,  0x296ffff,  0x297ffff,  0x298ffff,  0x299ffff,  0x29affff,  0x29bffff,  0x29cffff,  0x29dffff,  0x29effff,  0x29fffff,  0x2a0ffff,  0x2a1ffff,  0x2a2ffff,  0x2a3ffff,  0x2a4ffff,  0x2a5ffff,  0x2a6ffff,  0x2a7ffff,  0x2a8ffff,  0x2a9ffff,  0x2aaffff,  0x2abffff,  0x2acffff,  0x2adffff,  0x2aeffff,  0x2b002af,  0x2b202b1,  0x2b402b3,  0x2b602b5,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2b802b7,  0x2ba02b9,  0x2bc02bb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2be02bd,  0x2c002bf,  0x2c202c1,  0x2c402c3,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2c602c5,  0x2c802c7,  0x2ca02c9,  0x2cc02cb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2ce02cd,  0x2d002cf,  0x2d202d1,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2d305e1,  0x2d405e3,  0x2d505e6,  0x2d605e9,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2d802d7,  0x2da02d9,  0x2dc02db,  0x2de02dd,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2e002df,  0x2e202e1,  0x2e402e3,  0x2e602e5,  0x2e802e7,  0x2ea02e9,  0x2ec02eb,  0xffffffff,  0x60b060a,  0x60d060c,  0x60f060e,  0x6110610,  0x6130612,  0x6150614,  0x6170616,  0x6190618,  0x61b061a,  0x61d061c,  0x61f061e,  0x6210620,  0x6230622,  0x6250624,  0x6270626,  0x6290628,  0x62b062a,  0x62d062c,  0x62f062e,  0x6310630,  0x6330632,  0x6350634,  0x6370636,  0x6390638,  0x3060305,  0x63a0640,  0xffff0642,  0x64c05ec,  0xffffffff,  0xffffffff,  0xffff063b,  0xffff0308,  0xffffffff,  0x63c0644,  0xffff0646,  0x64f05ee,  0xffffffff,  0xffffffff,  0xffff063d,  0xffffffff,  0x30b030a,  0x5f305f0,  0xffffffff,  0x5f805f6,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x30d030c,  0x5fe05fb,  0x30e0601,  0x6050603,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x63e0648,  0xffff064a,  0x6520608,  0xffffffff,  0xffffffff,  0xffff063f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0310,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3120311,  0x3140313,  0x3160315,  0x3180317,  0x31a0319,  0x31c031b,  0x31e031d,  0x320031f,  0xffffffff,  0xffffffff,  0xffff0321,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3230322,  0x3250324,  0x3270326,  0x3290328,  0x32b032a,  0x32d032c,  0x32f032e,  0x3310330,  0x3330332,  0x3350334,  0x3370336,  0x3390338,  0x33b033a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x33d033c,  0x33f033e,  0x3410340,  0x3430342,  0x3450344,  0x3470346,  0x3490348,  0x34b034a,  0x34d034c,  0x34f034e,  0x3510350,  0x3530352,  0x3550354,  0x3570356,  0x3590358,  0x35b035a,  0x35d035c,  0x35f035e,  0x3610360,  0x3630362,  0x3650364,  0x3670366,  0x3690368,  0x36b036a,  0x36cffff,  0xffffffff,  0x36dffff,  0xffff036e,  0xffff036f,  0xffff0370,  0xffff0371,  0xffffffff,  0xffffffff,  0x372ffff,  0xffffffff,  0xffff0373,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x374ffff,  0x375ffff,  0x376ffff,  0x377ffff,  0x378ffff,  0x379ffff,  0x37affff,  0x37bffff,  0x37cffff,  0x37dffff,  0x37effff,  0x37fffff,  0x380ffff,  0x381ffff,  0x382ffff,  0x383ffff,  0x384ffff,  0x385ffff,  0x386ffff,  0x387ffff,  0x388ffff,  0x389ffff,  0x38affff,  0x38bffff,  0x38cffff,  0x38dffff,  0x38effff,  0x38fffff,  0x390ffff,  0x391ffff,  0x392ffff,  0x393ffff,  0x394ffff,  0x395ffff,  0x396ffff,  0x397ffff,  0x398ffff,  0x399ffff,  0x39affff,  0x39bffff,  0x39cffff,  0x39dffff,  0x39effff,  0x39fffff,  0x3a0ffff,  0x3a1ffff,  0x3a2ffff,  0x3a3ffff,  0x3a4ffff,  0x3a5ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff03a6,  0xffff03a7,  0xffffffff,  0x3a8ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3aa03a9,  0x3ac03ab,  0x3ae03ad,  0x3b003af,  0x3b203b1,  0x3b403b3,  0x3b603b5,  0x3b803b7,  0x3ba03b9,  0x3bc03bb,  0x3be03bd,  0x3c003bf,  0x3c203c1,  0x3c403c3,  0x3c603c5,  0x3c803c7,  0x3ca03c9,  0x3cc03cb,  0x3ce03cd,  0x3cfffff,  0xffffffff,  0xffffffff,  0x3d0ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3d1ffff,  0x3d2ffff,  0x3d3ffff,  0x3d4ffff,  0x3d5ffff,  0x3d6ffff,  0x3d7ffff,  0x3d8ffff,  0x3d9ffff,  0x3daffff,  0x3dbffff,  0x3dcffff,  0x3ddffff,  0x3deffff,  0x3dfffff,  0x3e0ffff,  0x3e1ffff,  0x3e2ffff,  0x3e3ffff,  0x3e4ffff,  0x3e5ffff,  0x3e6ffff,  0x3e7ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3e8ffff,  0x3e9ffff,  0x3eaffff,  0x3ebffff,  0x3ecffff,  0x3edffff,  0x3eeffff,  0x3efffff,  0x3f0ffff,  0x3f1ffff,  0x3f2ffff,  0x3f3ffff,  0x3f4ffff,  0x3f5ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3f6ffff,  0x3f7ffff,  0x3f8ffff,  0x3f9ffff,  0x3faffff,  0x3fbffff,  0x3fcffff,  0xffffffff,  0x3fdffff,  0x3feffff,  0x3ffffff,  0x400ffff,  0x401ffff,  0x402ffff,  0x403ffff,  0x404ffff,  0x405ffff,  0x406ffff,  0x407ffff,  0x408ffff,  0x409ffff,  0x40affff,  0x40bffff,  0x40cffff,  0x40dffff,  0x40effff,  0x40fffff,  0x410ffff,  0x411ffff,  0x412ffff,  0x413ffff,  0x414ffff,  0x415ffff,  0x416ffff,  0x417ffff,  0x418ffff,  0x419ffff,  0x41affff,  0x41bffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff041c,  0xffff041d,  0x41effff,  0x41fffff,  0x420ffff,  0x421ffff,  0x422ffff,  0xffffffff,  0xffffffff,  0xffff0423,  0xffffffff,  0x424ffff,  0x425ffff,  0xffff0426,  0x427ffff,  0x428ffff,  0x429ffff,  0x42affff,  0x42bffff,  0x42cffff,  0x42dffff,  0x42effff,  0x42fffff,  0x430ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x431ffff,  0x432ffff,  0x433ffff,  0x434ffff,  0x435ffff,  0x436ffff,  0x437ffff,  0x438ffff,  0xffffffff,  0xffffffff,  0xffff0439,  0xffff043a,  0xffffffff,  0xffffffff,  0x43bffff,  0xffffffff,  0xffffffff,  0x43cffff,  0x43dffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff043e,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x43fffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4410440,  0x4430442,  0x4450444,  0x4470446,  0x4490448,  0x44b044a,  0x44d044c,  0x44f044e,  0x4510450,  0x4530452,  0x4550454,  0x4570456,  0x4590458,  0x45b045a,  0x45d045c,  0x45f045e,  0x4610460,  0x4630462,  0x4650464,  0x4670466,  0x4690468,  0x46b046a,  0x46d046c,  0x46f046e,  0x4710470,  0x4730472,  0x4750474,  0x4770476,  0x4790478,  0x47b047a,  0x47d047c,  0x47f047e,  0x4810480,  0x4830482,  0x4850484,  0x4870486,  0x4890488,  0x48b048a,  0x48d048c,  0x48f048e,  0x5b305b1,  0x5b705b5,  0x5bd05ba,  0xffff05bf,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5c3ffff,  0x5c705c5,  0x5cb05c9,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x490ffff,  0x4920491,  0x4940493,  0x4960495,  0x4980497,  0x49a0499,  0x49c049b,  0x49e049d,  0x4a0049f,  0x4a204a1,  0x4a404a3,  0x4a604a5,  0x4a804a7,  0xffff04a9,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4ab04aa,  0x4ad04ac,  0x4af04ae,  0x4b104b0,  0x4b304b2,  0x4b504b4,  0x4b704b6,  0x4b904b8,  0x4bb04ba,  0x4bd04bc,  0x4bf04be,  0x4c104c0,  0x4c304c2,  0x4c504c4,  0x4c704c6,  0x4c904c8,  0x4cb04ca,  0x4cd04cc,  0x4cf04ce,  0x4d104d0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4d304d2,  0x4d504d4,  0x4d704d6,  0x4d904d8,  0x4db04da,  0x4dd04dc,  0x4df04de,  0x4e104e0,  0x4e304e2,  0x4e504e4,  0x4e704e6,  0x4e904e8,  0x4eb04ea,  0x4ed04ec,  0x4ef04ee,  0x4f104f0,  0x4f304f2,  0x4f504f4,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4f6ffff,  0x4f804f7,  0x4fa04f9,  0x4fc04fb,  0x4fe04fd,  0x50004ff,  0x501ffff,  0x5030502,  0x5050504,  0x5070506,  0x5090508,  0x50b050a,  0x50d050c,  0x50f050e,  0x510ffff,  0x5120511,  0x5140513,  0x5160515,  0x517ffff,  0xffff0518,  0xffffffff,  0x51a0519,  0x51c051b,  0x51e051d,  0x520051f,  0x5220521,  0x5240523,  0x5260525,  0x5280527,  0x52a0529,  0x52c052b,  0x52e052d,  0x530052f,  0x5320531,  0x5340533,  0x5360535,  0x5380537,  0x53a0539,  0x53c053b,  0x53e053d,  0x540053f,  0x5420541,  0x5440543,  0x5460545,  0x5480547,  0x54a0549,  0xffff054b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x54d054c,  0x54f054e,  0x5510550,  0x5530552,  0x5550554,  0x5570556,  0x5590558,  0x55b055a,  0x55d055c,  0x55f055e,  0x5610560,  0x5630562,  0x5650564,  0x5670566,  0x5690568,  0x56b056a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x56d056c,  0x56f056e,  0x5710570,  0x5730572,  0x5750574,  0x5770576,  0x5790578,  0x57b057a,  0x57d057c,  0x57f057e,  0x5810580,  0x5830582,  0x5850584,  0x5870586,  0x5890588,  0x58b058a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x58d058c,  0x58f058e,  0x5910590,  0x5930592,  0x5950594,  0x5970596,  0x5990598,  0x59b059a,  0x59d059c,  0x59f059e,  0x5a105a0,  0x5a305a2,  0x5a505a4,  0x5a705a6,  0x5a905a8,  0x5ab05aa,  0x5ad05ac,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff]);
//10368 bytes
enum toUpperSimpleIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x40,  0x280], [ 0x100,  0x480,  0xf40], [ 0x2020100,  0x4020302,  0x6020205,  0x7020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x10000,  0x30002,  0x50004,  0x70006,  0x90008,  0xa,  0xb0000,  0xd000c,  0xf000e,  0x110010,  0x130012,  0x14,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x150000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x160000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x17,  0x180000,  0x19,  0x1b001a,  0x1d001c,  0x1f001e,  0x210020,  0x0,  0x0,  0x220000,  0x23,  0x0,  0x0,  0x0,  0x0,  0x0,  0x240000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x260025,  0x280027,  0x29,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2a0000,  0x2b,  0x2d002c,  0x2f002e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x300000,  0x31,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x320000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x340033,  0x350000,  0x0,  0x36,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x370000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x380000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x390000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3b003a,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x20001,  0x40003,  0x60005,  0x80007,  0xa0009,  0xc000b,  0xe000d,  0x10000f,  0x120011,  0x140013,  0x160015,  0x180017,  0xffff0019,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1affff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1c001b,  0x1e001d,  0x20001f,  0x220021,  0x240023,  0x260025,  0x280027,  0x2a0029,  0x2c002b,  0x2e002d,  0x30002f,  0xffff0031,  0x330032,  0x350034,  0x370036,  0x390038,  0x3affff,  0x3bffff,  0x3cffff,  0x3dffff,  0x3effff,  0x3fffff,  0x40ffff,  0x41ffff,  0x42ffff,  0x43ffff,  0x44ffff,  0x45ffff,  0x46ffff,  0x47ffff,  0x48ffff,  0x49ffff,  0x4affff,  0x4bffff,  0x4cffff,  0x4dffff,  0x4effff,  0x4fffff,  0x50ffff,  0x51ffff,  0x52ffff,  0x53ffff,  0x54ffff,  0x55ffff,  0xffffffff,  0xffff0056,  0xffff0057,  0xffff0058,  0xffff0059,  0xffff005a,  0xffff005b,  0xffff005c,  0xffff005d,  0x5effff,  0x5fffff,  0x60ffff,  0x61ffff,  0x62ffff,  0x63ffff,  0x64ffff,  0x65ffff,  0x66ffff,  0x67ffff,  0x68ffff,  0x69ffff,  0x6affff,  0x6bffff,  0x6cffff,  0x6dffff,  0x6effff,  0x6fffff,  0x70ffff,  0x71ffff,  0x72ffff,  0x73ffff,  0x74ffff,  0xffffffff,  0xffff0075,  0xffff0076,  0x780077,  0xffff0079,  0x7affff,  0x7bffff,  0xffffffff,  0xffff007c,  0xffffffff,  0xffff007d,  0xffffffff,  0xffffffff,  0xffff007e,  0x7fffff,  0xffffffff,  0x80ffff,  0xffff0081,  0xffffffff,  0xffff0082,  0x83ffff,  0x84ffff,  0x85ffff,  0xffffffff,  0xffff0086,  0xffffffff,  0x87ffff,  0xffffffff,  0xffff0088,  0xffffffff,  0xffff0089,  0xffff008a,  0x8bffff,  0xffffffff,  0x8cffff,  0x8dffff,  0xffffffff,  0xffffffff,  0x8effff,  0xffff008f,  0x910090,  0x92ffff,  0xffff0093,  0xffff0094,  0xffff0095,  0xffff0096,  0xffff0097,  0xffff0098,  0xffff0099,  0xffff009a,  0x9c009b,  0x9dffff,  0x9effff,  0x9fffff,  0xa0ffff,  0xa1ffff,  0xa2ffff,  0xa3ffff,  0xa4ffff,  0xa5ffff,  0xffffffff,  0xa700a6,  0xa8ffff,  0xffffffff,  0xa9ffff,  0xaaffff,  0xabffff,  0xacffff,  0xadffff,  0xaeffff,  0xafffff,  0xb0ffff,  0xb1ffff,  0xb2ffff,  0xb3ffff,  0xb4ffff,  0xb5ffff,  0xb6ffff,  0xb7ffff,  0xb8ffff,  0xb9ffff,  0xbaffff,  0xbbffff,  0xbcffff,  0xffffffff,  0xbdffff,  0xbeffff,  0xbfffff,  0xc0ffff,  0xc1ffff,  0xc2ffff,  0xc3ffff,  0xc4ffff,  0xc5ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff00c6,  0xc7ffff,  0xffff00c8,  0xffff00c9,  0xffffffff,  0xcaffff,  0xcbffff,  0xccffff,  0xcdffff,  0xceffff,  0xd000cf,  0xd200d1,  0xffff00d3,  0xd500d4,  0xd6ffff,  0xd7ffff,  0xffff00d8,  0xffffffff,  0xda00d9,  0xdbffff,  0xdcffff,  0xffff00dd,  0xdf00de,  0xe100e0,  0xffff00e2,  0xe3ffff,  0xe4ffff,  0xffff00e5,  0xe6ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xe7ffff,  0xffffffff,  0xffff00e8,  0xea00e9,  0xffffffff,  0xebffff,  0xed00ec,  0xef00ee,  0xffff00f0,  0xffffffff,  0xffffffff,  0xffff00f1,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf2ffff,  0xffff00f3,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf4ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf5ffff,  0xf6ffff,  0xffffffff,  0xf7ffff,  0xffffffff,  0xf8ffff,  0xfa00f9,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xfc00fb,  0xfe00fd,  0xffffff,  0x1010100,  0x1030102,  0x1050104,  0x1070106,  0x1090108,  0x10b010a,  0x10d010c,  0x10f010e,  0x1110110,  0x1130112,  0x1150114,  0x1170116,  0x1190118,  0x11b011a,  0xffff011c,  0x11e011d,  0xffffffff,  0x11fffff,  0x1210120,  0x122ffff,  0x123ffff,  0x124ffff,  0x125ffff,  0x126ffff,  0x127ffff,  0x128ffff,  0x129ffff,  0x12affff,  0x12bffff,  0x12cffff,  0x12dffff,  0x12f012e,  0x1310130,  0x132ffff,  0xffffffff,  0xffff0133,  0x134ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1360135,  0x1380137,  0x13a0139,  0x13c013b,  0x13e013d,  0x140013f,  0x1420141,  0x1440143,  0x1460145,  0x1480147,  0x14a0149,  0x14c014b,  0x14e014d,  0x150014f,  0x1520151,  0x1540153,  0x1560155,  0x1580157,  0x15a0159,  0x15c015b,  0x15e015d,  0x160015f,  0x1620161,  0x1640163,  0x165ffff,  0x166ffff,  0x167ffff,  0x168ffff,  0x169ffff,  0x16affff,  0x16bffff,  0x16cffff,  0x16dffff,  0x16effff,  0x16fffff,  0x170ffff,  0x171ffff,  0x172ffff,  0x173ffff,  0x174ffff,  0x175ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x176ffff,  0x177ffff,  0x178ffff,  0x179ffff,  0x17affff,  0x17bffff,  0x17cffff,  0x17dffff,  0x17effff,  0x17fffff,  0x180ffff,  0x181ffff,  0x182ffff,  0x183ffff,  0x184ffff,  0x185ffff,  0x186ffff,  0x187ffff,  0x188ffff,  0x189ffff,  0x18affff,  0x18bffff,  0x18cffff,  0x18dffff,  0x18effff,  0x18fffff,  0x190ffff,  0xffffffff,  0xffff0191,  0xffff0192,  0xffff0193,  0xffff0194,  0xffff0195,  0xffff0196,  0x1980197,  0x199ffff,  0x19affff,  0x19bffff,  0x19cffff,  0x19dffff,  0x19effff,  0x19fffff,  0x1a0ffff,  0x1a1ffff,  0x1a2ffff,  0x1a3ffff,  0x1a4ffff,  0x1a5ffff,  0x1a6ffff,  0x1a7ffff,  0x1a8ffff,  0x1a9ffff,  0x1aaffff,  0x1abffff,  0x1acffff,  0x1adffff,  0x1aeffff,  0x1afffff,  0x1b0ffff,  0x1b1ffff,  0x1b2ffff,  0x1b3ffff,  0x1b4ffff,  0x1b5ffff,  0x1b6ffff,  0x1b7ffff,  0x1b8ffff,  0x1b9ffff,  0x1baffff,  0x1bbffff,  0x1bcffff,  0x1bdffff,  0x1beffff,  0x1bfffff,  0x1c0ffff,  0x1c1ffff,  0x1c2ffff,  0x1c3ffff,  0x1c4ffff,  0x1c5ffff,  0x1c6ffff,  0x1c7ffff,  0x1c8ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1c9ffff,  0x1cb01ca,  0x1cd01cc,  0x1cf01ce,  0x1d101d0,  0x1d301d2,  0x1d501d4,  0x1d701d6,  0x1d901d8,  0x1db01da,  0x1dd01dc,  0x1df01de,  0x1e101e0,  0x1e301e2,  0x1e501e4,  0x1e701e6,  0x1e901e8,  0x1eb01ea,  0x1ed01ec,  0xffff01ee,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1f001ef,  0x1f201f1,  0x1f401f3,  0x1f601f5,  0x1f801f7,  0x1fa01f9,  0x1fc01fb,  0x1fe01fd,  0x20001ff,  0x2020201,  0x2040203,  0x2060205,  0x2080207,  0x20a0209,  0x20c020b,  0x20e020d,  0x210020f,  0x2120211,  0x2140213,  0x2160215,  0x2180217,  0xffff0219,  0x21affff,  0x21c021b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x21e021d,  0x220021f,  0x2220221,  0xffffffff,  0x2240223,  0x2260225,  0x2280227,  0x22a0229,  0xffff022b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x22cffff,  0xffffffff,  0x22dffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff022e,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x22fffff,  0x230ffff,  0x231ffff,  0x232ffff,  0x233ffff,  0x234ffff,  0x235ffff,  0x236ffff,  0x237ffff,  0x238ffff,  0x239ffff,  0x23affff,  0x23bffff,  0x23cffff,  0x23dffff,  0x23effff,  0x23fffff,  0x240ffff,  0x241ffff,  0x242ffff,  0x243ffff,  0x244ffff,  0x245ffff,  0x246ffff,  0x247ffff,  0x248ffff,  0x249ffff,  0x24affff,  0x24bffff,  0x24cffff,  0x24dffff,  0x24effff,  0x24fffff,  0x250ffff,  0x251ffff,  0x252ffff,  0x253ffff,  0x254ffff,  0x255ffff,  0x256ffff,  0x257ffff,  0x258ffff,  0x259ffff,  0x25affff,  0x25bffff,  0x25cffff,  0x25dffff,  0x25effff,  0x25fffff,  0x260ffff,  0x261ffff,  0x262ffff,  0x263ffff,  0x264ffff,  0x265ffff,  0x266ffff,  0x267ffff,  0x268ffff,  0x269ffff,  0x26affff,  0x26bffff,  0x26cffff,  0x26dffff,  0x26effff,  0x26fffff,  0x270ffff,  0x271ffff,  0x272ffff,  0x273ffff,  0x274ffff,  0x275ffff,  0x276ffff,  0x277ffff,  0x278ffff,  0x279ffff,  0xffffffff,  0xffffffff,  0x27affff,  0xffffffff,  0xffffffff,  0x27bffff,  0x27cffff,  0x27dffff,  0x27effff,  0x27fffff,  0x280ffff,  0x281ffff,  0x282ffff,  0x283ffff,  0x284ffff,  0x285ffff,  0x286ffff,  0x287ffff,  0x288ffff,  0x289ffff,  0x28affff,  0x28bffff,  0x28cffff,  0x28dffff,  0x28effff,  0x28fffff,  0x290ffff,  0x291ffff,  0x292ffff,  0x293ffff,  0x294ffff,  0x295ffff,  0x296ffff,  0x297ffff,  0x298ffff,  0x299ffff,  0x29affff,  0x29bffff,  0x29cffff,  0x29dffff,  0x29effff,  0x29fffff,  0x2a0ffff,  0x2a1ffff,  0x2a2ffff,  0x2a3ffff,  0x2a4ffff,  0x2a5ffff,  0x2a6ffff,  0x2a7ffff,  0x2a8ffff,  0x2a9ffff,  0x2aaffff,  0x2ac02ab,  0x2ae02ad,  0x2b002af,  0x2b202b1,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2b402b3,  0x2b602b5,  0x2b802b7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2ba02b9,  0x2bc02bb,  0x2be02bd,  0x2c002bf,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2c202c1,  0x2c402c3,  0x2c602c5,  0x2c802c7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2ca02c9,  0x2cc02cb,  0x2ce02cd,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2cfffff,  0x2d0ffff,  0x2d1ffff,  0x2d2ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2d402d3,  0x2d602d5,  0x2d802d7,  0x2da02d9,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2dc02db,  0x2de02dd,  0x2e002df,  0x2e202e1,  0x2e402e3,  0x2e602e5,  0x2e802e7,  0xffffffff,  0x2ea02e9,  0x2ec02eb,  0x2ee02ed,  0x2f002ef,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2f202f1,  0x2f402f3,  0x2f602f5,  0x2f802f7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2fa02f9,  0x2fc02fb,  0x2fe02fd,  0x30002ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3020301,  0x303ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0304,  0xffffffff,  0x305ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3070306,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3090308,  0xffffffff,  0x30affff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x30bffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff030c,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x30e030d,  0x310030f,  0x3120311,  0x3140313,  0x3160315,  0x3180317,  0x31a0319,  0x31c031b,  0xffffffff,  0xffffffff,  0xffff031d,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x31f031e,  0x3210320,  0x3230322,  0x3250324,  0x3270326,  0x3290328,  0x32b032a,  0x32d032c,  0x32f032e,  0x3310330,  0x3330332,  0x3350334,  0x3370336,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3390338,  0x33b033a,  0x33d033c,  0x33f033e,  0x3410340,  0x3430342,  0x3450344,  0x3470346,  0x3490348,  0x34b034a,  0x34d034c,  0x34f034e,  0x3510350,  0x3530352,  0x3550354,  0x3570356,  0x3590358,  0x35b035a,  0x35d035c,  0x35f035e,  0x3610360,  0x3630362,  0x3650364,  0x3670366,  0x368ffff,  0xffffffff,  0x369ffff,  0xffff036a,  0xffff036b,  0xffff036c,  0xffff036d,  0xffffffff,  0xffffffff,  0x36effff,  0xffffffff,  0xffff036f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x370ffff,  0x371ffff,  0x372ffff,  0x373ffff,  0x374ffff,  0x375ffff,  0x376ffff,  0x377ffff,  0x378ffff,  0x379ffff,  0x37affff,  0x37bffff,  0x37cffff,  0x37dffff,  0x37effff,  0x37fffff,  0x380ffff,  0x381ffff,  0x382ffff,  0x383ffff,  0x384ffff,  0x385ffff,  0x386ffff,  0x387ffff,  0x388ffff,  0x389ffff,  0x38affff,  0x38bffff,  0x38cffff,  0x38dffff,  0x38effff,  0x38fffff,  0x390ffff,  0x391ffff,  0x392ffff,  0x393ffff,  0x394ffff,  0x395ffff,  0x396ffff,  0x397ffff,  0x398ffff,  0x399ffff,  0x39affff,  0x39bffff,  0x39cffff,  0x39dffff,  0x39effff,  0x39fffff,  0x3a0ffff,  0x3a1ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff03a2,  0xffff03a3,  0xffffffff,  0x3a4ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3a603a5,  0x3a803a7,  0x3aa03a9,  0x3ac03ab,  0x3ae03ad,  0x3b003af,  0x3b203b1,  0x3b403b3,  0x3b603b5,  0x3b803b7,  0x3ba03b9,  0x3bc03bb,  0x3be03bd,  0x3c003bf,  0x3c203c1,  0x3c403c3,  0x3c603c5,  0x3c803c7,  0x3ca03c9,  0x3cbffff,  0xffffffff,  0xffffffff,  0x3ccffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3cdffff,  0x3ceffff,  0x3cfffff,  0x3d0ffff,  0x3d1ffff,  0x3d2ffff,  0x3d3ffff,  0x3d4ffff,  0x3d5ffff,  0x3d6ffff,  0x3d7ffff,  0x3d8ffff,  0x3d9ffff,  0x3daffff,  0x3dbffff,  0x3dcffff,  0x3ddffff,  0x3deffff,  0x3dfffff,  0x3e0ffff,  0x3e1ffff,  0x3e2ffff,  0x3e3ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3e4ffff,  0x3e5ffff,  0x3e6ffff,  0x3e7ffff,  0x3e8ffff,  0x3e9ffff,  0x3eaffff,  0x3ebffff,  0x3ecffff,  0x3edffff,  0x3eeffff,  0x3efffff,  0x3f0ffff,  0x3f1ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3f2ffff,  0x3f3ffff,  0x3f4ffff,  0x3f5ffff,  0x3f6ffff,  0x3f7ffff,  0x3f8ffff,  0xffffffff,  0x3f9ffff,  0x3faffff,  0x3fbffff,  0x3fcffff,  0x3fdffff,  0x3feffff,  0x3ffffff,  0x400ffff,  0x401ffff,  0x402ffff,  0x403ffff,  0x404ffff,  0x405ffff,  0x406ffff,  0x407ffff,  0x408ffff,  0x409ffff,  0x40affff,  0x40bffff,  0x40cffff,  0x40dffff,  0x40effff,  0x40fffff,  0x410ffff,  0x411ffff,  0x412ffff,  0x413ffff,  0x414ffff,  0x415ffff,  0x416ffff,  0x417ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0418,  0xffff0419,  0x41affff,  0x41bffff,  0x41cffff,  0x41dffff,  0x41effff,  0xffffffff,  0xffffffff,  0xffff041f,  0xffffffff,  0x420ffff,  0x421ffff,  0xffff0422,  0x423ffff,  0x424ffff,  0x425ffff,  0x426ffff,  0x427ffff,  0x428ffff,  0x429ffff,  0x42affff,  0x42bffff,  0x42cffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x42dffff,  0x42effff,  0x42fffff,  0x430ffff,  0x431ffff,  0x432ffff,  0x433ffff,  0x434ffff,  0xffffffff,  0xffffffff,  0xffff0435,  0xffff0436,  0xffffffff,  0xffffffff,  0x437ffff,  0xffffffff,  0xffffffff,  0x438ffff,  0x439ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff043a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x43bffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x43d043c,  0x43f043e,  0x4410440,  0x4430442,  0x4450444,  0x4470446,  0x4490448,  0x44b044a,  0x44d044c,  0x44f044e,  0x4510450,  0x4530452,  0x4550454,  0x4570456,  0x4590458,  0x45b045a,  0x45d045c,  0x45f045e,  0x4610460,  0x4630462,  0x4650464,  0x4670466,  0x4690468,  0x46b046a,  0x46d046c,  0x46f046e,  0x4710470,  0x4730472,  0x4750474,  0x4770476,  0x4790478,  0x47b047a,  0x47d047c,  0x47f047e,  0x4810480,  0x4830482,  0x4850484,  0x4870486,  0x4890488,  0x48b048a,  0x48cffff,  0x48e048d,  0x490048f,  0x4920491,  0x4940493,  0x4960495,  0x4980497,  0x49a0499,  0x49c049b,  0x49e049d,  0x4a0049f,  0x4a204a1,  0x4a404a3,  0xffff04a5,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4a704a6,  0x4a904a8,  0x4ab04aa,  0x4ad04ac,  0x4af04ae,  0x4b104b0,  0x4b304b2,  0x4b504b4,  0x4b704b6,  0x4b904b8,  0x4bb04ba,  0x4bd04bc,  0x4bf04be,  0x4c104c0,  0x4c304c2,  0x4c504c4,  0x4c704c6,  0x4c904c8,  0x4cb04ca,  0x4cd04cc,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4cf04ce,  0x4d104d0,  0x4d304d2,  0x4d504d4,  0x4d704d6,  0x4d904d8,  0x4db04da,  0x4dd04dc,  0x4df04de,  0x4e104e0,  0x4e304e2,  0x4e504e4,  0x4e704e6,  0x4e904e8,  0x4eb04ea,  0x4ed04ec,  0x4ef04ee,  0x4f104f0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4f2ffff,  0x4f404f3,  0x4f604f5,  0x4f804f7,  0x4fa04f9,  0x4fc04fb,  0x4fdffff,  0x4ff04fe,  0x5010500,  0x5030502,  0x5050504,  0x5070506,  0x5090508,  0x50b050a,  0x50cffff,  0x50e050d,  0x510050f,  0x5120511,  0x513ffff,  0xffff0514,  0xffffffff,  0x5160515,  0x5180517,  0x51a0519,  0x51c051b,  0x51e051d,  0x520051f,  0x5220521,  0x5240523,  0x5260525,  0x5280527,  0x52a0529,  0x52c052b,  0x52e052d,  0x530052f,  0x5320531,  0x5340533,  0x5360535,  0x5380537,  0x53a0539,  0x53c053b,  0x53e053d,  0x540053f,  0x5420541,  0x5440543,  0x5460545,  0xffff0547,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5490548,  0x54b054a,  0x54d054c,  0x54f054e,  0x5510550,  0x5530552,  0x5550554,  0x5570556,  0x5590558,  0x55b055a,  0x55d055c,  0x55f055e,  0x5610560,  0x5630562,  0x5650564,  0x5670566,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5690568,  0x56b056a,  0x56d056c,  0x56f056e,  0x5710570,  0x5730572,  0x5750574,  0x5770576,  0x5790578,  0x57b057a,  0x57d057c,  0x57f057e,  0x5810580,  0x5830582,  0x5850584,  0x5870586,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5890588,  0x58b058a,  0x58d058c,  0x58f058e,  0x5910590,  0x5930592,  0x5950594,  0x5970596,  0x5990598,  0x59b059a,  0x59d059c,  0x59f059e,  0x5a105a0,  0x5a305a2,  0x5a505a4,  0x5a705a6,  0x5a905a8,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff]);
//9856 bytes
enum toLowerSimpleIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x40,  0x280], [ 0x100,  0x480,  0xe40], [ 0x2020100,  0x4020302,  0x6020205,  0x7020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x10000,  0x20000,  0x40003,  0x60005,  0x80007,  0x0,  0x90000,  0xb000a,  0xd000c,  0xf000e,  0x110010,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x130012,  0x0,  0x0,  0x0,  0x0,  0x0,  0x150014,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x16,  0x0,  0x0,  0x180017,  0x1a0019,  0x1c001b,  0x1e001d,  0x0,  0x0,  0x20001f,  0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x230022,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x250024,  0x270026,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x280000,  0x29,  0x2b002a,  0x2d002c,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2f,  0x310030,  0x320000,  0x33,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x34,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x35,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x360000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x37,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x20001,  0x40003,  0x60005,  0x80007,  0xa0009,  0xc000b,  0xe000d,  0x10000f,  0x120011,  0x140013,  0x160015,  0x180017,  0xffff0019,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1b001a,  0x1d001c,  0x1f001e,  0x210020,  0x230022,  0x250024,  0x270026,  0x290028,  0x2b002a,  0x2d002c,  0x2f002e,  0xffff0030,  0x320031,  0x340033,  0x360035,  0xffff0037,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0038,  0xffff0039,  0xffff003a,  0xffff003b,  0xffff003c,  0xffff003d,  0xffff003e,  0xffff003f,  0xffff0040,  0xffff0041,  0xffff0042,  0xffff0043,  0xffff0044,  0xffff0045,  0xffff0046,  0xffff0047,  0xffff0048,  0xffff0049,  0xffff004a,  0xffff004b,  0xffff004c,  0xffff004d,  0xffff004e,  0xffff004f,  0xffff0050,  0xffff0051,  0xffff0052,  0xffff0053,  0x54ffff,  0x55ffff,  0x56ffff,  0x57ffff,  0x58ffff,  0x59ffff,  0x5affff,  0x5bffff,  0xffffffff,  0xffff005c,  0xffff005d,  0xffff005e,  0xffff005f,  0xffff0060,  0xffff0061,  0xffff0062,  0xffff0063,  0xffff0064,  0xffff0065,  0xffff0066,  0xffff0067,  0xffff0068,  0xffff0069,  0xffff006a,  0xffff006b,  0xffff006c,  0xffff006d,  0xffff006e,  0xffff006f,  0xffff0070,  0xffff0071,  0xffff0072,  0x740073,  0x75ffff,  0x76ffff,  0xffffffff,  0x77ffff,  0xffff0078,  0xffff0079,  0x7b007a,  0x7cffff,  0x7e007d,  0xffffffff,  0x80007f,  0x820081,  0x83ffff,  0xffff0084,  0x860085,  0xffff0087,  0xffffffff,  0x890088,  0x8affff,  0xffff008b,  0xffff008c,  0xffff008d,  0x8f008e,  0x90ffff,  0xffffffff,  0xffff0091,  0x930092,  0x94ffff,  0x960095,  0x97ffff,  0x98ffff,  0xffff0099,  0xffffffff,  0xffff009a,  0xffffffff,  0xffffffff,  0xffffffff,  0x9c009b,  0x9dffff,  0xffff009e,  0xa0009f,  0xa1ffff,  0xa2ffff,  0xa3ffff,  0xa4ffff,  0xa5ffff,  0xa6ffff,  0xa7ffff,  0xa8ffff,  0xffffffff,  0xffff00a9,  0xffff00aa,  0xffff00ab,  0xffff00ac,  0xffff00ad,  0xffff00ae,  0xffff00af,  0xffff00b0,  0xffff00b1,  0xb2ffff,  0xffff00b3,  0xffff00b4,  0xb600b5,  0xffff00b7,  0xffff00b8,  0xffff00b9,  0xffff00ba,  0xffff00bb,  0xffff00bc,  0xffff00bd,  0xffff00be,  0xffff00bf,  0xffff00c0,  0xffff00c1,  0xffff00c2,  0xffff00c3,  0xffff00c4,  0xffff00c5,  0xffff00c6,  0xffff00c7,  0xffff00c8,  0xffff00c9,  0xffff00ca,  0xffff00cb,  0xffff00cc,  0xffff00cd,  0xffff00ce,  0xffff00cf,  0xffff00d0,  0xffff00d1,  0xffff00d2,  0xffff00d3,  0xffff00d4,  0xffffffff,  0xffffffff,  0xffffffff,  0xd600d5,  0xd7ffff,  0xffff00d8,  0xd9ffff,  0xdaffff,  0xdc00db,  0xffff00dd,  0xffff00de,  0xffff00df,  0xffff00e0,  0xffff00e1,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff00e2,  0xffff00e3,  0xffffffff,  0xffff00e4,  0xffffffff,  0xffffffff,  0xffffffff,  0xe5ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff00e6,  0xe800e7,  0xffff00e9,  0xffff00ea,  0xec00eb,  0xedffff,  0xef00ee,  0xf100f0,  0xf300f2,  0xf500f4,  0xf700f6,  0xf900f8,  0xfb00fa,  0xfd00fc,  0xfeffff,  0x10000ff,  0x1020101,  0x1040103,  0x1060105,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x107ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0108,  0xffff0109,  0xffff010a,  0xffff010b,  0xffff010c,  0xffff010d,  0xffff010e,  0xffff010f,  0xffff0110,  0xffff0111,  0xffff0112,  0xffff0113,  0xffffffff,  0xffffffff,  0xffff0114,  0x115ffff,  0x116ffff,  0xffff0117,  0x118ffff,  0x11a0119,  0x11c011b,  0x11e011d,  0x120011f,  0x1220121,  0x1240123,  0x1260125,  0x1280127,  0x12a0129,  0x12c012b,  0x12e012d,  0x130012f,  0x1320131,  0x1340133,  0x1360135,  0x1380137,  0x13a0139,  0x13c013b,  0x13e013d,  0x140013f,  0x1420141,  0x1440143,  0x1460145,  0x1480147,  0x14a0149,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff014b,  0xffff014c,  0xffff014d,  0xffff014e,  0xffff014f,  0xffff0150,  0xffff0151,  0xffff0152,  0xffff0153,  0xffff0154,  0xffff0155,  0xffff0156,  0xffff0157,  0xffff0158,  0xffff0159,  0xffff015a,  0xffff015b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff015c,  0xffff015d,  0xffff015e,  0xffff015f,  0xffff0160,  0xffff0161,  0xffff0162,  0xffff0163,  0xffff0164,  0xffff0165,  0xffff0166,  0xffff0167,  0xffff0168,  0xffff0169,  0xffff016a,  0xffff016b,  0xffff016c,  0xffff016d,  0xffff016e,  0xffff016f,  0xffff0170,  0xffff0171,  0xffff0172,  0xffff0173,  0xffff0174,  0xffff0175,  0xffff0176,  0x1780177,  0x179ffff,  0x17affff,  0x17bffff,  0x17cffff,  0x17dffff,  0x17effff,  0xffffffff,  0xffff017f,  0xffff0180,  0xffff0181,  0xffff0182,  0xffff0183,  0xffff0184,  0xffff0185,  0xffff0186,  0xffff0187,  0xffff0188,  0xffff0189,  0xffff018a,  0xffff018b,  0xffff018c,  0xffff018d,  0xffff018e,  0xffff018f,  0xffff0190,  0xffff0191,  0xffff0192,  0xffff0193,  0xffff0194,  0xffff0195,  0xffff0196,  0xffff0197,  0xffff0198,  0xffff0199,  0xffff019a,  0xffff019b,  0xffff019c,  0xffff019d,  0xffff019e,  0xffff019f,  0xffff01a0,  0xffff01a1,  0xffff01a2,  0xffff01a3,  0xffff01a4,  0xffff01a5,  0xffff01a6,  0xffff01a7,  0xffff01a8,  0xffff01a9,  0xffff01aa,  0xffff01ab,  0xffff01ac,  0xffff01ad,  0xffff01ae,  0x1afffff,  0x1b101b0,  0x1b301b2,  0x1b501b4,  0x1b701b6,  0x1b901b8,  0x1bb01ba,  0x1bd01bc,  0x1bf01be,  0x1c101c0,  0x1c301c2,  0x1c501c4,  0x1c701c6,  0x1c901c8,  0x1cb01ca,  0x1cd01cc,  0x1cf01ce,  0x1d101d0,  0x1d301d2,  0xffff01d4,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1d601d5,  0x1d801d7,  0x1da01d9,  0x1dc01db,  0x1de01dd,  0x1e001df,  0x1e201e1,  0x1e401e3,  0x1e601e5,  0x1e801e7,  0x1ea01e9,  0x1ec01eb,  0x1ee01ed,  0x1f001ef,  0x1f201f1,  0x1f401f3,  0x1f601f5,  0x1f801f7,  0x1fa01f9,  0x1fbffff,  0xffffffff,  0xffffffff,  0x1fcffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1fe01fd,  0x20001ff,  0x2020201,  0x2040203,  0x2060205,  0x2080207,  0x20a0209,  0x20c020b,  0x20e020d,  0x210020f,  0x2120211,  0x2140213,  0x2160215,  0x2180217,  0x21a0219,  0x21c021b,  0x21e021d,  0x220021f,  0x2220221,  0x2240223,  0x2260225,  0x2280227,  0x22a0229,  0x22c022b,  0x22e022d,  0x230022f,  0x2320231,  0x2340233,  0x2360235,  0x2380237,  0x23a0239,  0x23c023b,  0x23e023d,  0x240023f,  0x2420241,  0x2440243,  0x2460245,  0x2480247,  0x24a0249,  0x24c024b,  0x24e024d,  0x250024f,  0x2520251,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2540253,  0x2560255,  0x2580257,  0x25a0259,  0x25c025b,  0x25e025d,  0x260025f,  0x2620261,  0x2640263,  0x2660265,  0x2680267,  0x26a0269,  0x26c026b,  0x26e026d,  0x270026f,  0x2720271,  0x2740273,  0x2760275,  0x2780277,  0x27a0279,  0x27c027b,  0xffff027d,  0x27effff,  0x280027f,  0xffff0281,  0xffff0282,  0xffff0283,  0xffff0284,  0xffff0285,  0xffff0286,  0xffff0287,  0xffff0288,  0xffff0289,  0xffff028a,  0xffff028b,  0xffff028c,  0xffff028d,  0xffff028e,  0xffff028f,  0xffff0290,  0xffff0291,  0xffff0292,  0xffff0293,  0xffff0294,  0xffff0295,  0xffff0296,  0xffff0297,  0xffff0298,  0xffff0299,  0xffff029a,  0xffff029b,  0xffff029c,  0xffff029d,  0xffff029e,  0xffff029f,  0xffff02a0,  0xffff02a1,  0xffff02a2,  0xffff02a3,  0xffff02a4,  0xffff02a5,  0xffff02a6,  0xffff02a7,  0xffff02a8,  0xffff02a9,  0xffff02aa,  0xffff02ab,  0xffff02ac,  0xffff02ad,  0xffff02ae,  0xffff02af,  0xffff02b0,  0xffff02b1,  0xffff02b2,  0xffff02b3,  0xffff02b4,  0xffff02b5,  0xffff02b6,  0xffff02b7,  0xffff02b8,  0xffff02b9,  0xffff02ba,  0xffff02bb,  0xffff02bc,  0xffff02bd,  0xffff02be,  0xffff02bf,  0xffff02c0,  0xffff02c1,  0xffff02c2,  0xffff02c3,  0xffff02c4,  0xffff02c5,  0xffff02c6,  0xffff02c7,  0xffff02c8,  0xffff02c9,  0xffff02ca,  0xffff02cb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff02cc,  0xffff02cd,  0xffff02ce,  0xffff02cf,  0xffff02d0,  0xffff02d1,  0xffff02d2,  0xffff02d3,  0xffff02d4,  0xffff02d5,  0xffff02d6,  0xffff02d7,  0xffff02d8,  0xffff02d9,  0xffff02da,  0xffff02db,  0xffff02dc,  0xffff02dd,  0xffff02de,  0xffff02df,  0xffff02e0,  0xffff02e1,  0xffff02e2,  0xffff02e3,  0xffff02e4,  0xffff02e5,  0xffff02e6,  0xffff02e7,  0xffff02e8,  0xffff02e9,  0xffff02ea,  0xffff02eb,  0xffff02ec,  0xffff02ed,  0xffff02ee,  0xffff02ef,  0xffff02f0,  0xffff02f1,  0xffff02f2,  0xffff02f3,  0xffff02f4,  0xffff02f5,  0xffff02f6,  0xffff02f7,  0xffff02f8,  0xffff02f9,  0xffff02fa,  0xffff02fb,  0xffff02fc,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2fe02fd,  0x30002ff,  0x3020301,  0x3040303,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3060305,  0x3080307,  0x30a0309,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x30c030b,  0x30e030d,  0x310030f,  0x3120311,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3140313,  0x3160315,  0x3180317,  0x31a0319,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x31c031b,  0x31e031d,  0x320031f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x321ffff,  0x322ffff,  0x323ffff,  0x324ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3260325,  0x3280327,  0x32a0329,  0x32c032b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x32e032d,  0x330032f,  0x3320331,  0x3340333,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3360335,  0x3380337,  0x33a0339,  0x33c033b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x33e033d,  0x340033f,  0x3420341,  0x3440343,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3460345,  0x3480347,  0xffff0349,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x34b034a,  0x34d034c,  0xffff034e,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x350034f,  0x3520351,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3540353,  0x3560355,  0xffff0357,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3590358,  0x35b035a,  0xffff035c,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff035d,  0xffffffff,  0x35f035e,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0360,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3620361,  0x3640363,  0x3660365,  0x3680367,  0x36a0369,  0x36c036b,  0x36e036d,  0x370036f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x371ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3730372,  0x3750374,  0x3770376,  0x3790378,  0x37b037a,  0x37d037c,  0x37f037e,  0x3810380,  0x3830382,  0x3850384,  0x3870386,  0x3890388,  0x38b038a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x38d038c,  0x38f038e,  0x3910390,  0x3930392,  0x3950394,  0x3970396,  0x3990398,  0x39b039a,  0x39d039c,  0x39f039e,  0x3a103a0,  0x3a303a2,  0x3a503a4,  0x3a703a6,  0x3a903a8,  0x3ab03aa,  0x3ad03ac,  0x3af03ae,  0x3b103b0,  0x3b303b2,  0x3b503b4,  0x3b703b6,  0x3b903b8,  0x3bb03ba,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff03bc,  0x3be03bd,  0xffff03bf,  0x3c0ffff,  0x3c1ffff,  0x3c2ffff,  0x3c3ffff,  0x3c503c4,  0xffff03c6,  0xffff03c7,  0x3c8ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3ca03c9,  0xffff03cb,  0xffff03cc,  0xffff03cd,  0xffff03ce,  0xffff03cf,  0xffff03d0,  0xffff03d1,  0xffff03d2,  0xffff03d3,  0xffff03d4,  0xffff03d5,  0xffff03d6,  0xffff03d7,  0xffff03d8,  0xffff03d9,  0xffff03da,  0xffff03db,  0xffff03dc,  0xffff03dd,  0xffff03de,  0xffff03df,  0xffff03e0,  0xffff03e1,  0xffff03e2,  0xffff03e3,  0xffff03e4,  0xffff03e5,  0xffff03e6,  0xffff03e7,  0xffff03e8,  0xffff03e9,  0xffff03ea,  0xffff03eb,  0xffff03ec,  0xffff03ed,  0xffff03ee,  0xffff03ef,  0xffff03f0,  0xffff03f1,  0xffff03f2,  0xffff03f3,  0xffff03f4,  0xffff03f5,  0xffff03f6,  0xffff03f7,  0xffff03f8,  0xffff03f9,  0xffff03fa,  0xffff03fb,  0xffff03fc,  0xffffffff,  0xffffffff,  0xffffffff,  0x3fdffff,  0x3feffff,  0xffffffff,  0xffffffff,  0xffff03ff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0400,  0xffff0401,  0xffff0402,  0xffff0403,  0xffff0404,  0xffff0405,  0xffff0406,  0xffff0407,  0xffff0408,  0xffff0409,  0xffff040a,  0xffff040b,  0xffff040c,  0xffff040d,  0xffff040e,  0xffff040f,  0xffff0410,  0xffff0411,  0xffff0412,  0xffff0413,  0xffff0414,  0xffff0415,  0xffff0416,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0417,  0xffff0418,  0xffff0419,  0xffff041a,  0xffff041b,  0xffff041c,  0xffff041d,  0xffff041e,  0xffff041f,  0xffff0420,  0xffff0421,  0xffff0422,  0xffff0423,  0xffff0424,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0425,  0xffff0426,  0xffff0427,  0xffff0428,  0xffff0429,  0xffff042a,  0xffff042b,  0xffffffff,  0xffff042c,  0xffff042d,  0xffff042e,  0xffff042f,  0xffff0430,  0xffff0431,  0xffff0432,  0xffff0433,  0xffff0434,  0xffff0435,  0xffff0436,  0xffff0437,  0xffff0438,  0xffff0439,  0xffff043a,  0xffff043b,  0xffff043c,  0xffff043d,  0xffff043e,  0xffff043f,  0xffff0440,  0xffff0441,  0xffff0442,  0xffff0443,  0xffff0444,  0xffff0445,  0xffff0446,  0xffff0447,  0xffff0448,  0xffff0449,  0xffff044a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x44bffff,  0x44cffff,  0x44dffff,  0xffff044e,  0xffff044f,  0xffff0450,  0xffff0451,  0xffff0452,  0xffffffff,  0x453ffff,  0x454ffff,  0xffffffff,  0xffff0455,  0xffff0456,  0xffffffff,  0xffff0457,  0xffff0458,  0xffff0459,  0xffff045a,  0xffff045b,  0xffff045c,  0xffff045d,  0xffff045e,  0xffff045f,  0xffff0460,  0x4620461,  0x4640463,  0xffff0465,  0x4670466,  0x4690468,  0xffff046a,  0xffff046b,  0xffff046c,  0xffff046d,  0xffff046e,  0xffff046f,  0xffff0470,  0xffff0471,  0x4730472,  0x4750474,  0x476ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0477,  0xffffffff,  0xffffffff,  0xffff0478,  0xffff0479,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x47affff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x47bffff,  0x47d047c,  0x47f047e,  0x4810480,  0x4830482,  0x4850484,  0x4870486,  0x4890488,  0x48b048a,  0x48d048c,  0x48f048e,  0x4910490,  0x4930492,  0xffff0494,  0xffffffff,  0xffffffff,  0x4960495,  0x4980497,  0x49a0499,  0x49c049b,  0x49e049d,  0x4a0049f,  0x4a204a1,  0x4a404a3,  0x4a604a5,  0x4a804a7,  0x4aa04a9,  0x4ac04ab,  0x4ae04ad,  0x4b004af,  0x4b204b1,  0x4b404b3,  0x4b604b5,  0x4b804b7,  0x4ba04b9,  0x4bc04bb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4be04bd,  0x4c004bf,  0x4c204c1,  0x4c404c3,  0x4c604c5,  0x4c804c7,  0x4ca04c9,  0x4cc04cb,  0x4ce04cd,  0x4d004cf,  0x4d204d1,  0x4d404d3,  0x4d604d5,  0x4d804d7,  0x4da04d9,  0x4dc04db,  0x4de04dd,  0x4e004df,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4e204e1,  0x4e404e3,  0x4e604e5,  0x4e804e7,  0x4ea04e9,  0xffff04eb,  0x4ed04ec,  0x4ef04ee,  0x4f104f0,  0x4f304f2,  0x4f504f4,  0x4f704f6,  0x4f904f8,  0xffff04fa,  0x4fc04fb,  0x4fe04fd,  0x50004ff,  0xffff0501,  0x5030502,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5050504,  0x5070506,  0x5090508,  0x50b050a,  0x50d050c,  0x50f050e,  0x5110510,  0x5130512,  0x5150514,  0x5170516,  0x5190518,  0x51b051a,  0x51d051c,  0x51f051e,  0x5210520,  0x5230522,  0x5250524,  0x5270526,  0x5290528,  0x52b052a,  0x52d052c,  0x52f052e,  0x5310530,  0x5330532,  0x5350534,  0xffff0536,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5380537,  0x53a0539,  0x53c053b,  0x53e053d,  0x540053f,  0x5420541,  0x5440543,  0x5460545,  0x5480547,  0x54a0549,  0x54c054b,  0x54e054d,  0x550054f,  0x5520551,  0x5540553,  0x5560555,  0x5580557,  0x55a0559,  0x55c055b,  0x55e055d,  0x560055f,  0x5620561,  0x5640563,  0x5660565,  0x5680567,  0x56a0569,  0x56c056b,  0x56e056d,  0x570056f,  0x5720571,  0x5740573,  0x5760575,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x5780577,  0x57a0579,  0x57c057b,  0x57e057d,  0x580057f,  0x5820581,  0x5840583,  0x5860585,  0x5880587,  0x58a0589,  0x58c058b,  0x58e058d,  0x590058f,  0x5920591,  0x5940593,  0x5960595,  0x5980597,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff]);
//10368 bytes
enum toTitleSimpleIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x40,  0x280], [ 0x100,  0x480,  0xf40], [ 0x2020100,  0x4020302,  0x6020205,  0x7020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x2020202,  0x10000,  0x30002,  0x50004,  0x70006,  0x90008,  0xa,  0xb0000,  0xd000c,  0xf000e,  0x110010,  0x130012,  0x14,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x150000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x160000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x17,  0x180000,  0x19,  0x1b001a,  0x1d001c,  0x1f001e,  0x210020,  0x0,  0x0,  0x220000,  0x23,  0x0,  0x0,  0x0,  0x0,  0x0,  0x240000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x260025,  0x280027,  0x29,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2a0000,  0x2b,  0x2d002c,  0x2f002e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x300000,  0x31,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x320000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x340033,  0x350000,  0x0,  0x36,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x370000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x380000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x390000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3b003a,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff,  0x20001,  0x40003,  0x60005,  0x80007,  0xa0009,  0xc000b,  0xe000d,  0x10000f,  0x120011,  0x140013,  0x160015,  0x180017,  0xffff0019,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1affff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1c001b,  0x1e001d,  0x20001f,  0x220021,  0x240023,  0x260025,  0x280027,  0x2a0029,  0x2c002b,  0x2e002d,  0x30002f,  0xffff0031,  0x330032,  0x350034,  0x370036,  0x390038,  0x3affff,  0x3bffff,  0x3cffff,  0x3dffff,  0x3effff,  0x3fffff,  0x40ffff,  0x41ffff,  0x42ffff,  0x43ffff,  0x44ffff,  0x45ffff,  0x46ffff,  0x47ffff,  0x48ffff,  0x49ffff,  0x4affff,  0x4bffff,  0x4cffff,  0x4dffff,  0x4effff,  0x4fffff,  0x50ffff,  0x51ffff,  0x52ffff,  0x53ffff,  0x54ffff,  0x55ffff,  0xffffffff,  0xffff0056,  0xffff0057,  0xffff0058,  0xffff0059,  0xffff005a,  0xffff005b,  0xffff005c,  0xffff005d,  0x5effff,  0x5fffff,  0x60ffff,  0x61ffff,  0x62ffff,  0x63ffff,  0x64ffff,  0x65ffff,  0x66ffff,  0x67ffff,  0x68ffff,  0x69ffff,  0x6affff,  0x6bffff,  0x6cffff,  0x6dffff,  0x6effff,  0x6fffff,  0x70ffff,  0x71ffff,  0x72ffff,  0x73ffff,  0x74ffff,  0xffffffff,  0xffff0075,  0xffff0076,  0x780077,  0xffff0079,  0x7affff,  0x7bffff,  0xffffffff,  0xffff007c,  0xffffffff,  0xffff007d,  0xffffffff,  0xffffffff,  0xffff007e,  0x7fffff,  0xffffffff,  0x80ffff,  0xffff0081,  0xffffffff,  0xffff0082,  0x83ffff,  0x84ffff,  0x85ffff,  0xffffffff,  0xffff0086,  0xffffffff,  0x87ffff,  0xffffffff,  0xffff0088,  0xffffffff,  0xffff0089,  0xffff008a,  0x8bffff,  0xffffffff,  0x8cffff,  0x8dffff,  0xffffffff,  0xffffffff,  0x8f008e,  0x910090,  0x930092,  0x950094,  0xffff0096,  0xffff0097,  0xffff0098,  0xffff0099,  0xffff009a,  0xffff009b,  0xffff009c,  0xffff009d,  0x9f009e,  0xa0ffff,  0xa1ffff,  0xa2ffff,  0xa3ffff,  0xa4ffff,  0xa5ffff,  0xa6ffff,  0xa7ffff,  0xa8ffff,  0xa9ffff,  0xab00aa,  0xacffff,  0xffffffff,  0xadffff,  0xaeffff,  0xafffff,  0xb0ffff,  0xb1ffff,  0xb2ffff,  0xb3ffff,  0xb4ffff,  0xb5ffff,  0xb6ffff,  0xb7ffff,  0xb8ffff,  0xb9ffff,  0xbaffff,  0xbbffff,  0xbcffff,  0xbdffff,  0xbeffff,  0xbfffff,  0xc0ffff,  0xffffffff,  0xc1ffff,  0xc2ffff,  0xc3ffff,  0xc4ffff,  0xc5ffff,  0xc6ffff,  0xc7ffff,  0xc8ffff,  0xc9ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff00ca,  0xcbffff,  0xffff00cc,  0xffff00cd,  0xffffffff,  0xceffff,  0xcfffff,  0xd0ffff,  0xd1ffff,  0xd2ffff,  0xd400d3,  0xd600d5,  0xffff00d7,  0xd900d8,  0xdaffff,  0xdbffff,  0xffff00dc,  0xffffffff,  0xde00dd,  0xdfffff,  0xe0ffff,  0xffff00e1,  0xe300e2,  0xe500e4,  0xffff00e6,  0xe7ffff,  0xe8ffff,  0xffff00e9,  0xeaffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xebffff,  0xffffffff,  0xffff00ec,  0xee00ed,  0xffffffff,  0xefffff,  0xf100f0,  0xf300f2,  0xffff00f4,  0xffffffff,  0xffffffff,  0xffff00f5,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf6ffff,  0xffff00f7,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf8ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xf9ffff,  0xfaffff,  0xffffffff,  0xfbffff,  0xffffffff,  0xfcffff,  0xfe00fd,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x10000ff,  0x1020101,  0x103ffff,  0x1050104,  0x1070106,  0x1090108,  0x10b010a,  0x10d010c,  0x10f010e,  0x1110110,  0x1130112,  0x1150114,  0x1170116,  0x1190118,  0x11b011a,  0x11d011c,  0x11f011e,  0xffff0120,  0x1220121,  0xffffffff,  0x123ffff,  0x1250124,  0x126ffff,  0x127ffff,  0x128ffff,  0x129ffff,  0x12affff,  0x12bffff,  0x12cffff,  0x12dffff,  0x12effff,  0x12fffff,  0x130ffff,  0x131ffff,  0x1330132,  0x1350134,  0x136ffff,  0xffffffff,  0xffff0137,  0x138ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x13a0139,  0x13c013b,  0x13e013d,  0x140013f,  0x1420141,  0x1440143,  0x1460145,  0x1480147,  0x14a0149,  0x14c014b,  0x14e014d,  0x150014f,  0x1520151,  0x1540153,  0x1560155,  0x1580157,  0x15a0159,  0x15c015b,  0x15e015d,  0x160015f,  0x1620161,  0x1640163,  0x1660165,  0x1680167,  0x169ffff,  0x16affff,  0x16bffff,  0x16cffff,  0x16dffff,  0x16effff,  0x16fffff,  0x170ffff,  0x171ffff,  0x172ffff,  0x173ffff,  0x174ffff,  0x175ffff,  0x176ffff,  0x177ffff,  0x178ffff,  0x179ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x17affff,  0x17bffff,  0x17cffff,  0x17dffff,  0x17effff,  0x17fffff,  0x180ffff,  0x181ffff,  0x182ffff,  0x183ffff,  0x184ffff,  0x185ffff,  0x186ffff,  0x187ffff,  0x188ffff,  0x189ffff,  0x18affff,  0x18bffff,  0x18cffff,  0x18dffff,  0x18effff,  0x18fffff,  0x190ffff,  0x191ffff,  0x192ffff,  0x193ffff,  0x194ffff,  0xffffffff,  0xffff0195,  0xffff0196,  0xffff0197,  0xffff0198,  0xffff0199,  0xffff019a,  0x19c019b,  0x19dffff,  0x19effff,  0x19fffff,  0x1a0ffff,  0x1a1ffff,  0x1a2ffff,  0x1a3ffff,  0x1a4ffff,  0x1a5ffff,  0x1a6ffff,  0x1a7ffff,  0x1a8ffff,  0x1a9ffff,  0x1aaffff,  0x1abffff,  0x1acffff,  0x1adffff,  0x1aeffff,  0x1afffff,  0x1b0ffff,  0x1b1ffff,  0x1b2ffff,  0x1b3ffff,  0x1b4ffff,  0x1b5ffff,  0x1b6ffff,  0x1b7ffff,  0x1b8ffff,  0x1b9ffff,  0x1baffff,  0x1bbffff,  0x1bcffff,  0x1bdffff,  0x1beffff,  0x1bfffff,  0x1c0ffff,  0x1c1ffff,  0x1c2ffff,  0x1c3ffff,  0x1c4ffff,  0x1c5ffff,  0x1c6ffff,  0x1c7ffff,  0x1c8ffff,  0x1c9ffff,  0x1caffff,  0x1cbffff,  0x1ccffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1cdffff,  0x1cf01ce,  0x1d101d0,  0x1d301d2,  0x1d501d4,  0x1d701d6,  0x1d901d8,  0x1db01da,  0x1dd01dc,  0x1df01de,  0x1e101e0,  0x1e301e2,  0x1e501e4,  0x1e701e6,  0x1e901e8,  0x1eb01ea,  0x1ed01ec,  0x1ef01ee,  0x1f101f0,  0xffff01f2,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x1f401f3,  0x1f601f5,  0x1f801f7,  0x1fa01f9,  0x1fc01fb,  0x1fe01fd,  0x20001ff,  0x2020201,  0x2040203,  0x2060205,  0x2080207,  0x20a0209,  0x20c020b,  0x20e020d,  0x210020f,  0x2120211,  0x2140213,  0x2160215,  0x2180217,  0x21a0219,  0x21c021b,  0xffff021d,  0x21effff,  0x220021f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2220221,  0x2240223,  0x2260225,  0xffffffff,  0x2280227,  0x22a0229,  0x22c022b,  0x22e022d,  0xffff022f,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x230ffff,  0xffffffff,  0x231ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0232,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x233ffff,  0x234ffff,  0x235ffff,  0x236ffff,  0x237ffff,  0x238ffff,  0x239ffff,  0x23affff,  0x23bffff,  0x23cffff,  0x23dffff,  0x23effff,  0x23fffff,  0x240ffff,  0x241ffff,  0x242ffff,  0x243ffff,  0x244ffff,  0x245ffff,  0x246ffff,  0x247ffff,  0x248ffff,  0x249ffff,  0x24affff,  0x24bffff,  0x24cffff,  0x24dffff,  0x24effff,  0x24fffff,  0x250ffff,  0x251ffff,  0x252ffff,  0x253ffff,  0x254ffff,  0x255ffff,  0x256ffff,  0x257ffff,  0x258ffff,  0x259ffff,  0x25affff,  0x25bffff,  0x25cffff,  0x25dffff,  0x25effff,  0x25fffff,  0x260ffff,  0x261ffff,  0x262ffff,  0x263ffff,  0x264ffff,  0x265ffff,  0x266ffff,  0x267ffff,  0x268ffff,  0x269ffff,  0x26affff,  0x26bffff,  0x26cffff,  0x26dffff,  0x26effff,  0x26fffff,  0x270ffff,  0x271ffff,  0x272ffff,  0x273ffff,  0x274ffff,  0x275ffff,  0x276ffff,  0x277ffff,  0x278ffff,  0x279ffff,  0x27affff,  0x27bffff,  0x27cffff,  0x27dffff,  0xffffffff,  0xffffffff,  0x27effff,  0xffffffff,  0xffffffff,  0x27fffff,  0x280ffff,  0x281ffff,  0x282ffff,  0x283ffff,  0x284ffff,  0x285ffff,  0x286ffff,  0x287ffff,  0x288ffff,  0x289ffff,  0x28affff,  0x28bffff,  0x28cffff,  0x28dffff,  0x28effff,  0x28fffff,  0x290ffff,  0x291ffff,  0x292ffff,  0x293ffff,  0x294ffff,  0x295ffff,  0x296ffff,  0x297ffff,  0x298ffff,  0x299ffff,  0x29affff,  0x29bffff,  0x29cffff,  0x29dffff,  0x29effff,  0x29fffff,  0x2a0ffff,  0x2a1ffff,  0x2a2ffff,  0x2a3ffff,  0x2a4ffff,  0x2a5ffff,  0x2a6ffff,  0x2a7ffff,  0x2a8ffff,  0x2a9ffff,  0x2aaffff,  0x2abffff,  0x2acffff,  0x2adffff,  0x2aeffff,  0x2b002af,  0x2b202b1,  0x2b402b3,  0x2b602b5,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2b802b7,  0x2ba02b9,  0x2bc02bb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2be02bd,  0x2c002bf,  0x2c202c1,  0x2c402c3,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2c602c5,  0x2c802c7,  0x2ca02c9,  0x2cc02cb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2ce02cd,  0x2d002cf,  0x2d202d1,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2d3ffff,  0x2d4ffff,  0x2d5ffff,  0x2d6ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2d802d7,  0x2da02d9,  0x2dc02db,  0x2de02dd,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2e002df,  0x2e202e1,  0x2e402e3,  0x2e602e5,  0x2e802e7,  0x2ea02e9,  0x2ec02eb,  0xffffffff,  0x2ee02ed,  0x2f002ef,  0x2f202f1,  0x2f402f3,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2f602f5,  0x2f802f7,  0x2fa02f9,  0x2fc02fb,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x2fe02fd,  0x30002ff,  0x3020301,  0x3040303,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3060305,  0x307ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0308,  0xffffffff,  0x309ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x30b030a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x30d030c,  0xffffffff,  0x30effff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x30fffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff0310,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3120311,  0x3140313,  0x3160315,  0x3180317,  0x31a0319,  0x31c031b,  0x31e031d,  0x320031f,  0xffffffff,  0xffffffff,  0xffff0321,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3230322,  0x3250324,  0x3270326,  0x3290328,  0x32b032a,  0x32d032c,  0x32f032e,  0x3310330,  0x3330332,  0x3350334,  0x3370336,  0x3390338,  0x33b033a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x33d033c,  0x33f033e,  0x3410340,  0x3430342,  0x3450344,  0x3470346,  0x3490348,  0x34b034a,  0x34d034c,  0x34f034e,  0x3510350,  0x3530352,  0x3550354,  0x3570356,  0x3590358,  0x35b035a,  0x35d035c,  0x35f035e,  0x3610360,  0x3630362,  0x3650364,  0x3670366,  0x3690368,  0x36b036a,  0x36cffff,  0xffffffff,  0x36dffff,  0xffff036e,  0xffff036f,  0xffff0370,  0xffff0371,  0xffffffff,  0xffffffff,  0x372ffff,  0xffffffff,  0xffff0373,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x374ffff,  0x375ffff,  0x376ffff,  0x377ffff,  0x378ffff,  0x379ffff,  0x37affff,  0x37bffff,  0x37cffff,  0x37dffff,  0x37effff,  0x37fffff,  0x380ffff,  0x381ffff,  0x382ffff,  0x383ffff,  0x384ffff,  0x385ffff,  0x386ffff,  0x387ffff,  0x388ffff,  0x389ffff,  0x38affff,  0x38bffff,  0x38cffff,  0x38dffff,  0x38effff,  0x38fffff,  0x390ffff,  0x391ffff,  0x392ffff,  0x393ffff,  0x394ffff,  0x395ffff,  0x396ffff,  0x397ffff,  0x398ffff,  0x399ffff,  0x39affff,  0x39bffff,  0x39cffff,  0x39dffff,  0x39effff,  0x39fffff,  0x3a0ffff,  0x3a1ffff,  0x3a2ffff,  0x3a3ffff,  0x3a4ffff,  0x3a5ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff03a6,  0xffff03a7,  0xffffffff,  0x3a8ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3aa03a9,  0x3ac03ab,  0x3ae03ad,  0x3b003af,  0x3b203b1,  0x3b403b3,  0x3b603b5,  0x3b803b7,  0x3ba03b9,  0x3bc03bb,  0x3be03bd,  0x3c003bf,  0x3c203c1,  0x3c403c3,  0x3c603c5,  0x3c803c7,  0x3ca03c9,  0x3cc03cb,  0x3ce03cd,  0x3cfffff,  0xffffffff,  0xffffffff,  0x3d0ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3d1ffff,  0x3d2ffff,  0x3d3ffff,  0x3d4ffff,  0x3d5ffff,  0x3d6ffff,  0x3d7ffff,  0x3d8ffff,  0x3d9ffff,  0x3daffff,  0x3dbffff,  0x3dcffff,  0x3ddffff,  0x3deffff,  0x3dfffff,  0x3e0ffff,  0x3e1ffff,  0x3e2ffff,  0x3e3ffff,  0x3e4ffff,  0x3e5ffff,  0x3e6ffff,  0x3e7ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3e8ffff,  0x3e9ffff,  0x3eaffff,  0x3ebffff,  0x3ecffff,  0x3edffff,  0x3eeffff,  0x3efffff,  0x3f0ffff,  0x3f1ffff,  0x3f2ffff,  0x3f3ffff,  0x3f4ffff,  0x3f5ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x3f6ffff,  0x3f7ffff,  0x3f8ffff,  0x3f9ffff,  0x3faffff,  0x3fbffff,  0x3fcffff,  0xffffffff,  0x3fdffff,  0x3feffff,  0x3ffffff,  0x400ffff,  0x401ffff,  0x402ffff,  0x403ffff,  0x404ffff,  0x405ffff,  0x406ffff,  0x407ffff,  0x408ffff,  0x409ffff,  0x40affff,  0x40bffff,  0x40cffff,  0x40dffff,  0x40effff,  0x40fffff,  0x410ffff,  0x411ffff,  0x412ffff,  0x413ffff,  0x414ffff,  0x415ffff,  0x416ffff,  0x417ffff,  0x418ffff,  0x419ffff,  0x41affff,  0x41bffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff041c,  0xffff041d,  0x41effff,  0x41fffff,  0x420ffff,  0x421ffff,  0x422ffff,  0xffffffff,  0xffffffff,  0xffff0423,  0xffffffff,  0x424ffff,  0x425ffff,  0xffff0426,  0x427ffff,  0x428ffff,  0x429ffff,  0x42affff,  0x42bffff,  0x42cffff,  0x42dffff,  0x42effff,  0x42fffff,  0x430ffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x431ffff,  0x432ffff,  0x433ffff,  0x434ffff,  0x435ffff,  0x436ffff,  0x437ffff,  0x438ffff,  0xffffffff,  0xffffffff,  0xffff0439,  0xffff043a,  0xffffffff,  0xffffffff,  0x43bffff,  0xffffffff,  0xffffffff,  0x43cffff,  0x43dffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffff043e,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x43fffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4410440,  0x4430442,  0x4450444,  0x4470446,  0x4490448,  0x44b044a,  0x44d044c,  0x44f044e,  0x4510450,  0x4530452,  0x4550454,  0x4570456,  0x4590458,  0x45b045a,  0x45d045c,  0x45f045e,  0x4610460,  0x4630462,  0x4650464,  0x4670466,  0x4690468,  0x46b046a,  0x46d046c,  0x46f046e,  0x4710470,  0x4730472,  0x4750474,  0x4770476,  0x4790478,  0x47b047a,  0x47d047c,  0x47f047e,  0x4810480,  0x4830482,  0x4850484,  0x4870486,  0x4890488,  0x48b048a,  0x48d048c,  0x48f048e,  0x490ffff,  0x4920491,  0x4940493,  0x4960495,  0x4980497,  0x49a0499,  0x49c049b,  0x49e049d,  0x4a0049f,  0x4a204a1,  0x4a404a3,  0x4a604a5,  0x4a804a7,  0xffff04a9,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4ab04aa,  0x4ad04ac,  0x4af04ae,  0x4b104b0,  0x4b304b2,  0x4b504b4,  0x4b704b6,  0x4b904b8,  0x4bb04ba,  0x4bd04bc,  0x4bf04be,  0x4c104c0,  0x4c304c2,  0x4c504c4,  0x4c704c6,  0x4c904c8,  0x4cb04ca,  0x4cd04cc,  0x4cf04ce,  0x4d104d0,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4d304d2,  0x4d504d4,  0x4d704d6,  0x4d904d8,  0x4db04da,  0x4dd04dc,  0x4df04de,  0x4e104e0,  0x4e304e2,  0x4e504e4,  0x4e704e6,  0x4e904e8,  0x4eb04ea,  0x4ed04ec,  0x4ef04ee,  0x4f104f0,  0x4f304f2,  0x4f504f4,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x4f6ffff,  0x4f804f7,  0x4fa04f9,  0x4fc04fb,  0x4fe04fd,  0x50004ff,  0x501ffff,  0x5030502,  0x5050504,  0x5070506,  0x5090508,  0x50b050a,  0x50d050c,  0x50f050e,  0x510ffff,  0x5120511,  0x5140513,  0x5160515,  0x517ffff,  0xffff0518,  0xffffffff,  0x51a0519,  0x51c051b,  0x51e051d,  0x520051f,  0x5220521,  0x5240523,  0x5260525,  0x5280527,  0x52a0529,  0x52c052b,  0x52e052d,  0x530052f,  0x5320531,  0x5340533,  0x5360535,  0x5380537,  0x53a0539,  0x53c053b,  0x53e053d,  0x540053f,  0x5420541,  0x5440543,  0x5460545,  0x5480547,  0x54a0549,  0xffff054b,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x54d054c,  0x54f054e,  0x5510550,  0x5530552,  0x5550554,  0x5570556,  0x5590558,  0x55b055a,  0x55d055c,  0x55f055e,  0x5610560,  0x5630562,  0x5650564,  0x5670566,  0x5690568,  0x56b056a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x56d056c,  0x56f056e,  0x5710570,  0x5730572,  0x5750574,  0x5770576,  0x5790578,  0x57b057a,  0x57d057c,  0x57f057e,  0x5810580,  0x5830582,  0x5850584,  0x5870586,  0x5890588,  0x58b058a,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0x58d058c,  0x58f058e,  0x5910590,  0x5930592,  0x5950594,  0x5970596,  0x5990598,  0x59b059a,  0x59d059c,  0x59f059e,  0x5a105a0,  0x5a305a2,  0x5a505a4,  0x5a705a6,  0x5a905a8,  0x5ab05aa,  0x5ad05ac,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff,  0xffffffff]);
@property
{
private alias _IUA = immutable(uint[]);
_IUA toUpperTable() nothrow @nogc @safe pure { static _IUA t = [ 0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,  0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,  0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,  0x58,  0x59,  0x5a,  0x39c,  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0x178,  0x100,  0x102,  0x104,  0x106,  0x108,  0x10a,  0x10c,  0x10e,  0x110,  0x112,  0x114,  0x116,  0x118,  0x11a,  0x11c,  0x11e,  0x120,  0x122,  0x124,  0x126,  0x128,  0x12a,  0x12c,  0x12e,  0x49,  0x132,  0x134,  0x136,  0x139,  0x13b,  0x13d,  0x13f,  0x141,  0x143,  0x145,  0x147,  0x14a,  0x14c,  0x14e,  0x150,  0x152,  0x154,  0x156,  0x158,  0x15a,  0x15c,  0x15e,  0x160,  0x162,  0x164,  0x166,  0x168,  0x16a,  0x16c,  0x16e,  0x170,  0x172,  0x174,  0x176,  0x179,  0x17b,  0x17d,  0x53,  0x243,  0x182,  0x184,  0x187,  0x18b,  0x191,  0x1f6,  0x198,  0x23d,  0x220,  0x1a0,  0x1a2,  0x1a4,  0x1a7,  0x1ac,  0x1af,  0x1b3,  0x1b5,  0x1b8,  0x1bc,  0x1f7,  0x1c4,  0x1c4,  0x1c7,  0x1c7,  0x1ca,  0x1ca,  0x1cd,  0x1cf,  0x1d1,  0x1d3,  0x1d5,  0x1d7,  0x1d9,  0x1db,  0x18e,  0x1de,  0x1e0,  0x1e2,  0x1e4,  0x1e6,  0x1e8,  0x1ea,  0x1ec,  0x1ee,  0x1f1,  0x1f1,  0x1f4,  0x1f8,  0x1fa,  0x1fc,  0x1fe,  0x200,  0x202,  0x204,  0x206,  0x208,  0x20a,  0x20c,  0x20e,  0x210,  0x212,  0x214,  0x216,  0x218,  0x21a,  0x21c,  0x21e,  0x222,  0x224,  0x226,  0x228,  0x22a,  0x22c,  0x22e,  0x230,  0x232,  0x23b,  0x2c7e,  0x2c7f,  0x241,  0x246,  0x248,  0x24a,  0x24c,  0x24e,  0x2c6f,  0x2c6d,  0x2c70,  0x181,  0x186,  0x189,  0x18a,  0x18f,  0x190,  0xa7ab,  0x193,  0xa7ac,  0x194,  0xa78d,  0xa7aa,  0x197,  0x196,  0xa7ae,  0x2c62,  0xa7ad,  0x19c,  0x2c6e,  0x19d,  0x19f,  0x2c64,  0x1a6,  0xa7c5,  0x1a9,  0xa7b1,  0x1ae,  0x244,  0x1b1,  0x1b2,  0x245,  0x1b7,  0xa7b2,  0xa7b0,  0x399,  0x370,  0x372,  0x376,  0x3fd,  0x3fe,  0x3ff,  0x386,  0x388,  0x389,  0x38a,  0x391,  0x392,  0x393,  0x394,  0x395,  0x396,  0x397,  0x398,  0x399,  0x39a,  0x39b,  0x39c,  0x39d,  0x39e,  0x39f,  0x3a0,  0x3a1,  0x3a3,  0x3a3,  0x3a4,  0x3a5,  0x3a6,  0x3a7,  0x3a8,  0x3a9,  0x3aa,  0x3ab,  0x38c,  0x38e,  0x38f,  0x392,  0x398,  0x3a6,  0x3a0,  0x3cf,  0x3d8,  0x3da,  0x3dc,  0x3de,  0x3e0,  0x3e2,  0x3e4,  0x3e6,  0x3e8,  0x3ea,  0x3ec,  0x3ee,  0x39a,  0x3a1,  0x3f9,  0x37f,  0x395,  0x3f7,  0x3fa,  0x410,  0x411,  0x412,  0x413,  0x414,  0x415,  0x416,  0x417,  0x418,  0x419,  0x41a,  0x41b,  0x41c,  0x41d,  0x41e,  0x41f,  0x420,  0x421,  0x422,  0x423,  0x424,  0x425,  0x426,  0x427,  0x428,  0x429,  0x42a,  0x42b,  0x42c,  0x42d,  0x42e,  0x42f,  0x400,  0x401,  0x402,  0x403,  0x404,  0x405,  0x406,  0x407,  0x408,  0x409,  0x40a,  0x40b,  0x40c,  0x40d,  0x40e,  0x40f,  0x460,  0x462,  0x464,  0x466,  0x468,  0x46a,  0x46c,  0x46e,  0x470,  0x472,  0x474,  0x476,  0x478,  0x47a,  0x47c,  0x47e,  0x480,  0x48a,  0x48c,  0x48e,  0x490,  0x492,  0x494,  0x496,  0x498,  0x49a,  0x49c,  0x49e,  0x4a0,  0x4a2,  0x4a4,  0x4a6,  0x4a8,  0x4aa,  0x4ac,  0x4ae,  0x4b0,  0x4b2,  0x4b4,  0x4b6,  0x4b8,  0x4ba,  0x4bc,  0x4be,  0x4c1,  0x4c3,  0x4c5,  0x4c7,  0x4c9,  0x4cb,  0x4cd,  0x4c0,  0x4d0,  0x4d2,  0x4d4,  0x4d6,  0x4d8,  0x4da,  0x4dc,  0x4de,  0x4e0,  0x4e2,  0x4e4,  0x4e6,  0x4e8,  0x4ea,  0x4ec,  0x4ee,  0x4f0,  0x4f2,  0x4f4,  0x4f6,  0x4f8,  0x4fa,  0x4fc,  0x4fe,  0x500,  0x502,  0x504,  0x506,  0x508,  0x50a,  0x50c,  0x50e,  0x510,  0x512,  0x514,  0x516,  0x518,  0x51a,  0x51c,  0x51e,  0x520,  0x522,  0x524,  0x526,  0x528,  0x52a,  0x52c,  0x52e,  0x531,  0x532,  0x533,  0x534,  0x535,  0x536,  0x537,  0x538,  0x539,  0x53a,  0x53b,  0x53c,  0x53d,  0x53e,  0x53f,  0x540,  0x541,  0x542,  0x543,  0x544,  0x545,  0x546,  0x547,  0x548,  0x549,  0x54a,  0x54b,  0x54c,  0x54d,  0x54e,  0x54f,  0x550,  0x551,  0x552,  0x553,  0x554,  0x555,  0x556,  0x1c90,  0x1c91,  0x1c92,  0x1c93,  0x1c94,  0x1c95,  0x1c96,  0x1c97,  0x1c98,  0x1c99,  0x1c9a,  0x1c9b,  0x1c9c,  0x1c9d,  0x1c9e,  0x1c9f,  0x1ca0,  0x1ca1,  0x1ca2,  0x1ca3,  0x1ca4,  0x1ca5,  0x1ca6,  0x1ca7,  0x1ca8,  0x1ca9,  0x1caa,  0x1cab,  0x1cac,  0x1cad,  0x1cae,  0x1caf,  0x1cb0,  0x1cb1,  0x1cb2,  0x1cb3,  0x1cb4,  0x1cb5,  0x1cb6,  0x1cb7,  0x1cb8,  0x1cb9,  0x1cba,  0x1cbd,  0x1cbe,  0x1cbf,  0x13f0,  0x13f1,  0x13f2,  0x13f3,  0x13f4,  0x13f5,  0x412,  0x414,  0x41e,  0x421,  0x422,  0x422,  0x42a,  0x462,  0xa64a,  0xa77d,  0x2c63,  0xa7c6,  0x1e00,  0x1e02,  0x1e04,  0x1e06,  0x1e08,  0x1e0a,  0x1e0c,  0x1e0e,  0x1e10,  0x1e12,  0x1e14,  0x1e16,  0x1e18,  0x1e1a,  0x1e1c,  0x1e1e,  0x1e20,  0x1e22,  0x1e24,  0x1e26,  0x1e28,  0x1e2a,  0x1e2c,  0x1e2e,  0x1e30,  0x1e32,  0x1e34,  0x1e36,  0x1e38,  0x1e3a,  0x1e3c,  0x1e3e,  0x1e40,  0x1e42,  0x1e44,  0x1e46,  0x1e48,  0x1e4a,  0x1e4c,  0x1e4e,  0x1e50,  0x1e52,  0x1e54,  0x1e56,  0x1e58,  0x1e5a,  0x1e5c,  0x1e5e,  0x1e60,  0x1e62,  0x1e64,  0x1e66,  0x1e68,  0x1e6a,  0x1e6c,  0x1e6e,  0x1e70,  0x1e72,  0x1e74,  0x1e76,  0x1e78,  0x1e7a,  0x1e7c,  0x1e7e,  0x1e80,  0x1e82,  0x1e84,  0x1e86,  0x1e88,  0x1e8a,  0x1e8c,  0x1e8e,  0x1e90,  0x1e92,  0x1e94,  0x1e60,  0x1ea0,  0x1ea2,  0x1ea4,  0x1ea6,  0x1ea8,  0x1eaa,  0x1eac,  0x1eae,  0x1eb0,  0x1eb2,  0x1eb4,  0x1eb6,  0x1eb8,  0x1eba,  0x1ebc,  0x1ebe,  0x1ec0,  0x1ec2,  0x1ec4,  0x1ec6,  0x1ec8,  0x1eca,  0x1ecc,  0x1ece,  0x1ed0,  0x1ed2,  0x1ed4,  0x1ed6,  0x1ed8,  0x1eda,  0x1edc,  0x1ede,  0x1ee0,  0x1ee2,  0x1ee4,  0x1ee6,  0x1ee8,  0x1eea,  0x1eec,  0x1eee,  0x1ef0,  0x1ef2,  0x1ef4,  0x1ef6,  0x1ef8,  0x1efa,  0x1efc,  0x1efe,  0x1f08,  0x1f09,  0x1f0a,  0x1f0b,  0x1f0c,  0x1f0d,  0x1f0e,  0x1f0f,  0x1f18,  0x1f19,  0x1f1a,  0x1f1b,  0x1f1c,  0x1f1d,  0x1f28,  0x1f29,  0x1f2a,  0x1f2b,  0x1f2c,  0x1f2d,  0x1f2e,  0x1f2f,  0x1f38,  0x1f39,  0x1f3a,  0x1f3b,  0x1f3c,  0x1f3d,  0x1f3e,  0x1f3f,  0x1f48,  0x1f49,  0x1f4a,  0x1f4b,  0x1f4c,  0x1f4d,  0x1f59,  0x1f5b,  0x1f5d,  0x1f5f,  0x1f68,  0x1f69,  0x1f6a,  0x1f6b,  0x1f6c,  0x1f6d,  0x1f6e,  0x1f6f,  0x1fba,  0x1fbb,  0x1fc8,  0x1fc9,  0x1fca,  0x1fcb,  0x1fda,  0x1fdb,  0x1ff8,  0x1ff9,  0x1fea,  0x1feb,  0x1ffa,  0x1ffb,  0x1f88,  0x1f89,  0x1f8a,  0x1f8b,  0x1f8c,  0x1f8d,  0x1f8e,  0x1f8f,  0x1f98,  0x1f99,  0x1f9a,  0x1f9b,  0x1f9c,  0x1f9d,  0x1f9e,  0x1f9f,  0x1fa8,  0x1fa9,  0x1faa,  0x1fab,  0x1fac,  0x1fad,  0x1fae,  0x1faf,  0x1fb8,  0x1fb9,  0x1fbc,  0x399,  0x1fcc,  0x1fd8,  0x1fd9,  0x1fe8,  0x1fe9,  0x1fec,  0x1ffc,  0x2132,  0x2160,  0x2161,  0x2162,  0x2163,  0x2164,  0x2165,  0x2166,  0x2167,  0x2168,  0x2169,  0x216a,  0x216b,  0x216c,  0x216d,  0x216e,  0x216f,  0x2183,  0x24b6,  0x24b7,  0x24b8,  0x24b9,  0x24ba,  0x24bb,  0x24bc,  0x24bd,  0x24be,  0x24bf,  0x24c0,  0x24c1,  0x24c2,  0x24c3,  0x24c4,  0x24c5,  0x24c6,  0x24c7,  0x24c8,  0x24c9,  0x24ca,  0x24cb,  0x24cc,  0x24cd,  0x24ce,  0x24cf,  0x2c00,  0x2c01,  0x2c02,  0x2c03,  0x2c04,  0x2c05,  0x2c06,  0x2c07,  0x2c08,  0x2c09,  0x2c0a,  0x2c0b,  0x2c0c,  0x2c0d,  0x2c0e,  0x2c0f,  0x2c10,  0x2c11,  0x2c12,  0x2c13,  0x2c14,  0x2c15,  0x2c16,  0x2c17,  0x2c18,  0x2c19,  0x2c1a,  0x2c1b,  0x2c1c,  0x2c1d,  0x2c1e,  0x2c1f,  0x2c20,  0x2c21,  0x2c22,  0x2c23,  0x2c24,  0x2c25,  0x2c26,  0x2c27,  0x2c28,  0x2c29,  0x2c2a,  0x2c2b,  0x2c2c,  0x2c2d,  0x2c2e,  0x2c2f,  0x2c60,  0x23a,  0x23e,  0x2c67,  0x2c69,  0x2c6b,  0x2c72,  0x2c75,  0x2c80,  0x2c82,  0x2c84,  0x2c86,  0x2c88,  0x2c8a,  0x2c8c,  0x2c8e,  0x2c90,  0x2c92,  0x2c94,  0x2c96,  0x2c98,  0x2c9a,  0x2c9c,  0x2c9e,  0x2ca0,  0x2ca2,  0x2ca4,  0x2ca6,  0x2ca8,  0x2caa,  0x2cac,  0x2cae,  0x2cb0,  0x2cb2,  0x2cb4,  0x2cb6,  0x2cb8,  0x2cba,  0x2cbc,  0x2cbe,  0x2cc0,  0x2cc2,  0x2cc4,  0x2cc6,  0x2cc8,  0x2cca,  0x2ccc,  0x2cce,  0x2cd0,  0x2cd2,  0x2cd4,  0x2cd6,  0x2cd8,  0x2cda,  0x2cdc,  0x2cde,  0x2ce0,  0x2ce2,  0x2ceb,  0x2ced,  0x2cf2,  0x10a0,  0x10a1,  0x10a2,  0x10a3,  0x10a4,  0x10a5,  0x10a6,  0x10a7,  0x10a8,  0x10a9,  0x10aa,  0x10ab,  0x10ac,  0x10ad,  0x10ae,  0x10af,  0x10b0,  0x10b1,  0x10b2,  0x10b3,  0x10b4,  0x10b5,  0x10b6,  0x10b7,  0x10b8,  0x10b9,  0x10ba,  0x10bb,  0x10bc,  0x10bd,  0x10be,  0x10bf,  0x10c0,  0x10c1,  0x10c2,  0x10c3,  0x10c4,  0x10c5,  0x10c7,  0x10cd,  0xa640,  0xa642,  0xa644,  0xa646,  0xa648,  0xa64a,  0xa64c,  0xa64e,  0xa650,  0xa652,  0xa654,  0xa656,  0xa658,  0xa65a,  0xa65c,  0xa65e,  0xa660,  0xa662,  0xa664,  0xa666,  0xa668,  0xa66a,  0xa66c,  0xa680,  0xa682,  0xa684,  0xa686,  0xa688,  0xa68a,  0xa68c,  0xa68e,  0xa690,  0xa692,  0xa694,  0xa696,  0xa698,  0xa69a,  0xa722,  0xa724,  0xa726,  0xa728,  0xa72a,  0xa72c,  0xa72e,  0xa732,  0xa734,  0xa736,  0xa738,  0xa73a,  0xa73c,  0xa73e,  0xa740,  0xa742,  0xa744,  0xa746,  0xa748,  0xa74a,  0xa74c,  0xa74e,  0xa750,  0xa752,  0xa754,  0xa756,  0xa758,  0xa75a,  0xa75c,  0xa75e,  0xa760,  0xa762,  0xa764,  0xa766,  0xa768,  0xa76a,  0xa76c,  0xa76e,  0xa779,  0xa77b,  0xa77e,  0xa780,  0xa782,  0xa784,  0xa786,  0xa78b,  0xa790,  0xa792,  0xa7c4,  0xa796,  0xa798,  0xa79a,  0xa79c,  0xa79e,  0xa7a0,  0xa7a2,  0xa7a4,  0xa7a6,  0xa7a8,  0xa7b4,  0xa7b6,  0xa7b8,  0xa7ba,  0xa7bc,  0xa7be,  0xa7c0,  0xa7c2,  0xa7c7,  0xa7c9,  0xa7d0,  0xa7d6,  0xa7d8,  0xa7f5,  0xa7b3,  0x13a0,  0x13a1,  0x13a2,  0x13a3,  0x13a4,  0x13a5,  0x13a6,  0x13a7,  0x13a8,  0x13a9,  0x13aa,  0x13ab,  0x13ac,  0x13ad,  0x13ae,  0x13af,  0x13b0,  0x13b1,  0x13b2,  0x13b3,  0x13b4,  0x13b5,  0x13b6,  0x13b7,  0x13b8,  0x13b9,  0x13ba,  0x13bb,  0x13bc,  0x13bd,  0x13be,  0x13bf,  0x13c0,  0x13c1,  0x13c2,  0x13c3,  0x13c4,  0x13c5,  0x13c6,  0x13c7,  0x13c8,  0x13c9,  0x13ca,  0x13cb,  0x13cc,  0x13cd,  0x13ce,  0x13cf,  0x13d0,  0x13d1,  0x13d2,  0x13d3,  0x13d4,  0x13d5,  0x13d6,  0x13d7,  0x13d8,  0x13d9,  0x13da,  0x13db,  0x13dc,  0x13dd,  0x13de,  0x13df,  0x13e0,  0x13e1,  0x13e2,  0x13e3,  0x13e4,  0x13e5,  0x13e6,  0x13e7,  0x13e8,  0x13e9,  0x13ea,  0x13eb,  0x13ec,  0x13ed,  0x13ee,  0x13ef,  0xff21,  0xff22,  0xff23,  0xff24,  0xff25,  0xff26,  0xff27,  0xff28,  0xff29,  0xff2a,  0xff2b,  0xff2c,  0xff2d,  0xff2e,  0xff2f,  0xff30,  0xff31,  0xff32,  0xff33,  0xff34,  0xff35,  0xff36,  0xff37,  0xff38,  0xff39,  0xff3a,  0x10400,  0x10401,  0x10402,  0x10403,  0x10404,  0x10405,  0x10406,  0x10407,  0x10408,  0x10409,  0x1040a,  0x1040b,  0x1040c,  0x1040d,  0x1040e,  0x1040f,  0x10410,  0x10411,  0x10412,  0x10413,  0x10414,  0x10415,  0x10416,  0x10417,  0x10418,  0x10419,  0x1041a,  0x1041b,  0x1041c,  0x1041d,  0x1041e,  0x1041f,  0x10420,  0x10421,  0x10422,  0x10423,  0x10424,  0x10425,  0x10426,  0x10427,  0x104b0,  0x104b1,  0x104b2,  0x104b3,  0x104b4,  0x104b5,  0x104b6,  0x104b7,  0x104b8,  0x104b9,  0x104ba,  0x104bb,  0x104bc,  0x104bd,  0x104be,  0x104bf,  0x104c0,  0x104c1,  0x104c2,  0x104c3,  0x104c4,  0x104c5,  0x104c6,  0x104c7,  0x104c8,  0x104c9,  0x104ca,  0x104cb,  0x104cc,  0x104cd,  0x104ce,  0x104cf,  0x104d0,  0x104d1,  0x104d2,  0x104d3,  0x10570,  0x10571,  0x10572,  0x10573,  0x10574,  0x10575,  0x10576,  0x10577,  0x10578,  0x10579,  0x1057a,  0x1057c,  0x1057d,  0x1057e,  0x1057f,  0x10580,  0x10581,  0x10582,  0x10583,  0x10584,  0x10585,  0x10586,  0x10587,  0x10588,  0x10589,  0x1058a,  0x1058c,  0x1058d,  0x1058e,  0x1058f,  0x10590,  0x10591,  0x10592,  0x10594,  0x10595,  0x10c80,  0x10c81,  0x10c82,  0x10c83,  0x10c84,  0x10c85,  0x10c86,  0x10c87,  0x10c88,  0x10c89,  0x10c8a,  0x10c8b,  0x10c8c,  0x10c8d,  0x10c8e,  0x10c8f,  0x10c90,  0x10c91,  0x10c92,  0x10c93,  0x10c94,  0x10c95,  0x10c96,  0x10c97,  0x10c98,  0x10c99,  0x10c9a,  0x10c9b,  0x10c9c,  0x10c9d,  0x10c9e,  0x10c9f,  0x10ca0,  0x10ca1,  0x10ca2,  0x10ca3,  0x10ca4,  0x10ca5,  0x10ca6,  0x10ca7,  0x10ca8,  0x10ca9,  0x10caa,  0x10cab,  0x10cac,  0x10cad,  0x10cae,  0x10caf,  0x10cb0,  0x10cb1,  0x10cb2,  0x118a0,  0x118a1,  0x118a2,  0x118a3,  0x118a4,  0x118a5,  0x118a6,  0x118a7,  0x118a8,  0x118a9,  0x118aa,  0x118ab,  0x118ac,  0x118ad,  0x118ae,  0x118af,  0x118b0,  0x118b1,  0x118b2,  0x118b3,  0x118b4,  0x118b5,  0x118b6,  0x118b7,  0x118b8,  0x118b9,  0x118ba,  0x118bb,  0x118bc,  0x118bd,  0x118be,  0x118bf,  0x16e40,  0x16e41,  0x16e42,  0x16e43,  0x16e44,  0x16e45,  0x16e46,  0x16e47,  0x16e48,  0x16e49,  0x16e4a,  0x16e4b,  0x16e4c,  0x16e4d,  0x16e4e,  0x16e4f,  0x16e50,  0x16e51,  0x16e52,  0x16e53,  0x16e54,  0x16e55,  0x16e56,  0x16e57,  0x16e58,  0x16e59,  0x16e5a,  0x16e5b,  0x16e5c,  0x16e5d,  0x16e5e,  0x16e5f,  0x1e900,  0x1e901,  0x1e902,  0x1e903,  0x1e904,  0x1e905,  0x1e906,  0x1e907,  0x1e908,  0x1e909,  0x1e90a,  0x1e90b,  0x1e90c,  0x1e90d,  0x1e90e,  0x1e90f,  0x1e910,  0x1e911,  0x1e912,  0x1e913,  0x1e914,  0x1e915,  0x1e916,  0x1e917,  0x1e918,  0x1e919,  0x1e91a,  0x1e91b,  0x1e91c,  0x1e91d,  0x1e91e,  0x1e91f,  0x1e920,  0x1e921,  0x2000053,  0x53,  0x130,  0x2000046,  0x46,  0x2000046,  0x49,  0x2000046,  0x4c,  0x3000046,  0x46,  0x49,  0x3000046,  0x46,  0x4c,  0x2000053,  0x54,  0x2000053,  0x54,  0x2000535,  0x552,  0x2000544,  0x546,  0x2000544,  0x535,  0x2000544,  0x53b,  0x200054e,  0x546,  0x2000544,  0x53d,  0x20002bc,  0x4e,  0x3000399,  0x308,  0x301,  0x30003a5,  0x308,  0x301,  0x200004a,  0x30c,  0x2000048,  0x331,  0x2000054,  0x308,  0x2000057,  0x30a,  0x2000059,  0x30a,  0x2000041,  0x2be,  0x20003a5,  0x313,  0x30003a5,  0x313,  0x300,  0x30003a5,  0x313,  0x301,  0x30003a5,  0x313,  0x342,  0x2000391,  0x342,  0x2000397,  0x342,  0x3000399,  0x308,  0x300,  0x3000399,  0x308,  0x301,  0x2000399,  0x342,  0x3000399,  0x308,  0x342,  0x30003a5,  0x308,  0x300,  0x30003a5,  0x308,  0x301,  0x20003a1,  0x313,  0x20003a5,  0x342,  0x30003a5,  0x308,  0x342,  0x20003a9,  0x342,  0x2001f08,  0x399,  0x2001f09,  0x399,  0x2001f0a,  0x399,  0x2001f0b,  0x399,  0x2001f0c,  0x399,  0x2001f0d,  0x399,  0x2001f0e,  0x399,  0x2001f0f,  0x399,  0x2001f08,  0x399,  0x2001f09,  0x399,  0x2001f0a,  0x399,  0x2001f0b,  0x399,  0x2001f0c,  0x399,  0x2001f0d,  0x399,  0x2001f0e,  0x399,  0x2001f0f,  0x399,  0x2001f28,  0x399,  0x2001f29,  0x399,  0x2001f2a,  0x399,  0x2001f2b,  0x399,  0x2001f2c,  0x399,  0x2001f2d,  0x399,  0x2001f2e,  0x399,  0x2001f2f,  0x399,  0x2001f28,  0x399,  0x2001f29,  0x399,  0x2001f2a,  0x399,  0x2001f2b,  0x399,  0x2001f2c,  0x399,  0x2001f2d,  0x399,  0x2001f2e,  0x399,  0x2001f2f,  0x399,  0x2001f68,  0x399,  0x2001f69,  0x399,  0x2001f6a,  0x399,  0x2001f6b,  0x399,  0x2001f6c,  0x399,  0x2001f6d,  0x399,  0x2001f6e,  0x399,  0x2001f6f,  0x399,  0x2001f68,  0x399,  0x2001f69,  0x399,  0x2001f6a,  0x399,  0x2001f6b,  0x399,  0x2001f6c,  0x399,  0x2001f6d,  0x399,  0x2001f6e,  0x399,  0x2001f6f,  0x399,  0x2000391,  0x399,  0x2000391,  0x399,  0x2000397,  0x399,  0x2000397,  0x399,  0x20003a9,  0x399,  0x20003a9,  0x399,  0x2001fba,  0x399,  0x2000386,  0x399,  0x2001fca,  0x399,  0x2000389,  0x399,  0x2001ffa,  0x399,  0x200038f,  0x399,  0x3000391,  0x342,  0x399,  0x3000397,  0x342,  0x399,  0x30003a9,  0x342,  0x399]; return t; }
_IUA toLowerTable() nothrow @nogc @safe pure { static _IUA t = [ 0x61,  0x62,  0x63,  0x64,  0x65,  0x66,  0x67,  0x68,  0x69,  0x6a,  0x6b,  0x6c,  0x6d,  0x6e,  0x6f,  0x70,  0x71,  0x72,  0x73,  0x74,  0x75,  0x76,  0x77,  0x78,  0x79,  0x7a,  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0x101,  0x103,  0x105,  0x107,  0x109,  0x10b,  0x10d,  0x10f,  0x111,  0x113,  0x115,  0x117,  0x119,  0x11b,  0x11d,  0x11f,  0x121,  0x123,  0x125,  0x127,  0x129,  0x12b,  0x12d,  0x12f,  0x69,  0x133,  0x135,  0x137,  0x13a,  0x13c,  0x13e,  0x140,  0x142,  0x144,  0x146,  0x148,  0x14b,  0x14d,  0x14f,  0x151,  0x153,  0x155,  0x157,  0x159,  0x15b,  0x15d,  0x15f,  0x161,  0x163,  0x165,  0x167,  0x169,  0x16b,  0x16d,  0x16f,  0x171,  0x173,  0x175,  0x177,  0xff,  0x17a,  0x17c,  0x17e,  0x253,  0x183,  0x185,  0x254,  0x188,  0x256,  0x257,  0x18c,  0x1dd,  0x259,  0x25b,  0x192,  0x260,  0x263,  0x269,  0x268,  0x199,  0x26f,  0x272,  0x275,  0x1a1,  0x1a3,  0x1a5,  0x280,  0x1a8,  0x283,  0x1ad,  0x288,  0x1b0,  0x28a,  0x28b,  0x1b4,  0x1b6,  0x292,  0x1b9,  0x1bd,  0x1c6,  0x1c6,  0x1c9,  0x1c9,  0x1cc,  0x1cc,  0x1ce,  0x1d0,  0x1d2,  0x1d4,  0x1d6,  0x1d8,  0x1da,  0x1dc,  0x1df,  0x1e1,  0x1e3,  0x1e5,  0x1e7,  0x1e9,  0x1eb,  0x1ed,  0x1ef,  0x1f3,  0x1f3,  0x1f5,  0x195,  0x1bf,  0x1f9,  0x1fb,  0x1fd,  0x1ff,  0x201,  0x203,  0x205,  0x207,  0x209,  0x20b,  0x20d,  0x20f,  0x211,  0x213,  0x215,  0x217,  0x219,  0x21b,  0x21d,  0x21f,  0x19e,  0x223,  0x225,  0x227,  0x229,  0x22b,  0x22d,  0x22f,  0x231,  0x233,  0x2c65,  0x23c,  0x19a,  0x2c66,  0x242,  0x180,  0x289,  0x28c,  0x247,  0x249,  0x24b,  0x24d,  0x24f,  0x371,  0x373,  0x377,  0x3f3,  0x3ac,  0x3ad,  0x3ae,  0x3af,  0x3cc,  0x3cd,  0x3ce,  0x3b1,  0x3b2,  0x3b3,  0x3b4,  0x3b5,  0x3b6,  0x3b7,  0x3b8,  0x3b9,  0x3ba,  0x3bb,  0x3bc,  0x3bd,  0x3be,  0x3bf,  0x3c0,  0x3c1,  0x3c3,  0x3c4,  0x3c5,  0x3c6,  0x3c7,  0x3c8,  0x3c9,  0x3ca,  0x3cb,  0x3d7,  0x3d9,  0x3db,  0x3dd,  0x3df,  0x3e1,  0x3e3,  0x3e5,  0x3e7,  0x3e9,  0x3eb,  0x3ed,  0x3ef,  0x3b8,  0x3f8,  0x3f2,  0x3fb,  0x37b,  0x37c,  0x37d,  0x450,  0x451,  0x452,  0x453,  0x454,  0x455,  0x456,  0x457,  0x458,  0x459,  0x45a,  0x45b,  0x45c,  0x45d,  0x45e,  0x45f,  0x430,  0x431,  0x432,  0x433,  0x434,  0x435,  0x436,  0x437,  0x438,  0x439,  0x43a,  0x43b,  0x43c,  0x43d,  0x43e,  0x43f,  0x440,  0x441,  0x442,  0x443,  0x444,  0x445,  0x446,  0x447,  0x448,  0x449,  0x44a,  0x44b,  0x44c,  0x44d,  0x44e,  0x44f,  0x461,  0x463,  0x465,  0x467,  0x469,  0x46b,  0x46d,  0x46f,  0x471,  0x473,  0x475,  0x477,  0x479,  0x47b,  0x47d,  0x47f,  0x481,  0x48b,  0x48d,  0x48f,  0x491,  0x493,  0x495,  0x497,  0x499,  0x49b,  0x49d,  0x49f,  0x4a1,  0x4a3,  0x4a5,  0x4a7,  0x4a9,  0x4ab,  0x4ad,  0x4af,  0x4b1,  0x4b3,  0x4b5,  0x4b7,  0x4b9,  0x4bb,  0x4bd,  0x4bf,  0x4cf,  0x4c2,  0x4c4,  0x4c6,  0x4c8,  0x4ca,  0x4cc,  0x4ce,  0x4d1,  0x4d3,  0x4d5,  0x4d7,  0x4d9,  0x4db,  0x4dd,  0x4df,  0x4e1,  0x4e3,  0x4e5,  0x4e7,  0x4e9,  0x4eb,  0x4ed,  0x4ef,  0x4f1,  0x4f3,  0x4f5,  0x4f7,  0x4f9,  0x4fb,  0x4fd,  0x4ff,  0x501,  0x503,  0x505,  0x507,  0x509,  0x50b,  0x50d,  0x50f,  0x511,  0x513,  0x515,  0x517,  0x519,  0x51b,  0x51d,  0x51f,  0x521,  0x523,  0x525,  0x527,  0x529,  0x52b,  0x52d,  0x52f,  0x561,  0x562,  0x563,  0x564,  0x565,  0x566,  0x567,  0x568,  0x569,  0x56a,  0x56b,  0x56c,  0x56d,  0x56e,  0x56f,  0x570,  0x571,  0x572,  0x573,  0x574,  0x575,  0x576,  0x577,  0x578,  0x579,  0x57a,  0x57b,  0x57c,  0x57d,  0x57e,  0x57f,  0x580,  0x581,  0x582,  0x583,  0x584,  0x585,  0x586,  0x2d00,  0x2d01,  0x2d02,  0x2d03,  0x2d04,  0x2d05,  0x2d06,  0x2d07,  0x2d08,  0x2d09,  0x2d0a,  0x2d0b,  0x2d0c,  0x2d0d,  0x2d0e,  0x2d0f,  0x2d10,  0x2d11,  0x2d12,  0x2d13,  0x2d14,  0x2d15,  0x2d16,  0x2d17,  0x2d18,  0x2d19,  0x2d1a,  0x2d1b,  0x2d1c,  0x2d1d,  0x2d1e,  0x2d1f,  0x2d20,  0x2d21,  0x2d22,  0x2d23,  0x2d24,  0x2d25,  0x2d27,  0x2d2d,  0xab70,  0xab71,  0xab72,  0xab73,  0xab74,  0xab75,  0xab76,  0xab77,  0xab78,  0xab79,  0xab7a,  0xab7b,  0xab7c,  0xab7d,  0xab7e,  0xab7f,  0xab80,  0xab81,  0xab82,  0xab83,  0xab84,  0xab85,  0xab86,  0xab87,  0xab88,  0xab89,  0xab8a,  0xab8b,  0xab8c,  0xab8d,  0xab8e,  0xab8f,  0xab90,  0xab91,  0xab92,  0xab93,  0xab94,  0xab95,  0xab96,  0xab97,  0xab98,  0xab99,  0xab9a,  0xab9b,  0xab9c,  0xab9d,  0xab9e,  0xab9f,  0xaba0,  0xaba1,  0xaba2,  0xaba3,  0xaba4,  0xaba5,  0xaba6,  0xaba7,  0xaba8,  0xaba9,  0xabaa,  0xabab,  0xabac,  0xabad,  0xabae,  0xabaf,  0xabb0,  0xabb1,  0xabb2,  0xabb3,  0xabb4,  0xabb5,  0xabb6,  0xabb7,  0xabb8,  0xabb9,  0xabba,  0xabbb,  0xabbc,  0xabbd,  0xabbe,  0xabbf,  0x13f8,  0x13f9,  0x13fa,  0x13fb,  0x13fc,  0x13fd,  0x10d0,  0x10d1,  0x10d2,  0x10d3,  0x10d4,  0x10d5,  0x10d6,  0x10d7,  0x10d8,  0x10d9,  0x10da,  0x10db,  0x10dc,  0x10dd,  0x10de,  0x10df,  0x10e0,  0x10e1,  0x10e2,  0x10e3,  0x10e4,  0x10e5,  0x10e6,  0x10e7,  0x10e8,  0x10e9,  0x10ea,  0x10eb,  0x10ec,  0x10ed,  0x10ee,  0x10ef,  0x10f0,  0x10f1,  0x10f2,  0x10f3,  0x10f4,  0x10f5,  0x10f6,  0x10f7,  0x10f8,  0x10f9,  0x10fa,  0x10fd,  0x10fe,  0x10ff,  0x1e01,  0x1e03,  0x1e05,  0x1e07,  0x1e09,  0x1e0b,  0x1e0d,  0x1e0f,  0x1e11,  0x1e13,  0x1e15,  0x1e17,  0x1e19,  0x1e1b,  0x1e1d,  0x1e1f,  0x1e21,  0x1e23,  0x1e25,  0x1e27,  0x1e29,  0x1e2b,  0x1e2d,  0x1e2f,  0x1e31,  0x1e33,  0x1e35,  0x1e37,  0x1e39,  0x1e3b,  0x1e3d,  0x1e3f,  0x1e41,  0x1e43,  0x1e45,  0x1e47,  0x1e49,  0x1e4b,  0x1e4d,  0x1e4f,  0x1e51,  0x1e53,  0x1e55,  0x1e57,  0x1e59,  0x1e5b,  0x1e5d,  0x1e5f,  0x1e61,  0x1e63,  0x1e65,  0x1e67,  0x1e69,  0x1e6b,  0x1e6d,  0x1e6f,  0x1e71,  0x1e73,  0x1e75,  0x1e77,  0x1e79,  0x1e7b,  0x1e7d,  0x1e7f,  0x1e81,  0x1e83,  0x1e85,  0x1e87,  0x1e89,  0x1e8b,  0x1e8d,  0x1e8f,  0x1e91,  0x1e93,  0x1e95,  0xdf,  0x1ea1,  0x1ea3,  0x1ea5,  0x1ea7,  0x1ea9,  0x1eab,  0x1ead,  0x1eaf,  0x1eb1,  0x1eb3,  0x1eb5,  0x1eb7,  0x1eb9,  0x1ebb,  0x1ebd,  0x1ebf,  0x1ec1,  0x1ec3,  0x1ec5,  0x1ec7,  0x1ec9,  0x1ecb,  0x1ecd,  0x1ecf,  0x1ed1,  0x1ed3,  0x1ed5,  0x1ed7,  0x1ed9,  0x1edb,  0x1edd,  0x1edf,  0x1ee1,  0x1ee3,  0x1ee5,  0x1ee7,  0x1ee9,  0x1eeb,  0x1eed,  0x1eef,  0x1ef1,  0x1ef3,  0x1ef5,  0x1ef7,  0x1ef9,  0x1efb,  0x1efd,  0x1eff,  0x1f00,  0x1f01,  0x1f02,  0x1f03,  0x1f04,  0x1f05,  0x1f06,  0x1f07,  0x1f10,  0x1f11,  0x1f12,  0x1f13,  0x1f14,  0x1f15,  0x1f20,  0x1f21,  0x1f22,  0x1f23,  0x1f24,  0x1f25,  0x1f26,  0x1f27,  0x1f30,  0x1f31,  0x1f32,  0x1f33,  0x1f34,  0x1f35,  0x1f36,  0x1f37,  0x1f40,  0x1f41,  0x1f42,  0x1f43,  0x1f44,  0x1f45,  0x1f51,  0x1f53,  0x1f55,  0x1f57,  0x1f60,  0x1f61,  0x1f62,  0x1f63,  0x1f64,  0x1f65,  0x1f66,  0x1f67,  0x1f80,  0x1f81,  0x1f82,  0x1f83,  0x1f84,  0x1f85,  0x1f86,  0x1f87,  0x1f90,  0x1f91,  0x1f92,  0x1f93,  0x1f94,  0x1f95,  0x1f96,  0x1f97,  0x1fa0,  0x1fa1,  0x1fa2,  0x1fa3,  0x1fa4,  0x1fa5,  0x1fa6,  0x1fa7,  0x1fb0,  0x1fb1,  0x1f70,  0x1f71,  0x1fb3,  0x1f72,  0x1f73,  0x1f74,  0x1f75,  0x1fc3,  0x1fd0,  0x1fd1,  0x1f76,  0x1f77,  0x1fe0,  0x1fe1,  0x1f7a,  0x1f7b,  0x1fe5,  0x1f78,  0x1f79,  0x1f7c,  0x1f7d,  0x1ff3,  0x3c9,  0x6b,  0xe5,  0x214e,  0x2170,  0x2171,  0x2172,  0x2173,  0x2174,  0x2175,  0x2176,  0x2177,  0x2178,  0x2179,  0x217a,  0x217b,  0x217c,  0x217d,  0x217e,  0x217f,  0x2184,  0x24d0,  0x24d1,  0x24d2,  0x24d3,  0x24d4,  0x24d5,  0x24d6,  0x24d7,  0x24d8,  0x24d9,  0x24da,  0x24db,  0x24dc,  0x24dd,  0x24de,  0x24df,  0x24e0,  0x24e1,  0x24e2,  0x24e3,  0x24e4,  0x24e5,  0x24e6,  0x24e7,  0x24e8,  0x24e9,  0x2c30,  0x2c31,  0x2c32,  0x2c33,  0x2c34,  0x2c35,  0x2c36,  0x2c37,  0x2c38,  0x2c39,  0x2c3a,  0x2c3b,  0x2c3c,  0x2c3d,  0x2c3e,  0x2c3f,  0x2c40,  0x2c41,  0x2c42,  0x2c43,  0x2c44,  0x2c45,  0x2c46,  0x2c47,  0x2c48,  0x2c49,  0x2c4a,  0x2c4b,  0x2c4c,  0x2c4d,  0x2c4e,  0x2c4f,  0x2c50,  0x2c51,  0x2c52,  0x2c53,  0x2c54,  0x2c55,  0x2c56,  0x2c57,  0x2c58,  0x2c59,  0x2c5a,  0x2c5b,  0x2c5c,  0x2c5d,  0x2c5e,  0x2c5f,  0x2c61,  0x26b,  0x1d7d,  0x27d,  0x2c68,  0x2c6a,  0x2c6c,  0x251,  0x271,  0x250,  0x252,  0x2c73,  0x2c76,  0x23f,  0x240,  0x2c81,  0x2c83,  0x2c85,  0x2c87,  0x2c89,  0x2c8b,  0x2c8d,  0x2c8f,  0x2c91,  0x2c93,  0x2c95,  0x2c97,  0x2c99,  0x2c9b,  0x2c9d,  0x2c9f,  0x2ca1,  0x2ca3,  0x2ca5,  0x2ca7,  0x2ca9,  0x2cab,  0x2cad,  0x2caf,  0x2cb1,  0x2cb3,  0x2cb5,  0x2cb7,  0x2cb9,  0x2cbb,  0x2cbd,  0x2cbf,  0x2cc1,  0x2cc3,  0x2cc5,  0x2cc7,  0x2cc9,  0x2ccb,  0x2ccd,  0x2ccf,  0x2cd1,  0x2cd3,  0x2cd5,  0x2cd7,  0x2cd9,  0x2cdb,  0x2cdd,  0x2cdf,  0x2ce1,  0x2ce3,  0x2cec,  0x2cee,  0x2cf3,  0xa641,  0xa643,  0xa645,  0xa647,  0xa649,  0xa64b,  0xa64d,  0xa64f,  0xa651,  0xa653,  0xa655,  0xa657,  0xa659,  0xa65b,  0xa65d,  0xa65f,  0xa661,  0xa663,  0xa665,  0xa667,  0xa669,  0xa66b,  0xa66d,  0xa681,  0xa683,  0xa685,  0xa687,  0xa689,  0xa68b,  0xa68d,  0xa68f,  0xa691,  0xa693,  0xa695,  0xa697,  0xa699,  0xa69b,  0xa723,  0xa725,  0xa727,  0xa729,  0xa72b,  0xa72d,  0xa72f,  0xa733,  0xa735,  0xa737,  0xa739,  0xa73b,  0xa73d,  0xa73f,  0xa741,  0xa743,  0xa745,  0xa747,  0xa749,  0xa74b,  0xa74d,  0xa74f,  0xa751,  0xa753,  0xa755,  0xa757,  0xa759,  0xa75b,  0xa75d,  0xa75f,  0xa761,  0xa763,  0xa765,  0xa767,  0xa769,  0xa76b,  0xa76d,  0xa76f,  0xa77a,  0xa77c,  0x1d79,  0xa77f,  0xa781,  0xa783,  0xa785,  0xa787,  0xa78c,  0x265,  0xa791,  0xa793,  0xa797,  0xa799,  0xa79b,  0xa79d,  0xa79f,  0xa7a1,  0xa7a3,  0xa7a5,  0xa7a7,  0xa7a9,  0x266,  0x25c,  0x261,  0x26c,  0x26a,  0x29e,  0x287,  0x29d,  0xab53,  0xa7b5,  0xa7b7,  0xa7b9,  0xa7bb,  0xa7bd,  0xa7bf,  0xa7c1,  0xa7c3,  0xa794,  0x282,  0x1d8e,  0xa7c8,  0xa7ca,  0xa7d1,  0xa7d7,  0xa7d9,  0xa7f6,  0xff41,  0xff42,  0xff43,  0xff44,  0xff45,  0xff46,  0xff47,  0xff48,  0xff49,  0xff4a,  0xff4b,  0xff4c,  0xff4d,  0xff4e,  0xff4f,  0xff50,  0xff51,  0xff52,  0xff53,  0xff54,  0xff55,  0xff56,  0xff57,  0xff58,  0xff59,  0xff5a,  0x10428,  0x10429,  0x1042a,  0x1042b,  0x1042c,  0x1042d,  0x1042e,  0x1042f,  0x10430,  0x10431,  0x10432,  0x10433,  0x10434,  0x10435,  0x10436,  0x10437,  0x10438,  0x10439,  0x1043a,  0x1043b,  0x1043c,  0x1043d,  0x1043e,  0x1043f,  0x10440,  0x10441,  0x10442,  0x10443,  0x10444,  0x10445,  0x10446,  0x10447,  0x10448,  0x10449,  0x1044a,  0x1044b,  0x1044c,  0x1044d,  0x1044e,  0x1044f,  0x104d8,  0x104d9,  0x104da,  0x104db,  0x104dc,  0x104dd,  0x104de,  0x104df,  0x104e0,  0x104e1,  0x104e2,  0x104e3,  0x104e4,  0x104e5,  0x104e6,  0x104e7,  0x104e8,  0x104e9,  0x104ea,  0x104eb,  0x104ec,  0x104ed,  0x104ee,  0x104ef,  0x104f0,  0x104f1,  0x104f2,  0x104f3,  0x104f4,  0x104f5,  0x104f6,  0x104f7,  0x104f8,  0x104f9,  0x104fa,  0x104fb,  0x10597,  0x10598,  0x10599,  0x1059a,  0x1059b,  0x1059c,  0x1059d,  0x1059e,  0x1059f,  0x105a0,  0x105a1,  0x105a3,  0x105a4,  0x105a5,  0x105a6,  0x105a7,  0x105a8,  0x105a9,  0x105aa,  0x105ab,  0x105ac,  0x105ad,  0x105ae,  0x105af,  0x105b0,  0x105b1,  0x105b3,  0x105b4,  0x105b5,  0x105b6,  0x105b7,  0x105b8,  0x105b9,  0x105bb,  0x105bc,  0x10cc0,  0x10cc1,  0x10cc2,  0x10cc3,  0x10cc4,  0x10cc5,  0x10cc6,  0x10cc7,  0x10cc8,  0x10cc9,  0x10cca,  0x10ccb,  0x10ccc,  0x10ccd,  0x10cce,  0x10ccf,  0x10cd0,  0x10cd1,  0x10cd2,  0x10cd3,  0x10cd4,  0x10cd5,  0x10cd6,  0x10cd7,  0x10cd8,  0x10cd9,  0x10cda,  0x10cdb,  0x10cdc,  0x10cdd,  0x10cde,  0x10cdf,  0x10ce0,  0x10ce1,  0x10ce2,  0x10ce3,  0x10ce4,  0x10ce5,  0x10ce6,  0x10ce7,  0x10ce8,  0x10ce9,  0x10cea,  0x10ceb,  0x10cec,  0x10ced,  0x10cee,  0x10cef,  0x10cf0,  0x10cf1,  0x10cf2,  0x118c0,  0x118c1,  0x118c2,  0x118c3,  0x118c4,  0x118c5,  0x118c6,  0x118c7,  0x118c8,  0x118c9,  0x118ca,  0x118cb,  0x118cc,  0x118cd,  0x118ce,  0x118cf,  0x118d0,  0x118d1,  0x118d2,  0x118d3,  0x118d4,  0x118d5,  0x118d6,  0x118d7,  0x118d8,  0x118d9,  0x118da,  0x118db,  0x118dc,  0x118dd,  0x118de,  0x118df,  0x16e60,  0x16e61,  0x16e62,  0x16e63,  0x16e64,  0x16e65,  0x16e66,  0x16e67,  0x16e68,  0x16e69,  0x16e6a,  0x16e6b,  0x16e6c,  0x16e6d,  0x16e6e,  0x16e6f,  0x16e70,  0x16e71,  0x16e72,  0x16e73,  0x16e74,  0x16e75,  0x16e76,  0x16e77,  0x16e78,  0x16e79,  0x16e7a,  0x16e7b,  0x16e7c,  0x16e7d,  0x16e7e,  0x16e7f,  0x1e922,  0x1e923,  0x1e924,  0x1e925,  0x1e926,  0x1e927,  0x1e928,  0x1e929,  0x1e92a,  0x1e92b,  0x1e92c,  0x1e92d,  0x1e92e,  0x1e92f,  0x1e930,  0x1e931,  0x1e932,  0x1e933,  0x1e934,  0x1e935,  0x1e936,  0x1e937,  0x1e938,  0x1e939,  0x1e93a,  0x1e93b,  0x1e93c,  0x1e93d,  0x1e93e,  0x1e93f,  0x1e940,  0x1e941,  0x1e942,  0x1e943,  0xdf,  0x2000069,  0x307,  0xfb00,  0xfb01,  0xfb02,  0xfb03,  0xfb04,  0xfb05,  0xfb06,  0x587,  0xfb13,  0xfb14,  0xfb15,  0xfb16,  0xfb17,  0x149,  0x390,  0x3b0,  0x1f0,  0x1e96,  0x1e97,  0x1e98,  0x1e99,  0x1e9a,  0x1f50,  0x1f52,  0x1f54,  0x1f56,  0x1fb6,  0x1fc6,  0x1fd2,  0x1fd3,  0x1fd6,  0x1fd7,  0x1fe2,  0x1fe3,  0x1fe4,  0x1fe6,  0x1fe7,  0x1ff6,  0x1f80,  0x1f81,  0x1f82,  0x1f83,  0x1f84,  0x1f85,  0x1f86,  0x1f87,  0x1f80,  0x1f81,  0x1f82,  0x1f83,  0x1f84,  0x1f85,  0x1f86,  0x1f87,  0x1f90,  0x1f91,  0x1f92,  0x1f93,  0x1f94,  0x1f95,  0x1f96,  0x1f97,  0x1f90,  0x1f91,  0x1f92,  0x1f93,  0x1f94,  0x1f95,  0x1f96,  0x1f97,  0x1fa0,  0x1fa1,  0x1fa2,  0x1fa3,  0x1fa4,  0x1fa5,  0x1fa6,  0x1fa7,  0x1fa0,  0x1fa1,  0x1fa2,  0x1fa3,  0x1fa4,  0x1fa5,  0x1fa6,  0x1fa7,  0x1fb3,  0x1fb3,  0x1fc3,  0x1fc3,  0x1ff3,  0x1ff3,  0x1fb2,  0x1fb4,  0x1fc2,  0x1fc4,  0x1ff2,  0x1ff4,  0x1fb7,  0x1fc7,  0x1ff7]; return t; }
_IUA toTitleTable() nothrow @nogc @safe pure { static _IUA t = [ 0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,  0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,  0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,  0x58,  0x59,  0x5a,  0x39c,  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0x178,  0x100,  0x102,  0x104,  0x106,  0x108,  0x10a,  0x10c,  0x10e,  0x110,  0x112,  0x114,  0x116,  0x118,  0x11a,  0x11c,  0x11e,  0x120,  0x122,  0x124,  0x126,  0x128,  0x12a,  0x12c,  0x12e,  0x49,  0x132,  0x134,  0x136,  0x139,  0x13b,  0x13d,  0x13f,  0x141,  0x143,  0x145,  0x147,  0x14a,  0x14c,  0x14e,  0x150,  0x152,  0x154,  0x156,  0x158,  0x15a,  0x15c,  0x15e,  0x160,  0x162,  0x164,  0x166,  0x168,  0x16a,  0x16c,  0x16e,  0x170,  0x172,  0x174,  0x176,  0x179,  0x17b,  0x17d,  0x53,  0x243,  0x182,  0x184,  0x187,  0x18b,  0x191,  0x1f6,  0x198,  0x23d,  0x220,  0x1a0,  0x1a2,  0x1a4,  0x1a7,  0x1ac,  0x1af,  0x1b3,  0x1b5,  0x1b8,  0x1bc,  0x1f7,  0x1c5,  0x1c5,  0x1c5,  0x1c8,  0x1c8,  0x1c8,  0x1cb,  0x1cb,  0x1cb,  0x1cd,  0x1cf,  0x1d1,  0x1d3,  0x1d5,  0x1d7,  0x1d9,  0x1db,  0x18e,  0x1de,  0x1e0,  0x1e2,  0x1e4,  0x1e6,  0x1e8,  0x1ea,  0x1ec,  0x1ee,  0x1f2,  0x1f2,  0x1f2,  0x1f4,  0x1f8,  0x1fa,  0x1fc,  0x1fe,  0x200,  0x202,  0x204,  0x206,  0x208,  0x20a,  0x20c,  0x20e,  0x210,  0x212,  0x214,  0x216,  0x218,  0x21a,  0x21c,  0x21e,  0x222,  0x224,  0x226,  0x228,  0x22a,  0x22c,  0x22e,  0x230,  0x232,  0x23b,  0x2c7e,  0x2c7f,  0x241,  0x246,  0x248,  0x24a,  0x24c,  0x24e,  0x2c6f,  0x2c6d,  0x2c70,  0x181,  0x186,  0x189,  0x18a,  0x18f,  0x190,  0xa7ab,  0x193,  0xa7ac,  0x194,  0xa78d,  0xa7aa,  0x197,  0x196,  0xa7ae,  0x2c62,  0xa7ad,  0x19c,  0x2c6e,  0x19d,  0x19f,  0x2c64,  0x1a6,  0xa7c5,  0x1a9,  0xa7b1,  0x1ae,  0x244,  0x1b1,  0x1b2,  0x245,  0x1b7,  0xa7b2,  0xa7b0,  0x399,  0x370,  0x372,  0x376,  0x3fd,  0x3fe,  0x3ff,  0x386,  0x388,  0x389,  0x38a,  0x391,  0x392,  0x393,  0x394,  0x395,  0x396,  0x397,  0x398,  0x399,  0x39a,  0x39b,  0x39c,  0x39d,  0x39e,  0x39f,  0x3a0,  0x3a1,  0x3a3,  0x3a3,  0x3a4,  0x3a5,  0x3a6,  0x3a7,  0x3a8,  0x3a9,  0x3aa,  0x3ab,  0x38c,  0x38e,  0x38f,  0x392,  0x398,  0x3a6,  0x3a0,  0x3cf,  0x3d8,  0x3da,  0x3dc,  0x3de,  0x3e0,  0x3e2,  0x3e4,  0x3e6,  0x3e8,  0x3ea,  0x3ec,  0x3ee,  0x39a,  0x3a1,  0x3f9,  0x37f,  0x395,  0x3f7,  0x3fa,  0x410,  0x411,  0x412,  0x413,  0x414,  0x415,  0x416,  0x417,  0x418,  0x419,  0x41a,  0x41b,  0x41c,  0x41d,  0x41e,  0x41f,  0x420,  0x421,  0x422,  0x423,  0x424,  0x425,  0x426,  0x427,  0x428,  0x429,  0x42a,  0x42b,  0x42c,  0x42d,  0x42e,  0x42f,  0x400,  0x401,  0x402,  0x403,  0x404,  0x405,  0x406,  0x407,  0x408,  0x409,  0x40a,  0x40b,  0x40c,  0x40d,  0x40e,  0x40f,  0x460,  0x462,  0x464,  0x466,  0x468,  0x46a,  0x46c,  0x46e,  0x470,  0x472,  0x474,  0x476,  0x478,  0x47a,  0x47c,  0x47e,  0x480,  0x48a,  0x48c,  0x48e,  0x490,  0x492,  0x494,  0x496,  0x498,  0x49a,  0x49c,  0x49e,  0x4a0,  0x4a2,  0x4a4,  0x4a6,  0x4a8,  0x4aa,  0x4ac,  0x4ae,  0x4b0,  0x4b2,  0x4b4,  0x4b6,  0x4b8,  0x4ba,  0x4bc,  0x4be,  0x4c1,  0x4c3,  0x4c5,  0x4c7,  0x4c9,  0x4cb,  0x4cd,  0x4c0,  0x4d0,  0x4d2,  0x4d4,  0x4d6,  0x4d8,  0x4da,  0x4dc,  0x4de,  0x4e0,  0x4e2,  0x4e4,  0x4e6,  0x4e8,  0x4ea,  0x4ec,  0x4ee,  0x4f0,  0x4f2,  0x4f4,  0x4f6,  0x4f8,  0x4fa,  0x4fc,  0x4fe,  0x500,  0x502,  0x504,  0x506,  0x508,  0x50a,  0x50c,  0x50e,  0x510,  0x512,  0x514,  0x516,  0x518,  0x51a,  0x51c,  0x51e,  0x520,  0x522,  0x524,  0x526,  0x528,  0x52a,  0x52c,  0x52e,  0x531,  0x532,  0x533,  0x534,  0x535,  0x536,  0x537,  0x538,  0x539,  0x53a,  0x53b,  0x53c,  0x53d,  0x53e,  0x53f,  0x540,  0x541,  0x542,  0x543,  0x544,  0x545,  0x546,  0x547,  0x548,  0x549,  0x54a,  0x54b,  0x54c,  0x54d,  0x54e,  0x54f,  0x550,  0x551,  0x552,  0x553,  0x554,  0x555,  0x556,  0x10d0,  0x10d1,  0x10d2,  0x10d3,  0x10d4,  0x10d5,  0x10d6,  0x10d7,  0x10d8,  0x10d9,  0x10da,  0x10db,  0x10dc,  0x10dd,  0x10de,  0x10df,  0x10e0,  0x10e1,  0x10e2,  0x10e3,  0x10e4,  0x10e5,  0x10e6,  0x10e7,  0x10e8,  0x10e9,  0x10ea,  0x10eb,  0x10ec,  0x10ed,  0x10ee,  0x10ef,  0x10f0,  0x10f1,  0x10f2,  0x10f3,  0x10f4,  0x10f5,  0x10f6,  0x10f7,  0x10f8,  0x10f9,  0x10fa,  0x10fd,  0x10fe,  0x10ff,  0x13f0,  0x13f1,  0x13f2,  0x13f3,  0x13f4,  0x13f5,  0x412,  0x414,  0x41e,  0x421,  0x422,  0x422,  0x42a,  0x462,  0xa64a,  0xa77d,  0x2c63,  0xa7c6,  0x1e00,  0x1e02,  0x1e04,  0x1e06,  0x1e08,  0x1e0a,  0x1e0c,  0x1e0e,  0x1e10,  0x1e12,  0x1e14,  0x1e16,  0x1e18,  0x1e1a,  0x1e1c,  0x1e1e,  0x1e20,  0x1e22,  0x1e24,  0x1e26,  0x1e28,  0x1e2a,  0x1e2c,  0x1e2e,  0x1e30,  0x1e32,  0x1e34,  0x1e36,  0x1e38,  0x1e3a,  0x1e3c,  0x1e3e,  0x1e40,  0x1e42,  0x1e44,  0x1e46,  0x1e48,  0x1e4a,  0x1e4c,  0x1e4e,  0x1e50,  0x1e52,  0x1e54,  0x1e56,  0x1e58,  0x1e5a,  0x1e5c,  0x1e5e,  0x1e60,  0x1e62,  0x1e64,  0x1e66,  0x1e68,  0x1e6a,  0x1e6c,  0x1e6e,  0x1e70,  0x1e72,  0x1e74,  0x1e76,  0x1e78,  0x1e7a,  0x1e7c,  0x1e7e,  0x1e80,  0x1e82,  0x1e84,  0x1e86,  0x1e88,  0x1e8a,  0x1e8c,  0x1e8e,  0x1e90,  0x1e92,  0x1e94,  0x1e60,  0x1ea0,  0x1ea2,  0x1ea4,  0x1ea6,  0x1ea8,  0x1eaa,  0x1eac,  0x1eae,  0x1eb0,  0x1eb2,  0x1eb4,  0x1eb6,  0x1eb8,  0x1eba,  0x1ebc,  0x1ebe,  0x1ec0,  0x1ec2,  0x1ec4,  0x1ec6,  0x1ec8,  0x1eca,  0x1ecc,  0x1ece,  0x1ed0,  0x1ed2,  0x1ed4,  0x1ed6,  0x1ed8,  0x1eda,  0x1edc,  0x1ede,  0x1ee0,  0x1ee2,  0x1ee4,  0x1ee6,  0x1ee8,  0x1eea,  0x1eec,  0x1eee,  0x1ef0,  0x1ef2,  0x1ef4,  0x1ef6,  0x1ef8,  0x1efa,  0x1efc,  0x1efe,  0x1f08,  0x1f09,  0x1f0a,  0x1f0b,  0x1f0c,  0x1f0d,  0x1f0e,  0x1f0f,  0x1f18,  0x1f19,  0x1f1a,  0x1f1b,  0x1f1c,  0x1f1d,  0x1f28,  0x1f29,  0x1f2a,  0x1f2b,  0x1f2c,  0x1f2d,  0x1f2e,  0x1f2f,  0x1f38,  0x1f39,  0x1f3a,  0x1f3b,  0x1f3c,  0x1f3d,  0x1f3e,  0x1f3f,  0x1f48,  0x1f49,  0x1f4a,  0x1f4b,  0x1f4c,  0x1f4d,  0x1f59,  0x1f5b,  0x1f5d,  0x1f5f,  0x1f68,  0x1f69,  0x1f6a,  0x1f6b,  0x1f6c,  0x1f6d,  0x1f6e,  0x1f6f,  0x1fba,  0x1fbb,  0x1fc8,  0x1fc9,  0x1fca,  0x1fcb,  0x1fda,  0x1fdb,  0x1ff8,  0x1ff9,  0x1fea,  0x1feb,  0x1ffa,  0x1ffb,  0x1f88,  0x1f89,  0x1f8a,  0x1f8b,  0x1f8c,  0x1f8d,  0x1f8e,  0x1f8f,  0x1f98,  0x1f99,  0x1f9a,  0x1f9b,  0x1f9c,  0x1f9d,  0x1f9e,  0x1f9f,  0x1fa8,  0x1fa9,  0x1faa,  0x1fab,  0x1fac,  0x1fad,  0x1fae,  0x1faf,  0x1fb8,  0x1fb9,  0x1fbc,  0x399,  0x1fcc,  0x1fd8,  0x1fd9,  0x1fe8,  0x1fe9,  0x1fec,  0x1ffc,  0x2132,  0x2160,  0x2161,  0x2162,  0x2163,  0x2164,  0x2165,  0x2166,  0x2167,  0x2168,  0x2169,  0x216a,  0x216b,  0x216c,  0x216d,  0x216e,  0x216f,  0x2183,  0x24b6,  0x24b7,  0x24b8,  0x24b9,  0x24ba,  0x24bb,  0x24bc,  0x24bd,  0x24be,  0x24bf,  0x24c0,  0x24c1,  0x24c2,  0x24c3,  0x24c4,  0x24c5,  0x24c6,  0x24c7,  0x24c8,  0x24c9,  0x24ca,  0x24cb,  0x24cc,  0x24cd,  0x24ce,  0x24cf,  0x2c00,  0x2c01,  0x2c02,  0x2c03,  0x2c04,  0x2c05,  0x2c06,  0x2c07,  0x2c08,  0x2c09,  0x2c0a,  0x2c0b,  0x2c0c,  0x2c0d,  0x2c0e,  0x2c0f,  0x2c10,  0x2c11,  0x2c12,  0x2c13,  0x2c14,  0x2c15,  0x2c16,  0x2c17,  0x2c18,  0x2c19,  0x2c1a,  0x2c1b,  0x2c1c,  0x2c1d,  0x2c1e,  0x2c1f,  0x2c20,  0x2c21,  0x2c22,  0x2c23,  0x2c24,  0x2c25,  0x2c26,  0x2c27,  0x2c28,  0x2c29,  0x2c2a,  0x2c2b,  0x2c2c,  0x2c2d,  0x2c2e,  0x2c2f,  0x2c60,  0x23a,  0x23e,  0x2c67,  0x2c69,  0x2c6b,  0x2c72,  0x2c75,  0x2c80,  0x2c82,  0x2c84,  0x2c86,  0x2c88,  0x2c8a,  0x2c8c,  0x2c8e,  0x2c90,  0x2c92,  0x2c94,  0x2c96,  0x2c98,  0x2c9a,  0x2c9c,  0x2c9e,  0x2ca0,  0x2ca2,  0x2ca4,  0x2ca6,  0x2ca8,  0x2caa,  0x2cac,  0x2cae,  0x2cb0,  0x2cb2,  0x2cb4,  0x2cb6,  0x2cb8,  0x2cba,  0x2cbc,  0x2cbe,  0x2cc0,  0x2cc2,  0x2cc4,  0x2cc6,  0x2cc8,  0x2cca,  0x2ccc,  0x2cce,  0x2cd0,  0x2cd2,  0x2cd4,  0x2cd6,  0x2cd8,  0x2cda,  0x2cdc,  0x2cde,  0x2ce0,  0x2ce2,  0x2ceb,  0x2ced,  0x2cf2,  0x10a0,  0x10a1,  0x10a2,  0x10a3,  0x10a4,  0x10a5,  0x10a6,  0x10a7,  0x10a8,  0x10a9,  0x10aa,  0x10ab,  0x10ac,  0x10ad,  0x10ae,  0x10af,  0x10b0,  0x10b1,  0x10b2,  0x10b3,  0x10b4,  0x10b5,  0x10b6,  0x10b7,  0x10b8,  0x10b9,  0x10ba,  0x10bb,  0x10bc,  0x10bd,  0x10be,  0x10bf,  0x10c0,  0x10c1,  0x10c2,  0x10c3,  0x10c4,  0x10c5,  0x10c7,  0x10cd,  0xa640,  0xa642,  0xa644,  0xa646,  0xa648,  0xa64a,  0xa64c,  0xa64e,  0xa650,  0xa652,  0xa654,  0xa656,  0xa658,  0xa65a,  0xa65c,  0xa65e,  0xa660,  0xa662,  0xa664,  0xa666,  0xa668,  0xa66a,  0xa66c,  0xa680,  0xa682,  0xa684,  0xa686,  0xa688,  0xa68a,  0xa68c,  0xa68e,  0xa690,  0xa692,  0xa694,  0xa696,  0xa698,  0xa69a,  0xa722,  0xa724,  0xa726,  0xa728,  0xa72a,  0xa72c,  0xa72e,  0xa732,  0xa734,  0xa736,  0xa738,  0xa73a,  0xa73c,  0xa73e,  0xa740,  0xa742,  0xa744,  0xa746,  0xa748,  0xa74a,  0xa74c,  0xa74e,  0xa750,  0xa752,  0xa754,  0xa756,  0xa758,  0xa75a,  0xa75c,  0xa75e,  0xa760,  0xa762,  0xa764,  0xa766,  0xa768,  0xa76a,  0xa76c,  0xa76e,  0xa779,  0xa77b,  0xa77e,  0xa780,  0xa782,  0xa784,  0xa786,  0xa78b,  0xa790,  0xa792,  0xa7c4,  0xa796,  0xa798,  0xa79a,  0xa79c,  0xa79e,  0xa7a0,  0xa7a2,  0xa7a4,  0xa7a6,  0xa7a8,  0xa7b4,  0xa7b6,  0xa7b8,  0xa7ba,  0xa7bc,  0xa7be,  0xa7c0,  0xa7c2,  0xa7c7,  0xa7c9,  0xa7d0,  0xa7d6,  0xa7d8,  0xa7f5,  0xa7b3,  0x13a0,  0x13a1,  0x13a2,  0x13a3,  0x13a4,  0x13a5,  0x13a6,  0x13a7,  0x13a8,  0x13a9,  0x13aa,  0x13ab,  0x13ac,  0x13ad,  0x13ae,  0x13af,  0x13b0,  0x13b1,  0x13b2,  0x13b3,  0x13b4,  0x13b5,  0x13b6,  0x13b7,  0x13b8,  0x13b9,  0x13ba,  0x13bb,  0x13bc,  0x13bd,  0x13be,  0x13bf,  0x13c0,  0x13c1,  0x13c2,  0x13c3,  0x13c4,  0x13c5,  0x13c6,  0x13c7,  0x13c8,  0x13c9,  0x13ca,  0x13cb,  0x13cc,  0x13cd,  0x13ce,  0x13cf,  0x13d0,  0x13d1,  0x13d2,  0x13d3,  0x13d4,  0x13d5,  0x13d6,  0x13d7,  0x13d8,  0x13d9,  0x13da,  0x13db,  0x13dc,  0x13dd,  0x13de,  0x13df,  0x13e0,  0x13e1,  0x13e2,  0x13e3,  0x13e4,  0x13e5,  0x13e6,  0x13e7,  0x13e8,  0x13e9,  0x13ea,  0x13eb,  0x13ec,  0x13ed,  0x13ee,  0x13ef,  0xff21,  0xff22,  0xff23,  0xff24,  0xff25,  0xff26,  0xff27,  0xff28,  0xff29,  0xff2a,  0xff2b,  0xff2c,  0xff2d,  0xff2e,  0xff2f,  0xff30,  0xff31,  0xff32,  0xff33,  0xff34,  0xff35,  0xff36,  0xff37,  0xff38,  0xff39,  0xff3a,  0x10400,  0x10401,  0x10402,  0x10403,  0x10404,  0x10405,  0x10406,  0x10407,  0x10408,  0x10409,  0x1040a,  0x1040b,  0x1040c,  0x1040d,  0x1040e,  0x1040f,  0x10410,  0x10411,  0x10412,  0x10413,  0x10414,  0x10415,  0x10416,  0x10417,  0x10418,  0x10419,  0x1041a,  0x1041b,  0x1041c,  0x1041d,  0x1041e,  0x1041f,  0x10420,  0x10421,  0x10422,  0x10423,  0x10424,  0x10425,  0x10426,  0x10427,  0x104b0,  0x104b1,  0x104b2,  0x104b3,  0x104b4,  0x104b5,  0x104b6,  0x104b7,  0x104b8,  0x104b9,  0x104ba,  0x104bb,  0x104bc,  0x104bd,  0x104be,  0x104bf,  0x104c0,  0x104c1,  0x104c2,  0x104c3,  0x104c4,  0x104c5,  0x104c6,  0x104c7,  0x104c8,  0x104c9,  0x104ca,  0x104cb,  0x104cc,  0x104cd,  0x104ce,  0x104cf,  0x104d0,  0x104d1,  0x104d2,  0x104d3,  0x10570,  0x10571,  0x10572,  0x10573,  0x10574,  0x10575,  0x10576,  0x10577,  0x10578,  0x10579,  0x1057a,  0x1057c,  0x1057d,  0x1057e,  0x1057f,  0x10580,  0x10581,  0x10582,  0x10583,  0x10584,  0x10585,  0x10586,  0x10587,  0x10588,  0x10589,  0x1058a,  0x1058c,  0x1058d,  0x1058e,  0x1058f,  0x10590,  0x10591,  0x10592,  0x10594,  0x10595,  0x10c80,  0x10c81,  0x10c82,  0x10c83,  0x10c84,  0x10c85,  0x10c86,  0x10c87,  0x10c88,  0x10c89,  0x10c8a,  0x10c8b,  0x10c8c,  0x10c8d,  0x10c8e,  0x10c8f,  0x10c90,  0x10c91,  0x10c92,  0x10c93,  0x10c94,  0x10c95,  0x10c96,  0x10c97,  0x10c98,  0x10c99,  0x10c9a,  0x10c9b,  0x10c9c,  0x10c9d,  0x10c9e,  0x10c9f,  0x10ca0,  0x10ca1,  0x10ca2,  0x10ca3,  0x10ca4,  0x10ca5,  0x10ca6,  0x10ca7,  0x10ca8,  0x10ca9,  0x10caa,  0x10cab,  0x10cac,  0x10cad,  0x10cae,  0x10caf,  0x10cb0,  0x10cb1,  0x10cb2,  0x118a0,  0x118a1,  0x118a2,  0x118a3,  0x118a4,  0x118a5,  0x118a6,  0x118a7,  0x118a8,  0x118a9,  0x118aa,  0x118ab,  0x118ac,  0x118ad,  0x118ae,  0x118af,  0x118b0,  0x118b1,  0x118b2,  0x118b3,  0x118b4,  0x118b5,  0x118b6,  0x118b7,  0x118b8,  0x118b9,  0x118ba,  0x118bb,  0x118bc,  0x118bd,  0x118be,  0x118bf,  0x16e40,  0x16e41,  0x16e42,  0x16e43,  0x16e44,  0x16e45,  0x16e46,  0x16e47,  0x16e48,  0x16e49,  0x16e4a,  0x16e4b,  0x16e4c,  0x16e4d,  0x16e4e,  0x16e4f,  0x16e50,  0x16e51,  0x16e52,  0x16e53,  0x16e54,  0x16e55,  0x16e56,  0x16e57,  0x16e58,  0x16e59,  0x16e5a,  0x16e5b,  0x16e5c,  0x16e5d,  0x16e5e,  0x16e5f,  0x1e900,  0x1e901,  0x1e902,  0x1e903,  0x1e904,  0x1e905,  0x1e906,  0x1e907,  0x1e908,  0x1e909,  0x1e90a,  0x1e90b,  0x1e90c,  0x1e90d,  0x1e90e,  0x1e90f,  0x1e910,  0x1e911,  0x1e912,  0x1e913,  0x1e914,  0x1e915,  0x1e916,  0x1e917,  0x1e918,  0x1e919,  0x1e91a,  0x1e91b,  0x1e91c,  0x1e91d,  0x1e91e,  0x1e91f,  0x1e920,  0x1e921,  0x2000053,  0x73,  0x130,  0x2000046,  0x66,  0x2000046,  0x69,  0x2000046,  0x6c,  0x3000046,  0x66,  0x69,  0x3000046,  0x66,  0x6c,  0x2000053,  0x74,  0x2000053,  0x74,  0x2000535,  0x582,  0x2000544,  0x576,  0x2000544,  0x565,  0x2000544,  0x56b,  0x200054e,  0x576,  0x2000544,  0x56d,  0x20002bc,  0x4e,  0x3000399,  0x308,  0x301,  0x30003a5,  0x308,  0x301,  0x200004a,  0x30c,  0x2000048,  0x331,  0x2000054,  0x308,  0x2000057,  0x30a,  0x2000059,  0x30a,  0x2000041,  0x2be,  0x20003a5,  0x313,  0x30003a5,  0x313,  0x300,  0x30003a5,  0x313,  0x301,  0x30003a5,  0x313,  0x342,  0x2000391,  0x342,  0x2000397,  0x342,  0x3000399,  0x308,  0x300,  0x3000399,  0x308,  0x301,  0x2000399,  0x342,  0x3000399,  0x308,  0x342,  0x30003a5,  0x308,  0x300,  0x30003a5,  0x308,  0x301,  0x20003a1,  0x313,  0x20003a5,  0x342,  0x30003a5,  0x308,  0x342,  0x20003a9,  0x342,  0x1f88,  0x1f89,  0x1f8a,  0x1f8b,  0x1f8c,  0x1f8d,  0x1f8e,  0x1f8f,  0x1f88,  0x1f89,  0x1f8a,  0x1f8b,  0x1f8c,  0x1f8d,  0x1f8e,  0x1f8f,  0x1f98,  0x1f99,  0x1f9a,  0x1f9b,  0x1f9c,  0x1f9d,  0x1f9e,  0x1f9f,  0x1f98,  0x1f99,  0x1f9a,  0x1f9b,  0x1f9c,  0x1f9d,  0x1f9e,  0x1f9f,  0x1fa8,  0x1fa9,  0x1faa,  0x1fab,  0x1fac,  0x1fad,  0x1fae,  0x1faf,  0x1fa8,  0x1fa9,  0x1faa,  0x1fab,  0x1fac,  0x1fad,  0x1fae,  0x1faf,  0x1fbc,  0x1fbc,  0x1fcc,  0x1fcc,  0x1ffc,  0x1ffc,  0x2001fba,  0x345,  0x2000386,  0x345,  0x2001fca,  0x345,  0x2000389,  0x345,  0x2001ffa,  0x345,  0x200038f,  0x345,  0x3000391,  0x342,  0x345,  0x3000397,  0x342,  0x345,  0x30003a9,  0x342,  0x345]; return t; }
}

}


static if (size_t.sizeof == 8)
{
//2080 bytes
enum lowerCaseTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x20,  0x70], [ 0x100,  0x140,  0x2500], [ 0x402030202020100,  0x807020206020205,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3000200010000,  0x6000600050004,  0x6000600060006,  0x6000600060006,  0x8000600060007,  0x6000600060006,  0x6000600060006,  0xc000b000a0009,  0x60006000e000d,  0x600060006000f,  0x6000600060006,  0x6000600110010,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x13001200060006,  0x14000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x15000600060006,  0x16000600060006,  0x6000600060006,  0x19000600180017,  0x6000600060006,  0x600060006001a,  0x6000600060006,  0x6000600060006,  0x600060006001b,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6001c00060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x20001f001e001d,  0x6000600060006,  0x21000600060006,  0x6000600060022,  0x6000600060006,  0x6000600230006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x0,  0x7fffffe00000000,  0x420040000000000,  0xff7fffff80000000,  0x55aaaaaaaaaaaaaa,  0xd4aaaaaaaaaaab55,  0xe6512d2a4e243129,  0xaa29aaaab5555240,  0x93faaaaaaaaaaaaa,  0xffffffffffffaa85,  0x1ffffffffefffff,  0x1f00000003,  0x0,  0x3c8a000000000020,  0xfffff00000010000,  0x192faaaaaae37fff,  0xffff000000000000,  0xaaaaaaaaffffffff,  0xaaaaaaaaaaaaa802,  0xaaaaaaaaaaaad554,  0xaaaaaaaaaaaa,  0xffffffff00000000,  0x1ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xf7ffffffffff0000,  0x0,  0x0,  0x0,  0x3f00000000000000,  0x0,  0x0,  0x1ff,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x0,  0xaaaaaaaaaaaaaaaa,  0xaaaaaaaaaaaaaaaa,  0xaaaaaaaabfeaaaaa,  0xaaaaaaaaaaaaaaaa,  0xff00ff003f00ff,  0x3fff00ff00ff003f,  0x40df00ff00ff00ff,  0xdc00ff00cf00dc,  0x0,  0x8002000000000000,  0x1fff0000,  0x0,  0x321080000008c400,  0xffff0000000043c0,  0x10,  0x0,  0x0,  0x0,  0x0,  0x3ffffff0000,  0xffff000000000000,  0x3fda1562ffffffff,  0xaaaaaaaaaaaaaaaa,  0x8501aaaaaaaaa,  0x20bfffffffff,  0x0,  0x0,  0x0,  0x0,  0x2aaaaaaaaaaa,  0x3aaaaaaa,  0x0,  0xaaabaaa800000000,  0x95ffaaaaaaaaaaaa,  0xaaa082aaaaba50aa,  0x75c000002aa050a,  0xffff000000000000,  0xffff03fff7ffffff,  0xffffffffffffffff,  0x0,  0xf8007f,  0x0,  0x0,  0x0,  0x0,  0x7fffffe,  0x0,  0x0,  0xffffff0000000000,  0xffff,  0x0,  0xfffffffff000000,  0x0,  0x0,  0x1bfbfffbff800000,  0x0,  0x0,  0x0,  0x7fdffffffffffb9,  0x0,  0x0,  0x0,  0x0,  0x7ffffffffffff,  0x0,  0x0,  0x0,  0xffffffff,  0x0,  0xffffffff00000000,  0x0,  0x0,  0xffffffc000000,  0xffffdfc000,  0xebc000000ffffffc,  0xfffffc000000ffef,  0xffffffc000000f,  0xffffffc0000,  0xfc000000ffffffc0,  0xffffc000000fffff,  0xffffffc000000ff,  0xffffffc00000,  0x3ffffffc00,  0xf0000003f7fffffc,  0xffc000000fdfffff,  0xffff0000003f7fff,  0xfffffc000000fdff,  0xbf7,  0x7e07ffffbff,  0x0,  0x0,  0x0,  0xffff000000000000,  0x3fffffffffff,  0x0,  0x0,  0xfffffffc00000000,  0xf,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0]);
//1856 bytes
enum upperCaseTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x20,  0x70], [ 0x100,  0x140,  0x1e00], [ 0x402030202020100,  0x807020206020205,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3000200010000,  0x6000600050004,  0x6000600060006,  0x6000600060006,  0x8000600060007,  0x6000600060006,  0x6000600060006,  0xb000a00060009,  0x60006000c0006,  0x600060006000d,  0x6000600060006,  0x600060006000e,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x10000f00060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x11000600060006,  0x6000600060006,  0x6000600130012,  0x6000600060006,  0x6000600060014,  0x6000600060006,  0x6000600060006,  0x6000600060015,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6001600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x1a001900180017,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x60006001b0006,  0x6000600060006,  0x60006001c0006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x6000600060006,  0x0,  0x7fffffe,  0x0,  0x7f7fffff,  0xaa55555555555555,  0x2b555555555554aa,  0x11aed2d5b1dbced6,  0x55d255554aaaa490,  0x6c05555555555555,  0x557a,  0x0,  0x0,  0x0,  0x8045000000000000,  0xffbfffed740,  0xe6905555551c8000,  0xffffffffffff,  0x5555555500000000,  0x5555555555555401,  0x5555555555552aab,  0xfffe555555555555,  0x7fffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffff00000000,  0x20bf,  0x0,  0x0,  0xffffffff00000000,  0x3fffffffffffff,  0x0,  0x0,  0xe7ffffffffff0000,  0x0,  0x5555555555555555,  0x5555555555555555,  0x5555555540155555,  0x5555555555555555,  0xff00ff003f00ff00,  0xff00aa003f00,  0xf00000000000000,  0xf001f000f000f00,  0xc00f3d503e273884,  0xffff00000020,  0x8,  0x0,  0x0,  0x0,  0xffc0000000000000,  0xffff,  0xffffffffffff,  0xc025ea9d00000000,  0x5555555555555555,  0x4280555555555,  0x0,  0x155555555555,  0x5555555,  0x0,  0x5554555400000000,  0x6a00555555555555,  0x555f7d5555452855,  0x200000014102f5,  0x7fffffe00000000,  0x0,  0x0,  0x0,  0xffffffffff,  0x0,  0xffff000000000000,  0xfffff,  0x0,  0xf7ff000000000000,  0x37f7ff,  0x0,  0x0,  0x0,  0x7ffffffffffff,  0x0,  0x0,  0x0,  0xffffffff00000000,  0x0,  0x0,  0xffffffff,  0x0,  0x0,  0xfff0000003ffffff,  0xffffff0000003fff,  0x3fde64d0000003,  0x3ffffff0000,  0x7b0000001fdfe7b0,  0xfffff0000001fc5f,  0x3ffffff0000003f,  0x3ffffff00000,  0xf0000003ffffff00,  0xffff0000003fffff,  0xffffff00000003ff,  0x7fffffc00000001,  0x1ffffff0000000,  0x7fffffc00000,  0x1ffffff0000,  0x400,  0x3ffffffff,  0x0,  0x0,  0x0,  0xffff000000000000,  0xffff03ffffff03ff,  0x3ff,  0x0,  0x0,  0x0,  0x0,  0x0]);
//11520 bytes
enum simpleCaseTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x20,  0x140], [ 0x100,  0x480,  0x1180], [ 0x402030202020100,  0x702020206020205,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x3000200010000,  0x7000600050004,  0xa00090008,  0xd000c000b0000,  0x110010000f000e,  0x1400130012,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x16001500000000,  0x0,  0x0,  0x18001700000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1900000000,  0x1b001a0000,  0x1f001e001d001c,  0x23002200210020,  0x0,  0x2600250024,  0x0,  0x0,  0x28002700000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2c002b002a0029,  0x2d,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2f002e0000,  0x33003200310030,  0x0,  0x0,  0x0,  0x3500340000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x370036,  0x0,  0x0,  0x0,  0x0,  0x3b003a00390038,  0x3d003c0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3f003e00000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x41004000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x420000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x440043,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x8e100800919ffff,  0x90700bd031905f9,  0xb25006b09cc0b94,  0xacc00e0082206c5,  0x5cf059204650834,  0x19301800a2d0783,  0xffff02f904d7051c,  0xffffffffffffffff,  0x8e20081091affff,  0x90800be031a05fa,  0xb26006c09cd0b95,  0xacd00e1082306c6,  0x5d0059304660835,  0x19401810a2e0784,  0xffff02fa04d8051d,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff0961ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x852011805ac0779,  0x3d9025709b70ad2,  0xb470128038d0557,  0x315004703950629,  0x29f008608d905f1,  0xffff00cb0589070f,  0x4f90213097e0adc,  0x8eb0a3f087c06ff,  0x853011905ad077a,  0x3da025809b80ad3,  0xb480129038e0558,  0x31600480396062a,  0x2a0008708da05f2,  0xffff00cc058a0710,  0x4fa0214097f0add,  0x36a0a40087d0700,  0x4ca04c909d909d8,  0xb520b5101cd01cc,  0x730072f020001ff,  0x8ab08aa00ce00cd,  0x6120611005c005b,  0x61e061d00520051,  0x661066002b202b1,  0x7ff07fe015a0159,  0x7e507e40b830b82,  0xa5c0a5b04bc04bb,  0x591059001b401b3,  0x9690968021c021b,  0x8750874ffffffff,  0x31c031b09350934,  0x6fb00950094ffff,  0x818008f008e06fc,  0x7c80b2b0b2a0819,  0xa1d0121012007c9,  0x4da04d9ffff0a1e,  0xb600b5f07c307c2,  0x162016106bb06ba,  0x2aa02a906810680,  0xd000c06080607,  0x70006f063f063e,  0xd200d108370836,  0x1df01de07260725,  0x1a201a10b7b0b7a,  0xa4c0a4b04c404c3,  0x564056307cd07cc,  0x9f509f409730972,  0x2106240623036b,  0x5d105fc05fb0022,  0xb120b110686068f,  0x2750524026a0269,  0x1af07f80b330276,  0xabc0767ffff01b0,  0x51e08b108b00a41,  0x98c0b030229027b,  0xffff04c700970096,  0x32b00d308e700aa,  0x62c062b00190018,  0x3cd055101050104,  0xffffffff09a203ce,  0x75707ec01690168,  0x52a077d01a70758,  0xaba03020301052b,  0xffffffff02560255,  0x1adffff091c091b,  0xffffffffffffffff,  0x5de092709260925,  0xadf0ade05e005df,  0x79604fc04fb0ae0,  0x7690a580a570797,  0xa7a0440043f076a,  0x54f02fe02fd0a7b,  0xb4e0b4d07680550,  0x16b016a06530652,  0x2c002bf05f805f7,  0xf200f106450644,  0x56e056d06a706a6,  0xab60ab50ab4ffff,  0x1ae022a07460745,  0x1eb01ea0b680b67,  0x96d096c04180417,  0x59d059c083d083c,  0x8ba08b9093c093b,  0x894089303ac03ab,  0x41a04190b0c0b0b,  0xa890a8804090408,  0x52f052e02b402b3,  0x7ef07ee016d016c,  0x847084605b505b4,  0x6cc06cbffff00d4,  0xb7d0b7c00640063,  0x73c073b00c200c1,  0x886088500790078,  0x6f306f205780577,  0xffffffffffffffff,  0x7940a08ffffffff,  0x95907bc04c80795,  0x690014c014b028b,  0x9d109d002d3041b,  0x324032309220921,  0x9f109f00950094f,  0x687021d0b190400,  0x7f90b34ffff0525,  0xa42ffff0abdffff,  0xffffffffffff093d,  0x27cffff0b28051f,  0xffff00b50b70ffff,  0x63a00f90b04098d,  0xabffffffff0986,  0xffff08e8059effff,  0xffffffff032cffff,  0xffffffffffffffff,  0xffffffff0031ffff,  0x9a30514ffff0552,  0x350ffffffffffff,  0x77e01a8041c07ed,  0xffffffffffff02d4,  0xffff0abbffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff070d0092ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff096effff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1cf01ce04a304a2,  0x1f601f5ffffffff,  0xa31ffffffffffff,  0x382ffff086a0122,  0xffffffffffffffff,  0xffff0299ffffffff,  0xffff00eb082406d5,  0x9c60b9affff07f0,  0x17c04ac04b1ffff,  0x16601d20ab70a11,  0xb010b2c096f0598,  0x1060399081a0962,  0x688ffff062d0b6d,  0xac03450605032d,  0x9a084806f808f9,  0xec082506d6029a,  0x17d04ad04b2ffff,  0x16701d30ab80a12,  0xb020b2d09700599,  0x107039a081b0963,  0x68a0689062e0b6e,  0xad03460606032e,  0x9b084906f908fa,  0x97409c70b9b07f1,  0xffffffff059a04ae,  0x9750b6f0347ffff,  0x4a704a6018c018b,  0x85b085a0a830a82,  0x98509840580057f,  0x3ba03b909db09da,  0x8be08bd02f602f5,  0x363036204480447,  0x38301d6062f0b2e,  0xa7effff0ab9059b,  0x5d905d801d70a7f,  0x86b01230a32ffff,  0x96a0291051804ef,  0x5aa0090098a0aef,  0x8f300a008f506fd,  0x38f009c031d05ed,  0x3bf053e0b3f071d,  0xab0027d03d106e5,  0x4b5012608660a86,  0x1b90a0e07a80808,  0x2df0a6d050f07ea,  0x15b02450ac809a0,  0xb55093606620579,  0x5303c1061f09ea,  0x3c0053f0b40071e,  0xab1027e03d206e6,  0x4b6012708670a87,  0x1ba0a0f07a90809,  0x2e00a6e051007eb,  0x15c02460ac909a1,  0xb5609370663057a,  0x5403c2062009eb,  0x96b0292051904f0,  0x5ab0091098b0af0,  0x8f400a108f606fe,  0x390009d031e05ee,  0x5cb05ca0a9d0a9c,  0xb440b4302440243,  0x3e403e301fa01f9,  0x855085409b209b1,  0x8dc08db05a105a0,  0x398039708c208c1,  0x933093208840883,  0x416041503dc03db,  0xffffffff0b1c0b1b,  0xffffffffffffffff,  0x5a505a4ffffffff,  0xe600e508270826,  0x5e005d06ce06cd,  0x50004061a0619,  0xca00c9072e072d,  0x566056508a908a8,  0x10b010a06b306b2,  0x1a0019f04ee04ed,  0x45604550a0b0a0a,  0xb6a0b6907b907b8,  0x4050404082d082c,  0x8ea08e909bb09ba,  0x8d608d503260325,  0x3b603b509f309f2,  0x21f06c106c002db,  0x23705d705d60220,  0x49e0a1c0a1b0238,  0x2dc07910790049f,  0x55a0559023c023b,  0x6e206e102620261,  0x626062500580057,  0x6770676001e001d,  0x675067401130112,  0x568056702480247,  0x7a707a6011b011a,  0x776077504990498,  0x46804670a8b0a8a,  0xafa0af902360235,  0x42a0429038a0389,  0x8c608c5090a0909,  0x920091f03380337,  0x3d603d509fb09fa,  0xa8f0a8e08210820,  0x1cb01ca07990798,  0x2c402c30a160a15,  0x171017004ea04e9,  0x5b905b806a306a2,  0x2c002b064b064a,  0x38003706370636,  0xb400b30b640b63,  0xac70ac607360735,  0x4ec04eb088a0889,  0x227017e0b9cffff,  0xa940293071704b3,  0x587047b084e0abe,  0x1330b5d06d303a5,  0x3030352067a0384,  0x1350928067c08ff,  0xb21094506d705b2,  0x4ff052208560a00,  0x22f0a3707130295,  0xffff078505da0184,  0xffffffffffffffff,  0xffffffffffffffff,  0x228017f0b9dffff,  0xa950294071804b4,  0x588047c084f0abf,  0x1340b5e06d403a6,  0x3040353067b0385,  0x1360929067d0900,  0xb22094606d805b3,  0x500052308570a01,  0x2300a3807140296,  0xffff078605db0185,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x50b03e9081e09b3,  0x1b10b8806f401f0,  0x1b7049604830241,  0x46b08780a980a96,  0xaf1069e07fc0569,  0x42f0646039100f7,  0x8bf068d090502d9,  0x9130670033b014f,  0x3cf084a09e40b49,  0xaa2ffff02e10108,  0xffffffffffffffff,  0xffffffff0a4fffff,  0x3fa06970ae10153,  0x92e0666042b05c2,  0x3c705ef0317002d,  0x9230b3509ec0025,  0x85806ae055b008c,  0x427087e09a70ada,  0xa04075f021504fd,  0x71104d1024901da,  0x81409940aa802a1,  0x6ea03c9058503df,  0xffff039d011e0b2f,  0x6930901000effff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x36000c3043105d4,  0x930006d081206be,  0x9f60b230374088f,  0x335007e08b70601,  0xa5502cd01f70a67,  0x55d0137095106b6,  0x7c605730b7807d8,  0x75b09e804dd0489,  0x64c037802e7044d,  0x6a0099c0141084c,  0x89709150041045b,  0x632031300450b96,  0xb6109dc023309ad,  0x737054100820271,  0x77b07150a060ad8,  0x4b708b201e40526,  0x3ad06d909f80289,  0x8040b1d05b601fb,  0x35a0678034c05dc,  0x92a068402ad0139,  0x38b06210b7e004b,  0xffffffff04370061,  0x38c06220b7f004c,  0xffffffff04380062,  0x5110a1006e70540,  0x5cc09380a700a6f,  0xffffffffffff069b,  0xffffffffffffffff,  0x3fb06980ae20154,  0x92f0667042c05c3,  0x3c805f00318002e,  0x9240b3609ed0026,  0x85906af055c008d,  0x428087f09a80adb,  0xa050760021604fe,  0x71204d2024a01db,  0x81509950aa902a2,  0x6eb03ca058603e0,  0xffff039e011f0b30,  0x6940902000fffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff0505ffff,  0xffffffff030dffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0b8cffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4c604c506f106f0,  0xb810b8007740773,  0x472047108010800,  0x260025f09810980,  0x904090305760575,  0x334033308f008ef,  0x910090f02cc02cb,  0x3d403d3045a0459,  0x7c507c40afe0afd,  0xa180a1704dc04db,  0x5c905c801ac01ab,  0x72a07290240023f,  0x83b083a00db00da,  0x61406130060005f,  0x60c060b00130012,  0x692069102a402a3,  0x6b506b4015e015d,  0x79d079c05af05ae,  0x49104900a5e0a5d,  0xb540b5302080207,  0x3de03dd020e020d,  0x877087609420941,  0x8fc08fb03550354,  0x37d037c08ce08cd,  0x95e095d08810880,  0x204020303d803d7,  0x1b601b50b380b37,  0xa3c0a3b047e047d,  0x5c105c007db07da,  0x14e014d080d080c,  0x2ac02ab065b065a,  0x4a004906310630,  0x890088061c061b,  0x53d053c089f089e,  0x206020507340733,  0x1d101d004c004bf,  0x43e043d0a540a53,  0xffffffff07cf07ce,  0x882ffffffffffff,  0xffff08ecffffffff,  0x8e408e303080307,  0x3a203a109c509c4,  0xad70ad602540253,  0x7e307e2042e042d,  0x7af07ae0a200a1f,  0x720071f04c204c1,  0x5440543021a0219,  0x702070100990098,  0x5f605f500a300a2,  0x6510650004e004d,  0xaf40af301250124,  0x531053002f402f3,  0x770076f01170116,  0x7b307b204950494,  0x3f503f40a6a0a69,  0xb770b76024e024d,  0x43a043903bc03bb,  0x8f208f108d008cf,  0x91e091d035f035e,  0x54a054909910990,  0xa720a7108a108a0,  0x19a01990450044f,  0x1d501d40a440a43,  0xee00ed06de06dd,  0x9fc003503a70603,  0x55300f3094b0b3b,  0x9fd003603a80604,  0x55400f4094c0b3c,  0x22b019d0a2f076b,  0xffffffff06f604cb,  0x22c019e0a30076c,  0xffffffff06f704cc,  0x16030505fd039b,  0x172086c067e08e5,  0x17030605fe039c,  0x173086d067f08e6,  0x1820ac20a3302e5,  0x1e0078c04a801a3,  0x1830ac30a3402e6,  0x1e1078d04a901a4,  0x35605e1034e0074,  0xffffffff08bb000a,  0x35705e2034f0075,  0xffffffff08bc000b,  0xa59ffff01e6ffff,  0x76dffff04d3ffff,  0xa5affff01e7ffff,  0x76effff04d4ffff,  0x654043b02c5098e,  0x5e30b86002903b1,  0x655043c02c6098f,  0x5e40b87002a03b2,  0x9d202d502ed0445,  0x41d05cd02090a6b,  0xa510aaa000808df,  0xffffffff06170321,  0x3a3028509640b15,  0x8ed012a02c10664,  0x3a4028609650b16,  0x8ee012b02c20665,  0x9ee028f03b706df,  0x5b001fd07f20b0d,  0x9ef029003b806e0,  0x5b101fe07f30b0e,  0xdc09af0b7409de,  0x7c0281073d058e,  0xdd09b00b7509df,  0x7d0282073e058f,  0x978ffff06680370,  0xffffffffffffffff,  0x2ee044606690371,  0xffff0971ffff0979,  0xf5ffffffffffff,  0xffffffffffffffff,  0x20a0a6c09d302d6,  0xffffffffffff00f6,  0xffffffff035c00bb,  0xffffffffffffffff,  0x41e05ce035d00bc,  0xffffffffffffffff,  0xffffffff01c30176,  0xffffffff029bffff,  0xa520aab01c40177,  0xffffffffffff029c,  0x3bdffffffffffff,  0xffffffffffffffff,  0x6180322000908e0,  0xffffffffffff03be,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff06faffffffff,  0x9b90b27ffffffff,  0xffffffffffffffff,  0xffff094dffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff094effffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x45704920a7307b0,  0xa3d09d601780765,  0x70702f101ec0532,  0x82a044b00de0ae5,  0x45804930a7407b1,  0xa3e09d701790766,  0x70802f201ed0533,  0x82b044c00df0ae6,  0x870ffffffffffff,  0xffffffffffff0871,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x594037affffffff,  0x743081600a60b1f,  0x89509c8052803fc,  0x7b404850a8c020f,  0xa9a071b018d0221,  0x516085c029d0102,  0x93f065c09760b17,  0xa70b200595037b,  0x52903fd07440817,  0xa8d0210089609c9,  0x18e022207b50486,  0x29e01030a9b071c,  0x9770b180517085d,  0xffffffff0940065d,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x10c0ae7065603c5,  0x509044106b00828,  0xaac01c808680a49,  0x225020b0751049a,  0x27705360b590709,  0x98200a8040a080e,  0x5a2002f09390703,  0x8cb003b09570638,  0x8720151039f066e,  0x3e505d20b050682,  0xa9e0114040207d0,  0x53801bb02e304b9,  0x10d0ae8065703c6,  0x50a044206b10829,  0xaad01c908690a4a,  0x226020c0752049b,  0x27805370b5a070a,  0x98300a9040b080f,  0x5a30030093a0704,  0x8cc003c09580639,  0x873015203a0066f,  0x3e605d30b060683,  0xa9f0115040307d1,  0x53901bc02e404ba,  0x30e063b003a0039,  0x9d407bd0a090032,  0x265037f037e09d5,  0x401059f0b1a0266,  0xa140a13ffff021e,  0xffff074c074bffff,  0xffffffffffffffff,  0x28c095affffffff,  0x33a033902a602a5,  0x90e090d08c808c7,  0x2b902b803730372,  0x46e046d09930992,  0xb500b4f07fb07fa,  0x4b004af07780777,  0x1e901e80a600a5f,  0xd600d5056c056b,  0x66006507280727,  0x20001f08a508a4,  0x5a005906280627,  0x26402630b140b13,  0x190018f06bd06bc,  0x5bb05ba07bf07be,  0xa360a35074e074d,  0x280027f04e004df,  0x3aa03a90afc0afb,  0x95409530470046f,  0x328032708d208d1,  0x9bd09bc092d092c,  0x82f082e057c057b,  0x420041f0aa70aa6,  0xa0d0a0c02180217,  0x70c070b01a601a5,  0x81d081c010f010e,  0xffffffffffffffff,  0x358ffffffffffff,  0xffff032a03290359,  0x6d006cfffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x50c03ea081f09b4,  0x1b20b8906f501f1,  0x1b8049704840242,  0x46c08790a990a97,  0xaf2069f07fd056a,  0x4300647039200f8,  0x8c0068e090602da,  0x9140671033c0150,  0x3d0084b09e50b4a,  0xaa3ffff02e20109,  0xffffffffffffffff,  0xffffffff0a50ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xa1a0a1901d901d8,  0x79b079a0a930a92,  0x69d069c0140013f,  0x4f404f302bb02ba,  0x6410640003e003d,  0x649064805bd05bc,  0x73a073900770076,  0xb660b650040003f,  0x782078104e804e7,  0x88e088d0acf0ace,  0xac10ac002c802c7,  0xffffffff017b017a,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x298029705130512,  0x9ff09fe09480947,  0xa7d0a7c07ad07ac,  0x18a01890a3a0a39,  0xaf00ae07480747,  0x52d052c08880887,  0x34003305ea05e9,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x70006ffffffff,  0xc600c508a708a6,  0xe800e706ef06ee,  0x680067060e060d,  0x1580157ffffffff,  0xb460b4508310830,  0x9bf09be05020501,  0x2b002af0a260a25,  0x95c095b087b087a,  0x3940393097d097c,  0x85108500b580b57,  0x330032f03120311,  0x5a705a602120211,  0x9890988040f040e,  0x8650864051b051a,  0xa220a21023e023d,  0x66b066a00ff00fe,  0x6a506a40b0a0b09,  0x65f065e01560155,  0x69a069902ea02e9,  0xffffffffffffffff,  0xffffffffffffffff,  0x4d507a107a0ffff,  0xb6c0b6b050604d6,  0x9b609b505840583,  0x84108400acb0aca,  0x4fffffffffffff,  0xffffffff0b710050,  0x24c024b0b080b07,  0x3b003afffff078e,  0x49d049c07d707d6,  0x9cb09ca03f903f8,  0x27a0279050e050d,  0x11d011c080b080a,  0x93e00b607060705,  0xffff00fa09870b29,  0xb5b00930351070e,  0x9f009e05e805e7,  0x13e013d06e406e3,  0x28e028d054e054d,  0x434043308030802,  0x7590b8d0515078f,  0xffff01750174075a,  0xffffffffffffffff,  0xffffffff02f802f7,  0x310030fffffffff,  0xffffffff0aec0aeb,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff09e709e6ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xb5cffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x36100c4043205d5,  0x931006e081306bf,  0x9f70b2403750890,  0x336007f08b80602,  0xa5602ce01f80a68,  0x55e0138095206b7,  0x7c705740b7907d9,  0x75c09e904de048a,  0x64d037902e8044e,  0x6a1099d0142084d,  0x89809160042045c,  0x633031400460b97,  0xb6209dd023409ae,  0x738054200830272,  0x77c07160a070ad9,  0x4b808b301e50527,  0x3ae06da09f9028a,  0x8050b1e05b701fc,  0x35b0679034d05dd,  0x92b068502ae013a,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x2670aed09c0ffff,  0x949064205a80143,  0xb720771074904cd,  0x3fe04f507c0013b,  0x2ef03eb054b0259,  0x19707a20a800aae,  0xffff045105ff08c3,  0xffffffffffffffff,  0x2680aee09c1ffff,  0x94a064305a90144,  0xb730772074a04ce,  0x3ff04f607c1013c,  0x2f003ec054c025a,  0x19807a30a810aaf,  0xffff0452060008c4,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x5be075d074f0a61,  0x9ab0aa407e8012f,  0x2dd099a0af50955,  0x14507d204e104f7,  0x8c90634047700e9,  0x36c072102cf0043,  0x25d0547040602d1,  0x38006720b840147,  0x479078a0ac40a75,  0xb4b077f02310481,  0x5bf075e07500a62,  0x9ac0aa507e90130,  0x2de099b0af60956,  0x14607d304e204f8,  0x8ca0635047800ea,  0x36d072202d00044,  0x25e0548040702d2,  0x38106730b850148,  0x47a078b0ac50a76,  0xb4c078002320482,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x73f07d40ad00a45,  0xaff09960223056f,  0x7920b3909c2022d,  0x761047f04a0024f,  0x6a8034305c40331,  0x6c7028301bf0b31,  0x64e03c3028709a9,  0x60908d3002702eb,  0x8ac0a290a270753,  0xffffffffffffffff,  0x74007d50ad10a46,  0xb00099702240570,  0x7930b3a09c3022e,  0x762048004a10250,  0x6a9034405c50332,  0x6c8028401c00b32,  0x64f03c4028809aa,  0x60a08d4002802ec,  0x8ad0a2a0a280754,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x26b00a40461088b,  0x25101100ae306aa,  0xffff00b709430b3d,  0x8fd00b908f705e5,  0x1310b4107ca0806,  0x2ff03e1055f0832,  0xffff02a704210581,  0x4e3047507630a23,  0xffff03b3063c0a2b,  0x88cffff06d102c9,  0x6ab026c00a50462,  0xb3e025201110ae4,  0x5e6ffff00b80944,  0x80708fe00ba08f8,  0x83301320b4207cb,  0x582030003e20560,  0xa24ffff02a80422,  0xa2c04e404760764,  0x2caffff03b4063d,  0xffffffffffff06d2,  0x1490191048704cf,  0x57101e207e00b8e,  0x44305c603e70695,  0x3090a470a8407e6,  0xc7090b0b8a0911,  0x8a0891072b0341,  0x10009660862045f,  0x7a036607190899,  0x33f04bd05200201,  0x463079e0ad40a63,  0x53a04690838095f,  0x1bd0b9006e80239,  0xffff066c09e002fb,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x14a0192048804d0,  0x57201e307e10b8f,  0x44405c703e80696,  0x30a0a480a8507e7,  0xc8090c0b8b0912,  0x8b0892072c0342,  0x101096708630460,  0x7b0367071a089a,  0x34004be05210202,  0x464079f0ad50a64,  0x53b046a08390960,  0x1be0b9106e9023a,  0xffff066d09e102fc,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xb9207a401dc057d,  0x4e5048e01c101a9,  0x83e0731036e00cf,  0x45d0844097a00ef,  0x68b086e015f0b0f,  0x60f08dd02d7034a,  0x8420ab20a650364,  0x6b803cb05550453,  0xb9307a501dd057e,  0x4e6048f01c201aa,  0x83f0732036f00d0,  0x45e0845097b00f0,  0x68c086f01600b10,  0x61008de02d8034b,  0x8430ab30a660365,  0x6b903cc05560454,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x31f0723099e0084,  0x40c05f30410025b,  0x56106db09170069,  0xa02061503480010,  0x19507aa04aa0473,  0x1ee0aa006ec030b,  0xae906c908a204f1,  0x50307b609e20a4d,  0x3200724099f0085,  0x40d05f40411025c,  0x56206dc0918006a,  0xa03061603490011,  0x19607ab04ab0474,  0x1ef0aa106ed030c,  0xaea06ca08a304f2,  0x50407b709e30a4e,  0x8ae005503f60658,  0x435002308d705eb,  0xbf03760596,  0x507053408100741,  0x755019b000207ba,  0xa90033d044904a4,  0x545016e02730af7,  0x9ce0b98099806ac,  0x3f7065900140368,  0x8d805ec08af0056,  0x377059704360024,  0x8110742000100c0,  0x307bb05080535,  0x44a04a50756019c,  0x2740af80a91033e,  0x99906ad0546016f,  0x15036909cf0b99,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff]);
//11648 bytes
enum fullCaseTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x20,  0x140], [ 0x100,  0x480,  0x11c0], [ 0x402030202020100,  0x702020206020205,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x3000200010000,  0x7000600050004,  0xa00090008,  0xd000c000b0000,  0x110010000f000e,  0x1400130012,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x16001500000000,  0x0,  0x0,  0x18001700000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1900000000,  0x1b001a0000,  0x1f001e001d001c,  0x23002200210020,  0x0,  0x2600250024,  0x0,  0x0,  0x28002700000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2c002b002a0029,  0x2d,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2f002e0000,  0x33003200310030,  0x0,  0x0,  0x0,  0x3500340000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x36,  0x0,  0x0,  0x0,  0x380037,  0x0,  0x0,  0x0,  0x0,  0x3c003b003a0039,  0x3e003d0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x40003f00000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x42004100000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x430000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x450044,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x984008a09beffff,  0x9ac00c703440658,  0xbf400740a7c0c6a,  0xb9100ef08b10736,  0x62905e604a608c3,  0x1ac01990ae607fe,  0xffff032005210569,  0xffffffffffffffff,  0x985008b09bfffff,  0x9ad00c803450659,  0xbf500750a7d0c6b,  0xb9200f008b20737,  0x62a05e704a708c4,  0x1ad019a0ae707ff,  0xffff03210522056a,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff0a0bffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x8e3012e060507f2,  0x41202770a640b9a,  0xc18013e03c105a6,  0x340004e03c9068a,  0x2c20090097c0650,  0xffff00d505da0781,  0x54302300a2a0ba7,  0xba20af909110771,  0x8e4012f060607f3,  0x41302780a650b9b,  0xc19013f03c205a7,  0x341004f03ca068b,  0x2c30091097d0651,  0xffff00d605db0782,  0x54402310a2b0ba8,  0x39b0afa09120772,  0x51205110a890a88,  0xc230c2201e601e5,  0x7a607a5021d021c,  0x946094500d800d7,  0x673067200650064,  0x67f067e005b005a,  0x6c406c302d802d7,  0x889088801730172,  0x86808670c550c54,  0xb180b1705040503,  0x5e505e401cd01cc,  0xa140a1302390238,  0x90a0909ffff03f6,  0x347034609dd09dc,  0x76d009f009effff,  0x8a700990098076e,  0x8440bfa0bf908a8,  0xad6013701360845,  0x5240523031a0ad7,  0xc310c30083f083e,  0x17b017a072a0729,  0x2d002cf06eb06ea,  0xf000e06690668,  0x79007806a0069f,  0xdc00db08c608c5,  0x1fb01fa079c079b,  0x1bb01ba0c4d0c4c,  0xb080b07050c050b,  0x5b305b2084b084a,  0xaab0aaa0a1e0a1d,  0x2506850684039c,  0x62b065b065a0026,  0xbe00bdf06f006f9,  0x2950571028a0289,  0x1c808810c020296,  0xb8107e0ffff01c9,  0x56b094f094e0afb,  0xa380bd00247029b,  0xffff050f00a100a0,  0x35600dd098a00b4,  0x68d068c001d001c,  0x40605a001180117,  0xffffffff0a4e0407,  0x7d0087401820181,  0x57707f801c007d1,  0xb7f032903280578,  0xffffffff02760275,  0x1c6ffff09c109c0,  0xffffffffffffffff,  0x63b09cf09ce09cd,  0xbaa0ba9063d063c,  0x812054605450bab,  0x7e20b140b130813,  0xb39047d047c07e3,  0x59e032503240b3a,  0xc1f0c1e07e1059f,  0x184018306b606b5,  0x2e602e506570656,  0x101010006a606a5,  0x5bd05bc07140713,  0xb7b0b7a0b790928,  0x1c7024807bf07be,  0x20702060c390c38,  0xa180a1704550454,  0x5f105f008ce08cd,  0x95b095a09e409e3,  0x92d092c03e103e0,  0x45704560bd90bd8,  0xb480b4704460445,  0x57c057b02da02d9,  0x877087601860185,  0x8d808d7060f060e,  0x73d073cffff00de,  0xc4f0c4e006d006c,  0x7b407b300cc00cb,  0x91b091a00820081,  0x765076405c905c8,  0xffffffffffffffff,  0x8100abeffffffff,  0xa03083805100811,  0x6fa0165016402ad,  0xa810a8002fa0458,  0x34f034e09c709c6,  0xaa70aa609fa09f9,  0x6f1023a0be8043b,  0x8820c03ffff0572,  0xafcffff0b82ffff,  0xffffffffffff09e5,  0x29cffff0bf7056c,  0xffff00bf0c41ffff,  0x69b01090bd10a39,  0xb5ffffffff0a32,  0xffff098b05f7ffff,  0xffffffff0357ffff,  0xffffffffffffffff,  0xffffffff0035ffff,  0xa4f055fffff05a1,  0x380ffffffffffff,  0x7f901c104590875,  0xffffffffffff02fb,  0xffff0b80ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff077f009cffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff0a19ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1e801e704e604e5,  0x2120211ffffffff,  0xaeaffffffffffff,  0x3b3ffff08ff0138,  0xffffffffffffffff,  0xffff02bcffffffff,  0xffff00fa08b30746,  0xa750c70ffff0878,  0x19504f104f90883,  0x17f01eb0b7c0aca,  0xbce0bfb0a1a05ec,  0x11903cd08a90a0c,  0x6f2ffff068e0c3e,  0xb6037206660358,  0xa408d9076a099e,  0xfb08b4074702bd,  0x19604f204fa0a79,  0x18001ec0b7d0acb,  0xbcf0bfc0a1b05ed,  0x11a03ce08aa0a0d,  0x6f406f3068f0c3f,  0xb7037306670359,  0xa508da076b099f,  0xa1f0a760c710879,  0xffffffff05ee04f3,  0xa200c400374ffff,  0x4ec04eb01a501a4,  0x8f008ef0b420b41,  0xa310a3005d105d0,  0x3f003ef0a8b0a8a,  0x95f095e031d031c,  0x394039304850484,  0x3b401ef06900bfd,  0xb3dffff0b7e05ef,  0x631063001f00b3e,  0x90001390aebffff,  0xa1502b405650539,  0x603009a0a360bba,  0x99800aa099a076f,  0x3c300a60348064a,  0x3f8058d0c0e0790,  0xb72029d040a0757,  0x4fd013c08fb0b45,  0x1d20ac408240894,  0x3060b2c055a0872,  0x17402650b8d0a4c,  0xc2609de06c505ca,  0x5c03fc06800a9d,  0x3f9058e0c0f0791,  0xb73029e040b0758,  0x4fe013d08fc0b46,  0x1d30ac508250895,  0x3070b2d055b0873,  0x17502660b8e0a4d,  0xc2709df06c605cb,  0x5d03fd06810a9e,  0xa1602b50566053a,  0x604009b0a370bbb,  0x99900ab099b0770,  0x3c400a70349064b,  0x62506240b5c0b5b,  0xc130c1202640263,  0x41d041c02160215,  0x8e608e50a5f0a5e,  0x97f097e05f605f5,  0x3cc03cb09630962,  0x9db09da09190918,  0x453045204150414,  0xffffffff0beb0bea,  0xffffffffffffffff,  0x5fe05fdffffffff,  0xf500f408b608b5,  0x670066073f073e,  0x50004067b067a,  0xd400d307a407a3,  0x5b505b409440943,  0x11e011d07220721,  0x1b901b805380537,  0x49504940ac10ac0,  0xc3b0c3a08350834,  0x442044108bc08bb,  0x98d098c0a680a67,  0x977097603510350,  0x3eb03ea0aa90aa8,  0x23c073207310302,  0x25506330632023d,  0x4e10ad50ad40256,  0x303080d080c04e2,  0x5a905a8025a0259,  0x754075302820281,  0x687068600610060,  0x6e006df00220021,  0x6db06da01290128,  0x5b705b602680267,  0x823082201310130,  0x7ef07ee04dc04db,  0x4a904a80b4a0b49,  0xbc50bc402540253,  0x467046603be03bd,  0x967096609af09ae,  0x9c509c403650364,  0x40f040e0ab10ab0,  0xb4e0b4d08b008af,  0x1e401e308150814,  0x2eb02ea0acf0ace,  0x18a018905340533,  0x61306120710070f,  0x30002f06ac06ab,  0x3c003b06980697,  0xbe00bd0c350c34,  0xb8c0b8b07ae07ad,  0x536053509230922,  0x24501970c72ffff,  0xb5302b6078904fb,  0x5d804be08df0b83,  0x14a0c2e074403da,  0x32a038206e403b5,  0x14c09d006e609a4,  0xbf009ed0748060c,  0x549056f08e70ab6,  0x24d0af0078502b8,  0xffff08000637019d,  0xffffffffffffffff,  0xffffffffffffffff,  0x24601980c73ffff,  0xb5402b7078a04fc,  0x5d904bf08e00b84,  0x14b0c2f074503db,  0x32b038306e503b6,  0x14d09d106e709a5,  0xbf109ee0749060d,  0x54a057008e80ab7,  0x24e0af1078602b9,  0x66208010638019e,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x556042208ad0a60,  0x1ca0c5e0766020c,  0x1d004d904c60261,  0x4ac090d0b570b55,  0xbbc070b088605b8,  0x46c06a703c50107,  0x96006f709aa0300,  0x9b806d403680168,  0x40808db0a970c1a,  0xb61ffff0308011b,  0xffffffffffffffff,  0xffffffff0b0bffff,  0x43507020bac016c,  0x9d606ca0468061c,  0x3fe064c03420031,  0x9cb0c040aa10029,  0x8eb071d05aa0096,  0x46409130a530ba5,  0xaba07d802320547,  0x7830519026901f3,  0x8a30a400b6802c4,  0x75c040005d60418,  0xffff03d101340bfe,  0x6fd09a60010ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x39100cd046e062e,  0x9d8007608a1072f,  0xaac0bf203a5093b,  0x362008c09580660,  0xb1102f402130b24,  0x5ac014e09fb0725,  0x84205c40c4a085b,  0x7d40a9b052704cc,  0x6ad03a9030e048a,  0x70d0a48015808dd,  0x93009ba004a049a,  0x693033e004c0c6c,  0xc320a8c02510a59,  0x7af059000940291,  0x7f607870abc0ba0,  0x4ff095302000573,  0x3e2074a0aae02ab,  0x8900c0806100217,  0x39906ee037a0639,  0x9d2071902d30150,  0x3bf06820c500054,  0xffffffff0474006a,  0x3c006830c510055,  0xffffffff0475006b,  0x55c0ac60759058f,  0x62609e00b2f0b2e,  0xffffffffffff0708,  0xffffffffffffffff,  0x43607030bad016d,  0x9d706cb0469061d,  0x3ff064d03430032,  0x9cc0c050aa2002a,  0x8ec071e05ab0097,  0x46509140a540ba6,  0xabb07d902330548,  0x784051a026a01f4,  0x8a40a410b6902c5,  0x75d040105d70419,  0xffff03d201350bff,  0x6fe09a70011ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff0561ffff,  0xffffffff0338ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0c62ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x50e050d07630762,  0xc530c5207ed07ec,  0x4b304b2088b088a,  0x280027f0a2d0a2c,  0x9a909a805c705c6,  0x361036009950994,  0x9b509b402f302f2,  0x40d040c04990498,  0x84108400bc90bc8,  0xad10ad005260525,  0x623062201c501c4,  0x7a0079f0260025f,  0x8ca08c900e500e4,  0x675067400690068,  0x66d066c00150014,  0x6fc06fb02c702c6,  0x724072301770176,  0x819081806080607,  0x4d404d30b1a0b19,  0xc250c2402250224,  0x4170416022b022a,  0x90c090b09ea09e9,  0x9a109a003850384,  0x3ae03ad096f096e,  0xa080a0709160915,  0x221022004110410,  0x1cf01ce0c070c06,  0xaf60af504c104c0,  0x61b061a085e085d,  0x1670166089c089b,  0x2d202d106be06bd,  0x51005006920691,  0x930092067d067c,  0x58c058b09380937,  0x223022207ac07ab,  0x1ea01e905080507,  0x47b047a0b100b0f,  0xdf0c5c084d084c,  0x917049e05ba03fa,  0xffff0ba3ffffffff,  0x987098603310330,  0x3d603d50a740a73,  0xb9f0b9e02740273,  0x8660865046b046a,  0x82b082a0ad90ad8,  0x7930792050a0509,  0x593059202370236,  0x774077300a300a2,  0x655065400ad00ac,  0x6b406b300570056,  0xbbf0bbe013b013a,  0x57e057d03270326,  0x7e907e8012d012c,  0x82f082e04d804d7,  0x430042f0b270b26,  0xc490c48026e026d,  0x477047603f203f1,  0x997099609710970,  0x9c309c20390038f,  0x59905980a3d0a3c,  0xb310b30093a0939,  0x1b301b2048d048c,  0x1ee01ed0b000aff,  0xfd00fc074f074e,  0xab2003903dc0664,  0x5a2010209f30c0a,  0xab3003a03dd0665,  0x5a3010309f40c0b,  0x24901b60ae807e4,  0xffffffff07680513,  0x24a01b70ae907e5,  0xffffffff07690514,  0x1a032c065c03cf,  0x18b090106e80988,  0x1b032d065d03d0,  0x18c090206e90989,  0x19b0b870aec030c,  0x1fc080704ed01bc,  0x19c0b880aed030d,  0x1fd080804ee01bd,  0x386063e037e007d,  0xffffffff095c000c,  0x387063f037f007e,  0xffffffff095d000d,  0xb1508ed02020085,  0x7e6072b051b0bec,  0xb16ffff0203ffff,  0x7e7ffff051cffff,  0x6b7047802ec0a3a,  0x6400c5a002d03e6,  0x6b8047902ed0a3b,  0x6410c5b002e03e7,  0xa8202fc03140482,  0x45a062702260b2a,  0xb0d0b6a000a0982,  0xffffffff0678034c,  0x8560b760ac70be3,  0x991014005f20794,  0x8570b770ac80be4,  0x992014105f30795,  0xaa3063403ec0750,  0x609021909c80bda,  0xaa4063503ed0751,  0x60a021a09c90bdb,  0xb1f0b950c450a90,  0x1f7054f07b50947,  0xb200b960c460a91,  0x1f8055007b60948,  0xa23048e06cc03a1,  0x3f0c43ffff0336,  0x315048306cd03a2,  0xffff0a1cffff0a24,  0xaf2084effffffff,  0x51f0581ffff0a9f,  0x2270b2b0a8302fd,  0xffffffffffff0af3,  0x884091e038d00c5,  0x96c064effffffff,  0x45b0628038e00c6,  0xffffffffffffffff,  0xa7a08e901dc018f,  0x4e707f402be0c16,  0xb0e0b6b01dd0190,  0xffffffffffff02bf,  0x6ff0a6bffffffff,  0x6d8091cffff05d2,  0x679034d000b0983,  0xffffffffffff0700,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff076cffffffff,  0xa660bf6ffffffff,  0xffffffffffffffff,  0xffff09f7ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff09f8ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x49604d50b32082c,  0xaf70a86019107de,  0x77903180208057f,  0x8b9048800eb0bb0,  0x49704d60b33082d,  0xaf80a87019207df,  0x77a031902090580,  0x8ba048900ec0bb1,  0x905ffffffffffff,  0xffffffffffff0906,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x5e803abffffffff,  0x7bc08a500b00bee,  0x92e0a7705750437,  0x83004c80b4b022c,  0xb59078e01a60241,  0x56308f102c00115,  0x9e706bf0a210be6,  0xb10bef05e903ac,  0x576043807bd08a6,  0xb4c022d092f0a78,  0x1a70242083104c9,  0x2c101160b5a078f,  0xa220be7056408f2,  0xffffffff09e806c0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x11f0bb206b90402,  0x554047e071f08b7,  0xb6c01e108fd0b05,  0x243022807ca04dd,  0x29705830c2a077b,  0xa2e00b20447089d,  0x5f9003309e10775,  0x97400450a010699,  0x907016a03d306d2,  0x41e062c0bd206ec,  0xb5d012a043d0850,  0x58501d4030a0501,  0x1200bb306ba0403,  0x555047f072008b8,  0xb6d01e208fe0b06,  0x244022907cb04de,  0x29805840c2b077c,  0xa2f00b30448089e,  0x5fa003409e20776,  0x97500460a02069a,  0x908016b03d406d3,  0x41f062d0bd306ed,  0xb5e012b043e0851,  0x58601d5030b0502,  0x339069c003e003d,  0xa8408390abf0036,  0x28503b003af0a85,  0x43c05f80be90286,  0xacd0accffff023b,  0xffff07c507c4ffff,  0xffffffffffffffff,  0x2ae0a04ffffffff,  0x367036602c902c8,  0x9b309b209690968,  0x2df02de03a403a3,  0x4af04ae0a3f0a3e,  0xc210c20088d088c,  0x4f504f407f107f0,  0x20502040b1c0b1b,  0xee00ed05bf05be,  0x6f006e079e079d,  0x2400230940093f,  0x63006206890688,  0x28402830be20be1,  0x1a901a8072e072d,  0x6150614083b083a,  0xaef0aee07c707c6,  0x2a0029f052a0529,  0x3df03de0bc70bc6,  0x9fe09fd04b104b0,  0x353035209730972,  0xa6a0a6909d509d4,  0x8be08bd05cd05cc,  0x45d045c0b670b66,  0xac30ac202350234,  0x77e077d01bf01be,  0x8ac08ab01220121,  0xffffffffffffffff,  0x38bffffffffffff,  0xffff03550354038c,  0x7410740ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x557042308ae0a61,  0x1cb0c5f0767020d,  0x1d104da04c70262,  0x4ad090e0b580b56,  0xbbd070c088705b9,  0x46d06a803c60108,  0x96106f809ab0301,  0x9b906d503690169,  0x40908dc0a980c1b,  0xb62ffff0309011c,  0xffffffffffffffff,  0xffffffff0b0cffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xad30ad201f201f1,  0x81708160b520b51,  0x70a070901570156,  0x53e053d02e102e0,  0x6a206a100420041,  0x6aa06a906170616,  0x7b207b10080007f,  0xc370c3600440043,  0x7fd07fc05320531,  0x92709260b940b93,  0xb860b8502ef02ee,  0xffffffff01940193,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x2bb02ba055e055d,  0xab50ab409f009ef,  0xb3c0b3b08290828,  0x1a301a20afe0afd,  0xb900b807c107c0,  0x57a057909210920,  0x38003706470646,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x90008ffffffff,  0xd000cf09420941,  0xf700f607610760,  0x710070066f066e,  0x1710170ffffffff,  0xc150c1408c008bf,  0xa700a6f054c054b,  0x2d602d50adf0ade,  0xa060a050910090f,  0x3c803c70a290a28,  0x8e208e10c290c28,  0x35d035c033d033c,  0x60005ff022f022e,  0xa350a34044c044b,  0x8fa08f905680567,  0xadb0ada025c025b,  0x6cf06ce01140113,  0x71207110bd70bd6,  0x6c206c1016f016e,  0x705070403110310,  0xffffffffffffffff,  0xffffffffffffffff,  0x51d081d081cffff,  0xc3d0c3c0562051e,  0xa630a6205d505d4,  0x8d208d10b900b8f,  0x58ffffffffffff,  0xffffffff0c420059,  0x26c026b0bd50bd4,  0x3e503e4ffff0826,  0x4e004df085a0859,  0xa8f0a8e04340433,  0x29a029905590558,  0x1330132089a0899,  0x9e600c007780777,  0xffff010a0a330bf8,  0xc2c009d03810780,  0xa900a806450644,  0x155015407560755,  0x2b002af059d059c,  0x4710470088f088e,  0x7d20c6305600827,  0xffff018e018d07d3,  0xffffffffffffffff,  0xffffffff031f031e,  0x33b033affffffff,  0xffffffff0bb70bb6,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0a9a0a99ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xc2dffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x39200ce046f062f,  0x9d9007708a20730,  0xaad0bf303a6093c,  0x363008d09590661,  0xb1202f502140b25,  0x5ad014f09fc0726,  0x84305c50c4b085c,  0x7d50a9c052804cd,  0x6ae03aa030f048b,  0x70e0a49015908de,  0x93109bb004b049b,  0x694033f004d0c6d,  0xc330a8d02520a5a,  0x7b0059100950292,  0x7f707880abd0ba1,  0x500095402010574,  0x3e3074b0aaf02ac,  0x8910c0906110218,  0x39a06ef037b063a,  0x9d3071a02d40151,  0x5fb014808c10bca,  0xffff0b640b630846,  0xffffffffffffffff,  0xffffffffffffffff,  0x9f5ffffffffffff,  0x35a001604b4069d,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x2870bb80a6dffff,  0x9f106a30601015a,  0xc6607ea07c20515,  0x439053f083c0152,  0x3160426059a0279,  0x1b0081e0b3f0b6e,  0xffff0490065e0964,  0xffffffffffffffff,  0x2880bb90a6effff,  0x9f206a40602015b,  0xc6707eb07c30516,  0x43a0540083d0153,  0x3170427059b027a,  0x1b1081f0b400b6f,  0xffff0491065f0965,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x61807d607c80b1d,  0xa570b70086d0146,  0x3040a460bc009ff,  0x15c0854052b0541,  0x96a069504ba00f8,  0x39d079702f60052,  0x27d0596044302f8,  0x3b106d60c56015e,  0x4bc08050b890b34,  0xc1c07fa024f04c4,  0x61907d707c90b1e,  0xa580b71086e0147,  0x3050a470bc10a00,  0x15d0855052c0542,  0x96b069604bb00f9,  0x39e079802f70053,  0x27e0597044402f9,  0x3b206d70c57015f,  0x4bd08060b8a0b35,  0xc1d07fb025004c5,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x7b808690b980b01,  0xbcc0a42025705c0,  0x80e0c100a71024b,  0x7da04c204e3026f,  0x7150370061e035e,  0x73802a401d80c00,  0x6b1042002a90a55,  0x66a0978002b0312,  0x94a0ae20ae007cc,  0xffffffffffffffff,  0x7b9086a0b990b02,  0xbcd0a43025805c1,  0x80f0c110a72024c,  0x7db04c304e40270,  0x7160371061f035f,  0x73902a501d90c01,  0x6b2042102aa0a56,  0x66b0979002c0313,  0x94b0ae30ae107cd,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x28b00ae04a00924,  0x27101230bae0717,  0xffff00c109eb0c0c,  0x9a200c3099c0642,  0x1600c5808480892,  0x32e041a05ae08c7,  0xffff02cd045e05dc,  0x52d04b807dc0adc,  0xffff03e806af0ae4,  0x925ffff074202f0,  0x718028c00af04a1,  0xc0d027201240baf,  0x643ffff00c209ec,  0x89309a300c4099d,  0x8c801610c590849,  0x5dd032f041b05af,  0xaddffff02ce045f,  0xae5052e04b907dd,  0x2f1ffff03e906b0,  0xffffffffffff0743,  0x16201aa04ca0517,  0x5c201fe08630c64,  0x480062004240706,  0x3320b030b43086b,  0xd109b00c6009b6,  0xd9092a07a1036e,  0x1110a1108f704a4,  0x83039707a70932,  0x36c0505056d021e,  0x4a2081a0b9c0b28,  0x58904aa08cb0a09,  0x1d60002075a025d,  0xffff06d00a930322,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x16301ab04cb0518,  0x5c301ff08640c65,  0x481062104250707,  0x3330b040b44086c,  0xd209b10c6109b7,  0xda092b07a2036f,  0x1120a1208f804a5,  0x84039807a80933,  0x36d0506056e021f,  0x4a3081b0b9d0b29,  0x58a04ab08cc0a0a,  0x1d70003075b025e,  0xffff06d10a940323,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xc68082001f505ce,  0x52f04d101da01c2,  0x8cf07a9039f00e9,  0x49c08d50a2600fe,  0x6f5090301780bdd,  0x670098002fe0378,  0x8d30b740b220395,  0x727040405a40492,  0xc69082101f605cf,  0x53004d201db01c3,  0x8d007aa03a000ea,  0x49d08d60a2700ff,  0x6f6090401790bde,  0x671098102ff0379,  0x8d40b750b230396,  0x728040505a50493,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x34a07990a4a008e,  0x4490652044d027b,  0x5b0074c09bc0072,  0xab80676037c0012,  0x1ae083604ef04b6,  0x20a0b5f075e0334,  0xbb4073a093d053b,  0x54d08320a950b09,  0x34b079a0a4b008f,  0x44a0653044e027c,  0x5b1074d09bd0073,  0xab90677037d0013,  0x1af083704f004b7,  0x20b0b60075f0335,  0xbb5073b093e053c,  0x54e08330a960b0a,  0x94c005e043106bb,  0x4720027097a0648,  0xc903a705ea,  0x5520587089f07ba,  0x7ce01b400060852,  0xb4f036a048604e9,  0x594018702930bc2,  0xa7e0c6e0a44071b,  0x43206bc0018043f,  0x97b0649094d005f,  0x3a805eb04730028,  0x8a007bb000100ca,  0x7085305530588,  0x48704ea07cf01b5,  0x2940bc30b50036b,  0xa45071c05950188,  0x1904400a7f0c6f,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff]);
//5568 bytes
enum alphaTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x20,  0xd0], [ 0x100,  0x2c0,  0x7a00], [ 0x605040303020100,  0xe0d0c0b0a090807,  0x11100f0303030303,  0x1414141414141312,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x1414141414141414,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3000200010000,  0x7000600050004,  0xb000a00090008,  0xf000e000d000c,  0x12001100010010,  0x15001400010013,  0x19001800170016,  0x1c0001001b001a,  0x1f001f001e001d,  0x1f001f001f0020,  0x1f001f001f001f,  0x1f002300220021,  0x1f001f00250024,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100260001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x29002800010027,  0x2d002c002b002a,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x2e000100010001,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x30002f0001001f,  0x33003200310001,  0x37003600350034,  0x3a000100390038,  0x3e003d003c003b,  0x4200410040003f,  0x46004500440043,  0x4a004900480047,  0x1f004d004c004b,  0x510050004f004e,  0x52000100010001,  0x1f001f00540053,  0x1f001f001f001f,  0x55001f001f001f,  0x1000100010001,  0x1f001f001f0056,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f005700010001,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x59005800010001,  0x5b005a001f001f,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x5c000100010001,  0x1000100010001,  0x1f001f005e005d,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x5f001f001f001f,  0x1f006100600001,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f0062,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x66006500640063,  0x1f001f001f001f,  0x67001f001f001f,  0x1f006a00690068,  0x6c001f001f006b,  0x1f001f006e006d,  0x1f006f001f001f,  0x1f001f0070001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1000100010001,  0x1007100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x72000100010001,  0x1000100010073,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1007400010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x75000100010001,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f007600010001,  0x1f001f001f001f,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x77000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x78000100010001,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x1f001f001f001f,  0x0,  0x7fffffe07fffffe,  0x420040000000000,  0xff7fffffff7fffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x501f0003ffc3,  0x0,  0xbcdf000000000020,  0xfffffffbffffd740,  0xffbfffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfffffffffffffc03,  0xffffffffffffffff,  0xfffeffffffffffff,  0xffffffff027fffff,  0xbfff0000000001ff,  0x787ffffff00b6,  0xffffffff07ff0000,  0xffffc000feffffff,  0xffffffffffffffff,  0x9c00e1fe1fefffff,  0xffffffffffff0000,  0xffffffffffffe000,  0x3ffffffffffff,  0x43007fffffffc00,  0x1ffffcffffff,  0xffff07ff01ffffff,  0xffffffff00007eff,  0xffff03f8fff003ff,  0xefffffffffffffff,  0xfffe000fffe1dfff,  0xe3c5fdfffff99fef,  0x1003000fb080599f,  0xc36dfdfffff987ee,  0x3f00005e021987,  0xe3edfdfffffbbfee,  0x1e00000f00011bbf,  0xe3edfdfffff99fee,  0x2000fb0c0199f,  0xc3ffc718d63dc7ec,  0x811dc7,  0xe3fffdfffffddfff,  0xf27601ddf,  0xe3effdfffffddfef,  0xe000f60601ddf,  0xe7fffffffffddfff,  0xfc00000f80f05ddf,  0x2ffbfffffc7fffee,  0xc0000ff5f807f,  0x7fffffffffffffe,  0x207f,  0x3bffffaffffff7d6,  0xf000205f,  0x1,  0xfffe1ffffffffeff,  0x1ffffffffeffff0f,  0x0,  0xf97fffffffffffff,  0xffffffffffff0000,  0xffffffff3c00ffff,  0xf7ffffffffff20bf,  0xffffffffffffffff,  0xffffffff3d7f3dff,  0x7f3dffffffff3dff,  0xffffffffff7fff3d,  0xffffffffff3dffff,  0x7ffffff,  0xffffffff0000ffff,  0x3f3fffffffffffff,  0xfffffffffffffffe,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff9fffffffffff,  0xffffffff07fffffe,  0x1ffc7ffffffffff,  0xfffff800fffff,  0xddfff000fffff,  0xffcfffffffffffff,  0x108001ff,  0xffffffff00000000,  0x1ffffffffffffff,  0xffff07ffffffffff,  0x3fffffffffffff,  0x1ff0fff7fffffff,  0x1f3fffffff0000,  0xffff0fffffffffff,  0x3ff,  0xffffffff0fffffff,  0x1ffffe7fffffff,  0x8000008000000000,  0x7001,  0xffefffffffffffff,  0x1fef,  0xfc00f3ffffffffff,  0x3ffbfffffffff,  0x7fffffffffffff,  0x3ffffffffc00e000,  0xe7ffffffffff01ff,  0x46fde0000000000,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1fff8000000000,  0xffffffff3f3fffff,  0x3fffffffaaff3f3f,  0x5fdfffffffffffff,  0x1fdc1fff0fcf1fdc,  0x0,  0x8002000000000000,  0x1fff0000,  0x0,  0xf3ffbd503e2ffc84,  0xffffffff000043e0,  0x1ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffc0000000000000,  0x3ffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xc781fffffffff,  0xffff20bfffffffff,  0x80ffffffffff,  0x7f7f7f7f007fffff,  0xffffffff7f7f7f7f,  0x800000000000,  0x0,  0x0,  0x0,  0x1f3e03fe000000e0,  0xfffffffffffffffe,  0xfffffffee07fffff,  0xf7ffffffffffffff,  0xfffeffffffffffe0,  0xffffffffffffffff,  0xffffffff00007fff,  0xffff000000000000,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0x1fff,  0x3fffffffffff0000,  0xc00ffff1fff,  0x8ff07fffffffffff,  0xffffffffffffffff,  0xffffffffffff,  0xfffffffcff800000,  0xffffffffffffffff,  0xfffffffffffff9ff,  0xfffc000003eb07ff,  0xffffffffbf,  0xfffffffffffff,  0xffffffffffffffff,  0xe8fc00000000002f,  0xffff07fffffffc00,  0x1fffffff0007ffff,  0xfff7ffffffffffff,  0x7c00ffff00008000,  0x7fffffffffffff,  0xfc7fffff00003fff,  0x7fffffffffffffff,  0x3cffff38000005,  0xffff7f7f007e7e7e,  0xffff03fff7ffffff,  0xffffffffffffffff,  0x7ffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff000fffffffff,  0xffffffffffff87f,  0xffffffffffffffff,  0xffff3fffffffffff,  0xffffffffffffffff,  0x3ffffff,  0x5f7ffdffe0f8007f,  0xffffffffffffffdb,  0x3ffffffffffff,  0xfffffffffff80000,  0x3fffffffffffffff,  0xffffffffffff0000,  0xfffffffffffcffff,  0xfff0000000000ff,  0x0,  0xffdf000000000000,  0xffffffffffffffff,  0x1fffffffffffffff,  0x7fffffe00000000,  0xffffffc007fffffe,  0x7fffffffffffffff,  0x1cfcfcfc,  0xb7ffff7fffffefff,  0x3fff3fff,  0xffffffffffffffff,  0x7ffffffffffffff,  0x0,  0x1fffffffffffff,  0x0,  0x0,  0x0,  0x0,  0xffffffff1fffffff,  0x1ffff,  0xffffe000ffffffff,  0x7ffffffffff07ff,  0xffffffff3fffffff,  0x3eff0f,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff00003fffffff,  0xfffffffff0fffff,  0xffff00ffffffffff,  0xf7ff000fffffffff,  0x1bfbfffbffb7f7ff,  0x0,  0x7fffffffffffff,  0xff003fffff,  0x7fdffffffffffbf,  0x0,  0x91bffffffffffd3f,  0x7fffff003fffff,  0x7fffffff,  0x37ffff00000000,  0x3ffffff003fffff,  0x0,  0xc0ffffffffffffff,  0x0,  0x3ffffffeeff06f,  0x1fffffff00000000,  0x1fffffff,  0x1ffffffeff,  0x3fffffffffffff,  0x7ffff003fffff,  0x3ffff,  0x0,  0xffffffffffffffff,  0x1ff,  0x7ffffffffffff,  0x7ffffffffffff,  0xffffffffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x31bffffffffff,  0x0,  0xffff00801fffffff,  0xffff00000000003f,  0xffff000000000003,  0x7fffff0000001f,  0xffffffffffffffff,  0x3e00000000003f,  0x1ffffffffffffff,  0x1ffffff0004,  0x7ffffffffffff,  0x47ffffffff00f0,  0xffffffffffffffff,  0x1400c01e,  0xc09ffffffffbffff,  0x3,  0xffff01ffbfffbd7f,  0x1ffffffffff,  0xe3edfdfffff99fef,  0xfe081199f,  0x0,  0x0,  0xffffffffffffffff,  0x3800007bb,  0xffffffffffffffff,  0xb3,  0x0,  0x0,  0x7f3fffffffffffff,  0x3f000000,  0x7fffffffffffffff,  0x11,  0x13fffffffffffff,  0x0,  0x7ffe7ffffff,  0x7f,  0x0,  0x0,  0x1ffffffffffffff,  0x0,  0xffffffff00000000,  0x80000000ffffffff,  0x99bfffffff6ff27f,  0x7,  0xfffffcff00000000,  0x1afcffffff,  0x7fe7ffffffffffff,  0xffffffffffff0000,  0xffff000020ffffff,  0x1ffffffffffffff,  0x7f7ffffffffffdff,  0xfffc000000000001,  0x7ffefffffcffff,  0x0,  0xb47ffffffffffb7f,  0xfffffdbf000000cb,  0x17b7fff,  0x0,  0x0,  0x0,  0x0,  0x7fffff00000000,  0xc7fffffffffdffff,  0x1,  0x1000000000000,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0x3ffffff,  0x0,  0xffffffffffffffff,  0x7fffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xf,  0x0,  0x0,  0x0,  0x0,  0xffffffffffff0000,  0x1ffffffffffff,  0xffffffffffff,  0x7e,  0x0,  0x0,  0xffffffffffffffff,  0x7f,  0x0,  0x0,  0x1ffffffffffffff,  0xffff00007fffffff,  0x7fffffffffffffff,  0x3fffffff0000,  0xffffffffffff,  0xe0fffff80000000f,  0xffff,  0x0,  0x0,  0xffffffffffffffff,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffff87ff,  0xffff80ff,  0x3000b00000000,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3fffff,  0x1ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x6fef000000000000,  0x40007ffffffff,  0xffff00f000270000,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfffffffffffffff,  0xffffffffffffffff,  0x1fff07ffffffffff,  0x43ff01ff,  0x0,  0xffffffffffffffff,  0xffffffffffdfffff,  0xebffde64dfffffff,  0xffffffffffffffef,  0x7bffffffdfdfe7bf,  0xfffffffffffdfc5f,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffff3fffffffff,  0xf7fffffff7fffffd,  0xffdfffffffdfffff,  0xffff7fffffff7fff,  0xfffffdfffffffdff,  0xff7,  0x7e07fffffff,  0x0,  0x0,  0x0,  0xffff07dbf9ffff7f,  0x3fffffffffff,  0x8000,  0x0,  0x3f801fffffffffff,  0x4000,  0x0,  0x0,  0x0,  0x0,  0x3fffffff0000,  0xfffffffffff,  0x0,  0x0,  0x0,  0xfffffff0000,  0x0,  0x0,  0x0,  0x7fff6f7f00000000,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1f,  0xffffffffffffffff,  0x88f,  0x0,  0x0,  0xaf7fe96ffffffef,  0x5ef7f796aa96ea84,  0xffffbee0ffffbff,  0x0,  0xffff000000000000,  0xffff03ffffff03ff,  0x3ff,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff,  0x3ffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff3fffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0003ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1ffffffff,  0x3fffffff,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffff07ff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffff,  0x0,  0x0,  0x0,  0x0,  0x0]);
//3392 bytes
enum markTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x20,  0x88], [ 0x100,  0x1a0,  0x4800], [ 0x402030202020100,  0xa09080207020605,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x20202020202020b,  0x202020202020202,  0x202020202020202,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1000000000000,  0x5000400030002,  0x9000800070006,  0xd000c000b000a,  0xf00000000000e,  0x10000000000000,  0x14001300120011,  0x160015,  0x17,  0x0,  0x0,  0x190018,  0x1a,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1b00000000,  0x1f001e001d001c,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x20000000000000,  0x2100000000,  0x24002300220000,  0x0,  0x2500000000,  0x28002700260000,  0x2c002b002a0029,  0x30002f002e002d,  0x3300320031,  0x37003600350034,  0x0,  0x0,  0x0,  0x0,  0x0,  0x38,  0x0,  0x0,  0x0,  0x0,  0x3a003900000000,  0x3b000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3c,  0x0,  0x0,  0x0,  0x3d000000000000,  0x3f003e0000,  0x0,  0x4000000000,  0x0,  0x42003a0041,  0x43,  0x450044,  0x0,  0x0,  0x0,  0x0,  0x0,  0x460000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffff,  0x0,  0x0,  0x0,  0x0,  0x3f8,  0x0,  0x0,  0x0,  0xbffffffffffe0000,  0xb6,  0x7ff0000,  0x10000fffff800,  0x0,  0x3d9f9fc00000,  0xffff000000020000,  0x7ff,  0x1ffc000000000,  0x200ff80000000000,  0x3eeffbc00000,  0xe000000,  0xff000000,  0xfffffffbfffffc00,  0xdc0000000000000f,  0xc00feffff,  0xd00000000000000e,  0x4000000c0080399f,  0xd00000000000000e,  0x23000000023987,  0xd00000000000000e,  0xfc00000c00003bbf,  0xd00000000000000e,  0xc00e0399f,  0xc000000000000004,  0x803dc7,  0xd00000000000001f,  0xc00603ddf,  0xd00000000000000e,  0x8000c00603ddf,  0xd80000000000000f,  0xc00803ddf,  0xe,  0xc0000ff5f8400,  0x7f2000000000000,  0x7f80,  0x1ff2000000000000,  0x7f00,  0xc2a0000003000000,  0xfffe000000000000,  0x1ffffffffeffe0df,  0x40,  0x7ffff80000000000,  0x1e3f9dc3c00000,  0x3c00bffc,  0x0,  0x0,  0xe0000000,  0x0,  0x0,  0x1c0000003c0000,  0xc0000000c0000,  0xfff0000000000000,  0x200fffff,  0xb800,  0x0,  0x20000000060,  0x0,  0xfff0fff00000000,  0x0,  0x0,  0x0,  0xf800000,  0x9fffffff7fe00000,  0xffff000000000000,  0x7fff,  0xfff000000000001f,  0xff8000000001f,  0x3ffe00000007,  0xfffc000000000,  0xfffff000000000,  0x0,  0x0,  0x39021fffff70000,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0x0,  0x0,  0x0,  0x1ffffffff0000,  0x0,  0x0,  0x0,  0x3800000000000,  0x0,  0x8000000000000000,  0x0,  0xffffffff00000000,  0xfc0000000000,  0x0,  0x6000000,  0x0,  0x0,  0x3ff7800000000000,  0xc0000000,  0x3000000000000,  0x10f800000844,  0x0,  0xfff0000000000003,  0x8003ffff0000003f,  0x3fc000000000,  0xfff80,  0xfff800000000000f,  0x2000000001,  0x7ffe0000000000,  0x3800000000003008,  0xc19d000000000000,  0x60f80000000002,  0x0,  0x0,  0x0,  0x37f800000000,  0x40000000,  0x0,  0x0,  0x0,  0xffff0000ffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2000000000000000,  0x0,  0x0,  0x0,  0x100000000,  0x0,  0x7c0000000000000,  0x0,  0x0,  0x870000000000f06e,  0x0,  0x0,  0x6000000000,  0xf000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x180000000000,  0xe000000000000000,  0x0,  0x1ffc0,  0x3c,  0x0,  0xff00000000000007,  0x801900000000007f,  0x7ff000000000007,  0x4,  0x1fff8000000007,  0x8000000000060,  0xfff8000000000007,  0xde01,  0x40fff00000000000,  0x2,  0x0,  0x7ff80000000,  0xd80000000000000f,  0x1f1fcc0080399f,  0x0,  0x0,  0xffe0000000000000,  0x4000007f,  0xffff000000000000,  0xf,  0x0,  0x0,  0xff3f800000000000,  0x30000001,  0xffff000000000000,  0x1,  0xfff80000000000,  0x0,  0xfffe0000000,  0x0,  0x0,  0x0,  0x7fff00000000000,  0x0,  0x0,  0x0,  0x79bf000000000000,  0xd,  0x0,  0x11fcfe0000,  0x7bf80000000007fe,  0xffe0080,  0x3fffc00,  0x0,  0xff7f800000000000,  0x0,  0x7ffefffffc0000,  0x0,  0xb47e000000000000,  0xbf,  0xfb7c00,  0x0,  0x0,  0x0,  0x0,  0x78000000000000,  0xc7f000000000000b,  0x7,  0x0,  0x0,  0x0,  0x3fff81,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1f000000000000,  0x7f000000000000,  0x0,  0x0,  0x0,  0x0,  0xfffffffffffe8000,  0x780ff,  0x3001000000000,  0x0,  0x0,  0x60000000,  0x0,  0xffff3fffffffffff,  0x7f,  0x0,  0x0,  0x0,  0xf807e3e000000000,  0x3c0000000fe7,  0x0,  0x0,  0x1c,  0x0,  0x0,  0xf87fffffffffffff,  0x201fffffffffff,  0xfffef8000010,  0x0,  0x7dbf9ffff7f,  0x0,  0x8000,  0x0,  0x0,  0x0,  0x400000000000,  0xf00000000000,  0x0,  0x0,  0x0,  0xf00000000000,  0x0,  0x0,  0x0,  0x7f0000,  0x0,  0x7f0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffff,  0x0,  0x0,  0x0,  0x0]);
//2848 bytes
enum numberTrieEntries = TrieEntry!(bool, 8, 6, 7)([ 0x0,  0x20,  0xd0], [ 0x100,  0x2c0,  0x2500], [ 0x402030202020100,  0x908020207020605,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2000200010000,  0x2000200020002,  0x2000200020002,  0x5000200040003,  0x7000600020002,  0x9000800060006,  0x6000b0006000a,  0x2000d000c000c,  0x20002000e0005,  0x2000f00020002,  0x2000200020002,  0x11000200100002,  0x1300120002000e,  0xc00140002,  0x2000200020015,  0x2000200020002,  0x19001800170016,  0x2000200020002,  0x20002001b001a,  0x1d001c00020002,  0x2000200020002,  0x2000200020002,  0x20002001e0002,  0x2000200020002,  0x2000020002001f,  0x2000200220021,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200060023,  0x250017000c0024,  0x400020002000c,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000e00020002,  0x27002600020002,  0x2a002900280002,  0x2000200230002,  0x2000200020002,  0x2e002d002c002b,  0x3200310030002f,  0x2000000330002,  0x36003500020034,  0x39003800040037,  0x2000200040002,  0x20002000c000c,  0x2003a0005000c,  0x2000c003b0002,  0x2000200020002,  0x23000c0002003c,  0x3d000c00020002,  0x2000200020002,  0x2000200020002,  0x200020002003e,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2003f00050003,  0x2000200020002,  0x2000200400002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2004200410002,  0x2000200020002,  0x43000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000500020002,  0x2000200040002,  0x2000200040002,  0x2000200020002,  0x2000c00440002,  0x2000200020002,  0x2004700460045,  0x2000200020002,  0x2004800020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x4000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x2000200020002,  0x3ff000000000000,  0x0,  0x720c000000000000,  0x0,  0x0,  0x0,  0x0,  0x3ff00000000,  0x0,  0x3ff000000000000,  0x0,  0x3ff,  0x0,  0xffc000000000,  0x0,  0x3f0ffc000000000,  0x0,  0xfcffc000000000,  0x0,  0x7ffc000000000,  0x0,  0x7f00ffc000000000,  0x0,  0x1ffffc07f000000,  0x0,  0x3ff0000,  0xfffff00000000,  0x0,  0x3ff0000,  0x0,  0x0,  0x1ffffe0000000000,  0x0,  0x1c00000000000,  0x0,  0x3ff03ff00000000,  0x0,  0xffc0,  0x0,  0x7ff0000,  0x3ff03ff,  0x0,  0x0,  0x3ff03ff,  0x0,  0x3f1000000000000,  0x3ff,  0x0,  0x0,  0xffffffffffff0000,  0x3e7,  0x0,  0x0,  0xffffffff00000000,  0xfffffff,  0xfffffc0000000000,  0x0,  0xffc0000000000000,  0xfffff,  0x0,  0x0,  0x2000000000000000,  0x70003fe00000080,  0x0,  0x3c0000,  0x0,  0x3ff00000000,  0xfffeff00,  0xfffe0000000003ff,  0x0,  0x3ff00000000,  0x0,  0x3f000000000000,  0x0,  0x0,  0x3ff000003ff0000,  0xfffffffffff80,  0x1ffffffffffffff,  0xc00,  0x0,  0x0,  0xffffffe00000000,  0xf00000000,  0x402,  0x0,  0x3e0000,  0x0,  0xfe000000ff000000,  0xff8000000000,  0xf800000000000000,  0xfc00000,  0x0,  0x3000000000000000,  0xfffffffffffcffff,  0x0,  0x60000000000001ff,  0xe0000000,  0xf80000000000,  0x0,  0xff000000ff000000,  0xfe0000000000,  0x0,  0x0,  0xfc00000000000000,  0x0,  0x7fffffff00000000,  0x7fe0000000,  0x1e0000,  0x0,  0xfe0,  0x0,  0xfffffffc0000,  0xffc0000000000000,  0x0,  0x0,  0x1ffffe03ff0000,  0xfff000000000000,  0x0,  0x0,  0x7ffff00000000,  0x0,  0x1fffffff0000,  0x0,  0x1fffff,  0xffffffffffffffff,  0x7fffffffffff,  0x0,  0x3fbff0000,  0x7fffff,  0x0,  0x0,  0xfffff000fffff,  0x0,  0x1ffffff00000000,  0x0,  0xffffffffffffc000,  0x0,  0xff80,  0x0,  0xfffe000000000000,  0x1eefffffffffff,  0x0,  0x3fffbffffffffffe,  0x0,  0x1fff,  0x0,  0x0,  0x3ff000000000000]);
//3360 bytes
enum punctuationTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x20,  0x80], [ 0x100,  0x180,  0x4900], [ 0x402030202020100,  0xa09080207020605,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2000100010000,  0x5000400030001,  0x1000800070006,  0xc000b000a0009,  0xe00010001000d,  0x1100100001000f,  0x15001400130012,  0x1000100010016,  0x18000100010017,  0x19000100010001,  0x10001001a0001,  0x1001d001c001b,  0x100010001001e,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x100200001001f,  0x24002300220021,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x27002600250001,  0x29000100280001,  0x10001002a0001,  0x2e002d002c002b,  0x30002f00010001,  0x1003300320031,  0x37003600350034,  0x3b003a00390038,  0x3e003d0001003c,  0x1000100010001,  0x100010001003f,  0x1000100010001,  0x40000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x42004100010001,  0x44004300010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010045,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1004600010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100470001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x8c00f7ee00000000,  0x28000000b8000001,  0x88c0088200000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x4000000000000000,  0x80,  0x0,  0x0,  0xfc000000,  0x4000000000000600,  0x18000000000049,  0xe8003600,  0x3c0000000000,  0x0,  0x100000,  0x3fff,  0x0,  0x0,  0x380000000000000,  0x7fff000000000000,  0x40000000,  0x0,  0x0,  0x0,  0x1003000000000,  0x0,  0x2000000000000000,  0x0,  0x40000000000000,  0x0,  0x1000000000000,  0x0,  0x80000000000000,  0x10,  0x0,  0x0,  0x0,  0x0,  0x10000000000000,  0x0,  0xc008000,  0x0,  0x0,  0x3c0000000017fff0,  0x0,  0x20,  0x61f0000,  0x0,  0xfc00,  0x0,  0x800000000000000,  0x0,  0x1ff00000000,  0x0,  0x0,  0x1,  0x0,  0x0,  0x0,  0x0,  0x400000000000,  0x18000000,  0x380000000000,  0x60000000000000,  0x0,  0x0,  0x7700000,  0x7ff,  0x0,  0x0,  0x0,  0x0,  0x30,  0x0,  0x0,  0xc0000000,  0x0,  0x3f7f00000000,  0x0,  0x0,  0x60000001fc000000,  0x0,  0xf000000000000000,  0xf800000000000000,  0xc000000000000000,  0x0,  0x800ff,  0xffff00ffffff0000,  0x600000007ffbffef,  0x6000,  0x0,  0x60000000f00,  0x0,  0x0,  0x0,  0x0,  0x3fff0000000000,  0x0,  0xffc000000060,  0x0,  0x0,  0x1fffff8,  0x300000000f000000,  0x0,  0x0,  0x0,  0xde00000000000000,  0x0,  0x1000000000000,  0x0,  0x0,  0xffff7fffffffffff,  0x3ffcffff,  0x0,  0x0,  0x20010000fff3ff0e,  0x0,  0x100000000,  0x800000000000000,  0x0,  0x0,  0x0,  0xc000000000000000,  0xe000,  0x4008000000000000,  0x0,  0xfc000000000000,  0x0,  0xf0000000000000,  0x0,  0x170000000000c000,  0xc00000000000,  0x80000000,  0x0,  0xc0003ffe,  0x0,  0xf0000000,  0x0,  0x30000c0000000,  0x0,  0x0,  0x0,  0x80000000000,  0xc000000000000000,  0x0,  0x0,  0x0,  0xffff000003ff0000,  0xd0bfff7ffff,  0x0,  0x0,  0xb80000018c00f7ee,  0x3fa8000000,  0x0,  0x0,  0x7,  0x0,  0x0,  0x0,  0x0,  0x0,  0x80000000,  0x10000,  0x0,  0x800000000000,  0x0,  0x0,  0x0,  0x800000,  0x0,  0x0,  0x8000000080000000,  0x0,  0x0,  0x0,  0x0,  0x8000000001ff0000,  0x0,  0x7f000000000000,  0xfe00000000000000,  0x0,  0x1e000000,  0x0,  0x0,  0x0,  0x200000000000,  0x0,  0x0,  0x3e00000,  0x3c0,  0x0,  0x0,  0x3f80,  0xd800000000000000,  0x3,  0x0,  0x3000000000000f,  0x0,  0xe80021e0,  0x3f00000000000000,  0x0,  0x20000000000,  0x0,  0x0,  0x2c00f800,  0x0,  0x40,  0x0,  0x0,  0x0,  0xfffffe,  0x0,  0x1fff0000000e,  0x200000000000000,  0x0,  0x7000000000000000,  0x0,  0x0,  0x0,  0x800000000000000,  0x0,  0x0,  0x0,  0x0,  0x70,  0x0,  0x400000000,  0x8000000000000000,  0x7f,  0x7dc000000,  0x0,  0x3ff,  0x0,  0x0,  0x0,  0x0,  0x300000000003e,  0x0,  0x0,  0x0,  0x0,  0x0,  0x180000000000000,  0x0,  0xfff8,  0x0,  0x8000000000000000,  0x0,  0x1f000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x6000000000000,  0x0,  0xc00000000000,  0x0,  0x20000000000000,  0xf80000000000000,  0x10,  0x0,  0x0,  0x0,  0x0,  0x7800000,  0x0,  0x0,  0x0,  0x0,  0x400000000,  0x0,  0x0,  0x80000000,  0x0,  0x0,  0x0,  0xf80,  0x0,  0x0,  0xc0000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0]);
//3424 bytes
enum symbolTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x20,  0x80], [ 0x100,  0x180,  0x4b00], [ 0x503040303020100,  0xa09080307030306,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x303030303030303,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3000200010000,  0x7000600050004,  0xb000a00090008,  0xf000e000d000c,  0x11000100010010,  0x13001200010001,  0x15000100140001,  0x16000100010001,  0x1a001900180017,  0x1c00190019001b,  0x1e0019001d0019,  0x2100200001001f,  0x19002400230022,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100250001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x27000100010026,  0x2a002900010028,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x2b000100010001,  0x2e002d002c0001,  0x10001002f0001,  0x1000100010001,  0x1003100010030,  0x1000100010001,  0x1000100010001,  0xe000100010001,  0x1000100010001,  0x32000100010001,  0x1000100010001,  0x1000100010001,  0x33000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010034,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x35000100010001,  0x39003800370036,  0x3b003a00010001,  0x1003c00190019,  0x1000100010001,  0x1003e003d0001,  0x1000100010001,  0x1000100010001,  0x100410040003f,  0x19004400430042,  0x46004500190019,  0x49004800190047,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x7000081000000000,  0x5000000140000000,  0x113d37c00000000,  0x80000000800000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffafe0fffc003c,  0x0,  0x20000000000000,  0x30,  0x40000000000000,  0x0,  0x0,  0x4,  0x0,  0x0,  0x0,  0xe000,  0x0,  0xc9c0,  0x0,  0x0,  0x6000020040000000,  0x0,  0x0,  0x0,  0xc040000000000000,  0x0,  0x0,  0x100,  0x0,  0x0,  0x0,  0x0,  0xc0c000000000000,  0x0,  0x0,  0x0,  0x2000000000000,  0x0,  0x1000000000000,  0x0,  0x7f8000000000000,  0x0,  0x8000000000000000,  0x0,  0x0,  0x0,  0x200000000008000,  0x0,  0x0,  0x8000000000000000,  0x0,  0x0,  0x0,  0x1500000fce8000e,  0x0,  0xc000000000000000,  0x1e0dfbf,  0x0,  0x0,  0xc0000000,  0x0,  0x0,  0x0,  0x3ff0000,  0x0,  0x0,  0x200000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8000000,  0x0,  0x1,  0x0,  0xffffffffc0000000,  0x0,  0x1ff007fe00000000,  0x0,  0x0,  0x0,  0x0,  0xa000000000000000,  0x6000e000e000e003,  0x0,  0x1c00000000040010,  0xffffffff00001c00,  0x1,  0xc0042afc1d0037b,  0xbc1f,  0xffffffffffff0c00,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfffff9fffffff0ff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x7fffffffff,  0x7ff,  0xfffffffff0000000,  0x3ffffffffff,  0xffffffffffffffff,  0xffffffffff,  0xfffffffffff00000,  0xffff003fffffff9f,  0xffffffffffffffff,  0xffffffffffffffff,  0xfffffffffe000007,  0xcffffffff0ffffff,  0xffffffffffffffff,  0xffcfffffffffffff,  0xffffffffffbfffff,  0xffffffffffffffff,  0x0,  0x0,  0x0,  0x7e000000000,  0x0,  0x30000,  0xfffffffffbffffff,  0xfffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfff0000003fffff,  0xc0c00001000c0010,  0x0,  0x18000000,  0x0,  0x0,  0x0,  0xffc30000,  0xfffffffff,  0xfffffc007fffffff,  0xffffffff000100ff,  0x1fffffffffc00,  0xffffffffffffffff,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0x0,  0x0,  0xffffffffffff0000,  0x7f,  0x3007fffff,  0x0,  0x600,  0x0,  0x3c00f0000000000,  0x0,  0x0,  0x0,  0x0,  0x380000000000000,  0x0,  0x0,  0x0,  0xc0008000000,  0x0,  0x0,  0x20000000000,  0x0,  0xfffc000000000000,  0x7,  0x0,  0xffff,  0x0,  0xf000000000008000,  0x0,  0x27400000000,  0x0,  0x0,  0x4000000070000810,  0x50000001,  0x0,  0x30007f7f00000000,  0xff80000000000000,  0xfe00000000000000,  0x11fff73ff,  0x1fffffffffff0000,  0x0,  0x180000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x100,  0x0,  0x0,  0x0,  0x3ffffffe00000,  0xf000000000000000,  0x20,  0x0,  0x0,  0x0,  0x0,  0x10000000,  0x0,  0x0,  0xffffffffffff0000,  0xffffffffffffffff,  0xf,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3fffffffffffff,  0xfffffe7fffffffff,  0x1c1fffffffff,  0xffffc3fffffff018,  0x7ffffffffff,  0xffffffffffffffff,  0x23,  0x0,  0x0,  0xffffffffffffffff,  0x7fffff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x800000008000002,  0x20000000200000,  0x800000008000,  0x20000000200,  0x8,  0x780000000000000,  0xffdfe00000000000,  0x6f,  0x0,  0x0,  0x8000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8000000000000000,  0x0,  0x0,  0x1100000000000,  0x0,  0x400000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3000000000000,  0xffff0fffffffffff,  0xffffffffffffffff,  0xfffe7fff000fffff,  0x3ffffffffefffe,  0xffffffffffffe000,  0xffffffffffffffff,  0x3fffffffffff,  0xffffffc000000000,  0xfffffffffff0007,  0x3f000301ff,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1fff1ffff0ffffff,  0xffffffffffffffff,  0xf87fffffffffffff,  0xffffffffffffffff,  0x10fff03ffffff,  0xffffffffffff0fff,  0xffffffff03ff00ff,  0x33fffffff00ff,  0x0,  0xffffffffffffffff,  0x1fff3fff000fffff,  0xbfffffffffff01ff,  0x1ff01ff0fffc03f,  0xffffffffffffffff,  0xffffffffffffffff,  0xfffffffffff7ffff,  0x7ff,  0x0,  0x0,  0x0,  0x0]);
//6048 bytes
enum graphicalTrieEntries = TrieEntry!(bool, 8, 5, 8)([ 0x0,  0x20,  0xd0], [ 0x100,  0x2c0,  0x8900], [ 0x504030202020100,  0xd0c0b0a09080706,  0x100f0e0202020202,  0x1313131313131211,  0x1313131313131313,  0x1313131313131313,  0x1313131313131313,  0x1313131313131313,  0x1313131313131313,  0x1313131313131313,  0x1313131313131313,  0x1313131313131313,  0x1313131313131313,  0x1313131313131313,  0x1313131313131314,  0x1313131313131313,  0x1313131313131313,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2000100010000,  0x5000400030001,  0x9000800070006,  0xd000c000b000a,  0x10000f0001000e,  0x12001100010001,  0x16001500140013,  0x18000100010017,  0x10001001a0019,  0x100010001001b,  0x1c000100010001,  0x20001f001e001d,  0x1002300220021,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x26002500010024,  0x2a002900280027,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x2b000100010001,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2e002d0001002c,  0x310030002f0001,  0x35003400330032,  0x38000100370036,  0x3c003b003a0039,  0x40003f003e003d,  0x44004300420041,  0x48004700460045,  0x4c004b004a0049,  0x50004f004e004d,  0x51000100010001,  0x2c002c00530052,  0x2c002c002c002c,  0x54002c002c002c,  0x1000100010001,  0x2c002c002c0055,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c005600010001,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x58005700010001,  0x5a0059002c002c,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x5b000100010001,  0x1000100010001,  0x2c002c005d005c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x5e002c002c002c,  0x2c0060005f0001,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c0061,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x62002c002c002c,  0x66006500640063,  0x6a006900680067,  0x2c006b00010001,  0x6c002c002c002c,  0x2c006f006e006d,  0x71002c002c0070,  0x2c002c00730072,  0x2c007600750074,  0x1007900780077,  0x7b007a00010001,  0x7e007d0001007c,  0x2c002c002c002c,  0x1000100010001,  0x1007f00010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x80000100010001,  0x1000100010081,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1008200010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x83000100010001,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c008400010001,  0x2c002c002c002c,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x85000100010001,  0x1000100010001,  0x1000100010001,  0x1000100010001,  0x86000100010001,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c0087002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0x2c002c002c002c,  0xffffffff00000000,  0x7fffffffffffffff,  0xffffdfff00000000,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfcffffffffffffff,  0xfffffffbffffd7f0,  0xffffffffffffffff,  0xfffeffffffffffff,  0xfffffffffe7fffff,  0xfffffffffffee7ff,  0x1f87ffffff00ff,  0xffffffffefffffc0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffdfffffff,  0xffffffffffff3fff,  0xffffffffffffe7ff,  0x3ffffffffffff,  0xe7ffffffffffffff,  0x7fff3fffffffffff,  0xffff07ff4fffffff,  0xffffffffff007fff,  0xfffffffbffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xf3c5fdfffff99fef,  0x7fffffcfb080799f,  0xd36dfdfffff987ee,  0x7fffc05e023987,  0xf3edfdfffffbbfee,  0xfe03ffcf00013bbf,  0xf3edfdfffff99fee,  0xffffcfb0e0399f,  0xc3ffc718d63dc7ec,  0x7ffffc000813dc7,  0xf3fffdfffffddfff,  0xff80ffcf27603ddf,  0xf3effdfffffddfff,  0xeffcf60603ddf,  0xfffffffffffddfff,  0xffffffcffff0fddf,  0x2ffbfffffc7fffee,  0x1cffc0ff5f847f,  0x87fffffffffffffe,  0xfffffff,  0x3fffffaffffff7d6,  0xf3ff7f5f,  0xffffffffffffffff,  0xfffe1ffffffffeff,  0xdffffffffeffffff,  0x7ffdfff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffff20bf,  0xffffffffffffffff,  0xffffffff3d7f3dff,  0x7f3dffffffff3dff,  0xffffffffff7fff3d,  0xffffffffff3dffff,  0x1fffffffe7ffffff,  0xffffffff03ffffff,  0x3f3fffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff1fffffff,  0x1ffffffffffffff,  0x7fffff803fffff,  0xddfff000fffff,  0xffffffffffffffff,  0x3ff03ff3fffffff,  0xffffffff03ffbfff,  0x1ffffffffffffff,  0xffff07ffffffffff,  0x3fffffffffffff,  0xfff0fff7fffffff,  0x1f3ffffffffff1,  0xffff0fffffffffff,  0xffffffffc7ff03ff,  0xffffffffcfffffff,  0x9fffffff7fffffff,  0xffff3fff03ff03ff,  0x7fff,  0xffffffffffffffff,  0x7fffffffffff1fff,  0xffffffffffffffff,  0xf00fffffffffffff,  0xf8ffffffffffffff,  0xffffffffffffe3ff,  0xe7ffffffffff01ff,  0x7ffffffffff00ff,  0xffffffff3f3fffff,  0x3fffffffaaff3f3f,  0xffdfffffffffffff,  0x7fdcffffefcfffdf,  0xffff80ffffff07ff,  0xfff30000ffffffff,  0xffffffff1fff7fff,  0x1ffffffff0001,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffff0fff,  0xffffffffffffffff,  0x7fffffffff,  0xffffffff000007ff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffcfffffffffffff,  0xffffffffffbfffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfe0fffffffffffff,  0xffff20bfffffffff,  0x800180ffffffffff,  0x7f7f7f7f007fffff,  0xffffffff7f7f7f7f,  0xffffffffffffffff,  0x3fffffff,  0xfffffffffbffffff,  0xfffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfff0000003fffff,  0xffffffffffffffff,  0xfffffffffffffffe,  0xfffffffffe7fffff,  0xffffffffffffffff,  0xfffeffffffffffe0,  0xffffffffffffffff,  0xffffffffffff7fff,  0xffff000fffffffff,  0xffffffff7fffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffff1fff,  0xffffffffffff007f,  0xfffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfffc000003eb07ff,  0x3ff1fffffffffff,  0xffffffffffffff,  0xffffffffffffffff,  0xffffffff03ffc03f,  0xffffffffffffffff,  0x1fffffff800fffff,  0xffffffffffffffff,  0x7fffffffc3ffbfff,  0x7fffffffffffff,  0xfffffffff3ff3fff,  0xffffffffffffffff,  0x7ffffff8000007,  0xffff7f7f007e7e7e,  0xffff0fffffffffff,  0xffffffffffffffff,  0x3ff3fffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff000fffffffff,  0xffffffffffff87f,  0x0,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffff3fffffffffff,  0xffffffffffffffff,  0x3ffffff,  0x5f7fffffe0f8007f,  0xffffffffffffffdb,  0xffffffffffffffff,  0xfffffffffff80007,  0xffffffffffffffff,  0xffffffffffffffff,  0xfffffffffffcffff,  0xffff0000000080ff,  0xffffffff03ffffff,  0xffdf0f7ffff7ffff,  0xffffffffffffffff,  0x1fffffffffffffff,  0xfffffffffffffffe,  0xffffffffffffffff,  0x7fffffffffffffff,  0x30007f7f1cfcfcfc,  0xb7ffff7fffffefff,  0x3fff3fff,  0xffffffffffffffff,  0x7ffffffffffffff,  0xff8fffffffffff87,  0xffffffffffffffff,  0x11fff7fff,  0x3fffffffffff0000,  0x0,  0x0,  0xffffffff1fffffff,  0xfffffff0001ffff,  0xffffe00fffffffff,  0x7ffffffffff07ff,  0xffffffffbfffffff,  0x3fff0f,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff03ff3fffffff,  0xfffffffff0fffff,  0xffff00ffffffffff,  0xf7ff800fffffffff,  0x1bfbfffbffb7f7ff,  0x0,  0x7fffffffffffff,  0xff003fffff,  0x7fdffffffffffbf,  0x0,  0x91bffffffffffd3f,  0xffffffffffbfffff,  0xff807fffffff,  0xf837ffff00000000,  0x83ffffff8fffffff,  0x0,  0xf0ffffffffffffff,  0xfffffffffffcffff,  0x873ffffffeeff06f,  0xffffffff01ff01ff,  0xffffffff,  0x7ff87fffffffff,  0xfe3fffffffffffff,  0xff07ffffff3fffff,  0xfe001e03ffff,  0x0,  0xffffffffffffffff,  0x1ff,  0x7ffffffffffff,  0xfc07ffffffffffff,  0x3ff00ffffffffff,  0x0,  0x0,  0x0,  0x0,  0x7fffffff00000000,  0x33bffffffffff,  0xe000000000000000,  0xffff00ffffffffff,  0xffff000003ffffff,  0xffff0000000003ff,  0x7fffff00000fff,  0xffffffffffffffff,  0x803ffffffffc3fff,  0xdfffffffffffffff,  0x3ff01ffffff0007,  0xffdfffffffffffff,  0x7fffffffff00ff,  0xffffffffffffffff,  0x1ffffeffffffff,  0xfffffffffffbffff,  0x3,  0xffff03ffbfffbd7f,  0x3ff07ffffffffff,  0xfbedfdfffff99fef,  0x1f1fcfe081399f,  0x0,  0x0,  0xffffffffffffffff,  0x3efffffff,  0xffffffffffffffff,  0x3ff00ff,  0x0,  0x0,  0xff3fffffffffffff,  0x3fffffff,  0xffffffffffffffff,  0x1fff03ff001f,  0x3ffffffffffffff,  0x3ff,  0xffff0fffe7ffffff,  0x7f,  0x0,  0x0,  0xfffffffffffffff,  0x0,  0xffffffff00000000,  0x8007ffffffffffff,  0xf9bfffffff6ff27f,  0x3ff007f,  0xfffffcff00000000,  0x1ffcffffff,  0xffffffffffffffff,  0xffffffffffff00ff,  0xffff0007ffffffff,  0x1ffffffffffffff,  0x3ff,  0x0,  0x0,  0x0,  0xff7ffffffffffdff,  0xffff1fffffff003f,  0x7ffefffffcffff,  0x0,  0xb47ffffffffffb7f,  0xfffffdbf03ff00ff,  0x3ff01fb7fff,  0x0,  0x0,  0x0,  0x0,  0x1ffffff00000000,  0xc7fffffffffdffff,  0x3ffffff,  0x1000000000000,  0x8003ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3ffffff,  0x0,  0xffffffffffffffff,  0x1f7fffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xf,  0x0,  0x0,  0x0,  0x0,  0xffffffffffff0000,  0x7ffffffffffff,  0xffffffffffff,  0x3fffff,  0x0,  0x0,  0xffffffffffffffff,  0x7f,  0x0,  0x0,  0x1ffffffffffffff,  0xffffc3ff7fffffff,  0x7fffffffffffffff,  0x3f3fffffff03ff,  0xffffffffffffffff,  0xe0fffffbfbff003f,  0xffff,  0x0,  0x0,  0xffffffffffffffff,  0x7ffffff,  0x0,  0xffffffffffffffff,  0xffffffffffff87ff,  0xffff80ff,  0x3001f00000000,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3fffff,  0x1ff,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x6fef000000000000,  0x40007ffffffff,  0xffff00f000270000,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfffffffffffffff,  0xffffffffffffffff,  0x1fff07ffffffffff,  0xf3ff01ff,  0x0,  0xffff3fffffffffff,  0xffffffffffff007f,  0xffffffffffffffff,  0xf,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3fffffffffffff,  0xfffffe7fffffffff,  0xf807ffffffffffff,  0xffffffffffffffff,  0x7ffffffffff,  0xffffffffffffffff,  0x3f,  0x0,  0xfffff000fffff,  0xffffffffffffffff,  0x1ffffff007fffff,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffdfffff,  0xebffde64dfffffff,  0xffffffffffffffef,  0x7bffffffdfdfe7bf,  0xfffffffffffdfc5f,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffff3fffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffcfff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfffef8000fff,  0x0,  0x7e07fffffff,  0x0,  0x0,  0x0,  0xffff07dbf9ffff7f,  0x3fffffffffff,  0x8000,  0x0,  0x3fff1fffffffffff,  0xc3ff,  0x0,  0x0,  0x0,  0x0,  0x7fffffff0000,  0x83ffffffffffffff,  0x0,  0x0,  0x0,  0x3ffffffffff0000,  0x0,  0x0,  0x0,  0x7fff6f7f00000000,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x7fff9f,  0xffffffffffffffff,  0xc3ff0fff,  0x0,  0x0,  0x0,  0xfffe000000000000,  0x1fffffffffffff,  0x0,  0x3ffffffffffffffe,  0x0,  0x0,  0x0,  0xaf7fe96ffffffef,  0x5ef7f796aa96ea84,  0xffffbee0ffffbff,  0x3000000000000,  0xffff0fffffffffff,  0xffffffffffffffff,  0xfffe7fff000fffff,  0x3ffffffffefffe,  0xffffffffffffffff,  0xffffffffffffffff,  0x3fffffffffff,  0xffffffc000000000,  0xfffffffffff0007,  0x3f000301ff,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1fff1ffff0ffffff,  0xffffffffffffffff,  0xf87fffffffffffff,  0xffffffffffffffff,  0x10fff03ffffff,  0xffffffffffff0fff,  0xffffffff03ff00ff,  0x33fffffff00ff,  0x0,  0xffffffffffffffff,  0x1fff3fff000fffff,  0xbfffffffffff01ff,  0x1ff01ff0fffc03f,  0xffffffffffffffff,  0xffffffffffffffff,  0xfffffffffff7ffff,  0x3ff0000000007ff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff,  0x3ffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff3fffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0003ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1ffffffff,  0x3fffffff,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffff07ff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffff,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffff,  0x0,  0x0,  0x0,  0x0]);
//4784 bytes
enum nonCharacterTrieEntries = TrieEntry!(bool, 7, 4, 4, 6)([ 0x0,  0x10,  0x4c,  0x148], [ 0x80,  0xf0,  0x3f0,  0x4380], [ 0x706050403020100,  0xb0b0b0a09080101,  0xb0b0b0b0b0b0b0b,  0xb0b0b0b0b0b0b0b,  0xb0b0b0b0b0b0b0b,  0xb0b0b0b0b0b0b0b,  0xb0b0b0b0b0b0b0b,  0xd0101010b0b0b0c,  0xd010101,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3000200010000,  0x7000600050004,  0xb000a00090008,  0xd000d000d000c,  0xd000d000d000d,  0xd000d000d000d,  0xd000d000d000d,  0xd000d000d000d,  0xd000d000d000d,  0xd000d000d000d,  0xd000f000e000d,  0xd000d000d000d,  0xd000d000d000d,  0xd000d0010000d,  0xd000d000d000d,  0x120011000d000d,  0x16001500140013,  0x1a001900180017,  0x1e001d001c001b,  0x1d001d001f000d,  0x1d001d0020001d,  0x1d001d001d001d,  0x220021001d001d,  0xd000d000d000d,  0x24000d0023000d,  0x1d001d001d001d,  0x25001d001d001d,  0x27001d001d0026,  0x28001d001d001d,  0x2c002b002a0029,  0x30002f002e002d,  0x1d003300320031,  0xd000d000d000d,  0xd000d000d000d,  0xd000d0034000d,  0xd00360035000d,  0x37000d000d000d,  0xd000d000d000d,  0x1d0038000d000d,  0x1d0039001d001d,  0xd000d000d000d,  0xd000d000d003a,  0x1d001d001d003b,  0x1d001d001d001d,  0x1d001d001d001d,  0x1d001d001d001d,  0x1d001d001d001d,  0x1d001d001d001d,  0x1d001d001d003c,  0x1d001d001d001d,  0x1d001d001d001d,  0x1d001d001d001d,  0xd000d000d000d,  0xd000d000d000d,  0xd000d000d000d,  0x3d000d000d000d,  0xd000d000d000d,  0xd000d000d000d,  0xd000d000d000d,  0x3d000d000d000d,  0x0,  0x0,  0x0,  0x200010000,  0x0,  0x6000500040003,  0x0,  0xa000900080007,  0xd000c000b,  0xf000e00000000,  0x13001200110010,  0x17001600150014,  0x1b001a00190018,  0x1f001e001d001c,  0x23002200210020,  0x26002500240000,  0x27000000000000,  0x0,  0x2a002900280000,  0x2e002d002c002b,  0x0,  0x0,  0x30002f00000000,  0x33000000320031,  0x3500340030002d,  0x39003800370036,  0x3d003c003b003a,  0x3f0000003e0000,  0x43004200410040,  0x0,  0x0,  0x47004600450044,  0x4a004900480000,  0x4b00000000,  0x0,  0x0,  0x4d004c,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x4f004e0000,  0x50000000000000,  0x54005300520051,  0x57005600550000,  0x58000000000000,  0x400590000,  0x5c005b0000005a,  0x5d,  0x0,  0x0,  0x0,  0x0,  0x0,  0x5f005e00000000,  0x0,  0x61000000000060,  0x62000000000000,  0x64000000610063,  0x66000000650000,  0x69000000680067,  0x6b00000038006a,  0x0,  0x0,  0x0,  0x6c005c00000000,  0x0,  0x0,  0x6e0000006d0000,  0x7100000070006f,  0x0,  0x73007200000000,  0x7500000074002d,  0x77007600000059,  0x7a000000790078,  0x7d007c0000007b,  0x7f002f007e007e,  0x83008200810080,  0x85008400000000,  0x7e008800870086,  0x0,  0x7e008a00890067,  0x8d008c004f008b,  0x72008f007e008e,  0x93009200910090,  0x7e009600950094,  0x99009800970000,  0x7e007e007e009a,  0x9d009c009b007e,  0xa0009f009e0086,  0xa2000000a10000,  0xa4000000a30046,  0xa800a700a600a5,  0x7e007e00aa00a9,  0xac000000ab0000,  0x5500ad007e007e,  0xb000af00ae0000,  0x7e007e00b200b1,  0xb500b4007e00b3,  0xb900b800b700b6,  0x3000bb00ba0000,  0x7e007e007e00b0,  0x7e00be00bd00bc,  0x7e00c100c000bf,  0xc2007e007e007e,  0xc500c4006e00c3,  0x0,  0x0,  0x0,  0x7e006e00000000,  0xc60000,  0x7e007e00c70000,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x9800c8007e007e,  0x7e007e00c90000,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x0,  0x0,  0x7e007e00b20000,  0x7e007e007e007e,  0x0,  0x0,  0xcb007600ca0030,  0x7e00cd00cc0000,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e00ce0000007e,  0xd100d000cf0000,  0x0,  0x0,  0x0,  0x61000000000000,  0xc9000000000000,  0x7e007e007e0097,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0xd2007e007e007e,  0x0,  0xd400d3,  0xb3000000000000,  0x7e007e007e007e,  0x7e00d600d50000,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0xc70000005f006d,  0x35000000000000,  0xd80000000000d7,  0xda007e00d90000,  0x7e007e00db0000,  0xde00dd00dc0000,  0xe000df,  0xe100000000,  0xe2000000000000,  0x0,  0x0,  0x7e00e300000000,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e007e007e00e4,  0x7e00e700e600e5,  0x7e007e00e900e8,  0xeb00ea007e007e,  0x7e007e007e007e,  0xec007e007e007e,  0x7e007e007e007e,  0x7e007e007e007e,  0xed007e007e007e,  0xee000000000000,  0x7e007e00ef0000,  0x7e007e007e007e,  0x7e007e007e007e,  0x7e00f100f0007e,  0x7e007e007e00f2,  0xf600f500f400f3,  0x7e007e007e007e,  0xf800f700000038,  0xf900e600000000,  0x7e007e00fb00fa,  0x0,  0x0,  0x0,  0xfc000000000000,  0xfe000000fd0000,  0x7e010000ff004b,  0x0,  0x103010201010000,  0x105010400000000,  0x0,  0x0,  0x92000000000000,  0x0,  0x0,  0x0,  0x0,  0xaf,  0x106,  0x0,  0x0,  0x0,  0x0,  0x0,  0x10700000000,  0x0,  0x0,  0x0,  0x0,  0x108000000000000,  0x0,  0x0,  0x7e007e007e0055,  0x7e007e007e007e,  0x0,  0x0,  0x0,  0x1090000,  0x0,  0x0,  0x0,  0x7e010a00000000,  0x7e007e0000010b,  0x10a000000000000,  0x7e007e007e007e,  0x7e007e007e007e,  0x0,  0x0,  0x0,  0x10c000000000000,  0x0,  0x0,  0x0,  0x10c000000000000,  0x0,  0x300000000000000,  0x40000280f,  0x1000000000000,  0x1800000,  0x11800,  0xffe078000000ff00,  0x4000,  0x1800,  0xfffc000000000000,  0x1800000000000000,  0x8000c00000000000,  0xf800b0000000,  0xfc8000,  0xc3a020000066010,  0x800000304f7f8660,  0x2c92020000067811,  0xff80003fa1fdc678,  0xc12020000044011,  0x1fc0030fffec440,  0xc12020000066011,  0xff0000304f1fc660,  0x3c0038e729c23813,  0xf800003fff7ec238,  0xc00020000022000,  0x7f0030d89fc220,  0xc10020000022000,  0xfff100309f9fc220,  0x22000,  0x30000f0220,  0xd004000003800011,  0xffe3003f00a07b80,  0x7800000000000001,  0xfffffffff0000000,  0xc000005000000829,  0xffffffff0c0080a0,  0x1e00000000100,  0x2000000001000000,  0xfffffffff8002000,  0xdf40,  0xc280c200,  0x80c200000000c200,  0x8000c2,  0xc20000,  0xe000000018000000,  0xfc000000,  0xc0c0000000000000,  0xe0000000,  0xfe00000000000000,  0xff8000007fc00000,  0xfff22000fff00000,  0xfc00fc00c0000000,  0xf80000000000,  0xffc0000000000000,  0xf000f00080000000,  0xffe0c0000000000e,  0xf00000000000,  0x3800fc00,  0x30000000,  0x6000000080000000,  0xc000fc00fc00,  0xffffffffffff8000,  0x800000000000e000,  0xff0000000000000,  0x700000000000000,  0x1c00,  0x180000000000fe00,  0xf80000000000ff00,  0xc0c00000,  0xc00000005500c0c0,  0x20000000000000,  0x8023000010300020,  0xc002000000000,  0xe0008000,  0xfffe00000000fffe,  0xf000,  0xffffff8000000000,  0xfffff800,  0x30000000000000,  0x400000,  0x1f0000000000000,  0xdf4000000000,  0x7ffe7f0000000000,  0x80808080ff800000,  0x80808080,  0xffffffffc0000000,  0x4000000,  0xfff0000000000000,  0xf000ffffffc00000,  0x1,  0x100000000001f,  0x8000,  0xfff000000000,  0x80000000,  0xe000,  0xff80,  0xfffff00000000000,  0xff00000000000000,  0x3fffffc14f800,  0xfc00e00000000000,  0xfc003fc0,  0xe00000007ff00000,  0x800000003c004000,  0xff80000000000000,  0xc00c000,  0xff80000007fffff8,  0x8080ff818181,  0xfc00c00000000000,  0xf000000000000780,  0xc00000000000,  0xfffffffffc000000,  0xa08000001f07ff80,  0x24,  0x7fff8,  0x30000,  0xffffffff7f00,  0x20f08000080000,  0x6000000000000000,  0x8000000000000000,  0xc1ff8080e3030303,  0x4800008000001000,  0xffffffffc000c000,  0xf800000000000000,  0x70000000000078,  0xfffffffee0008000,  0xc00000000000ffff,  0xffffffffffffffff,  0xf0000000fffe0000,  0x1ff000000000,  0xf80000000000f800,  0x40000000,  0xffffffffffc000f0,  0xfc00c0000000,  0xf000000000f00000,  0xff0000000000,  0x8007ff000000000,  0xe404000400480800,  0xffffff00ffc00000,  0xf802000000000040,  0x6e400000000002c0,  0xffff007f80000000,  0x7c80000ffffffff,  0x7c00000070000000,  0xf00000000000000,  0x78c0000001100f90,  0xfe00fe00,  0xffffffff00000000,  0xff80078000000000,  0x1c0000000000000,  0xf8000000c00000,  0xffff01ffe1fc0000,  0xfffffffffffffe00,  0xfff8000000000000,  0x3f8000000000000,  0xfc00ff0000000000,  0x80000000ffffffff,  0xfffcc40000000000,  0x1fffffffffffffff,  0xfffffc000000,  0xfffffffffc00,  0xff800000fffff000,  0x7fc000000003c000,  0xfc00fe000000dff8,  0xff8000000000ff00,  0xffe0000100000000,  0x40000,  0xfffffffffffffffc,  0xfc0040004280,  0xfc00f80000000000,  0x412020000066010,  0xffe0e0301f7ec660,  0xfffffffc10000000,  0xfffffffffc00ff00,  0xc0000000000000,  0xffffe000fc00ffe0,  0xfc00000000000000,  0xfffffffffffffc00,  0xf00018000000,  0xffffffffffffff80,  0xf000000000000000,  0xffffffff,  0x7ff8000000000000,  0x640000000900d80,  0xfffffffffc00ff80,  0x300ffffffff,  0xffffffe003000000,  0xff00,  0xfff800000000,  0x80000000000200,  0xe0000000ffc0,  0xff80010000030000,  0x4b80000000000480,  0x240fc00ff00,  0xfffffc00fe048000,  0xfe000000ffffffff,  0x3800000000020000,  0xfffeffffffffffff,  0x7ffc000000000000,  0xffe0800000000000,  0xfffffffffffffff0,  0xffff,  0xffffffffffc00000,  0x3c0080000000,  0xffc0c0000000fc00,  0x1f0000040400ffc0,  0xffffffffffff0000,  0xfffffffff8000000,  0x7800,  0xffffffff00007f00,  0xfffcffe0ffffffff,  0x9010ffffffffffff,  0xfffbfff800000000,  0xff0fffd8ffff,  0xe000f80000000000,  0xfffffff00c00fe00,  0x18000000000,  0xfffff80000000000,  0xffffffffffffffc0,  0xfff00000fff00000,  0xfe000000ff800000,  0x200000,  0x1400219b20000000,  0x10,  0x8400000020201840,  0x203a0,  0xc000000000,  0x3000,  0xffff000107fff000,  0xfffff81f80000000,  0xf82406000080,  0xffffc00000000000,  0xffffffffffff7fff,  0xc000e00000000000,  0xffffffffffff3c00,  0xffff80000000ffff,  0x7c00000000000000,  0xfc0000000000ffff,  0x80009080ffffffff,  0xffffffffff800060,  0xffffffff3c00f000,  0x1ffffffffffff,  0xffe0000000000000,  0xc000000000000001,  0xf508016900000010,  0xa10808695569157b,  0xf0000411f0000400,  0xfffcffffffffffff,  0x18000fff00000,  0xffc0000000010001,  0x3fffffffff,  0xf00000000000fff8,  0xffffffc0fffcfe00,  0xe000e0000f000000,  0x780000000000000,  0xfffef000fc000000,  0xfc00ff00,  0xfffcc0000000ff00,  0xe000c000fff00000,  0x400000000000fe00,  0xfe00fe00f0003fc0,  0x80000,  0xfc00fffffffff800,  0xc0000000,  0xfffc00000000,  0xfffffffe00000000,  0xf800,  0xffff000000000000,  0xfffffffd,  0xc000000000000000,  0xc000000000000000]);
enum MAX_SIMPLE_LOWER = 1433;
enum MAX_SIMPLE_UPPER = 1450;
enum MAX_SIMPLE_TITLE = 1454;
//10496 bytes
enum toUpperIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x20,  0x140], [ 0x100,  0x480,  0xf80], [ 0x402030202020100,  0x702020206020205,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x3000200010000,  0x7000600050004,  0xa00090008,  0xd000c000b0000,  0x110010000f000e,  0x1400130012,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x15000000000000,  0x0,  0x0,  0x16000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1700000000,  0x1900180000,  0x1d001c001b001a,  0x210020001f001e,  0x0,  0x2300220000,  0x0,  0x0,  0x24000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x28002700260025,  0x29,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2b002a0000,  0x2f002e002d002c,  0x0,  0x0,  0x0,  0x3100300000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x32,  0x0,  0x0,  0x0,  0x330000,  0x0,  0x0,  0x0,  0x0,  0x36000000350034,  0x3700000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x38000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x39000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3a0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3c003b,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x200010000ffff,  0x6000500040003,  0xa000900080007,  0xe000d000c000b,  0x1200110010000f,  0x16001500140013,  0xffff001900180017,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff001affff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x5aaffffffffffff,  0x1e001d001c001b,  0x2200210020001f,  0x26002500240023,  0x2a002900280027,  0x2e002d002c002b,  0xffff00310030002f,  0x35003400330032,  0x39003800370036,  0x3bffff003affff,  0x3dffff003cffff,  0x3fffff003effff,  0x41ffff0040ffff,  0x43ffff0042ffff,  0x45ffff0044ffff,  0x47ffff0046ffff,  0x49ffff0048ffff,  0x4bffff004affff,  0x4dffff004cffff,  0x4fffff004effff,  0x51ffff0050ffff,  0x53ffff005205ac,  0x55ffff0054ffff,  0xffff0056ffffffff,  0xffff0058ffff0057,  0xffff005affff0059,  0xffff005cffff005b,  0x5effff05c9005d,  0x60ffff005fffff,  0x62ffff0061ffff,  0x64ffff0063ffff,  0x66ffff0065ffff,  0x68ffff0067ffff,  0x6affff0069ffff,  0x6cffff006bffff,  0x6effff006dffff,  0x70ffff006fffff,  0x72ffff0071ffff,  0x74ffff0073ffff,  0xffff0075ffffffff,  0x780077ffff0076,  0x7affffffff0079,  0xffffffff007bffff,  0xffffffffffff007c,  0xffffffffffff007d,  0xffff007effffffff,  0xffffffff007fffff,  0xffff00810080ffff,  0xffff0082ffffffff,  0x84ffff0083ffff,  0xffffffff0085ffff,  0xffffffffffff0086,  0xffffffff0087ffff,  0xffffffffffff0088,  0xffff008affff0089,  0xffffffff008bffff,  0x8dffff008cffff,  0xffffffffffffffff,  0xffff008f008effff,  0x92ffff00910090,  0xffff0094ffff0093,  0xffff0096ffff0095,  0xffff0098ffff0097,  0xffff009affff0099,  0x9dffff009c009b,  0x9fffff009effff,  0xa1ffff00a0ffff,  0xa3ffff00a2ffff,  0xa5ffff00a4ffff,  0xa700a6ffff05d1,  0xffffffff00a8ffff,  0xaaffff00a9ffff,  0xacffff00abffff,  0xaeffff00adffff,  0xb0ffff00afffff,  0xb2ffff00b1ffff,  0xb4ffff00b3ffff,  0xb6ffff00b5ffff,  0xb8ffff00b7ffff,  0xbaffff00b9ffff,  0xbcffff00bbffff,  0xbdffffffffffff,  0xbfffff00beffff,  0xc1ffff00c0ffff,  0xc3ffff00c2ffff,  0xc5ffff00c4ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xc7ffffffff00c6,  0xffff00c9ffff00c8,  0xcaffffffffffff,  0xccffff00cbffff,  0xceffff00cdffff,  0xd200d100d000cf,  0xd500d4ffff00d3,  0xd7ffff00d6ffff,  0xffffffffffff00d8,  0xdbffff00da00d9,  0xffff00dd00dcffff,  0xe100e000df00de,  0xe3ffffffff00e2,  0xffff00e500e4ffff,  0xffffffff00e6ffff,  0xffffffffffffffff,  0xffffffff00e7ffff,  0xea00e9ffff00e8,  0xebffffffffffff,  0xef00ee00ed00ec,  0xffffffffffff00f0,  0xffff00f1ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff00f300f2ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff00f4ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xf6ffff00f5ffff,  0xf7ffffffffffff,  0xf8ffffffffffff,  0xffffffff00fa00f9,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffff05cb,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfe00fd00fc00fb,  0x101010000ff05ce,  0x105010401030102,  0x109010801070106,  0x10d010c010b010a,  0x1110110010f010e,  0x115011401130112,  0x119011801170116,  0xffff011c011b011a,  0xffffffff011e011d,  0x1210120011fffff,  0x123ffff0122ffff,  0x125ffff0124ffff,  0x127ffff0126ffff,  0x129ffff0128ffff,  0x12bffff012affff,  0x12dffff012cffff,  0x1310130012f012e,  0xffffffff0132ffff,  0x134ffffffff0133,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x138013701360135,  0x13c013b013a0139,  0x140013f013e013d,  0x144014301420141,  0x148014701460145,  0x14c014b014a0149,  0x150014f014e014d,  0x154015301520151,  0x158015701560155,  0x15c015b015a0159,  0x160015f015e015d,  0x164016301620161,  0x166ffff0165ffff,  0x168ffff0167ffff,  0x16affff0169ffff,  0x16cffff016bffff,  0x16effff016dffff,  0x170ffff016fffff,  0x172ffff0171ffff,  0x174ffff0173ffff,  0xffffffff0175ffff,  0xffffffffffffffff,  0x176ffffffffffff,  0x178ffff0177ffff,  0x17affff0179ffff,  0x17cffff017bffff,  0x17effff017dffff,  0x180ffff017fffff,  0x182ffff0181ffff,  0x184ffff0183ffff,  0x186ffff0185ffff,  0x188ffff0187ffff,  0x18affff0189ffff,  0x18cffff018bffff,  0x18effff018dffff,  0x190ffff018fffff,  0xffff0191ffffffff,  0xffff0193ffff0192,  0xffff0195ffff0194,  0x1980197ffff0196,  0x19affff0199ffff,  0x19cffff019bffff,  0x19effff019dffff,  0x1a0ffff019fffff,  0x1a2ffff01a1ffff,  0x1a4ffff01a3ffff,  0x1a6ffff01a5ffff,  0x1a8ffff01a7ffff,  0x1aaffff01a9ffff,  0x1acffff01abffff,  0x1aeffff01adffff,  0x1b0ffff01afffff,  0x1b2ffff01b1ffff,  0x1b4ffff01b3ffff,  0x1b6ffff01b5ffff,  0x1b8ffff01b7ffff,  0x1baffff01b9ffff,  0x1bcffff01bbffff,  0x1beffff01bdffff,  0x1c0ffff01bfffff,  0x1c2ffff01c1ffff,  0x1c4ffff01c3ffff,  0x1c6ffff01c5ffff,  0x1c8ffff01c7ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1cb01ca01c9ffff,  0x1cf01ce01cd01cc,  0x1d301d201d101d0,  0x1d701d601d501d4,  0x1db01da01d901d8,  0x1df01de01dd01dc,  0x1e301e201e101e0,  0x1e701e601e501e4,  0x1eb01ea01e901e8,  0x5bd01ee01ed01ec,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1f201f101f001ef,  0x1f601f501f401f3,  0x1fa01f901f801f7,  0x1fe01fd01fc01fb,  0x2020201020001ff,  0x206020502040203,  0x20a020902080207,  0x20e020d020c020b,  0x21202110210020f,  0x216021502140213,  0xffff021902180217,  0x21c021b021affff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x220021f021e021d,  0xffffffff02220221,  0x226022502240223,  0x22a022902280227,  0xffffffffffff022b,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff022cffff,  0xffffffff022dffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff022effffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x230ffff022fffff,  0x232ffff0231ffff,  0x234ffff0233ffff,  0x236ffff0235ffff,  0x238ffff0237ffff,  0x23affff0239ffff,  0x23cffff023bffff,  0x23effff023dffff,  0x240ffff023fffff,  0x242ffff0241ffff,  0x244ffff0243ffff,  0x246ffff0245ffff,  0x248ffff0247ffff,  0x24affff0249ffff,  0x24cffff024bffff,  0x24effff024dffff,  0x250ffff024fffff,  0x252ffff0251ffff,  0x254ffff0253ffff,  0x256ffff0255ffff,  0x258ffff0257ffff,  0x25affff0259ffff,  0x25cffff025bffff,  0x25effff025dffff,  0x260ffff025fffff,  0x262ffff0261ffff,  0x264ffff0263ffff,  0x266ffff0265ffff,  0x268ffff0267ffff,  0x26affff0269ffff,  0x26cffff026bffff,  0x26effff026dffff,  0x270ffff026fffff,  0x272ffff0271ffff,  0x274ffff0273ffff,  0x276ffff0275ffff,  0x278ffff0277ffff,  0x5d505d30279ffff,  0x27a05db05d905d7,  0xffffffffffffffff,  0x27cffff027bffff,  0x27effff027dffff,  0x280ffff027fffff,  0x282ffff0281ffff,  0x284ffff0283ffff,  0x286ffff0285ffff,  0x288ffff0287ffff,  0x28affff0289ffff,  0x28cffff028bffff,  0x28effff028dffff,  0x290ffff028fffff,  0x292ffff0291ffff,  0x294ffff0293ffff,  0x296ffff0295ffff,  0x298ffff0297ffff,  0x29affff0299ffff,  0x29cffff029bffff,  0x29effff029dffff,  0x2a0ffff029fffff,  0x2a2ffff02a1ffff,  0x2a4ffff02a3ffff,  0x2a6ffff02a5ffff,  0x2a8ffff02a7ffff,  0x2aaffff02a9ffff,  0x2ae02ad02ac02ab,  0x2b202b102b002af,  0xffffffffffffffff,  0xffffffffffffffff,  0x2b602b502b402b3,  0xffffffff02b802b7,  0xffffffffffffffff,  0xffffffffffffffff,  0x2bc02bb02ba02b9,  0x2c002bf02be02bd,  0xffffffffffffffff,  0xffffffffffffffff,  0x2c402c302c202c1,  0x2c802c702c602c5,  0xffffffffffffffff,  0xffffffffffffffff,  0x2cc02cb02ca02c9,  0xffffffff02ce02cd,  0xffffffffffffffff,  0xffffffffffffffff,  0x2d005df02cf05dd,  0x2d205e502d105e2,  0xffffffffffffffff,  0xffffffffffffffff,  0x2d602d502d402d3,  0x2da02d902d802d7,  0xffffffffffffffff,  0xffffffffffffffff,  0x2de02dd02dc02db,  0x2e202e102e002df,  0x2e602e502e402e3,  0xffffffff02e802e7,  0x60c060a06080606,  0x61406120610060e,  0x61c061a06180616,  0x62406220620061e,  0x62c062a06280626,  0x63406320630062e,  0x63c063a06380636,  0x64406420640063e,  0x64c064a06480646,  0x65406520650064e,  0x65c065a06580656,  0x66406620660065e,  0x666067203020301,  0x67e05e8ffff0674,  0xffffffffffffffff,  0xffff0304ffff0668,  0x66a0676ffffffff,  0x68105eaffff0678,  0xffffffffffffffff,  0xffffffffffff066c,  0x5ef05ec03070306,  0x5f405f2ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x5fa05f703090308,  0x60105ff030a05fd,  0xffffffffffffffff,  0xffffffffffffffff,  0x66e067affffffff,  0x6840604ffff067c,  0xffffffffffffffff,  0xffffffffffff0670,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff030cffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x310030f030e030d,  0x314031303120311,  0x318031703160315,  0x31c031b031a0319,  0xffffffffffffffff,  0xffffffffffff031d,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3210320031f031e,  0x325032403230322,  0x329032803270326,  0x32d032c032b032a,  0x3310330032f032e,  0x335033403330332,  0xffffffff03370336,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x33b033a03390338,  0x33f033e033d033c,  0x343034203410340,  0x347034603450344,  0x34b034a03490348,  0x34f034e034d034c,  0x353035203510350,  0x357035603550354,  0x35b035a03590358,  0x35f035e035d035c,  0x363036203610360,  0x367036603650364,  0xffffffff0368ffff,  0xffff036a0369ffff,  0xffff036cffff036b,  0xffffffffffff036d,  0x36effffffffffff,  0xffff036fffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x371ffff0370ffff,  0x373ffff0372ffff,  0x375ffff0374ffff,  0x377ffff0376ffff,  0x379ffff0378ffff,  0x37bffff037affff,  0x37dffff037cffff,  0x37fffff037effff,  0x381ffff0380ffff,  0x383ffff0382ffff,  0x385ffff0384ffff,  0x387ffff0386ffff,  0x389ffff0388ffff,  0x38bffff038affff,  0x38dffff038cffff,  0x38fffff038effff,  0x391ffff0390ffff,  0x393ffff0392ffff,  0x395ffff0394ffff,  0x397ffff0396ffff,  0x399ffff0398ffff,  0x39bffff039affff,  0x39dffff039cffff,  0x39fffff039effff,  0x3a1ffff03a0ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff03a3ffff03a2,  0x3a4ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3a803a703a603a5,  0x3ac03ab03aa03a9,  0x3b003af03ae03ad,  0x3b403b303b203b1,  0x3b803b703b603b5,  0x3bc03bb03ba03b9,  0x3c003bf03be03bd,  0x3c403c303c203c1,  0x3c803c703c603c5,  0x3cbffff03ca03c9,  0xffffffffffffffff,  0xffffffff03ccffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3ceffff03cdffff,  0x3d0ffff03cfffff,  0x3d2ffff03d1ffff,  0x3d4ffff03d3ffff,  0x3d6ffff03d5ffff,  0x3d8ffff03d7ffff,  0x3daffff03d9ffff,  0x3dcffff03dbffff,  0x3deffff03ddffff,  0x3e0ffff03dfffff,  0x3e2ffff03e1ffff,  0xffffffff03e3ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3e5ffff03e4ffff,  0x3e7ffff03e6ffff,  0x3e9ffff03e8ffff,  0x3ebffff03eaffff,  0x3edffff03ecffff,  0x3efffff03eeffff,  0x3f1ffff03f0ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3f2ffffffffffff,  0x3f4ffff03f3ffff,  0x3f6ffff03f5ffff,  0x3f8ffff03f7ffff,  0x3f9ffffffffffff,  0x3fbffff03faffff,  0x3fdffff03fcffff,  0x3ffffff03feffff,  0x401ffff0400ffff,  0x403ffff0402ffff,  0x405ffff0404ffff,  0x407ffff0406ffff,  0x409ffff0408ffff,  0x40bffff040affff,  0x40dffff040cffff,  0x40fffff040effff,  0x411ffff0410ffff,  0x413ffff0412ffff,  0x415ffff0414ffff,  0x417ffff0416ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0418ffffffff,  0x41affffffff0419,  0x41cffff041bffff,  0x41effff041dffff,  0xffffffffffffffff,  0xffffffffffff041f,  0x421ffff0420ffff,  0x423ffffffff0422,  0x425ffff0424ffff,  0x427ffff0426ffff,  0x429ffff0428ffff,  0x42bffff042affff,  0xffffffff042cffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x42effff042dffff,  0x430ffff042fffff,  0x432ffff0431ffff,  0x434ffff0433ffff,  0xffffffffffffffff,  0xffff0436ffff0435,  0xffffffffffffffff,  0xffffffff0437ffff,  0x438ffffffffffff,  0xffffffff0439ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff043affffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x43bffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x43f043e043d043c,  0x443044204410440,  0x447044604450444,  0x44b044a04490448,  0x44f044e044d044c,  0x453045204510450,  0x457045604550454,  0x45b045a04590458,  0x45f045e045d045c,  0x463046204610460,  0x467046604650464,  0x46b046a04690468,  0x46f046e046d046c,  0x473047204710470,  0x477047604750474,  0x47b047a04790478,  0x47f047e047d047c,  0x483048204810480,  0x487048604850484,  0x48b048a04890488,  0x5b305b105af05ad,  0xffff05bb05b905b6,  0xffffffffffffffff,  0xffffffffffffffff,  0x5bfffffffffffff,  0x5c705c505c305c1,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x48e048d048cffff,  0x49204910490048f,  0x496049504940493,  0x49a049904980497,  0x49e049d049c049b,  0x4a204a104a0049f,  0xffff04a504a404a3,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4a904a804a704a6,  0x4ad04ac04ab04aa,  0x4b104b004af04ae,  0x4b504b404b304b2,  0x4b904b804b704b6,  0x4bd04bc04bb04ba,  0x4c104c004bf04be,  0x4c504c404c304c2,  0x4c904c804c704c6,  0x4cd04cc04cb04ca,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4d104d004cf04ce,  0x4d504d404d304d2,  0x4d904d804d704d6,  0x4dd04dc04db04da,  0x4e104e004df04de,  0x4e504e404e304e2,  0x4e904e804e704e6,  0x4ed04ec04eb04ea,  0x4f104f004ef04ee,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4f2ffffffffffff,  0x4f604f504f404f3,  0x4fa04f904f804f7,  0x4fdffff04fc04fb,  0x501050004ff04fe,  0x505050405030502,  0x509050805070506,  0x50cffff050b050a,  0x510050f050e050d,  0x513ffff05120511,  0xffffffffffff0514,  0x518051705160515,  0x51c051b051a0519,  0x520051f051e051d,  0x524052305220521,  0x528052705260525,  0x52c052b052a0529,  0x530052f052e052d,  0x534053305320531,  0x538053705360535,  0x53c053b053a0539,  0x540053f053e053d,  0x544054305420541,  0xffff054705460545,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x54b054a05490548,  0x54f054e054d054c,  0x553055205510550,  0x557055605550554,  0x55b055a05590558,  0x55f055e055d055c,  0x563056205610560,  0x567056605650564,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x56b056a05690568,  0x56f056e056d056c,  0x573057205710570,  0x577057605750574,  0x57b057a05790578,  0x57f057e057d057c,  0x583058205810580,  0x587058605850584,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x5890588ffffffff,  0x58d058c058b058a,  0x5910590058f058e,  0x595059405930592,  0x599059805970596,  0x59d059c059b059a,  0x5a105a0059f059e,  0x5a505a405a305a2,  0x5a905a805a705a6,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff]);
//10112 bytes
enum toLowerIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x20,  0x140], [ 0x100,  0x480,  0xec0], [ 0x402030202020100,  0x702020206020205,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x2000000010000,  0x6000500040003,  0x80007,  0xb000a00090000,  0xf000e000d000c,  0x1200110010,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x14001300000000,  0x0,  0x0,  0x16001500000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1700000000,  0x0,  0x1b001a00190018,  0x1f001e001d001c,  0x0,  0x2200210020,  0x0,  0x0,  0x24002300000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x28002700260025,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2a00290000,  0x2e002d002c002b,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2f,  0x0,  0x0,  0x0,  0x30,  0x0,  0x0,  0x0,  0x0,  0x33003200000031,  0x3500340000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3600000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3700000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x380000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x39,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x200010000ffff,  0x6000500040003,  0xa000900080007,  0xe000d000c000b,  0x1200110010000f,  0x16001500140013,  0xffff001900180017,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1d001c001b001a,  0x210020001f001e,  0x25002400230022,  0x29002800270026,  0x2d002c002b002a,  0xffff0030002f002e,  0x34003300320031,  0x599003700360035,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0039ffff0038,  0xffff003bffff003a,  0xffff003dffff003c,  0xffff003fffff003e,  0xffff0041ffff0040,  0xffff0043ffff0042,  0xffff0045ffff0044,  0xffff0047ffff0046,  0xffff0049ffff0048,  0xffff004bffff004a,  0xffff004dffff004c,  0xffff004fffff004e,  0xffff0051ffff059a,  0xffff0053ffff0052,  0x55ffff0054ffff,  0x57ffff0056ffff,  0x59ffff0058ffff,  0x5bffff005affff,  0xffff005c05a9ffff,  0xffff005effff005d,  0xffff0060ffff005f,  0xffff0062ffff0061,  0xffff0064ffff0063,  0xffff0066ffff0065,  0xffff0068ffff0067,  0xffff006affff0069,  0xffff006cffff006b,  0xffff006effff006d,  0xffff0070ffff006f,  0xffff0072ffff0071,  0x75ffff00740073,  0xffffffff0076ffff,  0xffff00780077ffff,  0x7b007affff0079,  0x7e007d007cffff,  0x80007fffffffff,  0x83ffff00820081,  0x860085ffff0084,  0xffffffffffff0087,  0x8affff00890088,  0xffff008cffff008b,  0x8f008effff008d,  0xffffffff0090ffff,  0x930092ffff0091,  0x9600950094ffff,  0x98ffff0097ffff,  0xffffffffffff0099,  0xffffffffffff009a,  0xffffffffffffffff,  0x9dffff009c009b,  0xa0009fffff009e,  0xa2ffff00a1ffff,  0xa4ffff00a3ffff,  0xa6ffff00a5ffff,  0xa8ffff00a7ffff,  0xffff00a9ffffffff,  0xffff00abffff00aa,  0xffff00adffff00ac,  0xffff00afffff00ae,  0xffff00b1ffff00b0,  0xffff00b300b205ac,  0xb600b5ffff00b4,  0xffff00b8ffff00b7,  0xffff00baffff00b9,  0xffff00bcffff00bb,  0xffff00beffff00bd,  0xffff00c0ffff00bf,  0xffff00c2ffff00c1,  0xffff00c4ffff00c3,  0xffff00c6ffff00c5,  0xffff00c8ffff00c7,  0xffff00caffff00c9,  0xffff00ccffff00cb,  0xffff00ceffff00cd,  0xffff00d0ffff00cf,  0xffff00d2ffff00d1,  0xffff00d4ffff00d3,  0xffffffffffffffff,  0xd600d5ffffffff,  0xffff00d800d7ffff,  0xdaffff00d9ffff,  0xffff00dd00dc00db,  0xffff00dfffff00de,  0xffff00e1ffff00e0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff00e3ffff00e2,  0xffff00e4ffffffff,  0xffffffffffffffff,  0xe5ffffffffffff,  0xffffffffffffffff,  0xffff00e6ffffffff,  0xffff00e900e800e7,  0xec00ebffff00ea,  0xef00ee00ed05aa,  0xf300f200f100f0,  0xf700f600f500f4,  0xfb00fa00f900f8,  0xfeffff00fd00fc,  0x1020101010000ff,  0x106010501040103,  0xffffffffffffffff,  0xffffffffffff05ab,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x107ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0109ffff0108,  0xffff010bffff010a,  0xffff010dffff010c,  0xffff010fffff010e,  0xffff0111ffff0110,  0xffff0113ffff0112,  0xffffffffffffffff,  0x115ffffffff0114,  0xffff01170116ffff,  0x11a01190118ffff,  0x11e011d011c011b,  0x12201210120011f,  0x126012501240123,  0x12a012901280127,  0x12e012d012c012b,  0x13201310130012f,  0x136013501340133,  0x13a013901380137,  0x13e013d013c013b,  0x14201410140013f,  0x146014501440143,  0x14a014901480147,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff014cffff014b,  0xffff014effff014d,  0xffff0150ffff014f,  0xffff0152ffff0151,  0xffff0154ffff0153,  0xffff0156ffff0155,  0xffff0158ffff0157,  0xffff015affff0159,  0xffffffffffff015b,  0xffffffffffffffff,  0xffff015cffffffff,  0xffff015effff015d,  0xffff0160ffff015f,  0xffff0162ffff0161,  0xffff0164ffff0163,  0xffff0166ffff0165,  0xffff0168ffff0167,  0xffff016affff0169,  0xffff016cffff016b,  0xffff016effff016d,  0xffff0170ffff016f,  0xffff0172ffff0171,  0xffff0174ffff0173,  0xffff0176ffff0175,  0x179ffff01780177,  0x17bffff017affff,  0x17dffff017cffff,  0xffffffff017effff,  0xffff0180ffff017f,  0xffff0182ffff0181,  0xffff0184ffff0183,  0xffff0186ffff0185,  0xffff0188ffff0187,  0xffff018affff0189,  0xffff018cffff018b,  0xffff018effff018d,  0xffff0190ffff018f,  0xffff0192ffff0191,  0xffff0194ffff0193,  0xffff0196ffff0195,  0xffff0198ffff0197,  0xffff019affff0199,  0xffff019cffff019b,  0xffff019effff019d,  0xffff01a0ffff019f,  0xffff01a2ffff01a1,  0xffff01a4ffff01a3,  0xffff01a6ffff01a5,  0xffff01a8ffff01a7,  0xffff01aaffff01a9,  0xffff01acffff01ab,  0xffff01aeffff01ad,  0x1b101b001afffff,  0x1b501b401b301b2,  0x1b901b801b701b6,  0x1bd01bc01bb01ba,  0x1c101c001bf01be,  0x1c501c401c301c2,  0x1c901c801c701c6,  0x1cd01cc01cb01ca,  0x1d101d001cf01ce,  0xffff01d401d301d2,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x5a3ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1d801d701d601d5,  0x1dc01db01da01d9,  0x1e001df01de01dd,  0x1e401e301e201e1,  0x1e801e701e601e5,  0x1ec01eb01ea01e9,  0x1f001ef01ee01ed,  0x1f401f301f201f1,  0x1f801f701f601f5,  0x1fbffff01fa01f9,  0xffffffffffffffff,  0xffffffff01fcffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x20001ff01fe01fd,  0x204020302020201,  0x208020702060205,  0x20c020b020a0209,  0x210020f020e020d,  0x214021302120211,  0x218021702160215,  0x21c021b021a0219,  0x220021f021e021d,  0x224022302220221,  0x228022702260225,  0x22c022b022a0229,  0x230022f022e022d,  0x234023302320231,  0x238023702360235,  0x23c023b023a0239,  0x240023f023e023d,  0x244024302420241,  0x248024702460245,  0x24c024b024a0249,  0x250024f024e024d,  0xffffffff02520251,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x256025502540253,  0x25a025902580257,  0x25e025d025c025b,  0x26202610260025f,  0x266026502640263,  0x26a026902680267,  0x26e026d026c026b,  0x27202710270026f,  0x276027502740273,  0x27a027902780277,  0xffff027d027c027b,  0x280027f027effff,  0xffff0282ffff0281,  0xffff0284ffff0283,  0xffff0286ffff0285,  0xffff0288ffff0287,  0xffff028affff0289,  0xffff028cffff028b,  0xffff028effff028d,  0xffff0290ffff028f,  0xffff0292ffff0291,  0xffff0294ffff0293,  0xffff0296ffff0295,  0xffff0298ffff0297,  0xffff029affff0299,  0xffff029cffff029b,  0xffff029effff029d,  0xffff02a0ffff029f,  0xffff02a2ffff02a1,  0xffff02a4ffff02a3,  0xffff02a6ffff02a5,  0xffff02a8ffff02a7,  0xffff02aaffff02a9,  0xffff02acffff02ab,  0xffff02aeffff02ad,  0xffff02b0ffff02af,  0xffff02b2ffff02b1,  0xffff02b4ffff02b3,  0xffff02b6ffff02b5,  0xffff02b8ffff02b7,  0xffff02baffff02b9,  0xffff02bcffff02bb,  0xffff02beffff02bd,  0xffff02c0ffff02bf,  0xffff02c2ffff02c1,  0xffff02c4ffff02c3,  0xffff02c6ffff02c5,  0xffff02c8ffff02c7,  0xffff02caffff02c9,  0x5ae05adffff02cb,  0xffff05b105b005af,  0xffff02ccffffffff,  0xffff02ceffff02cd,  0xffff02d0ffff02cf,  0xffff02d2ffff02d1,  0xffff02d4ffff02d3,  0xffff02d6ffff02d5,  0xffff02d8ffff02d7,  0xffff02daffff02d9,  0xffff02dcffff02db,  0xffff02deffff02dd,  0xffff02e0ffff02df,  0xffff02e2ffff02e1,  0xffff02e4ffff02e3,  0xffff02e6ffff02e5,  0xffff02e8ffff02e7,  0xffff02eaffff02e9,  0xffff02ecffff02eb,  0xffff02eeffff02ed,  0xffff02f0ffff02ef,  0xffff02f2ffff02f1,  0xffff02f4ffff02f3,  0xffff02f6ffff02f5,  0xffff02f8ffff02f7,  0xffff02faffff02f9,  0xffff02fcffff02fb,  0xffffffffffffffff,  0xffffffffffffffff,  0x30002ff02fe02fd,  0x304030303020301,  0xffffffffffffffff,  0xffffffffffffffff,  0x308030703060305,  0xffffffff030a0309,  0xffffffffffffffff,  0xffffffffffffffff,  0x30e030d030c030b,  0x31203110310030f,  0xffffffffffffffff,  0xffffffffffffffff,  0x316031503140313,  0x31a031903180317,  0xffffffffffffffff,  0xffffffffffffffff,  0x31e031d031c031b,  0xffffffff0320031f,  0xffff05b3ffff05b2,  0xffff05b5ffff05b4,  0x322ffff0321ffff,  0x324ffff0323ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x328032703260325,  0x32c032b032a0329,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x5c505c405c305c2,  0x5c905c805c705c6,  0x5cd05cc05cb05ca,  0x5d105d005cf05ce,  0x5d505d405d305d2,  0x5d905d805d705d6,  0x5dd05dc05db05da,  0x5e105e005df05de,  0x5e505e405e305e2,  0x5e905e805e705e6,  0x5ed05ec05eb05ea,  0x5f105f005ef05ee,  0x5f205f8ffffffff,  0x5fe05b6ffff05f9,  0x348034703460345,  0xffffffffffff05f3,  0x5f405faffffffff,  0x5ff05b7ffff05fb,  0x34d034c034b034a,  0xffffffffffff05f5,  0x5b905b8ffffffff,  0x5bb05baffffffff,  0x35203510350034f,  0xffffffffffffffff,  0x5bd05bcffffffff,  0x5c005bfffff05be,  0x356035503540353,  0xffffffffffff0357,  0x5f605fcffffffff,  0x60005c1ffff05fd,  0x35b035a03590358,  0xffffffffffff05f7,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff035dffffffff,  0x35f035effffffff,  0xffffffffffffffff,  0xffff0360ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x364036303620361,  0x368036703660365,  0x36c036b036a0369,  0x370036f036e036d,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x371ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3730372ffffffff,  0x377037603750374,  0x37b037a03790378,  0x37f037e037d037c,  0x383038203810380,  0x387038603850384,  0x38b038a03890388,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x38f038e038d038c,  0x393039203910390,  0x397039603950394,  0x39b039a03990398,  0x39f039e039d039c,  0x3a303a203a103a0,  0x3a703a603a503a4,  0x3ab03aa03a903a8,  0x3af03ae03ad03ac,  0x3b303b203b103b0,  0x3b703b603b503b4,  0x3bb03ba03b903b8,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3be03bdffff03bc,  0x3c0ffffffff03bf,  0x3c2ffff03c1ffff,  0x3c503c403c3ffff,  0xffff03c7ffff03c6,  0xffffffff03c8ffff,  0xffffffffffffffff,  0x3ca03c9ffffffff,  0xffff03ccffff03cb,  0xffff03ceffff03cd,  0xffff03d0ffff03cf,  0xffff03d2ffff03d1,  0xffff03d4ffff03d3,  0xffff03d6ffff03d5,  0xffff03d8ffff03d7,  0xffff03daffff03d9,  0xffff03dcffff03db,  0xffff03deffff03dd,  0xffff03e0ffff03df,  0xffff03e2ffff03e1,  0xffff03e4ffff03e3,  0xffff03e6ffff03e5,  0xffff03e8ffff03e7,  0xffff03eaffff03e9,  0xffff03ecffff03eb,  0xffff03eeffff03ed,  0xffff03f0ffff03ef,  0xffff03f2ffff03f1,  0xffff03f4ffff03f3,  0xffff03f6ffff03f5,  0xffff03f8ffff03f7,  0xffff03faffff03f9,  0xffff03fcffff03fb,  0xffffffffffffffff,  0x3fdffffffffffff,  0xffffffff03feffff,  0xffff03ffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0401ffff0400,  0xffff0403ffff0402,  0xffff0405ffff0404,  0xffff0407ffff0406,  0xffff0409ffff0408,  0xffff040bffff040a,  0xffff040dffff040c,  0xffff040fffff040e,  0xffff0411ffff0410,  0xffff0413ffff0412,  0xffff0415ffff0414,  0xffffffffffff0416,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0418ffff0417,  0xffff041affff0419,  0xffff041cffff041b,  0xffff041effff041d,  0xffff0420ffff041f,  0xffff0422ffff0421,  0xffff0424ffff0423,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0425ffffffff,  0xffff0427ffff0426,  0xffff0429ffff0428,  0xffff042bffff042a,  0xffff042cffffffff,  0xffff042effff042d,  0xffff0430ffff042f,  0xffff0432ffff0431,  0xffff0434ffff0433,  0xffff0436ffff0435,  0xffff0438ffff0437,  0xffff043affff0439,  0xffff043cffff043b,  0xffff043effff043d,  0xffff0440ffff043f,  0xffff0442ffff0441,  0xffff0444ffff0443,  0xffff0446ffff0445,  0xffff0448ffff0447,  0xffff044affff0449,  0xffffffffffffffff,  0xffffffffffffffff,  0x44cffff044bffff,  0xffff044e044dffff,  0xffff0450ffff044f,  0xffff0452ffff0451,  0x453ffffffffffff,  0xffffffff0454ffff,  0xffff0456ffff0455,  0xffff0457ffffffff,  0xffff0459ffff0458,  0xffff045bffff045a,  0xffff045dffff045c,  0xffff045fffff045e,  0x4620461ffff0460,  0xffff046504640463,  0x469046804670466,  0xffff046bffff046a,  0xffff046dffff046c,  0xffff046fffff046e,  0xffff0471ffff0470,  0x475047404730472,  0xffffffff0476ffff,  0xffffffffffffffff,  0xffffffffffff0477,  0xffff0478ffffffff,  0xffffffffffff0479,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff047affff,  0xffffffffffffffff,  0xffffffffffffffff,  0x59f059e059d059c,  0xffff05a205a105a0,  0xffffffffffffffff,  0xffffffffffffffff,  0x5a4ffffffffffff,  0x5a805a705a605a5,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x47d047c047bffff,  0x4810480047f047e,  0x485048404830482,  0x489048804870486,  0x48d048c048b048a,  0x4910490048f048e,  0xffff049404930492,  0xffffffffffffffff,  0x498049704960495,  0x49c049b049a0499,  0x4a0049f049e049d,  0x4a404a304a204a1,  0x4a804a704a604a5,  0x4ac04ab04aa04a9,  0x4b004af04ae04ad,  0x4b404b304b204b1,  0x4b804b704b604b5,  0x4bc04bb04ba04b9,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4c004bf04be04bd,  0x4c404c304c204c1,  0x4c804c704c604c5,  0x4cc04cb04ca04c9,  0x4d004cf04ce04cd,  0x4d404d304d204d1,  0x4d804d704d604d5,  0x4dc04db04da04d9,  0x4e004df04de04dd,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4e404e304e204e1,  0x4e804e704e604e5,  0xffff04eb04ea04e9,  0x4ef04ee04ed04ec,  0x4f304f204f104f0,  0x4f704f604f504f4,  0xffff04fa04f904f8,  0x4fe04fd04fc04fb,  0xffff0501050004ff,  0xffffffff05030502,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x507050605050504,  0x50b050a05090508,  0x50f050e050d050c,  0x513051205110510,  0x517051605150514,  0x51b051a05190518,  0x51f051e051d051c,  0x523052205210520,  0x527052605250524,  0x52b052a05290528,  0x52f052e052d052c,  0x533053205310530,  0xffff053605350534,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x53a053905380537,  0x53e053d053c053b,  0x54205410540053f,  0x546054505440543,  0x54a054905480547,  0x54e054d054c054b,  0x55205510550054f,  0x556055505540553,  0x55a055905580557,  0x55e055d055c055b,  0x56205610560055f,  0x566056505640563,  0x56a056905680567,  0x56e056d056c056b,  0x57205710570056f,  0x576057505740573,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x57a057905780577,  0x57e057d057c057b,  0x58205810580057f,  0x586058505840583,  0x58a058905880587,  0x58e058d058c058b,  0x59205910590058f,  0x596059505940593,  0xffffffff05980597,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff]);
//10496 bytes
enum toTitleIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x20,  0x140], [ 0x100,  0x480,  0xf80], [ 0x402030202020100,  0x702020206020205,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x3000200010000,  0x7000600050004,  0xa00090008,  0xd000c000b0000,  0x110010000f000e,  0x1400130012,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x15000000000000,  0x0,  0x0,  0x16000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1700000000,  0x1900180000,  0x1d001c001b001a,  0x210020001f001e,  0x0,  0x2300220000,  0x0,  0x0,  0x24000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x28002700260025,  0x29,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2b002a0000,  0x2f002e002d002c,  0x0,  0x0,  0x0,  0x3100300000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x32,  0x0,  0x0,  0x0,  0x330000,  0x0,  0x0,  0x0,  0x0,  0x36000000350034,  0x3700000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x38000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x39000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3a0000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3c003b,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x200010000ffff,  0x6000500040003,  0xa000900080007,  0xe000d000c000b,  0x1200110010000f,  0x16001500140013,  0xffff001900180017,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff001affff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x5aeffffffffffff,  0x1e001d001c001b,  0x2200210020001f,  0x26002500240023,  0x2a002900280027,  0x2e002d002c002b,  0xffff00310030002f,  0x35003400330032,  0x39003800370036,  0x3bffff003affff,  0x3dffff003cffff,  0x3fffff003effff,  0x41ffff0040ffff,  0x43ffff0042ffff,  0x45ffff0044ffff,  0x47ffff0046ffff,  0x49ffff0048ffff,  0x4bffff004affff,  0x4dffff004cffff,  0x4fffff004effff,  0x51ffff0050ffff,  0x53ffff005205b0,  0x55ffff0054ffff,  0xffff0056ffffffff,  0xffff0058ffff0057,  0xffff005affff0059,  0xffff005cffff005b,  0x5effff05cd005d,  0x60ffff005fffff,  0x62ffff0061ffff,  0x64ffff0063ffff,  0x66ffff0065ffff,  0x68ffff0067ffff,  0x6affff0069ffff,  0x6cffff006bffff,  0x6effff006dffff,  0x70ffff006fffff,  0x72ffff0071ffff,  0x74ffff0073ffff,  0xffff0075ffffffff,  0x780077ffff0076,  0x7affffffff0079,  0xffffffff007bffff,  0xffffffffffff007c,  0xffffffffffff007d,  0xffff007effffffff,  0xffffffff007fffff,  0xffff00810080ffff,  0xffff0082ffffffff,  0x84ffff0083ffff,  0xffffffff0085ffff,  0xffffffffffff0086,  0xffffffff0087ffff,  0xffffffffffff0088,  0xffff008affff0089,  0xffffffff008bffff,  0x8dffff008cffff,  0xffffffffffffffff,  0x910090008f008e,  0x95009400930092,  0xffff0097ffff0096,  0xffff0099ffff0098,  0xffff009bffff009a,  0xffff009dffff009c,  0xa0ffff009f009e,  0xa2ffff00a1ffff,  0xa4ffff00a3ffff,  0xa6ffff00a5ffff,  0xa8ffff00a7ffff,  0xab00aa00a905d5,  0xffffffff00acffff,  0xaeffff00adffff,  0xb0ffff00afffff,  0xb2ffff00b1ffff,  0xb4ffff00b3ffff,  0xb6ffff00b5ffff,  0xb8ffff00b7ffff,  0xbaffff00b9ffff,  0xbcffff00bbffff,  0xbeffff00bdffff,  0xc0ffff00bfffff,  0xc1ffffffffffff,  0xc3ffff00c2ffff,  0xc5ffff00c4ffff,  0xc7ffff00c6ffff,  0xc9ffff00c8ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xcbffffffff00ca,  0xffff00cdffff00cc,  0xceffffffffffff,  0xd0ffff00cfffff,  0xd2ffff00d1ffff,  0xd600d500d400d3,  0xd900d8ffff00d7,  0xdbffff00daffff,  0xffffffffffff00dc,  0xdfffff00de00dd,  0xffff00e100e0ffff,  0xe500e400e300e2,  0xe7ffffffff00e6,  0xffff00e900e8ffff,  0xffffffff00eaffff,  0xffffffffffffffff,  0xffffffff00ebffff,  0xee00edffff00ec,  0xefffffffffffff,  0xf300f200f100f0,  0xffffffffffff00f4,  0xffff00f5ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff00f700f6ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff00f8ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfaffff00f9ffff,  0xfbffffffffffff,  0xfcffffffffffff,  0xffffffff00fe00fd,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffff05cf,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1020101010000ff,  0x1050104010305d2,  0x109010801070106,  0x10d010c010b010a,  0x1110110010f010e,  0x115011401130112,  0x119011801170116,  0x11d011c011b011a,  0xffff0120011f011e,  0xffffffff01220121,  0x12501240123ffff,  0x127ffff0126ffff,  0x129ffff0128ffff,  0x12bffff012affff,  0x12dffff012cffff,  0x12fffff012effff,  0x131ffff0130ffff,  0x135013401330132,  0xffffffff0136ffff,  0x138ffffffff0137,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x13c013b013a0139,  0x140013f013e013d,  0x144014301420141,  0x148014701460145,  0x14c014b014a0149,  0x150014f014e014d,  0x154015301520151,  0x158015701560155,  0x15c015b015a0159,  0x160015f015e015d,  0x164016301620161,  0x168016701660165,  0x16affff0169ffff,  0x16cffff016bffff,  0x16effff016dffff,  0x170ffff016fffff,  0x172ffff0171ffff,  0x174ffff0173ffff,  0x176ffff0175ffff,  0x178ffff0177ffff,  0xffffffff0179ffff,  0xffffffffffffffff,  0x17affffffffffff,  0x17cffff017bffff,  0x17effff017dffff,  0x180ffff017fffff,  0x182ffff0181ffff,  0x184ffff0183ffff,  0x186ffff0185ffff,  0x188ffff0187ffff,  0x18affff0189ffff,  0x18cffff018bffff,  0x18effff018dffff,  0x190ffff018fffff,  0x192ffff0191ffff,  0x194ffff0193ffff,  0xffff0195ffffffff,  0xffff0197ffff0196,  0xffff0199ffff0198,  0x19c019bffff019a,  0x19effff019dffff,  0x1a0ffff019fffff,  0x1a2ffff01a1ffff,  0x1a4ffff01a3ffff,  0x1a6ffff01a5ffff,  0x1a8ffff01a7ffff,  0x1aaffff01a9ffff,  0x1acffff01abffff,  0x1aeffff01adffff,  0x1b0ffff01afffff,  0x1b2ffff01b1ffff,  0x1b4ffff01b3ffff,  0x1b6ffff01b5ffff,  0x1b8ffff01b7ffff,  0x1baffff01b9ffff,  0x1bcffff01bbffff,  0x1beffff01bdffff,  0x1c0ffff01bfffff,  0x1c2ffff01c1ffff,  0x1c4ffff01c3ffff,  0x1c6ffff01c5ffff,  0x1c8ffff01c7ffff,  0x1caffff01c9ffff,  0x1ccffff01cbffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1cf01ce01cdffff,  0x1d301d201d101d0,  0x1d701d601d501d4,  0x1db01da01d901d8,  0x1df01de01dd01dc,  0x1e301e201e101e0,  0x1e701e601e501e4,  0x1eb01ea01e901e8,  0x1ef01ee01ed01ec,  0x5c101f201f101f0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1f601f501f401f3,  0x1fa01f901f801f7,  0x1fe01fd01fc01fb,  0x2020201020001ff,  0x206020502040203,  0x20a020902080207,  0x20e020d020c020b,  0x21202110210020f,  0x216021502140213,  0x21a021902180217,  0xffff021d021c021b,  0x220021f021effff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x224022302220221,  0xffffffff02260225,  0x22a022902280227,  0x22e022d022c022b,  0xffffffffffff022f,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff0230ffff,  0xffffffff0231ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0232ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x234ffff0233ffff,  0x236ffff0235ffff,  0x238ffff0237ffff,  0x23affff0239ffff,  0x23cffff023bffff,  0x23effff023dffff,  0x240ffff023fffff,  0x242ffff0241ffff,  0x244ffff0243ffff,  0x246ffff0245ffff,  0x248ffff0247ffff,  0x24affff0249ffff,  0x24cffff024bffff,  0x24effff024dffff,  0x250ffff024fffff,  0x252ffff0251ffff,  0x254ffff0253ffff,  0x256ffff0255ffff,  0x258ffff0257ffff,  0x25affff0259ffff,  0x25cffff025bffff,  0x25effff025dffff,  0x260ffff025fffff,  0x262ffff0261ffff,  0x264ffff0263ffff,  0x266ffff0265ffff,  0x268ffff0267ffff,  0x26affff0269ffff,  0x26cffff026bffff,  0x26effff026dffff,  0x270ffff026fffff,  0x272ffff0271ffff,  0x274ffff0273ffff,  0x276ffff0275ffff,  0x278ffff0277ffff,  0x27affff0279ffff,  0x27cffff027bffff,  0x5d905d7027dffff,  0x27e05df05dd05db,  0xffffffffffffffff,  0x280ffff027fffff,  0x282ffff0281ffff,  0x284ffff0283ffff,  0x286ffff0285ffff,  0x288ffff0287ffff,  0x28affff0289ffff,  0x28cffff028bffff,  0x28effff028dffff,  0x290ffff028fffff,  0x292ffff0291ffff,  0x294ffff0293ffff,  0x296ffff0295ffff,  0x298ffff0297ffff,  0x29affff0299ffff,  0x29cffff029bffff,  0x29effff029dffff,  0x2a0ffff029fffff,  0x2a2ffff02a1ffff,  0x2a4ffff02a3ffff,  0x2a6ffff02a5ffff,  0x2a8ffff02a7ffff,  0x2aaffff02a9ffff,  0x2acffff02abffff,  0x2aeffff02adffff,  0x2b202b102b002af,  0x2b602b502b402b3,  0xffffffffffffffff,  0xffffffffffffffff,  0x2ba02b902b802b7,  0xffffffff02bc02bb,  0xffffffffffffffff,  0xffffffffffffffff,  0x2c002bf02be02bd,  0x2c402c302c202c1,  0xffffffffffffffff,  0xffffffffffffffff,  0x2c802c702c602c5,  0x2cc02cb02ca02c9,  0xffffffffffffffff,  0xffffffffffffffff,  0x2d002cf02ce02cd,  0xffffffff02d202d1,  0xffffffffffffffff,  0xffffffffffffffff,  0x2d405e302d305e1,  0x2d605e902d505e6,  0xffffffffffffffff,  0xffffffffffffffff,  0x2da02d902d802d7,  0x2de02dd02dc02db,  0xffffffffffffffff,  0xffffffffffffffff,  0x2e202e102e002df,  0x2e602e502e402e3,  0x2ea02e902e802e7,  0xffffffff02ec02eb,  0x60d060c060b060a,  0x6110610060f060e,  0x615061406130612,  0x619061806170616,  0x61d061c061b061a,  0x6210620061f061e,  0x625062406230622,  0x629062806270626,  0x62d062c062b062a,  0x6310630062f062e,  0x635063406330632,  0x639063806370636,  0x63a064003060305,  0x64c05ecffff0642,  0xffffffffffffffff,  0xffff0308ffff063b,  0x63c0644ffffffff,  0x64f05eeffff0646,  0xffffffffffffffff,  0xffffffffffff063d,  0x5f305f0030b030a,  0x5f805f6ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x5fe05fb030d030c,  0x6050603030e0601,  0xffffffffffffffff,  0xffffffffffffffff,  0x63e0648ffffffff,  0x6520608ffff064a,  0xffffffffffffffff,  0xffffffffffff063f,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0310ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x314031303120311,  0x318031703160315,  0x31c031b031a0319,  0x320031f031e031d,  0xffffffffffffffff,  0xffffffffffff0321,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x325032403230322,  0x329032803270326,  0x32d032c032b032a,  0x3310330032f032e,  0x335033403330332,  0x339033803370336,  0xffffffff033b033a,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x33f033e033d033c,  0x343034203410340,  0x347034603450344,  0x34b034a03490348,  0x34f034e034d034c,  0x353035203510350,  0x357035603550354,  0x35b035a03590358,  0x35f035e035d035c,  0x363036203610360,  0x367036603650364,  0x36b036a03690368,  0xffffffff036cffff,  0xffff036e036dffff,  0xffff0370ffff036f,  0xffffffffffff0371,  0x372ffffffffffff,  0xffff0373ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x375ffff0374ffff,  0x377ffff0376ffff,  0x379ffff0378ffff,  0x37bffff037affff,  0x37dffff037cffff,  0x37fffff037effff,  0x381ffff0380ffff,  0x383ffff0382ffff,  0x385ffff0384ffff,  0x387ffff0386ffff,  0x389ffff0388ffff,  0x38bffff038affff,  0x38dffff038cffff,  0x38fffff038effff,  0x391ffff0390ffff,  0x393ffff0392ffff,  0x395ffff0394ffff,  0x397ffff0396ffff,  0x399ffff0398ffff,  0x39bffff039affff,  0x39dffff039cffff,  0x39fffff039effff,  0x3a1ffff03a0ffff,  0x3a3ffff03a2ffff,  0x3a5ffff03a4ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff03a7ffff03a6,  0x3a8ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3ac03ab03aa03a9,  0x3b003af03ae03ad,  0x3b403b303b203b1,  0x3b803b703b603b5,  0x3bc03bb03ba03b9,  0x3c003bf03be03bd,  0x3c403c303c203c1,  0x3c803c703c603c5,  0x3cc03cb03ca03c9,  0x3cfffff03ce03cd,  0xffffffffffffffff,  0xffffffff03d0ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3d2ffff03d1ffff,  0x3d4ffff03d3ffff,  0x3d6ffff03d5ffff,  0x3d8ffff03d7ffff,  0x3daffff03d9ffff,  0x3dcffff03dbffff,  0x3deffff03ddffff,  0x3e0ffff03dfffff,  0x3e2ffff03e1ffff,  0x3e4ffff03e3ffff,  0x3e6ffff03e5ffff,  0xffffffff03e7ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3e9ffff03e8ffff,  0x3ebffff03eaffff,  0x3edffff03ecffff,  0x3efffff03eeffff,  0x3f1ffff03f0ffff,  0x3f3ffff03f2ffff,  0x3f5ffff03f4ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3f6ffffffffffff,  0x3f8ffff03f7ffff,  0x3faffff03f9ffff,  0x3fcffff03fbffff,  0x3fdffffffffffff,  0x3ffffff03feffff,  0x401ffff0400ffff,  0x403ffff0402ffff,  0x405ffff0404ffff,  0x407ffff0406ffff,  0x409ffff0408ffff,  0x40bffff040affff,  0x40dffff040cffff,  0x40fffff040effff,  0x411ffff0410ffff,  0x413ffff0412ffff,  0x415ffff0414ffff,  0x417ffff0416ffff,  0x419ffff0418ffff,  0x41bffff041affff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff041cffffffff,  0x41effffffff041d,  0x420ffff041fffff,  0x422ffff0421ffff,  0xffffffffffffffff,  0xffffffffffff0423,  0x425ffff0424ffff,  0x427ffffffff0426,  0x429ffff0428ffff,  0x42bffff042affff,  0x42dffff042cffff,  0x42fffff042effff,  0xffffffff0430ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x432ffff0431ffff,  0x434ffff0433ffff,  0x436ffff0435ffff,  0x438ffff0437ffff,  0xffffffffffffffff,  0xffff043affff0439,  0xffffffffffffffff,  0xffffffff043bffff,  0x43cffffffffffff,  0xffffffff043dffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff043effffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x43fffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x443044204410440,  0x447044604450444,  0x44b044a04490448,  0x44f044e044d044c,  0x453045204510450,  0x457045604550454,  0x45b045a04590458,  0x45f045e045d045c,  0x463046204610460,  0x467046604650464,  0x46b046a04690468,  0x46f046e046d046c,  0x473047204710470,  0x477047604750474,  0x47b047a04790478,  0x47f047e047d047c,  0x483048204810480,  0x487048604850484,  0x48b048a04890488,  0x48f048e048d048c,  0x5b705b505b305b1,  0xffff05bf05bd05ba,  0xffffffffffffffff,  0xffffffffffffffff,  0x5c3ffffffffffff,  0x5cb05c905c705c5,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x49204910490ffff,  0x496049504940493,  0x49a049904980497,  0x49e049d049c049b,  0x4a204a104a0049f,  0x4a604a504a404a3,  0xffff04a904a804a7,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4ad04ac04ab04aa,  0x4b104b004af04ae,  0x4b504b404b304b2,  0x4b904b804b704b6,  0x4bd04bc04bb04ba,  0x4c104c004bf04be,  0x4c504c404c304c2,  0x4c904c804c704c6,  0x4cd04cc04cb04ca,  0x4d104d004cf04ce,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4d504d404d304d2,  0x4d904d804d704d6,  0x4dd04dc04db04da,  0x4e104e004df04de,  0x4e504e404e304e2,  0x4e904e804e704e6,  0x4ed04ec04eb04ea,  0x4f104f004ef04ee,  0x4f504f404f304f2,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4f6ffffffffffff,  0x4fa04f904f804f7,  0x4fe04fd04fc04fb,  0x501ffff050004ff,  0x505050405030502,  0x509050805070506,  0x50d050c050b050a,  0x510ffff050f050e,  0x514051305120511,  0x517ffff05160515,  0xffffffffffff0518,  0x51c051b051a0519,  0x520051f051e051d,  0x524052305220521,  0x528052705260525,  0x52c052b052a0529,  0x530052f052e052d,  0x534053305320531,  0x538053705360535,  0x53c053b053a0539,  0x540053f053e053d,  0x544054305420541,  0x548054705460545,  0xffff054b054a0549,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x54f054e054d054c,  0x553055205510550,  0x557055605550554,  0x55b055a05590558,  0x55f055e055d055c,  0x563056205610560,  0x567056605650564,  0x56b056a05690568,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x56f056e056d056c,  0x573057205710570,  0x577057605750574,  0x57b057a05790578,  0x57f057e057d057c,  0x583058205810580,  0x587058605850584,  0x58b058a05890588,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x58d058cffffffff,  0x5910590058f058e,  0x595059405930592,  0x599059805970596,  0x59d059c059b059a,  0x5a105a0059f059e,  0x5a505a405a305a2,  0x5a905a805a705a6,  0x5ad05ac05ab05aa,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff]);
//10368 bytes
enum toUpperSimpleIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x20,  0x140], [ 0x100,  0x480,  0xf40], [ 0x402030202020100,  0x702020206020205,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x3000200010000,  0x7000600050004,  0xa00090008,  0xd000c000b0000,  0x110010000f000e,  0x1400130012,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x15000000000000,  0x0,  0x0,  0x16000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1700000000,  0x1900180000,  0x1d001c001b001a,  0x210020001f001e,  0x0,  0x2300220000,  0x0,  0x0,  0x24000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x28002700260025,  0x29,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2b002a0000,  0x2f002e002d002c,  0x0,  0x0,  0x0,  0x3100300000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x320000,  0x0,  0x0,  0x0,  0x0,  0x35000000340033,  0x3600000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x37000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x38000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x390000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3b003a,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x200010000ffff,  0x6000500040003,  0xa000900080007,  0xe000d000c000b,  0x1200110010000f,  0x16001500140013,  0xffff001900180017,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff001affff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1e001d001c001b,  0x2200210020001f,  0x26002500240023,  0x2a002900280027,  0x2e002d002c002b,  0xffff00310030002f,  0x35003400330032,  0x39003800370036,  0x3bffff003affff,  0x3dffff003cffff,  0x3fffff003effff,  0x41ffff0040ffff,  0x43ffff0042ffff,  0x45ffff0044ffff,  0x47ffff0046ffff,  0x49ffff0048ffff,  0x4bffff004affff,  0x4dffff004cffff,  0x4fffff004effff,  0x51ffff0050ffff,  0x53ffff0052ffff,  0x55ffff0054ffff,  0xffff0056ffffffff,  0xffff0058ffff0057,  0xffff005affff0059,  0xffff005cffff005b,  0x5effffffff005d,  0x60ffff005fffff,  0x62ffff0061ffff,  0x64ffff0063ffff,  0x66ffff0065ffff,  0x68ffff0067ffff,  0x6affff0069ffff,  0x6cffff006bffff,  0x6effff006dffff,  0x70ffff006fffff,  0x72ffff0071ffff,  0x74ffff0073ffff,  0xffff0075ffffffff,  0x780077ffff0076,  0x7affffffff0079,  0xffffffff007bffff,  0xffffffffffff007c,  0xffffffffffff007d,  0xffff007effffffff,  0xffffffff007fffff,  0xffff00810080ffff,  0xffff0082ffffffff,  0x84ffff0083ffff,  0xffffffff0085ffff,  0xffffffffffff0086,  0xffffffff0087ffff,  0xffffffffffff0088,  0xffff008affff0089,  0xffffffff008bffff,  0x8dffff008cffff,  0xffffffffffffffff,  0xffff008f008effff,  0x92ffff00910090,  0xffff0094ffff0093,  0xffff0096ffff0095,  0xffff0098ffff0097,  0xffff009affff0099,  0x9dffff009c009b,  0x9fffff009effff,  0xa1ffff00a0ffff,  0xa3ffff00a2ffff,  0xa5ffff00a4ffff,  0xa700a6ffffffff,  0xffffffff00a8ffff,  0xaaffff00a9ffff,  0xacffff00abffff,  0xaeffff00adffff,  0xb0ffff00afffff,  0xb2ffff00b1ffff,  0xb4ffff00b3ffff,  0xb6ffff00b5ffff,  0xb8ffff00b7ffff,  0xbaffff00b9ffff,  0xbcffff00bbffff,  0xbdffffffffffff,  0xbfffff00beffff,  0xc1ffff00c0ffff,  0xc3ffff00c2ffff,  0xc5ffff00c4ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xc7ffffffff00c6,  0xffff00c9ffff00c8,  0xcaffffffffffff,  0xccffff00cbffff,  0xceffff00cdffff,  0xd200d100d000cf,  0xd500d4ffff00d3,  0xd7ffff00d6ffff,  0xffffffffffff00d8,  0xdbffff00da00d9,  0xffff00dd00dcffff,  0xe100e000df00de,  0xe3ffffffff00e2,  0xffff00e500e4ffff,  0xffffffff00e6ffff,  0xffffffffffffffff,  0xffffffff00e7ffff,  0xea00e9ffff00e8,  0xebffffffffffff,  0xef00ee00ed00ec,  0xffffffffffff00f0,  0xffff00f1ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff00f300f2ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff00f4ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xf6ffff00f5ffff,  0xf7ffffffffffff,  0xf8ffffffffffff,  0xffffffff00fa00f9,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfe00fd00fc00fb,  0x101010000ffffff,  0x105010401030102,  0x109010801070106,  0x10d010c010b010a,  0x1110110010f010e,  0x115011401130112,  0x119011801170116,  0xffff011c011b011a,  0xffffffff011e011d,  0x1210120011fffff,  0x123ffff0122ffff,  0x125ffff0124ffff,  0x127ffff0126ffff,  0x129ffff0128ffff,  0x12bffff012affff,  0x12dffff012cffff,  0x1310130012f012e,  0xffffffff0132ffff,  0x134ffffffff0133,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x138013701360135,  0x13c013b013a0139,  0x140013f013e013d,  0x144014301420141,  0x148014701460145,  0x14c014b014a0149,  0x150014f014e014d,  0x154015301520151,  0x158015701560155,  0x15c015b015a0159,  0x160015f015e015d,  0x164016301620161,  0x166ffff0165ffff,  0x168ffff0167ffff,  0x16affff0169ffff,  0x16cffff016bffff,  0x16effff016dffff,  0x170ffff016fffff,  0x172ffff0171ffff,  0x174ffff0173ffff,  0xffffffff0175ffff,  0xffffffffffffffff,  0x176ffffffffffff,  0x178ffff0177ffff,  0x17affff0179ffff,  0x17cffff017bffff,  0x17effff017dffff,  0x180ffff017fffff,  0x182ffff0181ffff,  0x184ffff0183ffff,  0x186ffff0185ffff,  0x188ffff0187ffff,  0x18affff0189ffff,  0x18cffff018bffff,  0x18effff018dffff,  0x190ffff018fffff,  0xffff0191ffffffff,  0xffff0193ffff0192,  0xffff0195ffff0194,  0x1980197ffff0196,  0x19affff0199ffff,  0x19cffff019bffff,  0x19effff019dffff,  0x1a0ffff019fffff,  0x1a2ffff01a1ffff,  0x1a4ffff01a3ffff,  0x1a6ffff01a5ffff,  0x1a8ffff01a7ffff,  0x1aaffff01a9ffff,  0x1acffff01abffff,  0x1aeffff01adffff,  0x1b0ffff01afffff,  0x1b2ffff01b1ffff,  0x1b4ffff01b3ffff,  0x1b6ffff01b5ffff,  0x1b8ffff01b7ffff,  0x1baffff01b9ffff,  0x1bcffff01bbffff,  0x1beffff01bdffff,  0x1c0ffff01bfffff,  0x1c2ffff01c1ffff,  0x1c4ffff01c3ffff,  0x1c6ffff01c5ffff,  0x1c8ffff01c7ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1cb01ca01c9ffff,  0x1cf01ce01cd01cc,  0x1d301d201d101d0,  0x1d701d601d501d4,  0x1db01da01d901d8,  0x1df01de01dd01dc,  0x1e301e201e101e0,  0x1e701e601e501e4,  0x1eb01ea01e901e8,  0xffff01ee01ed01ec,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1f201f101f001ef,  0x1f601f501f401f3,  0x1fa01f901f801f7,  0x1fe01fd01fc01fb,  0x2020201020001ff,  0x206020502040203,  0x20a020902080207,  0x20e020d020c020b,  0x21202110210020f,  0x216021502140213,  0xffff021902180217,  0x21c021b021affff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x220021f021e021d,  0xffffffff02220221,  0x226022502240223,  0x22a022902280227,  0xffffffffffff022b,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff022cffff,  0xffffffff022dffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff022effffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x230ffff022fffff,  0x232ffff0231ffff,  0x234ffff0233ffff,  0x236ffff0235ffff,  0x238ffff0237ffff,  0x23affff0239ffff,  0x23cffff023bffff,  0x23effff023dffff,  0x240ffff023fffff,  0x242ffff0241ffff,  0x244ffff0243ffff,  0x246ffff0245ffff,  0x248ffff0247ffff,  0x24affff0249ffff,  0x24cffff024bffff,  0x24effff024dffff,  0x250ffff024fffff,  0x252ffff0251ffff,  0x254ffff0253ffff,  0x256ffff0255ffff,  0x258ffff0257ffff,  0x25affff0259ffff,  0x25cffff025bffff,  0x25effff025dffff,  0x260ffff025fffff,  0x262ffff0261ffff,  0x264ffff0263ffff,  0x266ffff0265ffff,  0x268ffff0267ffff,  0x26affff0269ffff,  0x26cffff026bffff,  0x26effff026dffff,  0x270ffff026fffff,  0x272ffff0271ffff,  0x274ffff0273ffff,  0x276ffff0275ffff,  0x278ffff0277ffff,  0xffffffff0279ffff,  0x27affffffffffff,  0xffffffffffffffff,  0x27cffff027bffff,  0x27effff027dffff,  0x280ffff027fffff,  0x282ffff0281ffff,  0x284ffff0283ffff,  0x286ffff0285ffff,  0x288ffff0287ffff,  0x28affff0289ffff,  0x28cffff028bffff,  0x28effff028dffff,  0x290ffff028fffff,  0x292ffff0291ffff,  0x294ffff0293ffff,  0x296ffff0295ffff,  0x298ffff0297ffff,  0x29affff0299ffff,  0x29cffff029bffff,  0x29effff029dffff,  0x2a0ffff029fffff,  0x2a2ffff02a1ffff,  0x2a4ffff02a3ffff,  0x2a6ffff02a5ffff,  0x2a8ffff02a7ffff,  0x2aaffff02a9ffff,  0x2ae02ad02ac02ab,  0x2b202b102b002af,  0xffffffffffffffff,  0xffffffffffffffff,  0x2b602b502b402b3,  0xffffffff02b802b7,  0xffffffffffffffff,  0xffffffffffffffff,  0x2bc02bb02ba02b9,  0x2c002bf02be02bd,  0xffffffffffffffff,  0xffffffffffffffff,  0x2c402c302c202c1,  0x2c802c702c602c5,  0xffffffffffffffff,  0xffffffffffffffff,  0x2cc02cb02ca02c9,  0xffffffff02ce02cd,  0xffffffffffffffff,  0xffffffffffffffff,  0x2d0ffff02cfffff,  0x2d2ffff02d1ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x2d602d502d402d3,  0x2da02d902d802d7,  0xffffffffffffffff,  0xffffffffffffffff,  0x2de02dd02dc02db,  0x2e202e102e002df,  0x2e602e502e402e3,  0xffffffff02e802e7,  0x2ec02eb02ea02e9,  0x2f002ef02ee02ed,  0xffffffffffffffff,  0xffffffffffffffff,  0x2f402f302f202f1,  0x2f802f702f602f5,  0xffffffffffffffff,  0xffffffffffffffff,  0x2fc02fb02fa02f9,  0x30002ff02fe02fd,  0xffffffffffffffff,  0xffffffffffffffff,  0x303ffff03020301,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0304ffffffff,  0x305ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff03070306,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff03090308,  0xffffffff030affff,  0xffffffffffffffff,  0xffffffffffffffff,  0x30bffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff030cffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x310030f030e030d,  0x314031303120311,  0x318031703160315,  0x31c031b031a0319,  0xffffffffffffffff,  0xffffffffffff031d,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3210320031f031e,  0x325032403230322,  0x329032803270326,  0x32d032c032b032a,  0x3310330032f032e,  0x335033403330332,  0xffffffff03370336,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x33b033a03390338,  0x33f033e033d033c,  0x343034203410340,  0x347034603450344,  0x34b034a03490348,  0x34f034e034d034c,  0x353035203510350,  0x357035603550354,  0x35b035a03590358,  0x35f035e035d035c,  0x363036203610360,  0x367036603650364,  0xffffffff0368ffff,  0xffff036a0369ffff,  0xffff036cffff036b,  0xffffffffffff036d,  0x36effffffffffff,  0xffff036fffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x371ffff0370ffff,  0x373ffff0372ffff,  0x375ffff0374ffff,  0x377ffff0376ffff,  0x379ffff0378ffff,  0x37bffff037affff,  0x37dffff037cffff,  0x37fffff037effff,  0x381ffff0380ffff,  0x383ffff0382ffff,  0x385ffff0384ffff,  0x387ffff0386ffff,  0x389ffff0388ffff,  0x38bffff038affff,  0x38dffff038cffff,  0x38fffff038effff,  0x391ffff0390ffff,  0x393ffff0392ffff,  0x395ffff0394ffff,  0x397ffff0396ffff,  0x399ffff0398ffff,  0x39bffff039affff,  0x39dffff039cffff,  0x39fffff039effff,  0x3a1ffff03a0ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff03a3ffff03a2,  0x3a4ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3a803a703a603a5,  0x3ac03ab03aa03a9,  0x3b003af03ae03ad,  0x3b403b303b203b1,  0x3b803b703b603b5,  0x3bc03bb03ba03b9,  0x3c003bf03be03bd,  0x3c403c303c203c1,  0x3c803c703c603c5,  0x3cbffff03ca03c9,  0xffffffffffffffff,  0xffffffff03ccffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3ceffff03cdffff,  0x3d0ffff03cfffff,  0x3d2ffff03d1ffff,  0x3d4ffff03d3ffff,  0x3d6ffff03d5ffff,  0x3d8ffff03d7ffff,  0x3daffff03d9ffff,  0x3dcffff03dbffff,  0x3deffff03ddffff,  0x3e0ffff03dfffff,  0x3e2ffff03e1ffff,  0xffffffff03e3ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3e5ffff03e4ffff,  0x3e7ffff03e6ffff,  0x3e9ffff03e8ffff,  0x3ebffff03eaffff,  0x3edffff03ecffff,  0x3efffff03eeffff,  0x3f1ffff03f0ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3f2ffffffffffff,  0x3f4ffff03f3ffff,  0x3f6ffff03f5ffff,  0x3f8ffff03f7ffff,  0x3f9ffffffffffff,  0x3fbffff03faffff,  0x3fdffff03fcffff,  0x3ffffff03feffff,  0x401ffff0400ffff,  0x403ffff0402ffff,  0x405ffff0404ffff,  0x407ffff0406ffff,  0x409ffff0408ffff,  0x40bffff040affff,  0x40dffff040cffff,  0x40fffff040effff,  0x411ffff0410ffff,  0x413ffff0412ffff,  0x415ffff0414ffff,  0x417ffff0416ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0418ffffffff,  0x41affffffff0419,  0x41cffff041bffff,  0x41effff041dffff,  0xffffffffffffffff,  0xffffffffffff041f,  0x421ffff0420ffff,  0x423ffffffff0422,  0x425ffff0424ffff,  0x427ffff0426ffff,  0x429ffff0428ffff,  0x42bffff042affff,  0xffffffff042cffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x42effff042dffff,  0x430ffff042fffff,  0x432ffff0431ffff,  0x434ffff0433ffff,  0xffffffffffffffff,  0xffff0436ffff0435,  0xffffffffffffffff,  0xffffffff0437ffff,  0x438ffffffffffff,  0xffffffff0439ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff043affffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x43bffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x43f043e043d043c,  0x443044204410440,  0x447044604450444,  0x44b044a04490448,  0x44f044e044d044c,  0x453045204510450,  0x457045604550454,  0x45b045a04590458,  0x45f045e045d045c,  0x463046204610460,  0x467046604650464,  0x46b046a04690468,  0x46f046e046d046c,  0x473047204710470,  0x477047604750474,  0x47b047a04790478,  0x47f047e047d047c,  0x483048204810480,  0x487048604850484,  0x48b048a04890488,  0x48e048d048cffff,  0x49204910490048f,  0x496049504940493,  0x49a049904980497,  0x49e049d049c049b,  0x4a204a104a0049f,  0xffff04a504a404a3,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4a904a804a704a6,  0x4ad04ac04ab04aa,  0x4b104b004af04ae,  0x4b504b404b304b2,  0x4b904b804b704b6,  0x4bd04bc04bb04ba,  0x4c104c004bf04be,  0x4c504c404c304c2,  0x4c904c804c704c6,  0x4cd04cc04cb04ca,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4d104d004cf04ce,  0x4d504d404d304d2,  0x4d904d804d704d6,  0x4dd04dc04db04da,  0x4e104e004df04de,  0x4e504e404e304e2,  0x4e904e804e704e6,  0x4ed04ec04eb04ea,  0x4f104f004ef04ee,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4f2ffffffffffff,  0x4f604f504f404f3,  0x4fa04f904f804f7,  0x4fdffff04fc04fb,  0x501050004ff04fe,  0x505050405030502,  0x509050805070506,  0x50cffff050b050a,  0x510050f050e050d,  0x513ffff05120511,  0xffffffffffff0514,  0x518051705160515,  0x51c051b051a0519,  0x520051f051e051d,  0x524052305220521,  0x528052705260525,  0x52c052b052a0529,  0x530052f052e052d,  0x534053305320531,  0x538053705360535,  0x53c053b053a0539,  0x540053f053e053d,  0x544054305420541,  0xffff054705460545,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x54b054a05490548,  0x54f054e054d054c,  0x553055205510550,  0x557055605550554,  0x55b055a05590558,  0x55f055e055d055c,  0x563056205610560,  0x567056605650564,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x56b056a05690568,  0x56f056e056d056c,  0x573057205710570,  0x577057605750574,  0x57b057a05790578,  0x57f057e057d057c,  0x583058205810580,  0x587058605850584,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x5890588ffffffff,  0x58d058c058b058a,  0x5910590058f058e,  0x595059405930592,  0x599059805970596,  0x59d059c059b059a,  0x5a105a0059f059e,  0x5a505a405a305a2,  0x5a905a805a705a6,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff]);
//9856 bytes
enum toLowerSimpleIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x20,  0x140], [ 0x100,  0x480,  0xe40], [ 0x402030202020100,  0x702020206020205,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x2000000010000,  0x6000500040003,  0x80007,  0xb000a00090000,  0xf000e000d000c,  0x110010,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x13001200000000,  0x0,  0x0,  0x15001400000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1600000000,  0x0,  0x1a001900180017,  0x1e001d001c001b,  0x0,  0x210020001f,  0x0,  0x0,  0x23002200000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x27002600250024,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2900280000,  0x2d002c002b002a,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2e,  0x0,  0x0,  0x0,  0x0,  0x3100300000002f,  0x3300320000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3400000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3500000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x360000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x37,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x200010000ffff,  0x6000500040003,  0xa000900080007,  0xe000d000c000b,  0x1200110010000f,  0x16001500140013,  0xffff001900180017,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1d001c001b001a,  0x210020001f001e,  0x25002400230022,  0x29002800270026,  0x2d002c002b002a,  0xffff0030002f002e,  0x34003300320031,  0xffff003700360035,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0039ffff0038,  0xffff003bffff003a,  0xffff003dffff003c,  0xffff003fffff003e,  0xffff0041ffff0040,  0xffff0043ffff0042,  0xffff0045ffff0044,  0xffff0047ffff0046,  0xffff0049ffff0048,  0xffff004bffff004a,  0xffff004dffff004c,  0xffff004fffff004e,  0xffff0051ffff0050,  0xffff0053ffff0052,  0x55ffff0054ffff,  0x57ffff0056ffff,  0x59ffff0058ffff,  0x5bffff005affff,  0xffff005cffffffff,  0xffff005effff005d,  0xffff0060ffff005f,  0xffff0062ffff0061,  0xffff0064ffff0063,  0xffff0066ffff0065,  0xffff0068ffff0067,  0xffff006affff0069,  0xffff006cffff006b,  0xffff006effff006d,  0xffff0070ffff006f,  0xffff0072ffff0071,  0x75ffff00740073,  0xffffffff0076ffff,  0xffff00780077ffff,  0x7b007affff0079,  0x7e007d007cffff,  0x80007fffffffff,  0x83ffff00820081,  0x860085ffff0084,  0xffffffffffff0087,  0x8affff00890088,  0xffff008cffff008b,  0x8f008effff008d,  0xffffffff0090ffff,  0x930092ffff0091,  0x9600950094ffff,  0x98ffff0097ffff,  0xffffffffffff0099,  0xffffffffffff009a,  0xffffffffffffffff,  0x9dffff009c009b,  0xa0009fffff009e,  0xa2ffff00a1ffff,  0xa4ffff00a3ffff,  0xa6ffff00a5ffff,  0xa8ffff00a7ffff,  0xffff00a9ffffffff,  0xffff00abffff00aa,  0xffff00adffff00ac,  0xffff00afffff00ae,  0xffff00b1ffff00b0,  0xffff00b300b2ffff,  0xb600b5ffff00b4,  0xffff00b8ffff00b7,  0xffff00baffff00b9,  0xffff00bcffff00bb,  0xffff00beffff00bd,  0xffff00c0ffff00bf,  0xffff00c2ffff00c1,  0xffff00c4ffff00c3,  0xffff00c6ffff00c5,  0xffff00c8ffff00c7,  0xffff00caffff00c9,  0xffff00ccffff00cb,  0xffff00ceffff00cd,  0xffff00d0ffff00cf,  0xffff00d2ffff00d1,  0xffff00d4ffff00d3,  0xffffffffffffffff,  0xd600d5ffffffff,  0xffff00d800d7ffff,  0xdaffff00d9ffff,  0xffff00dd00dc00db,  0xffff00dfffff00de,  0xffff00e1ffff00e0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff00e3ffff00e2,  0xffff00e4ffffffff,  0xffffffffffffffff,  0xe5ffffffffffff,  0xffffffffffffffff,  0xffff00e6ffffffff,  0xffff00e900e800e7,  0xec00ebffff00ea,  0xef00ee00edffff,  0xf300f200f100f0,  0xf700f600f500f4,  0xfb00fa00f900f8,  0xfeffff00fd00fc,  0x1020101010000ff,  0x106010501040103,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x107ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0109ffff0108,  0xffff010bffff010a,  0xffff010dffff010c,  0xffff010fffff010e,  0xffff0111ffff0110,  0xffff0113ffff0112,  0xffffffffffffffff,  0x115ffffffff0114,  0xffff01170116ffff,  0x11a01190118ffff,  0x11e011d011c011b,  0x12201210120011f,  0x126012501240123,  0x12a012901280127,  0x12e012d012c012b,  0x13201310130012f,  0x136013501340133,  0x13a013901380137,  0x13e013d013c013b,  0x14201410140013f,  0x146014501440143,  0x14a014901480147,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff014cffff014b,  0xffff014effff014d,  0xffff0150ffff014f,  0xffff0152ffff0151,  0xffff0154ffff0153,  0xffff0156ffff0155,  0xffff0158ffff0157,  0xffff015affff0159,  0xffffffffffff015b,  0xffffffffffffffff,  0xffff015cffffffff,  0xffff015effff015d,  0xffff0160ffff015f,  0xffff0162ffff0161,  0xffff0164ffff0163,  0xffff0166ffff0165,  0xffff0168ffff0167,  0xffff016affff0169,  0xffff016cffff016b,  0xffff016effff016d,  0xffff0170ffff016f,  0xffff0172ffff0171,  0xffff0174ffff0173,  0xffff0176ffff0175,  0x179ffff01780177,  0x17bffff017affff,  0x17dffff017cffff,  0xffffffff017effff,  0xffff0180ffff017f,  0xffff0182ffff0181,  0xffff0184ffff0183,  0xffff0186ffff0185,  0xffff0188ffff0187,  0xffff018affff0189,  0xffff018cffff018b,  0xffff018effff018d,  0xffff0190ffff018f,  0xffff0192ffff0191,  0xffff0194ffff0193,  0xffff0196ffff0195,  0xffff0198ffff0197,  0xffff019affff0199,  0xffff019cffff019b,  0xffff019effff019d,  0xffff01a0ffff019f,  0xffff01a2ffff01a1,  0xffff01a4ffff01a3,  0xffff01a6ffff01a5,  0xffff01a8ffff01a7,  0xffff01aaffff01a9,  0xffff01acffff01ab,  0xffff01aeffff01ad,  0x1b101b001afffff,  0x1b501b401b301b2,  0x1b901b801b701b6,  0x1bd01bc01bb01ba,  0x1c101c001bf01be,  0x1c501c401c301c2,  0x1c901c801c701c6,  0x1cd01cc01cb01ca,  0x1d101d001cf01ce,  0xffff01d401d301d2,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1d801d701d601d5,  0x1dc01db01da01d9,  0x1e001df01de01dd,  0x1e401e301e201e1,  0x1e801e701e601e5,  0x1ec01eb01ea01e9,  0x1f001ef01ee01ed,  0x1f401f301f201f1,  0x1f801f701f601f5,  0x1fbffff01fa01f9,  0xffffffffffffffff,  0xffffffff01fcffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x20001ff01fe01fd,  0x204020302020201,  0x208020702060205,  0x20c020b020a0209,  0x210020f020e020d,  0x214021302120211,  0x218021702160215,  0x21c021b021a0219,  0x220021f021e021d,  0x224022302220221,  0x228022702260225,  0x22c022b022a0229,  0x230022f022e022d,  0x234023302320231,  0x238023702360235,  0x23c023b023a0239,  0x240023f023e023d,  0x244024302420241,  0x248024702460245,  0x24c024b024a0249,  0x250024f024e024d,  0xffffffff02520251,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x256025502540253,  0x25a025902580257,  0x25e025d025c025b,  0x26202610260025f,  0x266026502640263,  0x26a026902680267,  0x26e026d026c026b,  0x27202710270026f,  0x276027502740273,  0x27a027902780277,  0xffff027d027c027b,  0x280027f027effff,  0xffff0282ffff0281,  0xffff0284ffff0283,  0xffff0286ffff0285,  0xffff0288ffff0287,  0xffff028affff0289,  0xffff028cffff028b,  0xffff028effff028d,  0xffff0290ffff028f,  0xffff0292ffff0291,  0xffff0294ffff0293,  0xffff0296ffff0295,  0xffff0298ffff0297,  0xffff029affff0299,  0xffff029cffff029b,  0xffff029effff029d,  0xffff02a0ffff029f,  0xffff02a2ffff02a1,  0xffff02a4ffff02a3,  0xffff02a6ffff02a5,  0xffff02a8ffff02a7,  0xffff02aaffff02a9,  0xffff02acffff02ab,  0xffff02aeffff02ad,  0xffff02b0ffff02af,  0xffff02b2ffff02b1,  0xffff02b4ffff02b3,  0xffff02b6ffff02b5,  0xffff02b8ffff02b7,  0xffff02baffff02b9,  0xffff02bcffff02bb,  0xffff02beffff02bd,  0xffff02c0ffff02bf,  0xffff02c2ffff02c1,  0xffff02c4ffff02c3,  0xffff02c6ffff02c5,  0xffff02c8ffff02c7,  0xffff02caffff02c9,  0xffffffffffff02cb,  0xffffffffffffffff,  0xffff02ccffffffff,  0xffff02ceffff02cd,  0xffff02d0ffff02cf,  0xffff02d2ffff02d1,  0xffff02d4ffff02d3,  0xffff02d6ffff02d5,  0xffff02d8ffff02d7,  0xffff02daffff02d9,  0xffff02dcffff02db,  0xffff02deffff02dd,  0xffff02e0ffff02df,  0xffff02e2ffff02e1,  0xffff02e4ffff02e3,  0xffff02e6ffff02e5,  0xffff02e8ffff02e7,  0xffff02eaffff02e9,  0xffff02ecffff02eb,  0xffff02eeffff02ed,  0xffff02f0ffff02ef,  0xffff02f2ffff02f1,  0xffff02f4ffff02f3,  0xffff02f6ffff02f5,  0xffff02f8ffff02f7,  0xffff02faffff02f9,  0xffff02fcffff02fb,  0xffffffffffffffff,  0xffffffffffffffff,  0x30002ff02fe02fd,  0x304030303020301,  0xffffffffffffffff,  0xffffffffffffffff,  0x308030703060305,  0xffffffff030a0309,  0xffffffffffffffff,  0xffffffffffffffff,  0x30e030d030c030b,  0x31203110310030f,  0xffffffffffffffff,  0xffffffffffffffff,  0x316031503140313,  0x31a031903180317,  0xffffffffffffffff,  0xffffffffffffffff,  0x31e031d031c031b,  0xffffffff0320031f,  0xffffffffffffffff,  0xffffffffffffffff,  0x322ffff0321ffff,  0x324ffff0323ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x328032703260325,  0x32c032b032a0329,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x330032f032e032d,  0x334033303320331,  0xffffffffffffffff,  0xffffffffffffffff,  0x338033703360335,  0x33c033b033a0339,  0xffffffffffffffff,  0xffffffffffffffff,  0x340033f033e033d,  0x344034303420341,  0xffffffffffffffff,  0xffffffffffffffff,  0x348034703460345,  0xffffffffffff0349,  0xffffffffffffffff,  0xffffffffffffffff,  0x34d034c034b034a,  0xffffffffffff034e,  0xffffffffffffffff,  0xffffffffffffffff,  0x35203510350034f,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x356035503540353,  0xffffffffffff0357,  0xffffffffffffffff,  0xffffffffffffffff,  0x35b035a03590358,  0xffffffffffff035c,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff035dffffffff,  0x35f035effffffff,  0xffffffffffffffff,  0xffff0360ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x364036303620361,  0x368036703660365,  0x36c036b036a0369,  0x370036f036e036d,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x371ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3730372ffffffff,  0x377037603750374,  0x37b037a03790378,  0x37f037e037d037c,  0x383038203810380,  0x387038603850384,  0x38b038a03890388,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x38f038e038d038c,  0x393039203910390,  0x397039603950394,  0x39b039a03990398,  0x39f039e039d039c,  0x3a303a203a103a0,  0x3a703a603a503a4,  0x3ab03aa03a903a8,  0x3af03ae03ad03ac,  0x3b303b203b103b0,  0x3b703b603b503b4,  0x3bb03ba03b903b8,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3be03bdffff03bc,  0x3c0ffffffff03bf,  0x3c2ffff03c1ffff,  0x3c503c403c3ffff,  0xffff03c7ffff03c6,  0xffffffff03c8ffff,  0xffffffffffffffff,  0x3ca03c9ffffffff,  0xffff03ccffff03cb,  0xffff03ceffff03cd,  0xffff03d0ffff03cf,  0xffff03d2ffff03d1,  0xffff03d4ffff03d3,  0xffff03d6ffff03d5,  0xffff03d8ffff03d7,  0xffff03daffff03d9,  0xffff03dcffff03db,  0xffff03deffff03dd,  0xffff03e0ffff03df,  0xffff03e2ffff03e1,  0xffff03e4ffff03e3,  0xffff03e6ffff03e5,  0xffff03e8ffff03e7,  0xffff03eaffff03e9,  0xffff03ecffff03eb,  0xffff03eeffff03ed,  0xffff03f0ffff03ef,  0xffff03f2ffff03f1,  0xffff03f4ffff03f3,  0xffff03f6ffff03f5,  0xffff03f8ffff03f7,  0xffff03faffff03f9,  0xffff03fcffff03fb,  0xffffffffffffffff,  0x3fdffffffffffff,  0xffffffff03feffff,  0xffff03ffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0401ffff0400,  0xffff0403ffff0402,  0xffff0405ffff0404,  0xffff0407ffff0406,  0xffff0409ffff0408,  0xffff040bffff040a,  0xffff040dffff040c,  0xffff040fffff040e,  0xffff0411ffff0410,  0xffff0413ffff0412,  0xffff0415ffff0414,  0xffffffffffff0416,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0418ffff0417,  0xffff041affff0419,  0xffff041cffff041b,  0xffff041effff041d,  0xffff0420ffff041f,  0xffff0422ffff0421,  0xffff0424ffff0423,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0425ffffffff,  0xffff0427ffff0426,  0xffff0429ffff0428,  0xffff042bffff042a,  0xffff042cffffffff,  0xffff042effff042d,  0xffff0430ffff042f,  0xffff0432ffff0431,  0xffff0434ffff0433,  0xffff0436ffff0435,  0xffff0438ffff0437,  0xffff043affff0439,  0xffff043cffff043b,  0xffff043effff043d,  0xffff0440ffff043f,  0xffff0442ffff0441,  0xffff0444ffff0443,  0xffff0446ffff0445,  0xffff0448ffff0447,  0xffff044affff0449,  0xffffffffffffffff,  0xffffffffffffffff,  0x44cffff044bffff,  0xffff044e044dffff,  0xffff0450ffff044f,  0xffff0452ffff0451,  0x453ffffffffffff,  0xffffffff0454ffff,  0xffff0456ffff0455,  0xffff0457ffffffff,  0xffff0459ffff0458,  0xffff045bffff045a,  0xffff045dffff045c,  0xffff045fffff045e,  0x4620461ffff0460,  0xffff046504640463,  0x469046804670466,  0xffff046bffff046a,  0xffff046dffff046c,  0xffff046fffff046e,  0xffff0471ffff0470,  0x475047404730472,  0xffffffff0476ffff,  0xffffffffffffffff,  0xffffffffffff0477,  0xffff0478ffffffff,  0xffffffffffff0479,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff047affff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x47d047c047bffff,  0x4810480047f047e,  0x485048404830482,  0x489048804870486,  0x48d048c048b048a,  0x4910490048f048e,  0xffff049404930492,  0xffffffffffffffff,  0x498049704960495,  0x49c049b049a0499,  0x4a0049f049e049d,  0x4a404a304a204a1,  0x4a804a704a604a5,  0x4ac04ab04aa04a9,  0x4b004af04ae04ad,  0x4b404b304b204b1,  0x4b804b704b604b5,  0x4bc04bb04ba04b9,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4c004bf04be04bd,  0x4c404c304c204c1,  0x4c804c704c604c5,  0x4cc04cb04ca04c9,  0x4d004cf04ce04cd,  0x4d404d304d204d1,  0x4d804d704d604d5,  0x4dc04db04da04d9,  0x4e004df04de04dd,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4e404e304e204e1,  0x4e804e704e604e5,  0xffff04eb04ea04e9,  0x4ef04ee04ed04ec,  0x4f304f204f104f0,  0x4f704f604f504f4,  0xffff04fa04f904f8,  0x4fe04fd04fc04fb,  0xffff0501050004ff,  0xffffffff05030502,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x507050605050504,  0x50b050a05090508,  0x50f050e050d050c,  0x513051205110510,  0x517051605150514,  0x51b051a05190518,  0x51f051e051d051c,  0x523052205210520,  0x527052605250524,  0x52b052a05290528,  0x52f052e052d052c,  0x533053205310530,  0xffff053605350534,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x53a053905380537,  0x53e053d053c053b,  0x54205410540053f,  0x546054505440543,  0x54a054905480547,  0x54e054d054c054b,  0x55205510550054f,  0x556055505540553,  0x55a055905580557,  0x55e055d055c055b,  0x56205610560055f,  0x566056505640563,  0x56a056905680567,  0x56e056d056c056b,  0x57205710570056f,  0x576057505740573,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x57a057905780577,  0x57e057d057c057b,  0x58205810580057f,  0x586058505840583,  0x58a058905880587,  0x58e058d058c058b,  0x59205910590058f,  0x596059505940593,  0xffffffff05980597,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff]);
//10368 bytes
enum toTitleSimpleIndexTrieEntries = TrieEntry!(ushort, 8, 7, 6)([ 0x0,  0x20,  0x140], [ 0x100,  0x480,  0xf40], [ 0x402030202020100,  0x702020206020205,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x202020202020202,  0x3000200010000,  0x7000600050004,  0xa00090008,  0xd000c000b0000,  0x110010000f000e,  0x1400130012,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x15000000000000,  0x0,  0x0,  0x16000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x1700000000,  0x1900180000,  0x1d001c001b001a,  0x210020001f001e,  0x0,  0x2300220000,  0x0,  0x0,  0x24000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x28002700260025,  0x29,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2b002a0000,  0x2f002e002d002c,  0x0,  0x0,  0x0,  0x3100300000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x320000,  0x0,  0x0,  0x0,  0x0,  0x35000000340033,  0x3600000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x37000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x38000000000000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x390000,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x3b003a,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x200010000ffff,  0x6000500040003,  0xa000900080007,  0xe000d000c000b,  0x1200110010000f,  0x16001500140013,  0xffff001900180017,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff001affff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1e001d001c001b,  0x2200210020001f,  0x26002500240023,  0x2a002900280027,  0x2e002d002c002b,  0xffff00310030002f,  0x35003400330032,  0x39003800370036,  0x3bffff003affff,  0x3dffff003cffff,  0x3fffff003effff,  0x41ffff0040ffff,  0x43ffff0042ffff,  0x45ffff0044ffff,  0x47ffff0046ffff,  0x49ffff0048ffff,  0x4bffff004affff,  0x4dffff004cffff,  0x4fffff004effff,  0x51ffff0050ffff,  0x53ffff0052ffff,  0x55ffff0054ffff,  0xffff0056ffffffff,  0xffff0058ffff0057,  0xffff005affff0059,  0xffff005cffff005b,  0x5effffffff005d,  0x60ffff005fffff,  0x62ffff0061ffff,  0x64ffff0063ffff,  0x66ffff0065ffff,  0x68ffff0067ffff,  0x6affff0069ffff,  0x6cffff006bffff,  0x6effff006dffff,  0x70ffff006fffff,  0x72ffff0071ffff,  0x74ffff0073ffff,  0xffff0075ffffffff,  0x780077ffff0076,  0x7affffffff0079,  0xffffffff007bffff,  0xffffffffffff007c,  0xffffffffffff007d,  0xffff007effffffff,  0xffffffff007fffff,  0xffff00810080ffff,  0xffff0082ffffffff,  0x84ffff0083ffff,  0xffffffff0085ffff,  0xffffffffffff0086,  0xffffffff0087ffff,  0xffffffffffff0088,  0xffff008affff0089,  0xffffffff008bffff,  0x8dffff008cffff,  0xffffffffffffffff,  0x910090008f008e,  0x95009400930092,  0xffff0097ffff0096,  0xffff0099ffff0098,  0xffff009bffff009a,  0xffff009dffff009c,  0xa0ffff009f009e,  0xa2ffff00a1ffff,  0xa4ffff00a3ffff,  0xa6ffff00a5ffff,  0xa8ffff00a7ffff,  0xab00aa00a9ffff,  0xffffffff00acffff,  0xaeffff00adffff,  0xb0ffff00afffff,  0xb2ffff00b1ffff,  0xb4ffff00b3ffff,  0xb6ffff00b5ffff,  0xb8ffff00b7ffff,  0xbaffff00b9ffff,  0xbcffff00bbffff,  0xbeffff00bdffff,  0xc0ffff00bfffff,  0xc1ffffffffffff,  0xc3ffff00c2ffff,  0xc5ffff00c4ffff,  0xc7ffff00c6ffff,  0xc9ffff00c8ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xcbffffffff00ca,  0xffff00cdffff00cc,  0xceffffffffffff,  0xd0ffff00cfffff,  0xd2ffff00d1ffff,  0xd600d500d400d3,  0xd900d8ffff00d7,  0xdbffff00daffff,  0xffffffffffff00dc,  0xdfffff00de00dd,  0xffff00e100e0ffff,  0xe500e400e300e2,  0xe7ffffffff00e6,  0xffff00e900e8ffff,  0xffffffff00eaffff,  0xffffffffffffffff,  0xffffffff00ebffff,  0xee00edffff00ec,  0xefffffffffffff,  0xf300f200f100f0,  0xffffffffffff00f4,  0xffff00f5ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff00f700f6ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff00f8ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xfaffff00f9ffff,  0xfbffffffffffff,  0xfcffffffffffff,  0xffffffff00fe00fd,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1020101010000ff,  0x10501040103ffff,  0x109010801070106,  0x10d010c010b010a,  0x1110110010f010e,  0x115011401130112,  0x119011801170116,  0x11d011c011b011a,  0xffff0120011f011e,  0xffffffff01220121,  0x12501240123ffff,  0x127ffff0126ffff,  0x129ffff0128ffff,  0x12bffff012affff,  0x12dffff012cffff,  0x12fffff012effff,  0x131ffff0130ffff,  0x135013401330132,  0xffffffff0136ffff,  0x138ffffffff0137,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x13c013b013a0139,  0x140013f013e013d,  0x144014301420141,  0x148014701460145,  0x14c014b014a0149,  0x150014f014e014d,  0x154015301520151,  0x158015701560155,  0x15c015b015a0159,  0x160015f015e015d,  0x164016301620161,  0x168016701660165,  0x16affff0169ffff,  0x16cffff016bffff,  0x16effff016dffff,  0x170ffff016fffff,  0x172ffff0171ffff,  0x174ffff0173ffff,  0x176ffff0175ffff,  0x178ffff0177ffff,  0xffffffff0179ffff,  0xffffffffffffffff,  0x17affffffffffff,  0x17cffff017bffff,  0x17effff017dffff,  0x180ffff017fffff,  0x182ffff0181ffff,  0x184ffff0183ffff,  0x186ffff0185ffff,  0x188ffff0187ffff,  0x18affff0189ffff,  0x18cffff018bffff,  0x18effff018dffff,  0x190ffff018fffff,  0x192ffff0191ffff,  0x194ffff0193ffff,  0xffff0195ffffffff,  0xffff0197ffff0196,  0xffff0199ffff0198,  0x19c019bffff019a,  0x19effff019dffff,  0x1a0ffff019fffff,  0x1a2ffff01a1ffff,  0x1a4ffff01a3ffff,  0x1a6ffff01a5ffff,  0x1a8ffff01a7ffff,  0x1aaffff01a9ffff,  0x1acffff01abffff,  0x1aeffff01adffff,  0x1b0ffff01afffff,  0x1b2ffff01b1ffff,  0x1b4ffff01b3ffff,  0x1b6ffff01b5ffff,  0x1b8ffff01b7ffff,  0x1baffff01b9ffff,  0x1bcffff01bbffff,  0x1beffff01bdffff,  0x1c0ffff01bfffff,  0x1c2ffff01c1ffff,  0x1c4ffff01c3ffff,  0x1c6ffff01c5ffff,  0x1c8ffff01c7ffff,  0x1caffff01c9ffff,  0x1ccffff01cbffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1cf01ce01cdffff,  0x1d301d201d101d0,  0x1d701d601d501d4,  0x1db01da01d901d8,  0x1df01de01dd01dc,  0x1e301e201e101e0,  0x1e701e601e501e4,  0x1eb01ea01e901e8,  0x1ef01ee01ed01ec,  0xffff01f201f101f0,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x1f601f501f401f3,  0x1fa01f901f801f7,  0x1fe01fd01fc01fb,  0x2020201020001ff,  0x206020502040203,  0x20a020902080207,  0x20e020d020c020b,  0x21202110210020f,  0x216021502140213,  0x21a021902180217,  0xffff021d021c021b,  0x220021f021effff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x224022302220221,  0xffffffff02260225,  0x22a022902280227,  0x22e022d022c022b,  0xffffffffffff022f,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff0230ffff,  0xffffffff0231ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0232ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x234ffff0233ffff,  0x236ffff0235ffff,  0x238ffff0237ffff,  0x23affff0239ffff,  0x23cffff023bffff,  0x23effff023dffff,  0x240ffff023fffff,  0x242ffff0241ffff,  0x244ffff0243ffff,  0x246ffff0245ffff,  0x248ffff0247ffff,  0x24affff0249ffff,  0x24cffff024bffff,  0x24effff024dffff,  0x250ffff024fffff,  0x252ffff0251ffff,  0x254ffff0253ffff,  0x256ffff0255ffff,  0x258ffff0257ffff,  0x25affff0259ffff,  0x25cffff025bffff,  0x25effff025dffff,  0x260ffff025fffff,  0x262ffff0261ffff,  0x264ffff0263ffff,  0x266ffff0265ffff,  0x268ffff0267ffff,  0x26affff0269ffff,  0x26cffff026bffff,  0x26effff026dffff,  0x270ffff026fffff,  0x272ffff0271ffff,  0x274ffff0273ffff,  0x276ffff0275ffff,  0x278ffff0277ffff,  0x27affff0279ffff,  0x27cffff027bffff,  0xffffffff027dffff,  0x27effffffffffff,  0xffffffffffffffff,  0x280ffff027fffff,  0x282ffff0281ffff,  0x284ffff0283ffff,  0x286ffff0285ffff,  0x288ffff0287ffff,  0x28affff0289ffff,  0x28cffff028bffff,  0x28effff028dffff,  0x290ffff028fffff,  0x292ffff0291ffff,  0x294ffff0293ffff,  0x296ffff0295ffff,  0x298ffff0297ffff,  0x29affff0299ffff,  0x29cffff029bffff,  0x29effff029dffff,  0x2a0ffff029fffff,  0x2a2ffff02a1ffff,  0x2a4ffff02a3ffff,  0x2a6ffff02a5ffff,  0x2a8ffff02a7ffff,  0x2aaffff02a9ffff,  0x2acffff02abffff,  0x2aeffff02adffff,  0x2b202b102b002af,  0x2b602b502b402b3,  0xffffffffffffffff,  0xffffffffffffffff,  0x2ba02b902b802b7,  0xffffffff02bc02bb,  0xffffffffffffffff,  0xffffffffffffffff,  0x2c002bf02be02bd,  0x2c402c302c202c1,  0xffffffffffffffff,  0xffffffffffffffff,  0x2c802c702c602c5,  0x2cc02cb02ca02c9,  0xffffffffffffffff,  0xffffffffffffffff,  0x2d002cf02ce02cd,  0xffffffff02d202d1,  0xffffffffffffffff,  0xffffffffffffffff,  0x2d4ffff02d3ffff,  0x2d6ffff02d5ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x2da02d902d802d7,  0x2de02dd02dc02db,  0xffffffffffffffff,  0xffffffffffffffff,  0x2e202e102e002df,  0x2e602e502e402e3,  0x2ea02e902e802e7,  0xffffffff02ec02eb,  0x2f002ef02ee02ed,  0x2f402f302f202f1,  0xffffffffffffffff,  0xffffffffffffffff,  0x2f802f702f602f5,  0x2fc02fb02fa02f9,  0xffffffffffffffff,  0xffffffffffffffff,  0x30002ff02fe02fd,  0x304030303020301,  0xffffffffffffffff,  0xffffffffffffffff,  0x307ffff03060305,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0308ffffffff,  0x309ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff030b030a,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffff030d030c,  0xffffffff030effff,  0xffffffffffffffff,  0xffffffffffffffff,  0x30fffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff0310ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x314031303120311,  0x318031703160315,  0x31c031b031a0319,  0x320031f031e031d,  0xffffffffffffffff,  0xffffffffffff0321,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x325032403230322,  0x329032803270326,  0x32d032c032b032a,  0x3310330032f032e,  0x335033403330332,  0x339033803370336,  0xffffffff033b033a,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x33f033e033d033c,  0x343034203410340,  0x347034603450344,  0x34b034a03490348,  0x34f034e034d034c,  0x353035203510350,  0x357035603550354,  0x35b035a03590358,  0x35f035e035d035c,  0x363036203610360,  0x367036603650364,  0x36b036a03690368,  0xffffffff036cffff,  0xffff036e036dffff,  0xffff0370ffff036f,  0xffffffffffff0371,  0x372ffffffffffff,  0xffff0373ffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x375ffff0374ffff,  0x377ffff0376ffff,  0x379ffff0378ffff,  0x37bffff037affff,  0x37dffff037cffff,  0x37fffff037effff,  0x381ffff0380ffff,  0x383ffff0382ffff,  0x385ffff0384ffff,  0x387ffff0386ffff,  0x389ffff0388ffff,  0x38bffff038affff,  0x38dffff038cffff,  0x38fffff038effff,  0x391ffff0390ffff,  0x393ffff0392ffff,  0x395ffff0394ffff,  0x397ffff0396ffff,  0x399ffff0398ffff,  0x39bffff039affff,  0x39dffff039cffff,  0x39fffff039effff,  0x3a1ffff03a0ffff,  0x3a3ffff03a2ffff,  0x3a5ffff03a4ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff03a7ffff03a6,  0x3a8ffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3ac03ab03aa03a9,  0x3b003af03ae03ad,  0x3b403b303b203b1,  0x3b803b703b603b5,  0x3bc03bb03ba03b9,  0x3c003bf03be03bd,  0x3c403c303c203c1,  0x3c803c703c603c5,  0x3cc03cb03ca03c9,  0x3cfffff03ce03cd,  0xffffffffffffffff,  0xffffffff03d0ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3d2ffff03d1ffff,  0x3d4ffff03d3ffff,  0x3d6ffff03d5ffff,  0x3d8ffff03d7ffff,  0x3daffff03d9ffff,  0x3dcffff03dbffff,  0x3deffff03ddffff,  0x3e0ffff03dfffff,  0x3e2ffff03e1ffff,  0x3e4ffff03e3ffff,  0x3e6ffff03e5ffff,  0xffffffff03e7ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3e9ffff03e8ffff,  0x3ebffff03eaffff,  0x3edffff03ecffff,  0x3efffff03eeffff,  0x3f1ffff03f0ffff,  0x3f3ffff03f2ffff,  0x3f5ffff03f4ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x3f6ffffffffffff,  0x3f8ffff03f7ffff,  0x3faffff03f9ffff,  0x3fcffff03fbffff,  0x3fdffffffffffff,  0x3ffffff03feffff,  0x401ffff0400ffff,  0x403ffff0402ffff,  0x405ffff0404ffff,  0x407ffff0406ffff,  0x409ffff0408ffff,  0x40bffff040affff,  0x40dffff040cffff,  0x40fffff040effff,  0x411ffff0410ffff,  0x413ffff0412ffff,  0x415ffff0414ffff,  0x417ffff0416ffff,  0x419ffff0418ffff,  0x41bffff041affff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff041cffffffff,  0x41effffffff041d,  0x420ffff041fffff,  0x422ffff0421ffff,  0xffffffffffffffff,  0xffffffffffff0423,  0x425ffff0424ffff,  0x427ffffffff0426,  0x429ffff0428ffff,  0x42bffff042affff,  0x42dffff042cffff,  0x42fffff042effff,  0xffffffff0430ffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x432ffff0431ffff,  0x434ffff0433ffff,  0x436ffff0435ffff,  0x438ffff0437ffff,  0xffffffffffffffff,  0xffff043affff0439,  0xffffffffffffffff,  0xffffffff043bffff,  0x43cffffffffffff,  0xffffffff043dffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffff043effffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x43fffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x443044204410440,  0x447044604450444,  0x44b044a04490448,  0x44f044e044d044c,  0x453045204510450,  0x457045604550454,  0x45b045a04590458,  0x45f045e045d045c,  0x463046204610460,  0x467046604650464,  0x46b046a04690468,  0x46f046e046d046c,  0x473047204710470,  0x477047604750474,  0x47b047a04790478,  0x47f047e047d047c,  0x483048204810480,  0x487048604850484,  0x48b048a04890488,  0x48f048e048d048c,  0x49204910490ffff,  0x496049504940493,  0x49a049904980497,  0x49e049d049c049b,  0x4a204a104a0049f,  0x4a604a504a404a3,  0xffff04a904a804a7,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4ad04ac04ab04aa,  0x4b104b004af04ae,  0x4b504b404b304b2,  0x4b904b804b704b6,  0x4bd04bc04bb04ba,  0x4c104c004bf04be,  0x4c504c404c304c2,  0x4c904c804c704c6,  0x4cd04cc04cb04ca,  0x4d104d004cf04ce,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4d504d404d304d2,  0x4d904d804d704d6,  0x4dd04dc04db04da,  0x4e104e004df04de,  0x4e504e404e304e2,  0x4e904e804e704e6,  0x4ed04ec04eb04ea,  0x4f104f004ef04ee,  0x4f504f404f304f2,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x4f6ffffffffffff,  0x4fa04f904f804f7,  0x4fe04fd04fc04fb,  0x501ffff050004ff,  0x505050405030502,  0x509050805070506,  0x50d050c050b050a,  0x510ffff050f050e,  0x514051305120511,  0x517ffff05160515,  0xffffffffffff0518,  0x51c051b051a0519,  0x520051f051e051d,  0x524052305220521,  0x528052705260525,  0x52c052b052a0529,  0x530052f052e052d,  0x534053305320531,  0x538053705360535,  0x53c053b053a0539,  0x540053f053e053d,  0x544054305420541,  0x548054705460545,  0xffff054b054a0549,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x54f054e054d054c,  0x553055205510550,  0x557055605550554,  0x55b055a05590558,  0x55f055e055d055c,  0x563056205610560,  0x567056605650564,  0x56b056a05690568,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x56f056e056d056c,  0x573057205710570,  0x577057605750574,  0x57b057a05790578,  0x57f057e057d057c,  0x583058205810580,  0x587058605850584,  0x58b058a05890588,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0x58d058cffffffff,  0x5910590058f058e,  0x595059405930592,  0x599059805970596,  0x59d059c059b059a,  0x5a105a0059f059e,  0x5a505a405a305a2,  0x5a905a805a705a6,  0x5ad05ac05ab05aa,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff,  0xffffffffffffffff]);
@property
{
private alias _IUA = immutable(uint[]);
_IUA toUpperTable() nothrow @nogc @safe pure { static _IUA t = [ 0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,  0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,  0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,  0x58,  0x59,  0x5a,  0x39c,  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0x178,  0x100,  0x102,  0x104,  0x106,  0x108,  0x10a,  0x10c,  0x10e,  0x110,  0x112,  0x114,  0x116,  0x118,  0x11a,  0x11c,  0x11e,  0x120,  0x122,  0x124,  0x126,  0x128,  0x12a,  0x12c,  0x12e,  0x49,  0x132,  0x134,  0x136,  0x139,  0x13b,  0x13d,  0x13f,  0x141,  0x143,  0x145,  0x147,  0x14a,  0x14c,  0x14e,  0x150,  0x152,  0x154,  0x156,  0x158,  0x15a,  0x15c,  0x15e,  0x160,  0x162,  0x164,  0x166,  0x168,  0x16a,  0x16c,  0x16e,  0x170,  0x172,  0x174,  0x176,  0x179,  0x17b,  0x17d,  0x53,  0x243,  0x182,  0x184,  0x187,  0x18b,  0x191,  0x1f6,  0x198,  0x23d,  0x220,  0x1a0,  0x1a2,  0x1a4,  0x1a7,  0x1ac,  0x1af,  0x1b3,  0x1b5,  0x1b8,  0x1bc,  0x1f7,  0x1c4,  0x1c4,  0x1c7,  0x1c7,  0x1ca,  0x1ca,  0x1cd,  0x1cf,  0x1d1,  0x1d3,  0x1d5,  0x1d7,  0x1d9,  0x1db,  0x18e,  0x1de,  0x1e0,  0x1e2,  0x1e4,  0x1e6,  0x1e8,  0x1ea,  0x1ec,  0x1ee,  0x1f1,  0x1f1,  0x1f4,  0x1f8,  0x1fa,  0x1fc,  0x1fe,  0x200,  0x202,  0x204,  0x206,  0x208,  0x20a,  0x20c,  0x20e,  0x210,  0x212,  0x214,  0x216,  0x218,  0x21a,  0x21c,  0x21e,  0x222,  0x224,  0x226,  0x228,  0x22a,  0x22c,  0x22e,  0x230,  0x232,  0x23b,  0x2c7e,  0x2c7f,  0x241,  0x246,  0x248,  0x24a,  0x24c,  0x24e,  0x2c6f,  0x2c6d,  0x2c70,  0x181,  0x186,  0x189,  0x18a,  0x18f,  0x190,  0xa7ab,  0x193,  0xa7ac,  0x194,  0xa78d,  0xa7aa,  0x197,  0x196,  0xa7ae,  0x2c62,  0xa7ad,  0x19c,  0x2c6e,  0x19d,  0x19f,  0x2c64,  0x1a6,  0xa7c5,  0x1a9,  0xa7b1,  0x1ae,  0x244,  0x1b1,  0x1b2,  0x245,  0x1b7,  0xa7b2,  0xa7b0,  0x399,  0x370,  0x372,  0x376,  0x3fd,  0x3fe,  0x3ff,  0x386,  0x388,  0x389,  0x38a,  0x391,  0x392,  0x393,  0x394,  0x395,  0x396,  0x397,  0x398,  0x399,  0x39a,  0x39b,  0x39c,  0x39d,  0x39e,  0x39f,  0x3a0,  0x3a1,  0x3a3,  0x3a3,  0x3a4,  0x3a5,  0x3a6,  0x3a7,  0x3a8,  0x3a9,  0x3aa,  0x3ab,  0x38c,  0x38e,  0x38f,  0x392,  0x398,  0x3a6,  0x3a0,  0x3cf,  0x3d8,  0x3da,  0x3dc,  0x3de,  0x3e0,  0x3e2,  0x3e4,  0x3e6,  0x3e8,  0x3ea,  0x3ec,  0x3ee,  0x39a,  0x3a1,  0x3f9,  0x37f,  0x395,  0x3f7,  0x3fa,  0x410,  0x411,  0x412,  0x413,  0x414,  0x415,  0x416,  0x417,  0x418,  0x419,  0x41a,  0x41b,  0x41c,  0x41d,  0x41e,  0x41f,  0x420,  0x421,  0x422,  0x423,  0x424,  0x425,  0x426,  0x427,  0x428,  0x429,  0x42a,  0x42b,  0x42c,  0x42d,  0x42e,  0x42f,  0x400,  0x401,  0x402,  0x403,  0x404,  0x405,  0x406,  0x407,  0x408,  0x409,  0x40a,  0x40b,  0x40c,  0x40d,  0x40e,  0x40f,  0x460,  0x462,  0x464,  0x466,  0x468,  0x46a,  0x46c,  0x46e,  0x470,  0x472,  0x474,  0x476,  0x478,  0x47a,  0x47c,  0x47e,  0x480,  0x48a,  0x48c,  0x48e,  0x490,  0x492,  0x494,  0x496,  0x498,  0x49a,  0x49c,  0x49e,  0x4a0,  0x4a2,  0x4a4,  0x4a6,  0x4a8,  0x4aa,  0x4ac,  0x4ae,  0x4b0,  0x4b2,  0x4b4,  0x4b6,  0x4b8,  0x4ba,  0x4bc,  0x4be,  0x4c1,  0x4c3,  0x4c5,  0x4c7,  0x4c9,  0x4cb,  0x4cd,  0x4c0,  0x4d0,  0x4d2,  0x4d4,  0x4d6,  0x4d8,  0x4da,  0x4dc,  0x4de,  0x4e0,  0x4e2,  0x4e4,  0x4e6,  0x4e8,  0x4ea,  0x4ec,  0x4ee,  0x4f0,  0x4f2,  0x4f4,  0x4f6,  0x4f8,  0x4fa,  0x4fc,  0x4fe,  0x500,  0x502,  0x504,  0x506,  0x508,  0x50a,  0x50c,  0x50e,  0x510,  0x512,  0x514,  0x516,  0x518,  0x51a,  0x51c,  0x51e,  0x520,  0x522,  0x524,  0x526,  0x528,  0x52a,  0x52c,  0x52e,  0x531,  0x532,  0x533,  0x534,  0x535,  0x536,  0x537,  0x538,  0x539,  0x53a,  0x53b,  0x53c,  0x53d,  0x53e,  0x53f,  0x540,  0x541,  0x542,  0x543,  0x544,  0x545,  0x546,  0x547,  0x548,  0x549,  0x54a,  0x54b,  0x54c,  0x54d,  0x54e,  0x54f,  0x550,  0x551,  0x552,  0x553,  0x554,  0x555,  0x556,  0x1c90,  0x1c91,  0x1c92,  0x1c93,  0x1c94,  0x1c95,  0x1c96,  0x1c97,  0x1c98,  0x1c99,  0x1c9a,  0x1c9b,  0x1c9c,  0x1c9d,  0x1c9e,  0x1c9f,  0x1ca0,  0x1ca1,  0x1ca2,  0x1ca3,  0x1ca4,  0x1ca5,  0x1ca6,  0x1ca7,  0x1ca8,  0x1ca9,  0x1caa,  0x1cab,  0x1cac,  0x1cad,  0x1cae,  0x1caf,  0x1cb0,  0x1cb1,  0x1cb2,  0x1cb3,  0x1cb4,  0x1cb5,  0x1cb6,  0x1cb7,  0x1cb8,  0x1cb9,  0x1cba,  0x1cbd,  0x1cbe,  0x1cbf,  0x13f0,  0x13f1,  0x13f2,  0x13f3,  0x13f4,  0x13f5,  0x412,  0x414,  0x41e,  0x421,  0x422,  0x422,  0x42a,  0x462,  0xa64a,  0xa77d,  0x2c63,  0xa7c6,  0x1e00,  0x1e02,  0x1e04,  0x1e06,  0x1e08,  0x1e0a,  0x1e0c,  0x1e0e,  0x1e10,  0x1e12,  0x1e14,  0x1e16,  0x1e18,  0x1e1a,  0x1e1c,  0x1e1e,  0x1e20,  0x1e22,  0x1e24,  0x1e26,  0x1e28,  0x1e2a,  0x1e2c,  0x1e2e,  0x1e30,  0x1e32,  0x1e34,  0x1e36,  0x1e38,  0x1e3a,  0x1e3c,  0x1e3e,  0x1e40,  0x1e42,  0x1e44,  0x1e46,  0x1e48,  0x1e4a,  0x1e4c,  0x1e4e,  0x1e50,  0x1e52,  0x1e54,  0x1e56,  0x1e58,  0x1e5a,  0x1e5c,  0x1e5e,  0x1e60,  0x1e62,  0x1e64,  0x1e66,  0x1e68,  0x1e6a,  0x1e6c,  0x1e6e,  0x1e70,  0x1e72,  0x1e74,  0x1e76,  0x1e78,  0x1e7a,  0x1e7c,  0x1e7e,  0x1e80,  0x1e82,  0x1e84,  0x1e86,  0x1e88,  0x1e8a,  0x1e8c,  0x1e8e,  0x1e90,  0x1e92,  0x1e94,  0x1e60,  0x1ea0,  0x1ea2,  0x1ea4,  0x1ea6,  0x1ea8,  0x1eaa,  0x1eac,  0x1eae,  0x1eb0,  0x1eb2,  0x1eb4,  0x1eb6,  0x1eb8,  0x1eba,  0x1ebc,  0x1ebe,  0x1ec0,  0x1ec2,  0x1ec4,  0x1ec6,  0x1ec8,  0x1eca,  0x1ecc,  0x1ece,  0x1ed0,  0x1ed2,  0x1ed4,  0x1ed6,  0x1ed8,  0x1eda,  0x1edc,  0x1ede,  0x1ee0,  0x1ee2,  0x1ee4,  0x1ee6,  0x1ee8,  0x1eea,  0x1eec,  0x1eee,  0x1ef0,  0x1ef2,  0x1ef4,  0x1ef6,  0x1ef8,  0x1efa,  0x1efc,  0x1efe,  0x1f08,  0x1f09,  0x1f0a,  0x1f0b,  0x1f0c,  0x1f0d,  0x1f0e,  0x1f0f,  0x1f18,  0x1f19,  0x1f1a,  0x1f1b,  0x1f1c,  0x1f1d,  0x1f28,  0x1f29,  0x1f2a,  0x1f2b,  0x1f2c,  0x1f2d,  0x1f2e,  0x1f2f,  0x1f38,  0x1f39,  0x1f3a,  0x1f3b,  0x1f3c,  0x1f3d,  0x1f3e,  0x1f3f,  0x1f48,  0x1f49,  0x1f4a,  0x1f4b,  0x1f4c,  0x1f4d,  0x1f59,  0x1f5b,  0x1f5d,  0x1f5f,  0x1f68,  0x1f69,  0x1f6a,  0x1f6b,  0x1f6c,  0x1f6d,  0x1f6e,  0x1f6f,  0x1fba,  0x1fbb,  0x1fc8,  0x1fc9,  0x1fca,  0x1fcb,  0x1fda,  0x1fdb,  0x1ff8,  0x1ff9,  0x1fea,  0x1feb,  0x1ffa,  0x1ffb,  0x1f88,  0x1f89,  0x1f8a,  0x1f8b,  0x1f8c,  0x1f8d,  0x1f8e,  0x1f8f,  0x1f98,  0x1f99,  0x1f9a,  0x1f9b,  0x1f9c,  0x1f9d,  0x1f9e,  0x1f9f,  0x1fa8,  0x1fa9,  0x1faa,  0x1fab,  0x1fac,  0x1fad,  0x1fae,  0x1faf,  0x1fb8,  0x1fb9,  0x1fbc,  0x399,  0x1fcc,  0x1fd8,  0x1fd9,  0x1fe8,  0x1fe9,  0x1fec,  0x1ffc,  0x2132,  0x2160,  0x2161,  0x2162,  0x2163,  0x2164,  0x2165,  0x2166,  0x2167,  0x2168,  0x2169,  0x216a,  0x216b,  0x216c,  0x216d,  0x216e,  0x216f,  0x2183,  0x24b6,  0x24b7,  0x24b8,  0x24b9,  0x24ba,  0x24bb,  0x24bc,  0x24bd,  0x24be,  0x24bf,  0x24c0,  0x24c1,  0x24c2,  0x24c3,  0x24c4,  0x24c5,  0x24c6,  0x24c7,  0x24c8,  0x24c9,  0x24ca,  0x24cb,  0x24cc,  0x24cd,  0x24ce,  0x24cf,  0x2c00,  0x2c01,  0x2c02,  0x2c03,  0x2c04,  0x2c05,  0x2c06,  0x2c07,  0x2c08,  0x2c09,  0x2c0a,  0x2c0b,  0x2c0c,  0x2c0d,  0x2c0e,  0x2c0f,  0x2c10,  0x2c11,  0x2c12,  0x2c13,  0x2c14,  0x2c15,  0x2c16,  0x2c17,  0x2c18,  0x2c19,  0x2c1a,  0x2c1b,  0x2c1c,  0x2c1d,  0x2c1e,  0x2c1f,  0x2c20,  0x2c21,  0x2c22,  0x2c23,  0x2c24,  0x2c25,  0x2c26,  0x2c27,  0x2c28,  0x2c29,  0x2c2a,  0x2c2b,  0x2c2c,  0x2c2d,  0x2c2e,  0x2c2f,  0x2c60,  0x23a,  0x23e,  0x2c67,  0x2c69,  0x2c6b,  0x2c72,  0x2c75,  0x2c80,  0x2c82,  0x2c84,  0x2c86,  0x2c88,  0x2c8a,  0x2c8c,  0x2c8e,  0x2c90,  0x2c92,  0x2c94,  0x2c96,  0x2c98,  0x2c9a,  0x2c9c,  0x2c9e,  0x2ca0,  0x2ca2,  0x2ca4,  0x2ca6,  0x2ca8,  0x2caa,  0x2cac,  0x2cae,  0x2cb0,  0x2cb2,  0x2cb4,  0x2cb6,  0x2cb8,  0x2cba,  0x2cbc,  0x2cbe,  0x2cc0,  0x2cc2,  0x2cc4,  0x2cc6,  0x2cc8,  0x2cca,  0x2ccc,  0x2cce,  0x2cd0,  0x2cd2,  0x2cd4,  0x2cd6,  0x2cd8,  0x2cda,  0x2cdc,  0x2cde,  0x2ce0,  0x2ce2,  0x2ceb,  0x2ced,  0x2cf2,  0x10a0,  0x10a1,  0x10a2,  0x10a3,  0x10a4,  0x10a5,  0x10a6,  0x10a7,  0x10a8,  0x10a9,  0x10aa,  0x10ab,  0x10ac,  0x10ad,  0x10ae,  0x10af,  0x10b0,  0x10b1,  0x10b2,  0x10b3,  0x10b4,  0x10b5,  0x10b6,  0x10b7,  0x10b8,  0x10b9,  0x10ba,  0x10bb,  0x10bc,  0x10bd,  0x10be,  0x10bf,  0x10c0,  0x10c1,  0x10c2,  0x10c3,  0x10c4,  0x10c5,  0x10c7,  0x10cd,  0xa640,  0xa642,  0xa644,  0xa646,  0xa648,  0xa64a,  0xa64c,  0xa64e,  0xa650,  0xa652,  0xa654,  0xa656,  0xa658,  0xa65a,  0xa65c,  0xa65e,  0xa660,  0xa662,  0xa664,  0xa666,  0xa668,  0xa66a,  0xa66c,  0xa680,  0xa682,  0xa684,  0xa686,  0xa688,  0xa68a,  0xa68c,  0xa68e,  0xa690,  0xa692,  0xa694,  0xa696,  0xa698,  0xa69a,  0xa722,  0xa724,  0xa726,  0xa728,  0xa72a,  0xa72c,  0xa72e,  0xa732,  0xa734,  0xa736,  0xa738,  0xa73a,  0xa73c,  0xa73e,  0xa740,  0xa742,  0xa744,  0xa746,  0xa748,  0xa74a,  0xa74c,  0xa74e,  0xa750,  0xa752,  0xa754,  0xa756,  0xa758,  0xa75a,  0xa75c,  0xa75e,  0xa760,  0xa762,  0xa764,  0xa766,  0xa768,  0xa76a,  0xa76c,  0xa76e,  0xa779,  0xa77b,  0xa77e,  0xa780,  0xa782,  0xa784,  0xa786,  0xa78b,  0xa790,  0xa792,  0xa7c4,  0xa796,  0xa798,  0xa79a,  0xa79c,  0xa79e,  0xa7a0,  0xa7a2,  0xa7a4,  0xa7a6,  0xa7a8,  0xa7b4,  0xa7b6,  0xa7b8,  0xa7ba,  0xa7bc,  0xa7be,  0xa7c0,  0xa7c2,  0xa7c7,  0xa7c9,  0xa7d0,  0xa7d6,  0xa7d8,  0xa7f5,  0xa7b3,  0x13a0,  0x13a1,  0x13a2,  0x13a3,  0x13a4,  0x13a5,  0x13a6,  0x13a7,  0x13a8,  0x13a9,  0x13aa,  0x13ab,  0x13ac,  0x13ad,  0x13ae,  0x13af,  0x13b0,  0x13b1,  0x13b2,  0x13b3,  0x13b4,  0x13b5,  0x13b6,  0x13b7,  0x13b8,  0x13b9,  0x13ba,  0x13bb,  0x13bc,  0x13bd,  0x13be,  0x13bf,  0x13c0,  0x13c1,  0x13c2,  0x13c3,  0x13c4,  0x13c5,  0x13c6,  0x13c7,  0x13c8,  0x13c9,  0x13ca,  0x13cb,  0x13cc,  0x13cd,  0x13ce,  0x13cf,  0x13d0,  0x13d1,  0x13d2,  0x13d3,  0x13d4,  0x13d5,  0x13d6,  0x13d7,  0x13d8,  0x13d9,  0x13da,  0x13db,  0x13dc,  0x13dd,  0x13de,  0x13df,  0x13e0,  0x13e1,  0x13e2,  0x13e3,  0x13e4,  0x13e5,  0x13e6,  0x13e7,  0x13e8,  0x13e9,  0x13ea,  0x13eb,  0x13ec,  0x13ed,  0x13ee,  0x13ef,  0xff21,  0xff22,  0xff23,  0xff24,  0xff25,  0xff26,  0xff27,  0xff28,  0xff29,  0xff2a,  0xff2b,  0xff2c,  0xff2d,  0xff2e,  0xff2f,  0xff30,  0xff31,  0xff32,  0xff33,  0xff34,  0xff35,  0xff36,  0xff37,  0xff38,  0xff39,  0xff3a,  0x10400,  0x10401,  0x10402,  0x10403,  0x10404,  0x10405,  0x10406,  0x10407,  0x10408,  0x10409,  0x1040a,  0x1040b,  0x1040c,  0x1040d,  0x1040e,  0x1040f,  0x10410,  0x10411,  0x10412,  0x10413,  0x10414,  0x10415,  0x10416,  0x10417,  0x10418,  0x10419,  0x1041a,  0x1041b,  0x1041c,  0x1041d,  0x1041e,  0x1041f,  0x10420,  0x10421,  0x10422,  0x10423,  0x10424,  0x10425,  0x10426,  0x10427,  0x104b0,  0x104b1,  0x104b2,  0x104b3,  0x104b4,  0x104b5,  0x104b6,  0x104b7,  0x104b8,  0x104b9,  0x104ba,  0x104bb,  0x104bc,  0x104bd,  0x104be,  0x104bf,  0x104c0,  0x104c1,  0x104c2,  0x104c3,  0x104c4,  0x104c5,  0x104c6,  0x104c7,  0x104c8,  0x104c9,  0x104ca,  0x104cb,  0x104cc,  0x104cd,  0x104ce,  0x104cf,  0x104d0,  0x104d1,  0x104d2,  0x104d3,  0x10570,  0x10571,  0x10572,  0x10573,  0x10574,  0x10575,  0x10576,  0x10577,  0x10578,  0x10579,  0x1057a,  0x1057c,  0x1057d,  0x1057e,  0x1057f,  0x10580,  0x10581,  0x10582,  0x10583,  0x10584,  0x10585,  0x10586,  0x10587,  0x10588,  0x10589,  0x1058a,  0x1058c,  0x1058d,  0x1058e,  0x1058f,  0x10590,  0x10591,  0x10592,  0x10594,  0x10595,  0x10c80,  0x10c81,  0x10c82,  0x10c83,  0x10c84,  0x10c85,  0x10c86,  0x10c87,  0x10c88,  0x10c89,  0x10c8a,  0x10c8b,  0x10c8c,  0x10c8d,  0x10c8e,  0x10c8f,  0x10c90,  0x10c91,  0x10c92,  0x10c93,  0x10c94,  0x10c95,  0x10c96,  0x10c97,  0x10c98,  0x10c99,  0x10c9a,  0x10c9b,  0x10c9c,  0x10c9d,  0x10c9e,  0x10c9f,  0x10ca0,  0x10ca1,  0x10ca2,  0x10ca3,  0x10ca4,  0x10ca5,  0x10ca6,  0x10ca7,  0x10ca8,  0x10ca9,  0x10caa,  0x10cab,  0x10cac,  0x10cad,  0x10cae,  0x10caf,  0x10cb0,  0x10cb1,  0x10cb2,  0x118a0,  0x118a1,  0x118a2,  0x118a3,  0x118a4,  0x118a5,  0x118a6,  0x118a7,  0x118a8,  0x118a9,  0x118aa,  0x118ab,  0x118ac,  0x118ad,  0x118ae,  0x118af,  0x118b0,  0x118b1,  0x118b2,  0x118b3,  0x118b4,  0x118b5,  0x118b6,  0x118b7,  0x118b8,  0x118b9,  0x118ba,  0x118bb,  0x118bc,  0x118bd,  0x118be,  0x118bf,  0x16e40,  0x16e41,  0x16e42,  0x16e43,  0x16e44,  0x16e45,  0x16e46,  0x16e47,  0x16e48,  0x16e49,  0x16e4a,  0x16e4b,  0x16e4c,  0x16e4d,  0x16e4e,  0x16e4f,  0x16e50,  0x16e51,  0x16e52,  0x16e53,  0x16e54,  0x16e55,  0x16e56,  0x16e57,  0x16e58,  0x16e59,  0x16e5a,  0x16e5b,  0x16e5c,  0x16e5d,  0x16e5e,  0x16e5f,  0x1e900,  0x1e901,  0x1e902,  0x1e903,  0x1e904,  0x1e905,  0x1e906,  0x1e907,  0x1e908,  0x1e909,  0x1e90a,  0x1e90b,  0x1e90c,  0x1e90d,  0x1e90e,  0x1e90f,  0x1e910,  0x1e911,  0x1e912,  0x1e913,  0x1e914,  0x1e915,  0x1e916,  0x1e917,  0x1e918,  0x1e919,  0x1e91a,  0x1e91b,  0x1e91c,  0x1e91d,  0x1e91e,  0x1e91f,  0x1e920,  0x1e921,  0x2000053,  0x53,  0x130,  0x2000046,  0x46,  0x2000046,  0x49,  0x2000046,  0x4c,  0x3000046,  0x46,  0x49,  0x3000046,  0x46,  0x4c,  0x2000053,  0x54,  0x2000053,  0x54,  0x2000535,  0x552,  0x2000544,  0x546,  0x2000544,  0x535,  0x2000544,  0x53b,  0x200054e,  0x546,  0x2000544,  0x53d,  0x20002bc,  0x4e,  0x3000399,  0x308,  0x301,  0x30003a5,  0x308,  0x301,  0x200004a,  0x30c,  0x2000048,  0x331,  0x2000054,  0x308,  0x2000057,  0x30a,  0x2000059,  0x30a,  0x2000041,  0x2be,  0x20003a5,  0x313,  0x30003a5,  0x313,  0x300,  0x30003a5,  0x313,  0x301,  0x30003a5,  0x313,  0x342,  0x2000391,  0x342,  0x2000397,  0x342,  0x3000399,  0x308,  0x300,  0x3000399,  0x308,  0x301,  0x2000399,  0x342,  0x3000399,  0x308,  0x342,  0x30003a5,  0x308,  0x300,  0x30003a5,  0x308,  0x301,  0x20003a1,  0x313,  0x20003a5,  0x342,  0x30003a5,  0x308,  0x342,  0x20003a9,  0x342,  0x2001f08,  0x399,  0x2001f09,  0x399,  0x2001f0a,  0x399,  0x2001f0b,  0x399,  0x2001f0c,  0x399,  0x2001f0d,  0x399,  0x2001f0e,  0x399,  0x2001f0f,  0x399,  0x2001f08,  0x399,  0x2001f09,  0x399,  0x2001f0a,  0x399,  0x2001f0b,  0x399,  0x2001f0c,  0x399,  0x2001f0d,  0x399,  0x2001f0e,  0x399,  0x2001f0f,  0x399,  0x2001f28,  0x399,  0x2001f29,  0x399,  0x2001f2a,  0x399,  0x2001f2b,  0x399,  0x2001f2c,  0x399,  0x2001f2d,  0x399,  0x2001f2e,  0x399,  0x2001f2f,  0x399,  0x2001f28,  0x399,  0x2001f29,  0x399,  0x2001f2a,  0x399,  0x2001f2b,  0x399,  0x2001f2c,  0x399,  0x2001f2d,  0x399,  0x2001f2e,  0x399,  0x2001f2f,  0x399,  0x2001f68,  0x399,  0x2001f69,  0x399,  0x2001f6a,  0x399,  0x2001f6b,  0x399,  0x2001f6c,  0x399,  0x2001f6d,  0x399,  0x2001f6e,  0x399,  0x2001f6f,  0x399,  0x2001f68,  0x399,  0x2001f69,  0x399,  0x2001f6a,  0x399,  0x2001f6b,  0x399,  0x2001f6c,  0x399,  0x2001f6d,  0x399,  0x2001f6e,  0x399,  0x2001f6f,  0x399,  0x2000391,  0x399,  0x2000391,  0x399,  0x2000397,  0x399,  0x2000397,  0x399,  0x20003a9,  0x399,  0x20003a9,  0x399,  0x2001fba,  0x399,  0x2000386,  0x399,  0x2001fca,  0x399,  0x2000389,  0x399,  0x2001ffa,  0x399,  0x200038f,  0x399,  0x3000391,  0x342,  0x399,  0x3000397,  0x342,  0x399,  0x30003a9,  0x342,  0x399]; return t; }
_IUA toLowerTable() nothrow @nogc @safe pure { static _IUA t = [ 0x61,  0x62,  0x63,  0x64,  0x65,  0x66,  0x67,  0x68,  0x69,  0x6a,  0x6b,  0x6c,  0x6d,  0x6e,  0x6f,  0x70,  0x71,  0x72,  0x73,  0x74,  0x75,  0x76,  0x77,  0x78,  0x79,  0x7a,  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0x101,  0x103,  0x105,  0x107,  0x109,  0x10b,  0x10d,  0x10f,  0x111,  0x113,  0x115,  0x117,  0x119,  0x11b,  0x11d,  0x11f,  0x121,  0x123,  0x125,  0x127,  0x129,  0x12b,  0x12d,  0x12f,  0x69,  0x133,  0x135,  0x137,  0x13a,  0x13c,  0x13e,  0x140,  0x142,  0x144,  0x146,  0x148,  0x14b,  0x14d,  0x14f,  0x151,  0x153,  0x155,  0x157,  0x159,  0x15b,  0x15d,  0x15f,  0x161,  0x163,  0x165,  0x167,  0x169,  0x16b,  0x16d,  0x16f,  0x171,  0x173,  0x175,  0x177,  0xff,  0x17a,  0x17c,  0x17e,  0x253,  0x183,  0x185,  0x254,  0x188,  0x256,  0x257,  0x18c,  0x1dd,  0x259,  0x25b,  0x192,  0x260,  0x263,  0x269,  0x268,  0x199,  0x26f,  0x272,  0x275,  0x1a1,  0x1a3,  0x1a5,  0x280,  0x1a8,  0x283,  0x1ad,  0x288,  0x1b0,  0x28a,  0x28b,  0x1b4,  0x1b6,  0x292,  0x1b9,  0x1bd,  0x1c6,  0x1c6,  0x1c9,  0x1c9,  0x1cc,  0x1cc,  0x1ce,  0x1d0,  0x1d2,  0x1d4,  0x1d6,  0x1d8,  0x1da,  0x1dc,  0x1df,  0x1e1,  0x1e3,  0x1e5,  0x1e7,  0x1e9,  0x1eb,  0x1ed,  0x1ef,  0x1f3,  0x1f3,  0x1f5,  0x195,  0x1bf,  0x1f9,  0x1fb,  0x1fd,  0x1ff,  0x201,  0x203,  0x205,  0x207,  0x209,  0x20b,  0x20d,  0x20f,  0x211,  0x213,  0x215,  0x217,  0x219,  0x21b,  0x21d,  0x21f,  0x19e,  0x223,  0x225,  0x227,  0x229,  0x22b,  0x22d,  0x22f,  0x231,  0x233,  0x2c65,  0x23c,  0x19a,  0x2c66,  0x242,  0x180,  0x289,  0x28c,  0x247,  0x249,  0x24b,  0x24d,  0x24f,  0x371,  0x373,  0x377,  0x3f3,  0x3ac,  0x3ad,  0x3ae,  0x3af,  0x3cc,  0x3cd,  0x3ce,  0x3b1,  0x3b2,  0x3b3,  0x3b4,  0x3b5,  0x3b6,  0x3b7,  0x3b8,  0x3b9,  0x3ba,  0x3bb,  0x3bc,  0x3bd,  0x3be,  0x3bf,  0x3c0,  0x3c1,  0x3c3,  0x3c4,  0x3c5,  0x3c6,  0x3c7,  0x3c8,  0x3c9,  0x3ca,  0x3cb,  0x3d7,  0x3d9,  0x3db,  0x3dd,  0x3df,  0x3e1,  0x3e3,  0x3e5,  0x3e7,  0x3e9,  0x3eb,  0x3ed,  0x3ef,  0x3b8,  0x3f8,  0x3f2,  0x3fb,  0x37b,  0x37c,  0x37d,  0x450,  0x451,  0x452,  0x453,  0x454,  0x455,  0x456,  0x457,  0x458,  0x459,  0x45a,  0x45b,  0x45c,  0x45d,  0x45e,  0x45f,  0x430,  0x431,  0x432,  0x433,  0x434,  0x435,  0x436,  0x437,  0x438,  0x439,  0x43a,  0x43b,  0x43c,  0x43d,  0x43e,  0x43f,  0x440,  0x441,  0x442,  0x443,  0x444,  0x445,  0x446,  0x447,  0x448,  0x449,  0x44a,  0x44b,  0x44c,  0x44d,  0x44e,  0x44f,  0x461,  0x463,  0x465,  0x467,  0x469,  0x46b,  0x46d,  0x46f,  0x471,  0x473,  0x475,  0x477,  0x479,  0x47b,  0x47d,  0x47f,  0x481,  0x48b,  0x48d,  0x48f,  0x491,  0x493,  0x495,  0x497,  0x499,  0x49b,  0x49d,  0x49f,  0x4a1,  0x4a3,  0x4a5,  0x4a7,  0x4a9,  0x4ab,  0x4ad,  0x4af,  0x4b1,  0x4b3,  0x4b5,  0x4b7,  0x4b9,  0x4bb,  0x4bd,  0x4bf,  0x4cf,  0x4c2,  0x4c4,  0x4c6,  0x4c8,  0x4ca,  0x4cc,  0x4ce,  0x4d1,  0x4d3,  0x4d5,  0x4d7,  0x4d9,  0x4db,  0x4dd,  0x4df,  0x4e1,  0x4e3,  0x4e5,  0x4e7,  0x4e9,  0x4eb,  0x4ed,  0x4ef,  0x4f1,  0x4f3,  0x4f5,  0x4f7,  0x4f9,  0x4fb,  0x4fd,  0x4ff,  0x501,  0x503,  0x505,  0x507,  0x509,  0x50b,  0x50d,  0x50f,  0x511,  0x513,  0x515,  0x517,  0x519,  0x51b,  0x51d,  0x51f,  0x521,  0x523,  0x525,  0x527,  0x529,  0x52b,  0x52d,  0x52f,  0x561,  0x562,  0x563,  0x564,  0x565,  0x566,  0x567,  0x568,  0x569,  0x56a,  0x56b,  0x56c,  0x56d,  0x56e,  0x56f,  0x570,  0x571,  0x572,  0x573,  0x574,  0x575,  0x576,  0x577,  0x578,  0x579,  0x57a,  0x57b,  0x57c,  0x57d,  0x57e,  0x57f,  0x580,  0x581,  0x582,  0x583,  0x584,  0x585,  0x586,  0x2d00,  0x2d01,  0x2d02,  0x2d03,  0x2d04,  0x2d05,  0x2d06,  0x2d07,  0x2d08,  0x2d09,  0x2d0a,  0x2d0b,  0x2d0c,  0x2d0d,  0x2d0e,  0x2d0f,  0x2d10,  0x2d11,  0x2d12,  0x2d13,  0x2d14,  0x2d15,  0x2d16,  0x2d17,  0x2d18,  0x2d19,  0x2d1a,  0x2d1b,  0x2d1c,  0x2d1d,  0x2d1e,  0x2d1f,  0x2d20,  0x2d21,  0x2d22,  0x2d23,  0x2d24,  0x2d25,  0x2d27,  0x2d2d,  0xab70,  0xab71,  0xab72,  0xab73,  0xab74,  0xab75,  0xab76,  0xab77,  0xab78,  0xab79,  0xab7a,  0xab7b,  0xab7c,  0xab7d,  0xab7e,  0xab7f,  0xab80,  0xab81,  0xab82,  0xab83,  0xab84,  0xab85,  0xab86,  0xab87,  0xab88,  0xab89,  0xab8a,  0xab8b,  0xab8c,  0xab8d,  0xab8e,  0xab8f,  0xab90,  0xab91,  0xab92,  0xab93,  0xab94,  0xab95,  0xab96,  0xab97,  0xab98,  0xab99,  0xab9a,  0xab9b,  0xab9c,  0xab9d,  0xab9e,  0xab9f,  0xaba0,  0xaba1,  0xaba2,  0xaba3,  0xaba4,  0xaba5,  0xaba6,  0xaba7,  0xaba8,  0xaba9,  0xabaa,  0xabab,  0xabac,  0xabad,  0xabae,  0xabaf,  0xabb0,  0xabb1,  0xabb2,  0xabb3,  0xabb4,  0xabb5,  0xabb6,  0xabb7,  0xabb8,  0xabb9,  0xabba,  0xabbb,  0xabbc,  0xabbd,  0xabbe,  0xabbf,  0x13f8,  0x13f9,  0x13fa,  0x13fb,  0x13fc,  0x13fd,  0x10d0,  0x10d1,  0x10d2,  0x10d3,  0x10d4,  0x10d5,  0x10d6,  0x10d7,  0x10d8,  0x10d9,  0x10da,  0x10db,  0x10dc,  0x10dd,  0x10de,  0x10df,  0x10e0,  0x10e1,  0x10e2,  0x10e3,  0x10e4,  0x10e5,  0x10e6,  0x10e7,  0x10e8,  0x10e9,  0x10ea,  0x10eb,  0x10ec,  0x10ed,  0x10ee,  0x10ef,  0x10f0,  0x10f1,  0x10f2,  0x10f3,  0x10f4,  0x10f5,  0x10f6,  0x10f7,  0x10f8,  0x10f9,  0x10fa,  0x10fd,  0x10fe,  0x10ff,  0x1e01,  0x1e03,  0x1e05,  0x1e07,  0x1e09,  0x1e0b,  0x1e0d,  0x1e0f,  0x1e11,  0x1e13,  0x1e15,  0x1e17,  0x1e19,  0x1e1b,  0x1e1d,  0x1e1f,  0x1e21,  0x1e23,  0x1e25,  0x1e27,  0x1e29,  0x1e2b,  0x1e2d,  0x1e2f,  0x1e31,  0x1e33,  0x1e35,  0x1e37,  0x1e39,  0x1e3b,  0x1e3d,  0x1e3f,  0x1e41,  0x1e43,  0x1e45,  0x1e47,  0x1e49,  0x1e4b,  0x1e4d,  0x1e4f,  0x1e51,  0x1e53,  0x1e55,  0x1e57,  0x1e59,  0x1e5b,  0x1e5d,  0x1e5f,  0x1e61,  0x1e63,  0x1e65,  0x1e67,  0x1e69,  0x1e6b,  0x1e6d,  0x1e6f,  0x1e71,  0x1e73,  0x1e75,  0x1e77,  0x1e79,  0x1e7b,  0x1e7d,  0x1e7f,  0x1e81,  0x1e83,  0x1e85,  0x1e87,  0x1e89,  0x1e8b,  0x1e8d,  0x1e8f,  0x1e91,  0x1e93,  0x1e95,  0xdf,  0x1ea1,  0x1ea3,  0x1ea5,  0x1ea7,  0x1ea9,  0x1eab,  0x1ead,  0x1eaf,  0x1eb1,  0x1eb3,  0x1eb5,  0x1eb7,  0x1eb9,  0x1ebb,  0x1ebd,  0x1ebf,  0x1ec1,  0x1ec3,  0x1ec5,  0x1ec7,  0x1ec9,  0x1ecb,  0x1ecd,  0x1ecf,  0x1ed1,  0x1ed3,  0x1ed5,  0x1ed7,  0x1ed9,  0x1edb,  0x1edd,  0x1edf,  0x1ee1,  0x1ee3,  0x1ee5,  0x1ee7,  0x1ee9,  0x1eeb,  0x1eed,  0x1eef,  0x1ef1,  0x1ef3,  0x1ef5,  0x1ef7,  0x1ef9,  0x1efb,  0x1efd,  0x1eff,  0x1f00,  0x1f01,  0x1f02,  0x1f03,  0x1f04,  0x1f05,  0x1f06,  0x1f07,  0x1f10,  0x1f11,  0x1f12,  0x1f13,  0x1f14,  0x1f15,  0x1f20,  0x1f21,  0x1f22,  0x1f23,  0x1f24,  0x1f25,  0x1f26,  0x1f27,  0x1f30,  0x1f31,  0x1f32,  0x1f33,  0x1f34,  0x1f35,  0x1f36,  0x1f37,  0x1f40,  0x1f41,  0x1f42,  0x1f43,  0x1f44,  0x1f45,  0x1f51,  0x1f53,  0x1f55,  0x1f57,  0x1f60,  0x1f61,  0x1f62,  0x1f63,  0x1f64,  0x1f65,  0x1f66,  0x1f67,  0x1f80,  0x1f81,  0x1f82,  0x1f83,  0x1f84,  0x1f85,  0x1f86,  0x1f87,  0x1f90,  0x1f91,  0x1f92,  0x1f93,  0x1f94,  0x1f95,  0x1f96,  0x1f97,  0x1fa0,  0x1fa1,  0x1fa2,  0x1fa3,  0x1fa4,  0x1fa5,  0x1fa6,  0x1fa7,  0x1fb0,  0x1fb1,  0x1f70,  0x1f71,  0x1fb3,  0x1f72,  0x1f73,  0x1f74,  0x1f75,  0x1fc3,  0x1fd0,  0x1fd1,  0x1f76,  0x1f77,  0x1fe0,  0x1fe1,  0x1f7a,  0x1f7b,  0x1fe5,  0x1f78,  0x1f79,  0x1f7c,  0x1f7d,  0x1ff3,  0x3c9,  0x6b,  0xe5,  0x214e,  0x2170,  0x2171,  0x2172,  0x2173,  0x2174,  0x2175,  0x2176,  0x2177,  0x2178,  0x2179,  0x217a,  0x217b,  0x217c,  0x217d,  0x217e,  0x217f,  0x2184,  0x24d0,  0x24d1,  0x24d2,  0x24d3,  0x24d4,  0x24d5,  0x24d6,  0x24d7,  0x24d8,  0x24d9,  0x24da,  0x24db,  0x24dc,  0x24dd,  0x24de,  0x24df,  0x24e0,  0x24e1,  0x24e2,  0x24e3,  0x24e4,  0x24e5,  0x24e6,  0x24e7,  0x24e8,  0x24e9,  0x2c30,  0x2c31,  0x2c32,  0x2c33,  0x2c34,  0x2c35,  0x2c36,  0x2c37,  0x2c38,  0x2c39,  0x2c3a,  0x2c3b,  0x2c3c,  0x2c3d,  0x2c3e,  0x2c3f,  0x2c40,  0x2c41,  0x2c42,  0x2c43,  0x2c44,  0x2c45,  0x2c46,  0x2c47,  0x2c48,  0x2c49,  0x2c4a,  0x2c4b,  0x2c4c,  0x2c4d,  0x2c4e,  0x2c4f,  0x2c50,  0x2c51,  0x2c52,  0x2c53,  0x2c54,  0x2c55,  0x2c56,  0x2c57,  0x2c58,  0x2c59,  0x2c5a,  0x2c5b,  0x2c5c,  0x2c5d,  0x2c5e,  0x2c5f,  0x2c61,  0x26b,  0x1d7d,  0x27d,  0x2c68,  0x2c6a,  0x2c6c,  0x251,  0x271,  0x250,  0x252,  0x2c73,  0x2c76,  0x23f,  0x240,  0x2c81,  0x2c83,  0x2c85,  0x2c87,  0x2c89,  0x2c8b,  0x2c8d,  0x2c8f,  0x2c91,  0x2c93,  0x2c95,  0x2c97,  0x2c99,  0x2c9b,  0x2c9d,  0x2c9f,  0x2ca1,  0x2ca3,  0x2ca5,  0x2ca7,  0x2ca9,  0x2cab,  0x2cad,  0x2caf,  0x2cb1,  0x2cb3,  0x2cb5,  0x2cb7,  0x2cb9,  0x2cbb,  0x2cbd,  0x2cbf,  0x2cc1,  0x2cc3,  0x2cc5,  0x2cc7,  0x2cc9,  0x2ccb,  0x2ccd,  0x2ccf,  0x2cd1,  0x2cd3,  0x2cd5,  0x2cd7,  0x2cd9,  0x2cdb,  0x2cdd,  0x2cdf,  0x2ce1,  0x2ce3,  0x2cec,  0x2cee,  0x2cf3,  0xa641,  0xa643,  0xa645,  0xa647,  0xa649,  0xa64b,  0xa64d,  0xa64f,  0xa651,  0xa653,  0xa655,  0xa657,  0xa659,  0xa65b,  0xa65d,  0xa65f,  0xa661,  0xa663,  0xa665,  0xa667,  0xa669,  0xa66b,  0xa66d,  0xa681,  0xa683,  0xa685,  0xa687,  0xa689,  0xa68b,  0xa68d,  0xa68f,  0xa691,  0xa693,  0xa695,  0xa697,  0xa699,  0xa69b,  0xa723,  0xa725,  0xa727,  0xa729,  0xa72b,  0xa72d,  0xa72f,  0xa733,  0xa735,  0xa737,  0xa739,  0xa73b,  0xa73d,  0xa73f,  0xa741,  0xa743,  0xa745,  0xa747,  0xa749,  0xa74b,  0xa74d,  0xa74f,  0xa751,  0xa753,  0xa755,  0xa757,  0xa759,  0xa75b,  0xa75d,  0xa75f,  0xa761,  0xa763,  0xa765,  0xa767,  0xa769,  0xa76b,  0xa76d,  0xa76f,  0xa77a,  0xa77c,  0x1d79,  0xa77f,  0xa781,  0xa783,  0xa785,  0xa787,  0xa78c,  0x265,  0xa791,  0xa793,  0xa797,  0xa799,  0xa79b,  0xa79d,  0xa79f,  0xa7a1,  0xa7a3,  0xa7a5,  0xa7a7,  0xa7a9,  0x266,  0x25c,  0x261,  0x26c,  0x26a,  0x29e,  0x287,  0x29d,  0xab53,  0xa7b5,  0xa7b7,  0xa7b9,  0xa7bb,  0xa7bd,  0xa7bf,  0xa7c1,  0xa7c3,  0xa794,  0x282,  0x1d8e,  0xa7c8,  0xa7ca,  0xa7d1,  0xa7d7,  0xa7d9,  0xa7f6,  0xff41,  0xff42,  0xff43,  0xff44,  0xff45,  0xff46,  0xff47,  0xff48,  0xff49,  0xff4a,  0xff4b,  0xff4c,  0xff4d,  0xff4e,  0xff4f,  0xff50,  0xff51,  0xff52,  0xff53,  0xff54,  0xff55,  0xff56,  0xff57,  0xff58,  0xff59,  0xff5a,  0x10428,  0x10429,  0x1042a,  0x1042b,  0x1042c,  0x1042d,  0x1042e,  0x1042f,  0x10430,  0x10431,  0x10432,  0x10433,  0x10434,  0x10435,  0x10436,  0x10437,  0x10438,  0x10439,  0x1043a,  0x1043b,  0x1043c,  0x1043d,  0x1043e,  0x1043f,  0x10440,  0x10441,  0x10442,  0x10443,  0x10444,  0x10445,  0x10446,  0x10447,  0x10448,  0x10449,  0x1044a,  0x1044b,  0x1044c,  0x1044d,  0x1044e,  0x1044f,  0x104d8,  0x104d9,  0x104da,  0x104db,  0x104dc,  0x104dd,  0x104de,  0x104df,  0x104e0,  0x104e1,  0x104e2,  0x104e3,  0x104e4,  0x104e5,  0x104e6,  0x104e7,  0x104e8,  0x104e9,  0x104ea,  0x104eb,  0x104ec,  0x104ed,  0x104ee,  0x104ef,  0x104f0,  0x104f1,  0x104f2,  0x104f3,  0x104f4,  0x104f5,  0x104f6,  0x104f7,  0x104f8,  0x104f9,  0x104fa,  0x104fb,  0x10597,  0x10598,  0x10599,  0x1059a,  0x1059b,  0x1059c,  0x1059d,  0x1059e,  0x1059f,  0x105a0,  0x105a1,  0x105a3,  0x105a4,  0x105a5,  0x105a6,  0x105a7,  0x105a8,  0x105a9,  0x105aa,  0x105ab,  0x105ac,  0x105ad,  0x105ae,  0x105af,  0x105b0,  0x105b1,  0x105b3,  0x105b4,  0x105b5,  0x105b6,  0x105b7,  0x105b8,  0x105b9,  0x105bb,  0x105bc,  0x10cc0,  0x10cc1,  0x10cc2,  0x10cc3,  0x10cc4,  0x10cc5,  0x10cc6,  0x10cc7,  0x10cc8,  0x10cc9,  0x10cca,  0x10ccb,  0x10ccc,  0x10ccd,  0x10cce,  0x10ccf,  0x10cd0,  0x10cd1,  0x10cd2,  0x10cd3,  0x10cd4,  0x10cd5,  0x10cd6,  0x10cd7,  0x10cd8,  0x10cd9,  0x10cda,  0x10cdb,  0x10cdc,  0x10cdd,  0x10cde,  0x10cdf,  0x10ce0,  0x10ce1,  0x10ce2,  0x10ce3,  0x10ce4,  0x10ce5,  0x10ce6,  0x10ce7,  0x10ce8,  0x10ce9,  0x10cea,  0x10ceb,  0x10cec,  0x10ced,  0x10cee,  0x10cef,  0x10cf0,  0x10cf1,  0x10cf2,  0x118c0,  0x118c1,  0x118c2,  0x118c3,  0x118c4,  0x118c5,  0x118c6,  0x118c7,  0x118c8,  0x118c9,  0x118ca,  0x118cb,  0x118cc,  0x118cd,  0x118ce,  0x118cf,  0x118d0,  0x118d1,  0x118d2,  0x118d3,  0x118d4,  0x118d5,  0x118d6,  0x118d7,  0x118d8,  0x118d9,  0x118da,  0x118db,  0x118dc,  0x118dd,  0x118de,  0x118df,  0x16e60,  0x16e61,  0x16e62,  0x16e63,  0x16e64,  0x16e65,  0x16e66,  0x16e67,  0x16e68,  0x16e69,  0x16e6a,  0x16e6b,  0x16e6c,  0x16e6d,  0x16e6e,  0x16e6f,  0x16e70,  0x16e71,  0x16e72,  0x16e73,  0x16e74,  0x16e75,  0x16e76,  0x16e77,  0x16e78,  0x16e79,  0x16e7a,  0x16e7b,  0x16e7c,  0x16e7d,  0x16e7e,  0x16e7f,  0x1e922,  0x1e923,  0x1e924,  0x1e925,  0x1e926,  0x1e927,  0x1e928,  0x1e929,  0x1e92a,  0x1e92b,  0x1e92c,  0x1e92d,  0x1e92e,  0x1e92f,  0x1e930,  0x1e931,  0x1e932,  0x1e933,  0x1e934,  0x1e935,  0x1e936,  0x1e937,  0x1e938,  0x1e939,  0x1e93a,  0x1e93b,  0x1e93c,  0x1e93d,  0x1e93e,  0x1e93f,  0x1e940,  0x1e941,  0x1e942,  0x1e943,  0xdf,  0x2000069,  0x307,  0xfb00,  0xfb01,  0xfb02,  0xfb03,  0xfb04,  0xfb05,  0xfb06,  0x587,  0xfb13,  0xfb14,  0xfb15,  0xfb16,  0xfb17,  0x149,  0x390,  0x3b0,  0x1f0,  0x1e96,  0x1e97,  0x1e98,  0x1e99,  0x1e9a,  0x1f50,  0x1f52,  0x1f54,  0x1f56,  0x1fb6,  0x1fc6,  0x1fd2,  0x1fd3,  0x1fd6,  0x1fd7,  0x1fe2,  0x1fe3,  0x1fe4,  0x1fe6,  0x1fe7,  0x1ff6,  0x1f80,  0x1f81,  0x1f82,  0x1f83,  0x1f84,  0x1f85,  0x1f86,  0x1f87,  0x1f80,  0x1f81,  0x1f82,  0x1f83,  0x1f84,  0x1f85,  0x1f86,  0x1f87,  0x1f90,  0x1f91,  0x1f92,  0x1f93,  0x1f94,  0x1f95,  0x1f96,  0x1f97,  0x1f90,  0x1f91,  0x1f92,  0x1f93,  0x1f94,  0x1f95,  0x1f96,  0x1f97,  0x1fa0,  0x1fa1,  0x1fa2,  0x1fa3,  0x1fa4,  0x1fa5,  0x1fa6,  0x1fa7,  0x1fa0,  0x1fa1,  0x1fa2,  0x1fa3,  0x1fa4,  0x1fa5,  0x1fa6,  0x1fa7,  0x1fb3,  0x1fb3,  0x1fc3,  0x1fc3,  0x1ff3,  0x1ff3,  0x1fb2,  0x1fb4,  0x1fc2,  0x1fc4,  0x1ff2,  0x1ff4,  0x1fb7,  0x1fc7,  0x1ff7]; return t; }
_IUA toTitleTable() nothrow @nogc @safe pure { static _IUA t = [ 0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,  0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,  0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,  0x58,  0x59,  0x5a,  0x39c,  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0x178,  0x100,  0x102,  0x104,  0x106,  0x108,  0x10a,  0x10c,  0x10e,  0x110,  0x112,  0x114,  0x116,  0x118,  0x11a,  0x11c,  0x11e,  0x120,  0x122,  0x124,  0x126,  0x128,  0x12a,  0x12c,  0x12e,  0x49,  0x132,  0x134,  0x136,  0x139,  0x13b,  0x13d,  0x13f,  0x141,  0x143,  0x145,  0x147,  0x14a,  0x14c,  0x14e,  0x150,  0x152,  0x154,  0x156,  0x158,  0x15a,  0x15c,  0x15e,  0x160,  0x162,  0x164,  0x166,  0x168,  0x16a,  0x16c,  0x16e,  0x170,  0x172,  0x174,  0x176,  0x179,  0x17b,  0x17d,  0x53,  0x243,  0x182,  0x184,  0x187,  0x18b,  0x191,  0x1f6,  0x198,  0x23d,  0x220,  0x1a0,  0x1a2,  0x1a4,  0x1a7,  0x1ac,  0x1af,  0x1b3,  0x1b5,  0x1b8,  0x1bc,  0x1f7,  0x1c5,  0x1c5,  0x1c5,  0x1c8,  0x1c8,  0x1c8,  0x1cb,  0x1cb,  0x1cb,  0x1cd,  0x1cf,  0x1d1,  0x1d3,  0x1d5,  0x1d7,  0x1d9,  0x1db,  0x18e,  0x1de,  0x1e0,  0x1e2,  0x1e4,  0x1e6,  0x1e8,  0x1ea,  0x1ec,  0x1ee,  0x1f2,  0x1f2,  0x1f2,  0x1f4,  0x1f8,  0x1fa,  0x1fc,  0x1fe,  0x200,  0x202,  0x204,  0x206,  0x208,  0x20a,  0x20c,  0x20e,  0x210,  0x212,  0x214,  0x216,  0x218,  0x21a,  0x21c,  0x21e,  0x222,  0x224,  0x226,  0x228,  0x22a,  0x22c,  0x22e,  0x230,  0x232,  0x23b,  0x2c7e,  0x2c7f,  0x241,  0x246,  0x248,  0x24a,  0x24c,  0x24e,  0x2c6f,  0x2c6d,  0x2c70,  0x181,  0x186,  0x189,  0x18a,  0x18f,  0x190,  0xa7ab,  0x193,  0xa7ac,  0x194,  0xa78d,  0xa7aa,  0x197,  0x196,  0xa7ae,  0x2c62,  0xa7ad,  0x19c,  0x2c6e,  0x19d,  0x19f,  0x2c64,  0x1a6,  0xa7c5,  0x1a9,  0xa7b1,  0x1ae,  0x244,  0x1b1,  0x1b2,  0x245,  0x1b7,  0xa7b2,  0xa7b0,  0x399,  0x370,  0x372,  0x376,  0x3fd,  0x3fe,  0x3ff,  0x386,  0x388,  0x389,  0x38a,  0x391,  0x392,  0x393,  0x394,  0x395,  0x396,  0x397,  0x398,  0x399,  0x39a,  0x39b,  0x39c,  0x39d,  0x39e,  0x39f,  0x3a0,  0x3a1,  0x3a3,  0x3a3,  0x3a4,  0x3a5,  0x3a6,  0x3a7,  0x3a8,  0x3a9,  0x3aa,  0x3ab,  0x38c,  0x38e,  0x38f,  0x392,  0x398,  0x3a6,  0x3a0,  0x3cf,  0x3d8,  0x3da,  0x3dc,  0x3de,  0x3e0,  0x3e2,  0x3e4,  0x3e6,  0x3e8,  0x3ea,  0x3ec,  0x3ee,  0x39a,  0x3a1,  0x3f9,  0x37f,  0x395,  0x3f7,  0x3fa,  0x410,  0x411,  0x412,  0x413,  0x414,  0x415,  0x416,  0x417,  0x418,  0x419,  0x41a,  0x41b,  0x41c,  0x41d,  0x41e,  0x41f,  0x420,  0x421,  0x422,  0x423,  0x424,  0x425,  0x426,  0x427,  0x428,  0x429,  0x42a,  0x42b,  0x42c,  0x42d,  0x42e,  0x42f,  0x400,  0x401,  0x402,  0x403,  0x404,  0x405,  0x406,  0x407,  0x408,  0x409,  0x40a,  0x40b,  0x40c,  0x40d,  0x40e,  0x40f,  0x460,  0x462,  0x464,  0x466,  0x468,  0x46a,  0x46c,  0x46e,  0x470,  0x472,  0x474,  0x476,  0x478,  0x47a,  0x47c,  0x47e,  0x480,  0x48a,  0x48c,  0x48e,  0x490,  0x492,  0x494,  0x496,  0x498,  0x49a,  0x49c,  0x49e,  0x4a0,  0x4a2,  0x4a4,  0x4a6,  0x4a8,  0x4aa,  0x4ac,  0x4ae,  0x4b0,  0x4b2,  0x4b4,  0x4b6,  0x4b8,  0x4ba,  0x4bc,  0x4be,  0x4c1,  0x4c3,  0x4c5,  0x4c7,  0x4c9,  0x4cb,  0x4cd,  0x4c0,  0x4d0,  0x4d2,  0x4d4,  0x4d6,  0x4d8,  0x4da,  0x4dc,  0x4de,  0x4e0,  0x4e2,  0x4e4,  0x4e6,  0x4e8,  0x4ea,  0x4ec,  0x4ee,  0x4f0,  0x4f2,  0x4f4,  0x4f6,  0x4f8,  0x4fa,  0x4fc,  0x4fe,  0x500,  0x502,  0x504,  0x506,  0x508,  0x50a,  0x50c,  0x50e,  0x510,  0x512,  0x514,  0x516,  0x518,  0x51a,  0x51c,  0x51e,  0x520,  0x522,  0x524,  0x526,  0x528,  0x52a,  0x52c,  0x52e,  0x531,  0x532,  0x533,  0x534,  0x535,  0x536,  0x537,  0x538,  0x539,  0x53a,  0x53b,  0x53c,  0x53d,  0x53e,  0x53f,  0x540,  0x541,  0x542,  0x543,  0x544,  0x545,  0x546,  0x547,  0x548,  0x549,  0x54a,  0x54b,  0x54c,  0x54d,  0x54e,  0x54f,  0x550,  0x551,  0x552,  0x553,  0x554,  0x555,  0x556,  0x10d0,  0x10d1,  0x10d2,  0x10d3,  0x10d4,  0x10d5,  0x10d6,  0x10d7,  0x10d8,  0x10d9,  0x10da,  0x10db,  0x10dc,  0x10dd,  0x10de,  0x10df,  0x10e0,  0x10e1,  0x10e2,  0x10e3,  0x10e4,  0x10e5,  0x10e6,  0x10e7,  0x10e8,  0x10e9,  0x10ea,  0x10eb,  0x10ec,  0x10ed,  0x10ee,  0x10ef,  0x10f0,  0x10f1,  0x10f2,  0x10f3,  0x10f4,  0x10f5,  0x10f6,  0x10f7,  0x10f8,  0x10f9,  0x10fa,  0x10fd,  0x10fe,  0x10ff,  0x13f0,  0x13f1,  0x13f2,  0x13f3,  0x13f4,  0x13f5,  0x412,  0x414,  0x41e,  0x421,  0x422,  0x422,  0x42a,  0x462,  0xa64a,  0xa77d,  0x2c63,  0xa7c6,  0x1e00,  0x1e02,  0x1e04,  0x1e06,  0x1e08,  0x1e0a,  0x1e0c,  0x1e0e,  0x1e10,  0x1e12,  0x1e14,  0x1e16,  0x1e18,  0x1e1a,  0x1e1c,  0x1e1e,  0x1e20,  0x1e22,  0x1e24,  0x1e26,  0x1e28,  0x1e2a,  0x1e2c,  0x1e2e,  0x1e30,  0x1e32,  0x1e34,  0x1e36,  0x1e38,  0x1e3a,  0x1e3c,  0x1e3e,  0x1e40,  0x1e42,  0x1e44,  0x1e46,  0x1e48,  0x1e4a,  0x1e4c,  0x1e4e,  0x1e50,  0x1e52,  0x1e54,  0x1e56,  0x1e58,  0x1e5a,  0x1e5c,  0x1e5e,  0x1e60,  0x1e62,  0x1e64,  0x1e66,  0x1e68,  0x1e6a,  0x1e6c,  0x1e6e,  0x1e70,  0x1e72,  0x1e74,  0x1e76,  0x1e78,  0x1e7a,  0x1e7c,  0x1e7e,  0x1e80,  0x1e82,  0x1e84,  0x1e86,  0x1e88,  0x1e8a,  0x1e8c,  0x1e8e,  0x1e90,  0x1e92,  0x1e94,  0x1e60,  0x1ea0,  0x1ea2,  0x1ea4,  0x1ea6,  0x1ea8,  0x1eaa,  0x1eac,  0x1eae,  0x1eb0,  0x1eb2,  0x1eb4,  0x1eb6,  0x1eb8,  0x1eba,  0x1ebc,  0x1ebe,  0x1ec0,  0x1ec2,  0x1ec4,  0x1ec6,  0x1ec8,  0x1eca,  0x1ecc,  0x1ece,  0x1ed0,  0x1ed2,  0x1ed4,  0x1ed6,  0x1ed8,  0x1eda,  0x1edc,  0x1ede,  0x1ee0,  0x1ee2,  0x1ee4,  0x1ee6,  0x1ee8,  0x1eea,  0x1eec,  0x1eee,  0x1ef0,  0x1ef2,  0x1ef4,  0x1ef6,  0x1ef8,  0x1efa,  0x1efc,  0x1efe,  0x1f08,  0x1f09,  0x1f0a,  0x1f0b,  0x1f0c,  0x1f0d,  0x1f0e,  0x1f0f,  0x1f18,  0x1f19,  0x1f1a,  0x1f1b,  0x1f1c,  0x1f1d,  0x1f28,  0x1f29,  0x1f2a,  0x1f2b,  0x1f2c,  0x1f2d,  0x1f2e,  0x1f2f,  0x1f38,  0x1f39,  0x1f3a,  0x1f3b,  0x1f3c,  0x1f3d,  0x1f3e,  0x1f3f,  0x1f48,  0x1f49,  0x1f4a,  0x1f4b,  0x1f4c,  0x1f4d,  0x1f59,  0x1f5b,  0x1f5d,  0x1f5f,  0x1f68,  0x1f69,  0x1f6a,  0x1f6b,  0x1f6c,  0x1f6d,  0x1f6e,  0x1f6f,  0x1fba,  0x1fbb,  0x1fc8,  0x1fc9,  0x1fca,  0x1fcb,  0x1fda,  0x1fdb,  0x1ff8,  0x1ff9,  0x1fea,  0x1feb,  0x1ffa,  0x1ffb,  0x1f88,  0x1f89,  0x1f8a,  0x1f8b,  0x1f8c,  0x1f8d,  0x1f8e,  0x1f8f,  0x1f98,  0x1f99,  0x1f9a,  0x1f9b,  0x1f9c,  0x1f9d,  0x1f9e,  0x1f9f,  0x1fa8,  0x1fa9,  0x1faa,  0x1fab,  0x1fac,  0x1fad,  0x1fae,  0x1faf,  0x1fb8,  0x1fb9,  0x1fbc,  0x399,  0x1fcc,  0x1fd8,  0x1fd9,  0x1fe8,  0x1fe9,  0x1fec,  0x1ffc,  0x2132,  0x2160,  0x2161,  0x2162,  0x2163,  0x2164,  0x2165,  0x2166,  0x2167,  0x2168,  0x2169,  0x216a,  0x216b,  0x216c,  0x216d,  0x216e,  0x216f,  0x2183,  0x24b6,  0x24b7,  0x24b8,  0x24b9,  0x24ba,  0x24bb,  0x24bc,  0x24bd,  0x24be,  0x24bf,  0x24c0,  0x24c1,  0x24c2,  0x24c3,  0x24c4,  0x24c5,  0x24c6,  0x24c7,  0x24c8,  0x24c9,  0x24ca,  0x24cb,  0x24cc,  0x24cd,  0x24ce,  0x24cf,  0x2c00,  0x2c01,  0x2c02,  0x2c03,  0x2c04,  0x2c05,  0x2c06,  0x2c07,  0x2c08,  0x2c09,  0x2c0a,  0x2c0b,  0x2c0c,  0x2c0d,  0x2c0e,  0x2c0f,  0x2c10,  0x2c11,  0x2c12,  0x2c13,  0x2c14,  0x2c15,  0x2c16,  0x2c17,  0x2c18,  0x2c19,  0x2c1a,  0x2c1b,  0x2c1c,  0x2c1d,  0x2c1e,  0x2c1f,  0x2c20,  0x2c21,  0x2c22,  0x2c23,  0x2c24,  0x2c25,  0x2c26,  0x2c27,  0x2c28,  0x2c29,  0x2c2a,  0x2c2b,  0x2c2c,  0x2c2d,  0x2c2e,  0x2c2f,  0x2c60,  0x23a,  0x23e,  0x2c67,  0x2c69,  0x2c6b,  0x2c72,  0x2c75,  0x2c80,  0x2c82,  0x2c84,  0x2c86,  0x2c88,  0x2c8a,  0x2c8c,  0x2c8e,  0x2c90,  0x2c92,  0x2c94,  0x2c96,  0x2c98,  0x2c9a,  0x2c9c,  0x2c9e,  0x2ca0,  0x2ca2,  0x2ca4,  0x2ca6,  0x2ca8,  0x2caa,  0x2cac,  0x2cae,  0x2cb0,  0x2cb2,  0x2cb4,  0x2cb6,  0x2cb8,  0x2cba,  0x2cbc,  0x2cbe,  0x2cc0,  0x2cc2,  0x2cc4,  0x2cc6,  0x2cc8,  0x2cca,  0x2ccc,  0x2cce,  0x2cd0,  0x2cd2,  0x2cd4,  0x2cd6,  0x2cd8,  0x2cda,  0x2cdc,  0x2cde,  0x2ce0,  0x2ce2,  0x2ceb,  0x2ced,  0x2cf2,  0x10a0,  0x10a1,  0x10a2,  0x10a3,  0x10a4,  0x10a5,  0x10a6,  0x10a7,  0x10a8,  0x10a9,  0x10aa,  0x10ab,  0x10ac,  0x10ad,  0x10ae,  0x10af,  0x10b0,  0x10b1,  0x10b2,  0x10b3,  0x10b4,  0x10b5,  0x10b6,  0x10b7,  0x10b8,  0x10b9,  0x10ba,  0x10bb,  0x10bc,  0x10bd,  0x10be,  0x10bf,  0x10c0,  0x10c1,  0x10c2,  0x10c3,  0x10c4,  0x10c5,  0x10c7,  0x10cd,  0xa640,  0xa642,  0xa644,  0xa646,  0xa648,  0xa64a,  0xa64c,  0xa64e,  0xa650,  0xa652,  0xa654,  0xa656,  0xa658,  0xa65a,  0xa65c,  0xa65e,  0xa660,  0xa662,  0xa664,  0xa666,  0xa668,  0xa66a,  0xa66c,  0xa680,  0xa682,  0xa684,  0xa686,  0xa688,  0xa68a,  0xa68c,  0xa68e,  0xa690,  0xa692,  0xa694,  0xa696,  0xa698,  0xa69a,  0xa722,  0xa724,  0xa726,  0xa728,  0xa72a,  0xa72c,  0xa72e,  0xa732,  0xa734,  0xa736,  0xa738,  0xa73a,  0xa73c,  0xa73e,  0xa740,  0xa742,  0xa744,  0xa746,  0xa748,  0xa74a,  0xa74c,  0xa74e,  0xa750,  0xa752,  0xa754,  0xa756,  0xa758,  0xa75a,  0xa75c,  0xa75e,  0xa760,  0xa762,  0xa764,  0xa766,  0xa768,  0xa76a,  0xa76c,  0xa76e,  0xa779,  0xa77b,  0xa77e,  0xa780,  0xa782,  0xa784,  0xa786,  0xa78b,  0xa790,  0xa792,  0xa7c4,  0xa796,  0xa798,  0xa79a,  0xa79c,  0xa79e,  0xa7a0,  0xa7a2,  0xa7a4,  0xa7a6,  0xa7a8,  0xa7b4,  0xa7b6,  0xa7b8,  0xa7ba,  0xa7bc,  0xa7be,  0xa7c0,  0xa7c2,  0xa7c7,  0xa7c9,  0xa7d0,  0xa7d6,  0xa7d8,  0xa7f5,  0xa7b3,  0x13a0,  0x13a1,  0x13a2,  0x13a3,  0x13a4,  0x13a5,  0x13a6,  0x13a7,  0x13a8,  0x13a9,  0x13aa,  0x13ab,  0x13ac,  0x13ad,  0x13ae,  0x13af,  0x13b0,  0x13b1,  0x13b2,  0x13b3,  0x13b4,  0x13b5,  0x13b6,  0x13b7,  0x13b8,  0x13b9,  0x13ba,  0x13bb,  0x13bc,  0x13bd,  0x13be,  0x13bf,  0x13c0,  0x13c1,  0x13c2,  0x13c3,  0x13c4,  0x13c5,  0x13c6,  0x13c7,  0x13c8,  0x13c9,  0x13ca,  0x13cb,  0x13cc,  0x13cd,  0x13ce,  0x13cf,  0x13d0,  0x13d1,  0x13d2,  0x13d3,  0x13d4,  0x13d5,  0x13d6,  0x13d7,  0x13d8,  0x13d9,  0x13da,  0x13db,  0x13dc,  0x13dd,  0x13de,  0x13df,  0x13e0,  0x13e1,  0x13e2,  0x13e3,  0x13e4,  0x13e5,  0x13e6,  0x13e7,  0x13e8,  0x13e9,  0x13ea,  0x13eb,  0x13ec,  0x13ed,  0x13ee,  0x13ef,  0xff21,  0xff22,  0xff23,  0xff24,  0xff25,  0xff26,  0xff27,  0xff28,  0xff29,  0xff2a,  0xff2b,  0xff2c,  0xff2d,  0xff2e,  0xff2f,  0xff30,  0xff31,  0xff32,  0xff33,  0xff34,  0xff35,  0xff36,  0xff37,  0xff38,  0xff39,  0xff3a,  0x10400,  0x10401,  0x10402,  0x10403,  0x10404,  0x10405,  0x10406,  0x10407,  0x10408,  0x10409,  0x1040a,  0x1040b,  0x1040c,  0x1040d,  0x1040e,  0x1040f,  0x10410,  0x10411,  0x10412,  0x10413,  0x10414,  0x10415,  0x10416,  0x10417,  0x10418,  0x10419,  0x1041a,  0x1041b,  0x1041c,  0x1041d,  0x1041e,  0x1041f,  0x10420,  0x10421,  0x10422,  0x10423,  0x10424,  0x10425,  0x10426,  0x10427,  0x104b0,  0x104b1,  0x104b2,  0x104b3,  0x104b4,  0x104b5,  0x104b6,  0x104b7,  0x104b8,  0x104b9,  0x104ba,  0x104bb,  0x104bc,  0x104bd,  0x104be,  0x104bf,  0x104c0,  0x104c1,  0x104c2,  0x104c3,  0x104c4,  0x104c5,  0x104c6,  0x104c7,  0x104c8,  0x104c9,  0x104ca,  0x104cb,  0x104cc,  0x104cd,  0x104ce,  0x104cf,  0x104d0,  0x104d1,  0x104d2,  0x104d3,  0x10570,  0x10571,  0x10572,  0x10573,  0x10574,  0x10575,  0x10576,  0x10577,  0x10578,  0x10579,  0x1057a,  0x1057c,  0x1057d,  0x1057e,  0x1057f,  0x10580,  0x10581,  0x10582,  0x10583,  0x10584,  0x10585,  0x10586,  0x10587,  0x10588,  0x10589,  0x1058a,  0x1058c,  0x1058d,  0x1058e,  0x1058f,  0x10590,  0x10591,  0x10592,  0x10594,  0x10595,  0x10c80,  0x10c81,  0x10c82,  0x10c83,  0x10c84,  0x10c85,  0x10c86,  0x10c87,  0x10c88,  0x10c89,  0x10c8a,  0x10c8b,  0x10c8c,  0x10c8d,  0x10c8e,  0x10c8f,  0x10c90,  0x10c91,  0x10c92,  0x10c93,  0x10c94,  0x10c95,  0x10c96,  0x10c97,  0x10c98,  0x10c99,  0x10c9a,  0x10c9b,  0x10c9c,  0x10c9d,  0x10c9e,  0x10c9f,  0x10ca0,  0x10ca1,  0x10ca2,  0x10ca3,  0x10ca4,  0x10ca5,  0x10ca6,  0x10ca7,  0x10ca8,  0x10ca9,  0x10caa,  0x10cab,  0x10cac,  0x10cad,  0x10cae,  0x10caf,  0x10cb0,  0x10cb1,  0x10cb2,  0x118a0,  0x118a1,  0x118a2,  0x118a3,  0x118a4,  0x118a5,  0x118a6,  0x118a7,  0x118a8,  0x118a9,  0x118aa,  0x118ab,  0x118ac,  0x118ad,  0x118ae,  0x118af,  0x118b0,  0x118b1,  0x118b2,  0x118b3,  0x118b4,  0x118b5,  0x118b6,  0x118b7,  0x118b8,  0x118b9,  0x118ba,  0x118bb,  0x118bc,  0x118bd,  0x118be,  0x118bf,  0x16e40,  0x16e41,  0x16e42,  0x16e43,  0x16e44,  0x16e45,  0x16e46,  0x16e47,  0x16e48,  0x16e49,  0x16e4a,  0x16e4b,  0x16e4c,  0x16e4d,  0x16e4e,  0x16e4f,  0x16e50,  0x16e51,  0x16e52,  0x16e53,  0x16e54,  0x16e55,  0x16e56,  0x16e57,  0x16e58,  0x16e59,  0x16e5a,  0x16e5b,  0x16e5c,  0x16e5d,  0x16e5e,  0x16e5f,  0x1e900,  0x1e901,  0x1e902,  0x1e903,  0x1e904,  0x1e905,  0x1e906,  0x1e907,  0x1e908,  0x1e909,  0x1e90a,  0x1e90b,  0x1e90c,  0x1e90d,  0x1e90e,  0x1e90f,  0x1e910,  0x1e911,  0x1e912,  0x1e913,  0x1e914,  0x1e915,  0x1e916,  0x1e917,  0x1e918,  0x1e919,  0x1e91a,  0x1e91b,  0x1e91c,  0x1e91d,  0x1e91e,  0x1e91f,  0x1e920,  0x1e921,  0x2000053,  0x73,  0x130,  0x2000046,  0x66,  0x2000046,  0x69,  0x2000046,  0x6c,  0x3000046,  0x66,  0x69,  0x3000046,  0x66,  0x6c,  0x2000053,  0x74,  0x2000053,  0x74,  0x2000535,  0x582,  0x2000544,  0x576,  0x2000544,  0x565,  0x2000544,  0x56b,  0x200054e,  0x576,  0x2000544,  0x56d,  0x20002bc,  0x4e,  0x3000399,  0x308,  0x301,  0x30003a5,  0x308,  0x301,  0x200004a,  0x30c,  0x2000048,  0x331,  0x2000054,  0x308,  0x2000057,  0x30a,  0x2000059,  0x30a,  0x2000041,  0x2be,  0x20003a5,  0x313,  0x30003a5,  0x313,  0x300,  0x30003a5,  0x313,  0x301,  0x30003a5,  0x313,  0x342,  0x2000391,  0x342,  0x2000397,  0x342,  0x3000399,  0x308,  0x300,  0x3000399,  0x308,  0x301,  0x2000399,  0x342,  0x3000399,  0x308,  0x342,  0x30003a5,  0x308,  0x300,  0x30003a5,  0x308,  0x301,  0x20003a1,  0x313,  0x20003a5,  0x342,  0x30003a5,  0x308,  0x342,  0x20003a9,  0x342,  0x1f88,  0x1f89,  0x1f8a,  0x1f8b,  0x1f8c,  0x1f8d,  0x1f8e,  0x1f8f,  0x1f88,  0x1f89,  0x1f8a,  0x1f8b,  0x1f8c,  0x1f8d,  0x1f8e,  0x1f8f,  0x1f98,  0x1f99,  0x1f9a,  0x1f9b,  0x1f9c,  0x1f9d,  0x1f9e,  0x1f9f,  0x1f98,  0x1f99,  0x1f9a,  0x1f9b,  0x1f9c,  0x1f9d,  0x1f9e,  0x1f9f,  0x1fa8,  0x1fa9,  0x1faa,  0x1fab,  0x1fac,  0x1fad,  0x1fae,  0x1faf,  0x1fa8,  0x1fa9,  0x1faa,  0x1fab,  0x1fac,  0x1fad,  0x1fae,  0x1faf,  0x1fbc,  0x1fbc,  0x1fcc,  0x1fcc,  0x1ffc,  0x1ffc,  0x2001fba,  0x345,  0x2000386,  0x345,  0x2001fca,  0x345,  0x2000389,  0x345,  0x2001ffa,  0x345,  0x200038f,  0x345,  0x3000391,  0x342,  0x345,  0x3000397,  0x342,  0x345,  0x30003a9,  0x342,  0x345]; return t; }
}

}

