/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.BibTeXParser;
import org.jbibtex.BibTeXString;
import org.jbibtex.Key;
import org.jbibtex.LaTeXParser;
import org.jbibtex.LaTeXPrinter;
import org.jbibtex.ParseException;
import org.jbibtex.TokenMgrException;
import org.jbibtex.Value;
import writer2latex.bibtex.BibTeXEntryMap;
import writer2latex.office.BibMark;

public class BibTeXReader {
    private File file;
    private String sEncoding;
    private Map<String, BibMark> entries;

    public BibTeXReader(File file, String sEncoding) throws IOException, ParseException {
        this.file = file;
        this.sEncoding = sEncoding;
        this.reload();
    }

    public void reload() throws IOException, ParseException {
        this.entries = new HashMap<String, BibMark>();
        BibTeXDatabase database = BibTeXReader.parseBibTeX(this.file, this.sEncoding);
        this.readEntries(database);
    }

    public File getFile() {
        return this.file;
    }

    public Map<String, BibMark> getEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BibTeXDatabase parseBibTeX(File file, String sEncoding) throws ParseException, IOException {
        FileInputStream is = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)is, sEncoding);
        try {
            BibTeXParser parser = new BibTeXParser(){

                @Override
                public void checkStringResolution(Key key, BibTeXString string) {
                    if (string == null) {
                        System.err.println("Unresolved string: \"" + key.getValue() + "\"");
                    }
                }

                @Override
                public void checkCrossReferenceResolution(Key key, BibTeXEntry entry) {
                    if (entry == null) {
                        System.err.println("Unresolved cross-reference: \"" + key.getValue() + "\"");
                    }
                }
            };
            BibTeXDatabase bibTeXDatabase = parser.parse(reader);
            return bibTeXDatabase;
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    private void readEntries(BibTeXDatabase database) {
        Map<Key, BibTeXEntry> entryMap = database.getEntries();
        Collection<BibTeXEntry> bibentries = entryMap.values();
        for (BibTeXEntry bibentry : bibentries) {
            String sKey = bibentry.getKey().toString();
            String sType = bibentry.getType().toString();
            BibMark entry = new BibMark(sKey, sType);
            this.entries.put(sKey, entry);
            Map<Key, Value> fields = bibentry.getFields();
            for (Key key : fields.keySet()) {
                Value value = fields.get(key);
                BibMark.EntryType entryType = BibTeXEntryMap.getEntryType(key.getValue());
                if (entryType == null) continue;
                entry.setField(entryType, BibTeXReader.parseLaTeX(value.toUserString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseLaTeX(String string) {
        StringReader reader = new StringReader(string);
        try {
            LaTeXParser parser = new LaTeXParser();
            LaTeXPrinter printer = new LaTeXPrinter();
            String string2 = printer.print(parser.parse(reader));
            return string2;
        }
        catch (ParseException e) {
            String string3 = string;
            return string3;
        }
        catch (TokenMgrException e) {
            String string4 = string;
            return string4;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
    }
}

