/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.connections;

import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.connection.XConnection;
import com.sun.star.io.IOException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.RuntimeException;

public class PipedConnection
implements XConnection {
    public static final boolean DEBUG = false;
    private static final String __serviceName = "com.sun.star.connection.PipedConnection";
    protected static final int __waitTime = 10000;
    protected byte[] _buffer = new byte[4096];
    protected int _in;
    protected int _out;
    protected boolean _closed;
    protected PipedConnection _otherSide;

    public static XSingleServiceFactory __getServiceFactory(String implName, XMultiServiceFactory multiFactory, XRegistryKey regKey) {
        XSingleServiceFactory xSingleServiceFactory = null;
        if (implName.equals(PipedConnection.class.getName())) {
            xSingleServiceFactory = FactoryHelper.getServiceFactory(PipedConnection.class, __serviceName, multiFactory, regKey);
        }
        return xSingleServiceFactory;
    }

    public PipedConnection(Object[] args) throws RuntimeException {
        PipedConnection pipedConnection = this._otherSide = args.length == 1 ? (PipedConnection)args[0] : null;
        if (this._otherSide != null) {
            if (this._otherSide == this) {
                throw new java.lang.RuntimeException("can not connect to myself");
            }
            this._otherSide._otherSide = this;
        }
    }

    private synchronized void receive(byte[] aData) throws IOException {
        int bytesWritten = 0;
        while (bytesWritten < aData.length) {
            int bytes;
            while (this._out == this._in - 1 || this._in == 0 && this._out == this._buffer.length - 1) {
                try {
                    this.notify();
                    this.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
            if (this._closed) {
                throw new IOException("connection has been closed");
            }
            if (this._out < this._in) {
                bytes = Math.min(aData.length - bytesWritten, this._in - this._out - 1);
                System.arraycopy(aData, bytesWritten, this._buffer, this._out, bytes);
            } else {
                bytes = this._in > 0 ? Math.min(aData.length - bytesWritten, this._buffer.length - this._out) : Math.min(aData.length - bytesWritten, this._buffer.length - this._out - 1);
                System.arraycopy(aData, bytesWritten, this._buffer, this._out, bytes);
            }
            bytesWritten += bytes;
            this._out += bytes;
            if (this._out < this._buffer.length) continue;
            this._out = 0;
        }
    }

    @Override
    public synchronized int read(byte[][] aReadBytes, int nBytesToRead) throws IOException, RuntimeException {
        aReadBytes[0] = new byte[nBytesToRead];
        while (!(nBytesToRead <= 0 || this._in == this._out && this._closed)) {
            int bytes;
            while (this._in == this._out && !this._closed) {
                try {
                    this.notify();
                    this.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
            if (this._in < this._out) {
                bytes = Math.min(nBytesToRead, this._out - this._in);
                System.arraycopy(this._buffer, this._in, aReadBytes[0], aReadBytes[0].length - nBytesToRead, bytes);
                nBytesToRead -= bytes;
                this._in += bytes;
                continue;
            }
            if (this._in <= this._out) continue;
            bytes = Math.min(nBytesToRead, this._buffer.length - this._in);
            System.arraycopy(this._buffer, this._in, aReadBytes[0], aReadBytes[0].length - nBytesToRead, bytes);
            nBytesToRead -= bytes;
            this._in += bytes;
            if (this._in < this._buffer.length) continue;
            this._in = 0;
        }
        if (nBytesToRead > 0) {
            byte[] tmp = new byte[aReadBytes[0].length - nBytesToRead];
            System.arraycopy(aReadBytes[0], 0, tmp, 0, tmp.length);
            aReadBytes[0] = tmp;
        }
        return aReadBytes[0].length;
    }

    @Override
    public void write(byte[] aData) throws IOException, RuntimeException {
        this._otherSide.receive(aData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException, RuntimeException {
        PipedConnection pipedConnection = this._otherSide;
        synchronized (pipedConnection) {
            this._otherSide.notify();
        }
    }

    @Override
    public synchronized void close() throws IOException, RuntimeException {
        if (!this._closed) {
            this._closed = true;
            this._otherSide.close();
            this.notify();
        }
    }

    @Override
    public String getDescription() throws RuntimeException {
        return this.getClass().getName();
    }
}

