/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.io;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import java.io.InputStream;

public class XInputStreamImpl
implements XInputStream {
    private final InputStream is;

    public XInputStreamImpl(InputStream is) {
        this.is = is;
    }

    public int readBytes(byte[][] aData, int nBytesToRead) throws NotConnectedException, BufferSizeExceededException, IOException {
        int totalBytesRead;
        aData[0] = new byte[nBytesToRead];
        try {
            int bytesRead;
            for (totalBytesRead = 0; (bytesRead = this.is.read(aData[0], totalBytesRead, nBytesToRead)) > 0 && totalBytesRead < nBytesToRead; totalBytesRead += bytesRead, nBytesToRead -= bytesRead) {
            }
        }
        catch (java.io.IOException e) {
            throw new IOException((Throwable)e);
        }
        catch (IndexOutOfBoundsException aie) {
            throw new BufferSizeExceededException((Throwable)aie);
        }
        return totalBytesRead;
    }

    public int readSomeBytes(byte[][] aData, int nMaxBytesToRead) throws NotConnectedException, BufferSizeExceededException, IOException {
        int bytesToRead = nMaxBytesToRead;
        int availableBytes = this.available();
        if (availableBytes < nMaxBytesToRead) {
            bytesToRead = availableBytes;
        }
        int read = this.readBytes(aData, bytesToRead);
        return read;
    }

    public void skipBytes(int nBytesToSkip) throws NotConnectedException, BufferSizeExceededException, IOException {
        try {
            while ((nBytesToSkip = (int)((long)nBytesToSkip - this.is.skip(nBytesToSkip))) > 0) {
            }
        }
        catch (java.io.IOException e) {
            throw new IOException((Throwable)e);
        }
    }

    public int available() throws NotConnectedException, IOException {
        int bytesAvail = 0;
        try {
            bytesAvail = this.is.available();
        }
        catch (java.io.IOException e) {
            throw new IOException((Throwable)e);
        }
        return bytesAvail;
    }

    public void closeInput() throws NotConnectedException, IOException {
        try {
            this.is.close();
        }
        catch (java.io.IOException e) {
            throw new IOException((Throwable)e);
        }
    }
}

