/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.testkit.scaladsl;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.annotation.InternalApi;
import akka.stream.Materializer;
import akka.stream.impl.PhasedFusingActorMaterializer;
import akka.stream.impl.StreamSupervisor;
import akka.stream.impl.StreamSupervisor$GetChildren$;
import akka.stream.impl.StreamSupervisor$StopChildren$;
import akka.stream.impl.StreamSupervisor$StoppedChildren$;
import akka.stream.snapshot.ConnectionSnapshot;
import akka.stream.snapshot.ConnectionSnapshot$Closed$;
import akka.stream.snapshot.ConnectionSnapshot$ShouldPull$;
import akka.stream.snapshot.ConnectionSnapshot$ShouldPush$;
import akka.stream.snapshot.ConnectionSnapshotImpl;
import akka.stream.snapshot.InterpreterSnapshot;
import akka.stream.snapshot.LogicSnapshot;
import akka.stream.snapshot.LogicSnapshotImpl;
import akka.stream.snapshot.MaterializerState$;
import akka.stream.snapshot.RunningInterpreter;
import akka.stream.snapshot.RunningInterpreterImpl;
import akka.stream.snapshot.StreamSnapshot;
import akka.stream.snapshot.StreamSnapshotImpl;
import akka.stream.snapshot.UninitializedInterpreter;
import akka.testkit.TestProbe;
import akka.testkit.TestProbe$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StreamTestKit$ {
    public static final StreamTestKit$ MODULE$ = new StreamTestKit$();

    public <T> T assertAllStagesStopped(Function0<T> block, Materializer materializer) {
        T t;
        Materializer materializer2 = materializer;
        if (materializer2 instanceof PhasedFusingActorMaterializer) {
            PhasedFusingActorMaterializer phasedFusingActorMaterializer = (PhasedFusingActorMaterializer)materializer2;
            this.stopAllChildren(phasedFusingActorMaterializer.system(), phasedFusingActorMaterializer.supervisor());
            T result2 = block.apply();
            this.assertNoChildren(phasedFusingActorMaterializer.system(), phasedFusingActorMaterializer.supervisor());
            t = result2;
        } else {
            t = block.apply();
        }
        return t;
    }

    @InternalApi
    public void stopAllChildren(ActorSystem sys, ActorRef supervisor) {
        TestProbe probe = TestProbe$.MODULE$.apply(sys);
        probe.send(supervisor, StreamSupervisor$StopChildren$.MODULE$);
        probe.expectMsg(StreamSupervisor$StoppedChildren$.MODULE$);
    }

    @InternalApi
    public void assertNoChildren(ActorSystem sys, ActorRef supervisor) {
        TestProbe probe = TestProbe$.MODULE$.apply(sys);
        Config c = sys.settings().config().getConfig("akka.stream.testkit");
        FiniteDuration timeout = new package.DurationLong(package$.MODULE$.DurationLong(c.getDuration("all-stages-stopped-timeout", TimeUnit.MILLISECONDS))).millis();
        probe.within(timeout, () -> {
            try {
                probe.awaitAssert(() -> {
                    supervisor.tell(StreamSupervisor$GetChildren$.MODULE$, probe.ref());
                    Set<ActorRef> children = ((StreamSupervisor.Children)probe.expectMsgType(ClassTag$.MODULE$.apply(StreamSupervisor.Children.class))).children();
                    Predef$.MODULE$.assert(children.isEmpty(), (Function0<Object>)(Function0<String> & Serializable)() -> new java.lang.StringBuilder(49).append("expected no StreamSupervisor children, but got [").append(children.mkString(", ")).append("]").toString());
                }, probe.awaitAssert$default$2(), probe.awaitAssert$default$3());
            }
            catch (Throwable ex) {
                MODULE$.printDebugDump(supervisor, sys.dispatcher());
                throw ex;
            }
        });
    }

    @InternalApi
    public void printDebugDump(ActorRef streamSupervisor, ExecutionContext ec) {
        Future doneDumping = MaterializerState$.MODULE$.requestFromSupervisor(streamSupervisor, ec).map((Function1<Seq, Object> & Serializable)snapshots -> {
            snapshots.foreach((Function1<StreamSnapshot, Object> & Serializable)s -> {
                Predef$.MODULE$.println(StreamTestKit$.MODULE$.snapshotString((StreamSnapshotImpl)s));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }, ec);
        Await$.MODULE$.result(doneDumping, new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
    }

    @InternalApi
    public String snapshotString(StreamSnapshotImpl snapshot) {
        StringBuilder builder = new StringBuilder();
        builder.append(new java.lang.StringBuilder(24).append("activeShells (actor: ").append(snapshot.self()).append("):\n").toString());
        snapshot.activeInterpreters().foreach((Function1<RunningInterpreter, StringBuilder> & Serializable)shell -> {
            builder.append("  ");
            MODULE$.appendShellSnapshot(builder, (InterpreterSnapshot)shell);
            builder.append("\n");
            MODULE$.appendInterpreterSnapshot(builder, (RunningInterpreterImpl)shell);
            return builder.append("\n");
        });
        builder.append("newShells:\n");
        snapshot.newShells().foreach((Function1<UninitializedInterpreter, StringBuilder> & Serializable)shell -> {
            builder.append("  ");
            MODULE$.appendShellSnapshot(builder, (InterpreterSnapshot)shell);
            builder.append("\n");
            builder.append("    Not initialized");
            return builder.append("\n");
        });
        return builder.toString();
    }

    private void appendShellSnapshot(StringBuilder builder, InterpreterSnapshot shell) {
        builder.append("GraphInterpreterShell(\n  logics: [\n");
        Seq<LogicSnapshot> logicsToPrint = shell.logics();
        logicsToPrint.foreach((Function1<LogicSnapshot, StringBuilder> & Serializable)logic -> builder.append("    ").append(logic.label()).append(" attrs: [").append(logic.attributes().attributeList().mkString(", ")).append("],\n"));
        builder.setLength(builder.length() - 2);
        InterpreterSnapshot interpreterSnapshot = shell;
        if (interpreterSnapshot instanceof RunningInterpreter) {
            RunningInterpreter runningInterpreter = (RunningInterpreter)interpreterSnapshot;
            builder.append("\n  ],\n  connections: [\n");
            runningInterpreter.connections().foreach((Function1<ConnectionSnapshot, StringBuilder> & Serializable)connection -> builder.append("    ").append("Connection(").append(((ConnectionSnapshotImpl)connection).id()).append(", ").append(connection.in().label()).append(", ").append(connection.out().label()).append(", ").append(connection.state()).append(")\n"));
            builder.setLength(builder.length() - 2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        builder.append("\n  ]\n)");
        builder.toString();
    }

    private void appendInterpreterSnapshot(StringBuilder builder, RunningInterpreterImpl snapshot) {
        try {
            builder.append("\ndot format graph for deadlock analysis:\n");
            builder.append("================================================================\n");
            builder.append("digraph waits {\n");
            snapshot.logics().indices().foreach((Function1<Object, StringBuilder> & Serializable)i -> StreamTestKit$.$anonfun$appendInterpreterSnapshot$1(snapshot, builder, BoxesRunTime.unboxToInt(i)));
            snapshot.connections().foreach((Function1<ConnectionSnapshot, StringBuilder> & Serializable)connection -> {
                Serializable serializable;
                String inName = new java.lang.StringBuilder(1).append("N").append(((LogicSnapshotImpl)connection.in()).index()).toString();
                String outName = new java.lang.StringBuilder(1).append("N").append(((LogicSnapshotImpl)connection.out()).index()).toString();
                builder.append(new java.lang.StringBuilder(7).append("  ").append(inName).append(" -> ").append(outName).append(" ").toString());
                ConnectionSnapshot.ConnectionState connectionState = connection.state();
                if (ConnectionSnapshot$ShouldPull$.MODULE$.equals(connectionState)) {
                    serializable = builder.append("[label=shouldPull, color=blue];");
                } else if (ConnectionSnapshot$ShouldPush$.MODULE$.equals(connectionState)) {
                    serializable = builder.append("[label=shouldPush, color=red, dir=back];");
                } else if (ConnectionSnapshot$Closed$.MODULE$.equals(connectionState)) {
                    serializable = builder.append("[style=dotted, label=closed, dir=both];");
                } else if (connectionState == null) {
                    serializable = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(connectionState);
                }
                return builder.append("\n");
            });
            builder.append("}\n================================================================\n");
            builder.append(new java.lang.StringBuilder(25).append("// ").append(snapshot.queueStatus()).append(" (running=").append(snapshot.runningLogicsCount()).append(", shutdown=").append(snapshot.stoppedLogics().mkString(",")).append(")").toString());
            builder.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            builder.append("Not all logics has a stage listed, cannot create graph");
        }
    }

    public static final /* synthetic */ StringBuilder $anonfun$appendInterpreterSnapshot$1(RunningInterpreterImpl snapshot$1, StringBuilder builder$3, int i) {
        LogicSnapshot logic = (LogicSnapshot)snapshot$1.logics().apply(i);
        return builder$3.append(new java.lang.StringBuilder(15).append("  N").append(i).append(" [label=\"").append(logic.label()).append("\"];").toString()).append('\n');
    }

    private StreamTestKit$() {
    }
}

