/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.clone;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.AbstractRecursiveClone;
import com.alee.api.clone.CloneException;
import com.alee.api.clone.GlobalCloneBehavior;
import com.alee.api.clone.UnknownResolver;
import com.alee.api.clone.behavior.ArrayCloneBehavior;
import com.alee.api.clone.behavior.BasicCloneBehavior;
import com.alee.api.clone.behavior.CollectionCloneBehavior;
import com.alee.api.clone.behavior.MapCloneBehavior;
import com.alee.api.clone.behavior.RedefinedCloneBehavior;
import com.alee.api.clone.behavior.ReflectionCloneBehavior;
import com.alee.api.clone.behavior.SetCloneBehavior;
import com.alee.api.clone.unknownresolver.ExceptionUnknownResolver;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.reflection.ModifierType;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Clone
implements Serializable {
    @Nullable
    private static Map<String, Clone> commons;
    @NotNull
    private final UnknownResolver unknownResolver;
    @NotNull
    private final List<GlobalCloneBehavior> behaviors;

    public Clone(@NotNull UnknownResolver unknownResolver, GlobalCloneBehavior ... behaviors) {
        this(unknownResolver, new ImmutableList<GlobalCloneBehavior>(behaviors));
    }

    public Clone(@NotNull UnknownResolver unknownResolver, @NotNull List<GlobalCloneBehavior> behaviors) {
        this.unknownResolver = unknownResolver;
        this.behaviors = behaviors instanceof ImmutableList ? behaviors : new ImmutableList(behaviors);
    }

    @Nullable
    public <T> T clone(@Nullable T object) {
        return new InternalClone().clone(object, 0);
    }

    @NotNull
    public <T> T nonNullClone(@NotNull T object) {
        T clone = this.clone(object);
        if (clone == null) {
            throw new CloneException("Object clone is null: " + object);
        }
        return clone;
    }

    @NotNull
    public static Clone basic() {
        String identifier = "basic";
        Clone clone = Clone.commonInstance("basic");
        if (clone == null) {
            clone = new Clone((UnknownResolver)new ExceptionUnknownResolver(), new BasicCloneBehavior(), new RedefinedCloneBehavior(), new ArrayCloneBehavior(), new MapCloneBehavior(), new SetCloneBehavior(), new CollectionCloneBehavior());
            Clone.getCommons().put("basic", clone);
        }
        return clone;
    }

    @NotNull
    public static Clone deep() {
        String identifier = "deep";
        Clone clone = Clone.commonInstance("deep");
        if (clone == null) {
            clone = new Clone((UnknownResolver)new ExceptionUnknownResolver(), new BasicCloneBehavior(), new RedefinedCloneBehavior(), new ArrayCloneBehavior(), new MapCloneBehavior(), new SetCloneBehavior(), new CollectionCloneBehavior(), new ReflectionCloneBehavior(ReflectionCloneBehavior.Policy.cloneable, ModifierType.STATIC));
            Clone.getCommons().put("deep", clone);
        }
        return clone;
    }

    @NotNull
    public static Clone reflective() {
        String identifier = "reflective";
        Clone clone = Clone.commonInstance("reflective");
        if (clone == null) {
            clone = new Clone((UnknownResolver)new ExceptionUnknownResolver(), new BasicCloneBehavior(), new RedefinedCloneBehavior(), new ArrayCloneBehavior(), new MapCloneBehavior(), new SetCloneBehavior(), new CollectionCloneBehavior(), new ReflectionCloneBehavior(ReflectionCloneBehavior.Policy.all, ModifierType.STATIC));
            Clone.getCommons().put("reflective", clone);
        }
        return clone;
    }

    @Nullable
    private static Clone commonInstance(@NotNull String identifier) {
        return Clone.getCommons().get(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static Map<String, Clone> getCommons() {
        if (commons != null) return commons;
        Class<Clone> clazz = Clone.class;
        synchronized (Clone.class) {
            if (commons != null) return commons;
            commons = new ConcurrentHashMap<String, Clone>(4);
            // ** MonitorExit[var0] (shouldn't be in output)
            return commons;
        }
    }

    private class InternalClone
    extends AbstractRecursiveClone {
        private InternalClone() {
        }

        @Override
        @Nullable
        public <T> T clone(@Nullable T object, int depth) {
            Object result2;
            if (object != null) {
                Object cached = this.retrieve(object);
                if (cached == null) {
                    Object cloneResult = null;
                    GlobalCloneBehavior resultBehavior = null;
                    for (GlobalCloneBehavior behavior : Clone.this.behaviors) {
                        if (!behavior.supports(this, object)) continue;
                        cloneResult = behavior.clone(this, object, depth);
                        resultBehavior = behavior;
                        break;
                    }
                    if (resultBehavior != null) {
                        result2 = cloneResult;
                        if (depth > 0 && resultBehavior.isStorable()) {
                            this.store(object, result2);
                        }
                    } else {
                        result2 = Clone.this.unknownResolver.resolve(this, object);
                        if (depth > 0) {
                            this.store(object, result2);
                        }
                    }
                } else {
                    result2 = cached;
                }
            } else {
                result2 = null;
            }
            return (T)result2;
        }

        @Override
        @NotNull
        public <T> T cloneFields(@NotNull T object, int depth) {
            for (GlobalCloneBehavior behavior : Clone.this.behaviors) {
                if (!(behavior instanceof ReflectionCloneBehavior) || !behavior.supports(this, object)) continue;
                return behavior.clone(this, object, depth);
            }
            throw new CloneException("There is no ReflectionCloneBehavior in Clone algorithm");
        }
    }
}

