/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.data;

import java.awt.ComponentOrientation;
import javax.swing.SwingConstants;

public enum CompassDirection implements SwingConstants
{
    center(0),
    northEast(2),
    north(1),
    northWest(8),
    east(3),
    west(7),
    southEast(4),
    south(5),
    southWest(6);

    private final int value;

    private CompassDirection(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public CompassDirection opposite() {
        CompassDirection opposite;
        switch (this) {
            case northEast: {
                opposite = southWest;
                break;
            }
            case north: {
                opposite = south;
                break;
            }
            case northWest: {
                opposite = southEast;
                break;
            }
            case east: {
                opposite = west;
                break;
            }
            case west: {
                opposite = east;
                break;
            }
            case southEast: {
                opposite = northWest;
                break;
            }
            case south: {
                opposite = north;
                break;
            }
            case southWest: {
                opposite = northEast;
                break;
            }
            default: {
                opposite = center;
            }
        }
        return opposite;
    }

    public CompassDirection adjust(ComponentOrientation orientation) {
        CompassDirection adjusted;
        if (!orientation.isLeftToRight()) {
            switch (this) {
                case northEast: {
                    adjusted = northWest;
                    break;
                }
                case northWest: {
                    adjusted = northEast;
                    break;
                }
                case east: {
                    adjusted = west;
                    break;
                }
                case west: {
                    adjusted = east;
                    break;
                }
                case southEast: {
                    adjusted = southWest;
                    break;
                }
                case southWest: {
                    adjusted = southEast;
                    break;
                }
                default: {
                    adjusted = this;
                    break;
                }
            }
        } else {
            adjusted = this;
        }
        return adjusted;
    }

    public static CompassDirection get(int value) {
        CompassDirection direction;
        switch (value) {
            case 2: {
                direction = northEast;
                break;
            }
            case 1: {
                direction = north;
                break;
            }
            case 8: {
                direction = northWest;
                break;
            }
            case 3: {
                direction = east;
                break;
            }
            case 7: {
                direction = west;
                break;
            }
            case 4: {
                direction = southEast;
                break;
            }
            case 5: {
                direction = south;
                break;
            }
            case 6: {
                direction = southWest;
                break;
            }
            default: {
                direction = center;
            }
        }
        return direction;
    }
}

