/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.matcher;

import com.alee.api.Identifiable;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.api.matcher.AbstractMatcher;
import com.alee.api.matcher.MatchingException;

public final class IdentifiableMatcher
extends AbstractMatcher<Object, Object> {
    @Override
    public boolean supports(@Nullable Object object) {
        return object instanceof Identifiable || object instanceof Enum;
    }

    @Override
    protected boolean matchImpl(@Nullable Object first, @Nullable Object second) {
        boolean match;
        if (first instanceof Identifiable && second instanceof Identifiable) {
            String id1 = ((Identifiable)first).getId();
            String id2 = ((Identifiable)second).getId();
            match = Objects.equals((Object)id1, (Object)id2);
        } else if (first instanceof Enum && second instanceof Enum) {
            match = first == second;
        } else {
            String message = "Cannot match objects: %s and %s";
            throw new MatchingException(String.format("Cannot match objects: %s and %s", first, second));
        }
        return match;
    }
}

