/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.merge.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.merge.GlobalMergeBehavior;
import com.alee.api.merge.MergeException;
import com.alee.api.merge.Mergeable;
import com.alee.api.merge.RecursiveMerge;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.api.merge.behavior.OverwriteOnMerge;
import com.alee.api.merge.behavior.PreserveOnMerge;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.reflection.ClassRelationType;
import com.alee.utils.reflection.ModifierType;
import java.lang.reflect.Field;
import java.util.List;

public class ReflectionMergeBehavior
implements GlobalMergeBehavior<Object, Object, Object> {
    @NotNull
    private final Policy policy;
    @NotNull
    private final List<ModifierType> ignoredModifiers;

    public ReflectionMergeBehavior(@NotNull Policy policy, ModifierType ... ignoredModifiers) {
        this.policy = policy;
        this.ignoredModifiers = CollectionUtils.asList(ignoredModifiers);
    }

    @Override
    public boolean supports(@NotNull RecursiveMerge merge, @NotNull Class<Object> type, @NotNull Object base, @NotNull Object merged) {
        return (this.policy == Policy.all || base instanceof Mergeable && merged instanceof Mergeable) && type.isAssignableFrom(base.getClass()) && type.isAssignableFrom(merged.getClass());
    }

    @Override
    @NotNull
    public Object merge(@NotNull RecursiveMerge merge, @NotNull Class type, @NotNull Object base, @NotNull Object merged, int depth) {
        Object result2;
        ClassRelationType relation = ClassRelationType.of(base, merged);
        if (relation.isSame() || relation.isAncestor()) {
            List<Field> fields = ReflectUtils.getFields(merged.getClass());
            if (CollectionUtils.notEmpty(fields)) {
                for (Field field2 : fields) {
                    String message;
                    if (!ReflectUtils.hasNoneOfModifiers(field2, this.ignoredModifiers)) continue;
                    Class<?> fieldType = field2.getType();
                    if (field2.getAnnotation(OmitOnMerge.class) != null) {
                        try {
                            Object value = fieldType.isPrimitive() ? ReflectUtils.getDefaultPrimitiveValue(fieldType) : null;
                            ReflectUtils.setFieldValue(base, field2, value);
                            continue;
                        }
                        catch (Exception e) {
                            message = "Unable to omit field {%s} value";
                            throw new MergeException(String.format("Unable to omit field {%s} value", field2), e);
                        }
                    }
                    if (field2.getAnnotation(PreserveOnMerge.class) != null) continue;
                    try {
                        Object baseValue = field2.get(base);
                        Object mergedValue = field2.get(merged);
                        Object mergeResult = field2.getAnnotation(OverwriteOnMerge.class) == null ? merge.merge(fieldType, baseValue, mergedValue, depth + 1) : merge.overwrite(baseValue, mergedValue);
                        ReflectUtils.setFieldValue(base, field2, mergeResult);
                    }
                    catch (Exception e) {
                        message = "Unable to merge field {%s} values for objects {%s} and {%s}";
                        throw new MergeException(String.format("Unable to merge field {%s} values for objects {%s} and {%s}", field2, base, merged), e);
                    }
                }
            }
            result2 = base;
        } else {
            result2 = merged;
        }
        return result2;
    }

    public static enum Policy {
        mergeable,
        all;

    }
}

