/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.resource;

import com.alee.api.annotations.NotNull;
import com.alee.api.resource.Resource;
import com.alee.api.resource.ResourceException;
import com.alee.utils.NetUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

@XStreamAlias(value="UrlResource")
public final class UrlResource
implements Resource {
    @XStreamAsAttribute
    @NotNull
    private final String url;

    public UrlResource(@NotNull URL url2) {
        this(NetUtils.getAddress(url2));
    }

    public UrlResource(@NotNull String url2) {
        this.url = url2;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        try {
            return new URL(this.url).openStream();
        }
        catch (IOException e) {
            throw new ResourceException("Unable to open UrlResource stream for url: " + this.url, e);
        }
    }
}

