/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.accordion;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.data.BoxOrientation;
import com.alee.api.merge.Mergeable;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.extended.accordion.AccordionPane;
import com.alee.extended.accordion.WebAccordion;
import com.alee.laf.grouping.AbstractGroupingLayout;
import com.alee.managers.animation.easing.Easing;
import com.alee.managers.animation.transition.AbstractTransition;
import com.alee.managers.animation.transition.TimedTransition;
import com.alee.managers.animation.transition.Transition;
import com.alee.managers.animation.transition.TransitionAdapter;
import com.alee.managers.animation.transition.TransitionListener;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.parsing.DurationUnits;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

@XStreamAlias(value="AccordionLayout")
public class AccordionLayout
extends AbstractGroupingLayout
implements Mergeable,
Cloneable,
Serializable {
    @Nullable
    protected Integer panesGap;
    @Nullable
    protected Easing easing;
    @Nullable
    protected String duration;
    @OmitOnClone
    @OmitOnMerge
    protected transient Map<String, AbstractTransition> transitions;
    @OmitOnClone
    @OmitOnMerge
    protected transient Map<String, Float> contentSizes;

    public AccordionLayout() {
        this(null, null);
    }

    public AccordionLayout(@Nullable Easing easing, @Nullable Long duration) {
        this.setEasing(easing);
        this.setDuration(duration);
    }

    public int getPanesGap() {
        return this.panesGap != null ? this.panesGap : 0;
    }

    public void setPanesGap(int gap) {
        this.panesGap = gap;
    }

    @Nullable
    public Easing getEasing() {
        return this.easing;
    }

    public void setEasing(@Nullable Easing easing) {
        this.easing = easing;
    }

    public long getDuration() {
        return this.duration != null ? DurationUnits.get().fromString(this.duration) : 0L;
    }

    public void setDuration(@Nullable Long duration) {
        this.duration = duration != null ? DurationUnits.get().toString(duration) : null;
    }

    public void install(@NotNull WebAccordion accordion) {
        this.contentSizes = new HashMap<String, Float>(accordion.getComponentCount());
        this.transitions = new HashMap<String, AbstractTransition>(3);
        for (AccordionPane pane : accordion.getPanes()) {
            this.addComponent(pane, null);
            this.paneAdded(accordion, pane);
        }
    }

    public void uninstall(@NotNull WebAccordion accordion) {
        for (AccordionPane pane : accordion.getPanes()) {
            this.removeComponent(pane);
            this.paneRemoved(accordion, pane);
        }
        this.transitions = null;
        this.contentSizes = null;
    }

    public void paneAdded(@NotNull WebAccordion accordion, @NotNull AccordionPane pane) {
        this.size(accordion, pane.getId());
    }

    public void paneRemoved(@NotNull WebAccordion accordion, @NotNull AccordionPane pane) {
        AbstractTransition transition = this.transitions.get(pane.getId());
        if (transition != null) {
            transition.stop();
            this.transitions.remove(pane.getId());
        }
        this.contentSizes.remove(pane.getId());
    }

    protected float size(WebAccordion accordion, String id) {
        float size;
        if (this.contentSizes.containsKey(id)) {
            size = this.contentSizes.get(id).floatValue();
        } else {
            size = accordion.isPaneExpanded(id) ? 1.0f : 0.0f;
            this.contentSizes.put(id, Float.valueOf(size));
        }
        return size;
    }

    public void expandPane(final @NotNull WebAccordion accordion, final @NotNull String id) {
        this.changePaneState(accordion, id, this.size(accordion, id), 1.0f, new Runnable(){

            @Override
            public void run() {
                AccordionPane pane = accordion.getPane(id);
                pane.fireExpanding(accordion);
                accordion.fireExpanding(pane);
            }
        }, new Runnable(){

            @Override
            public void run() {
                AccordionPane pane = accordion.getPane(id);
                pane.fireExpanded(accordion);
                accordion.fireExpanded(pane);
            }
        });
    }

    public void collapsePane(final @NotNull WebAccordion accordion, final @NotNull String id) {
        this.changePaneState(accordion, id, this.size(accordion, id), 0.0f, new Runnable(){

            @Override
            public void run() {
                AccordionPane pane = accordion.getPane(id);
                pane.fireCollapsing(accordion);
                accordion.fireCollapsing(pane);
            }
        }, new Runnable(){

            @Override
            public void run() {
                AccordionPane pane = accordion.getPane(id);
                pane.fireCollapsed(accordion);
                accordion.fireCollapsed(pane);
            }
        });
    }

    protected void changePaneState(final @NotNull WebAccordion accordion, final @NotNull String id, float start2, float target, @NotNull Runnable preChange, final @NotNull Runnable afterChange) {
        AbstractTransition transition = this.transitions.get(id);
        if (transition != null) {
            transition.stop();
            this.transitions.remove(id);
        }
        Easing easing = this.getEasing();
        long fullDuration = this.getDuration();
        if (accordion.isAnimated() && accordion.isShowing() && easing != null && fullDuration > 0L) {
            TimedTransition<Float> stateTransition = new TimedTransition<Float>(Float.valueOf(start2), Float.valueOf(target), easing, fullDuration);
            this.transitions.put(id, stateTransition);
            preChange.run();
            stateTransition.addListener((TransitionListener<Float>)new TransitionAdapter<Float>(){

                @Override
                public void adjusted(Transition transition, Float value) {
                    AccordionLayout.this.contentSizes.put(id, value);
                    SwingUtils.update(accordion);
                }

                @Override
                public void finished(Transition transition, Float value) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AccordionLayout.this.transitions.remove(id);
                            afterChange.run();
                        }
                    });
                }
            });
            stateTransition.play();
        } else {
            preChange.run();
            this.contentSizes.put(id, Float.valueOf(target));
            SwingUtils.update(accordion);
            afterChange.run();
        }
    }

    public boolean isPaneInTransition(@NotNull String id) {
        return this.transitions.containsKey(id);
    }

    @Override
    public void layoutContainer(@NotNull Container parent) {
        WebAccordion accordion = (WebAccordion)parent;
        BoxOrientation headerPosition = accordion.getHeaderPosition();
        int panesGap = this.getPanesGap();
        boolean vertical = headerPosition.isTop() || headerPosition.isBottom();
        int count = accordion.getComponentCount();
        int w = parent.getWidth();
        int h = parent.getHeight();
        Insets insets = parent.getInsets();
        int cw = w - insets.left - insets.right;
        int ch = h - insets.top - insets.bottom;
        float totalExpanded = 0.0f;
        int expandedCount = 0;
        int freePixels = vertical ? ch : cw;
        Dimension[] preferred = new Dimension[count];
        for (int i = 0; i < count; ++i) {
            Dimension cps;
            AccordionPane pane = (AccordionPane)accordion.getComponent(i);
            preferred[i] = cps = pane.getPreferredSize();
            float expansion = this.size(accordion, pane.getId());
            boolean fullyExpanded = Float.compare(expansion, 1.0f) == 0;
            boolean partiallyExpanded = !fullyExpanded && Float.compare(expansion, 0.0f) == 1;
            totalExpanded += fullyExpanded || partiallyExpanded ? expansion : 0.0f;
            expandedCount += fullyExpanded || partiallyExpanded ? 1 : 0;
            freePixels -= vertical ? cps.height : cps.width;
            freePixels -= i > 0 ? panesGap : 0;
        }
        float totalFreePixels = freePixels;
        int x = insets.left;
        int y = insets.top;
        int expandedPositioned = 0;
        for (int i = 0; i < count; ++i) {
            AccordionPane pane = (AccordionPane)accordion.getComponent(i);
            Dimension cps = preferred[i];
            float expanded = this.size(accordion, pane.getId());
            if (Float.compare(expanded, 0.0f) == 1) {
                int panePixels = expandedPositioned < expandedCount - 1 ? Math.round(totalFreePixels * expanded / totalExpanded) : freePixels;
                pane.setBounds(x, y, vertical ? cw : cps.width + panePixels, vertical ? cps.height + panePixels : ch);
                freePixels -= panePixels;
                ++expandedPositioned;
            } else {
                pane.setBounds(x, y, vertical ? cw : cps.width, vertical ? cps.height : ch);
            }
            x += vertical ? 0 : pane.getWidth() + panesGap;
            y += vertical ? pane.getHeight() + panesGap : 0;
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Dimension ps = new Dimension(0, 0);
        WebAccordion accordion = (WebAccordion)parent;
        BoxOrientation headerPosition = accordion.getHeaderPosition();
        int panesGap = this.getPanesGap();
        boolean vertical = headerPosition.isTop() || headerPosition.isBottom();
        int count = accordion.getComponentCount();
        Insets insets = parent.getInsets();
        for (int i = 0; i < count; ++i) {
            AccordionPane pane = (AccordionPane)accordion.getComponent(i);
            Dimension cps = pane.getPreferredSize();
            if (vertical) {
                ps.width = Math.max(ps.width, cps.width);
                ps.height = ps.height + (cps.height + (i > 0 ? panesGap : 0) + (i > 0 ? panesGap : 0));
                continue;
            }
            ps.width = ps.width + (cps.width + (i > 0 ? panesGap : 0) + (i > 0 ? panesGap : 0));
            ps.height = Math.max(ps.height, cps.height);
        }
        if (vertical) {
            ps.height += accordion.getMinimumPaneContentSize() * accordion.getMinimumExpandedPaneCount();
        } else {
            ps.width += accordion.getMinimumPaneContentSize() * accordion.getMinimumExpandedPaneCount();
        }
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }

    @Override
    @NotNull
    protected String sides() {
        return this.sides != null ? this.sides : (this.sides = "0,0,0,0");
    }

    @Override
    @NotNull
    public Pair<String, String> getDescriptors(@NotNull Container container, @NotNull Component component2, int index) {
        Pair<String, String> descriptors;
        if (this.getPanesGap() == 0) {
            WebAccordion accordion = (WebAccordion)container;
            int last = container.getComponentCount() - 1;
            boolean hor = accordion.getHeaderPosition().isLeft() || accordion.getHeaderPosition().isRight();
            boolean top = (hor || index == 0) && this.isPaintTop();
            boolean left = (index == 0 || !hor) && this.isPaintLeft();
            boolean bottom = (hor || index == last) && this.isPaintBottom();
            boolean right = (index == last || !hor) && this.isPaintRight();
            String sides = DecorationUtils.toString(top, left, bottom, right);
            String lines = DecorationUtils.toString(false, false, !hor && index != last, hor && index != last);
            descriptors = new Pair<String, String>(sides, lines);
        } else {
            descriptors = new Pair<String, String>();
        }
        return descriptors;
    }

    @XStreamAlias(value="AccordionLayout$UIResource")
    public static final class UIResource
    extends AccordionLayout
    implements javax.swing.plaf.UIResource {
    }
}

