/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.accordion;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.Mergeable;
import com.alee.extended.accordion.AccordionPaneState;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@XStreamAlias(value="AccordionState")
public class AccordionState
implements Mergeable,
Cloneable,
Serializable {
    @XStreamImplicit
    @Nullable
    protected List<AccordionPaneState> states;

    public AccordionState() {
        this.states = new ArrayList<AccordionPaneState>();
    }

    public AccordionState(AccordionPaneState ... states) {
        this.states = new ArrayList<AccordionPaneState>(states.length);
        for (AccordionPaneState state : states) {
            this.addState(state);
        }
    }

    public AccordionState(@NotNull Map<String, AccordionPaneState> states) {
        this.states = new ArrayList<AccordionPaneState>(states.values());
    }

    @NotNull
    public Map<String, AccordionPaneState> states() {
        HashMap<String, AccordionPaneState> states = new HashMap<String, AccordionPaneState>();
        if (this.states != null) {
            for (AccordionPaneState state : this.states) {
                states.put(state.getId(), state);
            }
        }
        return states;
    }

    public void addState(@NotNull AccordionPaneState state) {
        if (this.states == null) {
            this.states = new ArrayList<AccordionPaneState>();
        }
        Iterator<AccordionPaneState> iterator = this.states.iterator();
        while (iterator.hasNext()) {
            if (!Objects.equals((Object)iterator.next().getId(), (Object)state.getId())) continue;
            iterator.remove();
        }
        this.states.add(state);
    }

    public void setStates(@NotNull Map<String, AccordionPaneState> states) {
        this.states = new ArrayList<AccordionPaneState>(states.values());
    }
}

