/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.accordion;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.accordion.AccordionListener;
import com.alee.extended.accordion.AccordionPane;
import com.alee.extended.accordion.WAccordionUI;
import com.alee.extended.accordion.WebAccordion;
import com.alee.extended.collapsible.AbstractHeaderPanel;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WebAccordionUI<C extends WebAccordion>
extends WAccordionUI<C>
implements PropertyChangeListener,
AccordionListener {
    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebAccordionUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.accordion);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.accordion);
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        this.accordion.addPropertyChangeListener(this);
        this.accordion.addAccordionListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.accordion.removeAccordionListener(this);
        this.accordion.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if (Objects.equals((Object)property, (Object)"animated")) {
            this.updateDecorationStates();
        } else if (Objects.equals((Object)property, (Object)"headerPosition")) {
            this.updateDecorationStates();
        } else if (Objects.equals((Object)property, (Object)"minimumPaneContentSize")) {
            SwingUtils.update(this.accordion);
        } else if (Objects.equals((Object)property, (Object)"panes")) {
            this.updateDecorationStates();
        }
    }

    @Override
    public void expanding(@NotNull WebAccordion accordion, @NotNull AccordionPane pane) {
        this.updateDecorationStates(pane);
    }

    @Override
    public void expanded(@NotNull WebAccordion accordion, @NotNull AccordionPane pane) {
        this.updateDecorationStates(pane);
    }

    @Override
    public void collapsing(@NotNull WebAccordion accordion, @NotNull AccordionPane pane) {
        this.updateDecorationStates(pane);
    }

    @Override
    public void collapsed(@NotNull WebAccordion accordion, @NotNull AccordionPane pane) {
        this.updateDecorationStates(pane);
    }

    protected void updateDecorationStates() {
        for (AccordionPane pane : this.accordion.getPanes()) {
            this.updateDecorationStates(pane);
        }
    }

    protected void updateDecorationStates(@NotNull AccordionPane pane) {
        JComponent header = pane.getHeader();
        if (header instanceof AbstractHeaderPanel) {
            AbstractHeaderPanel headerPanel = (AbstractHeaderPanel)header;
            DecorationUtils.fireStatesChanged(headerPanel.getTitle());
            DecorationUtils.fireStatesChanged(headerPanel.getControl());
        }
        DecorationUtils.fireStatesChanged(header);
        DecorationUtils.fireStatesChanged(pane);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c);
    }
}

