/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.api.annotations.NotNull;
import com.alee.extended.breadcrumb.WebBreadcrumb;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractClipBackground;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.JComponent;

@XStreamAlias(value="BreadcrumbProgressBackground")
public class BreadcrumbProgressBackground<C extends JComponent, D extends IDecoration<C, D>, I extends BreadcrumbProgressBackground<C, D, I>>
extends AbstractClipBackground<C, D, I> {
    @Override
    @NotNull
    protected Shape clip(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        Shape clippedShape;
        Container parent = ((Component)c).getParent();
        if (parent instanceof WebBreadcrumb) {
            WebBreadcrumb breadcrumb = (WebBreadcrumb)parent;
            double progress = breadcrumb.getProgress((JComponent)c);
            boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
            Rectangle shapeBounds = shape.getBounds();
            int pw = (int)Math.round((double)shapeBounds.width * progress);
            shapeBounds.x = ltr ? shapeBounds.x : shapeBounds.x + shapeBounds.width - pw;
            shapeBounds.width = pw;
            Area area = new Area(shape);
            area.intersect(new Area(shapeBounds));
            clippedShape = area;
        } else {
            clippedShape = shape;
        }
        return clippedShape;
    }
}

