/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb.element;

import com.alee.extended.breadcrumb.WebBreadcrumb;
import com.alee.extended.breadcrumb.element.BreadcrumbElementData;
import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;

public final class BreadcrumbElementUtils {
    public static void addBreadcrumbElementStates(JComponent component2, List<String> states) {
        Container parent = component2.getParent();
        if (parent instanceof WebBreadcrumb) {
            WebBreadcrumb breadcrumb = (WebBreadcrumb)parent;
            boolean first = breadcrumb.isFirst(component2);
            boolean last = breadcrumb.isLast(component2);
            if (first && !last) {
                states.add("first");
            } else if (!first && !last) {
                states.add("middle");
            } else if (last && !first) {
                states.add("last");
            } else if (first && last) {
                states.add("single");
            }
            BreadcrumbElementData.ProgressType progressType = breadcrumb.getProgressType(component2);
            if (progressType == BreadcrumbElementData.ProgressType.progress) {
                boolean max;
                states.add("progress");
                double value = breadcrumb.getProgress(component2);
                boolean min = value == 0.0;
                boolean bl = max = value == 1.0;
                if (min) {
                    states.add("minimum");
                }
                if (max) {
                    states.add("maximum");
                }
                if (!min && !max) {
                    states.add("intermediate");
                }
            } else if (progressType == BreadcrumbElementData.ProgressType.indeterminate) {
                states.add("indeterminate");
            }
        }
    }
}

