/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.collapsible;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.laf.button.WebButton;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.Stateful;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractControlButton
extends WebButton
implements Stateful {
    public AbstractControlButton() {
        this(StyleId.auto);
    }

    public AbstractControlButton(@NotNull StyleId id) {
        super(id);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractControlButton.this.onControlAction(e);
            }
        });
    }

    @NotNull
    public abstract BoxOrientation getHeaderPosition();

    public abstract boolean isExpanded();

    public abstract boolean isInTransition();

    protected abstract void onControlAction(@NotNull ActionEvent var1);

    @Override
    @Nullable
    public List<String> getStates() {
        ArrayList<String> states = new ArrayList<String>(3);
        states.add(this.getHeaderPosition().name());
        states.add(this.isExpanded() || this.isInTransition() ? "expanded" : "collapsed");
        if (this.isInTransition()) {
            states.add(this.isExpanded() ? "expanding" : "collapsing");
        }
        return states;
    }

    public static abstract class UIResource
    extends AbstractControlButton
    implements javax.swing.plaf.UIResource {
    }
}

