/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.collapsible;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.extended.collapsible.HeaderLayout;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.Stateful;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class AbstractHeaderPanel
extends WebPanel
implements Stateful {
    public AbstractHeaderPanel() {
        this(StyleId.auto);
    }

    public AbstractHeaderPanel(@NotNull StyleId id) {
        super(id, new HeaderLayout(), new Component[0]);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    Point point = e.getPoint();
                    if (0 <= point.x && point.x < AbstractHeaderPanel.this.getWidth() && 0 <= point.y && point.y < AbstractHeaderPanel.this.getHeight()) {
                        AbstractHeaderPanel.this.onHeaderAction(e);
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(@NotNull KeyEvent e) {
                if (Hotkey.ENTER.isTriggered(e) || Hotkey.SPACE.isTriggered(e)) {
                    AbstractHeaderPanel.this.onHeaderAction(e);
                }
            }
        });
    }

    @Override
    public void setLayout(@Nullable LayoutManager layout) {
        if (layout != null && !(layout instanceof HeaderLayout)) {
            throw new IllegalArgumentException("Only HeaderLayout instances are supported");
        }
        super.setLayout(layout);
    }

    @Override
    @Nullable
    public HeaderLayout getLayout() {
        return (HeaderLayout)super.getLayout();
    }

    @Nullable
    public Component getTitle() {
        HeaderLayout layout = this.getLayout();
        return layout != null ? layout.getTitle() : null;
    }

    @Nullable
    public Component getControl() {
        HeaderLayout layout = this.getLayout();
        return layout != null ? layout.getControl() : null;
    }

    @NotNull
    public abstract BoxOrientation getHeaderPosition();

    public abstract boolean isExpanded();

    public abstract boolean isInTransition();

    protected abstract void onHeaderAction(@NotNull InputEvent var1);

    @Override
    @Nullable
    public List<String> getStates() {
        ArrayList<String> states = new ArrayList<String>(2);
        states.add(this.getHeaderPosition().name());
        states.add(this.isExpanded() || this.isInTransition() ? "expanded" : "collapsed");
        if (this.isInTransition()) {
            states.add(this.isExpanded() ? "expanding" : "collapsing");
        }
        return states;
    }

    public static abstract class UIResource
    extends AbstractHeaderPanel
    implements javax.swing.plaf.UIResource {
    }
}

