/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.date;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.WebComponent;
import com.alee.extended.date.DateListener;
import com.alee.extended.date.WDateFieldUI;
import com.alee.extended.date.WebCalendar;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.utils.swing.Customizer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WebDateField
extends WebComponent<WebDateField, WDateFieldUI> {
    public static final String DATE_PROPERTY = "date";
    public static final String DATE_FORMAT_PROPERTY = "dateFormat";
    public static final String ALLOW_USER_INPUT_PROPERTY = "allowUserInput";
    public static final String CALENDAR_CUSTOMIZER_PROPERTY = "calendarCustomizer";
    @Nullable
    protected Date date = null;
    @NotNull
    protected DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy", LanguageManager.getLocale());
    protected boolean allowUserInput = true;
    @Nullable
    protected Customizer<WebCalendar> calendarCustomizer = null;

    public WebDateField() {
        this(StyleId.auto);
    }

    public WebDateField(@Nullable Date date) {
        this(StyleId.auto, date);
    }

    public WebDateField(@NotNull StyleId id) {
        this(id, null);
    }

    public WebDateField(@NotNull StyleId id, @Nullable Date date) {
        this.updateUI();
        this.setStyleId(id);
        this.setDate(date);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.datefield;
    }

    @Nullable
    public Date getDate() {
        return this.date != null ? new Date(this.date.getTime()) : null;
    }

    public void setDate(@Nullable Date date) {
        Date previous = this.date;
        this.date = date != null ? new Date(date.getTime()) : null;
        this.firePropertyChange(DATE_PROPERTY, previous, this.date);
        this.fireDateChanged(this.date);
    }

    @NotNull
    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(@NotNull DateFormat dateFormat) {
        DateFormat previous = this.dateFormat;
        this.dateFormat = dateFormat;
        this.firePropertyChange(DATE_FORMAT_PROPERTY, previous, dateFormat);
    }

    public boolean isAllowUserInput() {
        return this.allowUserInput;
    }

    public void setAllowUserInput(boolean allowUserInput) {
        boolean previous = this.allowUserInput;
        this.allowUserInput = allowUserInput;
        this.firePropertyChange(ALLOW_USER_INPUT_PROPERTY, previous, allowUserInput);
    }

    @Nullable
    public Customizer<WebCalendar> getCalendarCustomizer() {
        return this.calendarCustomizer;
    }

    public void setCalendarCustomizer(@Nullable Customizer<WebCalendar> customizer) {
        Customizer<WebCalendar> previous = this.calendarCustomizer;
        this.calendarCustomizer = customizer;
        this.firePropertyChange(CALENDAR_CUSTOMIZER_PROPERTY, previous, this.calendarCustomizer);
    }

    public void addDateListener(@NotNull DateListener listener) {
        this.listenerList.add(DateListener.class, listener);
    }

    public void removeDateListener(@NotNull DateListener listener) {
        this.listenerList.remove(DateListener.class, listener);
    }

    protected void fireDateChanged(@Nullable Date date) {
        for (DateListener listener : (DateListener[])this.listenerList.getListeners(DateListener.class)) {
            listener.dateChanged(date);
        }
    }

    @Override
    public WDateFieldUI getUI() {
        return (WDateFieldUI)this.ui;
    }

    public void setUI(WDateFieldUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

