/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.debug;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.style.Skin;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.LoggerFactory;

public final class SwingTest {
    public static void run(@NotNull Runnable runnable) {
        SwingTest.run(WebLookAndFeel.class.getCanonicalName(), null, runnable);
    }

    public static void run(@NotNull Class<? extends Skin> skin, @NotNull Runnable runnable) {
        SwingTest.run(WebLookAndFeel.class.getCanonicalName(), skin, runnable);
    }

    public static void run(@NotNull String lookAndFeel, @NotNull Runnable runnable) {
        SwingTest.run(lookAndFeel, null, runnable);
    }

    private static void run(final @NotNull String lookAndFeel, final @Nullable Class<? extends Skin> skin, final @NotNull Runnable runnable) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue(){

            @Override
            protected void dispatchEvent(AWTEvent event) {
                try {
                    super.dispatchEvent(event);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (lookAndFeel.equals(WebLookAndFeel.class.getCanonicalName())) {
                    if (skin != null) {
                        WebLookAndFeel.install(skin, new Object[0]);
                    } else {
                        WebLookAndFeel.install();
                    }
                } else {
                    try {
                        UIManager.setLookAndFeel(lookAndFeel);
                    }
                    catch (ClassNotFoundException e) {
                        LoggerFactory.getLogger(SwingTest.class).error("L&F class not found: " + lookAndFeel, e);
                    }
                    catch (InstantiationException e) {
                        LoggerFactory.getLogger(SwingTest.class).error("Unable to instantiate L&F class: " + lookAndFeel, e);
                    }
                    catch (IllegalAccessException e) {
                        LoggerFactory.getLogger(SwingTest.class).error("Unable to access L&F class: " + lookAndFeel, e);
                    }
                    catch (UnsupportedLookAndFeelException e) {
                        LoggerFactory.getLogger(SwingTest.class).error("Unsupported L&F: " + lookAndFeel, e);
                    }
                }
                runnable.run();
            }
        });
    }
}

