/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.extended.dock.DockableAreaPainter;
import com.alee.extended.dock.DockablePaneModel;
import com.alee.extended.dock.IDockableAreaPainter;
import com.alee.extended.dock.IDockablePanePainter;
import com.alee.extended.dock.WDockablePaneUI;
import com.alee.extended.dock.WebDockablePane;
import com.alee.painter.DefaultPainter;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.AbstractContainerPainter;
import com.alee.painter.decoration.IDecoration;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;

public class DockablePanePainter<C extends WebDockablePane, U extends WDockablePaneUI, D extends IDecoration<C, D>>
extends AbstractContainerPainter<C, U, D>
implements IDockablePanePainter<C, U> {
    @DefaultPainter(value=DockableAreaPainter.class)
    protected IDockableAreaPainter areaPainter;

    @Override
    @Nullable
    protected List<SectionPainter<C, U>> getSectionPainters() {
        return this.asList(this.areaPainter);
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
        this.paintSidebar(g2d, c, ui, bounds);
    }

    protected void paintSidebar(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
        if (this.areaPainter != null && ((WebDockablePane)c).getMaximizedFrame() == null) {
            DockablePaneModel model = ((WebDockablePane)c).getModel();
            ComponentOrientation componentOrientation = ((Component)c).getComponentOrientation();
            Rectangle outerBounds = model.getOuterBounds((WebDockablePane)c);
            Rectangle innerBounds = model.getInnerBounds((WebDockablePane)c);
            for (CompassDirection area : CompassDirection.values()) {
                CompassDirection adjustedArea = area.adjust(componentOrientation);
                Rectangle areaBounds = this.getAreaBounds(adjustedArea, outerBounds, innerBounds);
                if (areaBounds.width <= 0 || areaBounds.height <= 0 || !this.areaPainter.hasDecorationFor(area)) continue;
                this.areaPainter.prepareToPaint(area);
                this.paintSection(this.areaPainter, g2d, areaBounds);
            }
        }
    }

    @NotNull
    protected Rectangle getAreaBounds(CompassDirection area, Rectangle outerBounds, Rectangle innerBounds) {
        Rectangle areaBounds;
        switch (area) {
            case northWest: {
                areaBounds = new Rectangle(outerBounds.x, outerBounds.y, innerBounds.x - outerBounds.x, innerBounds.y - outerBounds.y);
                break;
            }
            case north: {
                areaBounds = new Rectangle(innerBounds.x, outerBounds.y, innerBounds.width, innerBounds.y - outerBounds.y);
                break;
            }
            case northEast: {
                areaBounds = new Rectangle(innerBounds.x + innerBounds.width, outerBounds.y, outerBounds.x + outerBounds.width - innerBounds.x - innerBounds.width, innerBounds.y - outerBounds.y);
                break;
            }
            case west: {
                areaBounds = new Rectangle(outerBounds.x, innerBounds.y, innerBounds.x - outerBounds.x, innerBounds.height);
                break;
            }
            default: {
                areaBounds = new Rectangle(innerBounds.x, innerBounds.y, innerBounds.width, innerBounds.height);
                break;
            }
            case east: {
                areaBounds = new Rectangle(innerBounds.x + innerBounds.width, innerBounds.y, outerBounds.x + outerBounds.width - innerBounds.x - innerBounds.width, innerBounds.height);
                break;
            }
            case southWest: {
                areaBounds = new Rectangle(outerBounds.x, innerBounds.y + innerBounds.height, innerBounds.x - outerBounds.x, outerBounds.y + outerBounds.height - innerBounds.y - innerBounds.height);
                break;
            }
            case south: {
                areaBounds = new Rectangle(innerBounds.x, innerBounds.y + innerBounds.height, innerBounds.width, outerBounds.y + outerBounds.height - innerBounds.y - innerBounds.height);
                break;
            }
            case southEast: {
                areaBounds = new Rectangle(innerBounds.x + innerBounds.width, innerBounds.y + innerBounds.height, outerBounds.x + outerBounds.width - innerBounds.x - innerBounds.width, outerBounds.y + outerBounds.height - innerBounds.y - innerBounds.height);
            }
        }
        return areaBounds;
    }
}

