/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.api.annotations.NotNull;
import com.alee.api.data.CompassDirection;
import com.alee.extended.dock.DockableFrameState;
import com.alee.extended.dock.DockablePaneAdapter;
import com.alee.extended.dock.DockablePaneListener;
import com.alee.extended.dock.DockablePaneState;
import com.alee.extended.dock.WebDockableFrame;
import com.alee.extended.dock.WebDockablePane;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;

public class DockablePaneSettingsProcessor
extends SettingsProcessor<WebDockablePane, DockablePaneState, Configuration<DockablePaneState>> {
    protected transient DockablePaneListener dockablePaneListener;

    public DockablePaneSettingsProcessor(WebDockablePane dockablePane, Configuration configuration) {
        super(dockablePane, configuration);
    }

    @Override
    protected void register(@NotNull WebDockablePane dockablePane) {
        this.dockablePaneListener = new DockablePaneAdapter(){

            @Override
            public void frameStateChanged(@NotNull WebDockableFrame frame, @NotNull DockableFrameState oldState, @NotNull DockableFrameState newState) {
                DockablePaneSettingsProcessor.this.save();
            }

            @Override
            public void frameMoved(@NotNull WebDockableFrame frame, @NotNull CompassDirection position) {
                DockablePaneSettingsProcessor.this.save();
            }
        };
        dockablePane.addDockablePaneListener(this.dockablePaneListener);
    }

    @Override
    protected void unregister(@NotNull WebDockablePane dockablePane) {
        dockablePane.removeDockablePaneListener(this.dockablePaneListener);
        this.dockablePaneListener = null;
    }

    @Override
    protected void loadSettings(@NotNull WebDockablePane dockablePane) {
        DockablePaneState state = (DockablePaneState)this.loadSettings();
        if (state != null) {
            state.apply(dockablePane);
        }
    }

    @Override
    protected void saveSettings(@NotNull WebDockablePane dockablePane) {
        this.saveSettings(new DockablePaneState(dockablePane));
    }
}

