/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.behavior.ComponentMoveBehavior;
import com.alee.extended.dock.DockableFrameState;
import com.alee.extended.dock.SidebarButton;
import com.alee.extended.dock.WDockableFrameUI;
import com.alee.extended.dock.WebDockableFrame;
import com.alee.extended.dock.drag.DockableFrameTransferHandler;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.laf.button.WebButton;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.separator.WebSeparator;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.plaf.ComponentUI;

public class WebDockableFrameUI<C extends WebDockableFrame>
extends WDockableFrameUI<C>
implements PropertyChangeListener {
    protected transient DefaultFocusTracker focusTracker;
    protected transient ComponentMoveBehavior dialogMoveBehavior;
    protected transient SidebarButton sidebarButton;
    protected transient WebPanel titlePanel;
    protected transient WebStyledLabel titleLabel;
    protected transient WebPanel buttonsPanel;
    protected transient WebButton dockButton;
    protected transient WebButton minimizeButton;
    protected transient WebButton floatButton;
    protected transient WebButton maximizeButton;
    protected transient WebButton closeButton;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebDockableFrameUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.frame);
        this.installComponents();
        this.installActions();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallActions();
        this.uninstallComponents();
        StyleManager.uninstallSkin(this.frame);
        super.uninstallUI(c);
    }

    protected void installComponents() {
        this.sidebarButton = new SidebarButton(this.frame);
        this.frame.setLayout(new BorderLayout());
        this.titlePanel = new WebPanel(StyleId.dockableframeTitlePanel.at(this.frame));
        this.frame.add((Component)this.titlePanel, (Object)"North");
        this.titleLabel = new WebStyledLabel(StyleId.dockableframeTitleLabel.at(this.titlePanel), this.frame.getTitle(), this.frame.getIcon());
        this.titlePanel.add((Component)this.titleLabel, (Object)"Center");
        this.buttonsPanel = new WebPanel(StyleId.dockableframeTitleButtonsPanel.at(this.titlePanel), new HorizontalFlowLayout(0, false), new Component[0]);
        this.titlePanel.add((Component)this.buttonsPanel, (Object)"After");
        this.buttonsPanel.add((Component)new WebSeparator(StyleId.dockableframeTitleSeparator.at(this.buttonsPanel)));
        this.minimizeButton = new WebButton(StyleId.dockableframeTitleIconButton.at(this.buttonsPanel));
        this.updateMinimizeButton();
        this.buttonsPanel.add((Component)this.minimizeButton);
        this.dockButton = new WebButton(StyleId.dockableframeTitleIconButton.at(this.buttonsPanel));
        this.updateDockButton();
        this.buttonsPanel.add((Component)this.dockButton);
        this.floatButton = new WebButton(StyleId.dockableframeTitleIconButton.at(this.buttonsPanel));
        this.updateFloatButton();
        this.buttonsPanel.add((Component)this.floatButton);
        this.maximizeButton = new WebButton(StyleId.dockableframeTitleIconButton.at(this.buttonsPanel));
        this.updateMaximizeButton();
        this.buttonsPanel.add((Component)this.maximizeButton);
        this.closeButton = new WebButton(StyleId.dockableframeTitleIconButton.at(this.buttonsPanel));
        this.updateCloseButton();
        this.buttonsPanel.add((Component)this.closeButton);
    }

    protected void uninstallComponents() {
        this.frame.remove((Component)this.titlePanel);
        this.titlePanel.resetStyleId();
        this.titlePanel = null;
        this.titleLabel = null;
        this.buttonsPanel = null;
        this.minimizeButton = null;
        this.dockButton = null;
        this.floatButton = null;
        this.closeButton = null;
        this.frame.setLayout(null);
        if (this.frame.getDockablePane() != null) {
            this.frame.getDockablePane().remove((Component)this.sidebarButton);
        }
        StyleManager.resetStyleId(this.sidebarButton);
        this.sidebarButton = null;
    }

    protected void installActions() {
        this.dialogMoveBehavior = new ComponentMoveBehavior((Component)this.titlePanel){

            @Override
            public boolean isEnabled() {
                return WebDockableFrameUI.this.frame.isFloating();
            }
        };
        this.dialogMoveBehavior.install();
        this.titlePanel.onMousePress(MouseButton.left, new MouseEventRunnable(){

            @Override
            public void run(@NotNull MouseEvent e) {
                WebDockableFrameUI.this.requestFocusInFrame();
            }
        });
        this.titlePanel.onMousePress(MouseButton.middle, new MouseEventRunnable(){

            @Override
            public void run(@NotNull MouseEvent e) {
                WebDockableFrameUI.this.frame.minimize();
            }
        });
        this.titlePanel.onDragStart(5, new MouseEventRunnable(){

            @Override
            public void run(@NotNull MouseEvent e) {
                TransferHandler handler;
                if (WebDockableFrameUI.this.frame.isDraggable() && !WebDockableFrameUI.this.frame.isFloating() && !WebDockableFrameUI.this.frame.isMaximized() && (handler = WebDockableFrameUI.this.frame.getTransferHandler()) != null) {
                    handler.exportAsDrag(WebDockableFrameUI.this.frame, e, 2);
                }
            }
        });
        this.minimizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebDockableFrameUI.this.frame.minimize();
            }
        });
        this.dockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (WebDockableFrameUI.this.frame.isPreview() || WebDockableFrameUI.this.frame.isFloating()) {
                    WebDockableFrameUI.this.requestFocusInFrame();
                    WebDockableFrameUI.this.frame.dock();
                } else if (WebDockableFrameUI.this.frame.isDocked()) {
                    WebDockableFrameUI.this.frame.minimize();
                }
            }
        });
        this.floatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebDockableFrameUI.this.requestFocusInFrame();
                WebDockableFrameUI.this.frame.detach();
            }
        });
        this.maximizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebDockableFrameUI.this.requestFocusInFrame();
                WebDockableFrameUI.this.frame.maximize();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebDockableFrameUI.this.frame.close();
            }
        });
        this.focusTracker = new DefaultFocusTracker(this.frame, true){

            @Override
            public void focusChanged(boolean focused) {
                if (!focused && WebDockableFrameUI.this.frame.isPreview()) {
                    WebDockableFrameUI.this.frame.minimize();
                }
            }
        };
        FocusManager.addFocusTracker(this.frame, this.focusTracker);
        this.frame.addPropertyChangeListener(this);
        this.frame.setTransferHandler(new DockableFrameTransferHandler());
    }

    protected void uninstallActions() {
        this.frame.setTransferHandler(null);
        this.frame.removePropertyChangeListener(this);
        FocusManager.removeFocusTracker(this.frame, this.focusTracker);
        this.focusTracker = null;
        this.dialogMoveBehavior.uninstall();
        this.dialogMoveBehavior = null;
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (Objects.equals((Object)property, (Object)"state")) {
            DockableFrameState oldState = (DockableFrameState)((Object)evt.getOldValue());
            DockableFrameState newState = (DockableFrameState)((Object)evt.getNewValue());
            if (oldState == DockableFrameState.docked || oldState == DockableFrameState.floating) {
                this.frame.setRestoreState(oldState);
            }
            this.sidebarButton.updateStates();
            this.updateMinimizeButton();
            this.updateDockButton();
            this.updateFloatButton();
            this.updateMaximizeButton();
            if (this.frame.isMaximized()) {
                this.frame.setMaximized(false);
            }
            this.frame.fireFrameStateChanged(oldState, newState);
            if (newState == DockableFrameState.preview || newState == DockableFrameState.docked) {
                this.requestFocusInFrame();
            }
        } else if (Objects.equals((Object)property, (Object)"maximizable")) {
            this.updateMaximizeButton();
            if (!this.frame.isMaximizable() && this.frame.isMaximized()) {
                this.frame.setMaximized(false);
            }
        } else if (Objects.equals((Object)property, (Object)"maximized")) {
            this.updateMaximizeButton();
        } else if (Objects.equals((Object)property, (Object)"closable")) {
            this.updateCloseButton();
        } else if (Objects.equals((Object)property, (Object)"floatable")) {
            this.updateFloatButton();
        } else if (Objects.equals((Object)property, (Object)"icon")) {
            this.titleLabel.setIcon(this.frame.getIcon());
            this.sidebarButton.setIcon(this.frame.getIcon());
        } else if (Objects.equals((Object)property, (Object)"title")) {
            this.titleLabel.setText(this.frame.getTitle());
            this.sidebarButton.setText(this.frame.getTitle());
        } else if (Objects.equals((Object)property, (Object)"position")) {
            this.sidebarButton.updateStates();
        }
    }

    private void updateMinimizeButton() {
        this.minimizeButton.setVisible(this.frame.isDocked() || this.frame.isFloating());
        this.minimizeButton.setIcon(Icons.underline);
        this.minimizeButton.setRolloverIcon(Icons.underlineHover);
        this.minimizeButton.setLanguage("weblaf.ex.dockable.frame.minimize", new Object[0]);
    }

    private void updateDockButton() {
        this.dockButton.setVisible(!this.frame.isDocked());
        this.dockButton.setIcon(Icons.pin);
        this.dockButton.setRolloverIcon(Icons.pinHover);
        this.dockButton.setLanguage("weblaf.ex.dockable.frame.dock", new Object[0]);
    }

    protected void updateFloatButton() {
        this.floatButton.setVisible(this.frame.isFloatable() && !this.frame.isFloating());
        this.floatButton.setIcon(Icons.external);
        this.floatButton.setRolloverIcon(Icons.externalHover);
        this.floatButton.setLanguage("weblaf.ex.dockable.frame.float", new Object[0]);
    }

    protected void updateMaximizeButton() {
        this.maximizeButton.setVisible(this.frame.isMaximizable() && this.frame.isDocked());
        this.maximizeButton.setIcon(this.frame.isMaximized() ? Icons.shrink : Icons.maximize);
        this.maximizeButton.setRolloverIcon(this.frame.isMaximized() ? Icons.shrinkHover : Icons.maximizeHover);
        this.maximizeButton.setLanguage("weblaf.ex.dockable.frame." + (this.frame.isMaximized() ? "restore" : "maximize"), new Object[0]);
    }

    protected void updateCloseButton() {
        this.closeButton.setVisible(this.frame.isClosable());
        this.closeButton.setIcon(Icons.cross);
        this.closeButton.setRolloverIcon(Icons.crossHover);
        this.closeButton.setLanguage("weblaf.ex.dockable.frame.close", new Object[0]);
    }

    @Override
    @NotNull
    public Dimension getMinimumDialogSize() {
        Dimension ps = this.titlePanel.isVisible() ? this.titlePanel.getPreferredSize() : (this.frame.getDockablePane() != null ? this.frame.getDockablePane().getMinimumElementSize() : new Dimension(0, 0));
        Insets bi = this.frame.getInsets();
        return SwingUtils.stretch(ps, bi);
    }

    protected void requestFocusInFrame() {
        CoreSwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!SwingUtils.hasFocusOwner(WebDockableFrameUI.this.frame)) {
                    Component component2 = SwingUtils.findFocusableComponent(WebDockableFrameUI.this.frame);
                    if (component2 != null) {
                        component2.requestFocusInWindow();
                    } else {
                        WebDockableFrameUI.this.frame.requestFocusInWindow();
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public SidebarButton getSidebarButton() {
        return this.sidebarButton;
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c);
    }
}

