/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.api.jdk.Objects;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.extended.dock.DockableFrameListener;
import com.alee.extended.dock.DockableFrameState;
import com.alee.extended.dock.DockablePaneGlassLayer;
import com.alee.extended.dock.WDockablePaneUI;
import com.alee.extended.dock.WebDockableFrame;
import com.alee.extended.dock.WebDockablePane;
import com.alee.extended.dock.data.DockableFrameElement;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.window.WebDialog;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WebDockablePaneUI<C extends WebDockablePane>
extends WDockablePaneUI<C>
implements PropertyChangeListener {
    protected static final String FRAME_LISTENER = "frame.listener";
    protected static final String FRAME_DIALOG = "frame.dialog";
    protected transient VisibilityBehavior<C> visibilityBehavior;
    protected transient DockableFrameListener proxyListener;
    protected transient JComponent emptyContent;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebDockablePaneUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.pane);
        this.installComponents();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallComponents();
        StyleManager.uninstallSkin(this.pane);
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.visibilityBehavior = new VisibilityBehavior<C>(this.pane){

            @Override
            protected void displayed(@NotNull C pane) {
                for (WebDockableFrame frame : ((WebDockablePane)pane).frames) {
                    if (!frame.isFloating()) continue;
                    WebDockablePaneUI.this.showFrameDialog(frame);
                }
            }

            @Override
            protected void hidden(@NotNull C pane) {
                for (WebDockableFrame frame : ((WebDockablePane)pane).frames) {
                    if (!frame.isFloating()) continue;
                    WebDockablePaneUI.this.disposeFrameDialog(frame);
                }
            }
        };
        this.visibilityBehavior.install();
        this.pane.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (Objects.equals((Object)property, "model", "modelState")) {
            this.updateFrameData();
        } else if (Objects.equals((Object)property, (Object)"sidebarButtonVisibility")) {
            this.updateSidebarsVisibility();
        } else if (Objects.equals((Object)property, "contentSpacing", "resizeGripperWidth")) {
            this.pane.revalidate();
            this.pane.repaint();
        } else if (Objects.equals((Object)property, (Object)"glassLayer")) {
            Component oldGlassLayer = (Component)evt.getOldValue();
            Component newGlassLayer = (Component)evt.getNewValue();
            this.updateGlassLayerVisibility(oldGlassLayer, newGlassLayer);
        } else if (Objects.equals((Object)property, (Object)"frame")) {
            if (evt.getNewValue() != null) {
                this.installFrame((WebDockableFrame)evt.getNewValue());
            }
            if (evt.getOldValue() != null) {
                this.uninstallFrame((WebDockableFrame)evt.getOldValue());
            }
        } else if (Objects.equals((Object)property, (Object)"content")) {
            JComponent oldContent = (JComponent)evt.getOldValue();
            JComponent newContent = (JComponent)evt.getNewValue();
            this.updateContentVisibility(oldContent, newContent);
        } else if (Objects.equals((Object)property, "minimumElementSize", "occupyMinimumSizeForChildren")) {
            this.pane.getModel().getRoot().validateSize(this.pane);
            this.pane.revalidate();
            this.pane.repaint();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.pane.removePropertyChangeListener(this);
        this.visibilityBehavior.uninstall();
        this.visibilityBehavior = null;
        super.uninstallListeners();
    }

    protected void installComponents() {
        this.emptyContent = new WebPanel(StyleId.dockablepaneEmpty.at(this.pane));
        if (this.pane.getContent() == null) {
            this.pane.setContent(this.emptyContent);
        }
    }

    protected void uninstallComponents() {
        if (this.pane.getContent() == this.emptyContent) {
            this.pane.setContent(null);
        }
        this.emptyContent = null;
    }

    protected void updateFrameData() {
        for (WebDockableFrame frame : this.pane.frames) {
            this.pane.getModel().updateFrame(this.pane, frame);
        }
        this.pane.revalidate();
        this.pane.repaint();
    }

    protected void updateGlassLayerVisibility(@Nullable Component oldGlassLayer, @Nullable Component newGlassLayer) {
        if (oldGlassLayer != null) {
            this.pane.remove(oldGlassLayer);
        }
        if (newGlassLayer != null) {
            this.pane.add(newGlassLayer, 0);
        }
        this.pane.revalidate();
        this.pane.repaint();
    }

    protected void updateSidebarsVisibility() {
        if (CollectionUtils.notEmpty(this.pane.frames)) {
            for (WebDockableFrame frame : this.pane.frames) {
                if (frame.isSidebarButtonVisible()) {
                    if (this.pane.contains(frame.getSidebarButton())) continue;
                    this.pane.add((Component)frame.getSidebarButton());
                    continue;
                }
                if (!this.pane.contains(frame.getSidebarButton())) continue;
                this.pane.remove((Component)frame.getSidebarButton());
            }
            this.pane.revalidate();
            this.pane.repaint();
        }
    }

    protected void updateFrameVisibility(@NotNull WebDockableFrame frame) {
        if (frame.isPreview() || frame.isDocked()) {
            if (!this.pane.contains(frame)) {
                this.pane.add((Component)frame);
            }
        } else if (this.pane.contains(frame)) {
            this.pane.remove((Component)frame);
        }
    }

    protected void updateContentVisibility(@Nullable JComponent oldContent, @Nullable JComponent newContent) {
        boolean update = false;
        if (oldContent != null) {
            this.pane.remove((Component)oldContent);
            update = true;
        }
        if (newContent != null) {
            this.pane.add((Component)newContent);
            update = true;
        } else {
            this.pane.setContent(this.emptyContent);
        }
        if (update) {
            this.pane.revalidate();
            this.pane.repaint();
        }
    }

    protected void installFrame(final @NotNull WebDockableFrame frame) {
        boolean updateLayout = false;
        this.pane.getModel().updateFrame(this.pane, frame);
        frame.setDockablePane(this.pane);
        if (frame.isPreview() || frame.isDocked()) {
            this.pane.add((Component)frame);
            updateLayout = true;
        }
        if (frame.isSidebarButtonVisible()) {
            this.pane.add((Component)frame.getSidebarButton());
            updateLayout = true;
        }
        PropertyChangeListener frameListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if (Objects.equals((Object)property, (Object)"frameId")) {
                    WebDockablePaneUI.this.pane.getModel().updateFrame(WebDockablePaneUI.this.pane, frame);
                } else if (Objects.equals((Object)property, (Object)"state")) {
                    DockableFrameState oldState = (DockableFrameState)((Object)evt.getOldValue());
                    DockableFrameState newState = (DockableFrameState)((Object)evt.getNewValue());
                    DockableFrameElement element = (DockableFrameElement)WebDockablePaneUI.this.pane.getModel().getElement(frame.getId());
                    element.setState(frame.getState());
                    if (oldState == DockableFrameState.floating) {
                        WebDockablePaneUI.this.disposeFrameDialog(frame);
                    }
                    WebDockablePaneUI.this.updateFrameVisibility(frame);
                    WebDockablePaneUI.this.updateSidebarsVisibility();
                    WebDockablePaneUI.this.pane.revalidate();
                    WebDockablePaneUI.this.pane.repaint();
                    if (newState == DockableFrameState.floating) {
                        WebDockablePaneUI.this.showFrameDialog(frame);
                    }
                } else if (Objects.equals((Object)property, (Object)"position")) {
                    WebDockablePaneUI.this.updateSidebarsVisibility();
                } else if (Objects.equals((Object)property, (Object)"maximized")) {
                    if (frame.isMaximized()) {
                        for (WebDockableFrame other : WebDockablePaneUI.this.pane.frames) {
                            if (other == frame || !other.isMaximized()) continue;
                            other.setMaximized(false);
                            break;
                        }
                    }
                    WebDockablePaneUI.this.pane.getModel().updateFrame(WebDockablePaneUI.this.pane, frame);
                } else if (Objects.equals((Object)property, (Object)"restoreState")) {
                    DockableFrameElement element = (DockableFrameElement)WebDockablePaneUI.this.pane.getModel().getElement(frame.getId());
                    element.setRestoreState(frame.getRestoreState());
                } else if (Objects.equals((Object)property, (Object)"title")) {
                    if (frame.isFloating()) {
                        WebDialog dialog = (WebDialog)frame.getClientProperty(WebDockablePaneUI.FRAME_DIALOG);
                        dialog.setTitle(frame.getTitle());
                    }
                } else if (Objects.equals((Object)property, (Object)"icon") && frame.isFloating()) {
                    WebDialog dialog = (WebDialog)frame.getClientProperty(WebDockablePaneUI.FRAME_DIALOG);
                    dialog.setIconImage(ImageUtils.toBufferedImage(frame.getIcon()));
                }
            }
        };
        frame.addPropertyChangeListener(frameListener);
        frame.putClientProperty(FRAME_LISTENER, frameListener);
        frame.addFrameListener(this.getProxyListener());
        if (this.pane.isShowing() && frame.isFloating()) {
            this.showFrameDialog(frame);
        }
        if (updateLayout) {
            this.pane.revalidate();
            this.pane.repaint();
        }
        frame.fireFrameAdded();
    }

    private void uninstallFrame(@NotNull WebDockableFrame frame) {
        boolean updateLayout = false;
        frame.removeFrameListener(this.getProxyListener());
        PropertyChangeListener frameListener = (PropertyChangeListener)frame.getClientProperty(FRAME_LISTENER);
        frame.removePropertyChangeListener(frameListener);
        frame.putClientProperty(FRAME_LISTENER, null);
        if (frame.isSidebarButtonVisible()) {
            this.pane.remove((Component)frame.getSidebarButton());
            updateLayout = true;
        }
        if (frame.isPreview() || frame.isDocked()) {
            this.pane.remove((Component)frame);
            updateLayout = true;
        }
        frame.setDockablePane(null);
        this.pane.getModel().removeFrame(this.pane, frame);
        if (this.pane.isShowing() && frame.isFloating()) {
            this.disposeFrameDialog(frame);
        }
        if (updateLayout) {
            this.pane.revalidate();
            this.pane.repaint();
        }
        frame.fireFrameRemoved();
    }

    @NotNull
    protected DockableFrameListener getProxyListener() {
        if (this.proxyListener == null) {
            this.proxyListener = new DockableFrameListener(){

                @Override
                public void frameAdded(@NotNull WebDockableFrame frame, @NotNull WebDockablePane dockablePane) {
                    WebDockablePaneUI.this.pane.fireFrameAdded(frame, dockablePane);
                }

                @Override
                public void frameStateChanged(@NotNull WebDockableFrame frame, @NotNull DockableFrameState oldState, @NotNull DockableFrameState newState) {
                    WebDockablePaneUI.this.pane.fireFrameStateChanged(frame, oldState, newState);
                }

                @Override
                public void frameMoved(@NotNull WebDockableFrame frame, @NotNull CompassDirection position) {
                    WebDockablePaneUI.this.pane.fireFrameMoved(frame, position);
                }

                @Override
                public void frameRemoved(@NotNull WebDockableFrame frame, @NotNull WebDockablePane dockablePane) {
                    WebDockablePaneUI.this.pane.fireFrameRemoved(frame, dockablePane);
                }
            };
        }
        return this.proxyListener;
    }

    protected void showFrameDialog(final @NotNull WebDockableFrame frame) {
        StyleId dialogStyle = StyleId.dockablepaneFloating.at(this.pane);
        WebDialog dialog = new WebDialog(dialogStyle, this.pane, frame.getTitle());
        dialog.setIconImage(ImageUtils.toBufferedImage(frame.getIcon()));
        dialog.add((Component)frame, "Center");
        dialog.setMinimumSize(SwingUtils.stretch(frame.getUI().getMinimumDialogSize(), dialog.getRootPane().getInsets()));
        dialog.setBounds(this.pane.getModel().getFloatingBounds(this.pane, frame, dialog));
        dialog.setDefaultCloseOperation(0);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DockableFrameElement element = (DockableFrameElement)WebDockablePaneUI.this.pane.getModel().getElement(frame.getId());
                element.saveFloatingBounds(frame);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                DockableFrameElement element = (DockableFrameElement)WebDockablePaneUI.this.pane.getModel().getElement(frame.getId());
                element.saveFloatingBounds(frame);
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (frame.isFloating()) {
                    frame.close();
                }
            }
        });
        dialog.setModal(false);
        dialog.setVisible(true);
        frame.putClientProperty(FRAME_DIALOG, dialog);
        frame.requestFocusInWindow();
    }

    protected void disposeFrameDialog(@NotNull WebDockableFrame frame) {
        WebDialog dialog = (WebDialog)frame.getClientProperty(FRAME_DIALOG);
        dialog.remove(frame);
        dialog.dispose();
        frame.putClientProperty(FRAME_DIALOG, null);
    }

    @Override
    @NotNull
    public JComponent createGlassLayer() {
        return new DockablePaneGlassLayer(this.pane);
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c);
    }
}

