/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock.data;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.Orientation;
import com.alee.api.jdk.Objects;
import com.alee.extended.dock.WebDockablePane;
import com.alee.extended.dock.data.AbstractDockableElement;
import com.alee.extended.dock.data.DockableContainer;
import com.alee.extended.dock.data.DockableElement;
import com.alee.extended.dock.data.ResizeData;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="DockableList")
public class DockableListContainer
extends AbstractDockableElement
implements DockableContainer {
    @XStreamAsAttribute
    @NotNull
    protected Orientation orientation;
    @XStreamImplicit
    @Nullable
    protected List<DockableElement> elements;

    public DockableListContainer(@NotNull Orientation orientation, DockableElement ... elements) {
        this(orientation, new Dimension(0, 0), elements);
    }

    public DockableListContainer(@NotNull Orientation orientation, @NotNull Dimension size, DockableElement ... elements) {
        super(TextUtils.generateId("EL"), size);
        this.orientation = orientation;
        for (DockableElement element : elements) {
            this.add(element);
        }
    }

    @Override
    public void added(@Nullable DockableContainer parent) {
        super.added(parent);
        if (this.elements != null) {
            for (DockableElement element : this.elements) {
                element.added(this);
            }
        }
    }

    @Override
    public boolean isContent() {
        boolean isContent = false;
        if (this.elements != null) {
            for (DockableElement element : this.elements) {
                if (!element.isContent()) continue;
                isContent = true;
                break;
            }
        }
        return isContent;
    }

    @Override
    @NotNull
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(@NotNull Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public int getElementCount() {
        return this.elements != null ? this.elements.size() : 0;
    }

    @Override
    @NotNull
    public <E extends DockableElement> E get(@NotNull String id) {
        E element = this.find(id);
        if (element == null) {
            throw new RuntimeException("Unable to find element with identifier: " + id);
        }
        return element;
    }

    @Override
    @Nullable
    public <E extends DockableElement> E find(@NotNull String id) {
        DockableElement element = null;
        if (this.elements != null) {
            for (DockableElement e : this.elements) {
                if (Objects.equals((Object)id, (Object)e.getId())) {
                    element = e;
                    break;
                }
                if (!(e instanceof DockableContainer) || (element = ((DockableContainer)e).find(id)) == null) continue;
                break;
            }
        }
        return (E)element;
    }

    @Override
    public boolean contains(@NotNull String id) {
        return this.find(id) != null;
    }

    @Override
    public int indexOf(@NotNull DockableElement element) {
        return this.elements != null ? this.elements.indexOf(element) : -1;
    }

    @Override
    @NotNull
    public DockableElement get(int index) {
        DockableElement element;
        DockableElement dockableElement = element = this.elements != null ? this.elements.get(index) : null;
        if (element == null) {
            throw new RuntimeException("Unable to find element at index: " + index);
        }
        return element;
    }

    @Override
    public void add(@NotNull DockableElement element) {
        this.add(this.getElementCount(), element);
    }

    @Override
    public void add(int index, @NotNull DockableElement element) {
        if (this.elements == null) {
            this.elements = new ArrayList<DockableElement>(2);
        }
        this.elements.add(index, element);
        element.added(this);
    }

    @Override
    public void remove(DockableElement element) {
        if (this.elements != null) {
            this.elements.remove(element);
            element.removed(this);
        }
    }

    @Override
    public boolean isVisible(@NotNull WebDockablePane dockablePane) {
        boolean isVisible = false;
        if (this.elements != null) {
            for (DockableElement element : this.elements) {
                if (!element.isVisible(dockablePane)) continue;
                isVisible = true;
                break;
            }
        }
        return isVisible;
    }

    @Override
    public void layout(@NotNull WebDockablePane dockablePane, @NotNull Rectangle bounds, @NotNull List<ResizeData> resizeableAreas) {
        this.setBounds(bounds);
        if (this.elements != null) {
            boolean horizontal = this.orientation.isHorizontal();
            int summ = 0;
            int minSumm = 0;
            int cindex = -1;
            ArrayList<DockableElement> visible = new ArrayList<DockableElement>(this.elements.size());
            ArrayList<Integer> sizes = new ArrayList<Integer>(this.elements.size());
            for (DockableElement element : this.elements) {
                int length;
                if (!element.isVisible(dockablePane)) continue;
                if (element.isContent()) {
                    length = 0;
                    cindex = visible.size();
                } else {
                    Dimension minimumSize = element.getMinimumSize(dockablePane);
                    length = horizontal ? Math.max(element.getSize().width, minimumSize.width) : Math.max(element.getSize().height, minimumSize.height);
                    int minLength = horizontal ? minimumSize.width : minimumSize.height;
                    summ += Math.max(length, minLength);
                    minSumm += minLength;
                }
                visible.add(element);
                sizes.add(length);
            }
            if (visible.size() > 0) {
                int i;
                int available;
                int minimumLength;
                int availableSpace;
                int spacing;
                int spacings;
                int minContentLength = cindex == -1 ? 0 : (horizontal ? ((DockableElement)visible.get((int)cindex)).getMinimumSize((WebDockablePane)dockablePane).width : ((DockableElement)visible.get((int)cindex)).getMinimumSize((WebDockablePane)dockablePane).height);
                int requiredLength = summ + minContentLength + (spacings = (spacing = dockablePane.getContentSpacing()) * (visible.size() - 1));
                if (requiredLength > (availableSpace = Math.max(horizontal ? bounds.width : bounds.height, minimumLength = minSumm + minContentLength + spacings))) {
                    available = availableSpace - minContentLength - spacings;
                    for (i = 0; i < visible.size(); ++i) {
                        if (i != cindex) {
                            sizes.set(i, (int)Math.floor((float)available * (float)((Integer)sizes.get(i)).intValue() / (float)summ));
                            continue;
                        }
                        sizes.set(i, minContentLength);
                    }
                } else if (cindex != -1) {
                    sizes.set(cindex, availableSpace - summ - spacings);
                } else {
                    available = availableSpace - spacings;
                    for (i = 0; i < visible.size(); ++i) {
                        sizes.set(i, (int)Math.floor((float)available * (float)((Integer)sizes.get(i)).intValue() / (float)summ));
                    }
                }
                boolean ltr = dockablePane.getComponentOrientation().isLeftToRight();
                int x = ltr ? bounds.x : bounds.x + bounds.width;
                int y = bounds.y;
                for (int i2 = 0; i2 < visible.size(); ++i2) {
                    int height;
                    DockableElement element = (DockableElement)visible.get(i2);
                    int width = horizontal ? (Integer)sizes.get(i2) : bounds.width;
                    int n = height = horizontal ? bounds.height : (Integer)sizes.get(i2);
                    if (i2 != cindex) {
                        Dimension oldSize = element.getSize();
                        element.setSize(new Dimension(horizontal ? (Integer)sizes.get(i2) : oldSize.width, horizontal ? oldSize.height : (Integer)sizes.get(i2)));
                    }
                    element.layout(dockablePane, new Rectangle(ltr ? x : x - width, y, width, height), resizeableAreas);
                    if (i2 < visible.size() - 1) {
                        int rg = dockablePane.getResizeGripperWidth();
                        int rgx = horizontal ? (ltr ? x + width + spacing / 2 - rg / 2 : x - width - spacing / 2 - rg / 2) : x;
                        int rgy = horizontal ? y : y + height + spacing / 2 - rg / 2;
                        int rgw = horizontal ? rg : width;
                        int rgh = horizontal ? height : rg;
                        Rectangle rb = new Rectangle(rgx, rgy, rgw, rgh);
                        String leftElementId = !horizontal || ltr ? element.getId() : ((DockableElement)visible.get(i2 + 1)).getId();
                        String rightElementId = !horizontal || ltr ? ((DockableElement)visible.get(i2 + 1)).getId() : element.getId();
                        resizeableAreas.add(new ResizeData(rb, this.orientation, leftElementId, rightElementId));
                    }
                    if (horizontal) {
                        if (ltr) {
                            x += width + spacing;
                            continue;
                        }
                        x -= width - spacing;
                        continue;
                    }
                    y += height + spacing;
                }
            }
        }
    }

    @Override
    @NotNull
    public Dimension getMinimumSize(@NotNull WebDockablePane dockablePane) {
        Dimension min = dockablePane.getMinimumElementSize();
        if (dockablePane.isOccupyMinimumSizeForChildren()) {
            Dimension mc = new Dimension(0, 0);
            if (this.elements != null) {
                int spacing = dockablePane.getContentSpacing();
                for (DockableElement element : this.elements) {
                    Dimension minElement = element.getMinimumSize(dockablePane);
                    if (this.orientation.isHorizontal()) {
                        mc.width += minElement.width + spacing;
                        mc.height = Math.max(minElement.height, mc.height);
                        continue;
                    }
                    mc.width = Math.max(minElement.width, mc.width);
                    mc.height += minElement.height + spacing;
                }
                if (this.orientation.isHorizontal()) {
                    mc.width -= spacing;
                } else {
                    mc.height -= spacing;
                }
            }
            min = new Dimension(Math.max(min.width, mc.width), Math.max(min.height, mc.height));
        }
        if (this.size.width < min.width || this.size.height < min.height) {
            this.setSize(new Dimension(Math.max(this.size.width, min.width), Math.max(this.size.height, min.height)));
        }
        return min;
    }
}

