/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.api.annotations.NotNull;
import com.alee.extended.filechooser.FilesSelectionListener;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.panel.CenterPanel;
import com.alee.laf.button.WebButton;
import com.alee.laf.filechooser.WebFileChooser;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.managers.drag.transfer.FilesTransferHandler;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class WebFileChooserField
extends WebPanel {
    protected boolean multiSelectionEnabled = false;
    private boolean showFileShortName = true;
    private boolean showFileIcon = true;
    private boolean showRemoveButton = true;
    private boolean showFileExtensions = false;
    private boolean showChooseButton = true;
    private boolean filesDropEnabled = true;
    private final List<File> selectedFiles = new ArrayList<File>();
    private final WebPanel contentPanel;
    private final WebScrollPane scroll;
    private final WebButton chooseButton;
    private final WebFileChooser webFileChooser;

    public WebFileChooserField() {
        this(StyleId.auto, null);
    }

    public WebFileChooserField(Window parent) {
        this(StyleId.auto, parent, true);
    }

    public WebFileChooserField(boolean showChooseButton) {
        this(StyleId.auto, null, showChooseButton);
    }

    public WebFileChooserField(Window owner, boolean showChooseButton) {
        this(StyleId.auto, owner, showChooseButton);
    }

    public WebFileChooserField(StyleId id) {
        this(id, null);
    }

    public WebFileChooserField(StyleId id, Window parent) {
        this(id, parent, true);
    }

    public WebFileChooserField(StyleId id, boolean showChooseButton) {
        this(id, null, showChooseButton);
    }

    public WebFileChooserField(StyleId id, final Window owner, boolean showChooseButton) {
        super(id, new BorderLayout(0, 0), new Component[0]);
        this.showChooseButton = showChooseButton;
        this.setTransferHandler(new FilesTransferHandler(false, this.filesDropEnabled){

            @Override
            public boolean isDropEnabled() {
                return WebFileChooserField.this.filesDropEnabled;
            }

            @Override
            public boolean filesDropped(@NotNull List<File> files2) {
                WebFileChooserField.this.setSelectedFiles(files2);
                return WebFileChooserField.this.getSelectedFiles().size() > 0;
            }
        });
        this.scroll = new WebScrollPane(StyleId.filechooserfieldContentScroll.at(this)){

            @Override
            @NotNull
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                ps.height = ((WebFileChooserField)WebFileChooserField.this).contentPanel.getPreferredSize().height;
                return ps;
            }
        };
        this.contentPanel = new WebPanel(StyleId.filechooserfieldContentPanel.at(this.scroll));
        this.scroll.setViewportView(this.contentPanel);
        this.contentPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Rectangle vr = WebFileChooserField.this.contentPanel.getVisibleRect();
                WebFileChooserField.this.contentPanel.scrollRectToVisible(new Rectangle(vr.x + e.getWheelRotation() * 25, vr.y, vr.width, vr.height));
            }
        });
        this.add((Component)this.scroll, (Object)"Center");
        if (this.showChooseButton) {
            this.webFileChooser = new WebFileChooser();
            this.webFileChooser.setMultiSelectionEnabled(this.multiSelectionEnabled);
            this.webFileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("ApproveSelection")) {
                        WebFileChooserField.this.setSelectedFiles(CollectionUtils.toList(WebFileChooserField.this.webFileChooser.getSelectedFiles()));
                    }
                }
            });
            this.chooseButton = new WebButton(StyleId.filechooserfieldChooseButton.at(this), "...");
            this.chooseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebFileChooserField.this.webFileChooser.showOpenDialog(owner);
                    WebFileChooserField.this.chooseButton.requestFocusInWindow();
                }
            });
            this.contentPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        WebFileChooserField.this.chooseButton.doClick(0);
                    }
                }
            });
            this.add((Component)this.chooseButton, (Object)"After");
        } else {
            this.chooseButton = null;
            this.webFileChooser = null;
        }
        this.updateContentLayout();
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.filechooserfield;
    }

    private void updateContentLayout() {
        this.contentPanel.setLayout(new HorizontalFlowLayout(0, !this.multiSelectionEnabled));
    }

    public WebFileChooser getWebFileChooser() {
        return this.webFileChooser;
    }

    public WebButton getChooseButton() {
        return this.chooseButton;
    }

    public boolean isShowChooseButton() {
        return this.showChooseButton;
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
        this.multiSelectionEnabled = multiSelectionEnabled;
        if (this.webFileChooser != null) {
            this.webFileChooser.setMultiSelectionEnabled(multiSelectionEnabled);
        }
        this.updateContentLayout();
    }

    public boolean isFilesDropEnabled() {
        return this.filesDropEnabled;
    }

    public void setFilesDropEnabled(boolean filesDropEnabled) {
        this.filesDropEnabled = filesDropEnabled;
    }

    public boolean isShowFileShortName() {
        return this.showFileShortName;
    }

    public void setShowFileShortName(boolean showFileShortName) {
        this.showFileShortName = showFileShortName;
        this.updateSelectedFiles();
    }

    public boolean isShowFileIcon() {
        return this.showFileIcon;
    }

    public void setShowFileIcon(boolean showFileIcon) {
        this.showFileIcon = showFileIcon;
        this.updateSelectedFiles();
    }

    public boolean isShowRemoveButton() {
        return this.showRemoveButton;
    }

    public void setShowRemoveButton(boolean showRemoveButton) {
        this.showRemoveButton = showRemoveButton;
        this.updateSelectedFiles();
    }

    public boolean isShowFileExtensions() {
        return this.showFileExtensions;
    }

    public void setShowFileExtensions(boolean showFileExtensions) {
        this.showFileExtensions = showFileExtensions;
        this.updateSelectedFiles();
    }

    public List<File> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void setSelectedFile(File selectedFile) {
        this.selectedFiles.clear();
        if (selectedFile != null && FileUtils.isFileAccepted(selectedFile, this.getAvailableFilters())) {
            this.selectedFiles.add(selectedFile);
        }
        this.updateSelectedFiles();
        this.fireSelectionChanged(this.selectedFiles);
    }

    public void setSelectedFiles(List<File> selectedFiles) {
        this.selectedFiles.clear();
        if (selectedFiles != null && selectedFiles.size() > 0) {
            if (this.multiSelectionEnabled) {
                for (File file : selectedFiles) {
                    if (!FileUtils.isFileAccepted(file, this.getAvailableFilters())) continue;
                    this.selectedFiles.add(file);
                }
            } else {
                for (File file : selectedFiles) {
                    if (!FileUtils.isFileAccepted(file, this.getAvailableFilters())) continue;
                    this.selectedFiles.add(file);
                    break;
                }
            }
        }
        this.updateSelectedFiles();
        this.fireSelectionChanged(this.selectedFiles);
    }

    public void clearSelectedFiles() {
        this.setSelectedFiles(null);
    }

    private void updateSelectedFiles() {
        this.contentPanel.removeAll();
        for (File file : this.selectedFiles) {
            FilePlate filePlate = new FilePlate(file);
            filePlate.applyComponentOrientation(this.getComponentOrientation());
            this.contentPanel.add((Component)filePlate);
        }
        this.revalidate();
        this.repaint();
    }

    private List<AbstractFileFilter> getAvailableFilters() {
        return this.webFileChooser != null ? this.webFileChooser.getFileChooserPanel().getAvailableFilters() : null;
    }

    public void addSelectedFilesListener(FilesSelectionListener listener) {
        this.listenerList.add(FilesSelectionListener.class, listener);
    }

    public void removeSelectedFilesListener(FilesSelectionListener listener) {
        this.listenerList.remove(FilesSelectionListener.class, listener);
    }

    private void fireSelectionChanged(List<File> selectedFiles) {
        for (FilesSelectionListener listener : (FilesSelectionListener[])this.listenerList.getListeners(FilesSelectionListener.class)) {
            listener.selectionChanged(selectedFiles);
        }
    }

    public class FilePlate
    extends WebPanel {
        public FilePlate(final File file) {
            super(StyleId.filechooserfieldFilePlate.at(WebFileChooserField.this.contentPanel), new BorderLayout(), new Component[0]);
            String actual = FileUtils.getDisplayFileName(file);
            final String display = WebFileChooserField.this.showFileExtensions || file.isDirectory() ? actual : FileUtils.getFileNamePart(actual);
            final String absolute = file.getAbsolutePath();
            StyleId nameId = StyleId.filechooserfieldFileNameLabel.at(this);
            final WebLabel fileName = new WebLabel(nameId, WebFileChooserField.this.showFileShortName ? display : absolute);
            fileName.setIcon(WebFileChooserField.this.showFileIcon ? FileUtils.getFileIcon(file, false) : null);
            this.add((Component)fileName, (Object)"Center");
            if (WebFileChooserField.this.showRemoveButton) {
                StyleId removeId = StyleId.filechooserfieldFileRemoveButton.at(this);
                WebButton remove2 = new WebButton(removeId, (Icon)Icons.crossSmall);
                remove2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebFileChooserField.this.selectedFiles.remove(file);
                        WebFileChooserField.this.contentPanel.remove((Component)FilePlate.this);
                        WebFileChooserField.this.revalidate();
                        WebFileChooserField.this.repaint();
                        WebFileChooserField.this.fireSelectionChanged(WebFileChooserField.this.selectedFiles);
                    }
                });
                this.add((Component)new CenterPanel(remove2), (Object)"After");
            }
            this.addMouseListener(new MouseAdapter(){
                private boolean showShortName;
                {
                    this.showShortName = WebFileChooserField.this.showFileShortName;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    FilePlate.this.requestFocusInWindow();
                    if (SwingUtilities.isRightMouseButton(e)) {
                        if (WebFileChooserField.this.multiSelectionEnabled) {
                            this.showShortName = !this.showShortName;
                            fileName.setText(this.showShortName ? display : absolute);
                        } else {
                            WebFileChooserField.this.setShowFileShortName(!WebFileChooserField.this.isShowFileShortName());
                        }
                    }
                    FilePlate.this.scrollToPlate();
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    FilePlate.this.scrollToPlate();
                }
            });
        }

        private void scrollToPlate() {
            Rectangle b = this.getBounds();
            int w = WebFileChooserField.this.scroll.getWidth() - 2;
            b.width = w < b.width ? w : b.width;
            WebFileChooserField.this.contentPanel.scrollRectToVisible(b);
        }
    }
}

