/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.filechooser.WebFileDrop;
import com.alee.extended.layout.TableLayout;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.drag.transfer.FilesTransferHandler;
import com.alee.managers.drag.transfer.ProxyDropHandler;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.AncestorEvent;

public class WebFilePlate
extends WebPanel {
    protected final List<ActionListener> closeListeners = new ArrayList<ActionListener>(1);
    protected boolean showRemoveButton = true;
    protected boolean showFileExtensions = false;
    protected final boolean animate = true;
    protected boolean dragEnabled = false;
    protected int dragAction = 2;
    protected final File file;
    protected WebTimer animator = null;
    protected float opacity = 0.0f;
    protected final WebLabel fileName;
    protected WebButton remove = null;

    public WebFilePlate(WebFileDrop fileDrop, final File file) {
        super(StyleId.filedropPlate.at(fileDrop));
        this.file = file;
        this.setLayout(new TableLayout(new double[][]{{-1.0, -2.0}, {-2.0}}, 0, 0));
        this.fileName = new WebLabel(StyleId.filedropPlateFileLabel.at(this));
        this.add((Component)this.fileName, (Object)"0,0");
        this.updateFileName();
        if (this.showRemoveButton) {
            this.add((Component)this.getRemoveButton(), (Object)"1,0");
        }
        this.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (WebFilePlate.this.animator != null && WebFilePlate.this.animator.isRunning()) {
                    WebFilePlate.this.animator.stop();
                }
                WebFilePlate.this.animator = new WebTimer("WebFilePlate.fadeInTimer", SwingUtils.frameRateDelay(24), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebFilePlate.this.opacity += 0.1f;
                        if (WebFilePlate.this.opacity < 1.0f) {
                            WebFilePlate.this.repaint();
                        } else {
                            WebFilePlate.this.opacity = 1.0f;
                            WebFilePlate.this.repaint();
                            WebFilePlate.this.animator.stop();
                        }
                    }
                });
                WebFilePlate.this.animator.start();
            }
        });
        MouseAdapter ma = new MouseAdapter(){
            public boolean doDrag;

            @Override
            public void mousePressed(MouseEvent e) {
                this.doDrag = true;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.doDrag) {
                    TransferHandler transferHandler = WebFilePlate.this.getTransferHandler();
                    transferHandler.exportAsDrag(WebFilePlate.this, e, transferHandler.getSourceActions(WebFilePlate.this));
                    this.doDrag = false;
                }
            }
        };
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
        this.setTransferHandler(new FilesTransferHandler(true, true){
            private final ProxyDropHandler dropProxy;
            {
                super(dragEnabled, dropEnabled);
                this.dropProxy = new ProxyDropHandler();
            }

            @Override
            public boolean isDragEnabled() {
                Container parent = WebFilePlate.this.getParent();
                if (parent instanceof WebFileDrop) {
                    return ((WebFileDrop)parent).isFilesDragEnabled();
                }
                return WebFilePlate.this.isDragEnabled();
            }

            @Override
            public int getSourceActions(JComponent component2) {
                return this.getSourceActions();
            }

            protected int getSourceActions() {
                Container parent = WebFilePlate.this.getParent();
                if (parent instanceof WebFileDrop) {
                    return ((WebFileDrop)parent).getDragAction();
                }
                return WebFilePlate.this.getDragAction();
            }

            @Override
            @Nullable
            public File getDraggedFile() {
                Container parent;
                if (this.getSourceActions() == 2 && (parent = WebFilePlate.this.getParent()) instanceof WebFileDrop) {
                    WebFilePlate.this.performPlateRemoval(new ActionEvent(WebFilePlate.this, 0, "File moved by drag"), false);
                }
                return file;
            }

            @Override
            public boolean importData(@NotNull TransferHandler.TransferSupport info) {
                return this.dropProxy.importData(info);
            }
        });
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    public int getDragAction() {
        return this.dragAction;
    }

    public void setDragAction(int dragAction) {
        this.dragAction = dragAction;
    }

    protected void updateFileName() {
        this.fileName.setIcon(this.getDisplayIcon(this.file));
        this.fileName.setText(this.getDisplayName(this.file));
    }

    protected WebButton getRemoveButton() {
        if (this.remove == null) {
            this.remove = new WebButton(StyleId.filedropPlateRemoveButton.at(this), (Icon)Icons.crossSmall);
            this.remove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    WebFilePlate.this.performPlateRemoval(ae, true);
                }
            });
        }
        return this.remove;
    }

    protected void performPlateRemoval(ActionEvent ae, boolean animate) {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
        if (animate) {
            this.animator = new WebTimer("WebFilePlate.fadeOutTimer", SwingUtils.frameRateDelay(24), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebFilePlate.this.opacity -= 0.1f;
                    if (WebFilePlate.this.opacity > 0.0f) {
                        WebFilePlate.this.repaint();
                    } else {
                        WebFilePlate.this.removeFromParent();
                        WebFilePlate.this.animator.stop();
                    }
                }
            });
            this.animator.start();
        } else {
            this.removeFromParent();
        }
        this.fireCloseActionPerformed(ae);
    }

    protected void removeFromParent() {
        this.opacity = 0.0f;
        Container container = this.getParent();
        if (container != null && container instanceof JComponent) {
            JComponent parent = (JComponent)container;
            parent.remove(this);
            parent.revalidate();
            parent.repaint();
        }
    }

    protected Icon getDisplayIcon(File file) {
        return FileUtils.getFileIcon(file, false);
    }

    protected String getDisplayName(File file) {
        String name = FileUtils.getDisplayFileName(file);
        return this.showFileExtensions || file.isDirectory() ? name : FileUtils.getFileNamePart(name);
    }

    public boolean isShowRemoveButton() {
        return this.showRemoveButton;
    }

    public void setShowRemoveButton(boolean showRemoveButton) {
        if (this.showRemoveButton != showRemoveButton) {
            this.showRemoveButton = showRemoveButton;
            if (showRemoveButton) {
                this.add((Component)this.getRemoveButton(), (Object)"1,0");
            } else {
                this.remove((Component)this.getRemoveButton());
            }
            this.revalidate();
        }
    }

    public boolean isShowFileExtensions() {
        return this.showFileExtensions;
    }

    public void setShowFileExtensions(boolean showFileExtensions) {
        this.showFileExtensions = showFileExtensions;
        this.updateFileName();
    }

    public File getFile() {
        return this.file;
    }

    public void remove() {
        this.remove.doClick(0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        GraphicsUtils.setupAlphaComposite((Graphics2D)g, Float.valueOf(this.opacity), this.opacity < 1.0f);
        super.paintComponent(g);
    }

    public void addCloseListener(ActionListener actionListener) {
        this.closeListeners.add(actionListener);
    }

    public void removeCloseListener(ActionListener actionListener) {
        this.closeListeners.remove(actionListener);
    }

    protected void fireCloseActionPerformed(ActionEvent e) {
        for (ActionListener listener : CollectionUtils.copy(this.closeListeners)) {
            listener.actionPerformed(e);
        }
    }
}

