/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.api.annotations.NotNull;
import com.alee.extended.filechooser.FileTableColumns;
import com.alee.extended.filechooser.WebFileTableCellEditor;
import com.alee.extended.filechooser.WebFileTableCellRenderer;
import com.alee.extended.filechooser.WebFileTableModel;
import com.alee.laf.table.WebTable;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.filefilter.NonHiddenFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class WebFileTable
extends WebTable
implements FileTableColumns {
    protected AbstractFileFilter fileFilter = new NonHiddenFilter();
    protected File displayedDirectory;

    public WebFileTable() {
        this(StyleId.auto);
    }

    public WebFileTable(List<File> files2) {
        this(StyleId.auto, files2);
    }

    public WebFileTable(List<File> files2, String ... columns) {
        this(StyleId.auto, files2, columns);
    }

    public WebFileTable(List<File> files2, List<String> columns) {
        this(StyleId.auto, files2, columns);
    }

    public WebFileTable(StyleId id) {
        this(id, new ArrayList<File>());
    }

    public WebFileTable(StyleId id, List<File> files2) {
        this(id, files2, CollectionUtils.copy(FileTableColumns.DEFAULT_COLUMNS));
    }

    public WebFileTable(StyleId id, List<File> files2, String ... columns) {
        this(id, files2, CollectionUtils.asList(columns));
    }

    public WebFileTable(StyleId id, List<File> files2, List<String> columns) {
        super(id);
        this.getColumnModel().setColumnMargin(0);
        this.setModel(new WebFileTableModel(files2, columns));
        this.setDefaultRenderer(File.class, new WebFileTableCellRenderer());
        this.setDefaultEditor(File.class, new WebFileTableCellEditor());
        this.setOptimizeRowHeight(true);
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        this.updateColumnSizes();
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.filetable;
    }

    private void updateColumnSizes() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            WebFileTableModel model = this.getFileTableModel();
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setIdentifier(model.getColumnId(i));
            if (model.getColumnId(i).equals("weblaf.filechooser.table.column.number")) {
                column.setPreferredWidth(30);
                continue;
            }
            if (model.getColumnId(i).equals("weblaf.filechooser.table.column.name")) {
                column.setPreferredWidth(340);
                continue;
            }
            if (model.getColumnId(i).equals("weblaf.filechooser.table.column.size") || model.getColumnId(i).equals("weblaf.filechooser.table.column.extension")) {
                column.setPreferredWidth(90);
                continue;
            }
            if (!model.getColumnId(i).equals("weblaf.filechooser.table.column.creation.date") && !model.getColumnId(i).equals("weblaf.filechooser.table.column.modification.date")) continue;
            column.setPreferredWidth(130);
        }
    }

    public WebFileTableModel getFileTableModel() {
        return (WebFileTableModel)this.getModel();
    }

    public AbstractFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(AbstractFileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.reloadFiles();
    }

    public void reloadFiles() {
        this.setDisplayedDirectory(this.getDisplayedDirectory());
    }

    public File getDisplayedDirectory() {
        return this.displayedDirectory;
    }

    public void setDisplayedDirectory(File file) {
        this.stopCellEditing();
        List<File> oldSelection = this.getSelectedFiles();
        File[] listedFiles = file != null ? FileUtils.listFiles(file, this.fileFilter) : null;
        File[] files2 = file != null ? FileUtils.sortFiles(listedFiles) : FileUtils.getDiskRoots();
        this.getFileTableModel().setFiles(CollectionUtils.asList(files2));
        if (FileUtils.equals(this.displayedDirectory, file)) {
            this.setSelectedFiles(oldSelection);
        }
        this.displayedDirectory = file;
    }

    public void setFiles(Collection<File> files2) {
        this.displayedDirectory = null;
        this.getFileTableModel().setFiles(files2);
    }

    public void addFiles(Collection<File> files2) {
        this.getFileTableModel().addFiles(files2);
    }

    public void setColumns(String ... columns) {
        this.setColumns(CollectionUtils.asList(columns));
    }

    public void setColumns(List<String> columns) {
        this.getFileTableModel().setColumns(columns);
        this.updateColumnSizes();
    }

    public File getSelectedFile() {
        int row = this.getSelectedRow();
        return row != -1 ? this.getFileAtRow(this.convertRowIndexToModel(row)) : null;
    }

    public List<File> getSelectedFiles() {
        int[] selectedRows = this.getSelectedRows();
        ArrayList<File> selectedFiles = new ArrayList<File>(selectedRows.length);
        for (int row : selectedRows) {
            selectedFiles.add(this.getFileAtRow(this.convertRowIndexToModel(row)));
        }
        return selectedFiles;
    }

    private File getFileAtRow(int row) {
        return this.getFileTableModel().getFileAtRow(row);
    }

    public void setSelectedFile(File file) {
        this.setSelectedFile(file, true);
    }

    public void setSelectedFile(File file, boolean scroll) {
        int row = this.getFileTableModel().getFileRow(file);
        this.setSelectedRow(row == -1 ? -1 : this.convertRowIndexToView(row), scroll);
    }

    public void setSelectedFiles(File[] files2) {
        this.clearSelection();
        for (File file : files2) {
            int row = this.getFileTableModel().getFileRow(file);
            if (row == -1) continue;
            this.addSelectedRow(this.convertRowIndexToView(row));
        }
    }

    public boolean isColumnDisplayed(String column) {
        return this.getFileTableModel().isColumnDisplayed(column);
    }

    public void setSelectedFiles(Collection<File> files2) {
        this.clearSelection();
        for (File file : files2) {
            int row = this.getFileTableModel().getFileRow(file);
            if (row == -1) continue;
            this.addSelectedRow(this.convertRowIndexToView(row));
        }
    }

    public boolean editSelectedFileName() {
        int row = this.getSelectedRow();
        return row != -1 && this.editFileNameAt(this.convertRowIndexToModel(row));
    }

    public boolean editFileName(File file) {
        return this.editFileNameAt(this.getFileTableModel().getFileRow(file));
    }

    public boolean editFileNameAt(int row) {
        return row != 1 && this.isColumnDisplayed("weblaf.filechooser.table.column.name") && this.editCellAt(this.convertRowIndexToView(row), this.getColumnModel().getColumnIndex("weblaf.filechooser.table.column.name"));
    }
}

