/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.api.jdk.Objects;
import com.alee.extended.filechooser.FileTableCellParameters;
import com.alee.extended.filechooser.WebFileTable;
import com.alee.laf.table.TableCellParameters;
import com.alee.laf.table.renderers.WebTableCellRenderer;
import com.alee.managers.language.LM;
import com.alee.utils.FileUtils;
import java.io.File;
import javax.swing.Icon;

public class WebFileTableCellRenderer<V extends File, C extends WebFileTable, P extends FileTableCellParameters<V, C>>
extends WebTableCellRenderer<V, C, P> {
    @Override
    protected int horizontalAlignmentForValue(P parameters) {
        int alignment = Objects.equals((Object)((FileTableCellParameters)parameters).columnId(), "weblaf.filechooser.table.column.number", "weblaf.filechooser.table.column.size") ? 11 : 10;
        return alignment;
    }

    @Override
    protected Icon iconForValue(P parameters) {
        Icon icon = Objects.equals((Object)((FileTableCellParameters)parameters).columnId(), (Object)"weblaf.filechooser.table.column.name") ? FileUtils.getFileIcon((File)((TableCellParameters)parameters).value()) : null;
        return icon;
    }

    @Override
    protected String textForValue(P parameters) {
        String text;
        boolean isFile = FileUtils.isFile((File)((TableCellParameters)parameters).value());
        if (Objects.equals((Object)((FileTableCellParameters)parameters).columnId(), (Object)"weblaf.filechooser.table.column.number")) {
            text = Integer.toString(((TableCellParameters)parameters).row() + 1);
        } else if (Objects.equals((Object)((FileTableCellParameters)parameters).columnId(), (Object)"weblaf.filechooser.table.column.name")) {
            text = FileUtils.getDisplayFileName((File)((TableCellParameters)parameters).value());
        } else if (Objects.equals((Object)((FileTableCellParameters)parameters).columnId(), (Object)"weblaf.filechooser.table.column.size")) {
            text = isFile ? FileUtils.getDisplayFileSize((File)((TableCellParameters)parameters).value()) : "";
        } else if (Objects.equals((Object)((FileTableCellParameters)parameters).columnId(), (Object)"weblaf.filechooser.table.column.extension")) {
            text = isFile ? FileUtils.getFileExtPart(((File)((TableCellParameters)parameters).value()).getName(), true) : LM.get("weblaf.file.type.folder", new Object[0]);
        } else if (Objects.equals((Object)((FileTableCellParameters)parameters).columnId(), (Object)"weblaf.filechooser.table.column.creation.date")) {
            text = FileUtils.getDisplayFileCreationDate((File)((TableCellParameters)parameters).value());
        } else if (Objects.equals((Object)((FileTableCellParameters)parameters).columnId(), (Object)"weblaf.filechooser.table.column.modification.date")) {
            text = FileUtils.getDisplayFileModificationDate((File)((TableCellParameters)parameters).value());
        } else {
            throw new IllegalArgumentException("Unknown column identifier: " + ((FileTableCellParameters)parameters).columnId());
        }
        return text;
    }

    @Override
    protected P getRenderingParameters(WebFileTable table2, File value, boolean isSelected, boolean hasFocus, int row, int column) {
        return (P)new FileTableCellParameters<File, WebFileTable>(table2, value, row, column, isSelected, hasFocus);
    }

    public static final class UIResource<V extends File, C extends WebFileTable, P extends FileTableCellParameters<V, C>>
    extends WebFileTableCellRenderer<V, C, P>
    implements javax.swing.plaf.UIResource {
    }
}

