/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.icon;

import com.alee.api.annotations.NotNull;
import com.alee.extended.icon.MixedIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Collection;
import javax.swing.Icon;

public class FlowIcon
extends MixedIcon<FlowIcon> {
    protected final int spacing;

    public FlowIcon(@NotNull Collection<? extends Icon> icons) {
        this(0, icons);
    }

    public FlowIcon(int spacing, @NotNull Collection<? extends Icon> icons) {
        this(spacing, icons.toArray(new Icon[icons.size()]));
    }

    public FlowIcon(Icon ... icons) {
        this(0, icons);
    }

    public FlowIcon(int spacing, Icon ... icons) {
        super(icons);
        this.spacing = spacing;
    }

    @Override
    protected FlowIcon newInstance(Icon ... icons) {
        return new FlowIcon(icons);
    }

    @Override
    public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
        int offset = x;
        for (Icon icon : this.icons) {
            icon.paintIcon(c, g, offset, y);
            offset += icon.getIconWidth() + this.spacing;
        }
    }

    @Override
    public int getIconWidth() {
        int width = 0;
        for (Icon icon : this.icons) {
            width += icon.getIconWidth() + this.spacing;
        }
        return width - this.spacing;
    }

    @Override
    public int getIconHeight() {
        return this.maxHeight(this.icons);
    }
}

