/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.icon;

import com.alee.api.annotations.NotNull;
import com.alee.api.ui.DisabledCopySupplier;
import com.alee.api.ui.TransparentCopySupplier;
import com.alee.managers.icon.IconException;
import com.alee.utils.ImageUtils;
import javax.swing.Icon;

public abstract class MixedIcon<I extends MixedIcon<I>>
implements Icon,
DisabledCopySupplier<I>,
TransparentCopySupplier<I> {
    @NotNull
    protected final Icon[] icons;

    public MixedIcon(Icon ... icons) {
        if (icons.length <= 1) {
            throw new IconException("At least 2 icons or more should be provided");
        }
        this.icons = icons;
    }

    protected abstract I newInstance(Icon ... var1);

    protected int maxWidth(Icon ... icons) {
        int maxWidth = 0;
        for (Icon icon : icons) {
            maxWidth = Math.max(maxWidth, icon.getIconWidth());
        }
        return maxWidth;
    }

    protected int maxHeight(Icon ... icons) {
        int maxHeight = 0;
        for (Icon icon : icons) {
            maxHeight = Math.max(maxHeight, icon.getIconHeight());
        }
        return maxHeight;
    }

    @Override
    @NotNull
    public I createDisabledCopy() {
        Icon[] disabled = new Icon[this.icons.length];
        for (int i = 0; i < this.icons.length; ++i) {
            disabled[i] = ImageUtils.getDisabledCopy(this.icons[i]);
        }
        return this.newInstance(disabled);
    }

    @Override
    @NotNull
    public I createTransparentCopy(float opacity) {
        Icon[] transparent = new Icon[this.icons.length];
        for (int i = 0; i < this.icons.length; ++i) {
            transparent[i] = ImageUtils.getTransparentCopy(this.icons[i], opacity);
        }
        return this.newInstance(transparent);
    }
}

