/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.api.jdk.Objects;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.shape.Round;
import com.alee.painter.decoration.shape.ShapeType;
import com.alee.painter.decoration.shape.Sides;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.ShapeUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.geom.Area;
import java.util.Map;
import javax.swing.JComponent;

public final class ComponentHighlighter
extends JComponent
implements ComponentListener,
HierarchyBoundsListener {
    public static final Color marginColor = new Color(255, 255, 0, 50);
    public static final Color borderColor = new Color(255, 0, 0, 50);
    public static final Color paddingColor = new Color(0, 200, 0, 50);
    public static final Color contentColor = new Color(0, 0, 255, 50);
    private static final Insets emptyInsets = new Insets(0, 0, 0, 0);
    private static final int sizeTipHeight = 20;
    @Nullable
    private transient Component component;
    @Nullable
    private transient WebGlassPane glassPane;
    @Nullable
    private transient VisibilityBehavior visibilityListener;

    public ComponentHighlighter() {
        this.setOpaque(false);
        this.setFont(WebLookAndFeel.globalTextFont);
    }

    public void install(@NotNull Component component2) {
        if (this.component == null && this.glassPane == null && this.visibilityListener == null) {
            this.component = Objects.requireNonNull(component2, "Component cannot be null");
            WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(component2);
            this.glassPane = Objects.requireNonNull(webGlassPane, "Component window must have a glass pane");
            this.updateBounds();
            component2.addComponentListener(this);
            component2.addHierarchyBoundsListener(this);
            this.visibilityListener = new VisibilityBehavior<Component>(component2){

                @Override
                protected void hidden(@NotNull Component component2) {
                    ComponentHighlighter.this.uninstall();
                }
            };
            this.visibilityListener.install();
            this.glassPane.showComponent(this);
        }
    }

    public void uninstall() {
        if (this.component != null && this.glassPane != null && this.visibilityListener != null) {
            this.glassPane.hideComponent(this);
            this.glassPane = null;
            this.visibilityListener.uninstall();
            this.visibilityListener = null;
            this.component.removeHierarchyBoundsListener(this);
            this.component.removeComponentListener(this);
            this.component = null;
        }
    }

    @Nullable
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void ancestorMoved(@NotNull HierarchyEvent e) {
        this.updateBounds();
    }

    @Override
    public void ancestorResized(@NotNull HierarchyEvent e) {
        this.updateBounds();
    }

    @Override
    public void componentResized(@NotNull ComponentEvent e) {
        this.updateBounds();
    }

    @Override
    public void componentMoved(@NotNull ComponentEvent e) {
        this.updateBounds();
    }

    @Override
    public void componentShown(@NotNull ComponentEvent e) {
    }

    @Override
    public void componentHidden(@NotNull ComponentEvent e) {
        this.uninstall();
    }

    private void updateBounds() {
        if (this.component != null && this.glassPane != null) {
            Dimension glassPaneSize = this.glassPane.getSize();
            Rectangle componentBounds = CoreSwingUtils.getRelativeBounds(this.component, this.glassPane);
            int tipWidth = this.getTipWidth();
            CompassDirection tipDirection = this.getTipDirection(tipWidth, glassPaneSize, componentBounds);
            Rectangle tipBounds = this.getTipBounds(true, tipWidth, tipDirection, componentBounds);
            Rectangle bodyBounds = this.getBodyBounds(true, tipWidth, tipDirection, componentBounds);
            this.setBounds(GeometryUtils.getNonNullContainingRect(tipBounds, bodyBounds));
        }
    }

    private int getTipWidth() {
        return this.getFontMetrics(this.getFont()).stringWidth(this.getSizeTip()) + 8;
    }

    @NotNull
    private CompassDirection getTipDirection(int tipWidth, @NotNull Dimension glassPaneSize, @NotNull Rectangle componentBounds) {
        boolean fromLeft;
        boolean bl = fromLeft = componentBounds.x + tipWidth < glassPaneSize.width || componentBounds.x + componentBounds.width - tipWidth < 0;
        CompassDirection direction = componentBounds.y > 20 ? (fromLeft ? CompassDirection.northWest : CompassDirection.northEast) : (fromLeft ? CompassDirection.southWest : CompassDirection.southEast);
        return direction;
    }

    @NotNull
    private Rectangle getTipBounds(boolean relative, int tipWidth, @NotNull CompassDirection tipDirection, @NotNull Rectangle componentBounds) {
        int x;
        if (tipDirection == CompassDirection.northWest || tipDirection == CompassDirection.southWest) {
            x = relative ? componentBounds.x : 0;
        } else {
            int n = x = relative ? componentBounds.x + componentBounds.width - tipWidth : 0;
        }
        int y = tipDirection == CompassDirection.northEast || tipDirection == CompassDirection.northWest ? (relative ? componentBounds.y - 20 : 0) : (relative ? componentBounds.y + componentBounds.height : componentBounds.height);
        int w = relative ? tipWidth : tipWidth - 1;
        int h = relative ? 20 : 19;
        return new Rectangle(x, y, w, h);
    }

    @NotNull
    private Rectangle getBodyBounds(boolean relative, int tipWidth, @NotNull CompassDirection tipDirection, @NotNull Rectangle componentBounds) {
        int x;
        if (tipDirection == CompassDirection.northWest || tipDirection == CompassDirection.southWest) {
            x = relative ? componentBounds.x : 0;
        } else {
            int n = x = relative ? componentBounds.x : tipWidth - componentBounds.width;
        }
        int y = tipDirection == CompassDirection.northEast || tipDirection == CompassDirection.northWest ? (relative ? componentBounds.y : 20) : (relative ? componentBounds.y : 0);
        int w = componentBounds.width;
        int h = componentBounds.height;
        return new Rectangle(x, y, w, h);
    }

    @NotNull
    private String getSizeTip() {
        return this.component != null ? this.component.getWidth() + " x " + this.component.getHeight() + " px" : "? x ?";
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (this.component != null && this.glassPane != null) {
            this.paintHighlight((Graphics2D)g, this.component, this.glassPane);
        }
    }

    private void paintHighlight(@NotNull Graphics2D g2d, @NotNull Component component2, @NotNull WebGlassPane glassPane) {
        Dimension glassPaneSize = glassPane.getSize();
        Rectangle componentBounds = CoreSwingUtils.getRelativeBounds(component2, glassPane);
        int tipWidth = this.getTipWidth();
        CompassDirection tipPosition = this.getTipDirection(tipWidth, glassPaneSize, componentBounds);
        Rectangle tipBounds = this.getTipBounds(false, tipWidth, tipPosition, componentBounds);
        Rectangle bodyBounds = this.getBodyBounds(false, tipWidth, tipPosition, componentBounds);
        this.paintSizeTip(g2d, component2, tipBounds, tipPosition);
        this.paintAreas(g2d, component2, bodyBounds);
    }

    private void paintSizeTip(@NotNull Graphics2D g2d, @NotNull Component component2, @NotNull Rectangle tipBounds, @NotNull CompassDirection tipPosition) {
        FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
        int shearY = LafUtils.getTextCenterShiftY(fm);
        boolean top = tipPosition == CompassDirection.northWest || tipPosition == CompassDirection.northEast;
        boolean left = tipPosition == CompassDirection.northWest || tipPosition == CompassDirection.southWest;
        boolean longTip = component2.getWidth() < tipBounds.width;
        Object aa = GraphicsUtils.setupAntialias(g2d);
        Round round = new Round(top || !left && longTip ? 5 : 0, top || left && longTip ? 5 : 0, !top || left && longTip ? 5 : 0, !top || !left && longTip ? 5 : 0);
        Sides sides = new Sides(true);
        g2d.setPaint(Color.WHITE);
        g2d.fill(ShapeUtils.createFillShape(0, tipBounds, round, sides, ShapeType.background));
        g2d.setPaint(Color.DARK_GRAY);
        g2d.draw(ShapeUtils.createBorderShape(0, tipBounds, round, sides));
        GraphicsUtils.restoreAntialias(g2d, aa);
        Map taa = SwingUtils.setupTextAntialias(g2d);
        g2d.setPaint(Color.BLACK);
        g2d.drawString(this.getSizeTip(), tipBounds.x + 4, tipBounds.y + tipBounds.height / 2 + 1 + shearY);
        SwingUtils.restoreTextAntialias(g2d, taa);
    }

    private void paintAreas(@NotNull Graphics2D g2d, @NotNull Component component2, @NotNull Rectangle bodyBounds) {
        if (component2 instanceof JComponent && LafUtils.hasWebLafUI((JComponent)component2)) {
            JComponent jComponent = (JComponent)component2;
            Insets margin = PainterSupport.getMargin(jComponent, true);
            Insets m = margin != null ? margin : emptyInsets;
            Insets padding = PainterSupport.getPadding(jComponent, true);
            Insets p = padding != null ? padding : emptyInsets;
            Insets insets = jComponent.getInsets();
            Insets b = insets != null && (insets.top > 0 || insets.left > 0 || insets.bottom > 0 || insets.right > 0) ? new Insets(insets.top - m.top - p.top, insets.left - m.left - p.left, insets.bottom - m.bottom - p.bottom, insets.right - m.right - p.right) : emptyInsets;
            Rectangle sr = new Rectangle(bodyBounds);
            Rectangle mr = new Rectangle(sr.x + m.left, sr.y + m.top, sr.width - m.left - m.right, sr.height - m.top - m.bottom);
            Rectangle br = new Rectangle(mr.x + b.left, mr.y + b.top, mr.width - b.left - b.right, mr.height - b.top - b.bottom);
            Rectangle pr = new Rectangle(br.x + p.left, br.y + p.top, br.width - p.left - p.right, br.height - p.top - p.bottom);
            this.paintComplexArea(g2d, m, sr, mr, marginColor);
            this.paintComplexArea(g2d, b, mr, br, borderColor);
            this.paintComplexArea(g2d, p, br, pr, paddingColor);
            this.paintContentArea(g2d, pr);
        } else {
            this.paintContentArea(g2d, bodyBounds);
        }
    }

    private void paintComplexArea(@NotNull Graphics2D g2d, @NotNull Insets insets, @NotNull Rectangle outer, @NotNull Rectangle inner, @NotNull Color color) {
        if (!insets.equals(emptyInsets)) {
            g2d.setPaint(color);
            Area ma = new Area(outer);
            ma.exclusiveOr(new Area(inner));
            g2d.fill(ma);
        }
    }

    private void paintContentArea(@NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        g2d.setPaint(contentColor);
        g2d.fill(bounds);
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }
}

