/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.behavior.Behavior;
import com.alee.extended.behavior.BehaviorException;
import com.alee.extended.inspector.ComponentHighlighter;
import com.alee.extended.inspector.InspectionListener;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.CoreSwingUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public final class ComponentInspectBehavior
implements Behavior {
    @Nullable
    protected ComponentHighlighter hoverHighlighter;
    @Nullable
    protected AWTEventListener awtEventListener;
    @Nullable
    protected Component root;
    @Nullable
    protected InspectionListener listener;

    public boolean isInstalled() {
        return this.hoverHighlighter != null;
    }

    public void install(@Nullable Component root, @NotNull InspectionListener listener) {
        if (this.isInstalled()) {
            throw new BehaviorException("ComponentInspectBehavior is already installed");
        }
        this.root = root;
        this.listener = listener;
        this.hoverHighlighter = new ComponentHighlighter();
        this.awtEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(@NotNull AWTEvent event) {
                int eventId = event.getID();
                if (event instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)event;
                    Component source = (Component)event.getSource();
                    Component component2 = CoreSwingUtils.getTopComponentAt(source, mouseEvent.getPoint());
                    if (component2 != null && component2.isShowing() && (ComponentInspectBehavior.this.root == null || CoreSwingUtils.isAncestorOf(ComponentInspectBehavior.this.root, component2))) {
                        if (Objects.equals((Object)eventId, (Object)501)) {
                            ComponentInspectBehavior.this.listener.inspected(component2);
                            ComponentInspectBehavior.this.uninstall();
                        } else if (Objects.equals((Object)eventId, 504, 503)) {
                            if (ComponentInspectBehavior.this.hoverHighlighter != null && ComponentInspectBehavior.this.hoverHighlighter.getComponent() != component2) {
                                ComponentInspectBehavior.this.showInspector(component2);
                            }
                        } else if (Objects.equals((Object)eventId, (Object)505)) {
                            ComponentInspectBehavior.this.hideInspector();
                        }
                        mouseEvent.consume();
                    }
                } else if (event instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)event;
                    if (Objects.equals((Object)eventId, (Object)401) && Hotkey.ESCAPE.isTriggered(keyEvent)) {
                        ComponentInspectBehavior.this.listener.cancelled();
                        ComponentInspectBehavior.this.uninstall();
                    }
                    keyEvent.consume();
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 16L);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 32L);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 8L);
    }

    public void uninstall() {
        if (!this.isInstalled()) {
            throw new BehaviorException("ComponentInspectBehavior is not installed");
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
        this.hideInspector();
        this.hoverHighlighter = null;
        this.listener = null;
        this.root = null;
    }

    protected void showInspector(@NotNull Component component2) {
        if (!this.isInstalled()) {
            throw new BehaviorException("ComponentInspectBehavior is not installed");
        }
        this.hideInspector();
        this.hoverHighlighter.install(component2);
    }

    protected void hideInspector() {
        if (!this.isInstalled()) {
            throw new BehaviorException("ComponentInspectBehavior is not installed");
        }
        this.hoverHighlighter.uninstall();
    }
}

