/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.ui.IconBridge;
import com.alee.api.ui.TextBridge;
import com.alee.extended.inspector.InterfaceTree;
import com.alee.extended.inspector.info.AWTComponentPreview;
import com.alee.extended.inspector.info.ComponentPreview;
import com.alee.extended.inspector.info.JComponentPreview;
import com.alee.extended.inspector.info.WComponentPreview;
import com.alee.extended.tree.ExTreeModel;
import com.alee.laf.VisibleWindowListener;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.TreeNodeParameters;
import com.alee.laf.tree.UniqueNode;
import com.alee.managers.language.LM;
import com.alee.managers.style.StyleAdapter;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.LafUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.TreeModel;

public class InterfaceTreeNode
extends UniqueNode<InterfaceTreeNode, Component>
implements IconBridge<TreeNodeParameters<InterfaceTreeNode, InterfaceTree>>,
TextBridge<TreeNodeParameters<InterfaceTreeNode, InterfaceTree>> {
    public static final String ALL_WINDOWS_ID = "all.windows";
    protected static final ImageIcon windowsIcon = new ImageIcon(ComponentPreview.class.getResource("icons/windows.png"));
    protected static final ComponentPreview wComponentPreview = new WComponentPreview();
    protected static final ComponentPreview jComponentPreview = new JComponentPreview();
    protected static final ComponentPreview awtComponentPreview = new AWTComponentPreview();
    @NotNull
    protected transient InterfaceTree tree;
    protected transient ComponentAdapter componentAdapter;
    protected transient ContainerAdapter containerAdapter;
    protected transient StyleListener styleListener;
    protected transient VisibleWindowListener visibleWindowListener;

    public InterfaceTreeNode(@NotNull InterfaceTree tree, @Nullable Component component2) {
        super(InterfaceTreeNode.id(component2), component2);
        this.tree = tree;
        this.install();
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull TreeNodeParameters<InterfaceTreeNode, InterfaceTree> parameters) {
        Component component2 = (Component)this.getUserObject();
        return component2 != null ? this.getPreview().getIcon(component2) : windowsIcon;
    }

    @Override
    @Nullable
    public String getText(@NotNull TreeNodeParameters<InterfaceTreeNode, InterfaceTree> parameters) {
        Component component2 = (Component)this.getUserObject();
        return component2 != null ? this.getPreview().getText(component2) : LM.get("weblaf.ex.inspector.windows", new Object[0]);
    }

    protected void install() {
        WebLookAndFeel.checkEventDispatchThread();
        Component component2 = (Component)this.getUserObject();
        if (component2 == null) {
            this.visibleWindowListener = new VisibleWindowListener(){

                @Override
                public void windowDisplayed(@NotNull Window window) {
                    if (window.isShowing()) {
                        InterfaceTreeNode childNode = new InterfaceTreeNode(InterfaceTreeNode.this.tree, window);
                        InterfaceTreeNode.this.tree.addChildNode(InterfaceTreeNode.this, childNode);
                    }
                }

                @Override
                public void windowHidden(@NotNull Window window) {
                    for (int i = 0; i < InterfaceTreeNode.this.getChildCount(); ++i) {
                        InterfaceTreeNode child = (InterfaceTreeNode)InterfaceTreeNode.this.getChildAt(i);
                        if (child.getUserObject() != window) continue;
                        child.uninstall();
                        InterfaceTreeNode.this.tree.removeNode(child);
                        break;
                    }
                }
            };
            WebLookAndFeel.addVisibleWindowListener(this.tree, this.visibleWindowListener);
        } else {
            this.componentAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(@NotNull ComponentEvent e) {
                }

                @Override
                public void componentMoved(@NotNull ComponentEvent e) {
                }

                @Override
                public void componentShown(@NotNull ComponentEvent e) {
                    InterfaceTreeNode.this.updateNodeLater(InterfaceTreeNode.this.tree);
                }

                @Override
                public void componentHidden(@NotNull ComponentEvent e) {
                    InterfaceTreeNode.this.updateNodeLater(InterfaceTreeNode.this.tree);
                }
            };
            component2.addComponentListener(this.componentAdapter);
            if (!(component2 instanceof CellRendererPane)) {
                JComponent jComponent;
                if (component2 instanceof Container) {
                    this.containerAdapter = new ContainerAdapter(){

                        @Override
                        public void componentAdded(@NotNull ContainerEvent e) {
                            Component child = e.getChild();
                            if (InterfaceTreeNode.this.tree.accept(child)) {
                                InterfaceTreeNode childNode = new InterfaceTreeNode(InterfaceTreeNode.this.tree, child);
                                InterfaceTreeNode.this.tree.addChildNode(InterfaceTreeNode.this, childNode);
                            }
                        }

                        @Override
                        public void componentRemoved(@NotNull ContainerEvent e) {
                            Component child = e.getChild();
                            if (InterfaceTreeNode.this.tree.accept(child)) {
                                String nodeId = InterfaceTreeNode.id(child);
                                InterfaceTreeNode childNode = (InterfaceTreeNode)InterfaceTreeNode.this.tree.getNode(nodeId);
                                childNode.uninstall();
                                InterfaceTreeNode.this.tree.removeNode(childNode);
                            }
                        }
                    };
                    ((Container)component2).addContainerListener(this.containerAdapter);
                }
                if (component2 instanceof JComponent && LafUtils.hasWebLafUI(jComponent = (JComponent)component2)) {
                    this.styleListener = new StyleAdapter(){

                        @Override
                        public void skinUpdated(@NotNull JComponent component2, @NotNull StyleId styleId) {
                            InterfaceTreeNode.this.updateNodeLater(InterfaceTreeNode.this.tree);
                        }
                    };
                    StyleManager.addStyleListener(jComponent, this.styleListener);
                }
            }
        }
    }

    protected void uninstall() {
        Component component2;
        WebLookAndFeel.checkEventDispatchThread();
        TreeModel model = this.tree.getModel();
        if (model != null) {
            for (InterfaceTreeNode child : ((ExTreeModel)model).getRawChildren(this)) {
                child.uninstall();
            }
        }
        if ((component2 = (Component)this.getUserObject()) != null) {
            component2.removeComponentListener(this.componentAdapter);
            if (this.containerAdapter != null) {
                ((Container)component2).removeContainerListener(this.containerAdapter);
            }
            if (this.styleListener != null) {
                StyleManager.removeStyleListener((JComponent)component2, this.styleListener);
            }
            this.componentAdapter = null;
            this.containerAdapter = null;
            this.styleListener = null;
        } else {
            WebLookAndFeel.removeVisibleWindowListener(this.tree, this.visibleWindowListener);
            this.visibleWindowListener = null;
        }
    }

    @NotNull
    protected ComponentPreview getPreview() {
        ComponentPreview preview;
        Component component2 = (Component)this.getUserObject();
        if (component2 != null) {
            preview = component2 instanceof JComponent ? (StyleManager.isSupported((JComponent)component2) ? wComponentPreview : jComponentPreview) : awtComponentPreview;
        } else {
            throw new RuntimeException("ComponentPreview is not available for null Component");
        }
        return preview;
    }

    protected void updateNodeLater(final @NotNull InterfaceTree tree) {
        CoreSwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                tree.updateNode(InterfaceTreeNode.this);
            }
        });
    }

    @Override
    @NotNull
    public String toString() {
        Component component2 = (Component)this.getUserObject();
        return component2 != null ? this.getPreview().getText(component2) : LM.get("weblaf.ex.inspector.windows", new Object[0]);
    }

    @NotNull
    protected static String id(@Nullable Component component2) {
        return component2 != null ? Integer.toString(component2.hashCode()) : ALL_WINDOWS_ID;
    }
}

