/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.label.AbstractStyledTextContent;
import com.alee.extended.label.StyleRange;
import com.alee.extended.label.StyleRanges;
import com.alee.extended.label.TextWrap;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.ContentPropertyListener;
import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Container;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractSimpleStyledTextContent<C extends JComponent, D extends IDecoration<C, D>, I extends AbstractSimpleStyledTextContent<C, D, I>>
extends AbstractStyledTextContent<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected TextWrap wrap;
    @XStreamAsAttribute
    @Nullable
    protected Integer maximumRows;
    @Nullable
    protected transient StyleRanges styleRanges;
    @Nullable
    protected transient Integer mnemonicIndex;
    @Nullable
    protected transient ContentPropertyListener<C, D> contentListener;

    @Override
    public void activate(@NotNull C c, @NotNull D d) {
        this.initializeContentCache(c, d);
        super.activate(c, d);
        this.installContentPropertyListener(c, d);
    }

    @Override
    public void deactivate(@NotNull C c, @NotNull D d) {
        this.uninstallContentPropertyListener(c, d);
        super.deactivate(c, d);
        this.destroyContentCache(c, d);
    }

    protected void initializeContentCache(@NotNull C c, @NotNull D d) {
        this.styleRanges = new StyleRanges(this.getComponentText(c, d));
        this.mnemonicIndex = SwingUtils.getMnemonicIndex(this.styleRanges.getPlainText(), this.getComponentMnemonic(c, d));
    }

    protected void destroyContentCache(@NotNull C c, @NotNull D d) {
        this.mnemonicIndex = null;
        this.styleRanges = null;
    }

    protected void installContentPropertyListener(@NotNull C c, @NotNull D d) {
        String property = this.getStyledTextProperty();
        if (property != null) {
            this.contentListener = new ContentPropertyListener<C, D>((JComponent)c, (IDecoration)d){

                @Override
                public void propertyChange(@NotNull C c, @NotNull D d, @NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
                    AbstractSimpleStyledTextContent.this.updateContentCache(c, d);
                }
            };
            ((Container)c).addPropertyChangeListener(property, this.contentListener);
        }
    }

    protected void uninstallContentPropertyListener(@NotNull C c, @NotNull D d) {
        String property = this.getStyledTextProperty();
        if (property != null) {
            ((Component)c).removePropertyChangeListener(property, this.contentListener);
            this.contentListener = null;
        }
    }

    @Nullable
    protected abstract String getStyledTextProperty();

    protected void updateContentCache(@NotNull C c, @NotNull D d) {
        this.initializeContentCache(c, d);
        this.buildTextRanges(c, d);
    }

    @Override
    @NotNull
    protected List<StyleRange> getStyleRanges(@NotNull C c, @NotNull D d) {
        return this.styleRanges != null ? this.styleRanges.getStyleRanges() : Collections.emptyList();
    }

    @Override
    @NotNull
    protected TextWrap getWrapType(@NotNull C c, @NotNull D d) {
        return this.wrap != null ? this.wrap : TextWrap.none;
    }

    @Override
    protected int getMaximumRows(@NotNull C c, @NotNull D d) {
        return this.maximumRows != null ? this.maximumRows : 0;
    }

    @Override
    @Nullable
    protected String getText(@NotNull C c, @NotNull D d) {
        return this.styleRanges != null ? this.styleRanges.getPlainText() : this.getComponentText(c, d);
    }

    @Override
    protected int getMnemonicIndex(@NotNull C c, @NotNull D d) {
        return this.mnemonicIndex != null ? this.mnemonicIndex : -1;
    }

    @Nullable
    protected abstract String getComponentText(@NotNull C var1, @NotNull D var2);

    protected abstract int getComponentMnemonic(@NotNull C var1, @NotNull D var2);
}

