/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.extended.label.StyleRange;
import com.alee.extended.label.StyleSettings;
import com.alee.extended.label.StyledTextRow;
import com.alee.extended.label.TextRange;
import com.alee.extended.label.TextRanges;
import com.alee.extended.label.TextWrap;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractTextContent;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FontUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.general.Pair;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractStyledTextContent<C extends JComponent, D extends IDecoration<C, D>, I extends AbstractStyledTextContent<C, D, I>>
extends AbstractTextContent<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Boolean ignoreStyleColors;
    @XStreamAsAttribute
    @Nullable
    protected Float scriptFontRatio;
    @XStreamAsAttribute
    @Nullable
    protected Boolean preserveLineBreaks;
    @XStreamAsAttribute
    @Nullable
    protected Integer rowGap;
    @XStreamAsAttribute
    @Nullable
    protected Integer maximumTextWidth;
    @XStreamAsAttribute
    @Nullable
    protected String globalStyle;
    @OmitOnClone
    @OmitOnMerge
    protected transient List<TextRange> textRanges;

    @Override
    public void activate(@NotNull C c, @NotNull D d) {
        super.activate(c, d);
        this.buildTextRanges(c, d);
    }

    @Override
    public void deactivate(@NotNull C c, @NotNull D d) {
        this.textRanges = null;
        super.deactivate(c, d);
    }

    protected boolean isIgnoreColorSettings(@NotNull C c, @NotNull D d) {
        return this.ignoreStyleColors != null && this.ignoreStyleColors != false;
    }

    protected Float getScriptFontRatio(@NotNull C c, @NotNull D d) {
        return Float.valueOf(this.scriptFontRatio != null ? this.scriptFontRatio.floatValue() : 1.5f);
    }

    protected boolean isPreserveLineBreaks(@NotNull C c, @NotNull D d) {
        return this.preserveLineBreaks == null || this.preserveLineBreaks != false;
    }

    protected int getRowGap(@NotNull C c, @NotNull D d) {
        return this.rowGap != null ? this.rowGap : 0;
    }

    protected int getMaximumTextWidth(@NotNull C c, @NotNull D d) {
        return this.maximumTextWidth != null ? this.maximumTextWidth : Short.MAX_VALUE;
    }

    @Nullable
    protected StyleRange getGlobalStyle(@NotNull C c, @NotNull D d, @Nullable String plainText) {
        return TextUtils.notEmpty(this.globalStyle) && plainText != null ? new StyleSettings(0, plainText.length(), this.globalStyle).getStyleRange() : null;
    }

    @NotNull
    protected abstract List<StyleRange> getStyleRanges(@NotNull C var1, @NotNull D var2);

    @NotNull
    protected abstract TextWrap getWrapType(@NotNull C var1, @NotNull D var2);

    protected abstract int getMaximumRows(@NotNull C var1, @NotNull D var2);

    protected void buildTextRanges(@NotNull C c, @NotNull D d) {
        String plainText = this.getText(c, d);
        List<StyleRange> styleRanges = this.getStyleRanges(c, d);
        StyleRange globalStyle = this.getGlobalStyle(c, d, plainText);
        if (globalStyle != null) {
            styleRanges = CollectionUtils.copy(styleRanges);
            styleRanges.add(0, globalStyle);
        }
        this.textRanges = new TextRanges(plainText, styleRanges).getTextRanges();
    }

    @Override
    public int getContentBaseline(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        return super.getContentBaseline(c, d, bounds);
    }

    @Override
    protected void paintText(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        if (this.textRanges != null) {
            int rg = Math.max(0, this.getRowGap(c, d));
            int x = bounds.x;
            int y = bounds.y;
            List<StyledTextRow> rows = this.layout(c, d, bounds);
            if (!rows.isEmpty()) {
                int va = this.getVerticalAlignment(c, d);
                if (va != 1) {
                    int th = -rg;
                    for (StyledTextRow row : rows) {
                        th += row.height + rg;
                    }
                    if (th < bounds.height) {
                        switch (va) {
                            case 0: {
                                y = (int)((double)y + Math.ceil((double)(bounds.height - th) / 2.0));
                                break;
                            }
                            case 3: {
                                y += bounds.height - th;
                                break;
                            }
                            default: {
                                throw new DecorationException("Incorrect vertical alignment provided: " + va);
                            }
                        }
                    }
                }
                Pair<Integer, Integer> fs = this.getFontSize(c, d);
                y += fs.getKey().intValue();
                for (int i = 0; i < rows.size(); ++i) {
                    StyledTextRow row;
                    row = rows.get(i);
                    this.paintRow(c, d, g2d, bounds, x, y, row, i == rows.size() - 1);
                    y += row.height + rg;
                }
            }
        }
    }

    @NotNull
    protected List<StyledTextRow> layout(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        int endY = bounds.y + bounds.height;
        int endX = bounds.x + bounds.width;
        Pair<Integer, Integer> fs = this.getFontSize(c, d);
        int maxRowHeight = fs.getValue();
        int maxAscent = fs.getKey();
        int x = bounds.x;
        int y = bounds.y + maxAscent;
        int mnemonicIndex = this.getMnemonicIndex(c, d);
        int maximumRows = this.getMaximumRows(c, d);
        int rowGap = this.getRowGap(c, d);
        TextWrap wrapType = this.getWrapType(c, d);
        boolean preserveLineBreaks = this.isPreserveLineBreaks(c, d);
        Font font = ((Component)c).getFont();
        int defaultFontSize = font.getSize();
        int rowCount = 0;
        int charDisplayed = 0;
        int nextRowStartIndex = 0;
        StyledTextRow row = new StyledTextRow(maxRowHeight, true);
        boolean readyToPaint = false;
        boolean leadingRow = false;
        ArrayList<StyledTextRow> rows = new ArrayList<StyledTextRow>();
        for (int i = 0; i < this.textRanges.size(); ++i) {
            TextRange textRange = this.textRanges.get(i);
            StyleRange style = textRange.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.getScriptFontRatio(c, d).floatValue()) : defaultFontSize;
            font = ((Component)c).getFont();
            if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont(font, style.getStyle() == -1 ? font.getStyle() : style.getStyle(), size);
            }
            FontMetrics cfm = ((JComponent)c).getFontMetrics(font);
            if (textRange.text.equals("\n")) {
                if (wrapType == TextWrap.none || preserveLineBreaks) {
                    if (row.isEmpty()) {
                        row.append(" ", null, cfm, -1, -1);
                    }
                    ++i;
                    ++charDisplayed;
                    readyToPaint = true;
                    leadingRow = true;
                }
            } else if (nextRowStartIndex == 0 || nextRowStartIndex < textRange.text.length()) {
                String s = textRange.text.substring(nextRowStartIndex);
                int strWidth = cfm.stringWidth(s);
                int widthLeft = endX - x;
                if (wrapType != TextWrap.none && widthLeft < strWidth && widthLeft >= 0) {
                    if ((maximumRows <= 0 || rowCount < maximumRows) && y + maxRowHeight + Math.max(0, rowGap) <= endY) {
                        int availLength = (int)((long)s.length() * (long)widthLeft / (long)strWidth) + 1;
                        int firstWordOffset = Math.max(0, TextUtils.findFirstWordFromIndex(s, 0));
                        int nextRowStartInSubString = 0;
                        do {
                            String subStringThisRow;
                            if (wrapType == TextWrap.word || wrapType == TextWrap.mixed) {
                                String subString = s.substring(0, Math.max(0, Math.min(availLength, s.length())));
                                int lastInWordEndIndex = TextUtils.findLastRowWordStartIndex(subString.trim());
                                if (lastInWordEndIndex < 0) {
                                    if (wrapType == TextWrap.word) {
                                        if (!row.isEmpty()) break;
                                        nextRowStartInSubString = firstWordOffset + TextUtils.findFirstRowWordEndIndex(s.trim());
                                        break;
                                    }
                                    if (row.isEmpty()) {
                                        lastInWordEndIndex = availLength - 1;
                                        firstWordOffset = 0;
                                    }
                                }
                                nextRowStartInSubString = firstWordOffset + lastInWordEndIndex + 1;
                                subStringThisRow = subString.substring(0, Math.min(nextRowStartInSubString, subString.length()));
                            } else {
                                subStringThisRow = s.substring(0, Math.max(0, Math.min(availLength, s.length())));
                                nextRowStartInSubString = availLength;
                                firstWordOffset = 0;
                            }
                            strWidth = cfm.stringWidth(subStringThisRow);
                            if (strWidth <= widthLeft) continue;
                            --availLength;
                        } while (strWidth > widthLeft && availLength > 0);
                        if (nextRowStartInSubString > 0 && (availLength > 0 || row.isEmpty())) {
                            s = s.substring(0, Math.min(nextRowStartInSubString, s.length()));
                            strWidth = row.append(s, style, cfm, charDisplayed, mnemonicIndex);
                            charDisplayed += s.length();
                            nextRowStartIndex += nextRowStartInSubString;
                        } else if (row.isEmpty()) {
                            ++i;
                            strWidth = row.append(s, style, cfm, charDisplayed, mnemonicIndex);
                            charDisplayed += s.length();
                            nextRowStartIndex = 0;
                        } else {
                            strWidth = 0;
                            nextRowStartIndex = 0;
                        }
                    } else {
                        strWidth = row.append(s, style, cfm, charDisplayed, mnemonicIndex);
                        charDisplayed += s.length();
                        nextRowStartIndex = 0;
                    }
                    readyToPaint = true;
                } else {
                    strWidth = row.append(s, style, cfm, charDisplayed, mnemonicIndex);
                    charDisplayed += s.length();
                    nextRowStartIndex = 0;
                }
                x += strWidth;
            } else {
                nextRowStartIndex = 0;
            }
            if (!readyToPaint || row.isEmpty()) continue;
            rows.add(row);
            ++rowCount;
            row = new StyledTextRow(maxRowHeight, leadingRow);
            readyToPaint = false;
            leadingRow = false;
            x = bounds.x;
            --i;
            if ((y += maxRowHeight + Math.max(0, rowGap)) > endY || maximumRows > 0 && rowCount >= maximumRows) break;
        }
        if (!row.isEmpty()) {
            rows.add(row);
        }
        return rows;
    }

    protected void paintRow(@NotNull C c, @NotNull D d, @NotNull Graphics2D g2d, @NotNull Rectangle bounds, int textX, int textY, @NotNull StyledTextRow row, boolean isLast) {
        Font font = ((Component)c).getFont();
        int defaultFontSize = font.getSize();
        FontMetrics fm = ((JComponent)c).getFontMetrics(font);
        TextWrap wt = this.getWrapType(c, d);
        int ha = this.getAdjustedHorizontalAlignment(c, d);
        int x = textX;
        if (bounds.width > row.width) {
            switch (ha) {
                case 2: {
                    break;
                }
                case 0: {
                    x = (int)((double)x + Math.floor((double)(bounds.width - row.width) / 2.0));
                    break;
                }
                case 4: {
                    x += bounds.width - row.width;
                    break;
                }
                default: {
                    throw new DecorationException("Incorrect horizontal alignment provided: " + ha);
                }
            }
        }
        int charDisplayed = 0;
        for (TextRange textRange : row.fragments) {
            boolean truncated;
            StyleRange style = textRange.getStyleRange();
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.getScriptFontRatio(c, d).floatValue()) : defaultFontSize;
            Font cFont = ((Component)c).getFont();
            if (style != null && (style.getStyle() != -1 && cFont.getStyle() != style.getStyle() || cFont.getSize() != size)) {
                cFont = FontUtils.getCachedDerivedFont(cFont, style.getStyle() == -1 ? cFont.getStyle() : style.getStyle(), size);
            }
            FontMetrics cfm = ((JComponent)c).getFontMetrics(cFont);
            int y = textY;
            String s = textRange.text;
            int strWidth = cfm.stringWidth(s);
            int mnemonicIndex = -1;
            if (row.mnemonic >= 0 && row.mnemonic < charDisplayed + s.length()) {
                mnemonicIndex = row.mnemonic - charDisplayed;
            }
            if (this.isTruncate(c, d)) {
                int availableWidth = bounds.width + bounds.x - x;
                boolean bl = truncated = availableWidth < strWidth && (wt == TextWrap.none || wt == TextWrap.word || isLast);
                if (truncated) {
                    s = SwingUtilities.layoutCompoundLabel(cfm, s, null, 0, ha, 0, 0, new Rectangle(x, y, availableWidth, bounds.height), new Rectangle(), new Rectangle(), 0);
                }
            } else {
                truncated = false;
            }
            g2d.setFont(cFont);
            if (style != null) {
                if (style.isSuperscript()) {
                    y -= fm.getHeight() - cfm.getHeight();
                } else if (style.isSubscript()) {
                    y += fm.getDescent() - cfm.getDescent();
                }
            }
            if (style != null && style.getBackground() != null) {
                g2d.setPaint(style.getBackground());
                g2d.fillRect(x, y - cfm.getAscent(), strWidth, cfm.getAscent() + cfm.getDescent());
            }
            boolean useStyleForeground = style != null && !this.isIgnoreColorSettings(c, d) && style.getForeground() != null;
            Color textColor = useStyleForeground ? style.getForeground() : this.getColor(c, d);
            g2d.setPaint(textColor);
            this.paintStyledTextFragment(c, d, g2d, s, x, y, mnemonicIndex, cfm, style, strWidth);
            if (truncated) break;
            x += strWidth;
            charDisplayed += s.length();
        }
    }

    @NotNull
    protected Pair<Integer, Integer> getFontSize(@NotNull C c, @NotNull D d) {
        Font font = ((Component)c).getFont();
        int defaultFontSize = font.getSize();
        FontMetrics fm = ((JComponent)c).getFontMetrics(font);
        int maxHeight = fm.getHeight();
        int maxAscent = fm.getAscent();
        for (TextRange textRange : this.textRanges) {
            StyleRange style = textRange.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.getScriptFontRatio(c, d).floatValue()) : defaultFontSize;
            Font cFont = font;
            if (style == null || (style.getStyle() == -1 || cFont.getStyle() == style.getStyle()) && cFont.getSize() == size) continue;
            cFont = FontUtils.getCachedDerivedFont(cFont, style.getStyle() == -1 ? cFont.getStyle() : style.getStyle(), size);
            FontMetrics fm2 = ((JComponent)c).getFontMetrics(cFont);
            maxHeight = Math.max(maxHeight, fm2.getHeight());
            maxAscent = Math.max(maxAscent, fm2.getAscent());
        }
        return new Pair<Integer, Integer>(maxAscent, maxHeight);
    }

    protected void paintStyledTextFragment(@NotNull C c, @NotNull D d, @NotNull Graphics2D g2d, @NotNull String s, int x, int y, int mnemonicIndex, @NotNull FontMetrics fm, @Nullable StyleRange style, int strWidth) {
        RenderingHints rh = g2d.getRenderingHints();
        this.paintTextFragment(c, d, g2d, s, x, y, mnemonicIndex);
        if (style != null) {
            int lineY;
            if (style.isStrikeThrough()) {
                lineY = y + (fm.getDescent() - fm.getAscent()) / 2;
                g2d.drawLine(x, lineY, x + strWidth - 1, lineY);
            }
            if (style.isDoubleStrikeThrough()) {
                lineY = y + (fm.getDescent() - fm.getAscent()) / 2;
                g2d.drawLine(x, lineY - 1, x + strWidth - 1, lineY - 1);
                g2d.drawLine(x, lineY + 1, x + strWidth - 1, lineY + 1);
            }
            if (style.isUnderlined()) {
                lineY = y + 1;
                g2d.drawLine(x, lineY, x + strWidth - 1, lineY);
            }
            if (style.isWaved()) {
                Paint op = GraphicsUtils.setupPaint(g2d, Color.RED);
                int waveY = y + 1;
                for (int waveX = x; waveX < x + strWidth; waveX += 4) {
                    if (waveX + 2 <= x + strWidth - 1) {
                        g2d.drawLine(waveX, waveY, waveX + 1, waveY);
                    }
                    if (waveX + 4 > x + strWidth - 1) continue;
                    g2d.drawLine(waveX + 2, waveY + 1, waveX + 3, waveY + 1);
                }
                GraphicsUtils.restorePaint(g2d, op);
            }
        }
        g2d.setRenderingHints(rh);
    }

    @Override
    @NotNull
    protected Dimension getPreferredTextSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        int maximumTextWidth = this.getMaximumTextWidth(c, d);
        Dimension vSize = this.getPreferredStyledTextSize(c, d, new Dimension(maximumTextWidth, Short.MAX_VALUE));
        available.width = Math.min(available.width, maximumTextWidth);
        Dimension hSize = this.getPreferredStyledTextSize(c, d, available);
        return SwingUtils.maxNonNull(vSize, hSize);
    }

    @NotNull
    protected Dimension getPreferredStyledTextSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        List<StyledTextRow> rows;
        Dimension ps = new Dimension(0, 0);
        if (this.textRanges != null && !(rows = this.layout(c, d, new Rectangle(0, 0, available.width, available.height))).isEmpty()) {
            int rg = Math.max(0, this.getRowGap(c, d));
            ps.height -= rg;
            for (StyledTextRow row : rows) {
                ps.width = Math.max(ps.width, row.width);
                ps.height += row.height + rg;
            }
        }
        return ps;
    }
}

