/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.extended.label.AbstractStyledTextContent;
import com.alee.extended.label.StyleRange;
import com.alee.extended.label.TextWrap;
import com.alee.extended.label.WebStyledLabel;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.ContentPropertyListener;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.JLabel;

@XStreamAlias(value="StyledLabelText")
public class StyledLabelText<C extends WebStyledLabel, D extends IDecoration<C, D>, I extends StyledLabelText<C, D, I>>
extends AbstractStyledTextContent<C, D, I> {
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient ContentPropertyListener<C, D> listener;

    @Override
    public void activate(@NotNull C c, @NotNull D d) {
        super.activate(c, d);
        this.listener = new ContentPropertyListener<C, D>((WebStyledLabel)c, (IDecoration)d){

            @Override
            public void propertyChange(@NotNull C c, @NotNull D d, @NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
                StyledLabelText.this.buildTextRanges(c, d);
                ((Component)c).repaint();
            }
        };
        ((Container)c).addPropertyChangeListener("styleRanges", this.listener);
    }

    @Override
    public void deactivate(@NotNull C c, @NotNull D d) {
        ((Component)c).removePropertyChangeListener("styleRanges", this.listener);
        this.listener = null;
        super.deactivate(c, d);
    }

    @Override
    @NotNull
    protected List<StyleRange> getStyleRanges(@NotNull C c, @NotNull D d) {
        return ((WebStyledLabel)c).getStyleRanges();
    }

    @Override
    @NotNull
    protected TextWrap getWrapType(@NotNull C c, @NotNull D d) {
        return ((WebStyledLabel)c).getWrap();
    }

    @Override
    protected int getMaximumRows(@NotNull C c, @NotNull D d) {
        return ((WebStyledLabel)c).getMaximumRows();
    }

    @Override
    @Nullable
    protected String getText(@NotNull C c, @NotNull D d) {
        return ((JLabel)c).getText();
    }

    @Override
    protected int getMnemonicIndex(@NotNull C c, @NotNull D d) {
        return ((JLabel)c).getDisplayedMnemonicIndex();
    }

    @Override
    protected int getHorizontalAlignment(@NotNull C c, @NotNull D d) {
        return this.halign != null ? this.halign.intValue() : ((WebStyledLabel)c).getHorizontalTextAlignment();
    }

    @Override
    protected int getVerticalAlignment(@NotNull C c, @NotNull D d) {
        return this.valign != null ? this.valign.intValue() : ((WebStyledLabel)c).getVerticalTextAlignment();
    }

    @Override
    protected int getMaximumTextWidth(@NotNull C c, @NotNull D d) {
        return this.maximumTextWidth != null ? this.maximumTextWidth.intValue() : ((WebStyledLabel)c).getMaximumTextWidth();
    }
}

