/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.merge.Merge;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.extended.label.ITextRanges;
import com.alee.extended.label.StyleRange;
import com.alee.extended.label.StyleRangeComparator;
import com.alee.extended.label.TextRange;
import com.alee.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TextRanges
implements ITextRanges {
    protected static final Comparator<StyleRange> styleRangeComparator = new StyleRangeComparator();
    protected static final List<String> specialParts = CollectionUtils.asList("\r\n", "\n", "\r");
    @Nullable
    protected final String plainText;
    @NotNull
    protected final List<StyleRange> styleRanges;
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient List<TextRange> textRanges;

    public TextRanges(@Nullable String plainText, @NotNull List<StyleRange> styleRanges) {
        this.plainText = plainText;
        this.styleRanges = styleRanges;
    }

    @Override
    @NotNull
    public List<TextRange> getTextRanges() {
        if (this.textRanges == null) {
            int length;
            this.textRanges = new ArrayList<TextRange>((int)((double)this.styleRanges.size() * 1.4 + 1.0));
            Collections.sort(this.styleRanges, styleRangeComparator);
            if (this.plainText != null && (length = this.plainText.length()) > 0) {
                int start2 = 0;
                while (start2 < this.plainText.length()) {
                    int end = this.plainText.length();
                    for (String specialPart : specialParts) {
                        int partEnd;
                        int partStart = this.plainText.indexOf(specialPart, start2);
                        if (partStart == -1 || (partEnd = partStart + specialPart.length()) <= start2) continue;
                        end = Math.min(end, partStart > start2 ? partStart : partEnd);
                    }
                    for (StyleRange style : this.styleRanges) {
                        int styleStart = style.getStartIndex();
                        int styleEnd = styleStart + style.getLength();
                        if (styleEnd <= start2) continue;
                        end = Math.min(end, styleStart > start2 ? styleStart : styleEnd);
                    }
                    String part = this.plainText.substring(start2, end);
                    StyleRange styleRange = null;
                    if (!specialParts.contains(part)) {
                        for (StyleRange style : this.styleRanges) {
                            int styleStart = style.getStartIndex();
                            int styleEnd = styleStart + style.getLength();
                            if (Math.max(styleStart, start2) >= Math.min(styleEnd, end)) continue;
                            styleRange = (StyleRange)Merge.deep().merge(styleRange, style);
                        }
                    }
                    styleRange = styleRange != null ? new StyleRange(styleRange, start2, end - start2) : null;
                    this.textRanges.add(new TextRange(part, styleRange));
                    start2 = end;
                }
            }
        }
        return this.textRanges;
    }
}

