/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.extended.language.DictionariesTree;
import com.alee.laf.text.WebTextField;
import com.alee.laf.tree.WebTreeCellEditor;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Value;
import java.awt.Component;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class DictionariesTreeEditor
extends WebTreeCellEditor {
    private final DictionariesTree tree;
    private DefaultMutableTreeNode lastValue = null;

    public DictionariesTreeEditor(DictionariesTree tree) {
        this.tree = tree;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        WebTextField editor = (WebTextField)super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        this.lastValue = (DefaultMutableTreeNode)value;
        Object val = this.lastValue.getUserObject();
        if (val instanceof Dictionary) {
            editor.setText(((Dictionary)val).getPrefix());
        } else if (val instanceof Record) {
            editor.setText(((Record)val).getKey());
        } else if (val instanceof Value) {
            editor.setText(((Value)val).getLocale().getLanguage());
        } else if (val instanceof Text) {
            editor.setText(((Text)val).getText(new Object[0]));
        }
        return editor;
    }

    @Override
    public Object getCellEditorValue() {
        String editorValue = (String)super.getCellEditorValue();
        Object val = this.lastValue.getUserObject();
        if (val instanceof Dictionary) {
            ((Dictionary)val).setPrefix(editorValue);
        } else if (val instanceof Record) {
            ((Record)val).setKey(editorValue);
        } else if (val instanceof Value) {
            ((Value)val).setLocale(new Locale(editorValue));
        } else if (val instanceof Text) {
            ((Text)val).setText(editorValue);
        }
        return val;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        Object value = this.tree.getSelectedValue();
        return value != null && (value instanceof Dictionary || value instanceof Record || value instanceof Value || value instanceof Text) && super.isCellEditable(event);
    }
}

