/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.api.annotations.NotNull;
import com.alee.laf.combobox.WebComboBoxModel;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.Dictionary;
import com.alee.utils.CollectionUtils;
import com.alee.utils.collection.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class LanguageChooserModel
extends WebComboBoxModel<Locale>
implements LanguageListener,
DictionaryListener {
    protected List<Locale> locales;

    public LanguageChooserModel() {
        this((Collection<Locale>)new ImmutableList<Locale>(new Locale[0]));
    }

    public LanguageChooserModel(Locale ... locales) {
        this((Collection<Locale>)new ImmutableList<Locale>(locales));
    }

    public LanguageChooserModel(Collection<Locale> locales) {
        this.locales = new ImmutableList<Locale>(locales);
        this.updateLocales();
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public void setLocales(Locale ... locales) {
        this.locales = new ImmutableList<Locale>(locales);
        this.updateLocales();
    }

    public void setLocales(Collection<Locale> locales) {
        this.locales = new ImmutableList<Locale>(locales);
        this.updateLocales();
    }

    protected void updateLocales() {
        List<Locale> data;
        if (CollectionUtils.notEmpty(this.locales)) {
            data = LanguageManager.getSupportedLocales(this.locales);
        } else {
            data = new ArrayList<Locale>(LanguageManager.getSupportedLocales());
            Locale systemLocale = LanguageUtils.getSystemLocale();
            if (LanguageManager.isSuportedLocale(systemLocale) && !data.contains(systemLocale)) {
                data.add(0, systemLocale);
            }
        }
        this.setAll(data);
        this.setSelectedItem(LanguageManager.getLocale());
    }

    @Override
    public void languageChanged(@NotNull Language oldLanguage, @NotNull Language newLanguage) {
        this.updateLocales();
    }

    @Override
    public void dictionaryAdded(@NotNull Dictionary dictionary) {
        this.updateLocales();
    }

    @Override
    public void dictionaryRemoved(@NotNull Dictionary dictionary) {
        this.updateLocales();
    }

    @Override
    public void dictionariesCleared() {
        this.updateLocales();
    }
}

