/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.utils.SwingUtils;
import com.alee.utils.collection.ImmutableList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingConstants;

public class AlignLayout
extends AbstractLayoutManager
implements SwingConstants {
    @NotNull
    public static final List<Integer> horizontals = new ImmutableList<Integer>(2, 0, 4);
    @NotNull
    public static final List<Integer> verticals = new ImmutableList<Integer>(1, 0, 3);
    @NotNull
    public static final String SEPARATOR = ",";
    @NotNull
    protected final Map<Component, String> constraints = new HashMap<Component, String>();
    protected int hgap = 0;
    protected int vgap = 0;
    protected boolean hfill = false;
    protected boolean vfill = false;

    public AlignLayout() {
        this(0, 0, false, false);
    }

    public AlignLayout(int hgap, int vgap) {
        this(hgap, vgap, false, false);
    }

    public AlignLayout(int hgap, int vgap, boolean hfill, boolean vfill) {
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public boolean isHfill() {
        return this.hfill;
    }

    public void setHfill(boolean hfill) {
        this.hfill = hfill;
    }

    public boolean isVfill() {
        return this.vfill;
    }

    public void setVfill(boolean vfill) {
        this.vfill = vfill;
    }

    @Override
    public void addComponent(@NotNull Component component2, @Nullable Object constraints) {
        String align = (String)constraints;
        if (align != null && !align.trim().equals("")) {
            try {
                int valign;
                int halign = this.getHalign(align);
                if (!horizontals.contains(halign)) {
                    this.illegalArgument();
                }
                if (!verticals.contains(valign = this.getValign(align))) {
                    this.illegalArgument();
                }
            }
            catch (Exception ex) {
                this.illegalArgument();
            }
        } else {
            align = "0,0";
        }
        this.constraints.put(component2, align);
    }

    @Override
    public void removeComponent(@NotNull Component component2) {
        this.constraints.remove(component2);
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        Insets insets = container.getInsets();
        int cw = container.getWidth() - insets.left - insets.right;
        int ch = container.getHeight() - insets.top - insets.bottom;
        for (Component component2 : container.getComponents()) {
            int y;
            int x;
            String align = this.constraints.get(component2);
            int halign = this.getHalign(align);
            int valign = this.getValign(align);
            Dimension ps = component2.getPreferredSize();
            ps.width = Math.min(ps.width, cw);
            ps.height = Math.min(ps.height, ch);
            if (this.isHfill()) {
                x = insets.left;
            } else if (halign == 2) {
                x = insets.left;
            } else if (halign == 0) {
                x = insets.left + cw / 2 - Math.min(ps.width / 2, cw / 2);
            } else if (halign == 4) {
                x = container.getWidth() - Math.min(ps.width, cw) - insets.right;
            } else {
                throw new IllegalArgumentException("Unknown horizontal alignment: " + halign);
            }
            if (this.isVfill()) {
                y = insets.top;
            } else if (valign == 1) {
                y = insets.top;
            } else if (valign == 0) {
                y = insets.top + ch / 2 - Math.min(ps.height / 2, ch / 2);
            } else if (valign == 3) {
                y = container.getHeight() - Math.min(ps.height, ch) - insets.bottom;
            } else {
                throw new IllegalArgumentException("Unknown vertical alignment: " + valign);
            }
            int width = this.isHfill() ? cw : Math.min(ps.width, cw);
            int height = this.isVfill() ? ch : Math.min(ps.height, ch);
            component2.setBounds(x, y, width, height);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Dimension ps;
        if (container.getComponentCount() > 1) {
            HashMap<Integer, Integer> widths = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> heights = new HashMap<Integer, Integer>();
            if (!this.isHfill() || !this.isVfill()) {
                for (int halign : horizontals) {
                    for (int valign : verticals) {
                        Dimension size = this.getAreaSize(container, halign, valign);
                        if (size == null) continue;
                        if (!this.isHfill()) {
                            int width = widths.containsKey(halign) ? (Integer)widths.get(halign) : 0;
                            widths.put(halign, Math.max(width, size.width));
                        }
                        if (this.isVfill()) continue;
                        int height = widths.containsKey(valign) ? (Integer)widths.get(valign) : 0;
                        heights.put(valign, Math.max(height, size.height));
                    }
                }
            }
            ps = new Dimension(0, 0);
            if (this.isHfill()) {
                ps.width = SwingUtils.maxPreferredWidth(container.getComponents());
            } else {
                for (Integer width : widths.values()) {
                    ps.width = ps.width + (ps.width > 0 ? this.getHgap() + width : width);
                }
            }
            if (this.isVfill()) {
                ps.height = SwingUtils.maxPreferredHeight(container.getComponents());
            } else {
                for (Integer height : heights.values()) {
                    ps.height = ps.height + (ps.height > 0 ? this.getVgap() + height : height);
                }
            }
        } else {
            ps = container.getComponentCount() == 1 ? container.getComponent(0).getPreferredSize() : new Dimension(0, 0);
        }
        Insets insets = container.getInsets();
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }

    @Nullable
    protected Dimension getAreaSize(@NotNull Container container, int halign, int valign) {
        Dimension size = new Dimension(0, 0);
        for (Component component2 : container.getComponents()) {
            String align = this.constraints.get(component2);
            if (this.getHalign(align) != halign || this.getValign(align) != valign) continue;
            Dimension preferredSize = component2.getPreferredSize();
            size.width = Math.max(size.width, preferredSize.width);
            size.height = Math.max(size.height, preferredSize.height);
        }
        return size.width > 0 || size.height > 0 ? size : null;
    }

    protected int getHalign(@Nullable String constraints) {
        return constraints == null ? 0 : Integer.parseInt(constraints.substring(0, constraints.indexOf(SEPARATOR)));
    }

    protected int getValign(@Nullable String constraints) {
        return constraints == null ? 0 : Integer.parseInt(constraints.substring(constraints.indexOf(SEPARATOR) + SEPARATOR.length()));
    }

    protected void illegalArgument() {
        throw new IllegalArgumentException("Cannot add to layout: please specify proper alignment constraints");
    }
}

