/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;

public class MultiLayout
extends AbstractLayoutManager {
    protected List<LayoutManager> layoutManagers = new ArrayList<LayoutManager>(2);

    public List<LayoutManager> getLayoutManagers() {
        return this.layoutManagers;
    }

    public void setLayoutManagers(List<LayoutManager> layoutManagers) {
        this.layoutManagers = layoutManagers;
    }

    public void addLayoutManager(LayoutManager layoutManager) {
        this.layoutManagers.add(layoutManager);
    }

    public void removeLayoutManager(LayoutManager layoutManager) {
        this.layoutManagers.remove(layoutManager);
    }

    @Override
    public void addComponent(@NotNull Component component2, @Nullable Object constraints) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            if (layoutManager instanceof LayoutManager2) {
                LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
                layoutManager2.addLayoutComponent(component2, constraints);
                continue;
            }
            layoutManager.addLayoutComponent(constraints != null ? constraints.toString() : null, component2);
        }
    }

    @Override
    public void removeComponent(@NotNull Component component2) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            layoutManager.removeLayoutComponent(component2);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Dimension ps = new Dimension(0, 0);
        for (LayoutManager layoutManager : this.layoutManagers) {
            ps = SwingUtils.max(ps, layoutManager.preferredLayoutSize(container));
        }
        return ps;
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        Dimension ms = new Dimension(0, 0);
        for (LayoutManager layoutManager : this.layoutManagers) {
            ms = SwingUtils.max(ms, layoutManager.minimumLayoutSize(container));
        }
        return ms;
    }

    @Override
    @NotNull
    public Dimension maximumLayoutSize(@NotNull Container container) {
        Dimension ms = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (LayoutManager layoutManager : this.layoutManagers) {
            if (!(layoutManager instanceof LayoutManager2)) continue;
            ms = SwingUtils.min(ms, ((LayoutManager2)layoutManager).maximumLayoutSize(container));
        }
        return ms;
    }

    @Override
    public void invalidateLayout(@NotNull Container container) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            if (!(layoutManager instanceof LayoutManager2)) continue;
            ((LayoutManager2)layoutManager).invalidateLayout(container);
        }
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        for (LayoutManager layoutManager : this.layoutManagers) {
            layoutManager.layoutContainer(container);
        }
    }
}

