/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.lazy;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.lazy.DataLoadAdapter;
import com.alee.extended.lazy.DataLoadProgress;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.progressbar.WebProgressBar;
import com.alee.utils.swing.LoadIconType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;

public class LazyProgressOverlay<D>
extends WebPanel {
    @NotNull
    protected final DataLoadProgress<D> progress;
    protected WebLabel indeterminate;
    protected WebProgressBar determinate;

    public LazyProgressOverlay(@NotNull DataLoadProgress<D> progress) {
        super((LayoutManager)new BorderLayout(), new Component[0]);
        this.progress = progress;
        this.updateDisplayedComponent();
        progress.addListener(new DataLoadAdapter(){

            @Override
            public void totalChanged(int total) {
                LazyProgressOverlay.this.updateDisplayedComponent();
                if (LazyProgressOverlay.this.isDeterminate()) {
                    LazyProgressOverlay.this.determinate.setMaximum(total);
                }
            }

            @Override
            public void progressChanged(int progress, @Nullable Object[] data) {
                LazyProgressOverlay.this.updateDisplayedComponent();
                if (LazyProgressOverlay.this.isDeterminate()) {
                    LazyProgressOverlay.this.determinate.setValue(progress);
                    if (data != null && data.length > 0 && data[0] instanceof String) {
                        LazyProgressOverlay.this.determinate.setStringPainted(true);
                        LazyProgressOverlay.this.determinate.setString((String)data[0]);
                    } else {
                        LazyProgressOverlay.this.determinate.setStringPainted(false);
                        LazyProgressOverlay.this.determinate.setString(null);
                    }
                } else if (data != null && data.length > 0 && data[0] instanceof String) {
                    LazyProgressOverlay.this.indeterminate.setText((String)data[0]);
                } else {
                    LazyProgressOverlay.this.indeterminate.setText(null);
                }
            }
        });
    }

    protected boolean isDeterminate() {
        return this.progress.getTotal() != -1;
    }

    protected void updateDisplayedComponent() {
        if (this.isDeterminate()) {
            if (this.indeterminate != null && this.indeterminate.getParent() != null) {
                this.remove((Component)this.indeterminate);
            }
            if (this.determinate == null || this.determinate.getParent() == null) {
                this.add((Component)this.getDeterminateComponent(), (Object)"Center");
                this.revalidate();
                this.repaint();
            }
        } else {
            if (this.determinate != null && this.determinate.getParent() != null) {
                this.remove((Component)this.determinate);
            }
            if (this.indeterminate == null || this.indeterminate.getParent() == null) {
                this.add((Component)this.getIndeterminateComponent(), (Object)"Center");
                this.revalidate();
                this.repaint();
            }
        }
    }

    @NotNull
    protected WebLabel getIndeterminateComponent() {
        if (this.indeterminate == null) {
            this.indeterminate = new WebLabel(LoadIconType.roller.getIcon(), 0);
        }
        return this.indeterminate;
    }

    @NotNull
    protected WebProgressBar getDeterminateComponent() {
        if (this.determinate == null) {
            this.determinate = new WebProgressBar(0, this.progress.getTotal());
            this.determinate.setValue(this.progress.getProgress());
        }
        return this.determinate;
    }
}

