/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.link;

import com.alee.api.annotations.NotNull;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.link.LinkAction;
import com.alee.extended.link.WLinkUI;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CollectionUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;

public class WebLink
extends WebStyledLabel {
    public static final String ACTION_PROPERTY = "action";
    public static final String VISITABLE_PROPERTY = "visitable";
    public static final String VISITED_PROPERTY = "visited";
    protected boolean visitable;
    protected boolean visited;

    public WebLink() {
        this(StyleId.auto);
    }

    public WebLink(Icon icon) {
        this(StyleId.auto, icon);
    }

    public WebLink(String text) {
        this(StyleId.auto, text);
    }

    public WebLink(Icon icon, String text) {
        this(StyleId.auto, icon, text);
    }

    public WebLink(LinkAction action) {
        this(StyleId.auto, action);
    }

    public WebLink(Icon icon, LinkAction action) {
        this(StyleId.auto, icon, action);
    }

    public WebLink(String text, LinkAction action) {
        this(StyleId.auto, text, action);
    }

    public WebLink(Icon icon, String text, LinkAction action) {
        this(StyleId.auto, icon, text, action);
    }

    public WebLink(StyleId id) {
        this(id, null, null, null);
    }

    public WebLink(StyleId id, Icon icon) {
        this(id, icon, null, null);
    }

    public WebLink(StyleId id, String text) {
        this(id, null, text, null);
    }

    public WebLink(StyleId id, Icon icon, String text) {
        this(id, icon, text, null);
    }

    public WebLink(StyleId id, LinkAction action) {
        this(id, null, null, action);
    }

    public WebLink(StyleId id, Icon icon, LinkAction action) {
        this(id, icon, null, action);
    }

    public WebLink(StyleId id, String text, LinkAction action) {
        this(id, null, text, action);
    }

    public WebLink(StyleId id, Icon icon, String text, LinkAction action) {
        super(id, text, icon);
        this.addAction(action);
    }

    public boolean isVisitable() {
        return this.visitable;
    }

    public void setVisitable(boolean visitable) {
        boolean old = this.visitable;
        this.visitable = visitable;
        this.firePropertyChange(VISITABLE_PROPERTY, old, visitable);
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        boolean old = this.visited;
        this.visited = visited;
        this.firePropertyChange(VISITED_PROPERTY, old, visited);
    }

    public void addAction(LinkAction action) {
        if (action != null) {
            if (this.getIcon() == null && this.getText() == null) {
                String text;
                Icon icon = action.getIcon();
                if (icon != null) {
                    this.setIcon(icon);
                }
                if ((text = action.getText()) != null) {
                    this.setText(UILanguageManager.getInitialText(text, new Object[0]));
                    UILanguageManager.registerInitialLanguage(this, text, new Object[0]);
                }
            }
            this.listenerList.add(LinkAction.class, action);
            this.firePropertyChange(ACTION_PROPERTY, null, action);
        }
    }

    public void removeAction(LinkAction action) {
        if (action != null) {
            this.listenerList.remove(LinkAction.class, action);
            this.firePropertyChange(ACTION_PROPERTY, action, null);
        }
    }

    public List<LinkAction> getActions() {
        return CollectionUtils.asList(this.listenerList.getListeners(LinkAction.class));
    }

    public void fireLinkExecuted() {
        ActionEvent event = new ActionEvent(this, 0, "Link clicked", System.currentTimeMillis(), 0);
        for (LinkAction action : (LinkAction[])this.listenerList.getListeners(LinkAction.class)) {
            action.linkExecuted(event);
        }
        this.fireActionPerformed(event);
        this.setVisited(true);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.link;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void fireActionPerformed(ActionEvent event) {
        for (ActionListener listener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            listener.actionPerformed(event);
        }
    }

    @Override
    public WLinkUI getUI() {
        return (WLinkUI)this.ui;
    }

    public void setUI(WLinkUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

