/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.list.FileElement;
import com.alee.laf.list.WebListModel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileListModel
extends WebListModel<FileElement> {
    private final Object elementsCacheLock = new Object();
    private final Map<String, FileElement> elementsCache = new HashMap<String, FileElement>();

    public FileListModel() {
    }

    public FileListModel(String directoryPath) {
        this.setData(directoryPath);
    }

    public FileListModel(File directory) {
        this.setData(directory);
    }

    public FileListModel(File[] data) {
        this.setData(data);
    }

    public FileListModel(List<File> data) {
        this.setData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        Object object = this.elementsCacheLock;
        synchronized (object) {
            for (Map.Entry<String, FileElement> entry : this.elementsCache.entrySet()) {
                entry.getValue().setFile(null);
            }
            this.elementsCache.clear();
        }
    }

    public FileElement getElement(File file) {
        return this.getElement(file != null ? file.getAbsolutePath() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileElement getElement(String path) {
        Object object = this.elementsCacheLock;
        synchronized (object) {
            return this.elementsCache.get(path);
        }
    }

    public void setData(String directoryPath) {
        this.clearCache();
        this.setAll(this.toElementsList(this.getData(new File(directoryPath))));
    }

    public void setData(File directory) {
        this.clearCache();
        this.setAll(this.toElementsList(this.getData(directory)));
    }

    public void setData(File[] data) {
        this.clearCache();
        this.setAll(this.toElementsList(data));
    }

    public void setData(List<File> data) {
        this.clearCache();
        this.setAll(this.toElementsList(data));
    }

    protected File[] getData(File directory) {
        if (directory != null) {
            return directory.listFiles();
        }
        return new File[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FileElement> toElementsList(File[] data) {
        ArrayList<FileElement> elements = new ArrayList<FileElement>(data != null ? data.length : 0);
        if (data != null) {
            for (File file : data) {
                FileElement element = new FileElement(file);
                elements.add(element);
                Object object = this.elementsCacheLock;
                synchronized (object) {
                    this.elementsCache.put(file.getAbsolutePath(), element);
                }
            }
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FileElement> toElementsList(List<File> data) {
        ArrayList<FileElement> elements = new ArrayList<FileElement>(data != null ? data.size() : 0);
        if (data != null) {
            for (File file : data) {
                FileElement element = new FileElement(file);
                elements.add(element);
                Object object = this.elementsCacheLock;
                synchronized (object) {
                    this.elementsCache.put(file.getAbsolutePath(), element);
                }
            }
        }
        return elements;
    }
}

