/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.resource.FileResource;
import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileThumbnailProvider;
import com.alee.extended.list.WebFileList;
import com.alee.managers.task.TaskManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.ImageUtils;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ThumbnailGenerator
implements Runnable {
    protected static final Map<FileElement, ThumbnailGenerator> generators = new WeakHashMap<FileElement, ThumbnailGenerator>();
    protected static final Object generatorsLock = new Object();
    @NotNull
    protected final WebFileList list;
    @NotNull
    protected final FileElement element;
    @NotNull
    protected final Dimension size;
    protected final boolean disabled;
    protected boolean aborted;

    public ThumbnailGenerator(@NotNull WebFileList list, @NotNull FileElement element, @NotNull Dimension size, boolean disabled) {
        this.list = list;
        this.element = element;
        this.size = size;
        this.disabled = disabled;
        this.aborted = false;
    }

    @NotNull
    public WebFileList getList() {
        return this.list;
    }

    @NotNull
    public FileElement getElement() {
        return this.element;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void abort() {
        this.aborted = true;
    }

    @Override
    public void run() {
        if (!this.aborted) {
            this.createThumbnail(this.element.getFile(), this.list.isGenerateThumbnails());
            if (!this.aborted) {
                CoreSwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThumbnailGenerator.this.list.repaint(ThumbnailGenerator.this.element);
                    }
                });
                this.cleanup();
            } else {
                this.cleanup();
            }
        } else {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Object object = generatorsLock;
        synchronized (object) {
            ThumbnailGenerator generator = generators.get(this.element);
            if (generator == this) {
                Object object2 = this.element.getLock();
                synchronized (object2) {
                    this.element.setThumbnailQueued(false);
                    this.element.setDisabledThumbnailQueued(false);
                }
                generators.remove(this.element);
            }
        }
    }

    protected void createThumbnail(@NotNull File file, boolean preview) {
        FileThumbnailProvider thumbnailProvider = this.list.getThumbnailProvider();
        if (thumbnailProvider != null && thumbnailProvider.accept(file)) {
            Icon thumb;
            Icon icon = thumb = this.element.getEnabledThumbnail() != null ? this.element.getEnabledThumbnail() : thumbnailProvider.provide(file, this.size, preview);
            if (thumb != null) {
                this.applyThumbnail(thumb);
            } else {
                this.createStandardThumbnail(file, preview);
            }
        } else {
            this.createStandardThumbnail(file, preview);
        }
    }

    protected void createStandardThumbnail(@NotNull File file, boolean preview) {
        if (preview && ImageUtils.isImageSupported(file.getName())) {
            Icon thumb;
            Icon icon = thumb = this.element.getEnabledThumbnail() != null ? this.element.getEnabledThumbnail() : this.createThumbnailIcon(file);
            if (thumb != null) {
                this.applyThumbnail(thumb);
            } else {
                this.applyStandardIcon(file);
            }
        } else {
            this.applyStandardIcon(file);
        }
    }

    @Nullable
    protected Icon createThumbnailIcon(@NotNull File file) {
        ImageIcon thumbnail;
        try {
            BufferedImage bufferedImage = ImageUtils.loadBufferedImage(new FileResource(file));
            BufferedImage previewImage = ImageUtils.createImageThumbnail(bufferedImage, Math.min(this.size.width, this.size.height));
            ImageIcon previewIcon = new ImageIcon(previewImage);
            previewIcon.setDescription(previewImage.getWidth() + "x" + previewImage.getHeight());
            thumbnail = previewIcon;
        }
        catch (Exception e) {
            thumbnail = null;
        }
        return thumbnail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyThumbnail(@NotNull Icon thumbnail) {
        if (!this.aborted) {
            Object object = this.element.getLock();
            synchronized (object) {
                if (this.element.isThumbnailQueued()) {
                    this.element.setEnabledThumbnail(thumbnail);
                }
            }
            if (!this.aborted && this.disabled) {
                Icon disabledThumbnail = ImageUtils.createDisabledCopy(thumbnail);
                if (!this.aborted && this.element.isDisabledThumbnailQueued()) {
                    this.element.setDisabledThumbnail(disabledThumbnail);
                }
            }
        }
    }

    protected void applyStandardIcon(@NotNull File file) {
        if (!this.aborted) {
            Icon enabledThumbnail = FileUtils.getStandardFileIcon(file, true, true);
            if (!this.aborted) {
                if (this.element.isThumbnailQueued()) {
                    this.element.setEnabledThumbnail(enabledThumbnail);
                }
                if (!this.aborted && this.disabled) {
                    Icon disabledThumbnail = FileUtils.getStandardFileIcon(file, true, false);
                    if (!this.aborted && this.element.isDisabledThumbnailQueued()) {
                        this.element.setDisabledThumbnail(disabledThumbnail);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueThumbnailLoad(@NotNull WebFileList list, @NotNull FileElement element, @NotNull Dimension size, boolean disabled) {
        Object object = generatorsLock;
        synchronized (object) {
            Object object2 = element.getLock();
            synchronized (object2) {
                if (disabled ? !element.isDisabledThumbnailQueued() && element.getDisabledThumbnail() == null : !element.isThumbnailQueued() && element.getEnabledThumbnail() == null) {
                    element.setThumbnailQueued(true);
                    element.setDisabledThumbnailQueued(disabled);
                    ThumbnailGenerator generator = new ThumbnailGenerator(list, element, size, disabled);
                    generators.put(element, generator);
                    TaskManager.execute("Computation", generator);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abortThumbnailLoad(@NotNull FileElement element) {
        Object object = generatorsLock;
        synchronized (object) {
            ThumbnailGenerator generator = generators.get(element);
            if (generator != null) {
                generator.abort();
            }
            Object object2 = element.getLock();
            synchronized (object2) {
                element.setEnabledThumbnail(null);
                element.setThumbnailQueued(false);
                element.setDisabledThumbnail(null);
                element.setDisabledThumbnailQueued(false);
            }
        }
    }
}

