/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.api.annotations.NotNull;
import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileListModel;
import com.alee.extended.list.FileListViewType;
import com.alee.extended.list.FileThumbnailProvider;
import com.alee.extended.list.ThumbnailGenerator;
import com.alee.extended.list.WebFileListCellEditor;
import com.alee.extended.list.WebFileListCellRenderer;
import com.alee.laf.list.WebList;
import com.alee.laf.list.editor.ListCellEditor;
import com.alee.managers.style.StyleId;
import com.alee.utils.FileUtils;
import com.alee.utils.filefilter.NonHiddenFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

public class WebFileList
extends WebList {
    protected boolean generateThumbnails;
    protected int preferredColumnCount;
    protected int preferredRowCount;
    protected FileListViewType fileListViewType;
    protected FileFilter fileFilter = new NonHiddenFilter();
    protected FileThumbnailProvider thumbnailProvider;
    protected File displayedDirectory = null;

    public WebFileList() {
        super(StyleId.filelist, new FileListModel());
        this.initializeDefaultSettings();
    }

    public WebFileList(String directoryPath) {
        super(StyleId.filelist, new FileListModel(directoryPath));
        this.initializeDefaultSettings();
    }

    public WebFileList(File directory) {
        super(StyleId.filelist, new FileListModel(directory));
        this.initializeDefaultSettings();
    }

    public WebFileList(File[] data) {
        super(StyleId.filelist, new FileListModel(data));
        this.initializeDefaultSettings();
    }

    public WebFileList(List<File> data) {
        super(StyleId.filelist, new FileListModel(data));
        this.initializeDefaultSettings();
    }

    public WebFileList(StyleId id) {
        super(id, new FileListModel());
        this.initializeDefaultSettings();
    }

    public WebFileList(StyleId id, String directoryPath) {
        super(id, new FileListModel(directoryPath));
        this.initializeDefaultSettings();
    }

    public WebFileList(StyleId id, File directory) {
        super(id, new FileListModel(directory));
        this.initializeDefaultSettings();
    }

    public WebFileList(StyleId id, File[] data) {
        super(id, new FileListModel(data));
        this.initializeDefaultSettings();
    }

    public WebFileList(StyleId id, List<File> data) {
        super(id, new FileListModel(data));
        this.initializeDefaultSettings();
    }

    protected void initializeDefaultSettings() {
        this.setVisibleRowCount(-1);
        this.setCellRenderer(new WebFileListCellRenderer(this));
    }

    public WebFileListCellRenderer getWebFileListCellRenderer() throws ClassCastException {
        ListCellRenderer cellRenderer = this.getCellRenderer();
        return cellRenderer instanceof WebFileListCellRenderer ? (WebFileListCellRenderer)cellRenderer : null;
    }

    public FileListModel getFileListModel() throws ClassCastException {
        return (FileListModel)this.getModel();
    }

    @Override
    protected ListCellEditor createDefaultCellEditor() {
        return new WebFileListCellEditor();
    }

    public int getPreferredColumnCount() {
        return this.preferredColumnCount;
    }

    public void setPreferredColumnCount(int preferredColumnCount) {
        this.preferredColumnCount = preferredColumnCount;
        this.getUI().updateListLayout();
    }

    public int getPreferredRowCount() {
        return this.preferredRowCount;
    }

    public void setPreferredRowCount(int preferredRowCount) {
        this.preferredRowCount = preferredRowCount;
        this.getUI().updateListLayout();
    }

    public boolean isGenerateThumbnails() {
        return this.generateThumbnails;
    }

    public void setGenerateThumbnails(boolean generateThumbnails) {
        this.generateThumbnails = generateThumbnails;
    }

    public FileListViewType getFileListViewType() {
        return this.fileListViewType;
    }

    public void setFileListViewType(FileListViewType fileListViewType) {
        this.fileListViewType = fileListViewType;
        WebFileListCellRenderer wr = this.getWebFileListCellRenderer();
        if (wr != null) {
            wr.updateFilesView();
        }
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.reloadFiles();
    }

    public void reloadFiles() {
        this.setDisplayedDirectory(this.getDisplayedDirectory());
    }

    public FileThumbnailProvider getThumbnailProvider() {
        return this.thumbnailProvider;
    }

    public void setThumbnailProvider(FileThumbnailProvider provider) {
        FileThumbnailProvider oldProvider = this.thumbnailProvider;
        this.thumbnailProvider = provider;
        this.abortThumbnailsGeneration(oldProvider);
        this.abortThumbnailsGeneration(provider);
        this.repaint();
    }

    protected void abortThumbnailsGeneration(FileThumbnailProvider provider) {
        if (provider != null) {
            for (FileElement element : this.getFileListModel().getElements()) {
                if (!provider.accept(element.getFile())) continue;
                ThumbnailGenerator.abortThumbnailLoad(element);
            }
        }
    }

    public File getDisplayedDirectory() {
        return this.displayedDirectory;
    }

    public void setDisplayedDirectory(File file) {
        this.stopCellEditing();
        List<File> oldSelection = this.getSelectedFiles();
        File[] files2 = file != null ? FileUtils.sortFiles(file.listFiles(this.fileFilter)) : FileUtils.getDiskRoots();
        this.getFileListModel().setData(files2);
        if (FileUtils.equals(this.displayedDirectory, file)) {
            this.setSelectedFiles(oldSelection);
        }
        this.displayedDirectory = file;
    }

    public List<File> getSelectedFiles() {
        Object[] selectedValues = this.getSelectedValues();
        ArrayList<File> selectedFiles = new ArrayList<File>(selectedValues.length);
        for (Object value : selectedValues) {
            selectedFiles.add(((FileElement)value).getFile());
        }
        return selectedFiles;
    }

    public File getSelectedFile() {
        Object selectedValue = this.getSelectedValue();
        return selectedValue != null ? ((FileElement)selectedValue).getFile() : null;
    }

    public void setSelectedFile(File file) {
        this.setSelectedFile(file, true);
    }

    public void setSelectedFile(File file, boolean shouldScroll) {
        FileElement element = this.getFileListModel().getElement(file);
        if (element != null) {
            this.setSelectedValue(element, shouldScroll);
        } else {
            this.clearSelection();
        }
    }

    public void setSelectedFiles(Collection<File> files2) {
        ArrayList<FileElement> elements = new ArrayList<FileElement>(files2.size());
        for (File file : files2) {
            FileElement element = this.getFileListModel().getElement(file);
            if (element == null) continue;
            elements.add(element);
        }
        this.setSelectedValues(elements);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Insets bi = this.getInsets();
        Dimension oneCell = this.getPreferredCellSize();
        int width = oneCell.width * this.getPreferredColumnCount() + bi.left + bi.right;
        int height = oneCell.height * this.getPreferredRowCount() + bi.top + bi.bottom;
        return new Dimension(width, height);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        Insets bi = this.getInsets();
        ps.width = this.getPreferredCellSize().width * this.getPreferredColumnCount() + bi.left + bi.right;
        return ps;
    }

    protected Dimension getPreferredCellSize() {
        Dimension ps = new Dimension(this.getFixedCellWidth(), this.getFixedCellHeight());
        if (ps.width == -1 || ps.height == -1) {
            Dimension cps = this.getPrototypeCellSize();
            if (cps == null) {
                if (this.getModel().getSize() > 0) {
                    Object v = this.getModel().getElementAt(0);
                    ListCellRenderer renderer = this.getCellRenderer();
                    Component r = renderer.getListCellRendererComponent(this, v, 0, false, false);
                    cps = r.getPreferredSize();
                } else {
                    cps = new Dimension(0, 0);
                }
            }
            if (ps.width == -1) {
                ps.width = cps.width;
            }
            if (ps.height == -1) {
                ps.height = cps.height;
            }
        }
        return ps;
    }

    protected Dimension getPrototypeCellSize() {
        ListCellRenderer renderer = this.getCellRenderer();
        return renderer instanceof JComponent ? ((JComponent)((Object)renderer)).getPreferredSize() : null;
    }
}

