/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileListViewType;
import com.alee.extended.list.ThumbnailGenerator;
import com.alee.extended.list.WebFileList;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.style.BoundsType;
import com.alee.managers.style.StyleId;
import com.alee.utils.FileUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.file.FileDescription;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class WebFileListCellRenderer
extends WebPanel
implements ListCellRenderer {
    protected int gap = 4;
    @NotNull
    protected final WebFileList fileList;
    @NotNull
    protected final WebLabel iconLabel;
    @NotNull
    protected final WebLabel nameLabel;
    @NotNull
    protected final WebLabel sizeLabel;
    @NotNull
    protected final WebLabel descriptionLabel;

    public WebFileListCellRenderer(final @NotNull WebFileList fileList) {
        super(StyleId.filelistCellRenderer.at(fileList));
        this.fileList = fileList;
        this.iconLabel = new WebLabel(StyleId.filelistCellRendererIcon.at(this));
        this.nameLabel = new WebLabel(StyleId.filelistCellRendererName.at(this));
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(0));
        this.descriptionLabel = new WebLabel(StyleId.filelistCellRendererDescription.at(this));
        this.descriptionLabel.setFont(this.descriptionLabel.getFont().deriveFont(0));
        this.sizeLabel = new WebLabel(StyleId.filelistCellRendererSize.at(this));
        this.sizeLabel.setFont(this.sizeLabel.getFont().deriveFont(0));
        this.setLayout(new FileCellLayout());
        this.add((Component)this.iconLabel);
        this.add((Component)this.nameLabel);
        this.add((Component)this.descriptionLabel);
        this.add((Component)this.sizeLabel);
        fileList.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = fileList.isEnabled();
                WebFileListCellRenderer.this.iconLabel.setEnabled(enabled);
                WebFileListCellRenderer.this.nameLabel.setEnabled(enabled);
                WebFileListCellRenderer.this.descriptionLabel.setEnabled(enabled);
                WebFileListCellRenderer.this.sizeLabel.setEnabled(enabled);
            }
        });
        fileList.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComponentOrientation orientation = fileList.getComponentOrientation();
                WebFileListCellRenderer.this.nameLabel.setComponentOrientation(orientation);
                WebFileListCellRenderer.this.descriptionLabel.setComponentOrientation(orientation);
                WebFileListCellRenderer.this.sizeLabel.setComponentOrientation(orientation);
            }
        });
        this.updateFilesView();
    }

    @NotNull
    public Rectangle getDescriptionBounds() {
        return ((FileCellLayout)this.getLayout()).getDescriptionBounds();
    }

    public void updateFilesView() {
        this.nameLabel.setHorizontalAlignment(this.isTilesView() ? 10 : 0);
    }

    @NotNull
    public JLabel getIconLabel() {
        return this.iconLabel;
    }

    @NotNull
    public JLabel getNameLabel() {
        return this.nameLabel;
    }

    @NotNull
    public JLabel getSizeLabel() {
        return this.sizeLabel;
    }

    @NotNull
    public JLabel getDescriptionLabel() {
        return this.descriptionLabel;
    }

    @NotNull
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        FileElement element = (FileElement)value;
        File file = element.getFile();
        this.setStyleId(this.getStyleId(list, value, index, isSelected, cellHasFocus));
        String imageSize = null;
        if (this.iconLabel.isEnabled()) {
            ThumbnailGenerator.queueThumbnailLoad(this.fileList, element, BoundsType.padding.bounds(this.iconLabel).getSize(), false);
            Icon thumbnail = element.getEnabledThumbnail();
            this.iconLabel.setIcon(thumbnail);
            if (thumbnail != null && thumbnail instanceof ImageIcon) {
                imageSize = ((ImageIcon)thumbnail).getDescription();
            } else if (thumbnail != null) {
                imageSize = thumbnail.getIconWidth() + "x" + thumbnail.getIconHeight();
            }
        } else {
            ThumbnailGenerator.queueThumbnailLoad(this.fileList, element, BoundsType.padding.bounds(this.iconLabel).getSize(), true);
            this.iconLabel.setDisabledIcon(element.getDisabledThumbnail());
        }
        if (this.fileList.getEditedCell() != index) {
            FileDescription fileDescription = FileUtils.getFileDescription(file, imageSize);
            String name = fileDescription.getName();
            this.nameLabel.setText(TextUtils.notEmpty(name) ? name : " ");
            if (this.isTilesView()) {
                this.descriptionLabel.setText(fileDescription.getDescription());
                if (fileDescription.getSize() != null) {
                    this.sizeLabel.setText(fileDescription.getSize());
                } else {
                    this.sizeLabel.setText(null);
                }
            } else {
                this.descriptionLabel.setText(null);
                this.sizeLabel.setText(null);
            }
        } else {
            this.nameLabel.setText(null);
            this.descriptionLabel.setText(null);
            this.sizeLabel.setText(null);
        }
        return this;
    }

    @NotNull
    protected StyleId getStyleId(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        return this.isTilesView() ? StyleId.filelistTileCellRenderer.at(list) : StyleId.filelistIconCellRenderer.at(list);
    }

    protected boolean isTilesView() {
        return this.fileList.getFileListViewType().equals((Object)FileListViewType.tiles);
    }

    protected class FileCellLayout
    extends AbstractLayoutManager {
        protected FileCellLayout() {
        }

        @Override
        public void layoutContainer(@NotNull Container container) {
            Dimension cellSize = WebFileListCellRenderer.this.getSize();
            Dimension iconSize = WebFileListCellRenderer.this.iconLabel.getPreferredSize();
            boolean ltr = WebFileListCellRenderer.this.fileList.getComponentOrientation().isLeftToRight();
            Insets i = WebFileListCellRenderer.this.getInsets();
            boolean tilesView = WebFileListCellRenderer.this.isTilesView();
            boolean hasDescription = tilesView && TextUtils.notEmpty(WebFileListCellRenderer.this.descriptionLabel.getText());
            boolean hasFileSize = tilesView && TextUtils.notEmpty(WebFileListCellRenderer.this.sizeLabel.getText());
            WebFileListCellRenderer.this.descriptionLabel.setVisible(hasDescription);
            WebFileListCellRenderer.this.sizeLabel.setVisible(hasFileSize);
            if (tilesView) {
                WebFileListCellRenderer.this.iconLabel.setBounds(ltr ? i.left : cellSize.width - i.right - iconSize.width, i.top, iconSize.width, iconSize.height);
                Dimension nps = WebFileListCellRenderer.this.nameLabel.getPreferredSize();
                Dimension dps = hasDescription ? WebFileListCellRenderer.this.descriptionLabel.getPreferredSize() : new Dimension(0, 0);
                Dimension sps = hasFileSize ? WebFileListCellRenderer.this.sizeLabel.getPreferredSize() : new Dimension(0, 0);
                int dh = nps.height + (hasDescription ? WebFileListCellRenderer.this.gap + dps.height : 0) + (hasFileSize ? WebFileListCellRenderer.this.gap + sps.height : 0);
                int dx = ltr ? i.left + iconSize.width + WebFileListCellRenderer.this.gap : i.left;
                int dw = cellSize.width - i.left - i.right - iconSize.width - WebFileListCellRenderer.this.gap;
                int dy = i.top + (cellSize.height - i.top - i.bottom) / 2 - dh / 2;
                WebFileListCellRenderer.this.nameLabel.setBounds(dx, dy, dw, nps.height);
                dy += nps.height + WebFileListCellRenderer.this.gap;
                if (hasDescription) {
                    WebFileListCellRenderer.this.descriptionLabel.setBounds(dx, dy, dw, dps.height);
                    dy += dps.height + WebFileListCellRenderer.this.gap;
                }
                if (hasFileSize) {
                    WebFileListCellRenderer.this.sizeLabel.setBounds(dx, dy, dw, sps.height);
                }
            } else {
                int cw = cellSize.width - i.left - i.right;
                WebFileListCellRenderer.this.iconLabel.setBounds(i.left + cw / 2 - 27, i.top, iconSize.width, iconSize.height);
                int ny = i.top + iconSize.height + WebFileListCellRenderer.this.gap;
                WebFileListCellRenderer.this.nameLabel.setBounds(i.left, ny, cw, cellSize.height - ny - i.bottom);
            }
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container container) {
            Dimension ps;
            Insets i = container.getInsets();
            Dimension is = WebFileListCellRenderer.this.iconLabel.getPreferredSize();
            Dimension ns = WebFileListCellRenderer.this.nameLabel.getPreferredSize();
            if (WebFileListCellRenderer.this.isTilesView()) {
                Dimension bs = new Dimension(ns.width, ns.height);
                if (WebFileListCellRenderer.this.descriptionLabel.isVisible()) {
                    Dimension ds = WebFileListCellRenderer.this.descriptionLabel.getPreferredSize();
                    bs.width = Math.max(bs.width, ds.width);
                    bs.height += WebFileListCellRenderer.this.gap + ds.height;
                }
                if (WebFileListCellRenderer.this.sizeLabel.isVisible()) {
                    Dimension ss = WebFileListCellRenderer.this.sizeLabel.getPreferredSize();
                    bs.width = Math.max(bs.width, ss.width);
                    bs.height += WebFileListCellRenderer.this.gap + ss.height;
                }
                ps = new Dimension(i.left + is.width + WebFileListCellRenderer.this.gap + bs.width + i.right, i.top + Math.max(is.height, bs.height) + i.bottom);
            } else {
                ps = new Dimension(i.left + Math.max(is.width, ns.width) + i.right, i.top + is.height + WebFileListCellRenderer.this.gap + ns.height + i.bottom);
            }
            return ps;
        }

        @NotNull
        public Rectangle getDescriptionBounds() {
            Rectangle bounds;
            Dimension cellSize = WebFileListCellRenderer.this.getSize();
            Dimension iconSize = WebFileListCellRenderer.this.iconLabel.getPreferredSize();
            boolean ltr = WebFileListCellRenderer.this.fileList.getComponentOrientation().isLeftToRight();
            Insets i = WebFileListCellRenderer.this.getInsets();
            boolean tilesView = WebFileListCellRenderer.this.isTilesView();
            if (tilesView) {
                if (ltr) {
                    int x = i.left + iconSize.width + WebFileListCellRenderer.this.gap;
                    bounds = new Rectangle(x, i.top, cellSize.width - x - i.right, cellSize.height - i.top - i.bottom);
                } else {
                    bounds = new Rectangle(i.left, i.top, cellSize.width - WebFileListCellRenderer.this.gap - iconSize.width - i.right, cellSize.height - i.top - i.bottom);
                }
            } else {
                int ny = i.top + iconSize.height + WebFileListCellRenderer.this.gap;
                bounds = new Rectangle(i.left, ny, cellSize.width - i.left - i.right, cellSize.height - ny - i.bottom);
            }
            return bounds;
        }
    }
}

