/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.magnifier;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.extended.magnifier.MagnifierPosition;
import com.alee.extended.magnifier.MagnifierType;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.managers.language.LM;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.swing.WebTimer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;

public class MagnifierGlass
extends JComponent {
    protected static final ImageIcon cursorIcon = new ImageIcon(MagnifierGlass.class.getResource("icons/cursor.png"));
    protected static final DecimalFormat msFormat = new DecimalFormat("0.00");
    @NotNull
    protected Dimension size;
    @NotNull
    protected MagnifierType type;
    @NotNull
    protected MagnifierPosition position;
    protected int shadeWidth;
    protected int round;
    protected int zoomFactor;
    protected boolean displayDummyCursor;
    protected boolean displayTimeMetrics;
    protected float dummyCursorOpacity;
    protected long forceUpdateFrequency;
    protected transient JComponent zoomProvider;
    protected transient Cursor defaultCursor;
    protected transient BufferedImage buffer;
    protected transient Long time;
    protected transient BufferedImage view;
    protected transient Icon shadeIcon;
    protected transient int lastShadeWidth;
    protected transient boolean rendered;
    protected final transient AWTEventListener listener;
    protected final transient WebTimer forceUpdater;

    public MagnifierGlass() {
        this(4);
    }

    public MagnifierGlass(int zoomFactor) {
        this.setOpaque(false);
        this.setBackground(new Color(237, 237, 237));
        this.size = new Dimension(159, 159);
        this.type = MagnifierType.rectangular;
        this.position = MagnifierPosition.nearCursor;
        this.shadeWidth = 25;
        this.round = 10;
        this.zoomFactor = zoomFactor;
        this.displayDummyCursor = true;
        this.displayTimeMetrics = true;
        this.dummyCursorOpacity = 0.5f;
        this.forceUpdateFrequency = 100L;
        this.setEnabled(false);
        this.forceUpdater = new WebTimer(this.forceUpdateFrequency, new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                MagnifierGlass.this.updatePreview();
            }
        });
        this.forceUpdater.setUseEventDispatchThread(true);
        this.forceUpdater.setUseDaemonThread(true);
        this.forceUpdater.setRepeats(true);
        this.listener = new AWTEventListener(){

            @Override
            public void eventDispatched(@NotNull AWTEvent event) {
                if (MagnifierGlass.this.isEnabled()) {
                    CoreSwingUtils.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MagnifierGlass.this.updatePreview();
                            MagnifierGlass.this.restartForceUpdater();
                        }
                    });
                }
            }
        };
    }

    @NotNull
    public Dimension getZoomAreaSize() {
        return this.size;
    }

    public void setZoomAreaSize(@NotNull Dimension size) {
        if (Objects.notEquals((Object)this.size, (Object)size)) {
            this.size = size;
            this.updatePreview();
        }
    }

    @NotNull
    public MagnifierType getType() {
        return this.type;
    }

    public void setType(@NotNull MagnifierType type) {
        if (this.type != type) {
            this.type = type;
            this.updatePreview();
        }
    }

    @NotNull
    public MagnifierPosition getPosition() {
        return this.position;
    }

    public void setPosition(@NotNull MagnifierPosition position) {
        if (this.position != position) {
            if (position == MagnifierPosition.staticComponent) {
                this.disposeFromGlassPane();
            } else {
                this.displayOnGlassPane();
            }
            this.position = position;
            this.updatePreview();
        }
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        if (this.shadeWidth != shadeWidth) {
            this.shadeWidth = shadeWidth;
            this.updatePreview();
        }
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        if (this.round != round) {
            this.round = round;
            this.updatePreview();
        }
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int zoomFactor) {
        if (this.zoomFactor != zoomFactor) {
            this.zoomFactor = zoomFactor;
            this.updatePreview();
        }
    }

    public boolean isDisplayDummyCursor() {
        return this.displayDummyCursor;
    }

    public void setDisplayDummyCursor(boolean display) {
        if (this.displayDummyCursor != display) {
            this.displayDummyCursor = display;
            this.updatePreview();
        }
    }

    public boolean isDisplayTimeMetrics() {
        return this.displayTimeMetrics;
    }

    public void setDisplayTimeMetrics(boolean display) {
        if (this.displayTimeMetrics != display) {
            this.displayTimeMetrics = display;
            this.updatePreview();
        }
    }

    public float getDummyCursorOpacity() {
        return this.dummyCursorOpacity;
    }

    public void setDummyCursorOpacity(float opacity) {
        if (this.dummyCursorOpacity != opacity) {
            this.dummyCursorOpacity = opacity;
            this.updatePreview();
        }
    }

    public long getForceUpdateFrequency() {
        return this.forceUpdateFrequency;
    }

    public void setForceUpdateFrequency(long forceUpdateFrequency) {
        if (this.forceUpdateFrequency != forceUpdateFrequency) {
            this.forceUpdateFrequency = forceUpdateFrequency;
            this.restartForceUpdater();
        }
    }

    protected void restartForceUpdater() {
        if (this.isEnabled() && this.forceUpdateFrequency > 0L) {
            this.forceUpdater.setDelay(this.forceUpdateFrequency);
            this.forceUpdater.restart();
        } else {
            this.forceUpdater.stop();
        }
    }

    @NotNull
    protected Dimension getBufferSize() {
        return new Dimension(this.size.width / this.zoomFactor, this.size.height / this.zoomFactor);
    }

    protected void updatePreview() {
        if (this.isEnabled()) {
            WebGlassPane glassPane;
            Graphics2D g2d;
            Dimension bs = this.getBufferSize();
            if (this.buffer == null || this.buffer.getWidth() != bs.width || this.buffer.getHeight() != bs.height) {
                this.buffer = ImageUtils.createCompatibleImage(bs.width, bs.height, 1);
            }
            Point mp = CoreSwingUtils.getMouseLocation();
            Rectangle gb = CoreSwingUtils.getBoundsOnScreen(this.zoomProvider, false);
            if (gb.contains(mp)) {
                g2d = this.buffer.createGraphics();
                g2d.setBackground(Color.WHITE);
                g2d.clearRect(0, 0, bs.width, bs.height);
                g2d.setClip(0, 0, bs.width, bs.height);
                int x = mp.x - gb.x - bs.width / 2;
                int y = mp.y - gb.y - bs.height / 2;
                g2d.translate(-x, -y);
                this.time = System.nanoTime();
                this.zoomProvider.paintAll(g2d);
                this.time = System.nanoTime() - this.time;
                if (this.isDisplayDummyCursor()) {
                    g2d.translate(x, y);
                    GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(this.dummyCursorOpacity));
                    g2d.drawImage(cursorIcon.getImage(), bs.width / 2, bs.height / 2, null);
                }
                g2d.dispose();
                this.rendered = true;
            } else if (this.rendered) {
                g2d = this.buffer.createGraphics();
                g2d.setBackground(Color.WHITE);
                g2d.clearRect(0, 0, bs.width, bs.height);
                g2d.dispose();
                this.rendered = false;
            }
            if (this.position == MagnifierPosition.atCursor) {
                glassPane = GlassPaneManager.getGlassPane(this.zoomProvider);
                Point rel = CoreSwingUtils.getRelativeLocation(this.zoomProvider, glassPane);
                Dimension ps = this.getPreferredSize();
                int mx = mp.x - gb.x + rel.x - ps.width / 2;
                int my = mp.y - gb.y + rel.y - ps.height / 2;
                this.setBounds(mx, my, ps.width, ps.height);
            } else if (this.position == MagnifierPosition.nearCursor) {
                glassPane = GlassPaneManager.getGlassPane(this.zoomProvider);
                Rectangle bos = CoreSwingUtils.getBoundsOnScreen(glassPane, false);
                Point rmp = new Point(mp.x - bos.x, mp.y - bos.y);
                Dimension ps = this.getPreferredSize();
                int mx = rmp.x - ps.width / 2 < 0 ? 0 : (rmp.x + ps.width / 2 > bos.width ? bos.width - ps.width : rmp.x - ps.width / 2);
                int my = rmp.y + ps.height > bos.height && bos.height - rmp.y < rmp.y ? rmp.y - ps.height : rmp.y;
                this.setBounds(mx, my, ps.width, ps.height);
            }
            Cursor cursor = this.position == MagnifierPosition.atCursor ? SystemUtils.getTransparentCursor() : this.defaultCursor;
            CoreSwingUtils.getNonNullWindowAncestor(this.zoomProvider).setCursor(cursor);
            this.repaint();
        } else if (this.buffer != null) {
            CoreSwingUtils.getNonNullWindowAncestor(this.zoomProvider).setCursor(this.defaultCursor);
            this.buffer.flush();
            this.buffer = null;
        }
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (this.isEnabled() && this.rendered) {
            Icon icon;
            RectangularShape borderShape;
            RectangularShape fillShape;
            Graphics2D g2d = (Graphics2D)g;
            GraphicsUtils.setupAntialias(g2d);
            if (this.type == MagnifierType.rectangular) {
                fillShape = new RoundRectangle2D.Double(this.shadeWidth, this.shadeWidth, this.size.width, this.size.height, this.round, this.round);
                borderShape = new RoundRectangle2D.Double(this.shadeWidth, this.shadeWidth, this.size.width - 1, this.size.height - 1, this.round, this.round);
            } else {
                fillShape = new Ellipse2D.Double(this.shadeWidth, this.shadeWidth, this.size.width, this.size.height);
                borderShape = new Ellipse2D.Double(this.shadeWidth, this.shadeWidth, this.size.width - 1, this.size.height - 1);
            }
            g2d.setPaint(this.getBackground());
            g2d.fill(fillShape);
            Shape oldClip = GraphicsUtils.setupClip(g2d, fillShape, this.round > 0);
            g2d.drawImage(this.buffer, this.shadeWidth, this.shadeWidth, this.size.width, this.size.height, null);
            GraphicsUtils.restoreClip(g2d, oldClip, this.round > 0);
            if (this.isDisplayTimeMetrics()) {
                Map taa = SwingUtils.setupTextAntialias(g2d);
                g2d.setColor(Color.BLACK);
                double ms = (double)this.time.longValue() / 1000000.0;
                String text = msFormat.format(ms) + " " + LM.get("weblaf.time.units.short.millisecond", new Object[0]);
                int x = this.getComponentOrientation().isLeftToRight() ? this.shadeWidth + 5 : this.shadeWidth + this.size.width - g2d.getFontMetrics().stringWidth(text) - 5;
                int y = this.shadeWidth + this.size.height - 5;
                g2d.drawString(text, x, y);
                SwingUtils.restoreTextAntialias(g2d, taa);
            }
            if ((icon = this.getShadeIcon()) instanceof NinePatchIcon) {
                ((NinePatchIcon)icon).paintIcon(g2d, 0, 0, this.getWidth(), this.getHeight());
            } else {
                icon.paintIcon(this, g2d, 0, 0);
            }
            g2d.setPaint(Color.GRAY);
            g2d.draw(borderShape);
        }
    }

    @NotNull
    protected Icon getShadeIcon() {
        if (this.type == MagnifierType.rectangular) {
            if (this.shadeIcon == null || this.shadeWidth != this.lastShadeWidth || !(this.shadeIcon instanceof NinePatchIcon)) {
                this.shadeIcon = NinePatchUtils.createShadeIcon(this.shadeWidth, this.round, 0.75f);
                this.lastShadeWidth = this.shadeWidth;
            }
        } else if (this.shadeIcon == null || this.shadeWidth != this.lastShadeWidth || !(this.shadeIcon instanceof ImageIcon)) {
            Dimension ps = this.getPreferredSize();
            Ellipse2D.Double shape = new Ellipse2D.Double(this.shadeWidth, this.shadeWidth, this.size.width, this.size.height);
            this.shadeIcon = new ImageIcon(ImageUtils.createShadowImage(ps.width, ps.height, shape, this.shadeWidth, 0.75f, true));
            this.lastShadeWidth = this.shadeWidth;
        }
        return this.shadeIcon;
    }

    public void displayOrDispose(@NotNull Window window) {
        this.displayOrDispose(this.getZoomProvider(window));
    }

    public void displayOrDispose(@NotNull JComponent component2) {
        if (!this.isEnabled()) {
            this.display(component2);
        } else {
            this.dispose();
        }
    }

    public void display(@NotNull Window window) {
        this.display(this.getZoomProvider(window));
    }

    public void display(@NotNull JComponent component2) {
        WebLookAndFeel.checkEventDispatchThread();
        if (!component2.isShowing()) {
            throw new IllegalArgumentException("Provided component is not displayed on screen: " + component2);
        }
        this.setEnabled(true);
        this.zoomProvider = component2 instanceof JRootPane ? ((JRootPane)component2).getLayeredPane() : component2;
        this.defaultCursor = CoreSwingUtils.getNonNullWindowAncestor(this.zoomProvider).getCursor();
        this.updatePreview();
        this.displayOnGlassPane();
        this.restartForceUpdater();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 16L);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 32L);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 131072L);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 8L);
    }

    public void dispose() {
        WebLookAndFeel.checkEventDispatchThread();
        this.setEnabled(false);
        this.updatePreview();
        this.disposeFromGlassPane();
        this.restartForceUpdater();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
        this.zoomProvider = null;
        this.defaultCursor = null;
    }

    public boolean isDisplayed() {
        return this.isEnabled();
    }

    @NotNull
    protected JComponent getZoomProvider(@NotNull Window window) {
        JLayeredPane component2;
        if (window instanceof JWindow) {
            component2 = ((JWindow)window).getLayeredPane();
        } else if (window instanceof JDialog) {
            component2 = ((JDialog)window).getLayeredPane();
        } else if (window instanceof JFrame) {
            component2 = ((JFrame)window).getLayeredPane();
        } else {
            throw new IllegalArgumentException("Provided window must contain JLayeredPane");
        }
        return component2;
    }

    protected void displayOnGlassPane() {
        if (this.isEnabled()) {
            GlassPaneManager.getGlassPane(this.zoomProvider).showComponent(this);
        }
    }

    protected void disposeFromGlassPane() {
        if (this.isEnabled()) {
            GlassPaneManager.getGlassPane(this.zoomProvider).hideComponent(this);
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return this.isEnabled() ? new Dimension(this.size.width + this.shadeWidth * 2, this.size.height + this.shadeWidth * 2) : new Dimension(0, 0);
    }
}

