/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.memorybar;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.Orientation;
import com.alee.extended.WebComponent;
import com.alee.extended.memorybar.MemoryBarListener;
import com.alee.extended.memorybar.WMemoryBarUI;
import com.alee.managers.language.LM;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.FileUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.MemoryUsage;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;

public class WebMemoryBar
extends WebComponent<WebMemoryBar, WMemoryBarUI<WebMemoryBar>> {
    public static final String MODEL_PROPERTY = "model";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String DISPLAY_MAXIMUM_MEMORY_PROPERTY = "displayMaximumMemory";
    public static final String DISPLAY_TOOL_TIP_PROPERTY = "displayToolTip";
    public static final String REFRESH_RATE_PROPERTY = "refreshRate";
    protected final ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(@NotNull ActionEvent event) {
            WebMemoryBar.this.doGC();
        }
    };
    protected ButtonModel model;
    protected Orientation orientation;
    protected boolean displayMaximumMemory;
    protected boolean displayToolTip;
    protected long refreshRate;

    public WebMemoryBar() {
        this(StyleId.auto);
    }

    public WebMemoryBar(boolean gcEnabled) {
        this(StyleId.auto, gcEnabled);
    }

    public WebMemoryBar(@NotNull StyleId id) {
        this(id, true);
    }

    public WebMemoryBar(@NotNull StyleId id, boolean gcEnabled) {
        this.setModel(new DefaultButtonModel());
        this.setGCEnabled(gcEnabled);
        this.setOrientation(Orientation.horizontal);
        this.setDisplayMaximumMemory(false);
        this.setDisplayToolTip(true);
        this.setRefreshRate(1000L);
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.memorybar;
    }

    @NotNull
    public ButtonModel getModel() {
        return this.model;
    }

    public void setModel(@NotNull ButtonModel model) {
        if (this.model != model) {
            ButtonModel old = this.model;
            if (old != null) {
                old.removeActionListener(this.actionListener);
            }
            this.model = model;
            model.setEnabled(old == null || old.isEnabled());
            model.addActionListener(this.actionListener);
            this.firePropertyChange(MODEL_PROPERTY, old, model);
        }
    }

    public boolean isGCEnabled() {
        return this.getModel().isEnabled();
    }

    public void setGCEnabled(boolean enabled) {
        this.getModel().setEnabled(enabled);
    }

    @NotNull
    public Orientation getOrientation() {
        return this.orientation != null ? this.orientation : Orientation.horizontal;
    }

    public void setOrientation(@Nullable Orientation orientation) {
        if (this.orientation != orientation) {
            Orientation old = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange(ORIENTATION_PROPERTY, old, orientation);
        }
    }

    public boolean isMaximumMemoryDisplayed() {
        return this.displayMaximumMemory;
    }

    public void setDisplayMaximumMemory(boolean displayMaximumMemory) {
        if (this.displayMaximumMemory != displayMaximumMemory) {
            boolean old = this.displayMaximumMemory;
            this.displayMaximumMemory = displayMaximumMemory;
            this.firePropertyChange(DISPLAY_MAXIMUM_MEMORY_PROPERTY, old, displayMaximumMemory);
        }
    }

    public boolean isToolTipDisplayed() {
        return this.displayToolTip;
    }

    public void setDisplayToolTip(boolean displayToolTip) {
        if (this.displayToolTip != displayToolTip) {
            boolean old = this.displayToolTip;
            this.displayToolTip = displayToolTip;
            this.firePropertyChange(DISPLAY_TOOL_TIP_PROPERTY, old, displayToolTip);
        }
    }

    public long getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(long refreshRate) {
        if (this.refreshRate != refreshRate) {
            long old = this.refreshRate;
            this.refreshRate = refreshRate;
            this.firePropertyChange(REFRESH_RATE_PROPERTY, old, refreshRate);
        }
    }

    @NotNull
    public MemoryUsage getMemoryUsage() {
        return this.getUI().getMemoryUsage();
    }

    @NotNull
    public String getText() {
        return LM.get(this.getTextKey(), this.getTextData(this.getMemoryUsage()));
    }

    @NotNull
    protected String getTextKey() {
        return "weblaf.ex.memorybar.text";
    }

    @NotNull
    protected Object[] getTextData(@NotNull MemoryUsage memoryUsage) {
        return new Object[]{this.getMemorySizeString(memoryUsage.getUsed()), this.getMemorySizeString(this.isMaximumMemoryDisplayed() ? memoryUsage.getMax() : memoryUsage.getCommitted())};
    }

    @NotNull
    protected String getToolTipKey() {
        return "weblaf.ex.memorybar.tooltip";
    }

    @NotNull
    protected Object[] getToolTipData(@NotNull MemoryUsage memoryUsage) {
        return new Object[]{this.getMemorySizeString(memoryUsage.getCommitted()), this.getMemorySizeString(memoryUsage.getUsed()), this.getMemorySizeString(memoryUsage.getMax())};
    }

    @NotNull
    protected String getMemorySizeString(long used) {
        return FileUtils.getFileSizeString(used, this.getDigits(used));
    }

    protected int getDigits(long size) {
        return size < 0x40000000L ? 0 : 2;
    }

    public void doGC() {
        this.fireGCCalled();
        System.gc();
        this.getUI().updateMemoryUsage();
        this.fireGCCompleted();
        this.fireActionPerformed();
    }

    public void addActionListener(@NotNull ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(@NotNull ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void fireActionPerformed() {
        ActionEvent event = null;
        for (ActionListener listener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            if (event == null) {
                event = new ActionEvent(this, 1001, this.getModel().getActionCommand(), System.currentTimeMillis(), CoreSwingUtils.getCurrentEventModifiers());
            }
            listener.actionPerformed(event);
        }
    }

    public void addMemoryBarListener(@NotNull MemoryBarListener listener) {
        this.listenerList.add(MemoryBarListener.class, listener);
    }

    public void removeMemoryBarListener(@NotNull MemoryBarListener listener) {
        this.listenerList.remove(MemoryBarListener.class, listener);
    }

    public void fireGCCalled() {
        for (MemoryBarListener listener : (MemoryBarListener[])this.listenerList.getListeners(MemoryBarListener.class)) {
            listener.gcCalled(this);
        }
    }

    public void fireGCCompleted() {
        for (MemoryBarListener listener : (MemoryBarListener[])this.listenerList.getListeners(MemoryBarListener.class)) {
            listener.gcCompleted(this);
        }
    }

    @Override
    public WMemoryBarUI getUI() {
        return (WMemoryBarUI)this.ui;
    }

    public void setUI(WMemoryBarUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

